/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.cloudcolla.adjsalfile.handler;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.AdjSalFileCollaHelper;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.handler.CollaAdjSalFileFlowOutHandler;
import kd.swc.hcdm.business.cloudcolla.adjsalfile.handler.ICollaAdjSalFileHandler;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CollaAdjSalFileFlowInHandler
implements ICollaAdjSalFileHandler {
    private static final Log log = LogFactory.getLog(CollaAdjSalFileFlowOutHandler.class);

    public static final CollaAdjSalFileFlowInHandler getInstance() {
        return Load.INSTANCE;
    }

    @Override
    public Map<String, List<DynamicObject>> assembleData(DynamicObject adjSalFile, Map<String, List<DynamicObject>> fieldMapResult, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData) {
        Map<String, Object> taskCenterMap = AdjSalFileCollaHelper.getTaskCenterMap(commonParams, null, "hcdm", null);
        if (taskCenterMap == null || taskCenterMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollaAdjSalFileFlowInHandler_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        log.info("[colla]CollaAdjSalFileFlowInHandler assembleData taskCenterMap is {}", taskCenterMap);
        AdjSalFileCollaHelper.fillAdjSalFile(adjSalFile, taskCenterMap);
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        Boolean isAddFile = MapUtils.getBoolean(ruleEngineData, (Object)"hcdm_adjfileinfo_isinputnewfile", (Boolean)Boolean.FALSE);
        if (isAddFile.booleanValue()) {
            this.dealWithAddFile(adjSalFile, taskCenterMap, commonParams, ruleEngineData, result);
        } else {
            this.dealWithUpdateFile(adjSalFile, taskCenterMap, commonParams, ruleEngineData, result);
        }
        log.info("[colla]CollaAdjSalFileFlowInHandler assembleData end, AdjSalFile is {}", (Object)adjSalFile);
        return result;
    }

    private void dealWithAddFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, Map<String, List<DynamicObject>> result) {
        this.dealWithFlowOutFile(taskCenterMap, commonParams, ruleEngineData, result);
        AdjSalFileCollaHelper.createAdjSalFile(adjSalFile, taskCenterMap, commonParams, result);
    }

    private void dealWithUpdateFile(DynamicObject adjSalFile, Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, Map<String, List<DynamicObject>> result) {
        Object[] sameEmpFileArr = AdjSalFileCollaHelper.getSameEmployeeFiles(adjSalFile, taskCenterMap);
        if (SWCArrayUtils.isEmpty((Object[])sameEmpFileArr)) {
            this.dealWithFlowOutFile(taskCenterMap, commonParams, ruleEngineData, result);
            AdjSalFileCollaHelper.createAdjSalFile(adjSalFile, taskCenterMap, commonParams, result);
        } else {
            if (sameEmpFileArr.length > 1) {
                sameEmpFileArr = AdjSalFileCollaHelper.filterLoseEffectFile((DynamicObject[])sameEmpFileArr, taskCenterMap);
            }
            Object sameEmpFile = sameEmpFileArr[0];
            AdjSalFileCollaHelper.dealWithSameEmpFile((DynamicObject)sameEmpFile, adjSalFile, taskCenterMap, commonParams, result);
        }
    }

    private void dealWithFlowOutFile(Map<String, Object> taskCenterMap, Map<String, Object> commonParams, Map<String, Object> ruleEngineData, Map<String, List<DynamicObject>> result) {
        Long orgMsgRecvCenterId = MapUtils.getLong(taskCenterMap, (Object)"msgSubId");
        Map<String, Object> outTaskCenterMap = AdjSalFileCollaHelper.getTaskCenterMap(commonParams, "2", "hcdm", orgMsgRecvCenterId);
        if (CollectionUtils.isEmpty(outTaskCenterMap)) {
            log.info("[colla]CollaAdjSalFileFlowInHandler getOutTaskFileByInputTask outTaskCenterMap == null.");
            return;
        }
        DynamicObject flowOutFile = AdjSalFileCollaHelper.getFileByTask(outTaskCenterMap, commonParams, false);
        if (SWCObjectUtils.isEmpty((Object)flowOutFile)) {
            return;
        }
        DynamicObject person = AdjSalFileCollaHelper.getPersonById(commonParams, MapUtils.getLong(outTaskCenterMap, (Object)"personId"));
        DynamicObject depEmp = AdjSalFileCollaHelper.getDepEmpById(commonParams, MapUtils.getLong(outTaskCenterMap, (Object)"depEmpId"));
        String personName = null;
        String personNumber = null;
        if (!SWCObjectUtils.isEmpty((Object)person)) {
            personName = person.getString("name");
            personNumber = person.getString("number");
        }
        String depEmpNum = SWCObjectUtils.isEmpty((Object)depEmp) ? flowOutFile.getString("depemp.number") : depEmp.getString("number");
        String status = flowOutFile.getString("status");
        if (StringUtils.equals((CharSequence)status, (CharSequence)"A") || StringUtils.equals((CharSequence)status, (CharSequence)"B")) {
            log.info("[colla]CollaAdjSalFileFlowInHandler dealWithFlowOutFile end, AdjSalFile status is SAVE/SUBMIT ...");
            throw new KDBizException(ResManager.loadKDString((String)"{0}({1})\u7684\u5b9a\u8c03\u85aa\u6863\u6848({2})\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"AdjSalFileCollaHelper_4", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, flowOutFile.getString("number")}));
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"D")) {
            List dynamicObjects = result.computeIfAbsent("DO_NOTHING", item -> new ArrayList(10));
            dynamicObjects.add(flowOutFile);
            return;
        }
        String flowOutBsledString = MapUtils.getString(ruleEngineData, (Object)"hcdm_adjfileinfo_flowoutbsled");
        Date flowOutBsled = null;
        if (!SWCStringUtils.isEmpty((String)flowOutBsledString)) {
            try {
                flowOutBsled = SWCDateTimeUtils.parseDate((String)flowOutBsledString);
            }
            catch (ParseException ex) {
                log.info("[colla] parse date error, date = {}", (Object)flowOutBsledString);
                throw new KDBizException((Throwable)ex, new ErrorCode("dealSameEmployeeFile", ex.getMessage()), new Object[0]);
            }
        }
        if (null != flowOutBsled) {
            flowOutFile.set("bsled", (Object)flowOutBsled);
            List dynamicObjects = result.computeIfAbsent("DISABLE", item -> new ArrayList(10));
            dynamicObjects.add(flowOutFile);
            return;
        }
        Long chgEventId = AdjSalFileCollaHelper.getChgEvent(commonParams);
        log.info("[colla]CollaAdjSalFileFlowInHandler dealWithFlowOutFile chgEventId{}", (Object)chgEventId);
        if (chgEventId != 1050L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u53d8\u52a8\u524d\u6863\u6848\u5931\u6548\u65e5\u671f\u201d\u4e3a\u7a7a\uff0c{0}({1})\u7684\u5c97\u4f4d({2}\uff09\u7684\u6863\u6848{3}\u5931\u6548\u5931\u8d25\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"CollaAdjSalFileFlowOutHandler_2", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, depEmpNum, flowOutFile.getString("number")}));
        }
        CollaRuleExecuteContext executeInfo = (CollaRuleExecuteContext)commonParams.get("executeInfo");
        executeInfo.getWarnMsgs().add(ResManager.loadKDString((String)"\u201c\u53d8\u52a8\u524d\u6863\u6848\u5931\u6548\u65e5\u671f\u201d\u4e3a\u7a7a\uff0c{0}({1})\u7684\u5c97\u4f4d({2}\uff09\u7684\u6863\u6848{3}\u4e0d\u5904\u7406\u3002", (String)"CollaAdjSalFileFlowInHandler_6", (String)"swc-hcdm-business", (Object[])new Object[]{personName, personNumber, depEmpNum, flowOutFile.getString("number")}));
        List dynamicObjects = result.computeIfAbsent("DO_NOTHING", item -> new ArrayList(10));
        dynamicObjects.add(flowOutFile);
    }

    private static class Load {
        private static final CollaAdjSalFileFlowInHandler INSTANCE = new CollaAdjSalFileFlowInHandler();

        private Load() {
        }
    }
}

