/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.coefficient;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CoefficientTabServiceHelper {
    public static DynamicObject[] getDataByDimension(String dimension, QFilter orgFilter) {
        String selectFields = "id,name";
        String orderBys = "createtime desc";
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_coefficienttab");
        QFilter queryFilter = new QFilter("dimension", "=", (Object)dimension);
        queryFilter.and(new QFilter("enable", "=", (Object)"1"));
        queryFilter.and(new QFilter("status", "=", (Object)"C"));
        if (orgFilter != null) {
            queryFilter.and(orgFilter);
        }
        return serviceHelper.query(selectFields, new QFilter[]{queryFilter}, orderBys);
    }

    public static String getStatusErrorMsgByPkId(String tableId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_coefficienttab");
        DynamicObject coeffTable = serviceHelper.queryOriginalOne("status,enable", (Object)Long.valueOf(tableId));
        String status = coeffTable.getString("status");
        String enable = coeffTable.getString("enable");
        return CoefficientTabServiceHelper.getErrorStatusMsg(status, enable);
    }

    private static String getErrorStatusMsg(String status, String enable) {
        boolean isAudit = SWCStringUtils.equalsIgnoreCase((String)status, (String)"C");
        boolean isEnable = SWCStringUtils.equalsIgnoreCase((String)enable, (String)"1");
        if (!isAudit || !isEnable) {
            return ResManager.loadKDString((String)"\u53ea\u53ef\u5bf9\u201c\u85aa\u916c\u6807\u51c6\u7cfb\u6570\u8868\u201d\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u4f7f\u7528\u72b6\u6001\u4e3a\u542f\u7528\u7684\u6570\u636e\u8fdb\u884c\u8df3\u8f6c\u3002", (String)"CoefficientTabServiceHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static DynamicObjectCollection queryCoefTabByIds(Set<Long> tableIdSet) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_coefficienttab");
        QFilter idFilter = new QFilter("id", "in", tableIdSet);
        return serviceHelper.queryOriginalCollection("id,status,enable", new QFilter[]{idFilter});
    }

    public static DynamicObjectCollection queryCoefTabByNumbers(Set<String> numbers, QFilter orgFilter) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_coefficienttab");
        QFilter queryFilter = new QFilter("number", "in", numbers);
        queryFilter.and(new QFilter("enable", "=", (Object)"1"));
        queryFilter.and(new QFilter("status", "=", (Object)"C"));
        if (orgFilter != null) {
            queryFilter.and(orgFilter);
        }
        return serviceHelper.queryOriginalCollection("number,dimension", new QFilter[]{queryFilter});
    }

    public static Map<Long, List<DynamicObject>> queryCoefficientByTabId(Set<Long> tableIdSet) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_coefficient");
        QFilter queryFilter = new QFilter("coefficienttab", "in", tableIdSet);
        Object[] dynamicObjects = serviceHelper.query("id,coefficienttab,coefficienttab.id,admindivision,admindivision.id", new QFilter[]{queryFilter});
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            return Arrays.asList(dynamicObjects).stream().collect(Collectors.groupingBy(o1 -> o1.getLong("coefficienttab.id")));
        }
        return null;
    }
}

