/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.converter;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.swc.hcdm.business.converter.Converter;
import kd.swc.hsbp.business.imports.ValidateResults;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class DecimalConverter
implements Converter {
    private String dataScope;
    private int precision;
    private int scale;

    public DecimalConverter() {
    }

    public DecimalConverter(String dataScope, int precision, int scale) {
        this.dataScope = dataScope;
        this.precision = precision;
        this.scale = scale;
    }

    public void setDataScope(String dataScope) {
        this.dataScope = dataScope;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDataScope() {
        return this.dataScope;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public ValidateResults checkType(Object val) {
        boolean checkPassed = this.checkBaseNumberType(val.getClass());
        if (!checkPassed && val instanceof Number) {
            checkPassed = true;
        }
        if (!checkPassed && val instanceof String) {
            checkPassed = NumberUtils.isNumber((String)((String)val));
        }
        ValidateResults result = new ValidateResults(ErrorLevel.Error);
        if (!checkPassed) {
            result.addErrorMsgs((Collection)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u6570\u636e\u662f\u6570\u5b57\u7c7b\u578b\u3002", (String)"DecimalConverter_0", (String)"swc-hcdm-business", (Object[])new Object[0])}));
        }
        return result;
    }

    @Override
    public ValidateResults checkVal(Object val) {
        return this.checkVal(val, false);
    }

    public ValidateResults checkVal(Object val, boolean ignoreScaleCheck) {
        ValidateResults typeResult = this.checkType(val);
        if (!typeResult.isSuccess()) {
            return typeResult;
        }
        BigDecimal convertVal = this.convert(val);
        boolean checkPassed = true;
        String errorMsg = null;
        int precision = convertVal.precision();
        int scale = convertVal.scale();
        int integerBit = this.precision - this.scale;
        if (!this.isInDataScope(convertVal)) {
            checkPassed = false;
            errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u503c\u5728{0}\u8303\u56f4\u5185\u7684\u6570\u636e\u3002", (String)"DecimalConverter_3", (String)"swc-hcdm-business", (Object[])new Object[0]), this.parseScopeValue());
            BigDecimal minScope = this.minScope();
            boolean minScopeMark = this.minScopeMark();
            boolean maxScopeMark = this.maxScopeMark();
            if (this.maxScope() == null && minScope != null && convertVal.compareTo(minScope) < 0) {
                String leftMarkStr = minScopeMark ? "<" : "<=";
                String rightMarkStr = minScopeMark ? ">=" : ">";
                errorMsg = ResManager.loadKDString((String)"\u5b58\u5728{0}{1}\u7684\u503c\uff0c\u8bf7\u586b\u5199{2}{3}\u7684\u503c\u3002", (String)"DecimalConverter_4", (String)"swc-hcdm-business", (Object[])new Object[]{leftMarkStr, minScope, rightMarkStr, minScope});
            }
        } else if (scale > this.scale) {
            if (!ignoreScaleCheck) {
                checkPassed = false;
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u5c0f\u6570\u4f4d\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6{0}\u4f4d\uff0c\u8bf7\u786e\u4fdd\u4e0d\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\u3002", (String)"DecimalConverter_2", (String)"swc-hcdm-business", (Object[])new Object[0]), this.scale);
            }
        } else if (precision - scale > integerBit) {
            checkPassed = false;
            errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6{0}\u4f4d\uff0c\u8bf7\u786e\u4fdd\u957f\u5ea6\u4e0d\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\u3002", (String)"DecimalConverter_1", (String)"swc-hcdm-business", (Object[])new Object[0]), integerBit);
        }
        ValidateResults result = new ValidateResults(ErrorLevel.Error);
        if (!checkPassed) {
            result.addErrorMsgs((Collection)Lists.newArrayList((Object[])new String[]{errorMsg}));
        }
        return result;
    }

    private String parseScopeValue() {
        BigDecimal maxScope = this.maxScope();
        BigDecimal minScope = this.minScope();
        boolean maxScopeMark = this.maxScopeMark();
        boolean minScopeMark = this.minScopeMark();
        String left = minScopeMark ? "[" : "(";
        String right = maxScopeMark ? "]" : ")";
        String leftVal = minScope == null ? "-\u221e" : minScope.toString();
        String rightVal = maxScope == null ? "+\u221e" : maxScope.toString();
        return left + leftVal + "," + rightVal + right;
    }

    @Override
    public BigDecimal convert(Object val) {
        if (this.checkBaseNumberType(val.getClass())) {
            return this.convertFromBaseNumberType(val);
        }
        if (val instanceof String && NumberUtils.isNumber((String)((String)val))) {
            return new BigDecimal((String)val);
        }
        return null;
    }

    boolean isInDataScope(BigDecimal val) {
        if (StringUtils.isEmpty((String)this.dataScope)) {
            return true;
        }
        BigDecimal maxScope = this.maxScope();
        BigDecimal minScope = this.minScope();
        boolean maxScopeMark = this.maxScopeMark();
        boolean minScopeMark = this.minScopeMark();
        boolean result = true;
        if (maxScope != null) {
            if (maxScopeMark) {
                result = val.compareTo(maxScope) <= 0;
            } else {
                boolean bl = result = val.compareTo(maxScope) < 0;
            }
        }
        if (result && minScope != null) {
            result = minScopeMark ? val.compareTo(minScope) >= 0 : val.compareTo(minScope) > 0;
        }
        return result;
    }

    private boolean checkBaseNumberType(Class<?> className) {
        return className.equals(Integer.class) || className.equals(Integer.TYPE) || className.equals(Byte.class) || className.equals(Byte.TYPE) || className.equals(Long.class) || className.equals(Long.TYPE) || className.equals(Double.class) || className.equals(Double.TYPE) || className.equals(Float.class) || className.equals(Float.TYPE) || className.equals(Short.class) || className.equals(Short.TYPE);
    }

    private BigDecimal convertFromBaseNumberType(Object val) {
        Class<?> className = val.getClass();
        if (className.equals(Integer.class) || className.equals(Integer.TYPE)) {
            return new BigDecimal((Integer)val);
        }
        if (className.equals(Byte.class) || className.equals(Byte.TYPE)) {
            return new BigDecimal(((Byte)val).intValue());
        }
        if (className.equals(Long.class) || className.equals(Long.TYPE)) {
            return new BigDecimal((Long)val);
        }
        if (className.equals(Double.class) || className.equals(Double.TYPE)) {
            return new BigDecimal(val.toString());
        }
        if (className.equals(Float.class) || className.equals(Float.TYPE)) {
            return new BigDecimal(val.toString());
        }
        if (className.equals(Short.class) || className.equals(Short.TYPE)) {
            return new BigDecimal(((Short)val).shortValue());
        }
        return null;
    }

    private BigDecimal maxScope() {
        String scope = StringUtils.substringAfter((String)this.dataScope, (String)",");
        if (StringUtils.isBlank((String)scope)) {
            return null;
        }
        String maxValStr = scope.substring(0, scope.length() - 1);
        return StringUtils.isEmpty((String)maxValStr) ? null : new BigDecimal(maxValStr);
    }

    private BigDecimal minScope() {
        String scope = StringUtils.substringBefore((String)this.dataScope, (String)",");
        if (StringUtils.isBlank((String)scope)) {
            return null;
        }
        String minValStr = scope.substring(1);
        return StringUtils.isEmpty((String)minValStr) ? null : new BigDecimal(minValStr);
    }

    private boolean maxScopeMark() {
        return StringUtils.isNotEmpty((String)this.dataScope) && this.dataScope.endsWith("]");
    }

    private boolean minScopeMark() {
        return StringUtils.isNotEmpty((String)this.dataScope) && this.dataScope.startsWith("[");
    }
}

