/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.country;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.country.CountryPolicy;
import kd.swc.hcdm.business.country.CountryRefChanged;
import kd.swc.hcdm.business.country.CountryRefInfo;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CountryHelper {
    private CountryHelper() {
    }

    public static void registerListenerForBaseData(AbstractFormPlugin plugin, Collection<String> baseDataFields) {
        if (CollectionUtils.isEmpty(baseDataFields) || !(plugin instanceof BeforeF7SelectListener) && !(plugin instanceof AfterF7SelectListener)) {
            return;
        }
        for (String baseDataField : baseDataFields) {
            BasedataEdit basedataEdit = (BasedataEdit)plugin.getView().getControl(baseDataField);
            if (basedataEdit == null || !(plugin instanceof BeforeF7SelectListener)) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)plugin);
        }
    }

    public static void afterBindDataForCountry(AbstractFormPlugin plugin) {
        if (plugin == null || plugin.getView() == null) {
            return;
        }
        String entityId = plugin.getView().getEntityId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (properties.containsKey((Object)"areatype") && properties.containsKey((Object)"country")) {
            CountryHelper.setCountryVisibleAndMustInput(plugin, plugin.getView().getModel().getDataEntity(true).getString("areatype"));
        }
    }

    public static void propertyChangedForCountry(AbstractFormPlugin plugin, PropertyChangedArgs propertyChangedArgs, CountryPolicy countryPolicy) {
        if (propertyChangedArgs == null || ArrayUtils.isEmpty((Object[])propertyChangedArgs.getChangeSet()) || propertyChangedArgs.getChangeSet()[0] == null || !countryPolicy.getMsgMap().containsKey(propertyChangedArgs.getProperty().getName())) {
            return;
        }
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        DynamicObject dataEntity = plugin.getView().getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        String fieldKey = propertyChangedArgs.getProperty().getName();
        if ("areatype".equals(fieldKey)) {
            String oldAreaType = (String)propertyChangedArgs.getChangeSet()[0].getOldValue();
            String newAreaType = (String)propertyChangedArgs.getChangeSet()[0].getNewValue();
            if ("2".equals(oldAreaType) && "1".equals(newAreaType)) {
                StringJoiner errMsgs;
                if (countryPolicy.isDelAfterConfirm() && (errMsgs = CountryHelper.checkRefFieldChanged(plugin, true)).length() > 0) {
                    plugin.getView().showConfirm(countryPolicy.getMsg(fieldKey).getMsg(), errMsgs.toString(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("areatype"), null, oldAreaType);
                    return;
                }
                CountryHelper.setCountryVisibleAndMustInput(plugin, (String)propertyChangedArgs.getChangeSet()[0].getNewValue());
                CountryHelper.needClearFieldRefCountry(plugin, countryPolicy.getClearPolicies());
            } else {
                CountryHelper.setCountryVisibleAndMustInput(plugin, (String)propertyChangedArgs.getChangeSet()[0].getNewValue());
            }
        } else if ("country".equals(fieldKey)) {
            boolean countryIsEmpty;
            DynamicObject countryDy = (DynamicObject)changeSet[0].getNewValue();
            boolean bl = countryIsEmpty = countryDy == null || Long.valueOf(0L).equals(countryDy.getPkValue());
            if (countryIsEmpty && properties.containsKey((Object)"areatype") && "1".equals(dataEntity.getString("areatype"))) {
                return;
            }
            CountryHelper.clearInfoIfCountryChanged(plugin, changeSet[0], fieldKey, countryPolicy);
        }
    }

    public static void confirmCallBackForCountry(AbstractFormPlugin plugin, MessageBoxClosedEvent event, CountryPolicy countryPolicy) {
        if (countryPolicy == null || CollectionUtils.isEmpty(countryPolicy.getClearPolicies()) || !countryPolicy.getMsgMap().containsKey(event.getCallBackId())) {
            return;
        }
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            long countryId;
            String oldVal = "areatype".equals(event.getCallBackId()) ? event.getCustomVaule() : (SWCStringUtils.isEmpty((String)event.getCustomVaule()) || (countryId = Long.parseLong(event.getCustomVaule())) == 0L ? null : Long.valueOf(countryId));
            IDataModel model = plugin.getView().getModel();
            model.beginInit();
            model.setValue(event.getCallBackId(), (Object)oldVal);
            model.endInit();
            plugin.getView().updateView(event.getCallBackId());
        } else {
            if ("areatype".equals(event.getCallBackId())) {
                CountryHelper.setCountryVisibleAndMustInput(plugin, plugin.getView().getModel().getDataEntity(true).getString("areatype"));
            }
            CountryHelper.needClearFieldRefCountry(plugin, countryPolicy.getClearPolicies());
        }
    }

    public static void beforeF7SelectForCountry(AbstractFormPlugin plugin, BeforeF7SelectEvent args, Collection<String> fieldKeysRefCountry) {
        if (plugin == null || args == null || CollectionUtils.isEmpty(fieldKeysRefCountry) || !fieldKeysRefCountry.contains(args.getProperty().getName()) || !(args.getProperty() instanceof MulBasedataProp) && !(args.getProperty() instanceof BasedataProp)) {
            return;
        }
        boolean isInvalid = CountryHelper.checkInvalidAndSetFilter(plugin, (IMetadata)args.getProperty(), null, args.getCustomQFilters(), true);
        if (isInvalid) {
            args.setCancel(true);
        }
    }

    public static boolean checkInvalidAndSetFilter(AbstractFormPlugin plugin, IMetadata currIMetadata, String entityName, List<QFilter> customQFilters, boolean needShowError) {
        DynamicObject dataEntity;
        IMetadata iMetadata;
        Object object = iMetadata = currIMetadata != null ? currIMetadata : EntityMetadataCache.getDataEntityType((String)entityName);
        if (plugin != null && iMetadata != null && customQFilters != null && CountryHelper.checkInvalidAndSetFilter(dataEntity = plugin.getView().getModel().getDataEntity(true), iMetadata, null, customQFilters)) {
            if (needShowError) {
                HCDMErrInfoEnum hcdmErrInfoEnum = dataEntity.getDynamicObjectType().getProperties().containsKey((Object)"areatype") && SWCStringUtils.isEmpty((String)dataEntity.getString("areatype")) ? HCDMErrInfoEnum.COMMON_AREA_TYPE_NOT_EXISTS : HCDMErrInfoEnum.COMMON_COUNTRY_NOT_EXISTS;
                plugin.getView().showTipNotification(hcdmErrInfoEnum.getMsg());
            }
            return true;
        }
        return false;
    }

    public static boolean checkInvalidAndSetFilter(DynamicObject dataEntity, IMetadata currIMetadata, String entityName, List<QFilter> customQFilters) {
        IMetadata iMetadata;
        Object object = iMetadata = currIMetadata != null ? currIMetadata : EntityMetadataCache.getDataEntityType((String)entityName);
        if (dataEntity == null || iMetadata == null || customQFilters == null) {
            return true;
        }
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        boolean containAreaType = properties.containsKey((Object)"areatype");
        long countryId = dataEntity.getLong("country.id");
        if (containAreaType && !AreaHelper.checkArea((DynamicObject)dataEntity) || !containAreaType && countryId == 0L) {
            return true;
        }
        boolean isGeneral = containAreaType && "1".equals(dataEntity.getString("areatype"));
        countryId = isGeneral ? 0L : countryId;
        QFilter countryFilter = CountryHelper.getCountryFilter(iMetadata, countryId);
        if (countryFilter != null) {
            customQFilters.add(countryFilter);
        }
        return false;
    }

    private static QFilter getCountryFilter(IMetadata iMetadata, long countryId) {
        DataEntityPropertyCollection properties = null;
        if (iMetadata instanceof MulBasedataProp) {
            properties = ((MulBasedataProp)iMetadata).getComplexType().getProperties();
        } else if (iMetadata instanceof BasedataProp) {
            properties = ((BasedataProp)iMetadata).getComplexType().getProperties();
        } else if (iMetadata instanceof MainEntityType) {
            properties = ((MainEntityType)iMetadata).getProperties();
        } else {
            return null;
        }
        return CountryHelper.getCountryFilter(countryId, properties);
    }

    private static QFilter getCountryFilter(long countryId, DataEntityPropertyCollection properties) {
        List<Long> countryIds = properties.containsKey((Object)"areatype") ? Sets.newHashSet((Object[])new Long[]{0L, countryId}) : Collections.singletonList(countryId);
        return new QFilter("country.id", "in", countryIds);
    }

    private static void setCountryVisibleAndMustInput(AbstractFormPlugin plugin, String areaType) {
        boolean isAssign = "2".equals(areaType);
        CountryHelper.setFieldMustInput(plugin, isAssign, "country");
        plugin.getView().setEnable(Boolean.valueOf(isAssign), new String[]{"country"});
        if (!isAssign) {
            IDataModel model = plugin.getView().getModel();
            model.beginInit();
            model.setValue("country", null);
            model.endInit();
            plugin.getView().updateView("country");
        }
    }

    private static void needClearFieldRefCountry(AbstractFormPlugin plugin, List<CountryPolicy.ClearPolicy> clearPolicies) {
        boolean unNeedCheck = CollectionUtils.isEmpty(clearPolicies);
        if (unNeedCheck) {
            return;
        }
        CountryRefInfo countryRefInfo = null;
        IFormView formView = plugin.getView();
        IDataModel model = formView.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        long countryId = dataEntity.getLong("country.id");
        for (CountryPolicy.ClearPolicy clearPolicy : clearPolicies) {
            if (clearPolicy.isDoCustom()) {
                CountryHelper.invokeCustomOp(plugin, clearPolicy);
                continue;
            }
            CountryRefInfo countryRefInfo2 = countryRefInfo = countryRefInfo != null ? countryRefInfo : CountryRefInfo.getCountryRefInfo(dataEntity.getDataEntityType().getProperties());
            if (countryRefInfo == null) {
                return;
            }
            String needClearFieldKey = clearPolicy.getFieldKey();
            if (countryRefInfo.getProperties().containsKey((Object)needClearFieldKey)) {
                CountryHelper.setValueAndUpdate(plugin, clearPolicy, null, null, null, dataEntity, countryId);
                continue;
            }
            if (countryRefInfo.getFieldAndEntityNameMap().get(needClearFieldKey) != null) {
                DynamicObjectCollection entryEntity = model.getEntryEntity(countryRefInfo.getFieldAndEntityNameMap().get(needClearFieldKey));
                if (!CollectionUtils.isEmpty((Collection)entryEntity) && clearPolicy.getClearPolicyEnum() == CountryPolicy.ClearDataPolicyEnum.COMMON_DELETE_ENTITY_REFERENCE) {
                    boolean doneSuccessfully = CountryHelper.clearEntity(entryEntity, clearPolicy, countryId);
                    if (!doneSuccessfully) continue;
                    formView.updateView(countryRefInfo.getFieldAndEntityNameMap().get(needClearFieldKey));
                    continue;
                }
                for (int i = 0; i < entryEntity.size(); ++i) {
                    CountryHelper.setValueAndUpdate(plugin, clearPolicy, null, i, null, (DynamicObject)entryEntity.get(i), countryId);
                }
                continue;
            }
            if (!countryRefInfo.getFieldAndSubEntityNameTable().rowKeySet().contains(needClearFieldKey)) continue;
            Map entityAndSubEntityName = (Map)countryRefInfo.getFieldAndSubEntityNameTable().rowMap().get(needClearFieldKey);
            for (Map.Entry entityAndSubEntityNameEntry : entityAndSubEntityName.entrySet()) {
                DynamicObjectCollection entryEntity = model.getEntryEntity((String)entityAndSubEntityNameEntry.getKey());
                for (int seq = 0; seq < entryEntity.size(); ++seq) {
                    DynamicObjectCollection subEntryEntity = ((DynamicObject)entryEntity.get(seq)).getDynamicObjectCollection((String)entityAndSubEntityNameEntry.getValue());
                    if (!subEntryEntity.isEmpty() && clearPolicy.getClearPolicyEnum() == CountryPolicy.ClearDataPolicyEnum.COMMON_DELETE_ENTITY_REFERENCE) {
                        subEntryEntity.clear();
                        formView.updateView((String)entityAndSubEntityNameEntry.getValue());
                        continue;
                    }
                    for (int subSeq = 0; subSeq < subEntryEntity.size(); ++subSeq) {
                        CountryHelper.setValueAndUpdate(plugin, clearPolicy, null, seq, subSeq, (DynamicObject)subEntryEntity.get(subSeq), countryId);
                    }
                }
            }
        }
    }

    private static boolean clearEntity(DynamicObjectCollection entryEntity, CountryPolicy.ClearPolicy clearPolicy, long changedCountryId) {
        boolean doneSuccessfully = false;
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            String fieldName;
            String string = fieldName = clearPolicy == null ? "fbasedataid" : clearPolicy.getFieldKey();
            DynamicObject baseDy = ((DynamicObject)iterator.next()).getDynamicObject(fieldName);
            if (!CountryHelper.isCountryChanged(baseDy, changedCountryId, false)) continue;
            doneSuccessfully = true;
            iterator.remove();
        }
        return doneSuccessfully;
    }

    private static void invokeCustomOp(AbstractFormPlugin plugin, CountryPolicy.ClearPolicy clearPolicy) {
        if (plugin instanceof CountryRefChanged) {
            CountryRefChanged countryRefChanged = (CountryRefChanged)plugin;
            countryRefChanged.clearCountryRefData();
        }
    }

    private static void setValueAndUpdate(AbstractFormPlugin plugin, CountryPolicy.ClearPolicy clearPolicy, Object val, Integer seq, Integer subSeq, DynamicObject dataEntry, long changedCountryId) {
        boolean needNotClear;
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dataEntry.getDataEntityType().getProperties().get((Object)clearPolicy.getFieldKey());
        boolean bl = needNotClear = iDataEntityProperty instanceof BasedataProp && dataEntry.getLong(clearPolicy.getFieldKey() + ".id") == 0L || iDataEntityProperty instanceof MulBasedataProp && CollectionUtils.isEmpty((Collection)dataEntry.getDynamicObjectCollection(clearPolicy.getFieldKey())) || dataEntry.get(clearPolicy.getFieldKey()) == null;
        if (iDataEntityProperty instanceof BasedataProp) {
            DynamicObject baseDataDy = dataEntry.getDynamicObject(clearPolicy.getFieldKey());
            needNotClear = needNotClear || !CountryHelper.isCountryChanged(baseDataDy, changedCountryId, false);
        } else if (iDataEntityProperty instanceof MulBasedataProp) {
            DynamicObjectCollection mulDyColl = dataEntry.getDynamicObjectCollection(clearPolicy.getFieldKey());
            boolean bl2 = needNotClear = needNotClear || !CountryHelper.clearEntity(mulDyColl, null, changedCountryId);
            if (!needNotClear) {
                val = mulDyColl;
            }
        } else {
            needNotClear = true;
        }
        if (needNotClear) {
            return;
        }
        IFormView formView = plugin.getView();
        IDataModel model = formView.getModel();
        if (clearPolicy.isNeedLock()) {
            model.beginInit();
        }
        if (seq != null && subSeq != null) {
            model.setValue(clearPolicy.getFieldKey(), val, seq.intValue(), subSeq.intValue());
        } else if (seq != null && subSeq == null) {
            model.setValue(clearPolicy.getFieldKey(), val, seq.intValue());
        } else if (seq == null && subSeq == null) {
            model.setValue(clearPolicy.getFieldKey(), val);
        }
        if (clearPolicy.isNeedLock()) {
            model.endInit();
        }
        if (seq != null && subSeq != null) {
            formView.updateView(clearPolicy.getFieldKey(), seq.intValue(), subSeq.intValue());
        } else if (seq != null && subSeq == null) {
            formView.updateView(clearPolicy.getFieldKey(), seq.intValue());
        } else if (seq == null && subSeq == null) {
            formView.updateView(clearPolicy.getFieldKey());
        }
    }

    private static void setFieldMustInput(AbstractFormPlugin plugin, boolean mustInput, String ... keys) {
        for (String key : keys) {
            FieldEdit fieldEdit = (FieldEdit)plugin.getControl(key);
            fieldEdit.setMustInput(mustInput);
            fieldEdit.setVisible(key, mustInput);
        }
    }

    private static DataEntityPropertyCollection getProperties(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        return model.getDataEntity(true).getDynamicObjectType().getProperties();
    }

    private static void clearInfoIfCountryChanged(AbstractFormPlugin plugin, ChangeData changeData, String fieldKey, CountryPolicy countryPolicy) {
        DynamicObject oldCountryDyObj = (DynamicObject)changeData.getOldValue();
        DynamicObject newCountryDyObj = (DynamicObject)changeData.getNewValue();
        if (oldCountryDyObj == null || oldCountryDyObj.getLong("id") == 0L || newCountryDyObj == null || newCountryDyObj.getLong("id") != oldCountryDyObj.getLong("id")) {
            StringJoiner errMsgs;
            if (!(oldCountryDyObj != null && oldCountryDyObj.getLong("id") != 0L || newCountryDyObj != null && newCountryDyObj.getLong("id") != 0L)) {
                return;
            }
            if (countryPolicy.isDelAfterConfirm() && (errMsgs = CountryHelper.checkRefFieldChanged(plugin, false)).length() > 0) {
                String oldCountryId = oldCountryDyObj == null ? "0" : oldCountryDyObj.getString("id");
                plugin.getView().showConfirm(countryPolicy.getMsg(fieldKey).getMsg(), errMsgs.toString(), MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("country"), null, oldCountryId);
            } else {
                CountryHelper.needClearFieldRefCountry(plugin, countryPolicy.getClearPolicies());
            }
        }
    }

    private static StringJoiner checkRefFieldChanged(AbstractFormPlugin plugin, boolean isGeneral) {
        if (plugin instanceof CountryRefChanged) {
            CountryRefChanged countryRefChanged = (CountryRefChanged)plugin;
            return countryRefChanged.getChangedInfoOfRefField(isGeneral);
        }
        return new StringJoiner("\n");
    }

    public static StringJoiner validate(DynamicObject dataEntity) {
        StringJoiner errMandatoryField = new StringJoiner(HCDMErrInfoEnum.COMMON_STOP_SIGN.getMsg());
        if (dataEntity == null) {
            return errMandatoryField;
        }
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        IDataEntityProperty areaProp = (IDataEntityProperty)properties.get((Object)"areatype");
        IDataEntityProperty countryProp = (IDataEntityProperty)properties.get((Object)"country");
        String areaType = null;
        if (areaProp != null && SWCStringUtils.isEmpty((String)(areaType = dataEntity.getString("areatype")))) {
            errMandatoryField.add(areaProp.getDisplayName().getLocaleValue());
        }
        if (countryProp != null) {
            long countryId = dataEntity.getLong("country.id");
            if ((areaProp == null || "2".equals(areaType)) && countryId == 0L) {
                errMandatoryField.add(countryProp.getDisplayName().getLocaleValue());
            }
        }
        return errMandatoryField;
    }

    public static boolean isCountryChanged(DynamicObject baseDataDy, long countryId, boolean refChanged) {
        if (baseDataDy != null && baseDataDy.getLong("id") != 0L) {
            long countryIdOfBaseProp;
            DataEntityPropertyCollection properties = baseDataDy.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)"country")) {
                return false;
            }
            if (properties.containsKey((Object)"areatype")) {
                String areaType = baseDataDy.getString("areatype");
                if (!SWCStringUtils.isEmpty((String)areaType) && refChanged) {
                    return true;
                }
                if ("1".equals(areaType)) {
                    return false;
                }
            }
            return (countryIdOfBaseProp = baseDataDy.getLong("country.id")) != 0L && (refChanged || countryIdOfBaseProp != countryId);
        }
        return false;
    }

    public static IFormView getSubPageView(String pageId) {
        SessionManager sm = SessionManager.getCurrent();
        sm.setRequestThread(true);
        return sm.getView(pageId);
    }

    public static Map<HCDMErrInfoEnum, StringJoiner> getSortLinkedMap(Collection<HCDMErrInfoEnum> hcdmErrInfoEnums) {
        if (CollectionUtils.isEmpty(hcdmErrInfoEnums)) {
            return new LinkedHashMap<HCDMErrInfoEnum, StringJoiner>(0);
        }
        return hcdmErrInfoEnums.stream().collect(Collectors.toMap(key -> key, val -> new StringJoiner(HCDMErrInfoEnum.COMMON_STOP_SIGN.getMsg()), (oldVal, newVal) -> oldVal, LinkedHashMap::new));
    }

    public static boolean setErrMsgMap(long countryIdInMainTable, Map<HCDMErrInfoEnum, StringJoiner> errMsgMap, DynamicObject baseDataDy, boolean refChanged, HCDMErrInfoEnum hcdmErrInfoEnum) {
        if (errMsgMap == null || baseDataDy == null || hcdmErrInfoEnum == null) {
            return false;
        }
        boolean countryChanged = CountryHelper.isCountryChanged(baseDataDy, countryIdInMainTable, refChanged);
        if (countryChanged) {
            errMsgMap.computeIfAbsent(hcdmErrInfoEnum, key -> new StringJoiner(HCDMErrInfoEnum.COMMON_STOP_SIGN.getMsg())).add(baseDataDy.getString("name"));
            return true;
        }
        return false;
    }

    public static StringJoiner getErrMsg(Map<HCDMErrInfoEnum, StringJoiner> errMsgMap) {
        StringJoiner errMsgSj = new StringJoiner("\n");
        errMsgMap.forEach((key, val) -> {
            if (val != null && val.length() > 0) {
                errMsgSj.add(HCDMErrInfoEnum.COMMON_COUNTRY_CHANGED_MODEL.getMsg(new Object[]{key.getMsg(), val.toString()}));
            }
        });
        return errMsgSj;
    }
}

