/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.country;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.swc.hcdm.common.enums.HCDMErrInfoEnum;

public class CountryPolicy {
    private List<ClearPolicy> clearPolicies;
    private boolean delAfterConfirm;
    private Map<String, HCDMErrInfoEnum> msgMap;

    private CountryPolicy(Builder builder) {
        this.delAfterConfirm = builder.delAfterConfirm;
        this.msgMap = builder.msgMap;
        this.clearPolicies = builder.clearPolicies;
    }

    public static Builder createInstance() {
        return new Builder();
    }

    public List<ClearPolicy> getClearPolicies() {
        if (this.clearPolicies == null) {
            return new ArrayList<ClearPolicy>(0);
        }
        return this.clearPolicies;
    }

    public void setClearPolicies(List<ClearPolicy> clearPolicies) {
        this.clearPolicies = clearPolicies;
    }

    public boolean isDelAfterConfirm() {
        return this.delAfterConfirm;
    }

    public void setDelAfterConfirm(boolean delAfterConfirm) {
        this.delAfterConfirm = delAfterConfirm;
    }

    public Map<String, HCDMErrInfoEnum> getMsgMap() {
        return this.msgMap;
    }

    public HCDMErrInfoEnum getMsg(String key) {
        if (this.msgMap != null) {
            return this.msgMap.get(key);
        }
        return null;
    }

    public void setMsgMap(Map<String, HCDMErrInfoEnum> msgMap) {
        this.msgMap = msgMap;
    }

    public static class ClearPolicy {
        private String fieldKey;
        private ClearDataPolicyEnum clearPolicyEnum;
        private boolean needLock = true;
        private boolean doCustom = false;

        public ClearPolicy(String fieldKey, ClearDataPolicyEnum clearPolicyEnum, boolean needLock, boolean doCustom) {
            this.fieldKey = fieldKey;
            this.clearPolicyEnum = clearPolicyEnum;
            if (clearPolicyEnum == null) {
                this.clearPolicyEnum = ClearDataPolicyEnum.DELETE_DATA_ONLY;
            }
            this.needLock = needLock;
            this.doCustom = doCustom;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public ClearDataPolicyEnum getClearPolicyEnum() {
            return this.clearPolicyEnum;
        }

        public boolean isNeedLock() {
            return this.needLock;
        }

        public boolean isDoCustom() {
            return this.doCustom;
        }

        public void setDoCustom(boolean doCustom) {
            this.doCustom = doCustom;
        }
    }

    public static enum ClearDataPolicyEnum {
        DELETE_DATA_ONLY(HCDMErrInfoEnum.COMMON_DELETE_DATA_ONLY),
        COMMON_DELETE_ENTITY_REFERENCE(HCDMErrInfoEnum.COMMON_DELETE_ENTITY_REFERENCE);

        HCDMErrInfoEnum hcdmErrInfoEnum;

        private ClearDataPolicyEnum(HCDMErrInfoEnum hcdmErrInfoEnum) {
            this.hcdmErrInfoEnum = hcdmErrInfoEnum;
        }
    }

    public static class Builder {
        private List<ClearPolicy> clearPolicies;
        private boolean delAfterConfirm = false;
        private Map<String, HCDMErrInfoEnum> msgMap;

        public Builder() {
            this.clearPolicies = new ArrayList<ClearPolicy>(10);
            this.msgMap = new HashMap<String, HCDMErrInfoEnum>(4);
        }

        public Builder(List<ClearPolicy> clearPolicies, boolean delAfterConfirm, Map<String, HCDMErrInfoEnum> msgMap) {
            this.clearPolicies = clearPolicies;
            if (clearPolicies == null) {
                this.clearPolicies = new ArrayList<ClearPolicy>(10);
            }
            this.delAfterConfirm = delAfterConfirm;
            this.msgMap = msgMap;
            if (msgMap == null) {
                this.msgMap = new HashMap<String, HCDMErrInfoEnum>(4);
            }
        }

        public Builder delAfterConfirm(boolean delAfterConfirm) {
            this.delAfterConfirm = delAfterConfirm;
            return this;
        }

        public Builder msgMap(Map<String, HCDMErrInfoEnum> msgMap) {
            this.msgMap = msgMap;
            return this;
        }

        public Builder putErrorInfoEnum(String fieldKey, HCDMErrInfoEnum hcdmErrInfoEnum) {
            if (this.msgMap == null) {
                this.msgMap = new HashMap<String, HCDMErrInfoEnum>(4);
            }
            this.msgMap.put(fieldKey, hcdmErrInfoEnum);
            return this;
        }

        public Builder putClearPolicy(String fieldKey, ClearDataPolicyEnum clearPolicyEnum, boolean needLock) {
            this.putClearPolicy(fieldKey, clearPolicyEnum, needLock, false);
            return this;
        }

        public Builder putClearPolicy(String fieldKey, ClearDataPolicyEnum clearPolicyEnum, boolean needLock, boolean doCustom) {
            if (this.clearPolicies == null) {
                this.clearPolicies = new ArrayList<ClearPolicy>(10);
            }
            this.clearPolicies.add(new ClearPolicy(fieldKey, clearPolicyEnum, needLock, doCustom));
            return this;
        }

        public Builder putClearPolicy(String fieldKey, ClearDataPolicyEnum clearPolicyEnum) {
            return this.putClearPolicy(fieldKey, clearPolicyEnum, true);
        }

        public Builder putClearPolicy(String fieldKey, boolean doCustom) {
            return this.putClearPolicy(fieldKey, null, false, doCustom);
        }

        public CountryPolicy build() {
            return new CountryPolicy(this);
        }
    }
}

