/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.decadjrecord;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.DecAdjSalaryEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.SalaryAdjRecordRelPersonDynEntity;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdRangeNameFormatParam;
import kd.sdk.swc.hcdm.common.stdtab.StdTabNotFoundType;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.AdjBillEntryImpHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.adjfieldcfg.AdjDetailFieldMappingHelper;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.imports.perm.AdjFilePermissionHandler;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjfile.DecAdjSalaryEvent;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DecAdjRecordHRImportHelper {
    private static final Log logger = LogFactory.getLog(DecAdjRecordHRImportHelper.class);
    private static final String adjfileInfoProp = "id,boid,employee,employee.empnumber,employee.id,status,iscurrentversion,datastatus,number,bsed,bsled";

    public static QFilter[] getAdjFilePermissionFilter() {
        AdjFilePermissionHandler adjFilePermissionHandler = new AdjFilePermissionHandler();
        return adjFilePermissionHandler.getPermissionFilter();
    }

    public static void dataValidate(Set<String> employeeNumbers, ImportLog importLog, Set<String> adjFileNum, List<ImportBillData> list, Map<String, Object> baseDataMap) {
        long startTime = System.currentTimeMillis();
        HashMap<Long, String> salaryadjrsnToType = new HashMap<Long, String>(list.size());
        DecAdjRecordHRImportHelper.fileValidate(employeeNumbers, importLog, adjFileNum, list, baseDataMap, salaryadjrsnToType);
        logger.info("fileValidate user time:{}", (Object)(System.currentTimeMillis() - startTime));
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        startTime = System.currentTimeMillis();
        DecAdjRecordHRImportHelper.fileVersionConfirm(importLog, list, baseDataMap, adjFileApplicationService);
        logger.info("fileVersionConfirm user time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        DecAdjRecordHRImportHelper.validateAfterDeterFile(list, baseDataMap, importLog, adjFileApplicationService, salaryadjrsnToType);
        logger.info("validateAfterDeterFile user time:{}", (Object)(System.currentTimeMillis() - startTime));
        if (ObjectUtils.isNotEmpty((Object)baseDataMap.get("salaryadjfile.number"))) {
            Map deterFileMap = (Map)baseDataMap.get("salaryadjfile.number");
            for (Map.Entry entry : deterFileMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof DynamicObject)) continue;
                entry.setValue(((DynamicObject)value).getLong("id"));
            }
            baseDataMap.put("salaryadjfile.number", SerializationUtils.serializeToBase64((Object)deterFileMap));
        }
    }

    public static void fileValidate(Set<String> employeeNumbers, ImportLog importLog, Set<String> adjFileNum, List<ImportBillData> list, Map<String, Object> baseDataMap, Map<Long, String> salaryadjrsnToType) {
        Object[] salarySrn;
        HashMap<Integer, Object> baseFileMap = new HashMap<Integer, Object>(16);
        baseDataMap.put("salaryadjfile.number", baseFileMap);
        long startTime = System.currentTimeMillis();
        Object[] filePermFilter = DecAdjRecordHRImportHelper.getAdjFilePermissionFilter();
        logger.info("getAdjFilePermissionFilter user time:{}", (Object)(System.currentTimeMillis() - startTime));
        logger.info("filePermFilter is:{}", (Object)JSON.toJSONString((Object)filePermFilter));
        startTime = System.currentTimeMillis();
        DynamicObject[] employeeDyns = AdjBillEntryImpHelper.getEmployeeByEmpnumber(employeeNumbers);
        logger.info("getEmployeeByEmpnumber user time:{}", (Object)(System.currentTimeMillis() - startTime));
        Set<Long> employeeIds = Arrays.stream(employeeDyns).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        startTime = System.currentTimeMillis();
        DynamicObject[] adjFileLists = DecAdjRecordHRImportHelper.getAdjFileList(null, employeeIds, null);
        logger.info("getAdjFileList with employeeIds noperm user time:{}", (Object)(System.currentTimeMillis() - startTime));
        Map<String, List<DynamicObject>> noPerAdjFileForEmpMap = Arrays.stream(adjFileLists).filter(obj -> StringUtils.isNotBlank((CharSequence)obj.getString("employee.empnumber"))).collect(Collectors.groupingBy(adjFile -> adjFile.getString("employee.empnumber")));
        startTime = System.currentTimeMillis();
        DynamicObject[] adjFileAuthorList = ArrayUtils.isNotEmpty((Object[])filePermFilter) ? DecAdjRecordHRImportHelper.getAdjFileList(null, employeeIds, (QFilter[])filePermFilter) : adjFileLists;
        logger.info("getAdjFileList with employeeIds perm user time:{}", (Object)(System.currentTimeMillis() - startTime));
        Map<String, List<DynamicObject>> perAdjFileForEmpMap = Arrays.stream(adjFileAuthorList).filter(obj -> StringUtils.isNotBlank((CharSequence)obj.getString("employee.empnumber"))).collect(Collectors.groupingBy(adjFile -> adjFile.getString("employee.empnumber")));
        startTime = System.currentTimeMillis();
        DynamicObject[] noPerFileDyns = DecAdjRecordHRImportHelper.getAdjFileList(adjFileNum, null, null);
        logger.info("getAdjFileList with adjFileNum noperm user time:{}", (Object)(System.currentTimeMillis() - startTime));
        Map<String, List<DynamicObject>> noperFileMap = Arrays.stream(noPerFileDyns).filter(adjFile -> StringUtils.isNotBlank((CharSequence)adjFile.getString("number"))).collect(Collectors.groupingBy(adjFile -> adjFile.getString("number")));
        startTime = System.currentTimeMillis();
        DynamicObject[] adjFileDyns = ArrayUtils.isNotEmpty((Object[])filePermFilter) ? DecAdjRecordHRImportHelper.getAdjFileList(adjFileNum, null, (QFilter[])filePermFilter) : noPerFileDyns;
        logger.info("getAdjFileList with adjFileNum perm user time:{}", (Object)(System.currentTimeMillis() - startTime));
        Map<String, List<DynamicObject>> perFileMap = Arrays.stream(adjFileDyns).filter(adjFile -> StringUtils.isNotBlank((CharSequence)adjFile.getString("number"))).collect(Collectors.groupingBy(adjFile -> adjFile.getString("number")));
        HashSet salaryadjrsnIds = Sets.newHashSetWithExpectedSize((int)16);
        Date sysMaxDate = SWCBaseUtils.getMaxLoseEffectDate();
        Date sysMinDate = SWCBaseUtils.getMinEffectDate();
        for (ImportBillData billData : list) {
            JSONObject jsonObject = billData.getData();
            JSONObject jsonFile = jsonObject.getJSONObject("hcdm_adjfileinfo");
            JSONArray jsonRecord = jsonObject.getJSONArray("hcdm_salaryadjrecord");
            String empnumber = jsonFile.getJSONObject("employee").getString("empnumber");
            for (int i = 0; i < jsonRecord.size(); ++i) {
                Object excBsled;
                Object excBsed;
                JSONObject salaryadjrsn;
                JSONObject record = (JSONObject)jsonRecord.get(i);
                Integer rowIndex = record.getInteger("$excelIndex");
                DecAdjRecordHRImportHelper.adjBillNoValidate(importLog, noPerAdjFileForEmpMap, perAdjFileForEmpMap, noperFileMap, perFileMap, baseFileMap, billData, empnumber, record);
                if (ObjectUtils.isNotEmpty((Object)record.get((Object)"salaryadjrsn")) && (salaryadjrsn = record.getJSONObject("salaryadjrsn")).containsKey((Object)"id")) {
                    salaryadjrsnIds.add(salaryadjrsn.getLong("id"));
                }
                if (ObjectUtils.isNotEmpty((Object)(excBsed = record.get((Object)"bsed"))) && excBsed instanceof Date) {
                    if (((Date)excBsed).after(sysMaxDate)) {
                        DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u9700\u586b\u5199\u65e9\u4e8e\u6216\u7b49\u4e8e2999.12.31\u7684\u65e5\u671f\u3002", (String)"DecAdjRecordHRImportHelper_50", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                    }
                    if (((Date)excBsed).before(sysMinDate)) {
                        DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u9700\u586b\u5199\u665a\u4e8e\u6216\u7b49\u4e8e1900.01.01\u7684\u65e5\u671f\u3002", (String)"DecAdjRecordHRImportHelper_51", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                    }
                }
                if (!ObjectUtils.isNotEmpty((Object)(excBsled = record.get((Object)"bsled"))) || !(excBsled instanceof Date)) continue;
                if (((Date)excBsled).after(sysMaxDate)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u9700\u586b\u5199\u65e9\u4e8e\u6216\u7b49\u4e8e2999.12.31\u7684\u65e5\u671f\u3002", (String)"DecAdjRecordHRImportHelper_52", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                }
                if (!((Date)excBsled).before(sysMinDate)) continue;
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u9700\u586b\u5199\u665a\u4e8e\u6216\u7b49\u4e8e1900.01.01\u7684\u65e5\u671f\u3002", (String)"DecAdjRecordHRImportHelper_53", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)salaryadjrsnIds) && ArrayUtils.isNotEmpty((Object[])(salarySrn = DecAdjRecordHRImportHelper.querySalaryadjustrsn(salaryadjrsnIds)))) {
            Arrays.stream(salarySrn).forEach(obj -> salaryadjrsnToType.put(obj.getLong("id"), obj.getString("attributiontype")));
        }
    }

    public static void fileVersionConfirm(ImportLog importLog, List<ImportBillData> list, Map<String, Object> baseDataMap, AdjFileApplicationService adjFileApplicationService) {
        if (ObjectUtils.isEmpty((Object)baseDataMap.get("salaryadjfile.number"))) {
            return;
        }
        HashMap<Integer, Object> baseFileMap = (HashMap<Integer, Object>)baseDataMap.get("salaryadjfile.number");
        ArrayList fileMatchParams = Lists.newArrayListWithExpectedSize((int)baseFileMap.size());
        DecAdjRecordHRImportHelper.assembleFileParams("package", importLog, list, (Map<Integer, Object>)baseFileMap, fileMatchParams, null);
        if (CollectionUtils.isNotEmpty((Collection)fileMatchParams)) {
            long startTime = System.currentTimeMillis();
            String selectFiles = "id,boid,depemp.id,employee.id,salaystructure.id,salaystructure.name,adminorg.id,position.id,employee.empnumber,person.name,bsed,org.id,country.id,stdscm.id,enable,bsled";
            Map<String, AdjfileMatchResult> matchResultMap = adjFileApplicationService.batchMatchEffectiveAdjfileVersion(fileMatchParams, selectFiles);
            logger.info("batchMatchEffectiveAdjfileVersion use time:{}", (Object)(System.currentTimeMillis() - startTime));
            if (org.apache.commons.collections4.MapUtils.isNotEmpty(matchResultMap)) {
                DecAdjRecordHRImportHelper.assembleFileParams("unpackage", importLog, list, baseFileMap, null, matchResultMap);
            } else {
                logger.info("matchResultMap is empty !!!");
                baseFileMap = new HashMap(16);
            }
        } else {
            logger.info(" fileMatchParams is empty !!!");
            baseFileMap = new HashMap<Integer, Object>(16);
        }
        baseDataMap.put("salaryadjfile.number", baseFileMap);
    }

    private static void assembleFileParams(String type, ImportLog importLog, List<ImportBillData> list, Map<Integer, Object> baseFileMap, List<AdjFileMatchParam> fileMatchParams, Map<String, AdjfileMatchResult> matchResultMap) {
        String bsledMustBigbsed = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u5931\u6548\u65e5\u671f\uff08{0}\uff09\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\uff08{1}\uff09\u3002", (String)"DecAdjRecordHRImportHelper_25", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashSet<String> standarditemSet = new HashSet<String>(16);
        for (ImportBillData billData : list) {
            JSONArray jsonRecord = billData.getData().getJSONArray("hcdm_salaryadjrecord");
            for (int i = 0; i < jsonRecord.size(); ++i) {
                AdjfileMatchResult adjfileMatchResult;
                Object bsedOjb;
                JSONObject record = (JSONObject)jsonRecord.get(i);
                JSONObject item = record.getJSONObject("standarditem");
                Integer rowIndex = record.getInteger("$excelIndex");
                if (ObjectUtils.isEmpty((Object)item) || !item.containsKey((Object)"id") || !ObjectUtils.isNotEmpty((Object)baseFileMap.get(rowIndex)) || (bsedOjb = record.get((Object)"bsed")) == null || !(bsedOjb instanceof Date)) continue;
                Date bsed = (Date)bsedOjb;
                Long boid = (Long)baseFileMap.get(rowIndex);
                Long itemId = item.getLong("id");
                Object bsledObj = record.get((Object)"bsled");
                if (bsledObj != null && !(bsledObj instanceof Date)) continue;
                Date bsled = SWCBaseUtils.getMaxLoseEffectDate();
                if (bsledObj != null && bsed.after(bsled = (Date)bsledObj)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(bsledMustBigbsed, SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd")), rowIndex, importLog, billData);
                    continue;
                }
                String unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(boid), String.valueOf(itemId), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
                logger.info(" boid:{},itemid:{},bsed:{},bsled:{},unionId:{}", new Object[]{boid, itemId, bsed, bsled, unionId});
                if (type.equals("package")) {
                    if (standarditemSet.contains(unionId)) {
                        DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_13", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                        continue;
                    }
                    AdjFileMatchParam fileMatchParam = new AdjFileMatchParam();
                    fileMatchParam.setAdjFileBoId(boid);
                    fileMatchParam.setBsed(bsed);
                    fileMatchParam.setBsled(bsled);
                    fileMatchParam.setUnionId(unionId);
                    fileMatchParams.add(fileMatchParam);
                    standarditemSet.add(unionId);
                    continue;
                }
                if (!type.equals("unpackage") || null == (adjfileMatchResult = matchResultMap.get(unionId))) continue;
                DynamicObject adjfileVersion = adjfileMatchResult.getAdjfileVersion();
                if (null == adjfileVersion) {
                    DecAdjRecordHRImportHelper.writeErrorLog(adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString(), rowIndex, importLog, billData);
                    continue;
                }
                baseFileMap.put(rowIndex, adjfileVersion);
            }
        }
    }

    public static void validateAfterDeterFile(List<ImportBillData> list, Map<String, Object> baseDataMap, ImportLog importLog, AdjFileApplicationService adjFileApplicationService, Map<Long, String> salaryadjrsnToType) {
        if (org.apache.commons.collections4.MapUtils.isEmpty(baseDataMap) || ObjectUtils.isEmpty((Object)baseDataMap.get("salaryadjfile.number"))) {
            return;
        }
        Map deterFileMap = (Map)baseDataMap.get("salaryadjfile.number");
        HashSet<Long> depEmpIds = new HashSet<Long>(deterFileMap.size());
        HashSet<Long> employeeIds = new HashSet<Long>(deterFileMap.size());
        deterFileMap.values().stream().forEach(obj -> {
            if (obj instanceof DynamicObject) {
                DynamicObject fileObj = (DynamicObject)obj;
                depEmpIds.add(fileObj.getLong("depemp.id"));
                employeeIds.add(fileObj.getLong("employee.id"));
            }
        });
        HashSet matchParams = Sets.newHashSetWithExpectedSize((int)16);
        HashSet frequencyNames = Sets.newHashSetWithExpectedSize((int)16);
        HashSet decFileBoids = Sets.newHashSetWithExpectedSize((int)16);
        HashMap adjFileBoidToItemMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet decAdjFileBoidIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet<Long> structIds = new HashSet<Long>(16);
        DecAdjRecordHRImportHelper.extractParams(list, deterFileMap, frequencyNames, decFileBoids, adjFileBoidToItemMap, salaryadjrsnToType, matchParams, decAdjFileBoidIds, structIds);
        HashMap<Integer, Object> gradeBaseMap = new HashMap<Integer, Object>(16);
        HashMap<Integer, Object> rankBaseMap = new HashMap<Integer, Object>(16);
        HashMap<Integer, DynamicObject> frequencyBaseMap = new HashMap<Integer, DynamicObject>(16);
        HashMap<Integer, Object> jobLevelGradeBaseMap = new HashMap<Integer, Object>(16);
        baseDataMap.put("frequency.name", frequencyBaseMap);
        baseDataMap.put("joblevel.grade.name", jobLevelGradeBaseMap);
        Map<Object, Object> nameToFrequencyMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty((Collection)frequencyNames)) {
            DynamicObject[] frerDyns = AdjBillEntryImpHelper.getFrequencyByName(frequencyNames);
            nameToFrequencyMap = Arrays.stream(frerDyns).collect(Collectors.groupingBy(obj -> obj.getString("name")));
        }
        Map<Long, List<DynamicObject>> jobLevelGradeMap = DecAdjRecordHRImportHelper.queryEmpjobrel(employeeIds);
        long startTime = System.currentTimeMillis();
        Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap = AdjBillEntryImpHelper.getMatchStdResult(Lists.newArrayList((Iterable)matchParams));
        logger.info("AdjBillEntryImpHelper.getMatchStdResult use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<String, Map<Long, DynamicObject>> tableAndCoeffObjs = DecAdjRecordHRImportHelper.getStdTableAndCoeff(resultMap);
        logger.info("DecAdjRecordHRImportHelper.getStdTableAndCoeff use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<String, Map<Long, String>> rankAndGradeNameMaps = DecAdjRecordHRImportHelper.getGradeAndRankById(resultMap);
        logger.info("getGradeAndRankById use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Long, Map<Long, Boolean>> openRankMap = AdjBillEntryImpHelper.getUseRankFlag(resultMap);
        logger.info("getUseRankFlag use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Long, Set<String>> candSet = CommonHcdmBizHelper.getCandSetSalApplidInTransitMap(depEmpIds);
        logger.info("getCandSetSalApplidInTransitMap use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Long, Set<String>> adjBillMap = CommonHcdmBizHelper.getInvalidAdjBillByDepEmpId(depEmpIds);
        logger.info("getInvalidAdjBillByDepEmpId use time:{}", (Object)(System.currentTimeMillis() - startTime));
        HashMap<Long, List<DynamicObject>> initMap = new HashMap<Long, List<DynamicObject>>(16);
        try {
            startTime = System.currentTimeMillis();
            initMap.putAll(CommonHcdmBizHelper.getInvalidAdjRecordByAdjFileId(decAdjFileBoidIds));
            logger.info("getInvalidAdjRecordByAdjFileId use time:{}", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception ex) {
            logger.error("CommonHcdmBizHelper.getInvalidAdjRecordByAdjFileId error:", (Throwable)ex);
        }
        logger.info("depEmpIds:{},candSet:{},initMap:{}", (Object)JSON.toJSONString(depEmpIds), (Object)JSON.toJSONString(candSet));
        DynamicObject[] structObjs = AdjBillEntryImpHelper.getSalayStructure(structIds);
        Map<Long, Set> structIdToItemIdMap = Arrays.stream(structObjs).collect(Collectors.toMap(key -> key.getLong("id"), dy -> dy.getDynamicObjectCollection("entryentity").stream().map(obj -> obj.getLong("standarditem.id")).collect(Collectors.toSet())));
        startTime = System.currentTimeMillis();
        Map<Long, Date> decRecMaxDateMap = adjFileApplicationService.getMaxBsedOfRecordForDecType(decFileBoids);
        logger.info("getMaxBsedOfRecordForDecType use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Long, Map<Long, Date>> adjRecMaxDateMap = adjFileApplicationService.getMaxBsedOfRecordForAdjType(adjFileBoidToItemMap);
        logger.info("getMaxBsedOfRecordForAdjType use time:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        Map<Long, Boolean> checkResult = adjFileApplicationService.checkEmpposorgrelAvailable(decAdjFileBoidIds);
        logger.info("checkEmpposorgrelAvailable use time:{}", (Object)(System.currentTimeMillis() - startTime));
        String candBillExist = ResManager.loadKDString((String)"\u5458\u5de5\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u5019\u9009\u4eba\u5b9a\u85aa\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a{0}\uff09\uff0c\u65e0\u6cd5\u5bfc\u5165\u5b9a\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordHRImportHelper_45", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String adjBillExist = ResManager.loadKDString((String)"\u5458\u5de5\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a{0}\uff09\uff0c\u65e0\u6cd5\u5bfc\u5165\u5b9a\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordHRImportHelper_46", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String initExit = ResManager.loadKDString((String)"\u5458\u5de5\u5b58\u5728\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u521d\u59cb\u5316\u6570\u636e\uff0c\u65e0\u6cd5\u5bfc\u5165\u5b9a\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordHRImportHelper_47", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String jrsnRepeat = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4e0b\u5b58\u5728\u4e0d\u540c\u7684\u5b9a\u8c03\u85aa\u7c7b\u578b\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_12", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String itemRepeat = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_13", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String empopoAbandon = ResManager.loadKDString((String)"\u6863\u6848\u7248\u672c\u5173\u8054\u4efb\u804c\u5df2\u5e9f\u5f03\uff0c\u8bf7\u8c03\u6574\u6863\u6848\u57fa\u672c\u4fe1\u606f\u3002", (String)"DecAdjRecordHRImportHelper_22", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String frequencyNoMatch = ResManager.loadKDString((String)"\u9891\u5ea6\u6240\u5c5e\u56fd\u5bb6\u5730\u533a\u4e0e\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_19", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String bsedAfterMaxDate = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08{0}\uff09\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u6b21\u5b9a\u8c03\u85aa\u751f\u6548\u65e5\u671f\uff08{1}\uff09\u3002", (String)"DecAdjRecordHRImportHelper_24", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashSet<String> standarditemSet = new HashSet<String>(16);
        HashMap<Long, Long> fileJrsnMap = new HashMap<Long, Long>(16);
        HashMap indexToPersonMap = new HashMap(16);
        Date sysMinDate = SWCBaseUtils.getMinEffectDate();
        for (ImportBillData billData : list) {
            indexToPersonMap.clear();
            JSONObject jsonObject = billData.getData();
            JSONObject jsonFile = jsonObject.getJSONObject("hcdm_adjfileinfo");
            JSONArray jsonRecord = jsonObject.getJSONArray("hcdm_salaryadjrecord");
            JSONArray jsonPerson = jsonObject.getJSONArray("hcdm_decadjrelperson");
            if (jsonPerson != null) {
                jsonPerson.stream().forEach(person -> indexToPersonMap.put(((JSONObject)person).getInteger("$excelIndex"), (JSONObject)person));
            }
            String empnumber = jsonFile.getJSONObject("employee").getString("empnumber");
            for (int i = 0; i < jsonRecord.size(); ++i) {
                String type;
                JSONObject item;
                JSONObject record = (JSONObject)jsonRecord.get(i);
                Integer rowIndex = record.getInteger("$excelIndex");
                Object fileObj = deterFileMap.get(rowIndex);
                if (ObjectUtils.isEmpty(fileObj) || !(fileObj instanceof DynamicObject)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u6863\u6848\u7248\u672c\u3002", (String)"DecAdjRecordHRImportHelper_49", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                    continue;
                }
                DynamicObject deterFile = (DynamicObject)fileObj;
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(checkResult) && !checkResult.getOrDefault(deterFile.getLong("boid"), false).booleanValue()) {
                    DecAdjRecordHRImportHelper.writeErrorLog(empopoAbandon, rowIndex, importLog, billData);
                }
                Long depempId = deterFile.getLong("depemp.id");
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(initMap) && initMap.containsKey(deterFile.getLong("boid"))) {
                    DecAdjRecordHRImportHelper.writeErrorLog(initExit, rowIndex, importLog, billData);
                }
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(candSet) && candSet.containsKey(depempId)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(candBillExist, Joiner.on((String)",").join((Iterable)candSet.get(depempId))), rowIndex, importLog, billData);
                }
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(adjBillMap) && adjBillMap.containsKey(depempId)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(adjBillExist, Joiner.on((String)",").join((Iterable)adjBillMap.get(depempId))), rowIndex, importLog, billData);
                }
                Long fileId = deterFile.getLong("id");
                JSONObject sjrsn = record.getJSONObject("salaryadjrsn");
                if (ObjectUtils.isEmpty((Object)sjrsn)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_54", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                }
                if (sjrsn.containsKey((Object)"id")) {
                    Long value = (Long)fileJrsnMap.get(fileId);
                    Long sjrsnId = sjrsn.getLong("id");
                    if (ObjectUtils.isEmpty((Object)value)) {
                        fileJrsnMap.put(fileId, sjrsnId);
                    } else if (value.compareTo(sjrsnId) != 0) {
                        DecAdjRecordHRImportHelper.writeErrorLog(jrsnRepeat, rowIndex, importLog, billData);
                    }
                }
                if ((item = record.getJSONObject("standarditem")).containsKey((Object)"id")) {
                    Set itemSet;
                    String key2 = fileId + "_" + item.getLong("id");
                    if (standarditemSet.contains(key2)) {
                        DecAdjRecordHRImportHelper.writeErrorLog(itemRepeat, rowIndex, importLog, billData);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(itemSet = structIdToItemIdMap.get(deterFile.getLong("salaystructure.id")))) && !itemSet.contains(item.getLong("id"))) {
                        DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\uff08{0}\uff09\u4e0d\u5c5e\u4e8e\u8be5\u4eba\u5458\u85aa\u916c\u7ed3\u6784\u4e2d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\uff0c\u8bf7\u8c03\u6574", (String)"DecAdjRecordHRImportHelper_35", (String)"swc-hcdm-business", (Object[])new Object[0]), item.getString("name")), rowIndex, importLog, billData);
                    }
                    standarditemSet.add(key2);
                }
                JSONObject personJson = (JSONObject)indexToPersonMap.get(rowIndex);
                JSONObject frequency = record.getJSONObject("frequency");
                if (ObjectUtils.isNotEmpty((Object)frequency) && frequency.containsKey((Object)"id")) {
                    List frequencyList = (List)nameToFrequencyMap.get(((JSONObject)record.get((Object)"frequency")).getString("name"));
                    Long countryId = deterFile.getLong("country.id");
                    if (ObjectUtils.isNotEmpty((Object)personJson) && ObjectUtils.isNotEmpty((Object)personJson.getJSONObject("country")) && personJson.getJSONObject("country").containsKey((Object)"id")) {
                        countryId = personJson.getJSONObject("country").getLong("id");
                    }
                    DynamicObject matchFrequency = DecAdjRecordHRImportHelper.frequencyMatch(countryId, frequencyList);
                    frequencyBaseMap.put(rowIndex, matchFrequency);
                    if (matchFrequency == null) {
                        DecAdjRecordHRImportHelper.writeErrorLog(frequencyNoMatch, rowIndex, importLog, billData);
                    }
                    if (org.apache.commons.collections4.MapUtils.isNotEmpty(resultMap) && org.apache.commons.collections4.MapUtils.isNotEmpty(resultMap.get(deterFile.getLong("id"))) && item.containsKey((Object)"id")) {
                        DynamicObject stdTable;
                        SalaryStdMatchResultNew sMatchResult = resultMap.get(deterFile.getLong("id")).get(item.getLong("id"));
                        if (org.apache.commons.collections4.MapUtils.isNotEmpty(tableAndCoeffObjs) && org.apache.commons.collections4.MapUtils.isNotEmpty(tableAndCoeffObjs.get("stdTableVid")) && ObjectUtils.isNotEmpty((Object)sMatchResult) && sMatchResult.getStdTableVid() != null && ObjectUtils.isNotEmpty((Object)(stdTable = tableAndCoeffObjs.get("stdTableVid").get(sMatchResult.getStdTableVid()))) && ObjectUtils.isNotEmpty((Object)stdTable.get("frequency")) && matchFrequency != null && matchFrequency.getLong("id") != stdTable.getLong("frequency.id")) {
                            DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u9891\u5ea6\u4e0e\u85aa\u916c\u6807\u51c6\u8868\u4e2d\u9891\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_37", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                        }
                    }
                }
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(resultMap)) {
                    DecAdjRecordHRImportHelper.stdTableValidate(empnumber, gradeBaseMap, rankBaseMap, resultMap.get(deterFile.getLong("id")), record, deterFile, importLog, billData, rankAndGradeNameMaps, openRankMap);
                }
                if (ObjectUtils.isNotEmpty((Object)personJson)) {
                    DecAdjRecordHRImportHelper.personDataValidate(empnumber, personJson, record, deterFile, importLog, billData, jobLevelGradeMap, jobLevelGradeBaseMap);
                }
                if (!item.containsKey((Object)"id")) continue;
                String string = type = salaryadjrsnToType == null ? null : salaryadjrsnToType.get(record.getJSONObject("salaryadjrsn").get((Object)"id"));
                if (type == null) continue;
                Long fileBoid = deterFile.getLong("boid");
                Date maxDate = null;
                Date bsed = record.getDate("bsed");
                if (AdjAttributionType.DECATTRTYPE.getCode().equals(type) && org.apache.commons.collections4.MapUtils.isNotEmpty(decRecMaxDateMap)) {
                    maxDate = decRecMaxDateMap.get(fileBoid);
                }
                if (AdjAttributionType.ADJATTRTYPE.getCode().equals(type) && org.apache.commons.collections4.MapUtils.isNotEmpty(adjRecMaxDateMap)) {
                    maxDate = adjRecMaxDateMap.get(fileBoid).get(item.getLong("id"));
                }
                logger.info("decAdjType is:{},match maxDate is:{}, item bsed is:{}", new Object[]{type, SWCDateTimeUtils.format((Date)maxDate, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd")});
                if (bsed == null || maxDate == null || bsed.after(maxDate) || !maxDate.after(sysMinDate)) continue;
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(bsedAfterMaxDate, SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)maxDate, (String)"yyyy-MM-dd")), rowIndex, importLog, billData);
            }
        }
    }

    private static void extractParams(List<ImportBillData> list, Map<Integer, Object> deterFileMap, Set<String> frequencyNames, Set<Long> decFileBoids, Map<Long, Set<Long>> adjFileBoidToItemMap, Map<Long, String> salaryadjrsnToType, Set<MatchStdTableWithAdjFileParam> matchParams, Set<Long> decAdjFileBoidIds, Set<Long> structIds) {
        for (ImportBillData billData : list) {
            JSONObject jsonObject = billData.getData();
            JSONArray jsonRecord = jsonObject.getJSONArray("hcdm_salaryadjrecord");
            for (int i = 0; i < jsonRecord.size(); ++i) {
                JSONObject frequency;
                JSONObject record = (JSONObject)jsonRecord.get(i);
                Integer rowIndex = record.getInteger("$excelIndex");
                Object file = deterFileMap.get(rowIndex);
                JSONObject standarditem = record.getJSONObject("standarditem");
                JSONObject salaryadjrsn = record.getJSONObject("salaryadjrsn");
                if (ObjectUtils.isNotEmpty((Object)file) && file instanceof DynamicObject && standarditem.containsKey((Object)"id") && ObjectUtils.isNotEmpty((Object)salaryadjrsn)) {
                    String type;
                    DynamicObject deterFile = (DynamicObject)file;
                    Long fileId = deterFile.getLong("id");
                    Long boid = deterFile.getLong("boid");
                    structIds.add(deterFile.getLong("salaystructure.id"));
                    Long itemId = standarditem.getLong("id");
                    Date bsed = record.getDate("bsed");
                    if (ObjectUtils.isNotEmpty((Object)bsed)) {
                        MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
                        param.setAdjFileId(fileId);
                        param.setStdItemId(itemId);
                        param.setBsed(bsed);
                        matchParams.add(param);
                    }
                    String string = type = salaryadjrsnToType == null ? null : salaryadjrsnToType.get(salaryadjrsn.get((Object)"id"));
                    if (type != null) {
                        if (AdjAttributionType.DECATTRTYPE.getCode().equals(type)) {
                            decFileBoids.add(boid);
                        }
                        if (AdjAttributionType.ADJATTRTYPE.getCode().equals(type)) {
                            adjFileBoidToItemMap.computeIfAbsent(boid, vo -> Sets.newHashSetWithExpectedSize((int)16)).add(itemId);
                        }
                    }
                    decAdjFileBoidIds.add(boid);
                }
                if (!ObjectUtils.isNotEmpty((Object)(frequency = record.getJSONObject("frequency")))) continue;
                frequencyNames.add(frequency.getString("name"));
            }
        }
    }

    private static DynamicObject frequencyMatch(Long countryId, List<DynamicObject> frequencyList) {
        List matchList;
        DynamicObject result = null;
        if (CollectionUtils.isNotEmpty(frequencyList) && CollectionUtils.isNotEmpty(matchList = frequencyList.stream().filter(obj -> ObjectUtils.isEmpty((Object)obj.get("country")) || ObjectUtils.isNotEmpty((Object)obj.get("country")) && countryId.longValue() == obj.getLong("country.id")).collect(Collectors.toList()))) {
            DynamicObject matchObj = matchList.stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj.get("country")) && countryId.compareTo(obj.getLong("country.id")) == 0).findFirst().orElse(null);
            result = matchObj == null ? (DynamicObject)matchList.get(0) : matchObj;
        }
        return result;
    }

    public static void stdTableValidate(String empNumber, Map<Integer, Object> gradeBaseMap, Map<Integer, Object> rankBaseMap, Map<Long, SalaryStdMatchResultNew> matchValues, JSONObject record, DynamicObject deterFile, ImportLog importLog, ImportBillData billData, Map<String, Map<Long, String>> rankAndGradeNameMaps, Map<Long, Map<Long, Boolean>> openRankMap) {
        String gradeOrRankNoMatch = ResManager.loadKDString((String)"\u5f53\u524d\u6240\u586b\u85aa\u7b49\u3001\u85aa\u6863\u4e0d\u5728\u5458\u5de5\u5f53\u524d\u85aa\u916c\u6807\u51c6\u8303\u56f4\u5185\u201c{0}\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_16", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String frequencyMustInput = ResManager.loadKDString((String)"\u672a\u5173\u8054\u6807\u51c6\u8868\uff0c\u9891\u5ea6\u4e3a\u5fc5\u586b\u3002", (String)"DecAdjRecordHRImportHelper_20", (String)"swc-hcdm-business", (Object[])new Object[0]);
        logger.info("matchValues is:{}", (Object)JSON.toJSONString(matchValues));
        if (org.apache.commons.collections4.MapUtils.isEmpty(matchValues)) {
            return;
        }
        JSONObject item = record.getJSONObject("standarditem");
        if (!item.containsKey((Object)"id")) {
            return;
        }
        Long itemId = item.getLong("id");
        SalaryStdMatchResultNew sMatchResult = matchValues.get(itemId);
        if (ObjectUtils.isEmpty((Object)sMatchResult)) {
            return;
        }
        Integer rowIndex = record.getInteger("$excelIndex");
        JSONObject grade = record.getJSONObject("grade");
        JSONObject rank = record.getJSONObject("rank");
        logger.info("sMatchResult is:{}", (Object)JSON.toJSONString((Object)sMatchResult));
        StdTabNotFoundType stdTabNotFoundType = sMatchResult.getStdTableNotFoundType();
        String isMatchGradeRank = sMatchResult.getIsMatchGradeRank();
        logger.info("isMatchGradeRank is:{}", (Object)isMatchGradeRank);
        if (isMatchGradeRank != null && isMatchGradeRank.equals("0") && (ObjectUtils.isNotEmpty((Object)grade) || ObjectUtils.isNotEmpty((Object)rank))) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee\uff08{0}\uff09\u6ca1\u6709\u53ef\u7528\u85aa\u7b49\u3001\u85aa\u6863\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_34", (String)"swc-hcdm-business", (Object[])new Object[0]), item.getString("name")), rowIndex, importLog, billData);
        }
        if (ObjectUtils.isNotEmpty((Object)stdTabNotFoundType)) {
            logger.info("stdTabNotFoundType.code:{},stdTabNotFoundType.name:{}", (Object)stdTabNotFoundType.getCode(), (Object)stdTabNotFoundType.getLocaleName());
            String structName = deterFile.getString("salaystructure.name");
            String errorMsg = StdTabNotFoundType.getNameByCode((String)stdTabNotFoundType.getCode());
            logger.info("stdTabNotFoundType info itemName is:{}, StdTabNotFoundType msg is:{}, structName is :{}", new Object[]{item.getString("name"), errorMsg, structName});
            if (StdTabNotFoundType.NOSTDSCM_INBSED.getCode().equals(stdTabNotFoundType.getCode())) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u4f53\u7cfb\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_38", (String)"swc-hcdm-business", (Object[])new Object[0]), empNumber), rowIndex, importLog, billData);
                return;
            }
            if (StdTabNotFoundType.ITEM_NOTEXIST_INSCM.getCode().equals(stdTabNotFoundType.getCode())) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee\u5728\u85aa\u916c\u4f53\u7cfb\u6216\u85aa\u916c\u7ed3\u6784\u4e2d\u4e0d\u53ef\u7528\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_32", (String)"swc-hcdm-business", (Object[])new Object[0]), empNumber), rowIndex, importLog, billData);
                return;
            }
            if (StdTabNotFoundType.STD_UNUSEABLE.getCode().equals(stdTabNotFoundType.getCode())) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u751f\u6548\u65e5\u671f\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_39", (String)"swc-hcdm-business", (Object[])new Object[0]), empNumber), rowIndex, importLog, billData);
                return;
            }
            if (StdTabNotFoundType.ITEM_NOTEXIST_INSTD.getCode().equals(stdTabNotFoundType.getCode())) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u5b9a\u8c03\u85aa\u9879\u76ee\u4e0d\u5b58\u5728\u6240\u5c5e\u7684\u6807\u51c6\u8868\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_40", (String)"swc-hcdm-business", (Object[])new Object[0]), empNumber), rowIndex, importLog, billData);
                return;
            }
        }
        Map gradeRankKeys = sMatchResult.getRangeData();
        logger.info("rowIndex:{}, isMatchGradeRank is:{}", (Object)rowIndex, (Object)isMatchGradeRank);
        Long stdTableId = sMatchResult.getStdTableVid();
        logger.info("rowIndex:{},match stdTableId:{}", (Object)rowIndex, (Object)stdTableId);
        if ((stdTableId == null || stdTableId <= 0L) && ObjectUtils.isEmpty((Object)record.get((Object)"frequency"))) {
            DecAdjRecordHRImportHelper.writeErrorLog(frequencyMustInput, rowIndex, importLog, billData);
            return;
        }
        if (ObjectUtils.isNotEmpty((Object)stdTabNotFoundType) && StdTabNotFoundType.ITEM_NOTSETSTD_INSCM.getCode().equals(stdTabNotFoundType.getCode())) {
            return;
        }
        boolean isOpenRank = false;
        Map<Long, Boolean> itemIsOpMap = openRankMap.get(stdTableId);
        if (org.apache.commons.collections4.MapUtils.isNotEmpty(itemIsOpMap) && itemIsOpMap.get(itemId) != null && itemIsOpMap.get(itemId).booleanValue()) {
            isOpenRank = true;
        }
        if (isMatchGradeRank != null && isMatchGradeRank.equals("1")) {
            if (ObjectUtils.isEmpty((Object)grade) && ObjectUtils.isEmpty((Object)rank)) {
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u85aa\u7b49\uff0c\u85aa\u6863\u3002", (String)"DecAdjRecordHRImportHelper_26", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                return;
            }
            if (ObjectUtils.isEmpty((Object)grade)) {
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u85aa\u7b49\u3002", (String)"DecAdjRecordHRImportHelper_27", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                return;
            }
            if (ObjectUtils.isEmpty((Object)rank) && isOpenRank) {
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u85aa\u6863\u3002", (String)"DecAdjRecordHRImportHelper_28", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                return;
            }
        }
        if (org.apache.commons.collections4.MapUtils.isEmpty((Map)gradeRankKeys)) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"{0}\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6dfb\u52a0\u3002", (String)"DecAdjRecordHRImportHelper_42", (String)"swc-hcdm-business", (Object[])new Object[0]), item.getString("name")), rowIndex, importLog, billData);
            return;
        }
        if (ObjectUtils.isEmpty((Object)grade)) {
            return;
        }
        Long gradeMatchObj = DecAdjRecordHRImportHelper.gradeRankMatch("grade", grade.getString("name"), rankAndGradeNameMaps, gradeRankKeys, null);
        gradeBaseMap.put(rowIndex, gradeMatchObj);
        if (gradeMatchObj == null) {
            String rangeName = DecAdjRecordHRImportHelper.getStdRangeNameByRangeId(String.valueOf(rowIndex), stdTableId, isOpenRank, gradeRankKeys);
            logger.info(" rangeName is:{}", (Object)rangeName);
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(gradeOrRankNoMatch, rangeName), rowIndex, importLog, billData);
            return;
        }
        if (gradeMatchObj != null && ObjectUtils.isNotEmpty((Object)rank)) {
            Long rankMatchObj = DecAdjRecordHRImportHelper.gradeRankMatch("rank", rank.getString("name"), rankAndGradeNameMaps, gradeRankKeys, gradeMatchObj);
            rankBaseMap.put(rowIndex, rankMatchObj);
            if (rankMatchObj == null) {
                String rangeName = DecAdjRecordHRImportHelper.getStdRangeNameByRangeId(String.valueOf(rowIndex), stdTableId, isOpenRank, gradeRankKeys);
                logger.info(" rangeName is:{}", (Object)rangeName);
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(gradeOrRankNoMatch, rangeName), rowIndex, importLog, billData);
                return;
            }
        }
    }

    public static void fileEqualValidate(List<ImportBillData> list, Map<String, Object> baseDataMap, ImportLog importLog) {
        String rowHasErrorMsg = ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u5165\u6570\u636e\u4e2d\uff0c\u8be5\u884c\u5b58\u5728\u5176\u4ed6\u7684\u5b9a\u8c03\u85aa\u6570\u636e\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u7cfb\u7edf\u8981\u6c42\u6bcf\u6b21\u5bfc\u5165\u7684\u540c\u4e00\u4e2a\u6863\u6848\u6570\u636e\u9700\u540c\u65f6\u6821\u9a8c\u901a\u8fc7\u540e\u624d\u53ef\u5bfc\u5165\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_48", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String noMatchFile = ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u6709\u6548\u7684\u6863\u6848\u7248\u672c\u3002", (String)"DecAdjRecordHRImportHelper_18", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Map deterFileMap = (Map)baseDataMap.get("salaryadjfile.number");
        if (org.apache.commons.collections4.MapUtils.isEmpty((Map)importLog.getRowErrors()) || CollectionUtils.isEmpty(list) || org.apache.commons.collections4.MapUtils.isEmpty((Map)((Map)importLog.getRowErrors().get(list.get(0).getSheetName())))) {
            return;
        }
        Set errorIndexSet = ((ConcurrentHashMap)importLog.getRowErrors().get(list.get(0).getSheetName())).keySet();
        if (org.apache.commons.collections4.MapUtils.isEmpty((Map)deterFileMap) || CollectionUtils.isEmpty((Collection)errorIndexSet)) {
            return;
        }
        HashSet errorFileIds = new HashSet(16);
        for (ImportBillData billData : list) {
            errorFileIds.clear();
            JSONArray jsonRecord = billData.getData().getJSONArray("hcdm_salaryadjrecord");
            jsonRecord.stream().forEach(obj -> {
                Integer rowIndex = ((JSONObject)obj).getInteger("$excelIndex");
                Object fileObj = deterFileMap.get(rowIndex);
                if (ObjectUtils.isEmpty(fileObj) || !(fileObj instanceof DynamicObject)) {
                    DecAdjRecordHRImportHelper.writeErrorLog(noMatchFile, rowIndex, importLog, billData);
                } else if (errorIndexSet.contains(rowIndex)) {
                    errorFileIds.add(((DynamicObject)fileObj).getLong("id"));
                }
            });
            if (CollectionUtils.isEmpty(errorFileIds)) continue;
            jsonRecord.stream().forEach(obj -> {
                Integer rowIndex = ((JSONObject)obj).getInteger("$excelIndex");
                if (ObjectUtils.isNotEmpty(deterFileMap.get(rowIndex)) && !errorIndexSet.contains(rowIndex) && errorFileIds.contains(((DynamicObject)deterFileMap.get(rowIndex)).getLong("id"))) {
                    DecAdjRecordHRImportHelper.writeErrorLog(rowHasErrorMsg, rowIndex, importLog, billData);
                }
            });
        }
    }

    public static void personDataValidate(String empnumber, JSONObject person, JSONObject record, DynamicObject adjFile, ImportLog importLog, ImportBillData billData, Map<Long, List<DynamicObject>> jobLevelGradeMap, Map<Integer, Object> jobLevelGradeBaseMap) {
        JSONObject jobgrade;
        String adminorgnotequal = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0e\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String positionnotequal = ResManager.loadKDString((String)"\u5c97\u4f4d\u4e0e\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjRecordHRImportHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String nameNotMatchFile = ResManager.loadKDString((String)"\u59d3\u540d{0}\u4e0e\u5de5\u53f7{1}\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String empNumNotMatchFile = ResManager.loadKDString((String)"\u5de5\u53f7{0}\u4e0e\u6863\u6848\u7f16\u53f7{1}\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_8", (String)"swc-hcdm-business", (Object[])new Object[0]);
        JSONObject adminorg = person.getJSONObject("adminorg");
        JSONObject position = person.getJSONObject("position");
        Integer rowIndex = record.getInteger("$excelIndex");
        if (ObjectUtils.isNotEmpty((Object)adminorg) && adminorg.containsKey((Object)"id") && adminorg.getLong("id").longValue() != adjFile.getLong("adminorg.id")) {
            DecAdjRecordHRImportHelper.writeErrorLog(adminorgnotequal, rowIndex, importLog, billData);
            return;
        }
        if (ObjectUtils.isNotEmpty((Object)position) && position.containsKey((Object)"id") && position.getLong("id").longValue() != adjFile.getLong("position.id")) {
            DecAdjRecordHRImportHelper.writeErrorLog(positionnotequal, rowIndex, importLog, billData);
            return;
        }
        String personname = person.getString("personname");
        String fileEmpNumber = adjFile.getString("employee.empnumber");
        if (!empnumber.equals(fileEmpNumber)) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(empNumNotMatchFile, personname, empnumber), rowIndex, importLog, billData);
            return;
        }
        String filePersonName = adjFile.getString("person.name");
        if (StringUtils.isNotBlank((CharSequence)personname) && !personname.equals(filePersonName)) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(nameNotMatchFile, personname, empnumber), rowIndex, importLog, billData);
            return;
        }
        String bsed = SWCDateTimeUtils.format((Date)adjFile.getDate("bsed"), (String)"yyyy-MM-dd");
        JSONObject org = person.getJSONObject("org");
        if (ObjectUtils.isNotEmpty((Object)org) && org.containsKey((Object)"id") && org.getLong("id").longValue() != adjFile.getLong("org.id")) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u5728{0}\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_29", (String)"swc-hcdm-business", (Object[])new Object[0]), bsed), rowIndex, importLog, billData);
            return;
        }
        JSONObject country = person.getJSONObject("country");
        if (ObjectUtils.isNotEmpty((Object)country) && country.containsKey((Object)"id") && country.getLong("id").longValue() != adjFile.getLong("country.id")) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u4e0e\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u5728{0}\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_30", (String)"swc-hcdm-business", (Object[])new Object[0]), bsed), rowIndex, importLog, billData);
            return;
        }
        JSONObject stdscm = person.getJSONObject("stdscm");
        if (ObjectUtils.isNotEmpty((Object)stdscm) && stdscm.containsKey((Object)"id") && stdscm.getLong("id").longValue() != adjFile.getLong("stdscm.id")) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u85aa\u916c\u4f53\u7cfb\u4e0e\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u5728{0}\u7684\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_36", (String)"swc-hcdm-business", (Object[])new Object[0]), bsed), rowIndex, importLog, billData);
            return;
        }
        JSONObject joblevel = person.getJSONObject("joblevel");
        Long employeeId = adjFile.getLong("employee.id");
        if (ObjectUtils.isNotEmpty((Object)joblevel) && joblevel.containsKey((Object)"id") && jobLevelGradeMap != null) {
            DynamicObject matchObj = DecAdjRecordHRImportHelper.matchJobGrade("joblevel.name", joblevel.getString("name"), record, jobLevelGradeMap.get(employeeId));
            if (matchObj == null) {
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u804c\u7ea7\u3001\u804c\u7b49\u4e0e\u5458\u5de5\u5f53\u524d\u751f\u6548\u65e5\u671f\u4e0b\u804c\u7ea7\u804c\u7b49\u4e0d\u7b26\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_41", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                return;
            }
            HashMap valueMap = (HashMap)jobLevelGradeBaseMap.computeIfAbsent(rowIndex, value -> new HashMap(16));
            valueMap.put("joblevel", matchObj.get("joblevel"));
        }
        if (ObjectUtils.isNotEmpty((Object)(jobgrade = person.getJSONObject("jobgrade"))) && jobgrade.containsKey((Object)"id") && jobLevelGradeMap != null) {
            DynamicObject matchObj = DecAdjRecordHRImportHelper.matchJobGrade("jobgrade.name", jobgrade.getString("name"), record, jobLevelGradeMap.get(employeeId));
            if (matchObj == null) {
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u804c\u7ea7\u3001\u804c\u7b49\u4e0e\u5458\u5de5\u5f53\u524d\u751f\u6548\u65e5\u671f\u4e0b\u804c\u7ea7\u804c\u7b49\u4e0d\u7b26\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjRecordHRImportHelper_41", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                return;
            }
            HashMap valueMap = (HashMap)jobLevelGradeBaseMap.computeIfAbsent(rowIndex, value -> new HashMap(16));
            valueMap.put("jobgrade", matchObj.get("jobgrade"));
        }
    }

    private static DynamicObject matchJobGrade(String property, String name, JSONObject record, List<DynamicObject> list) {
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        Object bsedObj = record.get((Object)"bsed");
        if (bsedObj != null && !(bsedObj instanceof Date)) {
            return null;
        }
        Date bsed = (Date)bsedObj;
        return list.stream().filter(obj -> SWCDateTimeUtils.isCover((Date)bsed, (Date)obj.getDate("startdate"), (Date)obj.getDate("enddate")) && obj.getString(property).equals(name)).findFirst().orElse(null);
    }

    public static void adjBillNoValidate(ImportLog importLog, Map<String, List<DynamicObject>> noPerAdjFileForEmpMap, Map<String, List<DynamicObject>> perAdjFileForEmpMap, Map<String, List<DynamicObject>> noperFileMap, Map<String, List<DynamicObject>> perFileMap, Map<Integer, Object> baseFileMap, ImportBillData billData, String empnumber, JSONObject recObj) {
        Map<String, List<DynamicObject>> groupMap;
        String noFilePerMsg = ResManager.loadKDString((String)"\u65e0\u6863\u6848\u7f16\u53f7{0}\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"DecAdjRecordHRImportHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String suitFileMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u3001\u5df2\u5931\u6548\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u624d\u652f\u6301\u5bfc\u5165\u5b9a\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordHRImportHelper_44", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String findMuliFile = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e3a\u60a8\u627e\u5230\u591a\u4e2a\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u8bf7\u586b\u5199\u6863\u6848\u7f16\u53f7\u3002", (String)"DecAdjRecordHRImportHelper_4", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String notMatch = ResManager.loadKDString((String)"\u5de5\u53f7{0}\u4e0e\u6863\u6848\u7f16\u53f7{1}\u4e0d\u5339\u914d\u3002", (String)"DecAdjRecordHRImportHelper_23", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Integer rowIndex = recObj.getInteger("$excelIndex");
        DynamicObject fileFromNum = null;
        if (ObjectUtils.isNotEmpty((Object)recObj.get((Object)"salaryadjfile"))) {
            JSONObject jsfile = recObj.getJSONObject("salaryadjfile");
            if (!jsfile.containsKey((Object)"id")) {
                return;
            }
            String fileNumber = jsfile.getString("number");
            List<DynamicObject> perFileList = perFileMap.get(fileNumber);
            List<DynamicObject> noperFileList = noperFileMap.get(fileNumber);
            if (CollectionUtils.isNotEmpty(noperFileList) && CollectionUtils.isEmpty(perFileList)) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(noFilePerMsg, empnumber), rowIndex, importLog, billData);
                return;
            }
            if (CollectionUtils.isEmpty(perFileList)) {
                DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u6863\u6848\uff0c\u8bf7\u586b\u5199\u6863\u6848\u7f16\u53f7\u3002", (String)"DecAdjRecordHRImportHelper_31", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
                return;
            }
            List<DynamicObject> matchObj = DecAdjRecordHRImportHelper.matchFileWithStatus(perFileList);
            if (CollectionUtils.isEmpty(matchObj)) {
                DecAdjRecordHRImportHelper.writeErrorLog(suitFileMsg, rowIndex, importLog, billData);
                return;
            }
            fileFromNum = matchObj.get(0);
        }
        List<DynamicObject> noperList = noPerAdjFileForEmpMap.get(empnumber);
        List<DynamicObject> perList = perAdjFileForEmpMap.get(empnumber);
        if (CollectionUtils.isNotEmpty(noperList) && CollectionUtils.isEmpty(perList)) {
            DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(noFilePerMsg, empnumber), rowIndex, importLog, billData);
            return;
        }
        if (CollectionUtils.isEmpty(perList)) {
            DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u6863\u6848\uff0c\u8bf7\u586b\u5199\u6863\u6848\u7f16\u53f7\u3002", (String)"DecAdjRecordHRImportHelper_31", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
            return;
        }
        List<DynamicObject> matchObj = DecAdjRecordHRImportHelper.matchFileWithStatus(perList);
        if (CollectionUtils.isEmpty(matchObj)) {
            DecAdjRecordHRImportHelper.writeErrorLog(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u6863\u6848\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u3001\u5df2\u5931\u6548\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u624d\u652f\u6301\u5bfc\u5165\u5b9a\u8c03\u85aa\u6570\u636e\u3002", (String)"DecAdjRecordHRImportHelper_43", (String)"swc-hcdm-business", (Object[])new Object[0]), rowIndex, importLog, billData);
            return;
        }
        if (ObjectUtils.isEmpty((Object)recObj.get((Object)"salaryadjfile")) && (groupMap = matchObj.stream().collect(Collectors.groupingBy(obj -> obj.getString("number")))).size() > 1) {
            DecAdjRecordHRImportHelper.writeErrorLog(findMuliFile, rowIndex, importLog, billData);
            return;
        }
        if (fileFromNum != null) {
            Set numberSet = matchObj.stream().map(obj -> obj.getString("number")).collect(Collectors.toSet());
            Set empnumberSet = matchObj.stream().map(obj -> obj.getString("employee.empnumber")).collect(Collectors.toSet());
            String fileNumFromNum = fileFromNum.getString("number");
            if (!numberSet.contains(fileNumFromNum)) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(notMatch, empnumber, fileNumFromNum), rowIndex, importLog, billData);
                return;
            }
            if (!empnumberSet.contains(fileFromNum.getString("employee.empnumber"))) {
                DecAdjRecordHRImportHelper.writeErrorLog(MessageFormat.format(notMatch, empnumber, fileNumFromNum), rowIndex, importLog, billData);
                return;
            }
        } else {
            fileFromNum = matchObj.get(0);
        }
        baseFileMap.put(rowIndex, fileFromNum.getLong("boid"));
    }

    public static void packBaseDataForDynamicObject(Map<String, Object> baseDataMap, List<ImportBillData> importBillData, Object[] objects, Map<Integer, Object> deterFileMap, Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap) {
        if (org.apache.commons.collections4.MapUtils.isEmpty(deterFileMap)) {
            logger.info(" packBaseDataForDynamicObject deterFileMap is empty~~ ");
            throw new KDBizException("DecAdjRecordHRImportPlugin.packBaseDataForDynamicObject deterFileMap is empty ~~");
        }
        Map gradeBaseMap = null;
        if (ObjectUtils.isNotEmpty((Object)baseDataMap.get("grade.name"))) {
            gradeBaseMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)baseDataMap.get("grade.name")));
        }
        DecAdjRecordHRImportHelper.getGradeOrRankObjs("grade", gradeBaseMap);
        Map rankBaseMap = null;
        if (ObjectUtils.isNotEmpty((Object)baseDataMap.get("rank.name"))) {
            rankBaseMap = (Map)SerializationUtils.deSerializeFromBase64((String)((String)baseDataMap.get("rank.name")));
        }
        DecAdjRecordHRImportHelper.getGradeOrRankObjs("rank", rankBaseMap);
        Map<String, Map<Long, DynamicObject>> tableAndCoeffObjs = null;
        if (resultMap != null) {
            tableAndCoeffObjs = DecAdjRecordHRImportHelper.getStdTableAndCoeff(resultMap);
        }
        Map jobLevelGradeBaseMap = null;
        if (ObjectUtils.isNotEmpty((Object)baseDataMap.get("joblevel.grade.name"))) {
            jobLevelGradeBaseMap = (Map)baseDataMap.get("joblevel.grade.name");
        }
        SWCDataServiceHelper adjRelPersonService = new SWCDataServiceHelper("hcdm_decadjrelperson");
        HashMap perRowIndexMap = new HashMap(16);
        HashMap recRowIndexMap = new HashMap(16);
        logger.info("packBaseDataForDynamicObject perRowIndexMap size:{},recRowIndexMap size:{}", (Object)perRowIndexMap.size(), (Object)recRowIndexMap.size());
        for (ImportBillData importBillData2 : importBillData) {
            JSONArray jsonPerson = importBillData2.getData().getJSONArray("hcdm_decadjrelperson");
            if (jsonPerson != null) {
                jsonPerson.stream().forEach(per -> {
                    JSONObject person = (JSONObject)per;
                    perRowIndexMap.put(person.getLong("id"), person.getInteger("$excelIndex"));
                });
            }
            JSONArray jsonRecord = importBillData2.getData().getJSONArray("hcdm_salaryadjrecord");
            jsonRecord.stream().forEach(rec -> {
                JSONObject record = (JSONObject)rec;
                recRowIndexMap.put(record.getLong("id"), record.getInteger("$excelIndex"));
            });
        }
        HashMap indexToPersonMap = new HashMap(16);
        for (Object obj : objects) {
            if (ObjectUtils.isEmpty(((HashMap)obj).get("hcdm_decadjrelperson"))) continue;
            DynamicObjectCollection personCollection = (DynamicObjectCollection)((HashMap)obj).get("hcdm_decadjrelperson");
            indexToPersonMap.putAll(personCollection.stream().collect(Collectors.toMap(key -> (Integer)perRowIndexMap.get(key.getLong("id")), Function.identity(), (o1, o2) -> o2)));
        }
        DynamicObject dynamicObject = DecAdjRecordHRImportHelper.queryRMBcurrency();
        MainEntityType adjPersonEntity = MetadataServiceHelper.getDataEntityType((String)"hcdm_decadjrelperson");
        Map<Long, String> contrastIdToRecordMap = DecAdjRecordHRImportHelper.getContrastIdToRecord();
        int relPersonId = 0;
        long[] personIds = ORM.create().genLongIds("hcdm_decadjrelperson", recRowIndexMap.size());
        SWCDataServiceHelper adjFileService = new SWCDataServiceHelper("hcdm_adjfileinfo");
        for (Object obj : objects) {
            DynamicObjectCollection personCollection = null;
            if (ObjectUtils.isEmpty(((HashMap)obj).get("hcdm_decadjrelperson"))) {
                personCollection = new DynamicObjectCollection();
                ((HashMap)obj).put("hcdm_decadjrelperson", personCollection);
            } else {
                personCollection = (DynamicObjectCollection)((HashMap)obj).get("hcdm_decadjrelperson");
            }
            DynamicObjectCollection recordCollection = (DynamicObjectCollection)((HashMap)obj).get("hcdm_salaryadjrecord");
            for (DynamicObject record : recordCollection) {
                Object fileObj;
                Integer rowIndex = (Integer)recRowIndexMap.get(record.getLong("id"));
                if (ObjectUtils.isEmpty((Object)deterFileMap.get(rowIndex))) continue;
                DynamicObject perObj = (DynamicObject)indexToPersonMap.get(rowIndex);
                if (perObj == null) {
                    if (personIds == null || personIds.length < relPersonId + 1) {
                        throw new KDBizException("DecAdjRecordHRImportHelper.packBaseDataForDynamicObject new person index out of bound ~~~ ");
                    }
                    perObj = adjRelPersonService.generateEmptyDynamicObject();
                    perObj.set("id", (Object)personIds[relPersonId++]);
                    personCollection.add((Object)perObj);
                }
                if (ObjectUtils.isEmpty((Object)(fileObj = deterFileMap.get(rowIndex)))) {
                    throw new KDBizException("DecAdjRecordHRImportHelper.packBaseDataForDynamicObject fileObj is null ~~~ ");
                }
                DynamicObject adjFile = (DynamicObject)fileObj;
                SalaryStdMatchResultNew stdMachResult = null;
                if (org.apache.commons.collections4.MapUtils.isNotEmpty(resultMap) && ObjectUtils.isNotEmpty(resultMap.get(adjFile.getLong("id")))) {
                    stdMachResult = resultMap.get(adjFile.getLong("id")).get(record.getLong("standarditem.id"));
                }
                record.set("relpersonid", (Object)perObj.getLong("id"));
                DecAdjRecordHRImportHelper.supplyDecAdjRecord(deterFileMap, gradeBaseMap, rankBaseMap, tableAndCoeffObjs, record, rowIndex, stdMachResult, dynamicObject, adjFileService);
                DecAdjRecordHRImportHelper.supplyDecadjrelperson(rowIndex, record, perObj, adjFile, stdMachResult, jobLevelGradeBaseMap, adjPersonEntity, contrastIdToRecordMap);
            }
        }
    }

    private static void supplyDecAdjRecord(Map<Integer, Object> deterFileMap, Map<Integer, Object> gradeBaseMap, Map<Integer, Object> rankBaseMap, Map<String, Map<Long, DynamicObject>> tableAndCoeffObjs, DynamicObject record, Integer rowIndex, SalaryStdMatchResultNew stdMachResult, DynamicObject defaultCurrency, SWCDataServiceHelper adjFileService) {
        record.set("datasource", (Object)EventTypeEnum.SALARYADJRECORD_IMPORT.getCode());
        if (ObjectUtils.isNotEmpty((Object)deterFileMap.get(rowIndex))) {
            DynamicObject adjFile = (DynamicObject)deterFileMap.get(rowIndex);
            DynamicObject dy = adjFileService.generateEmptyDynamicObject();
            dy.set("id", (Object)adjFile.getLong("boid"));
            record.set("salaryadjfile", (Object)dy);
            record.set("salaryadjfilevid", (Object)adjFile);
        }
        if (org.apache.commons.collections4.MapUtils.isNotEmpty(gradeBaseMap) && ObjectUtils.isNotEmpty((Object)gradeBaseMap.get(rowIndex))) {
            record.set("grade", gradeBaseMap.get(rowIndex));
        }
        if (org.apache.commons.collections4.MapUtils.isNotEmpty(rankBaseMap) && ObjectUtils.isNotEmpty((Object)rankBaseMap.get(rowIndex))) {
            record.set("rank", rankBaseMap.get(rowIndex));
        }
        if (stdMachResult != null && org.apache.commons.collections4.MapUtils.isNotEmpty((Map)stdMachResult.getRangeData())) {
            Map rangeData = stdMachResult.getRangeData();
            String jsonRangeData = JSON.toJSONString((Object)rangeData);
            logger.info("salargrel rangeResultData is:{}", (Object)jsonRangeData);
            record.set("salargrel", (Object)jsonRangeData);
        }
        if (ObjectUtils.isNotEmpty((Object)defaultCurrency)) {
            int amtPrecision = defaultCurrency != null ? defaultCurrency.getInt("amtprecision") : 2;
            logger.info("amtPrecision is [{}]", (Object)amtPrecision);
            BigDecimal amount = record.getBigDecimal("amount");
            logger.info("amount is {}", (Object)amount);
            record.set("amount", (Object)amount.setScale(amtPrecision, 4));
            record.set("currency", (Object)defaultCurrency);
        }
        record.set("salarystd", null);
        record.set("coefficient", null);
        if (tableAndCoeffObjs != null && stdMachResult != null) {
            Map<Long, DynamicObject> stdTableDynMap = tableAndCoeffObjs.get("stdTableVid");
            Map<Long, DynamicObject> coefficientMap = tableAndCoeffObjs.get("coefficientVid");
            if (org.apache.commons.collections4.MapUtils.isNotEmpty(stdTableDynMap) && stdMachResult.getStdTableVid() != null && stdMachResult.getStdTableVid() > 0L) {
                DynamicObject stdTable = stdTableDynMap.get(stdMachResult.getStdTableVid());
                record.set("salarystd", (Object)stdTable);
                if (ObjectUtils.isEmpty((Object)record.get("frequency"))) {
                    record.set("frequency", stdTable.get("frequency"));
                }
            }
            if (org.apache.commons.collections4.MapUtils.isNotEmpty(coefficientMap) && stdMachResult.getCoefficientVid() != null && stdMachResult.getCoefficientVid() > 0L) {
                record.set("coefficient", (Object)coefficientMap.get(stdMachResult.getCoefficientVid()));
            }
        }
        if (StringUtils.isBlank((CharSequence)record.getString("needpush"))) {
            record.set("needpush", (Object)"1");
        }
        if (ObjectUtils.isNotEmpty((Object)record.get("actualamount")) && record.getBigDecimal("actualamount").compareTo(BigDecimal.ZERO) == 0) {
            record.set("actualamount", null);
        }
    }

    public static void recordVersionSlice(Map<Long, String> salaryadjrsnToType, Object[] objects) {
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        ArrayList<DecAdjSalaryEntity> decSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(objects.length);
        HashMap<Long, DynamicObject> idToPersonMap = new HashMap<Long, DynamicObject>(objects.length);
        ArrayList recordList = new ArrayList(objects.length);
        for (Object obj : objects) {
            DynamicObjectCollection personCollection = (DynamicObjectCollection)((HashMap)obj).get("hcdm_decadjrelperson");
            idToPersonMap.putAll(personCollection.stream().collect(Collectors.toMap(key -> key.getLong("id"), Function.identity(), (o1, o2) -> o2)));
            DynamicObjectCollection recordCollection = (DynamicObjectCollection)((HashMap)obj).get("hcdm_salaryadjrecord");
            recordList.addAll(recordCollection.stream().collect(Collectors.toList()));
        }
        Map<Long, List<DynamicObject>> fileIdToRecords = recordList.stream().filter(rec -> ObjectUtils.isNotEmpty((Object)rec.get("salaryadjfile"))).collect(Collectors.groupingBy(record -> record.getLong("salaryadjfile.id")));
        for (Map.Entry<Long, List<DynamicObject>> fileIdToRecord : fileIdToRecords.entrySet()) {
            List<DynamicObject> subrRecordList = fileIdToRecord.getValue();
            DecAdjSalaryEntity decAdjSalaryEntity = new DecAdjSalaryEntity();
            DecAdjRecordHRImportHelper.initDecAdjSalaryEntity(subrRecordList.get(0), salaryadjrsnToType, decAdjSalaryEntity);
            ArrayList<SalaryAdjRecordRelPersonDynEntity> salaryAdjRecordRelPersonDynEntities = new ArrayList<SalaryAdjRecordRelPersonDynEntity>(subrRecordList.size());
            DecAdjRecordHRImportHelper.setPersonRecordEntity(idToPersonMap, subrRecordList, salaryAdjRecordRelPersonDynEntities);
            decAdjSalaryEntity.setSalaryAdjRecordRelPersonDynEntities(salaryAdjRecordRelPersonDynEntities);
            decSalaryEntityList.add(decAdjSalaryEntity);
        }
        TXHandle txHandle = TX.requiresNew();
        String event = adjFileApplicationService.beginEvent(EventTypeEnum.SALARYADJRECORD_IMPORT.getCode());
        try {
            Map<String, String> decResultMap;
            if (CollectionUtils.isNotEmpty(decSalaryEntityList) && org.apache.commons.collections4.MapUtils.isNotEmpty(decResultMap = adjFileApplicationService.saveTimeVersionForBill(decSalaryEntityList, new DecAdjSalaryEvent(event)))) {
                logger.info(" DecAdjRecordHRImportHelper.recordVersionSlice decResultMap is error:{}", (Object)JSON.toJSONString(decResultMap));
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u8bb0\u5f55\u7248\u672c\u5207\u5272\u5f02\u5e38,\u8be6\u7ec6\u8bf7\u770b\u65e5\u5fd7\uff01", (String)"DecAdjRecordHRImportHelper_21", (String)"swc-hcdm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            try {
                logger.error("DecAdjRecordHRImportHelper.recordVersionSlice error:", (Throwable)ex);
                txHandle.markRollback();
                throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u8bb0\u5f55\u7248\u672c\u5207\u5272\u5f02\u5e38,\u8be6\u7ec6\u8bf7\u770b\u65e5\u5fd7\uff01", (String)"DecAdjRecordHRImportHelper_21", (String)"swc-hcdm-business", (Object[])new Object[0])), new Object[0]);
            }
            catch (Throwable throwable) {
                txHandle.close();
                adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
                throw throwable;
            }
        }
        txHandle.close();
        adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
    }

    private static void setPersonRecordEntity(Map<Long, DynamicObject> idToPersonMap, List<DynamicObject> recordList, List<SalaryAdjRecordRelPersonDynEntity> salaryAdjRecordRelPersonDynEntities) {
        for (DynamicObject record : recordList) {
            SalaryAdjRecordRelPersonDynEntity sarPerRecord = new SalaryAdjRecordRelPersonDynEntity();
            sarPerRecord.setRelpersonDyn(idToPersonMap.get(record.getLong("relpersonid")));
            sarPerRecord.setSalaryAdjRecord(record);
            salaryAdjRecordRelPersonDynEntities.add(sarPerRecord);
        }
    }

    private static void initDecAdjSalaryEntity(DynamicObject record, Map<Long, String> salaryadjrsnToType, DecAdjSalaryEntity decAdjSalaryEntity) {
        Long salaryadjrsnId = record.getLong("salaryadjrsn.id");
        logger.info(" salaryadjrsnId is :{}", (Object)salaryadjrsnId);
        String attributionType = salaryadjrsnToType.get(salaryadjrsnId);
        decAdjSalaryEntity.setSalaryadjfileId(Long.valueOf(record.getLong("salaryadjfile.id")));
        decAdjSalaryEntity.setSalaryAdjFileVId(Long.valueOf(record.getLong("salaryadjfilevid.id")));
        decAdjSalaryEntity.setBillType(AdjAttributionType.getByCode((String)attributionType));
        decAdjSalaryEntity.setBussinessId(Long.valueOf(System.currentTimeMillis()));
        decAdjSalaryEntity.setDatasource(EventTypeEnum.SALARYADJRECORD_IMPORT.getCode());
    }

    public static DynamicObject[] getAdjFileList(Set<String> adjFileNum, Set<Long> employeeIds, QFilter[] adjFilePermFilter) {
        if (CollectionUtils.isEmpty(adjFileNum) && CollectionUtils.isEmpty(employeeIds)) {
            return new DynamicObject[0];
        }
        Object[] allFilter = new QFilter[]{};
        if (CollectionUtils.isNotEmpty(adjFileNum)) {
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("number", "in", adjFileNum)});
        }
        if (CollectionUtils.isNotEmpty(employeeIds)) {
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("employee.id", "in", employeeIds)});
        }
        if (ArrayUtils.isNotEmpty((Object[])adjFilePermFilter)) {
            logger.info("import adjFileNumber permissionFilter:{}", (Object)JSON.toJSONString((Object)adjFilePermFilter));
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])adjFilePermFilter);
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{qFilter});
        logger.info("import adjFileNumber allFilter:{}", (Object)JSON.toJSONString((Object)allFilter));
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        return swcDataServiceHelper.query(adjfileInfoProp, (QFilter[])allFilter);
    }

    public static Map<Integer, Object> queryAdjFileByIds(Map<Integer, Object> rowIndexToFileIdMap) {
        HashMap<Integer, Object> fileMap = new HashMap<Integer, Object>(rowIndexToFileIdMap.size());
        Set ids = rowIndexToFileIdMap.values().stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj) && obj instanceof Long).map(obj -> (Long)obj).collect(Collectors.toSet());
        String selectProp = "id,boid,person,person.name,employee,employee.empnumber,country,org,empgroup,empposorgrel,empposorgrel.adminorg,depemp,assoadminorg,salaystructure";
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject[] dys = swcDataServiceHelper.query(selectProp, new QFilter[]{new QFilter("id", "in", ids)});
        Map<Long, List<DynamicObject>> dysMap = Arrays.stream(dys).collect(Collectors.groupingBy(obj -> obj.getLong("id")));
        for (Map.Entry<Integer, Object> subMap : rowIndexToFileIdMap.entrySet()) {
            List<DynamicObject> sbList;
            Object value = subMap.getValue();
            if (!(value instanceof Long) || (sbList = dysMap.get((Long)value)) == null) continue;
            fileMap.put(subMap.getKey(), sbList.get(0));
        }
        return fileMap;
    }

    private static List<DynamicObject> matchFileWithStatus(List<DynamicObject> fileList) {
        ArrayList<DynamicObject> matchObj = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(fileList)) {
            matchObj.addAll(fileList.stream().filter(file -> "C,D".contains(file.getString("status")) && "0,1,2".contains(file.getString("datastatus"))).collect(Collectors.toList()));
        }
        return matchObj;
    }

    public static void writeErrorLog(String errorMsg, Integer rowIndex, ImportLog importLog, ImportBillData billData) {
        if (importLog != null) {
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowIndex.intValue(), errorMsg);
        }
    }

    private static Map<String, Map<Long, String>> getGradeAndRankById(Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap) {
        DynamicObject[] rankDys;
        Map<Long, String> rankIdToNameMap;
        DynamicObject[] gradDys;
        Map<Long, String> gradIdToNameMap;
        HashMap<String, Map<Long, String>> gradeAndRankMap = new HashMap<String, Map<Long, String>>(16);
        if (org.apache.commons.collections4.MapUtils.isEmpty(resultMap)) {
            return gradeAndRankMap;
        }
        HashSet<Long> gradeIdset = new HashSet<Long>(16);
        HashSet<Long> rankIdset = new HashSet<Long>(16);
        for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> subMap : resultMap.entrySet()) {
            Map<Long, SalaryStdMatchResultNew> entry = subMap.getValue();
            for (Map.Entry<Long, SalaryStdMatchResultNew> ssubMap : entry.entrySet()) {
                Map rangeData = ssubMap.getValue().getRangeData();
                if (!org.apache.commons.collections4.MapUtils.isNotEmpty((Map)rangeData)) continue;
                gradeIdset.addAll(rangeData.keySet());
                if (!CollectionUtils.isNotEmpty(rangeData.values())) continue;
                rangeData.values().forEach(subList -> {
                    if (CollectionUtils.isNotEmpty((Collection)subList)) {
                        rankIdset.addAll(subList.stream().collect(Collectors.toSet()));
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(gradeIdset) && org.apache.commons.collections4.MapUtils.isNotEmpty(gradIdToNameMap = Arrays.stream(gradDys = DecAdjRecordHRImportHelper.queryGrade(gradeIdset)).filter(obj -> ObjectUtils.isNotEmpty((Object)obj)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name"), (dy1, dy2) -> dy1)))) {
            gradeAndRankMap.put("grade", gradIdToNameMap);
        }
        if (CollectionUtils.isNotEmpty(rankIdset) && org.apache.commons.collections4.MapUtils.isNotEmpty(rankIdToNameMap = Arrays.stream(rankDys = DecAdjRecordHRImportHelper.queryRank(rankIdset)).filter(obj -> ObjectUtils.isNotEmpty((Object)obj)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name"), (dy1, dy2) -> dy1)))) {
            gradeAndRankMap.put("rank", rankIdToNameMap);
        }
        return gradeAndRankMap;
    }

    private static Long gradeRankMatch(String type, String excelValue, Map<String, Map<Long, String>> rankAndGradeMaps, Map<Long, List<Long>> gradeRankKeys, Long gradeId) {
        Long matchId = null;
        if (MapUtils.isEmpty(rankAndGradeMaps) || MapUtils.isEmpty(rankAndGradeMaps.get(type)) || StringUtils.isBlank((CharSequence)excelValue)) {
            return matchId;
        }
        if ("grade".equals(type)) {
            if (MapUtils.isEmpty(gradeRankKeys) || org.apache.commons.collections.CollectionUtils.isEmpty(gradeRankKeys.keySet())) {
                return matchId;
            }
            Map<Long, String> gradeMap = rankAndGradeMaps.get(type);
            Set<Long> gradIds = gradeRankKeys.keySet();
            for (Map.Entry<Long, String> subMpa : gradeMap.entrySet()) {
                if (!excelValue.equals(subMpa.getValue()) || !gradIds.contains(subMpa.getKey())) continue;
                matchId = subMpa.getKey();
            }
        }
        if ("rank".equals(type) && MapUtils.isNotEmpty(gradeRankKeys) && org.apache.commons.collections.CollectionUtils.isNotEmpty(gradeRankKeys.values())) {
            Map<Long, String> rankMap = rankAndGradeMaps.get(type);
            List<Long> rankIds = gradeRankKeys.get(gradeId);
            for (Map.Entry<Long, String> subMpa : rankMap.entrySet()) {
                if (!excelValue.equals(subMpa.getValue()) || !rankIds.contains(subMpa.getKey())) continue;
                matchId = subMpa.getKey();
            }
        }
        return matchId;
    }

    public static String getStdRangeNameByRangeId(String rowIndex, Long stdTableId, boolean useRank, Map<Long, List<Long>> rangeData) {
        String rangeName = "";
        StdRangeNameFormatParam param = new StdRangeNameFormatParam();
        param.setUnionId(rowIndex);
        param.setRangeData(rangeData);
        param.setStdTableId(stdTableId);
        param.setUseRank(useRank);
        ArrayList<StdRangeNameFormatParam> params = new ArrayList<StdRangeNameFormatParam>(10);
        params.add(param);
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        Map<String, String> rowIndexRangeNameMap = service.getStdRangeNameByRangeId(params);
        if (org.apache.commons.collections4.MapUtils.isNotEmpty(rowIndexRangeNameMap)) {
            rangeName = rowIndexRangeNameMap.get(rowIndex);
            logger.info("amountStdRangeName = {}", (Object)rangeName);
        }
        logger.info(" final amountStdRangeName = {}", (Object)rangeName);
        return rangeName;
    }

    public static void supplyDecadjrelperson(Integer rowIndex, DynamicObject record, DynamicObject personObj, DynamicObject adjFile, SalaryStdMatchResultNew stdMachResult, Map<Integer, Object> jobLevelGradeBaseMap, MainEntityType adjPersonEntity, Map<Long, String> contrastIdToRecordMap) {
        Map levelGrade;
        if (StringUtils.isBlank((CharSequence)personObj.getString("personname"))) {
            personObj.set("personname", adjFile.get("person.name"));
        }
        personObj.set("empnumber", adjFile.get("employee.empnumber"));
        if (ObjectUtils.isEmpty((Object)personObj.get("country"))) {
            personObj.set("country", adjFile.get("country"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("org"))) {
            personObj.set("org", adjFile.get("org"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("empgroup"))) {
            personObj.set("empgroup", adjFile.get("empgroup"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("adminorg"))) {
            personObj.set("adminorg", adjFile.get("empposorgrel.adminorg"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("depemp"))) {
            personObj.set("depemp", adjFile.get("depemp"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("assoadminorg"))) {
            personObj.set("assoadminorg", adjFile.get("assoadminorg"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("salaystructure"))) {
            personObj.set("salaystructure", adjFile.get("salaystructure"));
        }
        if (ObjectUtils.isEmpty((Object)personObj.get("stdscm")) && stdMachResult != null && stdMachResult.getStdScmVid() > 0L) {
            personObj.set("stdscm", (Object)stdMachResult.getStdScmVid());
        }
        if (ObjectUtils.isNotEmpty((Object)personObj.get("joblevel")) && jobLevelGradeBaseMap != null && ObjectUtils.isNotEmpty((Object)jobLevelGradeBaseMap.get(rowIndex))) {
            levelGrade = (Map)jobLevelGradeBaseMap.get(rowIndex);
            personObj.set("joblevel", levelGrade.get("joblevel"));
        }
        if (ObjectUtils.isNotEmpty((Object)personObj.get("jobgrade")) && jobLevelGradeBaseMap != null && ObjectUtils.isNotEmpty((Object)jobLevelGradeBaseMap.get(rowIndex))) {
            levelGrade = (Map)jobLevelGradeBaseMap.get(rowIndex);
            personObj.set("jobgrade", levelGrade.get("jobgrade"));
        }
        if (stdMachResult != null && org.apache.commons.collections4.MapUtils.isNotEmpty((Map)stdMachResult.getPersonPropValue()) && (ObjectUtils.isNotEmpty((Object)record.get("grade")) || ObjectUtils.isNotEmpty((Object)record.get("rank")))) {
            DecAdjRecordHRImportHelper.assembleFourPersonInfo(personObj, stdMachResult.getPersonPropValue(), adjPersonEntity, contrastIdToRecordMap);
        }
    }

    public static void assembleFourPersonInfo(DynamicObject personObj, Map<Long, Object> conPropValMap, MainEntityType adjPersonEntity, Map<Long, String> contrastIdToRecordMap) {
        for (Map.Entry<Long, Object> subMap : conPropValMap.entrySet()) {
            List mulBaseBataIdList;
            Comparable<Long> obj;
            Long contrastId = subMap.getKey();
            Object value = subMap.getValue();
            String colName = contrastIdToRecordMap.get(contrastId);
            logger.info("contrastId:{},value:{},colName:{}", new Object[]{contrastId, value, colName});
            DynamicProperty property = adjPersonEntity.getProperty(colName);
            if (ObjectUtils.isNotEmpty((Object)personObj.get(colName))) continue;
            if (property instanceof BasedataProp) {
                obj = (Long)value;
                if (obj == null) continue;
                personObj.set(colName, (Object)obj);
                continue;
            }
            if (property instanceof DateProp) {
                obj = (Date)value;
                if (obj == null) continue;
                personObj.set(colName, (Object)obj);
                continue;
            }
            if (!(property instanceof MulBasedataProp) || CollectionUtils.isEmpty((Collection)(mulBaseBataIdList = (List)value)) || !colName.equals("schooltype")) continue;
            DynamicObjectCollection multiBaseDataDyColl = personObj.getDynamicObjectCollection("schooltype");
            for (Long multiBaseData : mulBaseBataIdList) {
                DynamicObject newMultiBaseData = new DynamicObject(multiBaseDataDyColl.getDynamicObjectType());
                newMultiBaseData.set("fbasedataid", (Object)multiBaseData);
                multiBaseDataDyColl.add((Object)newMultiBaseData);
                logger.info("schooltype id:{}", (Object)multiBaseData);
            }
            personObj.set("schooltype", (Object)multiBaseDataDyColl);
        }
    }

    public static DynamicObject[] querySalaryadjustrsn(Set<Long> salaryadjrsnIds) {
        SWCDataServiceHelper salaryAdjsrnService = new SWCDataServiceHelper("hsbs_salaryadjustrsn");
        return salaryAdjsrnService.query("id,attributiontype", new QFilter[]{new QFilter("id", "in", salaryadjrsnIds)});
    }

    public static DynamicObject queryRMBcurrency() {
        QFilter qFilter = new QFilter("id", "=", (Object)1L);
        qFilter.and("number", "=", (Object)"CNY");
        qFilter.and("issystem", "=", (Object)"1");
        qFilter.and("enable", "=", (Object)"1");
        SWCDataServiceHelper currencyService = new SWCDataServiceHelper("bd_currency");
        Object[] result = currencyService.query("id,amtprecision,number", new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])result)) {
            return result[0];
        }
        return null;
    }

    public static void getGradeOrRankObjs(String type, Map<Integer, Object> dataMap) {
        if (org.apache.commons.collections4.MapUtils.isNotEmpty(dataMap)) {
            DynamicObject[] dynas = null;
            if ("grade".equals(type)) {
                dynas = DecAdjRecordHRImportHelper.queryGrade(dataMap.values().stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj) && obj instanceof Long).map(obj -> (Long)obj).collect(Collectors.toSet()));
            }
            if ("rank".equals(type)) {
                dynas = DecAdjRecordHRImportHelper.queryRank(dataMap.values().stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj) && obj instanceof Long).map(obj -> (Long)obj).collect(Collectors.toSet()));
            }
            if (ArrayUtils.isEmpty(dynas)) {
                return;
            }
            Map idToObject = Arrays.stream(dynas).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (dy1, dy2) -> dy1));
            for (Map.Entry<Integer, Object> subMap : dataMap.entrySet()) {
                Object mapValue = subMap.getValue();
                Long value = 0L;
                if (mapValue instanceof Long) {
                    value = (Long)mapValue;
                }
                subMap.setValue(idToObject.get(value));
            }
        }
    }

    public static Map<String, Map<Long, DynamicObject>> getStdTableAndCoeff(Map<Long, Map<Long, SalaryStdMatchResultNew>> resultMap) {
        HashMap<String, Map<Long, DynamicObject>> result = new HashMap<String, Map<Long, DynamicObject>>(16);
        Map<String, Set<Long>> stdSourceVids = AdjBillEntryImpHelper.getStdSourceVids(resultMap);
        Map<Long, DynamicObject> stdTableDynMap = AdjBillEntryImpHelper.getStdTableInfo(stdSourceVids.get("stdTableVid"));
        Map<Long, DynamicObject> coefficientMap = AdjBillEntryImpHelper.getCoefficientInfo(stdSourceVids.get("coefficientVid"));
        result.put("stdTableVid", stdTableDynMap);
        result.put("coefficientVid", coefficientMap);
        return result;
    }

    public static DynamicObject[] queryGrade(Set<Long> gradeIdset) {
        HRBaseServiceHelper gradeHelper = new HRBaseServiceHelper("hcdm_salarygradeentrytodb");
        return gradeHelper.query("id,name,number", new QFilter[]{new QFilter("id", "in", gradeIdset)});
    }

    public static DynamicObject[] queryRank(Set<Long> rankIdset) {
        HRBaseServiceHelper rankHelper = new HRBaseServiceHelper("hcdm_rankgradeentrytodb");
        return rankHelper.query("id,name,number", new QFilter[]{new QFilter("id", "in", rankIdset)});
    }

    private static Map<Long, List<DynamicObject>> queryEmpjobrel(Set<Long> employeeIds) {
        DynamicObject[] empjobrelObjArr = new SWCDataServiceHelper("hrpi_empjobrel").query("id,joblevel,jobgrade,employee,joblevel.name,jobgrade.name,startdate,enddate", new QFilter[]{new QFilter("employee.id", "in", employeeIds), new QFilter("businessstatus", "=", (Object)"1")});
        Map<Long, List<DynamicObject>> empjobrelMap = Arrays.stream(empjobrelObjArr).collect(Collectors.groupingBy(adjFile -> adjFile.getLong("employee.id")));
        return empjobrelMap;
    }

    private static Map<Long, String> getContrastIdToRecord() {
        Map<String, String> detailToRecord = AdjDetailFieldMappingHelper.getAdjDetailFieldToRecordField();
        Map<String, Long> detailToContrastId = AdjDetailFieldMappingHelper.getAdjDetailFieldToContrastCfg();
        HashMap<Long, String> recordToContrastId = new HashMap<Long, String>(detailToContrastId.size());
        for (Map.Entry<String, Long> subMap : detailToContrastId.entrySet()) {
            if (detailToRecord.get(subMap.getKey()) == null) continue;
            recordToContrastId.put(subMap.getValue(), detailToRecord.get(subMap.getKey()));
        }
        return recordToContrastId;
    }
}

