/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.decadjrecordrevision;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.DecAdjSalaryEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.SalaryAdjRecordRelPersonDynEntity;
import kd.sdk.swc.hcdm.common.Pair;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjfile.DecAdjSalaryEvent;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DecAdjRecordRevisionHelper {
    private static final Log logger = LogFactory.getLog(DecAdjRecordRevisionHelper.class);
    private static final AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final CloneUtils cloneUtils = new CloneUtils(false, true);
    private static final HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hcdm_salaryadjrecord");
    private static final HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcdm_decadjrelperson");
    private static final HRBaseServiceHelper revisionHelper = new HRBaseServiceHelper("hcdm_revisionrecord");

    public static Map<Long, Map<String, DynamicObject>> getRevisionDyByIds(Object[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return ImmutableMap.of();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)ids.length);
        HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hcdm_salaryadjrecord");
        Object[] recordDys = recordHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)ids)});
        if (ArrayUtils.isEmpty((Object[])recordDys)) {
            return result;
        }
        Map<Long, Long> recordIdToPersonInfoIdMap = Arrays.stream(recordDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("relpersonid"), (o1, o2) -> o2));
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcdm_decadjrelperson");
        Object[] personDys = personHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", recordIdToPersonInfoIdMap.values())});
        Map<Object, Object> personMap = Maps.newHashMap();
        if (!ArrayUtils.isEmpty((Object[])personDys)) {
            personMap = Arrays.stream(personDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
        }
        for (Object recordDy : recordDys) {
            long recordId = recordDy.getLong("id");
            Long personId = recordIdToPersonInfoIdMap.get(recordId);
            DynamicObject personDy = (DynamicObject)personMap.get(personId);
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("hcdm_salaryadjrecord", recordDy);
            map.put("hcdm_decadjrelperson", personDy);
            result.put(recordId, map);
        }
        return result;
    }

    public static Map<String, DynamicObject> getRevisionDyById(Object id) {
        Map<Long, Map<String, DynamicObject>> result = DecAdjRecordRevisionHelper.getRevisionDyByIds(new Object[]{id});
        if (!CollectionUtils.isEmpty(result)) {
            return result.get(id);
        }
        return ImmutableMap.of();
    }

    public static Map<String, DynamicObject> getReviseFieldMapByDataSource() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_revisefieldmap");
        DynamicObject[] results = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("datasource", "!=", (Object)"")});
        return Arrays.stream(results).collect(Collectors.toMap(dy -> dy.getString("datasource"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<String, DynamicObject> getFieldMapByType(List<String> typeList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_fieldmapbytype");
        DynamicObject[] results = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("type", "in", typeList)});
        return Arrays.stream(results).collect(Collectors.toMap(dy -> dy.getString("type"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<Long, Pair<String, Boolean>> getFieldContrastMap() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_fieldcontrastmap");
        DynamicObject result = helper.loadDynamicObject(new QFilter[]{new QFilter("type", "=", (Object)"1")});
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (Objects.isNull(result)) {
            return map;
        }
        DynamicObjectCollection entryDys = result.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDy : entryDys) {
            map.put(entryDy.getLong("contrastprop.id"), new Pair((Object)entryDy.getString("fieldkey"), (Object)entryDy.getBoolean("isperprop")));
        }
        return map;
    }

    public static boolean isDecType(DynamicObject revisionDy) {
        String salaryAdjType = revisionDy.getString("salaryadjrsn_r.attributiontype");
        return AdjAttributionType.DECATTRTYPE.getCode().equals(salaryAdjType);
    }

    public static boolean isAdjType(DynamicObject revisionDy) {
        String salaryAdjType = revisionDy.getString("salaryadjrsn_r.attributiontype");
        return AdjAttributionType.ADJATTRTYPE.getCode().equals(salaryAdjType);
    }

    public static Map<Long, DynamicObject> getCurrentVersionStdScmsByBoid(Set<Long> stdScmBoidSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_stdscm");
        Object[] dynamicObjects = helper.query("id,sourcevid,entryentity,entryentity.salstructurent,entryentity.standarditem", new QFilter[]{new QFilter("id", "in", stdScmBoidSet)});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<Long, DynamicObject> getStdScmMapByVidSet(Set<Long> vids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_stdscm");
        QFilter idFilter = new QFilter("id", "in", vids);
        Object[] stdScmDys = serviceHelper.query("id,name,salaystructure,entryentity.salstructurent,entryentity.standarditem,entryentity.excesscontrol,entryentity.ismatchgraderank,entryentity.matchstrategy", new QFilter[]{idFilter});
        if (ArrayUtils.isEmpty((Object[])stdScmDys)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(stdScmDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static Map<String, List<String>> getInvalidAdjApprBillMapByDepEmpId(Set<Long> depEmpIds) {
        return CommonHcdmBizHelper.getInvalidAdjApprBillByDepEmpIdForRevision(depEmpIds);
    }

    public static Map<String, List<String>> getInvalidAdjRecordMapByDepEmpId(Set<Long> depEmpIds) {
        Map<Long, List<DynamicObject>> invalidAdjRecords = CommonHcdmBizHelper.getInvalidAdjRecordByDepEmpId(depEmpIds);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, List<DynamicObject>> entry : invalidAdjRecords.entrySet()) {
            Long depEmpId = entry.getKey();
            List<DynamicObject> records = entry.getValue();
            for (DynamicObject record : records) {
                long itemId = record.getLong("standarditem.id");
                String key = String.valueOf(depEmpId) + String.valueOf(itemId);
                List strings = result.computeIfAbsent(key, obj -> Lists.newArrayList());
                strings.add(record.getString("id"));
            }
        }
        return result;
    }

    public static Map<String, List<String>> getInvalidCandSetSalApplMapByDepEmpId(Set<Long> depEmpIds) {
        Map<Long, List<DynamicObject>> invalidCandSetSalAppls = CommonHcdmBizHelper.getInvalidCandSetSalAppl(depEmpIds);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, List<DynamicObject>> entry : invalidCandSetSalAppls.entrySet()) {
            Long depEmpId = entry.getKey();
            List<DynamicObject> candSetSalAppldDys = entry.getValue();
            for (DynamicObject candSetSalAppldDy : candSetSalAppldDys) {
                String billNo = candSetSalAppldDy.getString("billno");
                DynamicObjectCollection candSetSalPersonEntryEntity = candSetSalAppldDy.getDynamicObjectCollection("candsetsalperson");
                for (DynamicObject personDy : candSetSalPersonEntryEntity) {
                    DynamicObjectCollection records = personDy.getDynamicObjectCollection("persetsalrec");
                    for (DynamicObject record : records) {
                        long itemId = record.getLong("standarditem.id");
                        String key = String.valueOf(depEmpId) + String.valueOf(itemId);
                        List billNos = result.computeIfAbsent(key, obj -> Lists.newArrayList());
                        billNos.add(billNo);
                    }
                }
            }
        }
        return result;
    }

    public static Map<Long, DynamicObject> getDecAdjPersonInfoByRecord(List<DynamicObject> recordDys) {
        if (CollectionUtils.isEmpty(recordDys)) {
            return ImmutableMap.of();
        }
        Set relPersonIdSet = recordDys.stream().map(dy -> dy.getLong("relpersonid")).collect(Collectors.toSet());
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcdm_decadjrelperson");
        QFilter qFilter = new QFilter("id", "in", relPersonIdSet);
        DynamicObject[] personDys = personHelper.query("id,assoadminorg", new QFilter[]{qFilter});
        return Arrays.stream(personDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    public static String getKeyOfEntityFromDB(String key, String markStr) {
        if (Strings.isNullOrEmpty((String)key)) {
            return "";
        }
        int index = key.lastIndexOf(markStr);
        if (index != -1) {
            return key.substring(0, index);
        }
        return "";
    }

    public static Map<String, Long> getAdjFileBoidAndItemIdMap(List<Pair<Long, Long>> adjFileBoidAndItemIdList) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(adjFileBoidAndItemIdList)) {
            return result;
        }
        HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hcdm_salaryadjrecord");
        Set adjFileBoidSet = adjFileBoidAndItemIdList.stream().map(pair -> (Long)pair.getKey()).collect(Collectors.toSet());
        QFilter salaryAdjFileBoidFilter = new QFilter("salaryadjfile.id", "in", adjFileBoidSet);
        Set itemIdSet = adjFileBoidAndItemIdList.stream().map(pair -> (Long)pair.getValue()).collect(Collectors.toSet());
        QFilter itemIdFilter = new QFilter("standarditem.id", "in", itemIdSet);
        Object[] recordDys = recordHelper.query("id,boid,salaryadjfile,standarditem", new QFilter[]{salaryAdjFileBoidFilter, itemIdFilter});
        if (ArrayUtils.isEmpty((Object[])recordDys)) {
            return result;
        }
        Arrays.stream(recordDys).forEach(dy -> {
            String key = String.valueOf(dy.getLong("salaryadjfile.id")) + String.valueOf(dy.getLong("standarditem.id"));
            result.put(key, dy.getLong("boid"));
        });
        return result;
    }

    public static Set<String> getPerProps() {
        Map<Long, Pair<String, Boolean>> fieldContrastMap = DecAdjRecordRevisionHelper.getFieldContrastMap();
        HashSet perProps = Sets.newHashSetWithExpectedSize((int)fieldContrastMap.size());
        for (Pair<String, Boolean> value : fieldContrastMap.values()) {
            if (!((Boolean)value.getValue()).booleanValue()) continue;
            perProps.add(value.getKey());
        }
        return perProps;
    }

    public static Map<Long, DynamicObject> getAdjFilesByBoIds(Set<Long> boids) {
        HRBaseServiceHelper adjFileHelper = new HRBaseServiceHelper("hcdm_adjfileinfo");
        QFilter idFilter = new QFilter("id", "in", boids);
        Object[] dynamicObjects = adjFileHelper.query("id,status", new QFilter[]{idFilter});
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
        }
        return ImmutableMap.of();
    }

    public static Map<Long, Map<Long, Boolean>> getItemUseRankFlag(List<DynamicObject> revisionEntryDys) {
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)revisionEntryDys.size());
        for (DynamicObject entry : revisionEntryDys) {
            long stdId = entry.getLong("salarystd_r.id");
            long itemId = entry.getLong("standarditem_r.id");
            if (stdId <= 0L || itemId <= 0L) continue;
            List itemIds = stdItemMap.computeIfAbsent(stdId, v1 -> Lists.newArrayList());
            itemIds.add(itemId);
        }
        return service.getSalaryItemUseRankFlag(stdItemMap);
    }

    public static boolean checkItemUseRank(DynamicObject revisionEntry, Map<Long, Map<Long, Boolean>> itemUseRankFlag) {
        Map<Long, Boolean> flagMap;
        long stdId = revisionEntry.getLong("salarystd_r.id");
        long itemId = revisionEntry.getLong("standarditem_r.id");
        boolean userRank = false;
        if (stdId > 0L && itemId > 0L && (flagMap = itemUseRankFlag.get(stdId)) != null && flagMap.get(itemId).booleanValue()) {
            userRank = true;
        }
        return userRank;
    }

    public static ListShowParameter partAddnew() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("fixedadjap");
        showParameter.setFormId("hsbp_nosearch_list_inh");
        showParameter.setBillFormId("hcdm_salaryadjrecordview");
        showParameter.setSendToClient(true);
        showParameter.setMultiSelect(false);
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        QFilter filter = new QFilter("id", "in", null);
        filterParams.setQFilters(Collections.singletonList(filter));
        return showParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMutexLock(String entityId, String id, String groupId, String op) {
        DataMutex dataMutex = DataMutex.create();
        try {
            Map lockInfo = dataMutex.getLockInfo(id, groupId, entityId);
            if (null != lockInfo && !lockInfo.isEmpty()) {
                logger.error("addMutexLock lockInfo is {} ", (Object)lockInfo);
                boolean bl = false;
                return bl;
            }
            boolean bl = dataMutex.require(id, groupId, entityId, op);
            return bl;
        }
        catch (Exception e) {
            logger.error("{} DecAdjRecordRevisionHelper addMutexLock error ", (Object)groupId, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                logger.error("DecAdjRecordRevisionHelper close dataMutex error ", (Throwable)e);
            }
        }
    }

    public static Long getAdjFileBoId(Object id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_adjfileinfo");
        DynamicObject fileDy = helper.queryOne("id,boid", (Object)Long.parseLong(String.valueOf(id)));
        return Objects.isNull(fileDy) ? 0L : fileDy.getLong("boid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserNameWhenRequireMutexFail(String entityId, String id, String groupId, String op) {
        DataMutex dataMutex = DataMutex.create();
        try {
            Map lockInfo = dataMutex.getLockInfo(id, groupId, entityId);
            if (null != lockInfo && !lockInfo.isEmpty()) {
                logger.error("getUserNameWhenRequireMutexFail lockInfo is {} ", (Object)lockInfo);
                String userId = (String)lockInfo.get("userid");
                Map userInfoByID = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId));
                String string = CollectionUtils.isEmpty((Map)userInfoByID) ? "" : (String)userInfoByID.get("name");
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            logger.error("{} DecAdjRecordRevisionHelper getUserNameWhenRequireMutexFail addMutexLock error ", (Object)groupId, (Object)e);
            String string = "";
            return string;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                logger.error("DecAdjRecordRevisionHelper getUserNameWhenRequireMutexFail close dataMutex error ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMutexLock(String entityId, Collection<Long> ids, String op) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DataMutex dataMutex = DataMutex.create();
        try {
            for (Long id : ids) {
                dataMutex.release(String.valueOf(id), entityId, op);
            }
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                logger.error("DecAdjRecordRevisionHelper removeMutexLock dataMutex close error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> saveAddNewRevisionData(DynamicObject[] dynamicObjects) {
        HashMap result = Maps.newHashMap();
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            ArrayList<DecAdjSalaryEntity> decAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
            DecAdjSalaryEntity decAdjSalaryEntity = new DecAdjSalaryEntity();
            ArrayList<SalaryAdjRecordRelPersonDynEntity> salaryAdjRecordRelPersonDynEntities = new ArrayList<SalaryAdjRecordRelPersonDynEntity>(10);
            decAdjSalaryEntity.setSalaryAdjRecordRelPersonDynEntities(salaryAdjRecordRelPersonDynEntities);
            decAdjSalaryEntityList.add(decAdjSalaryEntity);
            decAdjSalaryEntity.setBussinessId(null);
            DynamicObjectCollection entryDys = dynamicObjects[0].getDynamicObjectCollection("revisionentry");
            for (int i = 0; i < entryDys.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)entryDys.get(i);
                DynamicObject emptyRecordDy = recordHelper.generateEmptyDynamicObject();
                DynamicObject emptyPersonDy = personHelper.generateEmptyDynamicObject();
                DynamicObjectType dynamicObjectType = entryDy.getDynamicObjectType();
                Map fields = ((EntryType)dynamicObjectType).getFields();
                for (Map.Entry entry : fields.entrySet()) {
                    DynamicProperty property;
                    String key = (String)entry.getKey();
                    if (key.endsWith("_p")) {
                        String keyOfPersonDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB(key, "_p");
                        property = emptyPersonDy.getDynamicObjectType().getProperty(keyOfPersonDy);
                        if (property != null) {
                            emptyPersonDy.set(keyOfPersonDy, entryDy.get(key));
                        }
                    }
                    if (!key.endsWith("_r")) continue;
                    String keyOfRecordDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB(key, "_r");
                    property = emptyRecordDy.getDynamicObjectType().getProperty(keyOfRecordDy);
                    if (property == null) continue;
                    emptyRecordDy.set(keyOfRecordDy, entryDy.get(key));
                }
                emptyRecordDy.set("status", (Object)"C");
                emptyRecordDy.set("enable", (Object)"1");
                emptyRecordDy.set("datasource", (Object)EventTypeEnum.SALARYADJRECORD_REVISION_ADDNEW.getCode());
                decAdjSalaryEntity.setSalaryadjfileId(Long.valueOf(emptyRecordDy.getLong("salaryadjfile.id")));
                decAdjSalaryEntity.setSalaryAdjFileVId(Long.valueOf(emptyRecordDy.getLong("salaryadjfilevid.id")));
                decAdjSalaryEntity.setBillType(AdjAttributionType.getByCode((String)emptyRecordDy.getString("salaryadjrsn.attributiontype")));
                SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity = new SalaryAdjRecordRelPersonDynEntity();
                salaryAdjRecordRelPersonDynEntity.setSalaryAdjRecord(emptyRecordDy);
                salaryAdjRecordRelPersonDynEntity.setRelpersonDyn(emptyPersonDy);
                salaryAdjRecordRelPersonDynEntities.add(salaryAdjRecordRelPersonDynEntity);
            }
            String event = adjFileApplicationService.beginEvent(EventTypeEnum.SALARYADJRECORD_REVISION_ADDNEW.getCode());
            try (TXHandle required = TX.requiresNew();){
                logger.error("saveAddNewRevisionData saveTimeVersionForRevisionAddNew begin");
                adjFileApplicationService.saveTimeVersionForRevisionAddNew(decAdjSalaryEntityList, new DecAdjSalaryEvent(event));
                logger.error("saveAddNewRevisionData saveTimeVersionForRevisionAddNew finish");
            }
            adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
            logger.error("saveAddNewRevisionData endEvent finish");
            result.put("success", Boolean.TRUE);
            result.put("message", "");
            return result;
        }
        logger.error("saveAddNewRevisionData dynamicObjects is empty");
        result.put("success", Boolean.TRUE);
        result.put("message", ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\u3002", (String)"DecAdjRecordRevisionHelper_01", (String)"swc-hcdm-business", (Object[])new Object[0]));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> saveRevisionData(DynamicObject[] dynamicObjects) {
        HashMap result = Maps.newHashMap();
        HashSet recordIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList adjFileBoidAndItemIdList = Lists.newArrayListWithExpectedSize((int)10);
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            ArrayList addNewRecordDataList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
            ArrayList updateRecordDataList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
            ArrayList updatePersonDataList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
            List<Object> revisionRecordList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
            DynamicObjectCollection entryDys = dynamicObjects[0].getDynamicObjectCollection("revisionentry");
            long[] personDataIds = DB.genLongIds((String)"T_HCDM_DECADJRELPERSON", (int)entryDys.size());
            for (int i = 0; i < entryDys.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)entryDys.get(i);
                DynamicObject emptyRecordDy = recordHelper.generateEmptyDynamicObject();
                DynamicObject emptyPersonDy = personHelper.generateEmptyDynamicObject();
                DynamicObjectType dynamicObjectType = entryDy.getDynamicObjectType();
                Map fields = ((EntryType)dynamicObjectType).getFields();
                for (Map.Entry entry : fields.entrySet()) {
                    DynamicProperty property;
                    String key = (String)entry.getKey();
                    if (key.endsWith("_p")) {
                        String keyOfPersonDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB(key, "_p");
                        property = emptyPersonDy.getDynamicObjectType().getProperty(keyOfPersonDy);
                        if (property != null) {
                            emptyPersonDy.set(keyOfPersonDy, entryDy.get(key));
                        }
                    }
                    if (!key.endsWith("_r")) continue;
                    String keyOfRecordDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB(key, "_r");
                    property = emptyRecordDy.getDynamicObjectType().getProperty(keyOfRecordDy);
                    if (property == null) continue;
                    emptyRecordDy.set(keyOfRecordDy, entryDy.get(key));
                }
                emptyPersonDy.set("id", (Object)personDataIds[i]);
                emptyRecordDy.set("relpersonid", (Object)personDataIds[i]);
                adjFileBoidAndItemIdList.add(new Pair((Object)entryDy.getLong("salaryadjfile_r.id"), (Object)entryDy.getLong("standarditem_r.id")));
                if (emptyRecordDy.getLong("standarditem.id") != entryDy.getLong("thisrecord.standarditem.id")) {
                    emptyRecordDy.set("datasource", (Object)EventTypeEnum.SALARYADJRECORD_REVISION.getCode());
                }
                emptyRecordDy.set("status", (Object)"C");
                emptyRecordDy.set("enable", (Object)"1");
                updateRecordDataList.add(emptyRecordDy);
                updatePersonDataList.add(emptyPersonDy);
                Long thisRecordId = entryDy.getLong("thisrecord.id");
                recordIdSet.add(thisRecordId);
                Long thisPersonId = entryDy.getLong("thisperson.id");
                personIdSet.add(thisPersonId);
            }
            DecAdjRecordRevisionHelper.completeFixeditem(updateRecordDataList);
            DecAdjRecordRevisionHelper.completeRelPersonFieldBo(updatePersonDataList);
            Map<String, Long> adjFileBoidAndItemIdMap = DecAdjRecordRevisionHelper.getAdjFileBoidAndItemIdMap(adjFileBoidAndItemIdList);
            for (int i = 0; i < updateRecordDataList.size(); ++i) {
                DynamicObject updateRecordData = (DynamicObject)updateRecordDataList.get(i);
                String key = String.valueOf(updateRecordData.getLong("salaryadjfile.id")) + String.valueOf(updateRecordData.getLong("standarditem.id"));
                Long boid = adjFileBoidAndItemIdMap.get(key);
                if (boid != null && boid != 0L) {
                    updateRecordData.set("boid", (Object)boid);
                    continue;
                }
                Date bsled = updateRecordData.getDate("bsled");
                if (bsled.compareTo(SWCDateTimeUtils.getMaxBsled()) < 0) {
                    DynamicObject addNewRecordData = (DynamicObject)cloneUtils.clone((IDataEntityBase)updateRecordData);
                    addNewRecordData.set("bsled", (Object)SWCDateTimeUtils.getMaxBsled());
                    addNewRecordDataList.add(addNewRecordData);
                    updateRecordData.set("bsed", (Object)SWCDateTimeUtils.addDay((Date)bsled, (long)1L));
                    updateRecordData.set("bsled", (Object)SWCDateTimeUtils.getMaxBsled());
                    updateRecordData.set("enable", (Object)"0");
                    continue;
                }
                if (bsled.compareTo(SWCDateTimeUtils.getMaxBsled()) != 0) continue;
                DynamicObject recordData = (DynamicObject)updateRecordDataList.remove(i);
                addNewRecordDataList.add(recordData);
            }
            adjFileApplicationService.completeVersionWhenRevise(updateRecordDataList);
            DynamicObject[] recordDys = recordHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)recordIdSet)});
            Map<Long, DynamicObject> recordDysMap = Arrays.stream(recordDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
            DynamicObject[] personDys = personHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)personIdSet)});
            Map<Long, DynamicObject> personDysMap = Arrays.stream(personDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
            revisionRecordList = DecAdjRecordRevisionHelper.saveRevisionRecord(recordDysMap, personDysMap, dynamicObjects, revisionHelper);
            ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
            String event = adjFileApplicationService.beginEvent(EventTypeEnum.SALARYADJRECORD_REVISION.getCode());
            Long eventPkId = adjFileApplicationService.genEventDyn(event, eventDynList, EventTypeEnum.SALARYADJRECORD_REVISION.getCode(), "0");
            try (TXHandle required = TX.requiresNew();){
                logger.error("saveRevisionData TX begin");
                if (!CollectionUtils.isEmpty(eventDynList)) {
                    adjFileApplicationService.getAdjFileDomainService().saveDecAdjEvent(eventDynList);
                }
                if (!CollectionUtils.isEmpty((Collection)addNewRecordDataList)) {
                    HisResponse addNewResponse = BaseDataHisHelper.saveTimeVersion((DynamicObject[])addNewRecordDataList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
                    if (EnumResponseCode.SUCCESS.getCode().equals(addNewResponse.getCode())) {
                        DynamicObject[] newHisDys = ((VersionChangeRespData)addNewResponse.getData()).getNewDynamicObjects();
                        Map<String, Long> newBoIdMap = Arrays.stream(newHisDys).collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("salaryadjfile.id")) + String.valueOf(dy.getLong("standarditem.id")), dy -> dy.getLong("boid"), (o1, o2) -> o2));
                        for (DynamicObject updateRecordData : updateRecordDataList) {
                            String combineKey = String.valueOf(updateRecordData.getLong("salaryadjfile.id")) + String.valueOf(updateRecordData.getLong("standarditem.id"));
                            Long newBoId = newBoIdMap.get(combineKey);
                            updateRecordData.set("boid", (Object)newBoId);
                        }
                    } else {
                        throw new KDBizException(addNewResponse.getErrorMessage());
                    }
                }
                BaseDataHisHelper.saveTimeVersion((DynamicObject[])updateRecordDataList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
                adjFileApplicationService.getAdjFileDomainService().saveRelPerson(updatePersonDataList);
                ArrayList record = Lists.newArrayListWithExpectedSize((int)updateRecordDataList.size());
                record.addAll(updateRecordDataList);
                SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, updatePersonDataList);
                revisionHelper.save(revisionRecordList.toArray(new DynamicObject[dynamicObjects.length]));
                logger.error("saveRevisionData TX finish");
            }
            adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
            logger.error("saveRevisionData endEvent finish");
            result.put("success", Boolean.TRUE);
            result.put("message", "");
            return result;
        }
        logger.error("saveRevisionData dynamicObjects is empty");
        result.put("success", Boolean.TRUE);
        result.put("message", ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\u3002", (String)"DecAdjRecordRevisionHelper_01", (String)"swc-hcdm-business", (Object[])new Object[0]));
        return result;
    }

    private static List<DynamicObject> saveRevisionRecord(Map<Long, DynamicObject> recordDysMap, Map<Long, DynamicObject> personDysMap, DynamicObject[] dynamicObjects, HRBaseServiceHelper revisionHelper) {
        ArrayList revisionRecordList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryDys = dynamicObject.getDynamicObjectCollection("revisionentry");
            for (int i = 0; i < entryDys.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)entryDys.get(i);
                long thisRecordId = entryDy.getLong("thisrecord.id");
                long thisPersonId = entryDy.getLong("thisperson.id");
                DynamicObject revisionRecord = DecAdjRecordRevisionHelper.saveRevisionRecord(entryDy, recordDysMap.get(thisRecordId), personDysMap.get(thisPersonId), revisionHelper);
                revisionRecordList.add(revisionRecord);
            }
        }
        return revisionRecordList;
    }

    private static DynamicObject saveRevisionRecord(DynamicObject entryDy, DynamicObject thisRecordDy, DynamicObject thisPersonDy, HRBaseServiceHelper revisionHelper) {
        DynamicObject revisionRecordObj = revisionHelper.generateEmptyDynamicObject();
        DynamicObjectCollection entryEntity = revisionRecordObj.getDynamicObjectCollection("entryentity");
        DynamicObject afterRevisionEntry = entryEntity.addNew();
        DynamicObjectType dynamicObjectType = entryDy.getDynamicObjectType();
        Map fields = ((EntryType)dynamicObjectType).getFields();
        for (Map.Entry entry : fields.entrySet()) {
            DynamicProperty afterProperty;
            DynamicProperty property;
            String key = (String)entry.getKey();
            if (key.endsWith("_p")) {
                String keyOfPersonDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB(key, "_p");
                property = revisionRecordObj.getDynamicObjectType().getProperty(keyOfPersonDy);
                if (property != null && thisPersonDy != null) {
                    if (property instanceof MulBasedataProp) {
                        DecAdjRecordRevisionHelper.setMulBaseData(revisionRecordObj, keyOfPersonDy, thisPersonDy);
                    } else {
                        revisionRecordObj.set(keyOfPersonDy, thisPersonDy.get(keyOfPersonDy));
                    }
                }
                if ((afterProperty = afterRevisionEntry.getDynamicObjectType().getProperty(keyOfPersonDy + "after")) != null) {
                    afterRevisionEntry.set(keyOfPersonDy + "after", entryDy.get(key));
                }
            }
            if (!key.endsWith("_r")) continue;
            String keyOfRecordDy = DecAdjRecordRevisionHelper.getKeyOfEntityFromDB(key, "_r");
            property = revisionRecordObj.getDynamicObjectType().getProperty(keyOfRecordDy);
            if (property != null && thisRecordDy != null) {
                revisionRecordObj.set(keyOfRecordDy, thisRecordDy.get(keyOfRecordDy));
            }
            if ((afterProperty = afterRevisionEntry.getDynamicObjectType().getProperty(keyOfRecordDy + "after")) == null) continue;
            afterRevisionEntry.set(keyOfRecordDy + "after", entryDy.get(key));
        }
        revisionRecordObj.set("revreason", (Object)entryDy.getString("revreason"));
        return revisionRecordObj;
    }

    private static void setMulBaseData(DynamicObject revisionRecordObj, String keyOfPersonDy, DynamicObject thisPersonDy) {
        DynamicObjectCollection oldMulBaseDataCol = thisPersonDy.getDynamicObjectCollection(keyOfPersonDy);
        if (!CollectionUtils.isEmpty((Collection)oldMulBaseDataCol)) {
            DynamicObjectCollection newMulBaseDataCol = new DynamicObjectCollection();
            for (DynamicObject oldObject : oldMulBaseDataCol) {
                DynamicObject tempDy = new DynamicObject(oldObject.getDynamicObjectType());
                tempDy.set("fbasedataid", (Object)oldObject.getDynamicObject("fbasedataid"));
                newMulBaseDataCol.add((Object)tempDy);
            }
            revisionRecordObj.set(keyOfPersonDy, (Object)newMulBaseDataCol);
        }
    }

    private static void completeFixeditem(List<DynamicObject> updateRecordDataList) {
        Set<Long> itemIdSet = updateRecordDataList.stream().filter(dy -> dy.getLong("standarditem.id") > 0L).map(dy -> dy.getLong("standarditem.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> standardItemMap = SalaryAdjFileServiceHelper.getStandardItemMap("id,fixeditem", itemIdSet);
        for (DynamicObject recordDy : updateRecordDataList) {
            DynamicObject itemDy = standardItemMap.get(recordDy.getLong("standarditem.id"));
            if (itemDy == null) continue;
            recordDy.set("fixeditem", (Object)itemDy.getString("fixeditem"));
        }
    }

    private static void completeRelPersonFieldBo(List<DynamicObject> updatePersonDataList) {
        HashSet adminorgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet stdpositionIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet projectteamIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject relpersonDyn : updatePersonDataList) {
            adminorgIds.add(relpersonDyn.getLong("company.id"));
            adminorgIds.add(relpersonDyn.getLong("adminorg.id"));
            adminorgIds.add(relpersonDyn.getLong("assoadminorg.id"));
            positionIds.add(relpersonDyn.getLong("position.id"));
            stdpositionIds.add(relpersonDyn.getLong("stdposition.id"));
            projectteamIds.add(relpersonDyn.getLong("projectteam.id"));
        }
        Map adminorgBoMap = BaseDataHisHelper.getCurrentOfVersion((String)"haos_adminorghr", (Collection)adminorgIds);
        DecAdjRecordRevisionHelper.setBo(updatePersonDataList, adminorgBoMap, "haos_adminorghr", "company", "companybo");
        DecAdjRecordRevisionHelper.setBo(updatePersonDataList, adminorgBoMap, "haos_adminorghr", "adminorg", "adminorgbo");
        DecAdjRecordRevisionHelper.setBo(updatePersonDataList, adminorgBoMap, "haos_adminorghr", "assoadminorg", "assoadminorgbo");
        DecAdjRecordRevisionHelper.setBo(updatePersonDataList, BaseDataHisHelper.getCurrentOfVersion((String)"hbpm_positionhr", (Collection)positionIds), "hbpm_positionhr", "position", "positionbo");
        DecAdjRecordRevisionHelper.setBo(updatePersonDataList, BaseDataHisHelper.getCurrentOfVersion((String)"hbpm_stposition", (Collection)stdpositionIds), "hbpm_stposition", "stdposition", "stdpositionbo");
        DecAdjRecordRevisionHelper.setBo(updatePersonDataList, BaseDataHisHelper.getCurrentOfVersion((String)"haos_projectteamhr", (Collection)projectteamIds), "haos_projectteamhr", "projectteam", "projectteambo");
    }

    private static void setBo(List<DynamicObject> updatePersonDataList, Map<Long, Long> boIdMap, String entityNumber, String vidField, String boField) {
        if (MapUtils.isEmpty(boIdMap)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        for (DynamicObject personDyn : updatePersonDataList) {
            Long companyId = personDyn.getLong(vidField + ".id");
            if (companyId <= 0L || boIdMap.get(companyId) <= 0L) continue;
            DynamicObject dy = serviceHelper.generateEmptyDynamicObject();
            dy.set("id", (Object)boIdMap.get(companyId));
            personDyn.set(boField, (Object)dy);
        }
    }

    public static String validateAttributionType(DynamicObjectCollection itemEntry) {
        if (itemEntry == null) {
            return "";
        }
        String firstAttributionType = null;
        String firstRowIndex = null;
        boolean firstRowIsSet = false;
        for (DynamicObject itemDyn : itemEntry) {
            String attributionType = itemDyn.getString("salaryadjrsn_r.attributiontype");
            if (attributionType == null) continue;
            if (firstAttributionType == null) {
                firstAttributionType = attributionType;
                firstRowIndex = itemDyn.getString("seq");
                if (StringUtils.equals((CharSequence)firstAttributionType, (CharSequence)"1")) {
                    firstRowIsSet = true;
                }
            }
            if (StringUtils.equals((CharSequence)firstAttributionType, (CharSequence)attributionType)) continue;
            String setSalMsg = ResManager.loadKDString((String)"\u5b9a\u85aa", (String)"DecAdjRecordRevisionHelper_02", (String)"swc-hcdm-business", (Object[])new Object[0]);
            String adjSalMsg = ResManager.loadKDString((String)"\u8c03\u85aa", (String)"DecAdjRecordRevisionHelper_03", (String)"swc-hcdm-business", (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"\u540c\u4e00\u6b21\u65b0\u589e\u9700\u4f7f\u7528\u76f8\u540c\u7684\u5b9a\u8c03\u85aa\u7c7b\u578b\uff08\u7b2c{0}\u884c\u4e3a{1}\uff0c\u7b2c{2}\u884c\u4e3a{3}\uff09\u3002", (String)"DecAdjRecordRevisionHelper_04", (String)"swc-hcdm-business", (Object[])new Object[]{firstRowIndex, firstRowIsSet ? setSalMsg : adjSalMsg, itemDyn.getString("seq"), firstRowIsSet ? adjSalMsg : setSalMsg});
            return msg;
        }
        return "";
    }
}

