/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hcdm.business.export.HeaderInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportHelper {
    protected static final Log logger = LogFactory.getLog(ExportHelper.class);
    private static final String EXCEL_SUFFIX = ".xlsx";

    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, List<HeaderInfo> headList) {
        SXSSFRow headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            HeaderInfo headerInfo = headList.get(i);
            if (null == headerInfo) continue;
            SXSSFCell cell = headRow.createCell(i);
            String headValue = headerInfo.getDisplayName();
            cell.setCellValue(headValue);
            cell.setCellStyle(ExportHelper.getHeadColumnStyle(wb, headerInfo));
            sheet.setColumnWidth(i, 256 * headerInfo.getColumnWidthRatio());
        }
        return sheet.getLastRowNum();
    }

    public static void writeData(SXSSFWorkbook wb, SXSSFSheet sheet, int rowIndex, List<Map<String, Object>> dataList, List<HeaderInfo> headList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> rowData = dataList.get(i);
            if (null == rowData || rowData.size() == 0) continue;
            SXSSFRow row = sheet.createRow(i + rowIndex);
            for (int j = 0; j < headList.size(); ++j) {
                HeaderInfo headerInfo = headList.get(j);
                if (headerInfo == null) continue;
                SXSSFCell cell = row.createCell(j);
                String columnType = headerInfo.getDataType();
                String columnCode = headerInfo.getCode();
                Object columnValue = MapUtils.getObject(rowData, (Object)columnCode);
                ExportHelper.parseCellValue(cell, columnValue, columnType);
                cell.setCellType(ExportHelper.getCellType(columnType));
                cell.setCellStyle(ExportHelper.getCellStyle(headerInfo, wb, cellStyleMap));
            }
        }
    }

    private static CellStyle getHeadColumnStyle(SXSSFWorkbook wb, HeaderInfo headerInfo) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(headerInfo.getAlignment());
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public static CellType getCellType(String dataType) {
        switch (dataType) {
            default: 
        }
        return CellType.STRING;
    }

    private static void parseCellValue(SXSSFCell cell, Object columnValue, String dataType) {
        if (columnValue == null) {
            return;
        }
        switch (dataType) {
            case "boolean": {
                if (((Boolean)columnValue).booleanValue()) {
                    cell.setCellValue(ResManager.loadKDString((String)"\u662f", (String)"ExportHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
                    break;
                }
                cell.setCellValue(ResManager.loadKDString((String)"\u5426", (String)"ExportHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]));
                break;
            }
            default: {
                cell.setCellValue(columnValue.toString());
            }
        }
    }

    public static CellStyle getCellStyle(HeaderInfo headerInfo, SXSSFWorkbook wb, Map<String, CellStyle> cellStyleMap) {
        String dataType = headerInfo.getDataType();
        dataType = dataType == null ? "text" : dataType;
        CellStyle cellStyle = cellStyleMap.get(dataType);
        if (cellStyle != null) {
            return cellStyle;
        }
        cellStyle = ExportHelper.getDataCellStyle(wb, headerInfo);
        cellStyleMap.put(dataType, cellStyle);
        return cellStyle;
    }

    private static CellStyle getDataCellStyle(SXSSFWorkbook wb, HeaderInfo headerInfo) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(headerInfo.getAlignment());
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String storeFile(Workbook wb, String fileName, Object AttPk) {
        String string;
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            fileName = fileName + EXCEL_SUFFIX;
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)AttPk, (String)fileName);
            String path = fileService.upload(new FileItem(fileName, pathParam, (InputStream)inStream));
            string = UrlService.getAttachmentFullUrl((String)path);
            ExportHelper.closeSafely(outStream, inStream);
        }
        catch (Exception e) {
            String string2 = null;
            return string2;
        }
        try {
            wb.close();
            return string;
        }
        catch (Exception e) {
            logger.error("ExportHelper storeFile error:", (Throwable)e);
        }
        return string;
        finally {
            ExportHelper.closeSafely(outStream, inStream);
            try {
                wb.close();
            }
            catch (Exception e) {
                logger.error("ExportHelper storeFile error:", (Throwable)e);
            }
        }
    }

    public static void closeSafely(OutputStream os, InputStream in) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

