/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.helper;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CommonHcdmBizHelper {
    public static final int BATCH_SIZE = 500;
    public static final Set<String> STATUS_IN_TRANSIT = Sets.newHashSet((Object[])new String[]{"A", "B", "G", "D"});
    public static final Set<String> STATUS_IN_TRANSIT_FOR_CANDIDATE = Sets.newHashSet((Object[])new String[]{"A", "B", "G", "D", "C"});
    public static final String[] VALIDATE_DATA_STATUS = new String[]{"-3", "0", "1", "2", " "};
    public static final String[] VALIDATE_STATUS = new String[]{"A", "B", "C", "D", " "};
    private static final Log logger = LogFactory.getLog(CommonHcdmBizHelper.class);

    private CommonHcdmBizHelper() {
    }

    public static Map<Long, List<DynamicObject>> getCandSetSalApplidMap(Collection<Long> depEmpIds, Set<String> statusSet) {
        HashSet depEmpIdSet = Sets.newHashSet(depEmpIds);
        if (depEmpIdSet.isEmpty() || CollectionUtils.isEmpty(statusSet)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_singlecandsetsalappl");
        QFilter filter = new QFilter("candsetsalperson.depemp.id", "in", depEmpIds);
        filter.and("billstatus", "in", statusSet);
        DynamicObject[] candSetSalApplidDyArr = helper.query("billno,billstatus,depemp.id,persetsalrec.standarditem,persetsalrec.itembsed", filter.toArray());
        HashMap<Long, List<DynamicObject>> depEmpIdAndcandSetSalApplidDysMap = new HashMap<Long, List<DynamicObject>>(depEmpIdSet.size());
        for (DynamicObject candSetSalApplidDy : candSetSalApplidDyArr) {
            DynamicObjectCollection candSetSalPersonEntryEntity = candSetSalApplidDy.getDynamicObjectCollection("candsetsalperson");
            for (DynamicObject candSetSalPersonEntity : candSetSalPersonEntryEntity) {
                long depEmpId = candSetSalPersonEntity.getLong("depemp.id");
                if (!depEmpIdSet.contains(depEmpId)) continue;
                depEmpIdAndcandSetSalApplidDysMap.computeIfAbsent(depEmpId, key -> new ArrayList(10)).add(candSetSalApplidDy);
            }
        }
        return depEmpIdAndcandSetSalApplidDysMap;
    }

    public static Map<Long, List<DynamicObject>> getCandSetSalApplidMapByAdjFile(Collection<Long> adjFileIds, Set<String> statusSet) throws InterruptedException {
        if (adjFileIds == null || adjFileIds.isEmpty() || statusSet == null || statusSet.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
        QFilter filter = new QFilter("id", "in", adjFileIds);
        DynamicObject[] fileColl = service.getData("hcdm_adjfileinfo", "id,depemp.id", new QFilter[]{filter}, "", 500);
        Map<Long, Long> adjFileIdAndEmployeeIdMap = Arrays.stream(fileColl).collect(Collectors.toMap(fileDy -> fileDy.getLong("id"), fileDy -> fileDy.getLong("depemp.id"), (oldVal, newVal) -> oldVal));
        Map<Long, List<DynamicObject>> depEmpIdAndCandSetSalApplidDysMap = CommonHcdmBizHelper.getCandSetSalApplidMap(adjFileIdAndEmployeeIdMap.values(), statusSet);
        HashMap<Long, List<DynamicObject>> adjFileIdAndCandSetSalApplidDysMap = new HashMap<Long, List<DynamicObject>>(adjFileIdAndEmployeeIdMap.size());
        for (Map.Entry<Long, Long> adjFileIdAndEmployeeIdEntry : adjFileIdAndEmployeeIdMap.entrySet()) {
            List<DynamicObject> candSetSalApplidDys = depEmpIdAndCandSetSalApplidDysMap.get(adjFileIdAndEmployeeIdEntry.getValue());
            if (candSetSalApplidDys == null || candSetSalApplidDys.isEmpty()) continue;
            adjFileIdAndCandSetSalApplidDysMap.put(adjFileIdAndEmployeeIdEntry.getKey(), candSetSalApplidDys);
        }
        return adjFileIdAndCandSetSalApplidDysMap;
    }

    public static Map<Long, Set<String>> getCandSetSalApplidInTransitMap(Collection<Long> depEmpIds) {
        return CommonHcdmBizHelper.getCandSetSalApplidInfo(depEmpIds, STATUS_IN_TRANSIT);
    }

    public static Map<Long, List<DynamicObject>> getInvalidCandSetSalAppl(Collection<Long> depEmpIds) {
        return CommonHcdmBizHelper.getCandSetSalApplidMap(depEmpIds, STATUS_IN_TRANSIT);
    }

    public static Map<Long, Set<String>> getCandSetSalApplidInfo(Collection<Long> depEmpIds, Set<String> statusSet) {
        Map<Long, List<DynamicObject>> depEmpIdAndcandSetSalApplidDysMap = CommonHcdmBizHelper.getCandSetSalApplidMap(depEmpIds, statusSet);
        HashMap<Long, Set<String>> depEmpIdAndNumbersMap = new HashMap<Long, Set<String>>(depEmpIds.size());
        for (Map.Entry<Long, List<DynamicObject>> depEmpIdAndcandSetSalApplidDysEntry : depEmpIdAndcandSetSalApplidDysMap.entrySet()) {
            List<DynamicObject> candSetSalApplidDys = depEmpIdAndcandSetSalApplidDysEntry.getValue();
            for (DynamicObject candSetSalApplidDy : candSetSalApplidDys) {
                Set billNos = depEmpIdAndNumbersMap.computeIfAbsent(depEmpIdAndcandSetSalApplidDysEntry.getKey(), key -> new LinkedHashSet(16));
                billNos.add(candSetSalApplidDy.getString("billno"));
            }
        }
        return depEmpIdAndNumbersMap;
    }

    public static Map<Long, List<DynamicObject>> getInvalidAdjApprBillByAdjFileId(Set<Long> adjFileIds) {
        if (adjFileIds.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        QFilter qFilter = new QFilter("adjfile.id", "in", adjFileIds);
        DynamicObject[] adjApprPersonDyArray = serviceHelper.query("adjfile, adjapprbill", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> adjApprPersonGroupByAdjFileIdMap = Arrays.stream(adjApprPersonDyArray).collect(Collectors.groupingBy(item -> item.getLong("adjfile.id")));
        Map<Long, List<DynamicObject>> adjApprBillMap = CommonHcdmBizHelper.getAdjApprBillMap(adjApprPersonDyArray, adjApprPersonGroupByAdjFileIdMap);
        return adjApprBillMap;
    }

    public static Map<Long, List<DynamicObject>> getInvalidAdjApprBillByDepEmpId(Set<Long> depEmpIds) {
        if (depEmpIds.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        QFilter qFilter = new QFilter("adjfile.depemp.id", "in", depEmpIds);
        DynamicObject[] adjApprPersonDyArray = serviceHelper.query("adjfile, adjapprbill", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> adjApprPersonGroupByAdjFileIdMap = Arrays.stream(adjApprPersonDyArray).collect(Collectors.groupingBy(item -> item.getLong("adjfile.depemp.id")));
        Map<Long, List<DynamicObject>> adjApprBillMap = CommonHcdmBizHelper.getAdjApprBillMap(adjApprPersonDyArray, adjApprPersonGroupByAdjFileIdMap);
        return adjApprBillMap;
    }

    private static Map<Long, List<DynamicObject>> getAdjApprBillMap(DynamicObject[] adjApprPersonDyArray, Map<Long, List<DynamicObject>> adjApprPersonGroupByAdjFileIdMap) {
        HashMap<Long, List<DynamicObject>> adjApprBillMap = new HashMap<Long, List<DynamicObject>>(16);
        Set adjApprBillIdSet = Arrays.stream(adjApprPersonDyArray).map(item -> item.getLong("adjapprbill")).collect(Collectors.toSet());
        SWCDataServiceHelper adjApprServiceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject[] adjApprBillArray = adjApprServiceHelper.query(adjApprBillIdSet.toArray());
        for (Map.Entry<Long, List<DynamicObject>> entry : adjApprPersonGroupByAdjFileIdMap.entrySet()) {
            Long id = entry.getKey();
            Set adjApprBillIds = entry.getValue().stream().map(dynamicObject -> dynamicObject.getLong("adjapprbill")).collect(Collectors.toSet());
            for (DynamicObject adjApprBillDy : adjApprBillArray) {
                String billStatus = adjApprBillDy.getString("billstatus");
                Long adjApprBillId = adjApprBillDy.getLong("id");
                if (!adjApprBillIds.contains(adjApprBillId) || !STATUS_IN_TRANSIT.contains(billStatus)) continue;
                adjApprBillMap.computeIfAbsent(id, key -> new ArrayList(10)).add(adjApprBillDy);
            }
        }
        return adjApprBillMap;
    }

    public static Map<String, List<String>> getInvalidAdjApprBillByDepEmpIdForRevision(Set<Long> depEmpIds) {
        if (depEmpIds.isEmpty()) {
            return null;
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcdm_adjapprperson");
        QFilter qFilter = new QFilter("depemp.id", "in", depEmpIds);
        Object[] adjApprPersonDyArray = personHelper.query("adjapprbill,depemp,entryentity.standarditem", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])adjApprPersonDyArray)) {
            return null;
        }
        logger.info("getInvalidAdjApprBillByDepEmpIdForRevision adjApprPersonDyArray id is {}", Arrays.stream(adjApprPersonDyArray).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        Set adjApprBillIdSet = Arrays.stream(adjApprPersonDyArray).map(dy -> dy.getLong("adjapprbill")).collect(Collectors.toSet());
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("hcdm_adjapprbill");
        QFilter idFilter = new QFilter("id", "in", adjApprBillIdSet);
        idFilter.and("billstatus", "in", STATUS_IN_TRANSIT);
        DynamicObject[] adjApprBillDyArray = billHelper.query("id,billno,billstatus", new QFilter[]{idFilter});
        Map<Long, String> billIdToNoMap = Arrays.stream(adjApprBillDyArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno"), (oldVal, newVal) -> oldVal));
        HashMap result = Maps.newHashMapWithExpectedSize((int)adjApprPersonDyArray.length);
        for (Object personDy : adjApprPersonDyArray) {
            long billId = personDy.getLong("adjapprbill");
            String billNo = billIdToNoMap.get(billId);
            if (Strings.isNullOrEmpty((String)billNo)) continue;
            long depEmpId = personDy.getLong("depemp.id");
            DynamicObjectCollection entryEntity = personDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : entryEntity) {
                long itemId = entryDy.getLong("standarditem.id");
                String key = String.valueOf(depEmpId) + String.valueOf(itemId);
                List strings = result.computeIfAbsent(key, obj -> Lists.newArrayList());
                strings.add(billNo);
            }
        }
        logger.info("getInvalidAdjApprBillByDepEmpIdForRevision result is {}", (Object)result);
        return result;
    }

    public static Map<Long, Set<String>> getInvalidAdjBillByDepEmpId(Set<Long> depEmpIds) {
        if (depEmpIds.isEmpty()) {
            return new HashMap<Long, Set<String>>(0);
        }
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hcdm_adjapprperson");
        QFilter qFilter = new QFilter("depemp.id", "in", depEmpIds);
        Object[] adjApprPersonDyArray = personHelper.query("adjapprbill,depemp,entryentity.standarditem,adjfile,adjfile.id", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])adjApprPersonDyArray)) {
            return new HashMap<Long, Set<String>>(0);
        }
        logger.info("getInvalidAdjBillByDepEmpId adjApprPersonDyArray id is {}", Arrays.stream(adjApprPersonDyArray).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        Set adjApprBillIdSet = Arrays.stream(adjApprPersonDyArray).map(dy -> dy.getLong("adjapprbill")).collect(Collectors.toSet());
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("hcdm_adjapprbill");
        QFilter idFilter = new QFilter("id", "in", adjApprBillIdSet);
        DynamicObject[] adjApprBillDyArray = billHelper.query("id,billno,billstatus,salaryadjscm,salaryadjscm.enableconfirm,salaryadjscm.datasyncondition", new QFilter[]{idFilter});
        Map<Long, String> billIdToNoMap = Arrays.stream(adjApprBillDyArray).filter(billObj -> STATUS_IN_TRANSIT.contains(billObj.getString("billstatus"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno"), (oldVal, newVal) -> oldVal));
        Map<Long, String> comfirmBillIdMap = Arrays.stream(adjApprBillDyArray).filter(billObj -> billObj.getString("billstatus").equals("C") && ObjectUtils.isNotEmpty((Object)billObj.get("salaryadjscm")) && billObj.getBoolean("salaryadjscm.enableconfirm") && billObj.getString("salaryadjscm.datasyncondition").equals("2")).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno"), (oldVal, newVal) -> oldVal));
        Map<Object, Object> adjbillIdToConfirm = new HashMap(16);
        if (MapUtils.isNotEmpty(comfirmBillIdMap)) {
            SWCDataServiceHelper confirmPersonServiceHelper = new SWCDataServiceHelper("hcdm_adjconfirmperson");
            DynamicObject[] confirmPersonObjs = confirmPersonServiceHelper.query("id, adjapprovalbill, adjfile, confirmstatus,adjfile.id", new QFilter[]{new QFilter("adjapprovalbill", "in", comfirmBillIdMap.keySet())});
            adjbillIdToConfirm = Arrays.stream(confirmPersonObjs).filter(obj -> ObjectUtils.isNotEmpty((Object)obj) && ConfirmStatusEnum.UN_CONFIRM.getCode().equals(obj.getString("confirmstatus"))).collect(Collectors.groupingBy(obj -> obj.getLong("adjapprovalbill")));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)adjApprPersonDyArray.length);
        HashSet<String> billNoSet = new HashSet<String>(16);
        for (Object personDy : adjApprPersonDyArray) {
            billNoSet.clear();
            long billId = personDy.getLong("adjapprbill");
            long adjfileId = personDy.getLong("adjfile.id");
            if (ObjectUtils.isNotEmpty((Object)billIdToNoMap.get(billId))) {
                billNoSet.add(billIdToNoMap.get(billId));
            }
            if (MapUtils.isNotEmpty(adjbillIdToConfirm) && !CollectionUtils.isEmpty((Collection)((Collection)adjbillIdToConfirm.get(billId)))) {
                List conPerson = (List)adjbillIdToConfirm.get(billId);
                for (DynamicObject cPerson : conPerson) {
                    String adjbillNo;
                    long cadjfileId = cPerson.getLong("adjfile.id");
                    if (cadjfileId != adjfileId || StringUtils.isEmpty((Object)(adjbillNo = comfirmBillIdMap.get(cPerson.getLong("adjapprovalbill"))))) continue;
                    billNoSet.add(adjbillNo);
                }
            }
            if (CollectionUtils.isEmpty(billNoSet)) continue;
            long depEmpId = personDy.getLong("depemp.id");
            Set strings = result.computeIfAbsent(depEmpId, obj -> new HashSet(16));
            strings.addAll(billNoSet);
        }
        logger.info("getInvalidAdjBillByDepEmpId result is {}", (Object)result);
        return result;
    }

    public static Map<Long, List<DynamicObject>> getInvalidAdjApprBillByDepEmpIdForCandApplValidation(Set<Long> depEmpIds) {
        if (depEmpIds.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        QFilter qFilter = new QFilter("adjfile.depemp.id", "in", depEmpIds);
        DynamicObject[] adjApprPersonDyArray = serviceHelper.query("adjfile, adjapprbill", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> adjApprPersonGroupByAdjFileIdMap = Arrays.stream(adjApprPersonDyArray).collect(Collectors.groupingBy(item -> item.getLong("adjfile.depemp.id")));
        HashMap<Long, List<DynamicObject>> adjApprBillMap = new HashMap<Long, List<DynamicObject>>(16);
        Set adjApprBillIdSet = Arrays.stream(adjApprPersonDyArray).map(item -> item.getLong("adjapprbill")).collect(Collectors.toSet());
        SWCDataServiceHelper adjApprServiceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject[] adjApprBillArray = adjApprServiceHelper.query(adjApprBillIdSet.toArray());
        for (Map.Entry<Long, List<DynamicObject>> entry : adjApprPersonGroupByAdjFileIdMap.entrySet()) {
            Long id = entry.getKey();
            Set adjApprBillIds = entry.getValue().stream().map(dynamicObject -> dynamicObject.getLong("adjapprbill")).collect(Collectors.toSet());
            for (DynamicObject adjApprBillDy : adjApprBillArray) {
                String billStatus = adjApprBillDy.getString("billstatus");
                Long adjApprBillId = adjApprBillDy.getLong("id");
                if (!adjApprBillIds.contains(adjApprBillId) || !STATUS_IN_TRANSIT_FOR_CANDIDATE.contains(billStatus)) continue;
                adjApprBillMap.computeIfAbsent(id, key -> new ArrayList(10)).add(adjApprBillDy);
            }
        }
        return adjApprBillMap;
    }

    public static Map<Long, List<DynamicObject>> getInvalidAdjRecordByAdjFileId(Set<Long> adjFileIds) throws InterruptedException {
        if (null == adjFileIds || adjFileIds.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        QFilter qFilter = new QFilter("initdatasource", "=", (Object)"1");
        qFilter.and("initstatus", "in", Arrays.asList("0", "1"));
        qFilter.and("datastatus", "in", (Object)VALIDATE_DATA_STATUS);
        qFilter.and("salaryadjfile_id", "in", adjFileIds);
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_salaryadjrecord");
        SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
        DynamicObject[] adjApprPersonDyArray = service.getData("hcdm_salaryadjrecord", selectProperties, new QFilter[]{qFilter}, "", 500);
        return Arrays.stream(adjApprPersonDyArray).collect(Collectors.groupingBy(item -> item.getLong("salaryadjfile_id")));
    }

    public static Map<Long, List<DynamicObject>> getInvalidAdjRecordByDepEmpId(Set<Long> depEmpIds) {
        if (null == depEmpIds || depEmpIds.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        QFilter filter = new QFilter("depemp", "in", depEmpIds);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"hcdm_decadjrelperson", (String)"id,depemp_id", (QFilter[])filter.toArray());
        if (0 == records.length) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        Map<Object, Long> personMap = Arrays.stream(records).collect(Collectors.toMap(DataEntityBase::getPkValue, record -> record.getLong("depemp_id")));
        QFilter qFilter = new QFilter("initdatasource", "=", (Object)"1");
        qFilter.and("initstatus", "in", Arrays.asList("0", "1"));
        qFilter.and("datastatus", "in", (Object)VALIDATE_DATA_STATUS);
        qFilter.and("relpersonid", "in", personMap.keySet());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        DynamicObject[] adjApprPersonDyArray = serviceHelper.query("id,standarditem,relpersonid ", qFilter.toArray());
        return Arrays.stream(adjApprPersonDyArray).collect(Collectors.groupingBy(item -> (Long)personMap.get(item.getLong("relpersonid"))));
    }

    public static DynamicObject[] queryEmployeeFromHrpi(Set<String> personNumber, Set<Long> adminorgIds) {
        if (CollectionUtils.isEmpty(personNumber) || CollectionUtils.isEmpty(adminorgIds)) {
            logger.info("queryEmployeeFromHrpi personNumber or adminorgIds is empty ");
            return null;
        }
        QFilter filter = new QFilter("adminorg.id", "in", adminorgIds);
        filter.and("person.number", "in", personNumber);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_depemp");
        return serviceHelper.query("id,person,person.id,person.number,employee,employee.id,adminorg,adminorg.id,startdate,enddate,bsed,bsled", new QFilter[]{filter});
    }

    public static DynamicObject[] queryEmployeeByIds(Set<Long> employeeIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_employee");
        return serviceHelper.query("id,person,person.id,person.number,empnumber,startdate,enddate,bsed,bsled", new QFilter[]{new QFilter("id", "in", employeeIds)});
    }

    public static DynamicObject matchEmployee(Date bizdatatime, List<DynamicObject> depempList, Map<Long, DynamicObject> idToEmployeeMap) {
        DynamicObject matchObj = null;
        List<Object> rightEmpList = new ArrayList(10);
        if (ObjectUtils.isNotEmpty((Object)bizdatatime) && !CollectionUtils.isEmpty(depempList) && MapUtils.isNotEmpty(idToEmployeeMap)) {
            for (DynamicObject depObj : depempList) {
                DynamicObject empObj = idToEmployeeMap.get(depObj.getLong("employee.id"));
                if (ObjectUtils.isEmpty((Object)empObj)) continue;
                if (empObj.getDate("startdate").compareTo(bizdatatime) <= 0 && empObj.getDate("enddate").compareTo(bizdatatime) >= 0) {
                    return empObj;
                }
                if (empObj.getDate("startdate").compareTo(bizdatatime) <= 0) continue;
                rightEmpList.add(empObj);
            }
            if (!CollectionUtils.isEmpty(rightEmpList)) {
                rightEmpList = rightEmpList.stream().sorted(Comparator.comparing(obj -> obj.getDate("startdate"))).collect(Collectors.toList());
                matchObj = (DynamicObject)rightEmpList.get(0);
            }
        }
        return matchObj;
    }

    public static DynamicObject[] queryEmployeeFromHrpi(String personNumber, Long adminorgId, Date bizdatatime) {
        if (StringUtils.isEmpty((Object)personNumber) || adminorgId == null) {
            logger.info("queryEmployeeFromHrpi personNumber or adminorgId is empty ");
            return null;
        }
        QFilter filter = new QFilter("person.number", "=", (Object)personNumber);
        filter.and("adminorg.id", "=", (Object)adminorgId);
        if (ObjectUtils.isNotEmpty((Object)bizdatatime)) {
            filter.and("startdate", "<=", (Object)bizdatatime);
            filter.and("enddate", ">=", (Object)bizdatatime);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_depemp");
        return serviceHelper.query("id,person,person.id,person.number,employee,employee.id,adminorg,adminorg.id,startdate,enddate,bsed,bsled", new QFilter[]{filter});
    }
}

