/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.his;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BdHisHelper {
    public static boolean checkAvailableVersion(DynamicObject hisObj) {
        String dataStatus = hisObj.getString("datastatus");
        String enableStatus = hisObj.getString("enable");
        boolean isNormal = false;
        if (StringUtils.equals((String)enableStatus, (String)"1") && (StringUtils.equals((String)dataStatus, (String)"2") || StringUtils.equals((String)dataStatus, (String)"1") || StringUtils.equals((String)dataStatus, (String)"0"))) {
            isNormal = true;
        }
        return isNormal;
    }

    public static boolean checkEffectingVersion(DynamicObject hisObj) {
        String dataStatus = hisObj.getString("datastatus");
        String enableStatus = hisObj.getString("enable");
        boolean isNormal = false;
        if (StringUtils.equals((String)enableStatus, (String)"1") && StringUtils.equals((String)dataStatus, (String)"1")) {
            isNormal = true;
        }
        return isNormal;
    }

    public static boolean checkInvalidVersion(DynamicObject hisObj) {
        String dataStatus = hisObj.getString("datastatus");
        String enableStatus = hisObj.getString("enable");
        boolean isNormal = false;
        if (StringUtils.equals((String)enableStatus, (String)"1") && (StringUtils.equals((String)dataStatus, (String)"1") || StringUtils.equals((String)dataStatus, (String)"0") || StringUtils.equals((String)dataStatus, (String)"2"))) {
            isNormal = true;
        }
        return isNormal;
    }

    public static boolean checkDateOverlap(DynamicObject versionObj, Date startDate, Date endDate) {
        Date bsed = versionObj.getDate("bsed");
        Date bsled = versionObj.getDate("bsled");
        if (startDate == null || endDate == null) {
            throw new KDBizException("checkDateInSection targetDate is null");
        }
        if (bsed == null || bsled == null) {
            throw new KDBizException("bsed or bsled is null");
        }
        long startDateTime = startDate.getTime();
        long endDateTime = endDate.getTime();
        long bsedTime = bsed.getTime();
        long bsledTime = bsled.getTime();
        return bsledTime >= startDateTime && bsedTime <= endDateTime;
    }

    public static boolean checkDateInSection(DynamicObject versionObj, Date startDate) {
        Date bsed = versionObj.getDate("bsed");
        Date bsled = versionObj.getDate("bsled");
        if (startDate == null) {
            throw new KDBizException("checkDateInSection targetDate is null");
        }
        if (bsed == null || bsled == null) {
            throw new KDBizException("bsed or bsled is null");
        }
        long startDateTime = startDate.getTime();
        long bsedTime = bsed.getTime();
        long bsledTime = bsled.getTime();
        return startDateTime >= bsedTime && startDateTime <= bsledTime;
    }

    public static DynamicObject getDataInSection(List<DynamicObject> adjVersionObjs, Date effectiveDate) {
        if (CollectionUtils.isNotEmpty(adjVersionObjs)) {
            for (DynamicObject adjVersionObj : adjVersionObjs) {
                if (!BdHisHelper.checkDateInSection(adjVersionObj, effectiveDate)) continue;
                return adjVersionObj;
            }
        }
        return null;
    }
}

