/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.swc.hcdm.business.imports.DefaultImportDataLogger;
import kd.swc.hcdm.business.imports.IImportDataLogger;
import kd.swc.hcdm.common.entity.adjfile.ImportRowEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ImportDataConvertToDyObjHelper {
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String SALARYFILE = "salaryadjfile";
    private static String BASE_DATA_SELECT_PROPS = "id,name,number,status,enable";
    private static Set<String> EXCLUDE_BASEDATA = Sets.newHashSet((Object[])new String[]{"hbpm_positionhr", "hbjm_joblevelhr", "hbjm_jobgradehr"});
    private IImportDataLogger importDataLogger;
    private Map<String, QFilter> customBaseDataFilter;
    private String noMatchMsg = ResManager.loadKDString((String)"{0}\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ImportDataConvertToDyObjHelper_8", (String)"swc-hcdm-business", (Object[])new Object[0]);

    public ImportDataConvertToDyObjHelper() {
        this.importDataLogger = new DefaultImportDataLogger();
    }

    public ImportDataConvertToDyObjHelper(IImportDataLogger importDataLogger) {
        this.importDataLogger = importDataLogger;
    }

    public Map<String, QFilter> getCustomBaseDataFilter() {
        return this.customBaseDataFilter;
    }

    public void setCustomBaseDataFilter(Map<String, QFilter> customBaseDataFilter) {
        this.customBaseDataFilter = customBaseDataFilter;
    }

    public void assembleImportData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger) {
        HashMap<String, Map<String, Map<String, List<String>>>> baseDataValMap = new HashMap<String, Map<String, Map<String, List<String>>>>();
        for (ImportRowEntity rowInfo : rowInfos) {
            this.assemblyDynamicObject(mainEntityType, rowInfo, baseDataValMap, logger);
        }
        Map<String, Map<String, Map<String, Map<String, List<DynamicObject>>>>> filedBasedataValRels = this.getBasedataRel(baseDataValMap);
        this.fillBasedata2DynamicObject(mainEntityType, rowInfos, logger, filedBasedataValRels);
    }

    private void fillBasedata2DynamicObject(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger, Map<String, Map<String, Map<String, Map<String, List<DynamicObject>>>>> filedBasedataValRels) {
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowInfo : rowInfos) {
            int rowIndex = rowInfo.getRowIndex();
            JSONObject importJsonData = rowInfo.getData();
            DynamicObject entityDyObj = rowInfo.getEntityDyobj(entityId);
            this.prepareFillBasedata(importJsonData, entityDyObj, rowIndex, logger, filedBasedataValRels);
            rowInfo.putEntityDyobj(entityId, entityDyObj);
        }
    }

    private void prepareFillBasedata(JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, Map<String, List<DynamicObject>>>>> filedBasedataValRels) {
        DynamicObjectType dyObjType = entityDyObj.getDynamicObjectType();
        for (String fieldKey : entityJson.keySet()) {
            DynamicProperty prop = dyObjType.getProperty(fieldKey);
            if (prop instanceof BasedataProp) {
                this.fillBasedataToEntity(fieldKey, entityJson, entityDyObj, rowIndex, logger, filedBasedataValRels, (BasedataProp)prop, 0);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            JSONArray entryJsonArr = entityJson.getJSONArray(fieldKey);
            DynamicObjectCollection entryEntityColl = entityDyObj.getDynamicObjectCollection(fieldKey);
            int size = entryJsonArr.size();
            for (int i = 0; i < size; ++i) {
                JSONObject entryEntityJson = entryJsonArr.getJSONObject(i);
                for (String entryFieldKey : entryEntityJson.keySet()) {
                    this.fillBasedataToEntryEntity(entryFieldKey, entryEntityColl, entryEntityJson, filedBasedataValRels, rowIndex, logger, i);
                }
            }
        }
    }

    private void fillBasedataToEntity(String fieldKey, JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, Map<String, List<DynamicObject>>>>> filedBasedataValRels, BasedataProp basedataDP, int index) {
        JSONObject basedataJson = entityJson.getJSONObject(fieldKey);
        if (basedataJson == null) {
            return;
        }
        String importPropKey = basedataJson.getString("importprop");
        BasedataProp basedataProp = basedataDP;
        String basedataEntityId = basedataProp.getBaseEntityId();
        Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = filedBasedataValRels.get(fieldKey);
        Map<String, Map<String, List<DynamicObject>>> importPropVals = basedataValRels.get(basedataEntityId);
        if (null != importPropVals) {
            Map<String, List<DynamicObject>> basedataValsMap = importPropVals.get(importPropKey);
            if (null != basedataValsMap) {
                List<DynamicObject> basedataDyobjs = basedataValsMap.get(basedataJson.get((Object)importPropKey));
                if (null == basedataDyobjs) {
                    this.importDataLogger.logger(entityDyObj, rowIndex + index, ImportDataConvertToDyObjHelper.getBasedNoMatchMsg((DynamicProperty)basedataDP, importPropKey), logger);
                    entityDyObj.set(fieldKey, null);
                } else if (basedataDyobjs.size() != 1) {
                    this.importDataLogger.logger(entityDyObj, rowIndex + index, ImportDataConvertToDyObjHelper.getDuplicateDataErrorMsg((DynamicProperty)basedataDP, importPropKey, basedataDyobjs), logger);
                    entityDyObj.set(fieldKey, null);
                } else {
                    DynamicObject basedata = basedataDyobjs.get(0);
                    if (!SALARYFILE.equals(fieldKey)) {
                        if (ImportDataConvertToDyObjHelper.isUseStatusQualified(basedata)) {
                            entityDyObj.set(fieldKey, (Object)basedata);
                        } else {
                            this.importDataLogger.logger(entityDyObj, rowIndex + index, ImportDataConvertToDyObjHelper.getBasedataStatusUnqualifiedMsg((DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                        }
                    } else {
                        entityDyObj.set(fieldKey, (Object)basedata);
                    }
                }
            } else {
                this.importDataLogger.logger(entityDyObj, rowIndex + index, ImportDataConvertToDyObjHelper.getBasedNoMatchMsg((DynamicProperty)basedataDP, importPropKey), logger);
                entityDyObj.set(fieldKey, null);
            }
        } else if (basedataProp.isMustInput()) {
            this.importDataLogger.logger(entityDyObj, rowIndex + index, ImportDataConvertToDyObjHelper.getBasedNoMatchMsg((DynamicProperty)basedataDP, importPropKey), logger);
            entityDyObj.set(fieldKey, null);
        }
    }

    private void fillBasedataToEntryEntity(String entryFieldKey, DynamicObjectCollection entryEntityColl, JSONObject entryEntityJson, Map<String, Map<String, Map<String, Map<String, List<DynamicObject>>>>> filedBasedataValRels, int rowIndex, ImportLogger logger, int index) {
        for (DynamicObject entryDyObj : entryEntityColl) {
            String importPropVal;
            String basedataVal;
            DynamicObjectType dyObjType = entryDyObj.getDynamicObjectType();
            DynamicProperty basedataDP = dyObjType.getProperty(entryFieldKey);
            if (!(basedataDP instanceof BasedataProp)) continue;
            JSONObject basedataJson = entryEntityJson.getJSONObject(entryFieldKey);
            String entryBasedataVal = entryDyObj.getString(entryFieldKey);
            if (basedataJson == null || !(basedataVal = basedataJson.getString(importPropVal = basedataJson.getString("importprop"))).equals(entryBasedataVal)) continue;
            this.fillBasedataToEntity(entryFieldKey, entryEntityJson, entryDyObj, rowIndex, logger, filedBasedataValRels, (BasedataProp)basedataDP, index);
            break;
        }
    }

    private void assemblyDynamicObject(MainEntityType mainEntityType, ImportRowEntity rowInfo, Map<String, Map<String, Map<String, List<String>>>> baseDataValMap, ImportLogger logger) {
        DynamicObject dynamicObj = (DynamicObject)mainEntityType.createInstance();
        JSONObject importJsonData = rowInfo.getData();
        int rowIndex = rowInfo.getRowIndex();
        DataEntityPropertyCollection allProps = mainEntityType.getProperties();
        for (IDataEntityProperty dp : allProps) {
            this.fillVal2DynamicObj(importJsonData, rowIndex, dynamicObj, dp, baseDataValMap, logger, 0);
        }
        Long pkId = ORM.create().genLongId((IDataEntityType)mainEntityType);
        dynamicObj.set("id", (Object)pkId);
        rowInfo.putEntityDyobj(mainEntityType.getName(), dynamicObj);
    }

    private Map<String, Map<String, Map<String, Map<String, List<DynamicObject>>>>> getBasedataRel(Map<String, Map<String, Map<String, List<String>>>> baseDataValMap) {
        HashMap filedBasedataValRels = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Map<String, Map<String, List<String>>>> filedBasedataEntityMap : baseDataValMap.entrySet()) {
            String fieldKey = filedBasedataEntityMap.getKey();
            Map<String, Map<String, List<String>>> basedataEntityMap = filedBasedataEntityMap.getValue();
            HashMap basedataValRels = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry<String, Map<String, List<String>>> basedataEntityMapEntry : basedataEntityMap.entrySet()) {
                String basedataEntityId = basedataEntityMapEntry.getKey();
                Map<String, List<String>> importPropValMap = basedataEntityMapEntry.getValue();
                if (null == importPropValMap) continue;
                HashMap importPropVals = Maps.newHashMapWithExpectedSize((int)16);
                for (Map.Entry<String, List<String>> importPropKeyMap : importPropValMap.entrySet()) {
                    String importPropKey = importPropKeyMap.getKey();
                    List<String> basedataValList = importPropKeyMap.getValue();
                    SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(basedataEntityId);
                    QFilter qFilter = new QFilter(importPropKey, "in", basedataValList);
                    if (SWCStringUtils.equals((String)"id", (String)importPropKey) && !CollectionUtils.isEmpty(basedataValList)) {
                        List longList = basedataValList.stream().filter(Objects::nonNull).map(str -> Long.parseLong(str.trim())).collect(Collectors.toList());
                        qFilter = new QFilter(importPropKey, "in", longList);
                    }
                    this.qFilterByBasedataEntity(basedataEntityId, qFilter);
                    DynamicObject[] basedataDyObjs = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)basedataEntityId), new QFilter[]{qFilter});
                    HashMap<String, List<DynamicObject>> basedataRelMap = new HashMap<String, List<DynamicObject>>();
                    for (DynamicObject dyObj : basedataDyObjs) {
                        this.fillBaseDataRel(basedataRelMap, dyObj, importPropKey);
                    }
                    importPropVals.put(importPropKey, basedataRelMap);
                    basedataValRels.put(basedataEntityId, importPropVals);
                }
            }
            filedBasedataValRels.put(fieldKey, basedataValRels);
        }
        return filedBasedataValRels;
    }

    private void qFilterByBasedataEntity(String basedataEntityId, QFilter qFilter) {
        if (EXCLUDE_BASEDATA.contains(basedataEntityId)) {
            return;
        }
        Map<String, QFilter> customBaseDataFilter = this.getCustomBaseDataFilter();
        if (customBaseDataFilter == null || !customBaseDataFilter.containsKey(basedataEntityId)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)basedataEntityId);
            DataEntityPropertyCollection properties = entityType.getProperties();
            if (properties.containsKey((Object)"iscurrentversion")) {
                qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
            }
            if (properties.containsKey((Object)"status")) {
                qFilter.and("status", "=", (Object)"C");
            }
            if (properties.containsKey((Object)"enable")) {
                qFilter.and("enable", "=", (Object)"1");
            }
        } else {
            QFilter customFilter = customBaseDataFilter.get(basedataEntityId);
            if (customFilter != null) {
                qFilter.and(customBaseDataFilter.get(basedataEntityId));
            }
        }
    }

    private void fillBaseDataRel(Map<String, List<DynamicObject>> basedataRelMap, DynamicObject dyObj, String importPropKey) {
        List<DynamicObject> exsitDyObjList = basedataRelMap.get(dyObj.getString(importPropKey));
        if (null == exsitDyObjList) {
            exsitDyObjList = new ArrayList<DynamicObject>();
            exsitDyObjList.add(dyObj);
        } else {
            exsitDyObjList.add(dyObj);
        }
        basedataRelMap.put(dyObj.getString(importPropKey), exsitDyObjList);
    }

    public void fillVal2DynamicObj(JSONObject importJsonData, int rowIndex, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, Map<String, List<String>>>> baseDataValMap, ImportLogger logger, int index) {
        String fieldKey = dp.getName();
        String fieldVal = importJsonData.getString(fieldKey);
        if (SWCStringUtils.isNotEmpty((String)fieldVal)) {
            if (dp instanceof BasedataProp) {
                this.fillBasedataProp(fieldKey, importJsonData, dynamicObj, dp, baseDataValMap);
            } else if (dp instanceof LargeTextProp || dp instanceof VarcharProp || dp instanceof MuliLangTextProp || dp instanceof TextProp || dp instanceof ComboProp) {
                if (dp instanceof MuliLangTextProp) {
                    Map muliLangTextMap = (Map)JSONObject.parseObject((String)importJsonData.getJSONObject(fieldKey).toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    dynamicObj.set(fieldKey, (Object)LocaleString.fromMap((Map)muliLangTextMap));
                } else {
                    dynamicObj.set(fieldKey, (Object)fieldVal);
                }
            } else if (dp instanceof DecimalProp) {
                this.fillDecimalProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, dp, index);
            } else if (dp instanceof DateProp) {
                this.fillDateProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, YYYY_MM_DD, dp, index);
            } else if (dp instanceof DateTimeProp) {
                this.fillDateProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, YYYY_MM_DD_HH_MM_SS, dp, index);
            } else if (dp instanceof BooleanProp) {
                if (SWCStringUtils.equals((String)fieldVal, (String)"true")) {
                    dynamicObj.set(fieldKey, (Object)Boolean.TRUE);
                } else {
                    dynamicObj.set(fieldKey, (Object)Boolean.FALSE);
                }
            } else if (dp instanceof EntryProp) {
                this.fillEntryProp(fieldVal, rowIndex, dynamicObj, fieldKey, baseDataValMap, logger);
            } else if (dp instanceof LongProp) {
                dynamicObj.set(fieldKey, (Object)Long.valueOf(fieldVal));
            }
        } else if (dp instanceof CreateDateProp || dp instanceof ModifyDateProp) {
            dynamicObj.set(fieldKey, (Object)new Date());
        } else if (dp instanceof CreaterProp || dp instanceof ModifierProp) {
            dynamicObj.set(fieldKey, (Object)RequestContext.get().getUserId());
        } else if (dp instanceof FieldProp) {
            dynamicObj.set(fieldKey, ((FieldProp)dp).getDefValue());
        }
    }

    private void fillBasedataProp(String fieldKey, JSONObject importJsonData, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, Map<String, List<String>>>> baseDataValMap) {
        JSONObject basedataJson = importJsonData.getJSONObject(fieldKey);
        String importProp = basedataJson.getString("importprop");
        String basedataVal = basedataJson.getString(importProp);
        Map basedataEntityIdMap = baseDataValMap.computeIfAbsent(fieldKey, k1 -> new HashMap());
        String basedataEntityId = ((BasedataProp)dp).getBaseEntityId();
        Map importPropValMap = basedataEntityIdMap.computeIfAbsent(basedataEntityId, k1 -> new HashMap());
        List basedataValList = importPropValMap.computeIfAbsent(importProp, k1 -> new ArrayList());
        basedataValList.add(basedataVal);
        dynamicObj.set(fieldKey, (Object)basedataVal);
    }

    private void fillEntryProp(String fieldVal, int rowIndex, DynamicObject dynamicObj, String fieldKey, Map<String, Map<String, Map<String, List<String>>>> baseDataValMap, ImportLogger logger) {
        JSONArray entryJsonArr = JSONArray.parseArray((String)fieldVal);
        DynamicObjectCollection entryEntityColl = dynamicObj.getDynamicObjectCollection(fieldKey);
        DynamicObjectType entryType = null;
        DynamicObject entryDyObj = null;
        int size = entryJsonArr.size();
        for (int i = 0; i < size; ++i) {
            JSONObject entryJson = entryJsonArr.getJSONObject(i);
            entryType = entryEntityColl.getDynamicObjectType();
            entryDyObj = new DynamicObject(entryType);
            for (IDataEntityProperty idp : entryType.getProperties()) {
                if ("id".equals(idp.getName())) continue;
                this.fillVal2DynamicObj(entryJson, rowIndex, entryDyObj, idp, baseDataValMap, logger, i);
            }
            entryDyObj.set("seq", (Object)(i + 1));
            entryEntityColl.add((Object)entryDyObj);
        }
    }

    private void fillDecimalProp(String fieldKey, String fieldVal, DynamicObject dynamicObj, int rowIndex, ImportLogger logger, IDataEntityProperty dp, int index) {
        try {
            BigDecimal bigDecimal = new BigDecimal(fieldVal);
            int precision = bigDecimal.precision();
            int scale = bigDecimal.scale();
            if (scale == 0 && precision >= 15 || scale == 1 && precision > 14 || scale == 2 && precision > 15) {
                String msg = ResManager.loadKDString((String)"{0}\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"SalaryFileImportDataConvert2DyObj_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.importDataLogger.logger(dynamicObj, rowIndex + index, MessageFormat.format(msg, dp.getDisplayName().getLocaleValue()), logger);
            } else {
                dynamicObj.set(fieldKey, (Object)new BigDecimal(fieldVal));
            }
        }
        catch (NumberFormatException e) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a{0}", (String)"SalaryFileImportDataConvert2DyObj_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.importDataLogger.logger(dynamicObj, rowIndex + index, MessageFormat.format(msg, dp.getDisplayName().getLocaleValue()), logger);
        }
    }

    private void fillDateProp(String fieldKey, String fieldVal, DynamicObject dynamicObj, int rowIndex, ImportLogger logger, String fmt, IDataEntityProperty dp, int index) {
        try {
            Date date = SWCDateTimeUtils.parseDate((String)fieldVal, (String)fmt);
            Date defaultMaxDate = SWCDateTimeUtils.parseDate((String)"2999-12-31", (String)fmt);
            if (YYYY_MM_DD.equals(fmt) && SWCDateTimeUtils.dayAfter((Date)date, (Date)defaultMaxDate)) {
                this.importDataLogger.logger(dynamicObj, rowIndex + index, MessageFormat.format(this.noMatchMsg, dp.getDisplayName().getLocaleValue()), logger);
            } else {
                dynamicObj.set(fieldKey, (Object)date);
            }
        }
        catch (Exception e) {
            this.importDataLogger.logger(dynamicObj, rowIndex + index, MessageFormat.format(this.noMatchMsg, dp.getDisplayName().getLocaleValue()), logger);
        }
    }

    public static String getBasedNoMatchMsg(DynamicProperty dp, String importProp) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ImportDataConvertToDyObjHelper_8", (String)"swc-hcdm-business", (Object[])new Object[0]), dp.getDisplayName().getLocaleValue() + ImportDataConvertToDyObjHelper.getImportPropDisName(importProp));
    }

    public static String getBasedataStatusUnqualifiedMsg(DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ImportDataConvertToDyObjHelper_8", (String)"swc-hcdm-business", (Object[])new Object[0]), dp.getDisplayName().getLocaleValue() + ImportDataConvertToDyObjHelper.getImportPropDisName(importProp));
    }

    public static String getDuplicateDataErrorMsg(DynamicProperty dp, String importProp, List<DynamicObject> basedataDyObjs) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\u7684\u503c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u552f\u4e00\uff1a{1}", (String)"ImportDataConvertToDyObjHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0]), dp.getDisplayName(), basedataDyObjs.get(0).getString(importProp));
    }

    public static String getImportPropDisName(String importProp) {
        if (SWCStringUtils.equals((String)importProp, (String)"number")) {
            return ResManager.loadKDString((String)".\u7f16\u7801", (String)"ImportDataConvertToDyObjHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        if (SWCStringUtils.equals((String)importProp, (String)"name")) {
            return ResManager.loadKDString((String)".\u540d\u79f0", (String)"ImportDataConvertToDyObjHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static boolean isUseStatusQualified(DynamicObject basedata) {
        boolean isQualified = true;
        String basedataEntityId = basedata.getDataEntityType().getName();
        if (EXCLUDE_BASEDATA.contains(basedataEntityId)) {
            return isQualified;
        }
        IDataEntityType entityType = basedata.getDataEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (name.equals("status")) {
                if (SWCStringUtils.equals((String)basedata.getString("status"), (String)"C")) continue;
                isQualified = false;
                continue;
            }
            if (!name.equals("enable") || SWCStringUtils.equals((String)basedata.getString("enable"), (String)"1")) continue;
            isQualified = false;
        }
        return isQualified;
    }
}

