/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.swc.hcdm.common.entity.adjfile.ImportRowEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ImportDataLoggerHelper {
    public static void preSuffixSplicingMsgLog(int rowIndex, String errorMsg, ImportLogger logger, String prefixMsg, String suffixMsg) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            List importLogs = (List)logCache.get(rowIndex);
            if (SWCStringUtils.isNotEmpty((String)prefixMsg)) {
                importLogs.add(1, new ImportLogger.ImportLog(errorMsg + "\u3001"));
            } else {
                importLogs.add(0, new ImportLogger.ImportLog(errorMsg + "\u3001"));
            }
            logger.setLogCache(logCache);
        } else {
            ArrayList<ImportLogger.ImportLog> importLogs = new ArrayList<ImportLogger.ImportLog>(10);
            if (SWCStringUtils.isNotEmpty((String)prefixMsg)) {
                importLogs.add(new ImportLogger.ImportLog(prefixMsg));
            }
            importLogs.add(new ImportLogger.ImportLog(errorMsg));
            importLogs.add(new ImportLogger.ImportLog(suffixMsg));
            logger.logAll(Integer.valueOf(rowIndex), importLogs).fail();
        }
    }

    public static List<ImportRowEntity> filterImportableData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger) {
        Set errorRowIndexs = logger.getLogCache().keySet();
        ArrayList<ImportRowEntity> importableRowInfos = new ArrayList<ImportRowEntity>();
        for (ImportRowEntity rowInfo : rowInfos) {
            JSONObject jsonObject = rowInfo.getData();
            JSONArray jsonArray = jsonObject.getJSONArray("entryentity");
            int stratIndex = rowInfo.getRowIndex();
            if (null != jsonArray && !jsonArray.isEmpty()) {
                int jsonArrSize = jsonArray.size();
                boolean isErrorData = false;
                for (int i = 0; i < jsonArrSize; ++i) {
                    int entryIndex = stratIndex + i;
                    if (!errorRowIndexs.contains(entryIndex)) continue;
                    isErrorData = true;
                    break;
                }
                if (isErrorData) continue;
                importableRowInfos.add(rowInfo);
                continue;
            }
            if (errorRowIndexs.contains(stratIndex)) continue;
            importableRowInfos.add(rowInfo);
        }
        return importableRowInfos;
    }
}

