/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hcdm.common.entity.adjfile.ImportRowEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ImportDataOperation {
    private static final Log log = LogFactory.getLog(ImportDataOperation.class);
    private static final String SALARYADJFILE = "salaryadjfile";
    private static final String SALARYADJFILE_NUMBER = "salaryadjfile.number";
    private static final String SEPARATOR = "\u3001";
    private OperateOption operateOption = OperateOption.create();
    private String statusKey = "status";
    private static final String OP_FORMSAVE = "save";
    private static final String OP_SAVEAFTERAUDIT = "saveafteraudit";

    public ImportDataOperation() {
    }

    public ImportDataOperation(OperateOption operateOption, String statusKey) {
        this.operateOption = operateOption;
        this.statusKey = statusKey;
    }

    public void executeImportData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportContext ctx, ImportLogger logger) {
        this.dealImportableData(rowInfos, mainEntityType, logger);
    }

    public void batchExecuteOp(String opName, List<DynamicObject> importDyList, Map<Long, ImportRowEntity> importRowEntityIdKeyMap, ImportLogger logger, String status) {
        try {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            this.operateOption.setVariableValue("status", status);
            this.operateOption.setVariableValue("ishasright", "true");
            this.operateOption.setVariableValue("currbizappid", "0VO5EV13=I9W");
            OperationResult operationResult = opImpl.localInvokeOperation(opName, importDyList.toArray(new DynamicObject[0]), this.operateOption);
            ImportDataOperation.batchDealOperationResult(operationResult, importRowEntityIdKeyMap, logger);
        }
        catch (Exception e) {
            log.error("executeOp error, msg: ", (Throwable)e);
            for (ImportRowEntity rowEntity : importRowEntityIdKeyMap.values()) {
                ImportDataOperation.log(rowEntity.getRowIndex(), e.getMessage(), logger);
            }
        }
    }

    private Set<String> getIgnoreKeysSet() {
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)8);
        keySet.add("status");
        keySet.add("enable");
        keySet.add("creator");
        keySet.add("createtime");
        keySet.add("masterid");
        keySet.add("ctrlstrategy");
        keySet.add("bsled");
        keySet.add("minbsed");
        return keySet;
    }

    private void dealImportableData(List<ImportRowEntity> importableRowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        if (CollectionUtils.isEmpty(importableRowInfos)) {
            return;
        }
        String currEntity = mainEntityType.getName();
        ArrayList needSaveList = Lists.newArrayListWithExpectedSize((int)importableRowInfos.size());
        HashMap importRowEntityIdKeyMap = Maps.newHashMapWithExpectedSize((int)importableRowInfos.size());
        ArrayList newHisDys = Lists.newArrayListWithExpectedSize((int)importableRowInfos.size());
        ArrayList needSaveWithStatusList = Lists.newArrayListWithExpectedSize((int)importableRowInfos.size());
        ArrayList needSaveWithStatusAList = Lists.newArrayListWithExpectedSize((int)importableRowInfos.size());
        for (ImportRowEntity importableRowInfo : importableRowInfos) {
            DynamicObject currEntityDyObj = importableRowInfo.getEntityDyobj(currEntity);
            String operation = importableRowInfo.getOperation();
            String status = (String)importableRowInfo.getStoreMapValue("status");
            long currEntityDyId = currEntityDyObj.getLong("id");
            importRowEntityIdKeyMap.put(currEntityDyId, importableRowInfo);
            if (SWCStringUtils.equals((String)status, (String)"A")) {
                needSaveWithStatusAList.add(currEntityDyObj);
                continue;
            }
            if (SWCStringUtils.equals((String)status, (String)"C")) {
                needSaveWithStatusList.add(currEntityDyObj);
                continue;
            }
            if (SWCStringUtils.equals((String)operation, (String)OP_FORMSAVE)) {
                needSaveList.add(currEntityDyObj);
                continue;
            }
            newHisDys.add(currEntityDyObj);
        }
        log.info("importRowEntityIdKeyMap size is {}, keyset is {}", (Object)importRowEntityIdKeyMap, (Object)SerializationUtils.toJsonString(importRowEntityIdKeyMap.keySet()));
        if (CollectionUtils.isNotEmpty((Collection)needSaveWithStatusList)) {
            log.info("needSaveWithStatusList size is {}", (Object)needSaveWithStatusList.size());
            this.batchExecuteOp(OP_FORMSAVE, needSaveWithStatusList, importRowEntityIdKeyMap, logger, "C");
        }
        if (CollectionUtils.isNotEmpty((Collection)needSaveList)) {
            log.info("needSaveList size is {}", (Object)needSaveList.size());
            this.batchExecuteOp(OP_FORMSAVE, needSaveList, importRowEntityIdKeyMap, logger, null);
        }
        if (CollectionUtils.isNotEmpty((Collection)newHisDys)) {
            log.info("newHisDys size is {}", (Object)newHisDys.size());
            this.batchExecuteOp(OP_SAVEAFTERAUDIT, newHisDys, importRowEntityIdKeyMap, logger, null);
        }
        if (CollectionUtils.isNotEmpty((Collection)needSaveWithStatusAList)) {
            log.info("needSaveWithStatusAList size is {}", (Object)needSaveWithStatusAList.size());
            this.batchExecuteOp(OP_FORMSAVE, needSaveWithStatusAList, importRowEntityIdKeyMap, logger, null);
        }
    }

    private static void batchDealOperationResult(OperationResult operationResult, Map<Long, ImportRowEntity> importRowEntityIdKeyMap, ImportLogger logger) {
        ImportRowEntity rowEntity2;
        log.info("operationResult isSuccess:{}", (Object)operationResult.isSuccess());
        List successPkIds = operationResult.getSuccessPkIds();
        log.info("importRowEntityIdKeyMap keyset is {}", (Object)SerializationUtils.toJsonString(importRowEntityIdKeyMap.keySet()));
        if (null != successPkIds && successPkIds.size() > 0) {
            List delRows = logger.getDelRows();
            log.info("operationResult success: delRows size is {}, delRows is {}", (Object)delRows.size(), (Object)SerializationUtils.toJsonString((Object)delRows));
            log.info("successPkIds is {}", (Object)SerializationUtils.toJsonString((Object)successPkIds));
            for (Object pkIdObj : successPkIds) {
                rowEntity2 = importRowEntityIdKeyMap.get(Long.valueOf(String.valueOf(pkIdObj)));
                if (rowEntity2 == null) continue;
                delRows.add(new int[]{rowEntity2.getRowIndex(), rowEntity2.getEndRowIndex()});
                logger.setDelRows(delRows);
                log.info("pkid is {}, delRows rowindex is {}, endrowindex is {}", new Object[]{Long.valueOf(String.valueOf(pkIdObj)), rowEntity2.getRowIndex(), rowEntity2.getEndRowIndex()});
            }
        }
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                rowEntity2 = importRowEntityIdKeyMap.get(Long.valueOf(String.valueOf(operateInfo.getPkValue())));
                if (rowEntity2 == null) continue;
                ImportDataOperation.log(rowEntity2.getRowIndex(), operateInfo.getMessage(), logger);
            }
            String msg = operationResult.getMessage();
            log.info("operationResult false msg is {}", (Object)msg);
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                for (ImportRowEntity rowEntity2 : importRowEntityIdKeyMap.values()) {
                    ImportDataOperation.log(rowEntity2.getRowIndex(), operationResult.getMessage(), logger);
                }
            }
        }
    }

    private static String assembleErrorMsg(Set<String> errors) {
        return StringUtils.join((Object[])errors.toArray(), (String)";");
    }

    public static void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

