/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.rpc.holders.StringHolder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.imports.perm.IPermissionHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportHelper {
    public static final String JOB_LEVEL_SCM_HEAD = "hbjm_joblevelscmhr&mulbasedatafield&1";
    public static final String JOB_GRADE_SCM_HEAD = "hbjm_jobgradescmhr&mulbasedatafield&1";

    public static Map<String, Map<String, List<DynamicObject>>> loadBaseData(Map<Integer, String> colKeyIndexMap, List<Map<Integer, String>> dataRow, IDataModel model, Map<String, IPermissionHandler> customQueryMethod, Map<String, String> queryFieldMap) {
        HashMap<String, Map<String, List<DynamicObject>>> map = new HashMap<String, Map<String, List<DynamicObject>>>();
        HashSet<String> longValues = new HashSet<String>();
        for (Map.Entry<Integer, String> entry : colKeyIndexMap.entrySet()) {
            String queryField;
            longValues.clear();
            int colIndex = entry.getKey();
            String propName = entry.getValue();
            DynamicProperty property = (DynamicProperty)model.getProperty(propName);
            String baseEntityId = null;
            StringHolder displayProp = new StringHolder("name");
            HashSet<String> values = new HashSet<String>();
            if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
                BasedataProp basedataProp;
                if (property instanceof BasedataProp) {
                    basedataProp = (BasedataProp)property;
                    baseEntityId = basedataProp.getBaseEntityId();
                    displayProp.value = basedataProp.getDisplayProp();
                    dataRow.stream().filter(map1 -> StringUtils.isNotEmpty((CharSequence)((CharSequence)map1.get(colIndex)))).forEach(map1 -> values.add((String)map1.get(colIndex)));
                }
                if (property instanceof MulBasedataProp) {
                    basedataProp = (MulBasedataProp)property;
                    ImportHelper.setValues(dataRow, longValues, colIndex, values);
                    baseEntityId = basedataProp.getBaseEntityId();
                    if (null != basedataProp.getDisplayProp()) {
                        displayProp.value = basedataProp.getDisplayProp();
                    }
                }
            }
            String string = queryField = queryFieldMap == null ? null : queryFieldMap.get(propName);
            if (StringUtils.isNotBlank((CharSequence)queryField)) {
                displayProp.value = queryField;
            }
            if (JOB_LEVEL_SCM_HEAD.equals(propName)) {
                baseEntityId = "hbjm_joblevelscmhr";
                ImportHelper.setValues(dataRow, longValues, colIndex, values);
            } else if (JOB_GRADE_SCM_HEAD.equals(propName)) {
                baseEntityId = "hbjm_jobgradescmhr";
                ImportHelper.setValues(dataRow, longValues, colIndex, values);
            }
            if (StringUtils.isEmpty((CharSequence)baseEntityId) || StringUtils.isEmpty((CharSequence)displayProp.value) || values.isEmpty() && longValues.isEmpty()) {
                map.put(propName, Maps.newHashMap());
                continue;
            }
            DynamicObject[] objects = null;
            if (!values.isEmpty()) {
                Object[] permissionFilter;
                IPermissionHandler function;
                ArrayList allFilter = Lists.newArrayList();
                allFilter.add(new QFilter(displayProp.value, "in", values));
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                if (dataEntityType.getProperty("iscurrentversion") != null) {
                    allFilter.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
                }
                if ((function = customQueryMethod.get(propName)) != null && (permissionFilter = function.getPermissionFilter()).length > 0) {
                    allFilter.addAll(Lists.newArrayList((Object[])permissionFilter));
                }
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                String props = "id," + displayProp.value;
                if ("hbjm_joblevelhr".equals(baseEntityId)) {
                    props = props + ",joblevelscm,joblevelscm.id";
                } else if ("hbjm_jobgradehr".equals(baseEntityId)) {
                    props = props + ",jobgradescm,jobgradescm.id";
                }
                objects = serviceHelper.query(props, allFilter.toArray(new QFilter[0]));
            }
            if (objects == null) continue;
            Map<String, List<DynamicObject>> dbData = Arrays.stream(objects).collect(Collectors.groupingBy(object -> object.getString(displayProp.value)));
            map.putIfAbsent(propName, dbData);
        }
        return map;
    }

    private static void setValues(List<Map<Integer, String>> dataRow, Set<String> longValues, int colIndex, Set<String> values) {
        for (Map<Integer, String> colMap : dataRow) {
            String[] strings;
            String colString = colMap.get(colIndex);
            if (!StringUtils.isNotEmpty((CharSequence)colString)) continue;
            for (String string : strings = colString.split(";")) {
                if (string.length() < 80) {
                    values.add(string);
                    continue;
                }
                longValues.add(string);
            }
        }
    }

    public static Map<String, Map<String, DynamicObject>> loadBaseDataWithPermission(Map<Integer, String> colKeyIndexMap, List<Map<Integer, String>> dataRow, IDataModel model, Map<String, IPermissionHandler> permissionHandlerMap) {
        HashMap<String, Map<String, DynamicObject>> map = new HashMap<String, Map<String, DynamicObject>>();
        for (Map.Entry<Integer, String> entry : colKeyIndexMap.entrySet()) {
            BasedataProp basedataProp;
            int colIndex = entry.getKey();
            String propName = entry.getValue();
            DynamicProperty property = (DynamicProperty)model.getProperty(propName);
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) continue;
            String baseEntityId = null;
            StringHolder displayProp = new StringHolder();
            HashSet values = new HashSet();
            HashSet<String> refProperties = new HashSet<String>();
            if (property instanceof BasedataProp) {
                basedataProp = (BasedataProp)property;
                baseEntityId = basedataProp.getBaseEntityId();
                displayProp.value = basedataProp.getDispProp().getName();
                DataEntityPropertyCollection properties = basedataProp.getDynamicComplexPropertyType().getProperties();
                for (IDataEntityProperty dataEntityProperty : properties) {
                    refProperties.add(dataEntityProperty.getName());
                }
                dataRow.stream().filter(map1 -> StringUtils.isNotEmpty((CharSequence)((CharSequence)map1.get(colIndex)))).forEach(map1 -> values.add(map1.get(colIndex)));
            }
            if (property instanceof MulBasedataProp) {
                basedataProp = (MulBasedataProp)property;
                dataRow.stream().filter(map1 -> StringUtils.isNotEmpty((CharSequence)((CharSequence)map1.get(colIndex)))).forEach(map1 -> values.addAll(Arrays.asList(((String)map1.get(colIndex)).split(";"))));
                baseEntityId = basedataProp.getBaseEntityId();
                displayProp.value = basedataProp.getDisplayProp();
            }
            if (StringUtils.isEmpty(baseEntityId) || StringUtils.isEmpty((CharSequence)displayProp.value) || values.isEmpty()) {
                map.put(propName, Maps.newHashMap());
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            QFilter valueFilter = new QFilter(displayProp.value, "in", values);
            Object[] allFilter = new QFilter[]{valueFilter};
            IPermissionHandler permissionHandler = permissionHandlerMap.get(propName);
            if (permissionHandler != null) {
                Object[] permissionFilter = permissionHandler.getPermissionFilter();
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])permissionFilter, (Object[])allFilter);
            }
            if (dataEntityType.getProperty("iscurrentversion") != null) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE)});
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
            String refProperty = SWCListUtils.join(refProperties, (String)",");
            DynamicObject[] objects = serviceHelper.query("id," + refProperty + displayProp, (QFilter[])allFilter);
            Map dbData = Arrays.stream(objects).collect(Collectors.toMap(object -> object.getString(displayProp.value), Function.identity()));
            map.putIfAbsent(propName, dbData);
        }
        return map;
    }
}

