/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports.builder;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IBaseDataService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.swc.hcdm.business.imports.builder.SXSSFWorkbookBuilder;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class AdjDecisionSXSSFWorkbookBuilder
extends SXSSFWorkbookBuilder {
    private static String PROPERTY = "property";
    private static String ALIAS = "alias";
    private static String SHEET_NAME = "sheetName";

    private AdjDecisionSXSSFWorkbookBuilder() {
        this.wb = new SXSSFWorkbook(5000);
        this.wb.setCompressTempFiles(true);
    }

    public static AdjDecisionSXSSFWorkbookBuilder newInstance() {
        AdjDecisionSXSSFWorkbookBuilder builder = new AdjDecisionSXSSFWorkbookBuilder();
        return builder;
    }

    public AdjDecisionSXSSFWorkbookBuilder prepareExportData(String routeAppId, String formId, String templateId, String plugin, String extenddata) {
        String exportJSon = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, Long.parseLong(templateId), plugin == null ? "" : plugin, extenddata});
        List format = JSON.parseArray((String)exportJSon, ExportWriterFormat.class);
        SXSSFSheet sheet = this.wb.createSheet(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f", (String)"AdjFileSXSSFWorkbookBuilder_70", (String)"swc-hcdm-business", (Object[])new Object[0]));
        ExportSheetStyle styles = new ExportSheetStyle(this.wb);
        ExportWriter.writeHeader((SXSSFWorkbook)this.wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (List)format);
        byte[] rgb = new byte[]{110, 40, 10};
        XSSFColor color = new XSSFColor();
        color.setRGB(rgb);
        sheet.setTabColor(color);
        return this;
    }

    public AdjDecisionSXSSFWorkbookBuilder prepareExportCreateOrg(IBaseDataService baseDataService, String entityName, Map<String, Object> properties) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("fishr", "=", (Object)"1"));
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"0VO5EV13=I9W", (String)"hcdm_bizdata");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        if (!hasAllOrgPerm) {
            filter.and(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        return this.prepareExport(entityName, properties, filter);
    }

    public AdjDecisionSXSSFWorkbookBuilder prepareExportAdminOrg(IBaseDataService baseDataService, String entityName, Map<String, Object> properties) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        AuthorizedOrgResult authorizedAdminOrgs = SWCPermissionServiceHelper.getAuthorizedAdminOrgs((String)"0VO5EV13=I9W", (String)"hcdm_bizdata", (String)"47150e89000000ac", (String)"adminorg");
        if (!authorizedAdminOrgs.isHasAllOrgPerm()) {
            filter.and(new QFilter("id", "in", (Object)authorizedAdminOrgs.getHasPermOrgs()));
        }
        return this.prepareExport(entityName, properties, filter);
    }

    public AdjDecisionSXSSFWorkbookBuilder prepareExportBizItemAndCategory(IBaseDataService baseDataService, String entityName, Map<String, Object> properties) {
        List propertyList = (List)properties.get(PROPERTY);
        List alias = (List)properties.get(ALIAS);
        String selectProperties = this.conversionFormat(propertyList);
        DynamicObjectCollection bizItemCollection = this.queryBizItemData(baseDataService, entityName, selectProperties);
        if (bizItemCollection != null && bizItemCollection.size() > 0) {
            ArrayList<List<String>> datas = new ArrayList<List<String>>(bizItemCollection.size());
            SXSSFSheet sheet = this.wb.createSheet((String)properties.get(SHEET_NAME));
            this.createTitle(sheet, alias);
            sheet.trackAllColumnsForAutoSizing();
            for (DynamicObject bizItemDyObj : bizItemCollection) {
                ArrayList<String> rowdata = new ArrayList<String>(2);
                String bizItemCategoryName = bizItemDyObj.getString("bizitemcategory.name");
                String bizItemName = bizItemDyObj.getString("name");
                rowdata.add(bizItemCategoryName);
                rowdata.add(bizItemName);
                datas.add(rowdata);
            }
            this.createDataRows(sheet, datas);
        }
        return this;
    }

    private DynamicObjectCollection queryBizItemData(IBaseDataService baseDataService, String entityName, String selectProperties) {
        long orgID = RequestContext.get().getOrgId();
        QFilter bdFilter = baseDataService.getBaseDataFilter(entityName, Long.valueOf(orgID));
        return new SWCDataServiceHelper(entityName).queryOriginalCollection(selectProperties, new QFilter[]{bdFilter});
    }

    private AdjDecisionSXSSFWorkbookBuilder prepareExport(String entityName, Map<String, Object> properties, QFilter filter) {
        List propertyList = (List)properties.get(PROPERTY);
        String selectProperties = this.conversionFormat(propertyList);
        DynamicObject[] dynamicObjects = new SWCDataServiceHelper(entityName).query(selectProperties, new QFilter[]{filter});
        List alias = (List)properties.get(ALIAS);
        SXSSFSheet sheet = this.wb.createSheet((String)properties.get(SHEET_NAME));
        this.createTitle(sheet, alias);
        ArrayList<List<String>> datas = new ArrayList<List<String>>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            ArrayList<String> rowdata = new ArrayList<String>(propertyList.size());
            for (String property : propertyList) {
                rowdata.add(dynamicObject.getString(property));
            }
            datas.add(rowdata);
        }
        this.createDataRows(sheet, datas);
        sheet.trackAllColumnsForAutoSizing();
        return this;
    }

    private String conversionFormat(List<String> properties) {
        StringJoiner sj = new StringJoiner(",", "", "");
        for (String property : properties) {
            sj.add(property);
        }
        return sj.toString();
    }

    private void createDataRows(SXSSFSheet sheet, List<List<String>> datas) {
        if (datas != null) {
            int index = 1;
            CellStyle style = null;
            for (List<String> data : datas) {
                SXSSFRow row = sheet.createRow(index);
                int cellIndex = 0;
                for (String rowdata : data) {
                    if (style == null) {
                        style = this.wb.createCellStyle();
                        this.setBorderStyle(style);
                    }
                    Cell cell1 = row.createCell((int)((short)cellIndex));
                    cell1.setCellValue(rowdata);
                    cell1.setCellStyle(style);
                    ++cellIndex;
                }
                ++index;
            }
        }
    }

    public static Map<String, Object> propertie(String entityName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        LocaleString entityCaption = mainEntityType.getDisplayName();
        String localeValue = entityCaption.getLocaleValue();
        String[] propertyName = new String[]{"number", "name"};
        String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"AdjFileSXSSFWorkbookBuilder_57", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AdjFileSXSSFWorkbookBuilder_58", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String[] propertyAlias = new String[]{localeValue + number, localeValue + name};
        return AdjDecisionSXSSFWorkbookBuilder.propertie(localeValue, propertyName, propertyAlias);
    }

    public static Map<String, Object> propertie(String entityName, String title) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        LocaleString entityCaption = mainEntityType.getDisplayName();
        String localeValue = title;
        if (StringUtils.isBlank((CharSequence)title)) {
            localeValue = entityCaption.getLocaleValue();
        }
        String[] propertyName = new String[]{"number", "name"};
        String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"AdjFileSXSSFWorkbookBuilder_57", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AdjFileSXSSFWorkbookBuilder_58", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String[] propertyAlias = new String[]{localeValue + number, localeValue + name};
        return AdjDecisionSXSSFWorkbookBuilder.propertie(localeValue, propertyName, propertyAlias);
    }

    public static Map<String, Object> propertie(String title, String[] propertyName, String[] propertyAlias) {
        HashMap<String, Object> propertie = new HashMap<String, Object>(2);
        List<String> property = Arrays.asList(propertyName);
        propertie.put(PROPERTY, property);
        propertie.put(SHEET_NAME, title);
        List<String> alias = Arrays.asList(propertyAlias);
        propertie.put(ALIAS, alias);
        return propertie;
    }
}

