/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports.builder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IBaseDataService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.swc.hcdm.business.imports.builder.SXSSFWorkbookBuilder;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class AdjFileSXSSFWorkbookBuilder
extends SXSSFWorkbookBuilder {
    private static Log logger = LogFactory.getLog(AdjFileSXSSFWorkbookBuilder.class);
    private static String PROPERTY = "property";
    private static String ALIAS = "alias";
    private static String SHEET_NAME = "sheetName";
    private static String[] propertyName = new String[]{"entryentity", "entryentity.salstructurent", "entryentity.salstructurent.name", "number", "name"};

    private AdjFileSXSSFWorkbookBuilder() {
        this.wb = new SXSSFWorkbook(5000);
        this.wb.setCompressTempFiles(true);
    }

    public static AdjFileSXSSFWorkbookBuilder newInstance() {
        AdjFileSXSSFWorkbookBuilder builder = new AdjFileSXSSFWorkbookBuilder();
        return builder;
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportData(String routeAppId, String formId, String templateId, String plugin, String extenddata) {
        String exportJSon = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, Long.parseLong(templateId), plugin == null ? "" : plugin, extenddata});
        List format = JSON.parseArray((String)exportJSon, ExportWriterFormat.class);
        this.convertDecimalFormat(format);
        SXSSFSheet sheet = this.wb.createSheet(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f", (String)"AdjFileSXSSFWorkbookBuilder_70", (String)"swc-hcdm-business", (Object[])new Object[0]));
        ExportSheetStyle styles = new ExportSheetStyle(this.wb);
        ExportWriter.writeHeader((SXSSFWorkbook)this.wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (List)format);
        byte[] rgb = new byte[]{110, 40, 10};
        XSSFColor color = new XSSFColor();
        color.setRGB(rgb);
        sheet.setTabColor(color);
        return this;
    }

    private void convertDecimalFormat(List<ExportWriterFormat> formats) {
        for (ExportWriterFormat format : formats) {
            List nexts = format.next;
            if (nexts == null) continue;
            for (ExportWriterFormat next : nexts) {
                Map properties = next.properties;
                Map standardamountMap = (Map)properties.get("standardamount");
                if (CollectionUtils.isEmpty((Map)standardamountMap)) continue;
                JSONObject standardamountDecimalFormat = (JSONObject)standardamountMap.get("DecimalFormat");
                standardamountDecimalFormat.put("precision", (Object)2);
            }
        }
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportExplain(String title, String importInfoMsg, String[][] arrs, int rowEntryNum) {
        SXSSFSheet sheet = this.wb.createSheet(ResManager.loadKDString((String)"\u5bfc\u5165\u8bf4\u660e", (String)"AdjFileSXSSFWorkbookBuilder_71", (String)"swc-hcdm-business", (Object[])new Object[0]));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 14));
        sheet.addMergedRegion(new CellRangeAddress(1, rowEntryNum - 1, 0, 14));
        for (int r = 0; r < rowEntryNum; ++r) {
            SXSSFRow row = sheet.createRow(r);
            for (int c = 0; c < rowEntryNum - 1; ++c) {
                this.setBorder(this.wb, (Row)row);
            }
        }
        this.importInfoTitle(sheet, title);
        this.importInfoContent(sheet, importInfoMsg);
        this.importInfoEntryEntity(sheet, arrs, rowEntryNum);
        return this;
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportBusinessOrg(IBaseDataService baseDataService, String entityName, Map<String, Object> propertie) {
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        if (!superUser) {
            String appId = "0VO5EV13=I9W";
            String entityNumber = "hcdm_adjfileinfo";
            String permItemId = "47156aff000000ac";
            HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)appId, (String)entityNumber, (String)permItemId);
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            filter.and(new QFilter("id", "in", (Object)hasPermOrgs));
        }
        return this.prepareExport(entityName, propertie, new QFilter[]{filter});
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportCountry(IBaseDataService baseDataService, String entityName, Map<String, Object> propertie) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        Set countrySetByPermItem = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (countrySetByPermItem != null) {
            logger.info("countrySetByPermItem = {}", (Object)countrySetByPermItem);
            filter.and(new QFilter("id", "in", (Object)countrySetByPermItem));
        }
        return this.prepareExport(entityName, propertie, new QFilter[]{filter});
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportStdScm(IBaseDataService baseDataService, String entityName) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        long orgID = RequestContext.get().getOrgId();
        QFilter bdFilter = baseDataService.getBaseDataFilter("hcdm_stdscm", Long.valueOf(orgID));
        filter.and(bdFilter);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        Set countrySetByPermItem = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (countrySetByPermItem != null) {
            logger.info("countrySetByPermItem = {}", (Object)countrySetByPermItem);
            filter.and(new QFilter("country", "in", (Object)countrySetByPermItem));
        }
        return this.prepareStdScmExport(entityName, new QFilter[]{filter});
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportDepemp(IBaseDataService baseDataService, String entityName, Map<String, Object> propertie) {
        QFilter filter = SalaryAdjFileServiceHelper.getEmpGroupFilter("id");
        return this.prepareExport(entityName, propertie, new QFilter[]{filter});
    }

    public AdjFileSXSSFWorkbookBuilder prepareExportAdminOrg(IBaseDataService baseDataService, String entityName, Map<String, Object> propertie) {
        String permItemId;
        String entityNumber;
        String appId;
        Set adminOrgSet;
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        if (!superUser && null != (adminOrgSet = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)(appId = "0VO5EV13=I9W"), (String)(entityNumber = "hcdm_adjfileinfo"), (String)(permItemId = "47156aff000000ac"), (String)"assoadminorg"))) {
            filter.and(new QFilter("id", "in", (Object)adminOrgSet));
        }
        return this.prepareExport(entityName, propertie, new QFilter[]{filter});
    }

    private AdjFileSXSSFWorkbookBuilder prepareExport(String entityName, Map<String, Object> propertie, QFilter[] filter) {
        List propertyList = (List)propertie.get(PROPERTY);
        String selectProperties = this.conversionFormat(propertyList);
        DynamicObject[] dynamicObjects = new SWCDataServiceHelper(entityName).query(selectProperties, filter);
        List alias = (List)propertie.get(ALIAS);
        SXSSFSheet sheet = this.wb.createSheet((String)propertie.get(SHEET_NAME));
        sheet.trackAllColumnsForAutoSizing();
        this.createTitle(sheet, alias);
        ArrayList<List<String>> datas = new ArrayList<List<String>>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            ArrayList<String> rowdata = new ArrayList<String>(propertyList.size());
            for (String property : propertyList) {
                rowdata.add(dynamicObject.getString(property));
            }
            datas.add(rowdata);
        }
        this.createDataRows(sheet, datas);
        return this;
    }

    public static String buildAdjFileInfoImportInfoMsg() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u4e00\u3001\u5bfc\u5165\u6a21\u677f", (String)"AdjFileSXSSFWorkbookBuilder_72", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"1\uff09\u6a21\u677f\u4e2d*\u53f7\u5747\u4e3a\u5fc5\u586b\u9879\u5b57\u6bb5\u3002", (String)"AdjFileSXSSFWorkbookBuilder_13", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"2\uff09\u6a21\u677f\u4e2d\u6d89\u53ca\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\"\u3001\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u53ef\u901a\u8fc7\u5bf9\u5e94\u7684\u9875\u7b7e\u67e5\u627e\u3002", (String)"AdjFileSXSSFWorkbookBuilder_52", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n').append('\n');
        sb.append(ResManager.loadKDString((String)"\u4e8c\u3001\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u9875\u7b7e", (String)"AdjFileSXSSFWorkbookBuilder_53", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"1\uff09\u9875\u7b7e\u6570\u636e\u5747\u4e3a\u4e0b\u8f7d\u6a21\u677f\u8005\u6743\u9650\u8303\u56f4\u5185\u7684\u6570\u636e\u3002", (String)"AdjFileSXSSFWorkbookBuilder_16", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"2\uff09\u82e5\u65e0\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u6743\u9650\uff0c\u5bf9\u5e94\u9875\u7b7e\u65e0\u6570\u636e\u3002", (String)"AdjFileSXSSFWorkbookBuilder_54", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n').append('\n');
        sb.append(ResManager.loadKDString((String)"\u4e09\u3001\u5bfc\u5165\u6570\u636e\u5904\u7406", (String)"AdjFileSXSSFWorkbookBuilder_73", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"1\uff09\u6821\u9a8c\u89c4\u5219\uff1a", (String)"AdjFileSXSSFWorkbookBuilder_19", (String)"swc-hcdm-business", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u662f\u5426\u586b\u5199\uff08\u5e26*\u53f7\u7684\u6570\u636e\u5747\u9700\u586b\u5199\uff09", (String)"AdjFileSXSSFWorkbookBuilder_20", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\u3001').append(ResManager.loadKDString((String)"\u91cd\u590d\u6570\u636e\uff08\u5728\u5bfc\u5165\u6a21\u677f\u7684\u4e0d\u540c\u884c\u5fc5\u586b\u9879\u6570\u636e\u4e0d\u80fd\u5b8c\u5168\u4e00\u81f4\uff09", (String)"AdjFileSXSSFWorkbookBuilder_74", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\u3001').append(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff08\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u9700\u901a\u8fc7\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u67e5\u627e\u7684\u6570\u636e\uff0c\u586b\u5199\u6570\u636e\u4e0d\u5728\u6b64\u8303\u56f4\u5185\uff09", (String)"AdjFileSXSSFWorkbookBuilder_80", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"2\uff09\u65b0\u589e\u6863\u6848\u4e0e\u66f4\u65b0\u6863\u6848\u5bfc\u5165\u5b9a\u8c03\u85aa\u6863\u6848\u5b58\u5728\u5dee\u5f02\u7684\u90e8\u5206\u4e3a\u6863\u6848\u7f16\u53f7\u3001\u4e1a\u52a1\u7f16\u7801\uff1a", (String)"AdjFileSXSSFWorkbookBuilder_81", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff1a", (String)"AdjFileSXSSFWorkbookBuilder_60", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"a.\u65b0\u589e\u6863\u6848\uff1a\u6b64\u5b57\u6bb5\u975e\u5fc5\u586b\uff1b", (String)"AdjFileSXSSFWorkbookBuilder_61", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"b.\u66f4\u65b0\u6863\u6848\uff1a\u6b64\u5b57\u6bb5\u5fc5\u586b\uff0c\u53ef\u4ece\u5df2\u5efa\u7acb\u7684\u4eba\u5458\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u5904\u67e5\u627e\u6863\u6848\u7f16\u53f7\u4fe1\u606f\u3002", (String)"AdjFileSXSSFWorkbookBuilder_62", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u7801\uff1a\u8bc6\u522b\u4eba\u5458\u4efb\u804c\u7ecf\u5386\u7684\u552f\u4e00\u7f16\u7801\u3002", (String)"AdjFileSXSSFWorkbookBuilder_63", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"a.\u65b0\u589e\u6863\u6848\uff1a\u901a\u8fc7\u65b0\u589e\u6863\u6848\u9875\u9762-\u4eba\u5458\u5f39\u7a97\u4e2d\u67e5\u627e\uff1b", (String)"AdjFileSXSSFWorkbookBuilder_64", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"b.\u66f4\u65b0\u6863\u6848\uff1a\u901a\u8fc7\u5df2\u5efa\u7acb\u7684\u6863\u6848\u57fa\u672c\u4fe1\u606f\u5904\u67e5\u627e\u3002", (String)"AdjFileSXSSFWorkbookBuilder_65", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n');
        sb.append(ResManager.loadKDString((String)"%s\uff09\u5bfc\u5165\u6570\u636e\u7248\u672c\u5904\u7406\u4e3e\u4f8b\u5982\u4e0b\uff1a", (String)"AdjFileSXSSFWorkbookBuilder_75", (String)"swc-hcdm-business", (Object[])new Object[]{3})).append('\n');
        sb.append(ResManager.loadKDString((String)"\u573a\u666f\uff1a\u5f20\u4e090001\u7684\u5b9a\u8c03\u85aa\u6863\u6848\u7f16\u53f7\u4e2d\u6863\u6848\u57fa\u672c\u4fe1\u606f\u7684\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u4eceA\u8c03\u6574\u5230\u4e86B\uff0c\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u3001\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u5747\u672a\u53d8\u5316\uff0c\u9700\u5728\u7cfb\u7edf\u4e2d\u5bfc\u5165\u6b64\u6761\u6570\u636e\u3002", (String)"AdjFileSXSSFWorkbookBuilder_82", (String)"swc-hcdm-business", (Object[])new Object[0])).append('\n').append('\n');
        return sb.toString();
    }

    private void importInfoEntryEntity(SXSSFSheet sheet, String[][] arrs, int rowEntryNum) {
        for (int i = 0; i < arrs.length; ++i) {
            String[] rowDatas = arrs[i];
            SXSSFRow rowEntry = sheet.createRow(rowEntryNum + i);
            rowEntry.setHeight((short)512);
            for (int j = 0; j < rowDatas.length; ++j) {
                String str = rowDatas[j];
                CellStyle style = this.wb.createCellStyle();
                if (i == 0) {
                    style = this.getAndSetXSSFCellStyleHeader();
                }
                style.setAlignment(HorizontalAlignment.CENTER);
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setWrapText(true);
                Cell cellData = rowEntry.createCell((int)((short)j));
                cellData.setCellValue(str);
                this.setBorderStyle(style);
                cellData.setCellStyle(style);
                int tempColIndex = j;
                if (j + 1 < rowDatas.length && StringUtils.isNotBlank((CharSequence)rowDatas[j])) {
                    while (StringUtils.isBlank((CharSequence)rowDatas[tempColIndex + 1])) {
                        ++tempColIndex;
                    }
                }
                int tempRowIndex = i;
                if (i + 1 < arrs.length && StringUtils.isNotBlank((CharSequence)str)) {
                    String[] nextRowDataList = arrs[tempRowIndex + 1];
                    while (StringUtils.isBlank((CharSequence)nextRowDataList[j]) && ++tempRowIndex + 1 != arrs.length) {
                        if (tempRowIndex + 1 >= arrs.length) continue;
                        nextRowDataList = arrs[tempRowIndex + 1];
                    }
                }
                if (tempRowIndex == i && tempColIndex == j) continue;
                sheet.addMergedRegion(new CellRangeAddress(rowEntryNum + i, rowEntryNum + tempRowIndex, j, tempColIndex));
            }
        }
    }

    public static String[][] getAdjFileInfoImportInfoEntryArray() {
        String importSucceed = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"AdjFileSXSSFWorkbookBuilder_76", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String deleted = ResManager.loadKDString((String)"\u5df2\u5220\u9664", (String)"AdjFileSXSSFWorkbookBuilder_25", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String haveEffect = ResManager.loadKDString((String)"\u5386\u53f2\u751f\u6548", (String)"AdjFileSXSSFWorkbookBuilder_26", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String effecting = ResManager.loadKDString((String)"\u751f\u6548\u4e2d", (String)"AdjFileSXSSFWorkbookBuilder_27", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String trueStr = ResManager.loadKDString((String)"\u662f", (String)"AdjFileSXSSFWorkbookBuilder_28", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String falseStr = ResManager.loadKDString((String)"\u5426", (String)"AdjFileSXSSFWorkbookBuilder_29", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String depemp = ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\uff1a", (String)"AdjFileSXSSFWorkbookBuilder_51", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String waitEffect = ResManager.loadKDString((String)"\u5f85\u751f\u6548", (String)"AdjFileSXSSFWorkbookBuilder_66", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String unEffect = ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"AdjFileSXSSFWorkbookBuilder_67", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String exampleA = "A";
        String exampleB = "B";
        String startDate = "2021.01.01";
        String beforeToAfter = "2021.01.01-2999.12.31";
        return new String[][]{{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AdjFileSXSSFWorkbookBuilder_31", (String)"swc-hcdm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u662f\u5426\u5b58\u5728\u6570\u636e\uff1f", (String)"AdjFileSXSSFWorkbookBuilder_32", (String)"swc-hcdm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6570\u636e\u751f\u5931\u6548\u65e5\u671f", (String)"AdjFileSXSSFWorkbookBuilder_33", (String)"swc-hcdm-business", (Object[])new Object[0]), " ", ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u751f\u6548\u65e5\u671f", (String)"AdjFileSXSSFWorkbookBuilder_77", (String)"swc-hcdm-business", (Object[])new Object[0]), " ", " ", ResManager.loadKDString((String)"\u5bfc\u5165\u72b6\u6001", (String)"AdjFileSXSSFWorkbookBuilder_78", (String)"swc-hcdm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f", (String)"AdjFileSXSSFWorkbookBuilder_68", (String)"swc-hcdm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u540e\u751f\u5931\u6548\u65e5\u671f", (String)"AdjFileSXSSFWorkbookBuilder_79", (String)"swc-hcdm-business", (Object[])new Object[0]), " ", " ", " ", " ", ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u72b6\u6001", (String)"AdjFileSXSSFWorkbookBuilder_37", (String)"swc-hcdm-business", (Object[])new Object[0])}, {"1", falseStr, "/", " ", startDate + '\n' + depemp + exampleA, " ", " ", importSucceed, startDate, beforeToAfter + '\n' + depemp + exampleA, " ", " ", " ", " ", effecting}, {"2", trueStr, beforeToAfter + '\n' + depemp + exampleA, " ", "2021.05.01\n" + depemp + exampleB, " ", " ", importSucceed, startDate, "2021.01.01-2021.04.30\n" + depemp + exampleA, " ", " ", " ", " ", effecting}, {" ", " ", " ", " ", " ", " ", " ", " ", " ", "2021.05.01-2999.12.31\n" + depemp + exampleB, " ", " ", " ", " ", waitEffect}, {"3", trueStr, beforeToAfter + '\n' + depemp + exampleA, " ", startDate + '\n' + depemp + exampleB, " ", " ", importSucceed, startDate, beforeToAfter + '\n' + depemp + exampleA, " ", " ", " ", " ", deleted}, {" ", " ", " ", " ", " ", " ", " ", " ", " ", beforeToAfter + '\n' + depemp + exampleB, " ", " ", " ", " ", effecting}, {"4", trueStr, beforeToAfter + '\n' + depemp + exampleA, " ", "2020.12.01\n" + depemp + exampleB, " ", " ", importSucceed, startDate, "2020.12.01-2020.12.31\n" + depemp + exampleB, " ", " ", " ", " ", unEffect}, {" ", " ", " ", " ", " ", " ", " ", " ", " ", beforeToAfter + '\n' + depemp + exampleA, " ", " ", " ", " ", effecting}};
    }

    private void importInfoContent(SXSSFSheet sheet, String importInfoMsg) {
        SXSSFRow row1 = sheet.createRow(1);
        this.setBorder(this.wb, (Row)row1);
        Cell cell1 = row1.createCell(0);
        CellStyle cellStyle1 = this.wb.createCellStyle();
        cellStyle1.setWrapText(true);
        this.setBorderStyle(cellStyle1);
        cell1.setCellStyle(cellStyle1);
        cell1.setCellValue(importInfoMsg);
    }

    private void importInfoTitle(SXSSFSheet sheet, String title) {
        int rownum = 0;
        SXSSFRow row = sheet.createRow(rownum);
        this.setBorder(this.wb, (Row)row);
        Cell cell = row.createCell(0);
        CellStyle cellStyle = this.wb.createCellStyle();
        Font headerFont = this.wb.createFont();
        headerFont.setBold(true);
        cellStyle.setFont(headerFont);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.setBorderStyle(cellStyle);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(title);
    }

    private void createDataRows(SXSSFSheet sheet, List<List<String>> datas) {
        if (datas != null) {
            int index = 1;
            CellStyle style = null;
            for (List<String> data : datas) {
                SXSSFRow row = sheet.createRow(index);
                int cellIndex = 0;
                for (String rowdata : data) {
                    if (style == null) {
                        style = this.wb.createCellStyle();
                        this.setBorderStyle(style);
                    }
                    Cell cell1 = row.createCell((int)((short)cellIndex));
                    cell1.setCellValue(rowdata);
                    cell1.setCellStyle(style);
                    ++cellIndex;
                }
                ++index;
            }
        }
    }

    private String conversionFormat(List<String> properties) {
        StringJoiner sj = new StringJoiner(",", "", "");
        for (String property : properties) {
            sj.add(property);
        }
        return sj.toString();
    }

    public static Map<String, Object> propertie(String entityName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        LocaleString entityCaption = mainEntityType.getDisplayName();
        String localeValue = entityCaption.getLocaleValue();
        String[] propertyName = new String[]{"number", "name"};
        String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"AdjFileSXSSFWorkbookBuilder_57", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AdjFileSXSSFWorkbookBuilder_58", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String[] propertyAlias = new String[]{localeValue + number, localeValue + name};
        return AdjFileSXSSFWorkbookBuilder.propertie(localeValue, propertyName, propertyAlias);
    }

    public static Map<String, Object> propertie(String entityName, String title) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        LocaleString entityCaption = mainEntityType.getDisplayName();
        String localeValue = title;
        if (StringUtils.isBlank((CharSequence)title)) {
            localeValue = entityCaption.getLocaleValue();
        }
        String[] propertyName = new String[]{"number", "name"};
        String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"AdjFileSXSSFWorkbookBuilder_57", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AdjFileSXSSFWorkbookBuilder_58", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String[] propertyAlias = new String[]{localeValue + number, localeValue + name};
        return AdjFileSXSSFWorkbookBuilder.propertie(localeValue, propertyName, propertyAlias);
    }

    public static Map<String, Object> propertie(String title, String[] propertyName, String[] propertyAlias) {
        HashMap<String, Object> propertie = new HashMap<String, Object>(2);
        List<String> property = Arrays.asList(propertyName);
        propertie.put(PROPERTY, property);
        propertie.put(SHEET_NAME, title);
        List<String> alias = Arrays.asList(propertyAlias);
        propertie.put(ALIAS, alias);
        return propertie;
    }

    private AdjFileSXSSFWorkbookBuilder prepareStdScmExport(String entityName, QFilter[] filter) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        LocaleString entityCaption = mainEntityType.getDisplayName();
        String localeValue = entityCaption.getLocaleValue();
        String salaystructureName = ResManager.loadKDString((String)"\u85aa\u916c\u7ed3\u6784", (String)"AdjFileSXSSFWorkbookBuilder_69", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String number = ResManager.loadKDString((String)"\u7f16\u7801", (String)"AdjFileSXSSFWorkbookBuilder_57", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u540d\u79f0", (String)"AdjFileSXSSFWorkbookBuilder_58", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String[] propertyAlias = new String[]{salaystructureName, localeValue + number, localeValue + name};
        Map<String, Object> propertie = AdjFileSXSSFWorkbookBuilder.propertie(localeValue, propertyName, propertyAlias);
        List propertyList = (List)propertie.get(PROPERTY);
        String selectProperties = this.conversionFormat(propertyList);
        DynamicObject[] dynamicObjects = new SWCDataServiceHelper(entityName).query(selectProperties, filter);
        List alias = (List)propertie.get(ALIAS);
        SXSSFSheet sheet = this.wb.createSheet((String)propertie.get(SHEET_NAME));
        sheet.trackAllColumnsForAutoSizing();
        this.createTitle(sheet, alias);
        ArrayList<List<String>> datas = new ArrayList<List<String>>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)entryentity.size());
                for (DynamicObject salaystructure : entryentity) {
                    long salayStructurerId = salaystructure.getLong("salstructurent.id");
                    ArrayList<String> rowdata = new ArrayList<String>(propertyList.size());
                    if (0L == salayStructurerId || ids.contains(salayStructurerId)) {
                        if (entryentity.size() != 1) continue;
                        rowdata.add("");
                        rowdata.add(dynamicObject.getString("number"));
                        rowdata.add(dynamicObject.getString("name"));
                        datas.add(rowdata);
                        continue;
                    }
                    ids.add(salayStructurerId);
                    String salaystructurerName = salaystructure.getString("salstructurent.name");
                    rowdata.add(salaystructurerName);
                    rowdata.add(dynamicObject.getString("number"));
                    rowdata.add(dynamicObject.getString("name"));
                    datas.add(rowdata);
                }
                continue;
            }
            ArrayList<String> rowdata = new ArrayList<String>(propertyList.size());
            rowdata.add("");
            rowdata.add(dynamicObject.getString("number"));
            rowdata.add(dynamicObject.getString("name"));
            datas.add(rowdata);
        }
        this.createDataRows(sheet, datas);
        return this;
    }
}

