/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.imports.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SXSSFWorkbookBuilder {
    protected SXSSFWorkbook wb;
    private Map<String, CellStyle> textStyles = new HashMap<String, CellStyle>();

    public SXSSFWorkbook build() {
        return this.wb;
    }

    public SXSSFWorkbookBuilder() {
    }

    public SXSSFWorkbookBuilder(SXSSFWorkbook wb) {
        this.wb = wb;
    }

    public CellStyle getTextStyle() {
        return this.getTextStyle("default");
    }

    public CellStyle getTextStyle(String align) {
        String style = "TEXT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = this.wb.createCellStyle();
            cs.setDataFormat(this.wb.createDataFormat().getFormat("@"));
            cs.setAlignment(this.getAlignment(align));
            this.setVerticalAlignment(cs, VerticalAlignment.CENTER);
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private void setVerticalAlignment(CellStyle cs, VerticalAlignment verticalAlignment) {
        cs.setVerticalAlignment(verticalAlignment);
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Exception var3) {
            return HorizontalAlignment.GENERAL;
        }
    }

    protected void setBorder(SXSSFWorkbook wb, Row row) {
        for (int c = 0; c < 15; ++c) {
            Cell cell = row.createCell(c);
            CellStyle cellStyle = wb.createCellStyle();
            this.setBorderStyle(cellStyle);
            cell.setCellStyle(cellStyle);
        }
    }

    protected CellStyle getAndSetXSSFCellStyleHeader() {
        CellStyle cellStyle = this.wb.createCellStyle();
        Font headerFont = this.wb.createFont();
        headerFont.setBold(true);
        cellStyle.setFont(headerFont);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        return cellStyle;
    }

    protected void setBorderStyle(CellStyle cellStyle) {
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    protected void createTitle(SXSSFSheet sheet, List<String> title) {
        CellStyle cellStyle = this.getAndSetXSSFCellStyleHeader();
        int rownum = 0;
        SXSSFRow row = sheet.createRow(rownum);
        for (int j = 0; j < title.size(); ++j) {
            sheet.setColumnWidth(j, 6144);
            Cell cell = row.createCell(j);
            cell.setCellValue(title.get(j));
            cell.setCellStyle(cellStyle);
        }
    }
}

