/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.init.HCDMInitServiceHelper;
import kd.swc.hcdm.business.init.HCDMInitValidateHelper;
import kd.swc.hcdm.common.vo.init.RecordAndPersonVO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class HCDMInitDomainDataService
extends AbstractInitDomainDataService {
    private static Log LOGGER = LogFactory.getLog(HCDMInitDomainDataService.class);
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final String ID_MAPPING = "idmapping";
    private static final String DATA = "data";

    public void validate() {
        Map map = this.getInfoWithDynamicObject();
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Map idMap = (Map)map.get(ID_MAPPING);
        List dataList = (List)map.get(DATA);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        Map<Long, DynamicObject> dataMap = this.transferMap(dataList, idMap);
        LOGGER.info("HCDMInitDomainDataService validate dataMap.keySet = {}", (Object)SerializationUtils.toJsonString(dataMap.keySet()));
        long startTime1 = System.currentTimeMillis();
        Map<String, Object> result = HCDMInitValidateHelper.initValidate(dataMap, this.getInitOutParam(), this.getInitInParam());
        long endTime1 = System.currentTimeMillis();
        LOGGER.info("HCDMInitDomainDataService: initValidate end -------------------- {}", (Object)(endTime1 - startTime1));
        this.setSuccessStatus(result, this.getInitOutParam());
        LOGGER.info("HCDMInitDomainDataService validate initOutParam.data = {}", (Object)SerializationUtils.toJsonString((Object)this.getInitOutParam().getData()));
    }

    public void save() {
        Map map = this.getInfoWithDynamicObject();
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Map idMap = (Map)map.get(ID_MAPPING);
        List dataList = (List)map.get(DATA);
        Map<Long, DynamicObject> dataMap = this.transferMap(dataList, idMap);
        Map<String, Object> result = HCDMInitValidateHelper.initValidate(dataMap, this.getInitOutParam(), this.getInitInParam());
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        Map groupData = (Map)result.get("groupData");
        Map depempIds = (Map)result.get("depempIds");
        HashMap midMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        groupData.forEach((number, value) -> value.forEach(midMap::put));
        List<RecordAndPersonVO> recordAndPersonVOS = HCDMInitServiceHelper.convertEntitys(midMap);
        HCDMInitServiceHelper.saveInitInfo(recordAndPersonVOS, depempIds, this.getInitOutParam(), this.getInitInParam());
    }

    private Map<Long, DynamicObject> transferMap(List<DynamicObject> dataList, Map<Long, Set<Long>> idMap) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(dataList.size());
        dataList.forEach(dynamicObject -> {
            Long id = dynamicObject.getLong("id");
            Set longs = (Set)idMap.get(id);
            longs.forEach(midLong -> resultMap.put((Long)midLong, (DynamicObject)dynamicObject));
        });
        return resultMap;
    }

    protected void rollbackSelecthandle(Map<String, List<Long>> bizIdMap) {
        bizIdMap.forEach((id, midIds) -> midIds.forEach(midId -> this.getInitOutParam().addSuccessMsg(midId, String.valueOf(id), "")));
    }

    protected void rollbackAll() {
        this.deleteDataByQFilter(this.getRollbackQFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDataByQFilter(List<QFilter> qFilter) {
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hcdm_decadjrelperson");
        DynamicObject[] recordDys = recordHelper.query("id,relpersonid", qFilter.toArray(new QFilter[0]));
        Set personIds = Stream.of(recordDys).map(it -> it.getLong("relpersonid")).collect(Collectors.toSet());
        try (TXHandle txHandle = TX.required();){
            personHelper.deleteByFilter(new QFilter("id", "in", personIds).toArray());
            recordHelper.delete(Stream.of(recordDys).map(it -> it.getLong("id")).distinct().toArray());
        }
    }

    protected void rollbackSelectedData() {
        Map bizIdMap = this.getBizIdMapByExecTaskId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        Set recordIds = bizIdMap.keySet().stream().filter(e1 -> !"".equals(e1)).map(Long::parseLong).collect(Collectors.toSet());
        qFilters.add(new QFilter("id", "in", recordIds));
        this.deleteDataByQFilter(qFilters);
        this.rollbackSelecthandle(bizIdMap);
    }

    public void changeSuccessStatus() {
        Long batchId = this.getInitInParam().getBatchNumber();
        LOGGER.info("changeSuccessStatus batchId is:{}", (Object)batchId);
        String event = null;
        try {
            event = this.adjFileApplicationService.saveTimeVersionForInit(batchId);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            LOGGER.error("HCDMInitDomainDataService Thread interrupt Error in changeSuccessStatus {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        if (null != event) {
            this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
        }
    }

    private void setSuccessStatus(Map<String, Object> result, InitOutParam initOutParam) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        Map groupData = (Map)result.get("groupData");
        if (CollectionUtils.isEmpty((Map)groupData)) {
            return;
        }
        groupData.forEach((key, value) -> value.forEach((mid, dy) -> initOutParam.addSuccessMsg(mid, String.valueOf(dy.getLong("id")), "")));
    }
}

