/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.init.InitOutParam;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.common.vo.init.RecordAndPersonVO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import org.apache.commons.collections4.MapUtils;

public class HCDMInitServiceHelper {
    private static Log LOGGER = LogFactory.getLog(HCDMInitServiceHelper.class);
    public static final String HAOS_ADMINORGHR = "haos_adminorghr";
    public static final String HBPM_POSITIONHR = "hbpm_positionhr";
    public static final String HBPM_STPOSITION = "hbpm_stposition";
    public static final String HAOS_PROJECTTEAMHR = "haos_projectteamhr";

    public static List<RecordAndPersonVO> convertEntitys(Map<Long, DynamicObject> dataMap) {
        if (CollectionUtils.isEmpty(dataMap)) {
            return Collections.emptyList();
        }
        ArrayList<RecordAndPersonVO> retList = new ArrayList<RecordAndPersonVO>(dataMap.size());
        MainEntityType recordType = EntityMetadataCache.getDataEntityType((String)"hcdm_salaryadjrecord");
        Set recordFields = recordType.getFields().keySet();
        MainEntityType personType = EntityMetadataCache.getDataEntityType((String)"hcdm_decadjrelperson");
        Set personFields = personType.getFields().keySet();
        for (Map.Entry<Long, DynamicObject> entry : dataMap.entrySet()) {
            DynamicObject aObject = entry.getValue();
            QueryEntityType entityType = (QueryEntityType)aObject.getDataEntityType();
            if (0 == entityType.getSelectFields().size()) continue;
            DynamicObject record = (DynamicObject)recordType.createInstance();
            DynamicObject person = (DynamicObject)personType.createInstance();
            for (QuerySelectField aSelectField : entityType.getSelectFields()) {
                String personField;
                String alias = aSelectField.getAlias();
                if (alias.startsWith("hcdm_decadjrelperson") && personFields.contains(personField = alias.substring("hcdm_decadjrelperson".length() + 1))) {
                    person.set(personField, aObject.get(alias));
                    continue;
                }
                if (!recordFields.contains(alias)) continue;
                record.set(alias, aObject.get(alias));
            }
            record.set("datastatus", (Object)"-3");
            record.set("status", (Object)"A");
            RecordAndPersonVO vo = new RecordAndPersonVO();
            vo.setMid(entry.getKey());
            vo.setPerson(person);
            vo.setRecord(record);
            retList.add(vo);
        }
        return retList;
    }

    public static void saveInitInfo(List<RecordAndPersonVO> recordAndPersonVOList, Map<Long, Long> depempIds, InitOutParam initOutParam, InitInParam initInParam) {
        int size = recordAndPersonVOList.size();
        ArrayList recordList = Lists.newArrayListWithExpectedSize((int)size);
        ArrayList personList = Lists.newArrayListWithExpectedSize((int)size);
        HashSet stdscmIds = Sets.newHashSetWithExpectedSize((int)size);
        HashSet salaryadjfileBoids = Sets.newHashSetWithExpectedSize((int)size);
        HashSet standardItemIds = Sets.newHashSetWithExpectedSize((int)size);
        HashSet adminorgIds = Sets.newHashSetWithExpectedSize((int)size);
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)size);
        HashSet stdpositionIds = Sets.newHashSetWithExpectedSize((int)size);
        HashSet projectteamIds = Sets.newHashSetWithExpectedSize((int)size);
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("hcdm_decadjrelperson", size);
        long[] recordIds = orm.genLongIds("hcdm_salaryadjrecord", size);
        HashMap midRecordIdMap = Maps.newHashMapWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            RecordAndPersonVO recordAndPersonVO = recordAndPersonVOList.get(i);
            Long mid2 = recordAndPersonVO.getMid();
            DynamicObject person = recordAndPersonVO.getPerson();
            person.set("depemp", (Object)depempIds.get(mid2));
            person.set("id", (Object)ids[i]);
            stdscmIds.add(person.getLong("stdscm.id"));
            DynamicObject record = recordAndPersonVO.getRecord();
            HCDMInitServiceHelper.setInitDefalutValue(record, initInParam);
            salaryadjfileBoids.add(record.getLong("salaryadjfile.id"));
            record.set("relpersonid", (Object)ids[i]);
            record.set("id", (Object)recordIds[i]);
            recordList.add(record);
            personList.add(person);
            midRecordIdMap.put(mid2, recordIds[i]);
            standardItemIds.add(record.getLong("standarditem.id"));
            adminorgIds.add(person.getLong("company.id"));
            adminorgIds.add(person.getLong("adminorg.id"));
            adminorgIds.add(person.getLong("assoadminorg.id"));
            positionIds.add(person.getLong("position.id"));
            stdpositionIds.add(person.getLong("stdposition.id"));
            projectteamIds.add(person.getLong("projectteam.id"));
        }
        HCDMInitServiceHelper.setVid("hcdm_stdscm", personList, stdscmIds, "stdscm.id", "stdscm");
        HCDMInitServiceHelper.setFixedItem(recordList, standardItemIds);
        HCDMInitServiceHelper.setBO(HAOS_ADMINORGHR, "company", "companybo", adminorgIds, personList);
        HCDMInitServiceHelper.setBO(HAOS_ADMINORGHR, "adminorg", "adminorgbo", adminorgIds, personList);
        HCDMInitServiceHelper.setBO(HAOS_ADMINORGHR, "assoadminorg", "assoadminorgbo", adminorgIds, personList);
        HCDMInitServiceHelper.setBO(HBPM_POSITIONHR, "position", "positionbo", positionIds, personList);
        HCDMInitServiceHelper.setBO(HBPM_STPOSITION, "stdposition", "stdpositionbo", stdpositionIds, personList);
        HCDMInitServiceHelper.setBO(HAOS_PROJECTTEAMHR, "projectteam", "projectteambo", projectteamIds, personList);
        try (TXHandle txHandle = TX.required();){
            try {
                SWCDataServiceHelper salHelper = new SWCDataServiceHelper("hcdm_decadjrelperson");
                salHelper.save(personList.toArray(new DynamicObject[0]));
                salHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
                salHelper.save(recordList.toArray(new DynamicObject[0]));
            }
            catch (Throwable ex) {
                txHandle.markRollback();
                LOGGER.error("doIntegrate transaction error", ex);
                throw ex;
            }
        }
        midRecordIdMap.forEach((mid, recordId) -> initOutParam.addSuccessMsg(mid, String.valueOf(recordId), ""));
    }

    private static void setBO(String entityNumber, String versionField, String boField, Set<Long> vids, List<DynamicObject> dynamicObjects) {
        Map boIdMap = BaseDataHisHelper.getCurrentOfVersion((String)entityNumber, vids);
        if (MapUtils.isEmpty((Map)boIdMap)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long versionFieldId = dynamicObject.getLong(versionField + ".id");
            if (versionFieldId <= 0L || (Long)boIdMap.get(versionFieldId) <= 0L) continue;
            HCDMInitServiceHelper.setBoDynamicObject(dynamicObject, entityNumber, (Long)boIdMap.get(versionFieldId), boField);
        }
    }

    private static void setBoDynamicObject(DynamicObject dynamicObject, String entityId, Long boId, String fieldKey) {
        HRBaseServiceHelper standarditemServiceHelper = new HRBaseServiceHelper(entityId);
        DynamicObject dy = standarditemServiceHelper.generateEmptyDynamicObject();
        dy.set("id", (Object)boId);
        dynamicObject.set(fieldKey, (Object)dy);
    }

    private static void setFixedItem(List<DynamicObject> recordList, Set<Long> standardItemIds) {
        Map<Long, DynamicObject> standardItemMap = SalaryAdjFileServiceHelper.getStandardItemMap("id,fixeditem", standardItemIds);
        if (MapUtils.isEmpty(standardItemMap)) {
            return;
        }
        for (DynamicObject recordDy : recordList) {
            Long standarditemId = recordDy.getLong("standarditem.id");
            DynamicObject standarditemDy = standardItemMap.get(standarditemId);
            if (null == standarditemDy) continue;
            recordDy.set("fixeditem", (Object)standarditemDy.getString("fixeditem"));
        }
    }

    private static void setVid(String entityName, List<DynamicObject> personList, Set<Long> boids, String queryFieldName, String filed) {
        Map map = BaseDataHisHelper.getVersionOfCurrent((String)entityName, boids);
        for (DynamicObject dynamicObject : personList) {
            Long id = (Long)map.get(dynamicObject.getLong(queryFieldName));
            if (filed.equals("stdscm")) {
                HRBaseServiceHelper standarditemServiceHelper = new HRBaseServiceHelper("hcdm_stdscm");
                DynamicObject dy = standarditemServiceHelper.generateEmptyDynamicObject();
                dy.set("id", (Object)id);
                dynamicObject.set(filed, (Object)dy);
                continue;
            }
            dynamicObject.set(filed, (Object)id);
        }
    }

    private static void setInitDefalutValue(DynamicObject dy, InitInParam initInParam) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        dy.set("creator", (Object)currUserId);
        dy.set("modifier", (Object)currUserId);
        dy.set("createtime", (Object)now);
        dy.set("modifytime", (Object)now);
        dy.set("initdatasource", (Object)"1");
        dy.set("initbatch", (Object)initInParam.getBatchNumber());
        dy.set("initstatus", (Object)"0");
        dy.set("datasource", (Object)"1");
        dy.set("enable", (Object)"1");
        dy.set("status", (Object)"A");
        if (null == dy.getDate("bsled")) {
            dy.set("bsled", (Object)SWCBaseUtils.getMaxLoseEffectDate());
        }
    }
}

