/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.init.InitInParam;
import kd.hr.hbp.common.init.InitOutParam;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.DecideAdjSalaryServiceHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandardscm.SalaryStandardScmHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class HCDMInitValidateHelper {
    private static final Log LOGGER = LogFactory.getLog(HCDMInitValidateHelper.class);
    private static final List<String> MUST_INPUT_FIELD = Lists.newArrayList((Object[])new String[]{"hcdm_decadjrelperson.empnumber", "needpush", "hcdm_decadjrelperson.org", "hcdm_decadjrelperson.country", "hcdm_decadjrelperson.empgroup", "hcdm_decadjrelperson.salaystructure", "hcdm_decadjrelperson.stdscm", "hcdm_decadjrelperson.assoadminorg", "standarditem", "frequency", "currency", "amount", "bsed", "salaryadjrsn"});
    private static final List<String> DIMENSION_FIELD = Lists.newArrayList((Object[])new String[]{"hcdm_decadjrelperson.empnumber", "hcdm_decadjrelperson.org.name", "hcdm_decadjrelperson.country.name", "hcdm_decadjrelperson.stdscm.name"});

    public static Map<String, Object> initValidate(Map<Long, DynamicObject> dataMap, InitOutParam initOutParam, InitInParam initInParam) {
        Map<String, Map<Long, DynamicObject>> groupData = HCDMInitValidateHelper.getGroupData(dataMap);
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 1 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        HashMap result = Maps.newHashMapWithExpectedSize((int)dataMap.size());
        HCDMInitValidateHelper.validateMustInput(groupData, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 2 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        Map<Long, Long> depempIds = HCDMInitValidateHelper.validateDepEmpValdate(groupData, initOutParam);
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 3 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.validateDataLegal(groupData, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 4 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.checkJobLevelJobGrade(groupData, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 5 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.validateSalaryStdVersion(groupData, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 6 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.validatePerm(groupData, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 7 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.validateOnTheWayDate(groupData, depempIds, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 8 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.validateRepeat(groupData, initOutParam, initInParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 9 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        groupData = HCDMInitValidateHelper.checkMatchAdjFileVersion(groupData, initOutParam);
        if (CollectionUtils.isEmpty(groupData)) {
            return result;
        }
        LOGGER.info("HCDMInitValidateHelper initValidate groupData 10 = {}", (Object)SerializationUtils.toJsonString(HCDMInitValidateHelper.getMidIdsFromGroupData(groupData)));
        result.put("groupData", groupData);
        result.put("depempIds", depempIds);
        return result;
    }

    private static Set<Long> getMidIdsFromGroupData(Map<String, Map<Long, DynamicObject>> groupData) {
        HashSet groupMidIds = Sets.newHashSetWithExpectedSize((int)100);
        groupData.values().stream().map(Map::keySet).forEach(groupMidIds::addAll);
        return groupMidIds;
    }

    private static Map<String, Map<Long, DynamicObject>> checkJobLevelJobGrade(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        HashMap emptyNameMap = Maps.newHashMapWithExpectedSize((int)groupData.size());
        groupData.forEach((key, value) -> value.forEach((mid, dy) -> {
            List list = emptyNameMap.computeIfAbsent(dy.getString("hcdm_decadjrelperson.empnumber"), k1 -> Lists.newArrayListWithExpectedSize((int)value.size()));
            list.add(dy);
        }));
        if (CollectionUtils.isEmpty((Map)emptyNameMap)) {
            return groupData;
        }
        DynamicObject[] dynamicObjects = SalaryAdjFileServiceHelper.queryEmployeeByempNum(emptyNameMap.keySet());
        if (!CollectionUtils.isEmpty((Map)emptyNameMap)) {
            HCDMInitValidateHelper.setEmptyName(emptyNameMap, dynamicObjects);
        }
        return groupData;
    }

    public static void validateMustInput(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        Map<String, QuerySelectField> fieldMap = HCDMInitValidateHelper.getFieldAlias();
        String msg = ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HCDMInitValidateServiceHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        groupData.forEach((key, dataMap) -> {
            Set<Long> errIds = HCDMInitValidateHelper.checkFieldMustInput(dataMap, initOutParam, msg, fieldMap);
            if (!CollectionUtils.isEmpty(errIds)) {
                HCDMInitValidateHelper.removeErrorData(dataMap, errIds);
            }
        });
    }

    public static Map<String, Map<Long, DynamicObject>> validateDataLegal(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        HashSet adjFileNumber = Sets.newHashSetWithExpectedSize((int)groupData.size());
        HashMap result = Maps.newHashMapWithExpectedSize((int)groupData.size());
        HashSet noFileNumberDataSet = Sets.newHashSetWithExpectedSize((int)groupData.size());
        HashMap dataWithLegal = Maps.newHashMapWithExpectedSize((int)groupData.size());
        HashSet structureIds = Sets.newHashSetWithExpectedSize((int)groupData.size());
        groupData.forEach((number, dataMap) -> dataMap.forEach((key, data) -> {
            if (null != data.get("salaryadjfile.number")) {
                adjFileNumber.add(data.get("salaryadjfile.number"));
            } else {
                structureIds.add(data.getLong("hcdm_decadjrelperson.salaystructure.id"));
                noFileNumberDataSet.add(number);
            }
        }));
        HCDMInitValidateHelper.checkADJFileInfo(groupData, initOutParam, adjFileNumber, result, dataWithLegal);
        HCDMInitValidateHelper.checkStdAndStructureWithNoADJFileNumber(groupData, result, structureIds, noFileNumberDataSet, initOutParam);
        return result;
    }

    public static Map<String, Map<Long, DynamicObject>> validateSalaryStdVersion(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        int groupSize = groupData.size();
        HashSet stdScmIds = Sets.newHashSetWithExpectedSize((int)groupSize);
        HashSet structurerIds = Sets.newHashSetWithExpectedSize((int)groupSize);
        HashSet salaryItemIds = Sets.newHashSetWithExpectedSize((int)groupSize);
        HashMap midMap = Maps.newHashMapWithExpectedSize((int)groupSize);
        HashMap midAndDataMap = Maps.newHashMapWithExpectedSize((int)groupSize);
        groupData.forEach((number, dataMap) -> dataMap.forEach((key, data) -> {
            long structureId = data.getLong("hcdm_decadjrelperson.salaystructure.id");
            long stdScmId = data.getLong("hcdm_decadjrelperson.stdscm.id");
            long stdItemId = data.getLong("standarditem.id");
            structurerIds.add(structureId);
            stdScmIds.add(stdScmId);
            salaryItemIds.add(stdItemId);
            String str = String.valueOf(stdScmId).concat("_").concat(String.valueOf(structureId)).concat("_").concat(String.valueOf(stdItemId));
            Set set = midMap.computeIfAbsent(str, k1 -> Sets.newHashSetWithExpectedSize((int)dataMap.size()));
            set.add(key);
            midAndDataMap.put(key, data);
        }));
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        param.put("stdScmBoId", stdScmIds);
        param.put("structureId", structurerIds);
        param.put("standardItemId", salaryItemIds);
        List<Map<String, Object>> standars = SalaryStandardScmHelper.querySalaryStandardByScm(param);
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u7b49\u3001\u85aa\u6863\u672a\u627e\u5230\u5339\u914d\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashSet errorMids = Sets.newHashSetWithExpectedSize((int)midAndDataMap.size());
        if (CollectionUtils.isEmpty(standars)) {
            midAndDataMap.forEach((mid, dy) -> {
                if (null != dy.get("grade") || null != dy.get("rank")) {
                    initOutParam.addErrorMsg(mid, errorMsg);
                    errorMids.add(mid);
                }
            });
            return HCDMInitValidateHelper.mergeGroupErrMsg(groupData, errorMids, initOutParam);
        }
        HashSet standarIds = Sets.newHashSetWithExpectedSize((int)midMap.size());
        HashMap standarIdAndKeyInfoMap = Maps.newHashMapWithExpectedSize((int)midMap.size());
        for (Map<String, Object> standarMap : standars) {
            for (Map.Entry<String, Object> entry : standarMap.entrySet()) {
                Map value = (Map)entry.getValue();
                String key = entry.getKey();
                LOGGER.info("standars key {}", (Object)key);
                if (!midMap.containsKey(key)) continue;
                HCDMInitValidateHelper.checkIsMatchGradeRank(midMap, midAndDataMap, standarIds, standarIdAndKeyInfoMap, value, key, initOutParam, errorMids);
            }
        }
        if (CollectionUtils.isEmpty((Collection)standarIds)) {
            return HCDMInitValidateHelper.mergeGroupErrMsg(groupData, errorMids, initOutParam);
        }
        DynamicObject[] dynamicObjects = new SWCDataServiceHelper("hcdm_salarystandard").query("bsled,bsed,id,boid", new QFilter[]{new QFilter("boid", "in", (Object)standarIds), new QFilter("status", "=", (Object)"C"), new QFilter("id", "not in", (Object)standarIds), new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"})});
        Map<Long, List<DynamicObject>> listMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(object -> object.getLong("boid")));
        for (Map.Entry<Object, Object> entry : listMap.entrySet()) {
            HCDMInitValidateHelper.checkStandardInfo(midAndDataMap, (Set)standarIdAndKeyInfoMap.get(entry.getKey()), (List)entry.getValue(), midMap, errorMids, initOutParam);
        }
        return HCDMInitValidateHelper.mergeGroupErrMsg(groupData, errorMids, initOutParam);
    }

    private static void checkIsMatchGradeRank(Map<String, Set<Long>> midMap, Map<Long, DynamicObject> midAndDataMap, Set<Long> standarIds, Map<Long, Set<String>> standarIdAndKeyInfoMap, Map<String, Object> value, String key, InitOutParam initOutParam, Set<Long> errorMids) {
        String standarErrMsg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee{1}\u6ca1\u6709\u53ef\u7528\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_23", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String gradeRankErrorMsg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee{1}\u6ca1\u6709\u53ef\u7528\u85aa\u7b49\u3001\u85aa\u6863\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_22", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String isMatchGradeRankErrorMsg = ResManager.loadKDString((String)"\u5de5\u53f7{0}\uff1a\u5f53\u524d\u5b9a\u8c03\u85aa\u9879\u76ee{1}\u6ca1\u6709\u53ef\u7528\u85aa\u916c\u6807\u51c6\u8868\u3001\u85aa\u7b49\u3001\u85aa\u6863\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_24", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Set<Long> mids = midMap.get(key);
        for (Long mid : mids) {
            String isMatchGradeRank;
            DynamicObject midDy = midAndDataMap.get(mid);
            if (null == value || 0L == (Long)value.get("id")) {
                String tempMsg;
                if (null != midDy.get("grade") || null != midDy.get("rank")) {
                    if (0L != midDy.getLong("salarystd.id")) {
                        tempMsg = MessageFormat.format(isMatchGradeRankErrorMsg, midDy.getString("hcdm_decadjrelperson.empnumber"), midDy.getString("standarditem.name"));
                        initOutParam.addErrorMsg(mid, tempMsg);
                        errorMids.add(mid);
                        continue;
                    }
                    tempMsg = MessageFormat.format(gradeRankErrorMsg, midDy.getString("hcdm_decadjrelperson.empnumber"), midDy.getString("standarditem.name"));
                    initOutParam.addErrorMsg(mid, tempMsg);
                    errorMids.add(mid);
                    continue;
                }
                if (0L == midDy.getLong("salarystd.id")) continue;
                tempMsg = MessageFormat.format(standarErrMsg, midDy.getString("hcdm_decadjrelperson.empnumber"), midDy.getString("standarditem.name"));
                initOutParam.addErrorMsg(mid, tempMsg);
                errorMids.add(mid);
                continue;
            }
            Object grade = midDy.get("grade");
            Object rank = midDy.get("rank");
            if ((null != grade || rank != null) && (SWCStringUtils.isEmpty((String)(isMatchGradeRank = (String)value.get("ismatchgraderank"))) || SWCStringUtils.equals((String)"0", (String)isMatchGradeRank))) {
                String tempMsg = MessageFormat.format(gradeRankErrorMsg, midDy.getString("hcdm_decadjrelperson.empnumber"), midDy.getString("standarditem.name"));
                initOutParam.addErrorMsg(mid, tempMsg);
                errorMids.add(mid);
                continue;
            }
            standarIds.add((Long)value.get("id"));
            Set keyInfoId = standarIdAndKeyInfoMap.computeIfAbsent((Long)value.get("id"), k1 -> Sets.newHashSetWithExpectedSize((int)4));
            keyInfoId.add(key);
        }
    }

    private static boolean checkFileStatus(DynamicObject dynamicObject, Set<Long> mIds, InitOutParam initOutParam) {
        String statusErrorMsg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5411\u201c\u5df2\u5ba1\u6838\u201d\u6216\u201c\u5df2\u5931\u6548\u201d\u7684\u6863\u6848\u521d\u59cb\u5316\u6570\u636e\uff0c\u5f53\u524d\u6863\u6848\u7f16\u53f7\uff1a{0}\u72b6\u6001\u4e0d\u7b26\u5408\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String status = dynamicObject.getString("status");
        if (!"C".equals(status) && !"D".equals(status)) {
            String errorMsg = MessageFormat.format(statusErrorMsg, dynamicObject.getString("number"));
            for (Long mId : mIds) {
                initOutParam.addErrorMsg(mId, errorMsg);
            }
            return false;
        }
        return true;
    }

    private static Set<Long> checkDataLegal(Map<String, QuerySelectField> fieldMap, DynamicObject fileDy, Map<Long, DynamicObject> dataMap, InitOutParam initOutParam, String consistentInfoMsg) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dataMap)) {
            return result;
        }
        dataMap.forEach((mId, dynamicObject) -> {
            String displayName;
            ArrayList errorFiledList = Lists.newArrayListWithExpectedSize((int)4);
            if (dynamicObject.getLong("hcdm_decadjrelperson.country.id") != fileDy.getLong("country.id")) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"country"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.country.name"));
            }
            if (dynamicObject.getLong("hcdm_decadjrelperson.org.id") != fileDy.getLong("org.id")) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"org"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.org.name"));
            }
            if (dynamicObject.getLong("hcdm_decadjrelperson.stdscm.id") != fileDy.getLong("stdscm.id")) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"stdscm"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.stdscm.name"));
            }
            if (dynamicObject.getLong("hcdm_decadjrelperson.salaystructure.id") != fileDy.getLong("salaystructure.id")) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"salaystructure"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.salaystructure.name"));
            }
            if (dynamicObject.getLong("hcdm_decadjrelperson.assoadminorg.id") != fileDy.getLong("assoadminorg.id")) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"assoadminorg"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.assoadminorg.number"));
            }
            if (dynamicObject.getLong("hcdm_decadjrelperson.empgroup.id") != fileDy.getLong("empgroup.id")) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"empgroup"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.empgroup.number"));
            }
            if (!dynamicObject.getString("hcdm_decadjrelperson.empnumber").equals(fileDy.getString("employee.empnumber"))) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"empnumber"}), fieldMap);
                errorFiledList.add(displayName + ":" + dynamicObject.getString("hcdm_decadjrelperson.empnumber"));
            }
            if (!CollectionUtils.isEmpty((Collection)errorFiledList)) {
                String errorMsg = MessageFormat.format(consistentInfoMsg, String.join((CharSequence)"\u3001", errorFiledList));
                initOutParam.addErrorMsg(mId, errorMsg);
                result.add(mId);
            }
        });
        return result;
    }

    public static Map<String, Map<Long, DynamicObject>> validatePerm(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        Map<String, Set<Long>> permDatas = HCDMInitValidateHelper.getDataWithPerm();
        Map<String, QuerySelectField> fieldMap = HCDMInitValidateHelper.getFieldAlias();
        String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709{0}\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashMap result = Maps.newHashMapWithExpectedSize((int)groupData.size());
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : groupData.entrySet()) {
            String dimensionNumber = entry.getKey();
            Map<Long, DynamicObject> dataMap = entry.getValue();
            Set<Long> errIds = HCDMInitValidateHelper.checkPerm(permDatas, dataMap, initOutParam, errMsg, fieldMap);
            if (CollectionUtils.isEmpty(errIds)) {
                result.put(dimensionNumber, dataMap);
                continue;
            }
            HCDMInitValidateHelper.removeErrorData(dataMap, errIds);
            if (CollectionUtils.isEmpty(dataMap)) continue;
            result.put(dimensionNumber, dataMap);
        }
        return result;
    }

    public static Map<String, Map<Long, DynamicObject>> validateRepeat(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam, InitInParam initInParam) {
        HCDMInitValidateHelper.checkCurTaskInfo(groupData, initOutParam);
        HashMap salaryadjFileNumberMap = Maps.newHashMapWithExpectedSize((int)groupData.size());
        HashMap dimensionNumberMap = Maps.newHashMapWithExpectedSize((int)groupData.size());
        for (Map.Entry<String, Map<Long, DynamicObject>> entry1 : groupData.entrySet()) {
            Map.Entry<Long, DynamicObject> entry;
            DynamicObject data;
            int result;
            String number = entry1.getKey();
            Map<Long, DynamicObject> dataMap = entry1.getValue();
            Iterator<Map.Entry<Long, DynamicObject>> iterator = dataMap.entrySet().iterator();
            while (iterator.hasNext() && (result = HCDMInitValidateHelper.setDimensionNumber(salaryadjFileNumberMap, dimensionNumberMap, number, dataMap, data = (entry = iterator.next()).getValue())) <= 0) {
            }
        }
        HCDMInitValidateHelper.checkRecordInfo(groupData, salaryadjFileNumberMap, dimensionNumberMap, initOutParam);
        return groupData;
    }

    private static int setDimensionNumber(HashMap<String, Map<Long, DynamicObject>> salaryadjFileNumberMap, HashMap<String, Map<Long, DynamicObject>> dimensionNumberMap, String number, Map<Long, DynamicObject> dataMap, DynamicObject data) {
        int result;
        if (null != data.get("salaryadjfile.number")) {
            salaryadjFileNumberMap.put(number, dataMap);
            result = salaryadjFileNumberMap.size();
        } else {
            dimensionNumberMap.put(number, dataMap);
            result = dimensionNumberMap.size();
        }
        return result;
    }

    private static void checkRecordInfo(Map<String, Map<Long, DynamicObject>> groupData, HashMap<String, Map<Long, DynamicObject>> salaryadjFileNumberMap, HashMap<String, Map<Long, DynamicObject>> dimensionNumberMap, InitOutParam initOutParam) {
        if (!CollectionUtils.isEmpty(salaryadjFileNumberMap)) {
            HCDMInitValidateHelper.checkInitInfoInRecordByAdjFileNumber(groupData, salaryadjFileNumberMap, initOutParam);
        }
        if (!CollectionUtils.isEmpty(dimensionNumberMap)) {
            HCDMInitValidateHelper.checkInitInfoInRecordByDimensionNumber(groupData, dimensionNumberMap, initOutParam);
        }
    }

    private static Map<Long, Long> validateDepEmpValdate(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        int size = groupData.size();
        HashSet empnumberSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet positionEmptySet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet adminorgSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet positionSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet stdpositionSet = Sets.newHashSetWithExpectedSize((int)size);
        HashSet jobSet = Sets.newHashSetWithExpectedSize((int)size);
        HashMap midMap = Maps.newHashMapWithExpectedSize((int)(2 * size));
        HashMap midAndPositionIdMap = Maps.newHashMapWithExpectedSize((int)(2 * size));
        HashMap positionInfoNotEmptyMap = Maps.newHashMapWithExpectedSize((int)(2 * size));
        HashMap positionInfoEmptyMap = Maps.newHashMapWithExpectedSize((int)(2 * size));
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)size);
        HashMap result = Maps.newHashMapWithExpectedSize((int)(2 * size));
        groupData.forEach((number, smallRowMap) -> {
            for (Map.Entry entry : smallRowMap.entrySet()) {
                DynamicObject data = (DynamicObject)entry.getValue();
                midMap.put(entry.getKey(), number);
                Set set = midAndPositionIdMap.computeIfAbsent(entry.getKey(), k1 -> Sets.newHashSetWithExpectedSize((int)10));
                boolean isPositionInfoEmpty = null == data.get("hcdm_decadjrelperson.position") && null == data.get("hcdm_decadjrelperson.stdposition") && null == data.get("hcdm_decadjrelperson.job");
                set.add(data.get("hcdm_decadjrelperson.empnumber"));
                if (null == data.get("hcdm_decadjrelperson.adminorg") || isPositionInfoEmpty) {
                    positionEmptySet.add(data.get("hcdm_decadjrelperson.empnumber"));
                    positionInfoEmptyMap.put(entry.getKey(), data);
                    continue;
                }
                positionInfoNotEmptyMap.put(entry.getKey(), data);
                empnumberSet.add(data.get("hcdm_decadjrelperson.empnumber"));
                if (data.get("hcdm_decadjrelperson.adminorg.id") != null) {
                    adminorgSet.add(data.get("hcdm_decadjrelperson.adminorg.id"));
                    set.add(data.get("hcdm_decadjrelperson.adminorg.id"));
                }
                if (null != data.get("hcdm_decadjrelperson.position")) {
                    positionSet.add(data.get("hcdm_decadjrelperson.position.id"));
                    set.add(data.get("hcdm_decadjrelperson.position.id"));
                }
                if (null != data.get("hcdm_decadjrelperson.stdposition")) {
                    stdpositionSet.add(data.get("hcdm_decadjrelperson.stdposition.id"));
                    set.add(data.get("hcdm_decadjrelperson.stdposition.id"));
                }
                if (null == data.get("hcdm_decadjrelperson.job")) continue;
                jobSet.add(data.get("hcdm_decadjrelperson.job.id"));
                set.add(data.get("hcdm_decadjrelperson.job.id"));
            }
        });
        DynamicObject[] depempInfosWhithEmpInfos = new DynamicObject[]{};
        if (!CollectionUtils.isEmpty((Collection)empnumberSet)) {
            depempInfosWhithEmpInfos = SalaryAdjFileServiceHelper.queryDepempInfoByEmpInfo(empnumberSet, adminorgSet, positionSet, stdpositionSet, jobSet);
        }
        Map<String, List<DynamicObject>> depEmpInfoByEmpNumber = HCDMInitValidateHelper.getDepempInfoByEmpNumber(positionEmptySet);
        HCDMInitValidateHelper.checkPositionInfoWithEmpty(positionInfoEmptyMap, depEmpInfoByEmpNumber, errorMap, midMap, initOutParam, result);
        HCDMInitValidateHelper.checkPositionInfoNotEmpty(positionInfoNotEmptyMap, midAndPositionIdMap, errorMap, midMap, depempInfosWhithEmpInfos, initOutParam, result);
        if (CollectionUtils.isEmpty((Map)errorMap)) {
            return result;
        }
        errorMap.forEach((number, ids) -> HCDMInitValidateHelper.removeErrorData((Map)groupData.get(number), ids));
        return result;
    }

    private static Map<String, QuerySelectField> getFieldAlias() {
        QueryEntityType dataEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hcdm_salaryadjrecordquery");
        List selectFields = dataEntityType.getSelectFields();
        HashMap map = Maps.newHashMapWithExpectedSize((int)selectFields.size());
        for (QuerySelectField selectField : selectFields) {
            String fieldAlias = selectField.getAlias();
            if (StringUtils.startsWithIgnoreCase((String)fieldAlias, (String)"hcdm_decadjrelperson")) {
                fieldAlias = StringUtils.delete((String)fieldAlias, (String)"hcdm_decadjrelperson.");
            }
            map.put(fieldAlias, selectField);
        }
        return map;
    }

    private static Map<String, Set<Long>> getDataWithPerm() {
        Object[] structurers;
        Object[] salaryAdjustrsns;
        Object[] salaryItems;
        HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        Object[] adjFiles = SalaryAdjFileServiceHelper.getAdjFileByDataRule(permOrgResult);
        if (!ArrayUtils.isEmpty((Object[])adjFiles)) {
            Set adjFilIds = Arrays.stream(adjFiles).map(object -> object.getLong("id")).collect(Collectors.toSet());
            map.put("salaryadjfile", adjFilIds);
        }
        if (!ArrayUtils.isEmpty((Object[])(salaryItems = SalaryAdjFileServiceHelper.getSalaryItemByOrg(permOrgResult)))) {
            Set salaryItemIds = Arrays.stream(salaryItems).map(object -> object.getLong("id")).collect(Collectors.toSet());
            map.put("standarditem", salaryItemIds);
        }
        if (!ArrayUtils.isEmpty((Object[])(salaryAdjustrsns = SalaryAdjFileServiceHelper.getSalaryAdjustrsnByOrg(permOrgResult)))) {
            Set salaryAdjustrsnsIds = Arrays.stream(salaryAdjustrsns).map(object -> object.getLong("id")).collect(Collectors.toSet());
            map.put("salaryadjrsn", salaryAdjustrsnsIds);
        }
        if (!ArrayUtils.isEmpty((Object[])(structurers = SalaryAdjFileServiceHelper.getSalayStructureByPermItem(permOrgResult)))) {
            Set structurerIds = Arrays.stream(structurers).map(object -> object.getLong("id")).collect(Collectors.toSet());
            map.put("salaystructure", structurerIds);
        }
        return map;
    }

    private static HashMap<String, Map<Long, DynamicObject>> getGroupData(Map<Long, DynamicObject> dataMap) {
        HashMap groupMaps = Maps.newHashMapWithExpectedSize((int)dataMap.size());
        for (Map.Entry<Long, DynamicObject> entry : dataMap.entrySet()) {
            Long key = entry.getKey();
            DynamicObject value = entry.getValue();
            String salaryADJFileNumber = value.getString("salaryadjfile.number");
            if (!StringUtils.isEmpty((Object)salaryADJFileNumber)) {
                Map groupMap = groupMaps.computeIfAbsent(salaryADJFileNumber, k1 -> Maps.newHashMapWithExpectedSize((int)4));
                groupMap.put(key, value);
                continue;
            }
            StringBuilder bu = new StringBuilder();
            for (String field : DIMENSION_FIELD) {
                String str = value.getString(field);
                if (StringUtils.isEmpty((Object)str)) continue;
                bu.append(str);
            }
            if (bu.length() <= 0) continue;
            Map groupMap = groupMaps.computeIfAbsent(bu.toString(), k1 -> Maps.newHashMapWithExpectedSize((int)4));
            groupMap.put(key, value);
        }
        return groupMaps;
    }

    private static Set<Long> checkPerm(Map<String, Set<Long>> permDatas, Map<Long, DynamicObject> dataMap, InitOutParam initOutParam, String errMsg, Map<String, QuerySelectField> fieldMap) {
        HashSet errorMIds = Sets.newHashSetWithExpectedSize((int)dataMap.size());
        for (Map.Entry<Long, DynamicObject> entry : dataMap.entrySet()) {
            String msg;
            String displayName;
            DynamicObject value = entry.getValue();
            HashSet errFields = Sets.newHashSetWithExpectedSize((int)4);
            if (null != value.get("salaryadjfile") && (null == permDatas.get("salaryadjfile") || value.getLong("salaryadjfile.id") != 0L && !permDatas.get("salaryadjfile").contains(value.getLong("salaryadjfile.id")))) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"salaryadjfile"}), fieldMap);
                msg = displayName + ":" + value.getString("salaryadjfile.number");
                errFields.add(msg);
            }
            if (null == permDatas.get("salaryadjrsn") || !permDatas.get("salaryadjrsn").contains(value.getLong("salaryadjrsn.id"))) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"salaryadjrsn"}), fieldMap);
                msg = displayName + ":" + value.getString("salaryadjrsn.name");
                errFields.add(msg);
            }
            if (null == permDatas.get("standarditem") || !permDatas.get("standarditem").contains(value.getLong("standarditem.id"))) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"standarditem"}), fieldMap);
                msg = displayName + ":" + value.getString("standarditem.name");
                errFields.add(msg);
            }
            if (null == permDatas.get("salaystructure") || !permDatas.get("salaystructure").contains(value.getLong("hcdm_decadjrelperson.salaystructure.id"))) {
                displayName = HCDMInitValidateHelper.getDisplayName(Sets.newHashSet((Object[])new String[]{"salaystructure"}), fieldMap);
                msg = displayName + ":" + value.getString("hcdm_decadjrelperson.salaystructure.name");
                errFields.add(msg);
            }
            if (CollectionUtils.isEmpty((Collection)errFields)) continue;
            String format = MessageFormat.format(errMsg, String.join((CharSequence)"\uff0c", errFields));
            initOutParam.addErrorMsg(entry.getKey(), format);
            errorMIds.add(entry.getKey());
        }
        return errorMIds;
    }

    private static Set<Long> checkFieldMustInput(Map<Long, DynamicObject> dataMap, InitOutParam initOutParam, String msg, Map<String, QuerySelectField> fieldMap) {
        HashSet errorIds = Sets.newHashSetWithExpectedSize((int)4);
        dataMap.forEach((mId, data) -> {
            HashSet emptyFiledSet = Sets.newHashSetWithExpectedSize((int)16);
            for (String filed : MUST_INPUT_FIELD) {
                if (null != data.get(filed)) continue;
                emptyFiledSet.add(filed);
            }
            if (!CollectionUtils.isEmpty((Collection)emptyFiledSet)) {
                errorIds.add(mId);
                String displayName = HCDMInitValidateHelper.getDisplayName(emptyFiledSet, fieldMap);
                initOutParam.addErrorMsg(mId, MessageFormat.format(msg, displayName));
            }
        });
        return errorIds;
    }

    private static Map<String, Map<Long, DynamicObject>> validateOnTheWayDate(Map<String, Map<Long, DynamicObject>> groupData, Map<Long, Long> depempIdsMap, InitOutParam initOutParam) {
        HashSet depempIds = Sets.newHashSetWithExpectedSize((int)depempIdsMap.size());
        depempIdsMap.forEach((mid, depempId) -> depempIds.add(depempId));
        HashSet mids = Sets.newHashSetWithExpectedSize((int)depempIds.size());
        groupData.forEach((key, value) -> value.forEach((mid, dy) -> mids.add(mid)));
        Map<Long, Set<String>> invalidCandSetSalApplidMap = CommonHcdmBizHelper.getCandSetSalApplidInTransitMap(depempIds);
        Map<Long, Set<String>> invalidAdjApprBillMap = CommonHcdmBizHelper.getInvalidAdjBillByDepEmpId(depempIds);
        HashSet errorMidIds = Sets.newHashSetWithExpectedSize((int)depempIds.size());
        String invalidAdjApprBillErr = ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u5b58\u5728\u5728\u9014\u7684\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355\uff0c\u6682\u4e0d\u53ef\u8fdb\u884c\u5b9a\u8c03\u85aa\u6570\u636e\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_11", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String invalidCandSetSalApplidErr = ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u5b58\u5728\u5019\u9009\u4eba\u5b9a\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u5b9a\u8c03\u85aa\u6570\u636e\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_12", (String)"swc-hcdm-business", (Object[])new Object[0]);
        for (Map.Entry<Long, Long> entry : depempIdsMap.entrySet()) {
            Long depempId2 = entry.getValue();
            Long mid2 = entry.getKey();
            if (!mids.contains(mid2)) continue;
            if (MapUtils.isNotEmpty(invalidCandSetSalApplidMap) && invalidCandSetSalApplidMap.containsKey(depempId2)) {
                initOutParam.addErrorMsg(mid2, invalidCandSetSalApplidErr);
                errorMidIds.add(mid2);
                continue;
            }
            if (!MapUtils.isNotEmpty(invalidAdjApprBillMap) || !invalidAdjApprBillMap.containsKey(depempId2)) continue;
            initOutParam.addErrorMsg(mid2, invalidAdjApprBillErr);
            errorMidIds.add(mid2);
        }
        return HCDMInitValidateHelper.mergeGroupErrMsg(groupData, errorMidIds, initOutParam);
    }

    private static Map<String, List<DynamicObject>> getDepempInfoByEmpNumber(Set<Object> positionEmptySet) {
        if (CollectionUtils.isEmpty(positionEmptySet)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        DynamicObject[] depempInfoWhithyEmpNumber = SalaryAdjFileServiceHelper.queryDepempInfoByEmpNumber(positionEmptySet);
        return Arrays.stream(depempInfoWhithyEmpNumber).collect(Collectors.groupingBy(object -> object.getString("employee.empnumber")));
    }

    private static void checkPositionInfoNotEmpty(Map<Long, DynamicObject> positionInfoNotEmptyMap, Map<Long, Set<Object>> midAndPositionIdMap, HashMap<String, Set<Long>> errorMap, Map<Long, String> midMap, DynamicObject[] depempInfosWhithEmpInfos, InitOutParam initOutParam, Map<Long, Long> result) {
        String msg = ResManager.loadKDString((String)"\u5458\u5de5{0}\u7684\u4efb\u804c\u7ecf\u5386\u672a\u627e\u5230\u3002\u8bf7\u786e\u8ba4\u5458\u5de5\u4efb\u804c\u7ecf\u5386\u4e0e\u6240\u586b\u5199\u7684\u804c\u4f4d/\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d\u3001\u884c\u653f\u7ec4\u7ec7\u662f\u5426\u4e00\u81f4\uff0c\u4ee5\u4fbf\u63a8\u9001\u7b97\u85aa\u6570\u636e\u3002", (String)"HCDMInitValidateHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
        for (Map.Entry<Long, DynamicObject> entry : positionInfoNotEmptyMap.entrySet()) {
            Long mid = entry.getKey();
            DynamicObject dy = entry.getValue();
            Date bsed = dy.getDate("bsed");
            Set<Object> objects = midAndPositionIdMap.get(mid);
            boolean isNeedPush = dy.getBoolean("needpush");
            if (ArrayUtils.isEmpty((Object[])depempInfosWhithEmpInfos) && isNeedPush) {
                LOGGER.info("\u672a\u627e\u5230\u5458\u5de5\u7684\u4efb\u804c\u7ecf\u5386 in checkPositionInfoNotEmpty 1");
                String errorMsg = MessageFormat.format(msg, SWCDateTimeUtils.formatDate((Date)bsed));
                initOutParam.addErrorMsg(mid, errorMsg);
                Set set = errorMap.computeIfAbsent(midMap.get(mid), k1 -> Sets.newHashSetWithExpectedSize((int)4));
                set.add(mid);
                continue;
            }
            boolean isDepempNotEmpty = false;
            for (DynamicObject depemp : depempInfosWhithEmpInfos) {
                if (!objects.contains(depemp.get("employee.empnumber")) || !objects.contains(depemp.get("adminorg.id")) || !objects.contains(depemp.get("stdposition.id")) && !objects.contains(depemp.get("position.id")) && !objects.contains(depemp.get("job.id"))) continue;
                Date endDate = depemp.getDate("enddate") == null ? SWCBaseUtils.getMaxLoseEffectDate() : depemp.getDate("enddate");
                LOGGER.info("\u627e\u5230\u4e86\u5458\u5de5\u7684\u4efb\u804c\u7ecf\u5386 in checkPositionInfoNotEmpty\uff0c\u4f46\u662f\u5b58\u5728\u591a\u4e2a\u7ec4\u7ec7\u4eba\uff0c\u53d6\u8303\u56f4\u4e0d\u6b63\u786e\u3002bsed = {}, startdate = {} endDate = {}", new Object[]{bsed, depemp.getDate("startdate"), endDate});
                if (!SWCDateTimeUtils.isCover((Date)bsed, (Date)depemp.getDate("startdate"), (Date)endDate)) continue;
                isDepempNotEmpty = true;
                result.put(mid, depemp.getLong("depemp.id"));
                break;
            }
            if (isDepempNotEmpty || !isNeedPush) continue;
            LOGGER.info("\u672a\u627e\u5230\u5458\u5de5\u7684\u4efb\u804c\u7ecf\u5386 in checkPositionInfoNotEmpty 2");
            String errorMsg = MessageFormat.format(msg, SWCDateTimeUtils.formatDate((Date)bsed));
            initOutParam.addErrorMsg(mid, errorMsg);
            Set set = errorMap.computeIfAbsent(midMap.get(mid), k1 -> Sets.newHashSetWithExpectedSize((int)4));
            set.add(mid);
        }
    }

    private static void checkPositionInfoWithEmpty(Map<Long, DynamicObject> positionInfoEmptyMap, Map<String, List<DynamicObject>> depEmpInfoByEmpNumber, HashMap<String, Set<Long>> errorMap, Map<Long, String> midMap, InitOutParam initOutParam, Map<Long, Long> result) {
        String msg = ResManager.loadKDString((String)"\u5458\u5de5{0}\u7684\u4efb\u804c\u7ecf\u5386\u672a\u627e\u5230\u3002\u8bf7\u786e\u8ba4\u5458\u5de5\u4efb\u804c\u7ecf\u5386\u4e0e\u6240\u586b\u5199\u7684\u804c\u4f4d/\u5c97\u4f4d/\u6807\u51c6\u5c97\u4f4d\u3001\u884c\u653f\u7ec4\u7ec7\u662f\u5426\u4e00\u81f4\uff0c\u4ee5\u4fbf\u63a8\u9001\u7b97\u85aa\u6570\u636e\u3002", (String)"HCDMInitValidateHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
        for (Map.Entry<Long, DynamicObject> entry : positionInfoEmptyMap.entrySet()) {
            Long mid = entry.getKey();
            DynamicObject dy = entry.getValue();
            Date bsed = dy.getDate("bsed");
            boolean isNeedPush = dy.getBoolean("needpush");
            if (CollectionUtils.isEmpty(depEmpInfoByEmpNumber) && isNeedPush) {
                String errorMsg = MessageFormat.format(msg, SWCDateTimeUtils.formatDate((Date)bsed));
                initOutParam.addErrorMsg(mid, errorMsg);
                Set set = errorMap.computeIfAbsent(midMap.get(mid), k1 -> Sets.newHashSetWithExpectedSize((int)4));
                set.add(mid);
                continue;
            }
            List<DynamicObject> depEmpInfos = depEmpInfoByEmpNumber.get(dy.getString("hcdm_decadjrelperson.empnumber"));
            DynamicObject matchDy = null;
            if (!CollectionUtils.isEmpty(depEmpInfos)) {
                for (DynamicObject emp : depEmpInfos) {
                    if (!SWCDateTimeUtils.isCover((Date)bsed, (Date)emp.getDate("startdate"), (Date)emp.getDate("enddate")) || !(matchDy = emp).getBoolean("isprimary")) continue;
                    result.put(mid, matchDy.getLong("depemp.id"));
                }
            }
            if (null != matchDy || !isNeedPush) continue;
            String errorMsg = MessageFormat.format(msg, SWCDateTimeUtils.formatDate((Date)bsed));
            initOutParam.addErrorMsg(mid, errorMsg);
            Set set = errorMap.computeIfAbsent(midMap.get(mid), k1 -> Sets.newHashSetWithExpectedSize((int)4));
            set.add(mid);
        }
    }

    private static void checkStandardInfo(Map<Long, DynamicObject> midAndDataMap, Set<String> keyInfoIds, List<DynamicObject> standars, Map<String, Set<Long>> midMap, Set<Long> errorMids, InitOutParam initOutParam) {
        HashSet midSet = Sets.newHashSetWithExpectedSize((int)keyInfoIds.size());
        for (String keyInfoId : keyInfoIds) {
            Set<Long> ids = midMap.get(keyInfoId);
            midSet.addAll(ids);
        }
        String msg = ResManager.loadKDString((String)"\u85aa\u916c\u4f53\u7cfb\uff1a{0}\u4e2d\u5b9a\u8c03\u85aa\u9879\u76ee\uff1a{1}\u5bf9\u5e94\u7684\u85aa\u916c\u6807\u51c6\u8868\u4e0e\u5f53\u524d\u586b\u5199\u7684\u85aa\u916c\u6807\u51c6\u8868\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u5e76\u4fdd\u6301\u4e00\u81f4\u3002", (String)"HCDMInitValidateHelper_8", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashMap matchMap = Maps.newHashMapWithExpectedSize((int)midAndDataMap.size());
        HashSet notNeedMatchMids = Sets.newHashSetWithExpectedSize((int)16);
        HashSet stdIds = Sets.newHashSetWithExpectedSize((int)midAndDataMap.size());
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)midAndDataMap.size());
        block1: for (Long mid : midSet) {
            DynamicObject midDy = midAndDataMap.get(mid);
            if (0L == midDy.getLong("salarystd.id") && 0L == midDy.getLong("grade.id") && 0L == midDy.getLong("rank.id")) {
                notNeedMatchMids.add(mid);
                continue;
            }
            for (DynamicObject standar : standars) {
                List itemIds;
                if (!SWCDateTimeUtils.isCover((Date)midDy.getDate("bsed"), (Date)standar.getDate("bsed"), (Date)standar.getDate("bsled"))) continue;
                if (0L == midDy.getLong("salarystd.id")) {
                    matchMap.put(mid, standar);
                    stdIds.add(standar.getLong("id"));
                    midDy.set("salarystd", (Object)standar);
                    itemIds = stdItemMap.computeIfAbsent(standar.getLong("id"), val -> Lists.newArrayList());
                    itemIds.add(midDy.getLong("standarditem.id"));
                    continue block1;
                }
                if (midDy.getLong("salarystd.id") != standar.getLong("boid")) {
                    String errorMsg = MessageFormat.format(msg, midDy.getString("hcdm_decadjrelperson.stdscm.name"), midDy.getString("standarditem.name"));
                    initOutParam.addErrorMsg(mid, errorMsg);
                    errorMids.add(mid);
                    continue block1;
                }
                midDy.set("salarystd", (Object)standar);
                matchMap.put(mid, standar);
                stdIds.add(standar.getLong("id"));
                itemIds = stdItemMap.computeIfAbsent(standar.getLong("id"), val -> Lists.newArrayList());
                itemIds.add(midDy.getLong("standarditem.id"));
            }
        }
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag = service.getSalaryItemUseRankFlag(stdItemMap);
        Map<Long, List<SalaryGradeEntity>> gradeMap = GradeRankHelper.queryGradeEntities(stdIds);
        Map<Long, List<SalaryRankEntity>> rankMap = GradeRankHelper.querySalaryRankEntities(stdIds, true);
        for (Map.Entry<Long, DynamicObject> entry : midAndDataMap.entrySet()) {
            Long key = entry.getKey();
            if (errorMids.contains(key) || notNeedMatchMids.contains(key) || !midSet.contains(key)) continue;
            DynamicObject midDy = entry.getValue();
            if (!matchMap.containsKey(key)) {
                String notMatchError = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u7b49\u3001\u85aa\u6863\u672a\u627e\u5230\u5339\u914d\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0]);
                initOutParam.addErrorMsg(key, notMatchError);
                errorMids.add(key);
                continue;
            }
            DynamicObject dynamicObject = (DynamicObject)matchMap.get(key);
            long midGradeId = midDy.getLong("grade.id");
            long midRankId = midDy.getLong("rank.id");
            if (0L == midGradeId && 0L == midRankId) continue;
            List<SalaryGradeEntity> grades = gradeMap.get(dynamicObject.getLong("id"));
            List<SalaryRankEntity> ranks = rankMap.get(dynamicObject.getLong("id"));
            boolean gradeMatch = false;
            String gradeName = midDy.getString("grade.name");
            for (SalaryGradeEntity grade : grades) {
                if (null == gradeName) {
                    gradeMatch = true;
                    break;
                }
                if (!gradeName.equals(grade.getGradeName())) continue;
                gradeMatch = true;
                midDy.set("grade", (Object)grade.getId());
                break;
            }
            boolean rankMatch = false;
            String rankName = midDy.getString("rank.name");
            Map<Long, Boolean> map = salaryItemUseRankFlag.get(midDy.getLong("salarystd.id"));
            for (SalaryRankEntity rank : ranks) {
                if (null == rankName) {
                    rankMatch = true;
                    break;
                }
                Boolean useRank = true;
                if (!CollectionUtils.isEmpty(map)) {
                    useRank = map.get(midDy.getLong("standarditem.id"));
                }
                if (!rankName.equals(rank.getRankName()) || !useRank.booleanValue()) continue;
                rankMatch = true;
                midDy.set("rank", (Object)rank.getId());
                break;
            }
            if (rankMatch && gradeMatch) continue;
            String rankAndGradeErrMsg = HCDMInitValidateHelper.getRankAndGradeErrMsg(rankName, gradeName, midDy.getString("salarystd.name"));
            initOutParam.addErrorMsg(key, rankAndGradeErrMsg);
            errorMids.add(key);
        }
    }

    private static String getRankAndGradeErrMsg(String rankName, String gradeName, String stdscmName) {
        if (null != rankName && null != gradeName) {
            String rankAndGradError = ResManager.loadKDString((String)"\u85aa\u7b49\u201c{0}\u201d\uff0c\u85aa\u6863\u201c{1}\u201d\u4e0d\u5728\u85aa\u916c\u6807\u51c6\u8868\u201c{2}\u201d\u8303\u56f4\u5185\uff0c\u8bf7\u8fdb\u884c\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_10", (String)"swc-hcdm-business", (Object[])new Object[0]);
            return MessageFormat.format(rankAndGradError, gradeName, rankName, stdscmName);
        }
        if (null != gradeName) {
            String rankAndGradError = ResManager.loadKDString((String)"\u85aa\u7b49\u201c{0}\u201d\u4e0d\u5728\u85aa\u916c\u6807\u51c6\u8868\u201c{1}\u201d\u8303\u56f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_18", (String)"swc-hcdm-business", (Object[])new Object[0]);
            return MessageFormat.format(rankAndGradError, gradeName, stdscmName);
        }
        if (null != rankName) {
            String rankAndGradError = ResManager.loadKDString((String)"\u85aa\u6863\u201c{0}\u201d\u4e0d\u5728\u85aa\u916c\u6807\u51c6\u8868\u201c{1}\u201d\u8303\u56f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_19", (String)"swc-hcdm-business", (Object[])new Object[0]);
            return MessageFormat.format(rankAndGradError, rankName, stdscmName);
        }
        return ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u7b49\u3001\u85aa\u6863\u672a\u627e\u5230\u5339\u914d\u7684\u85aa\u916c\u6807\u51c6\u8868\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_9", (String)"swc-hcdm-business", (Object[])new Object[0]);
    }

    private static void removeErrorData(Map<Long, DynamicObject> dataMap, Set<Long> errIds) {
        if (!CollectionUtils.isEmpty(errIds)) {
            errIds.forEach(dataMap::remove);
        }
    }

    private static Map<String, Map<Long, DynamicObject>> mergeGroupErrMsg(Map<String, Map<Long, DynamicObject>> groupData, Set<Long> errorMids, InitOutParam initOutParam) {
        if (CollectionUtils.isEmpty(errorMids)) {
            return groupData;
        }
        Iterator<Map.Entry<String, Map<Long, DynamicObject>>> iterator = groupData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<Long, DynamicObject>> next = iterator.next();
            Map<Long, DynamicObject> map = next.getValue();
            Set<Long> set = map.keySet();
            Sets.SetView errIds = Sets.intersection(errorMids, set);
            if (!CollectionUtils.isEmpty((Collection)errIds)) {
                HCDMInitValidateHelper.removeErrorData(map, (Set<Long>)errIds);
            }
            if (!CollectionUtils.isEmpty(map)) continue;
            iterator.remove();
        }
        if (!CollectionUtils.isEmpty(groupData) && CollectionUtils.isEmpty(groupData.values())) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return groupData;
    }

    private static void checkInitInfoInRecordByDimensionNumber(Map<String, Map<Long, DynamicObject>> groupData, HashMap<String, Map<Long, DynamicObject>> dimensionNumberMap, InitOutParam initOutParam) {
        HashSet empnumbers = Sets.newHashSetWithExpectedSize((int)16);
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet countryIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet stdscmIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap map = Maps.newHashMapWithExpectedSize((int)dimensionNumberMap.size());
        block0: for (Map.Entry<String, Map<Long, DynamicObject>> entry : dimensionNumberMap.entrySet()) {
            String key = entry.getKey();
            Map<Long, DynamicObject> value = entry.getValue();
            for (Map.Entry<Long, DynamicObject> longDynamicObjectEntry : value.entrySet()) {
                String enmNuOrgCountryStdmscm = HCDMInitValidateHelper.geEmpNuOrgCountryStdmscm(empnumbers, orgIds, countryIds, stdscmIds, longDynamicObjectEntry);
                if (StringUtils.isEmpty((Object)enmNuOrgCountryStdmscm)) continue;
                map.put(enmNuOrgCountryStdmscm, key);
                continue block0;
            }
        }
        Map<String, List<DynamicObject>> result = DecideAdjSalaryServiceHelper.queryInitInfoByDimensionNumber(empnumbers, orgIds, countryIds, stdscmIds);
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        String recordErrorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0e\u5458\u5de5\u5b9a\u8c03\u85aa\u6863\u6848\uff08\u82e5\u5458\u5de5\u6ca1\u6709\u6863\u6848\u5219\u9700\u6ee1\u8db3\u540c\u4e00\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3001\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u3001\u85aa\u916c\u4f53\u7cfb\uff09\u4e0b\u6570\u636e\u751f\u5931\u6548\u65e5\u671f\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_16", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String candiDateErrormsg = ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u5b58\u5728\u5019\u9009\u4eba\u5b9a\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u5b9a\u8c03\u85aa\u6570\u636e\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_12", (String)"swc-hcdm-business", (Object[])new Object[0]);
        block2: for (Map.Entry<String, List<DynamicObject>> entry : result.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> dys = entry.getValue();
            for (DynamicObject recordDy : dys) {
                String dimensionKey = (String)map.get(key);
                if (!SWCStringUtils.isNotEmpty((String)dimensionKey)) continue;
                Map<Long, DynamicObject> datas = groupData.get(dimensionKey);
                if ("2".equals(recordDy.getString("datasource"))) {
                    datas.forEach((mid, data) -> initOutParam.addErrorMsg(mid, candiDateErrormsg));
                    groupData.remove(dimensionKey);
                    continue block2;
                }
                Date recordBsed = recordDy.getDate("bsed");
                Date recordBsled = recordDy.getDate("bsled");
                long stdItemId = recordDy.getLong("standarditem.id");
                HashSet errIds = Sets.newHashSetWithExpectedSize((int)datas.size());
                datas.forEach((mid, dy) -> {
                    Date bsed = dy.getDate("bsed");
                    Date bsled = HCDMInitValidateHelper.getBsledFromMidTableDynamicObj(dy);
                    if (stdItemId != dy.getLong("standarditem.id")) {
                        return;
                    }
                    if (SWCDateTimeUtils.isDateRangeOverlap((Date)bsed, (Date)bsled, (Date)recordBsed, (Date)recordBsled)) {
                        initOutParam.addErrorMsg(mid, recordErrorMsg);
                        errIds.add(mid);
                    }
                });
                if (CollectionUtils.isEmpty((Collection)errIds)) continue;
                HCDMInitValidateHelper.removeErrorData(groupData.get(dimensionKey), errIds);
            }
        }
    }

    private static String geEmpNuOrgCountryStdmscm(Set<String> empnumbers, Set<Long> orgIds, Set<Long> countryIds, Set<String> stdscmIds, Map.Entry<Long, DynamicObject> longDynamicObjectEntry) {
        StringBuilder bu = new StringBuilder();
        DynamicObject dy = longDynamicObjectEntry.getValue();
        String empnumber = dy.getString("hcdm_decadjrelperson.empnumber");
        empnumbers.add(empnumber);
        bu.append(empnumber);
        long orgId = dy.getLong("hcdm_decadjrelperson.org.id");
        orgIds.add(orgId);
        bu.append(orgId);
        long countryId = dy.getLong("hcdm_decadjrelperson.country.id");
        countryIds.add(countryId);
        bu.append(countryId);
        String stdscmnumber = dy.getString("hcdm_decadjrelperson.stdscm.number");
        stdscmIds.add(stdscmnumber);
        bu.append(stdscmnumber);
        return bu.toString();
    }

    private static void checkInitInfoInRecordByAdjFileNumber(Map<String, Map<Long, DynamicObject>> groupData, HashMap<String, Map<Long, DynamicObject>> salaryadjFileNumberMap, InitOutParam initOutParam) {
        HashSet fileIds = Sets.newHashSetWithExpectedSize((int)groupData.size());
        salaryadjFileNumberMap.forEach((key, vlaue) -> vlaue.forEach((mid, dy) -> fileIds.add(dy.getLong("salaryadjfile.id"))));
        Object[] dynamicObjects = DecideAdjSalaryServiceHelper.queryInitInfoBySalaryAdjFile(fileIds);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        String recordErrorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0e\u5458\u5de5\u5b9a\u8c03\u85aa\u6863\u6848\uff08\u82e5\u5458\u5de5\u6ca1\u6709\u6863\u6848\u5219\u9700\u6ee1\u8db3\u540c\u4e00\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3001\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u3001\u85aa\u916c\u4f53\u7cfb\uff09\u4e0b\u6570\u636e\u751f\u5931\u6548\u65e5\u671f\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_16", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String candiDateErrormsg = ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u5b58\u5728\u5019\u9009\u4eba\u5b9a\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u5b9a\u8c03\u85aa\u6570\u636e\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_12", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Map<String, List<DynamicObject>> map = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(object -> object.getString("salaryadjfile.number")));
        block0: for (Map.Entry<String, Map<Long, DynamicObject>> entry : salaryadjFileNumberMap.entrySet()) {
            if (CollectionUtils.isEmpty(groupData)) break;
            String key2 = entry.getKey();
            Map<Long, DynamicObject> value = entry.getValue();
            List<DynamicObject> list = map.get(key2);
            if (CollectionUtils.isEmpty(list)) continue;
            for (DynamicObject recordDy : list) {
                if ("2".equals(recordDy.getString("datasource"))) {
                    value.forEach((mid, data) -> initOutParam.addErrorMsg(mid, candiDateErrormsg));
                    groupData.remove(key2);
                    continue block0;
                }
                Date recordBsed = recordDy.getDate("bsed");
                Date recordBsled = recordDy.getDate("bsled");
                long stdItemId = recordDy.getLong("standarditem.id");
                HashSet errIds = Sets.newHashSetWithExpectedSize((int)value.size());
                for (Map.Entry<Long, DynamicObject> longDynamicObjectEntry : value.entrySet()) {
                    Long mid2 = longDynamicObjectEntry.getKey();
                    DynamicObject dy = longDynamicObjectEntry.getValue();
                    Date bsed = dy.getDate("bsed");
                    Date bsled = HCDMInitValidateHelper.getBsledFromMidTableDynamicObj(dy);
                    if (stdItemId != dy.getLong("standarditem.id") || !SWCDateTimeUtils.isDateRangeOverlap((Date)bsed, (Date)bsled, (Date)recordBsed, (Date)recordBsled)) continue;
                    initOutParam.addErrorMsg(mid2, recordErrorMsg);
                    errIds.add(mid2);
                }
                if (CollectionUtils.isEmpty((Collection)errIds)) continue;
                HCDMInitValidateHelper.removeErrorData(groupData.get(key2), errIds);
            }
        }
    }

    private static Map<String, Map<Long, DynamicObject>> checkCurTaskInfo(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        Date maxLoseEffectDate = SWCBaseUtils.getMaxLoseEffectDate();
        String dateCoverMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0e\u4efb\u52a1\u4e2d\u5176\u4ed6\u6570\u636e\u5b58\u5728\u751f\u5931\u6548\u65e5\u671f\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_14", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String eqErrMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0e\u4efb\u52a1\u4e2d\u5176\u4ed6\u6570\u636e\u751f\u6548\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_15", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String bsedErrMsg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65e5\u671f\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_20", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashSet errorIds = Sets.newHashSetWithExpectedSize((int)groupData.size());
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : groupData.entrySet()) {
            Map<Long, DynamicObject> data = entry.getValue();
            for (Map.Entry<Long, DynamicObject> dataEntry : data.entrySet()) {
                Long mid = dataEntry.getKey();
                DynamicObject dy = dataEntry.getValue();
                Date bsed = dy.getDate("bsed");
                Date bsled = HCDMInitValidateHelper.getBsledFromMidTableDynamicObj(dy);
                if (bsled.before(bsed)) {
                    initOutParam.addErrorMsg(mid, bsedErrMsg);
                    errorIds.add(mid);
                    continue;
                }
                long stdItemId = dy.getLong("standarditem.id");
                for (Map.Entry<Long, DynamicObject> en : data.entrySet()) {
                    DynamicObject value = en.getValue();
                    if (en.getKey().equals(mid) || stdItemId != value.getLong("standarditem.id")) continue;
                    Date bsedOther = value.getDate("bsed");
                    Date bsledOther = HCDMInitValidateHelper.getBsledFromMidTableDynamicObj(value);
                    if (SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd").equals(SWCDateTimeUtils.format((Date)maxLoseEffectDate, (String)"yyyy-MM-dd"))) {
                        if (!bsed.equals(bsedOther)) continue;
                        initOutParam.addErrorMsg(mid, eqErrMsg);
                        errorIds.add(mid);
                        continue;
                    }
                    if (!SWCDateTimeUtils.isDateRangeOverlap((Date)bsed, (Date)bsled, (Date)bsedOther, (Date)bsledOther)) continue;
                    initOutParam.addErrorMsg(mid, dateCoverMsg);
                    errorIds.add(mid);
                }
            }
        }
        return HCDMInitValidateHelper.mergeGroupErrMsg(groupData, errorIds, initOutParam);
    }

    private static Date getBsledFromMidTableDynamicObj(DynamicObject dyObj) {
        Date maxLoseEffectDate = SWCBaseUtils.getMaxLoseEffectDate();
        Date bsled = dyObj.getDate("bsled");
        if (bsled != null) {
            return bsled;
        }
        return maxLoseEffectDate;
    }

    private static String getDisplayName(Set<String> fileds, Map<String, QuerySelectField> fieldMap) {
        HashSet displayNames = Sets.newHashSetWithExpectedSize((int)fileds.size());
        for (String filed : fileds) {
            QuerySelectField selectield;
            if (filed.startsWith("hcdm_decadjrelperson.")) {
                filed = filed.replace("hcdm_decadjrelperson.", "");
            }
            if (null == (selectield = fieldMap.get(filed))) continue;
            displayNames.add(selectield.getDisplayName());
        }
        return String.join((CharSequence)"\uff0c", displayNames);
    }

    private static void setEmptyName(Map<String, List<DynamicObject>> emptyNameMap, DynamicObject[] dynamicObjects) {
        for (DynamicObject empl : dynamicObjects) {
            List<DynamicObject> list = emptyNameMap.get(empl.get("empnumber"));
            for (DynamicObject dy : list) {
                dy.set("hcdm_decadjrelperson.personname", (Object)empl.getString("person.name"));
            }
        }
    }

    private static void checkADJFileInfo(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam, Set<Object> adjFileNumber, Map<String, Map<Long, DynamicObject>> result, Map<String, Map<Long, DynamicObject>> dataWithLegal) {
        String fileNumber;
        DynamicObject[] dynamicObjects = null;
        if (!CollectionUtils.isEmpty(adjFileNumber)) {
            dynamicObjects = SalaryAdjFileServiceHelper.queryAdjFileByNumber(adjFileNumber);
        }
        if (ArrayUtils.isEmpty(dynamicObjects)) {
            return;
        }
        String consistentInfoMsg = ResManager.loadKDString((String)"{0}\u4e0e\u6863\u6848\u5185\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u8c03\u6574\u3002", (String)"HCDMInitValidateHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        Map<String, List<DynamicObject>> listMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(object -> object.getString("number")));
        Map<String, QuerySelectField> fieldMap = HCDMInitValidateHelper.getFieldAlias();
        for (Map.Entry<String, List<DynamicObject>> entry : listMap.entrySet()) {
            fileNumber = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            Map<Long, DynamicObject> dataMap = groupData.get(fileNumber);
            Set<Long> errIds = HCDMInitValidateHelper.checkDataLegal(fieldMap, list.get(0), dataMap, initOutParam, consistentInfoMsg);
            if (CollectionUtils.isEmpty(errIds)) {
                dataWithLegal.put(fileNumber, dataMap);
                continue;
            }
            HCDMInitValidateHelper.removeErrorData(dataMap, errIds);
            if (CollectionUtils.isEmpty(dataMap)) continue;
            dataWithLegal.put(fileNumber, dataMap);
        }
        if (CollectionUtils.isEmpty(dataWithLegal)) {
            return;
        }
        for (Map.Entry<String, Object> entry : dataWithLegal.entrySet()) {
            fileNumber = entry.getKey();
            Map dataMap = (Map)entry.getValue();
            List<DynamicObject> list = listMap.get(fileNumber);
            if (!HCDMInitValidateHelper.checkFileStatus(list.get(0), dataMap.keySet(), initOutParam)) continue;
            result.put(fileNumber, dataMap);
        }
    }

    private static void checkStdAndStructureWithNoADJFileNumber(Map<String, Map<Long, DynamicObject>> groupData, Map<String, Map<Long, DynamicObject>> result, Set<Long> structureIds, Set<String> noFileNumberDataSet, InitOutParam initOutParam) {
        if (CollectionUtils.isEmpty(noFileNumberDataSet)) {
            return;
        }
        Map<Long, List<DynamicObject>> listMap = SalaryStandardScmHelper.queryStdScmMapByStructureIds(structureIds);
        for (String number : noFileNumberDataSet) {
            Map<Long, DynamicObject> dataMap = groupData.get(number);
            if (CollectionUtils.isEmpty(dataMap)) continue;
            Set<Long> errIds = HCDMInitValidateHelper.checkStdscmAndStructureRelated(listMap, dataMap, initOutParam);
            HCDMInitValidateHelper.removeErrorData(dataMap, errIds);
            if (CollectionUtils.isEmpty(dataMap)) continue;
            result.put(number, dataMap);
        }
    }

    private static Set<Long> checkStdscmAndStructureRelated(Map<Long, List<DynamicObject>> listMap, Map<Long, DynamicObject> map, InitOutParam initOutParam) {
        HashSet errorIds = Sets.newHashSetWithExpectedSize((int)map.size());
        for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
            DynamicObject data = entry.getValue();
            Long mId = entry.getKey();
            long structureId = data.getLong("hcdm_decadjrelperson.salaystructure.id");
            long stdScmId = data.getLong("hcdm_decadjrelperson.stdscm.id");
            List<DynamicObject> stdScmList = listMap.get(structureId);
            if (!CollectionUtils.isEmpty(stdScmList) && stdScmList.get(0).getLong(0) == stdScmId) continue;
            errorIds.add(mId);
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u916c\u7ed3\u6784\u4e0d\u5728\u85aa\u916c\u4f53\u7cfb\u4e2d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"HCDMInitValidateHelper_21", (String)"swc-hcdm-business", (Object[])new Object[0]);
            initOutParam.addErrorMsg(mId, errorMsg);
        }
        return errorIds;
    }

    private static Map<String, Map<Long, DynamicObject>> checkMatchAdjFileVersion(Map<String, Map<Long, DynamicObject>> groupData, InitOutParam initOutParam) {
        ArrayList fileMatchParams = Lists.newArrayListWithExpectedSize((int)groupData.size());
        for (Map.Entry<String, Map<Long, DynamicObject>> entry : groupData.entrySet()) {
            Map<Long, DynamicObject> dataMap = entry.getValue();
            for (Map.Entry<Long, DynamicObject> entry2 : dataMap.entrySet()) {
                DynamicObject value = entry2.getValue();
                if (null == value.get("salaryadjfile")) continue;
                Long fileId = value.getLong("salaryadjfile.id");
                Long standarditemId = value.getLong("standarditem.id");
                Date bsed = value.getDate("bsed");
                Date bsled = HCDMInitValidateHelper.getBsledFromMidTableDynamicObj(value);
                String unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(fileId), String.valueOf(standarditemId), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
                AdjFileMatchParam fileMatchParam = new AdjFileMatchParam();
                fileMatchParam.setAdjFileBoId(fileId);
                fileMatchParam.setBsed(bsed);
                fileMatchParam.setBsled(bsled);
                fileMatchParam.setUnionId(unionId);
                fileMatchParams.add(fileMatchParam);
            }
        }
        if (CollectionUtils.isEmpty((Collection)fileMatchParams)) {
            return groupData;
        }
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map<String, AdjfileMatchResult> matchResultMap = adjFileApplicationService.batchMatchEffectiveAdjfileVersion(fileMatchParams);
        HashMap result = Maps.newHashMapWithExpectedSize((int)groupData.size());
        for (Map.Entry<Object, Object> entry : groupData.entrySet()) {
            String dimensionNumber = (String)entry.getKey();
            Map dataMap = (Map)entry.getValue();
            Iterator iterator = dataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                DynamicObject value = (DynamicObject)next.getValue();
                if (null != value.get("salaryadjfile")) {
                    Long fileId = value.getLong("salaryadjfile.id");
                    Long standarditemId = value.getLong("standarditem.id");
                    Date bsed = value.getDate("bsed");
                    Date bsled = HCDMInitValidateHelper.getBsledFromMidTableDynamicObj(value);
                    String unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(fileId), String.valueOf(standarditemId), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
                    AdjfileMatchResult adjfileMatchResult = matchResultMap.get(unionId);
                    if (null == adjfileMatchResult) continue;
                    DynamicObject adjfileVersion = adjfileMatchResult.getAdjfileVersion();
                    if (null == adjfileVersion) {
                        initOutParam.addErrorMsg((Long)next.getKey(), adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString());
                        iterator.remove();
                        continue;
                    }
                    value.set("salaryadjfilevid", (Object)adjfileVersion);
                    result.put(dimensionNumber, dataMap);
                    continue;
                }
                result.put(dimensionNumber, dataMap);
            }
        }
        return result;
    }
}

