/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.matchprop;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.ContrastPropLoadEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetCustomerQFilterEvent;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.swc.hcdm.business.salarystandard.AppliedRangeHelper;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class HcdmContrastPropPlugin
implements IHcdmContrastPropExtPlugin {
    public void loadContrastPropValue(ContrastPropLoadEvent event) {
        Map<Long, Map<Long, Object>> result = this.getContrastPropValue(event.getPropCfgList(), event.getAdjFileIdList(), event.isVersion());
        event.setPropValues(result);
    }

    public void onGetCustomerQFilter(OnGetCustomerQFilterEvent event) {
        String scene;
        switch (scene = event.getScene()) {
            case "beforeF7Select": {
                this.prepareQFilterForBeforeF7(event);
                break;
            }
            case "downloadTemplate": {
                this.prepareQFilterForBeforeDownloadTpl(event);
                break;
            }
            case "importValidate": {
                this.prepareQFilterForBeforeImportValidate(event);
                break;
            }
        }
    }

    private void prepareQFilterForBeforeF7(OnGetCustomerQFilterEvent event) {
        for (ContrastPropConfigEntity configEntity : event.getPropCfgList()) {
            IDataEntityProperty initStatusProp;
            String entityName = configEntity.getObjectTypeIId();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            Map allFields = mainEntityType.getAllFields();
            ArrayList qFilters = Lists.newArrayList();
            if (allFields.containsKey("enable")) {
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
            }
            if (allFields.containsKey("status")) {
                qFilters.add(new QFilter("status", "=", (Object)"C"));
            }
            if (allFields.containsKey("iscurrentversion")) {
                qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            }
            if ((initStatusProp = (IDataEntityProperty)allFields.get("initstatus")) != null && !initStatusProp.isDbIgnore()) {
                qFilters.add(new QFilter("initstatus", "in", (Object)new String[]{"2", " "}));
            }
            if (configEntity.getId().equals(1050L)) {
                Set<Long> levelscmhrIds = AppliedRangeHelper.queryGradeOrLevelIds("hbjm_joblevelscmhr");
                qFilters.add(new QFilter("joblevelscm", "in", levelscmhrIds));
            }
            if (configEntity.getId().equals(1060L)) {
                Set<Long> gradescmhrIds = AppliedRangeHelper.queryGradeOrLevelIds("hbjm_jobgradescmhr");
                qFilters.add(new QFilter("jobgradescm", "in", gradescmhrIds));
            }
            if (configEntity.getId().equals(1130L)) {
                qFilters.add(new QFilter("createmode", "!=", (Object)"3"));
            }
            if (qFilters.isEmpty()) continue;
            event.getCustomerQFilter().put(configEntity.getId(), qFilters);
        }
    }

    private void prepareQFilterForBeforeDownloadTpl(OnGetCustomerQFilterEvent event) {
        this.prepareQFilterForBeforeF7(event);
    }

    private void prepareQFilterForBeforeImportValidate(OnGetCustomerQFilterEvent event) {
        this.prepareQFilterForBeforeF7(event);
    }

    private Map<Long, Map<Long, Object>> getContrastPropValue(List<ContrastPropConfigEntity> propCfg, List<Long> fileIds, boolean isVersion) {
        DynamicObject[] fileObjArr;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        fileIds.forEach(aLong -> resultMap.computeIfAbsent(aLong, v1 -> Maps.newHashMap()));
        HashMap fileMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashSet depempIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet employeeIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet empposorgrelIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet jobIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet stdPositionIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet companyAdminOrgIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashSet departmentAdminOrgIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
        HashMap fileIdToDepempMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToEmpposorgrelMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToJobMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPositionMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToStdPositionMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        SWCDataServiceHelper fileService = new SWCDataServiceHelper("hcdm_adjfileinfo");
        for (DynamicObject fileObj : fileObjArr = fileService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", fileIds)})) {
            long fileId = fileObj.getLong("id");
            fileMap.put(fileId, fileObj);
            depempIds.add(fileObj.getLong("depemp.id"));
            personIds.add(fileObj.getLong("person.id"));
            employeeIds.add(fileObj.getLong("employee.id"));
            empposorgrelIds.add(fileObj.getLong("empposorgrel.id"));
        }
        SWCDataServiceHelper depempService = new SWCDataServiceHelper("hrpi_depemp");
        DynamicObject[] depempObjArr = depempService.query("id,employee,otclassify,orgteam,adminorg", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("id", "in", (Object)depempIds)});
        Map depempMap = Arrays.stream(depempObjArr).collect(Collectors.toMap(o1 -> o1.getLong("id"), Function.identity(), (o1, o2) -> o2));
        SWCDataServiceHelper empposorgrelService = new SWCDataServiceHelper("hrpi_empposorgrel");
        DynamicObject[] empposorgrelObjArr = empposorgrelService.query("id,job,postype,adminorg,position,employee,workplace,stdposition,company", new QFilter[]{new QFilter("id", "in", (Object)empposorgrelIds), new QFilter("datastatus", "!=", (Object)"-1")});
        Map empposorgrelMap = Arrays.stream(empposorgrelObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        for (Map.Entry entry : fileMap.entrySet()) {
            DynamicObject empposorgrelObj;
            long empposorgrelId = ((DynamicObject)entry.getValue()).getLong("empposorgrel.id");
            if (empposorgrelId <= 0L || (empposorgrelObj = (DynamicObject)empposorgrelMap.get(empposorgrelId)) == null) continue;
            jobIds.add(empposorgrelObj.getLong("job.id"));
            positionIds.add(empposorgrelObj.getLong("position.id"));
            stdPositionIds.add(empposorgrelObj.getLong("stdposition.id"));
        }
        SWCDataServiceHelper jobService = new SWCDataServiceHelper("hbjm_jobhr");
        DynamicObject[] jobObjArr = jobService.query("id,number,name,jobscm,jobseq,jobfamily,jobclass", new QFilter[]{new QFilter("id", "in", (Object)jobIds)});
        Map jobMap = Arrays.stream(jobObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        SWCDataServiceHelper positionService = new SWCDataServiceHelper("hbpm_positionhr");
        DynamicObject[] positionObjArr = positionService.query("id,number,name,jobscm", new QFilter[]{new QFilter("id", "in", (Object)positionIds)});
        Map positionMap = Arrays.stream(positionObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        SWCDataServiceHelper stpositionService = new SWCDataServiceHelper("hbpm_stposition");
        DynamicObject[] stpositionObjArr = stpositionService.query("id,number,name,jobscm", new QFilter[]{new QFilter("id", "in", (Object)stdPositionIds)});
        Map stpositionMap = Arrays.stream(stpositionObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        for (Map.Entry entry : fileMap.entrySet()) {
            DynamicObject stpositionObj;
            DynamicObject positionObj;
            DynamicObject jobObj;
            DynamicObject empposorgrelObj;
            DynamicObject depempObj;
            long depempId = ((DynamicObject)entry.getValue()).getLong("depemp.id");
            long empposorgrelId = ((DynamicObject)entry.getValue()).getLong("empposorgrel.id");
            if (depempId > 0L && (depempObj = (DynamicObject)depempMap.get(depempId)) != null) {
                fileIdToDepempMap.putIfAbsent(entry.getKey(), depempObj);
                departmentAdminOrgIds.add(depempObj.getLong("adminorg.id"));
            }
            if (empposorgrelId <= 0L || (empposorgrelObj = (DynamicObject)empposorgrelMap.get(empposorgrelId)) == null) continue;
            fileIdToEmpposorgrelMap.putIfAbsent(entry.getKey(), empposorgrelObj);
            companyAdminOrgIds.add(empposorgrelObj.getLong("company.id"));
            long jobId = empposorgrelObj.getLong("job.id");
            long positionId = empposorgrelObj.getLong("position.id");
            long stdpositionId = empposorgrelObj.getLong("stdposition.id");
            if (jobId > 0L && (jobObj = (DynamicObject)jobMap.get(jobId)) != null) {
                fileIdToJobMap.putIfAbsent(entry.getKey(), jobMap.get(jobId));
            }
            if (positionId > 0L && (positionObj = (DynamicObject)positionMap.get(positionId)) != null) {
                fileIdToPositionMap.putIfAbsent(entry.getKey(), positionObj);
            }
            if (stdpositionId <= 0L || (stpositionObj = (DynamicObject)stpositionMap.get(stdpositionId)) == null) continue;
            fileIdToStdPositionMap.putIfAbsent(entry.getKey(), stpositionObj);
        }
        HashMap fileIdToEmpjobrelMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToDepartmentMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToEmpentrelMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPernontspropMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPerregionMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPereduexpMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToCollegeMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPerocpqualMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPerpractqualMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToPerprotitleMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToProtitletypeMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap fileIdToWorkplaceMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        block69: for (ContrastPropConfigEntity cfg : propCfg) {
            switch (cfg.getNumber()) {
                case "1000_S": {
                    DynamicObject job;
                    for (Long l : fileIds) {
                        job = (DynamicObject)fileIdToJobMap.get(l);
                        if (job != null && job.getLong("jobscm.id") > 0L) {
                            ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobscm.id"));
                            continue;
                        }
                        DynamicObject dynamicObject = (DynamicObject)fileIdToPositionMap.get(l);
                        DynamicObject stdpositionObj = (DynamicObject)fileIdToStdPositionMap.get(l);
                        if (dynamicObject != null && dynamicObject.getLong("jobscm.id") > 0L) {
                            ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), dynamicObject.getLong("jobscm.id"));
                            continue;
                        }
                        if (stdpositionObj == null || stdpositionObj.getLong("jobscm.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), stdpositionObj.getLong("jobscm.id"));
                    }
                    continue block69;
                }
                case "1010_S": {
                    DynamicObject job;
                    for (Long l : fileIds) {
                        job = (DynamicObject)fileIdToJobMap.get(l);
                        if (job == null || job.getLong("jobseq.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobseq.id"));
                    }
                    continue block69;
                }
                case "1020_S": {
                    DynamicObject job;
                    for (Long l : fileIds) {
                        job = (DynamicObject)fileIdToJobMap.get(l);
                        if (job == null || job.getLong("jobfamily.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobfamily.id"));
                    }
                    continue block69;
                }
                case "1030_S": {
                    DynamicObject job;
                    for (Long l : fileIds) {
                        job = (DynamicObject)fileIdToJobMap.get(l);
                        if (job == null || job.getLong("jobclass.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobclass.id"));
                    }
                    continue block69;
                }
                case "1040_S": {
                    DynamicObject job;
                    for (Long l : fileIds) {
                        job = (DynamicObject)fileIdToJobMap.get(l);
                        if (job == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("id"));
                    }
                    continue block69;
                }
                case "1070_S": {
                    DynamicObject depemp;
                    for (Long l : fileIds) {
                        depemp = (DynamicObject)fileIdToDepempMap.get(l);
                        if (depemp == null || depemp.getLong("adminorg.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), depemp.getLong("adminorg.id"));
                    }
                    continue block69;
                }
                case "1050_S": {
                    DynamicObject empjobrel;
                    this.tryLoadEmpjobrel(fileMap, employeeIds, fileIdToEmpjobrelMap);
                    for (Long l : fileIds) {
                        empjobrel = (DynamicObject)fileIdToEmpjobrelMap.get(l);
                        if (empjobrel == null || empjobrel.getLong("joblevel.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empjobrel.getLong("joblevel.id"));
                    }
                    continue block69;
                }
                case "1060_S": {
                    DynamicObject empjobrel;
                    this.tryLoadEmpjobrel(fileMap, employeeIds, fileIdToEmpjobrelMap);
                    for (Long l : fileIds) {
                        empjobrel = (DynamicObject)fileIdToEmpjobrelMap.get(l);
                        if (empjobrel == null || empjobrel.getLong("jobgrade.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empjobrel.getLong("jobgrade.id"));
                    }
                    continue block69;
                }
                case "1080_S": {
                    DynamicObject depemp;
                    for (Long l : fileIds) {
                        depemp = (DynamicObject)fileIdToDepempMap.get(l);
                        if (depemp == null || depemp.getLong("orgteam.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), depemp.getLong("orgteam.id"));
                    }
                    continue block69;
                }
                case "1100_S": {
                    HashMap fileIdToAdminorgcompanyMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
                    this.tryGetAdminOrgCompany(fileIdToEmpposorgrelMap, companyAdminOrgIds, fileIdToAdminorgcompanyMap);
                    for (Long fileId2 : fileIds) {
                        DynamicObject dynamicObject = (DynamicObject)fileIdToAdminorgcompanyMap.get(fileId2);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(fileId2)).putIfAbsent(cfg.getId(), dynamicObject.getLong("industrytype.id"));
                    }
                    continue block69;
                }
                case "1110_S": {
                    HashMap hashMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
                    this.tryGetAdminOrgDepartment(fileIdToDepempMap, departmentAdminOrgIds, hashMap);
                    for (Long l : fileIds) {
                        DynamicObject adminorgdepartmentObj = (DynamicObject)hashMap.get(l);
                        if (adminorgdepartmentObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), adminorgdepartmentObj.getLong("departmenttype.id"));
                    }
                    continue block69;
                }
                case "1120_S": {
                    this.tryGetDepartment(fileIdToDepempMap, departmentAdminOrgIds, fileIdToDepartmentMap);
                    for (Long l : fileIds) {
                        DynamicObject departmentObj = (DynamicObject)fileIdToDepartmentMap.get(l);
                        if (departmentObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), departmentObj.getLong("city.id"));
                    }
                    continue block69;
                }
                case "1130_S": {
                    DynamicObject empposorgrelObj;
                    for (Long l : fileIds) {
                        empposorgrelObj = (DynamicObject)fileIdToEmpposorgrelMap.get(l);
                        if (empposorgrelObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empposorgrelObj.getLong("position.id"));
                    }
                    continue block69;
                }
                case "1135_S": {
                    DynamicObject empposorgrelObj;
                    for (Long l : fileIds) {
                        empposorgrelObj = (DynamicObject)fileIdToEmpposorgrelMap.get(l);
                        if (empposorgrelObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empposorgrelObj.getLong("stdposition.id"));
                    }
                    continue block69;
                }
                case "1140_S": {
                    DynamicObject empentrelObj;
                    this.tryGetEmpentrel(fileMap, employeeIds, fileIdToEmpentrelMap);
                    for (Long l : fileIds) {
                        empentrelObj = (DynamicObject)fileIdToEmpentrelMap.get(l);
                        if (empentrelObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empentrelObj.getLong("laborreltype.id"));
                    }
                    continue block69;
                }
                case "1150_S": {
                    DynamicObject empentrelObj;
                    this.tryGetEmpentrel(fileMap, employeeIds, fileIdToEmpentrelMap);
                    for (Long l : fileIds) {
                        empentrelObj = (DynamicObject)fileIdToEmpentrelMap.get(l);
                        if (empentrelObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empentrelObj.getLong("laborrelstatus.id"));
                    }
                    continue block69;
                }
                case "1160_S": {
                    this.tryGetPernontsprop(fileMap, personIds, fileIdToPernontspropMap);
                    for (Long l : fileIds) {
                        DynamicObject pernontspropObj = (DynamicObject)fileIdToPernontspropMap.get(l);
                        if (pernontspropObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), pernontspropObj.getLong("nationality.id"));
                    }
                    continue block69;
                }
                case "1170_S": {
                    this.tryGetPerregion(fileMap, personIds, fileIdToPerregionMap);
                    for (Long l : fileIds) {
                        DynamicObject perregionObj = (DynamicObject)fileIdToPerregionMap.get(l);
                        if (perregionObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perregionObj.getLong("religion.id"));
                    }
                    continue block69;
                }
                case "1180_S": {
                    this.tryGetPereduexp(fileMap, personIds, fileIdToPereduexpMap);
                    for (Long l : fileIds) {
                        DynamicObject pereduexpObj = (DynamicObject)fileIdToPereduexpMap.get(l);
                        if (pereduexpObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), pereduexpObj.getLong("education.id"));
                    }
                    continue block69;
                }
                case "1190_S": {
                    this.tryGetPereduexp(fileMap, personIds, fileIdToPereduexpMap);
                    this.tryGetCollege(fileIdToPereduexpMap, fileIdToCollegeMap);
                    for (Long l : fileIds) {
                        DynamicObjectCollection collection;
                        DynamicObject collegeObj = (DynamicObject)fileIdToCollegeMap.get(l);
                        if (collegeObj == null || (collection = collegeObj.getDynamicObjectCollection("collegecharact")) == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), collection.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList()));
                    }
                    continue block69;
                }
                case "1200_S": {
                    DynamicObject perocpqualObj;
                    this.tryGetPerocpqual(fileMap, personIds, fileIdToPerocpqualMap);
                    for (Long l : fileIds) {
                        perocpqualObj = (DynamicObject)fileIdToPerocpqualMap.get(l);
                        if (perocpqualObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perocpqualObj.getLong("qualification.id"));
                    }
                    continue block69;
                }
                case "1210_S": {
                    DynamicObject perocpqualObj;
                    this.tryGetPerocpqual(fileMap, personIds, fileIdToPerocpqualMap);
                    for (Long l : fileIds) {
                        perocpqualObj = (DynamicObject)fileIdToPerocpqualMap.get(l);
                        if (perocpqualObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perocpqualObj.getLong("qualevel.id"));
                    }
                    continue block69;
                }
                case "1220_S": {
                    DynamicObject perpractqualObj;
                    this.tryGetPerpractqual(fileMap, personIds, fileIdToPerpractqualMap);
                    for (Long l : fileIds) {
                        perpractqualObj = (DynamicObject)fileIdToPerpractqualMap.get(l);
                        if (perpractqualObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perpractqualObj.getLong("qualification.id"));
                    }
                    continue block69;
                }
                case "1230_S": {
                    DynamicObject perpractqualObj;
                    this.tryGetPerpractqual(fileMap, personIds, fileIdToPerpractqualMap);
                    for (Long l : fileIds) {
                        perpractqualObj = (DynamicObject)fileIdToPerpractqualMap.get(l);
                        if (perpractqualObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perpractqualObj.getLong("qualevel.id"));
                    }
                    continue block69;
                }
                case "1240_S": {
                    DynamicObject perprotitleObj;
                    this.tryGetPerprotitle(fileMap, personIds, fileIdToPerprotitleMap);
                    for (Long l : fileIds) {
                        perprotitleObj = (DynamicObject)fileIdToPerprotitleMap.get(l);
                        if (perprotitleObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perprotitleObj.getLong("professional.id"));
                    }
                    continue block69;
                }
                case "1250_S": {
                    DynamicObject perprotitleObj;
                    this.tryGetPerprotitle(fileMap, personIds, fileIdToPerprotitleMap);
                    for (Long l : fileIds) {
                        perprotitleObj = (DynamicObject)fileIdToPerprotitleMap.get(l);
                        if (perprotitleObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), perprotitleObj.getLong("prolevel.id"));
                    }
                    continue block69;
                }
                case "1260_S": {
                    this.tryGetPerprotitle(fileMap, personIds, fileIdToPerprotitleMap);
                    this.tryGetProtitletype(fileIdToPerprotitleMap, fileIdToProtitletypeMap);
                    for (Long l : fileIds) {
                        DynamicObject protitletypObj = (DynamicObject)fileIdToProtitletypeMap.get(l);
                        if (protitletypObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), protitletypObj.getLong("protitletype.id"));
                    }
                    continue block69;
                }
                case "1270_S": {
                    DynamicObject empposorgrelObj;
                    for (Long l : fileIds) {
                        empposorgrelObj = (DynamicObject)fileIdToEmpposorgrelMap.get(l);
                        if (empposorgrelObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empposorgrelObj.getLong("postype.id"));
                    }
                    continue block69;
                }
                case "1280_S": {
                    for (Map.Entry entry : fileMap.entrySet()) {
                        ((Map)resultMap.get(entry.getKey())).putIfAbsent(cfg.getId(), ((DynamicObject)entry.getValue()).getLong("depcytype.id"));
                    }
                    continue block69;
                }
                case "1290_S": {
                    for (Map.Entry entry : fileMap.entrySet()) {
                        ((Map)resultMap.get(entry.getKey())).putIfAbsent(cfg.getId(), ((DynamicObject)entry.getValue()).getLong("country.id"));
                    }
                    continue block69;
                }
                case "1300_S": {
                    this.tryGetWorkplace(fileIdToEmpposorgrelMap, fileIdToWorkplaceMap);
                    for (Long l : fileIds) {
                        DynamicObject workplaceIObj = (DynamicObject)fileIdToWorkplaceMap.get(l);
                        if (workplaceIObj == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), workplaceIObj.getLong("city.id"));
                    }
                    continue block69;
                }
            }
        }
        if (isVersion) {
            return ContrastDataHelper.convertToVersion(propCfg, resultMap);
        }
        return resultMap;
    }

    private void tryGetWorkplace(Map<Long, DynamicObject> fileIdToEmpposorgrelMap, Map<Long, DynamicObject> fileIdToWorkplaceMap) {
        if (fileIdToWorkplaceMap.isEmpty()) {
            Set workplaceIds = fileIdToEmpposorgrelMap.values().stream().map(object -> object.getLong("workplace.id")).collect(Collectors.toSet());
            DynamicObject[] workplaceObjArr = new SWCDataServiceHelper("hbss_workplace").query("id,city", new QFilter[]{new QFilter("id", "in", workplaceIds)});
            Map workplaceMap = Arrays.stream(workplaceObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileIdToEmpposorgrelMap.entrySet()) {
                long workplaceId = entry.getValue().getLong("workplace.id");
                DynamicObject workplaceObj = (DynamicObject)workplaceMap.get(workplaceId);
                if (workplaceObj == null) continue;
                fileIdToWorkplaceMap.putIfAbsent(entry.getKey(), workplaceObj);
            }
        }
    }

    private void tryGetProtitletype(Map<Long, DynamicObject> fileIdToPerprotitleMap, Map<Long, DynamicObject> fileIdToProtitletypeMap) {
        if (fileIdToProtitletypeMap.isEmpty()) {
            Set protitleIds = fileIdToPerprotitleMap.values().stream().map(object -> object.getLong("professional.id")).collect(Collectors.toSet());
            DynamicObject[] protitleObjArr = new SWCDataServiceHelper("hbss_protitle").query("id,protitletype", new QFilter[]{new QFilter("id", "in", protitleIds)});
            Map protitleMap = Arrays.stream(protitleObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileIdToPerprotitleMap.entrySet()) {
                long protitleId = entry.getValue().getLong("professional.id");
                DynamicObject protitleObj = (DynamicObject)protitleMap.get(protitleId);
                if (protitleObj == null) continue;
                fileIdToProtitletypeMap.putIfAbsent(entry.getKey(), protitleObj);
            }
        }
    }

    private void tryGetPerprotitle(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPerprotitleMap) {
        if (fileIdToPerprotitleMap.isEmpty()) {
            DynamicObject[] perprotitleObjArr = new SWCDataServiceHelper("hrpi_perprotitle").query("id,professional,prolevel,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds), new QFilter("ishigh", "=", (Object)Boolean.TRUE)});
            Map perprotitleMap = Arrays.stream(perprotitleObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long personId = entry.getValue().getLong("person.id");
                DynamicObject perprotitleObj = (DynamicObject)perprotitleMap.get(personId);
                if (perprotitleObj == null) continue;
                fileIdToPerprotitleMap.putIfAbsent(entry.getKey(), perprotitleObj);
            }
        }
    }

    private void tryGetPerpractqual(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPerpractqualMap) {
        if (fileIdToPerpractqualMap.isEmpty()) {
            DynamicObject[] PerpractqualObjArr = new SWCDataServiceHelper("hrpi_perpractqual").query("id,qualevel,qualification,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map perpractqualMap = Arrays.stream(PerpractqualObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long personId = entry.getValue().getLong("person.id");
                DynamicObject perpractqualObject = (DynamicObject)perpractqualMap.get(personId);
                if (perpractqualObject == null) continue;
                fileIdToPerpractqualMap.putIfAbsent(entry.getKey(), perpractqualObject);
            }
        }
    }

    private void tryGetPerocpqual(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPerocpqualMap) {
        if (fileIdToPerocpqualMap.isEmpty()) {
            DynamicObject[] perocpqualObjArr = new SWCDataServiceHelper("hrpi_perocpqual").query("id,qualevel,qualification,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map perocpqualMap = Arrays.stream(perocpqualObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long personId = entry.getValue().getLong("person.id");
                DynamicObject perocpqualObject = (DynamicObject)perocpqualMap.get(personId);
                if (perocpqualObject == null) continue;
                fileIdToPerocpqualMap.putIfAbsent(entry.getKey(), perocpqualObject);
            }
        }
    }

    private void tryGetCollege(Map<Long, DynamicObject> fileIdToPereduexpMap, Map<Long, DynamicObject> fileIdToCollegeMap) {
        if (fileIdToCollegeMap.isEmpty()) {
            Set collegeIds = fileIdToPereduexpMap.values().stream().map(object -> object.getLong("graduateschool.id")).collect(Collectors.toSet());
            DynamicObject[] collegeObjArr = new SWCDataServiceHelper("hbss_college").query("id,collegecharact", new QFilter[]{new QFilter("id", "in", collegeIds)});
            Map collegeMap = Arrays.stream(collegeObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileIdToPereduexpMap.entrySet()) {
                long graduateschoolId = entry.getValue().getLong("graduateschool.id");
                DynamicObject collegeObject = (DynamicObject)collegeMap.get(graduateschoolId);
                if (collegeObject == null) continue;
                fileIdToCollegeMap.putIfAbsent(entry.getKey(), collegeObject);
            }
        }
    }

    private void tryGetPereduexp(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPereduexpMap) {
        if (fileIdToPereduexpMap.isEmpty()) {
            DynamicObject[] pereduexpObjArr = new SWCDataServiceHelper("hrpi_pereduexp").query("id,education,edunature,graduateschool,ishighestdegree,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds), new QFilter("ishighestdegree", "=", (Object)Character.valueOf('1'))});
            Map pereduexpMap = Arrays.stream(pereduexpObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long personId = entry.getValue().getLong("person.id");
                DynamicObject pereduexp = (DynamicObject)pereduexpMap.get(personId);
                if (pereduexp == null) continue;
                fileIdToPereduexpMap.putIfAbsent(entry.getKey(), pereduexp);
            }
        }
    }

    private void tryGetPerregion(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPerregionMap) {
        if (fileIdToPerregionMap.isEmpty()) {
            DynamicObject[] perregionObjArr = new SWCDataServiceHelper("hrpi_perregion").query("id,religion,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map perregionMap = Arrays.stream(perregionObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long personId = entry.getValue().getLong("person.id");
                DynamicObject perregion = (DynamicObject)perregionMap.get(personId);
                if (perregion == null) continue;
                fileIdToPerregionMap.putIfAbsent(entry.getKey(), perregion);
            }
        }
    }

    private void tryGetPernontsprop(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPernontspropMap) {
        if (fileIdToPernontspropMap.isEmpty()) {
            DynamicObject[] pernontspropObjArr = new SWCDataServiceHelper("hrpi_pernontsprop").query("id,nationality,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map pernontspropMap = Arrays.stream(pernontspropObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long personId = entry.getValue().getLong("person.id");
                DynamicObject pernontsprop = (DynamicObject)pernontspropMap.get(personId);
                if (pernontsprop == null) continue;
                fileIdToPernontspropMap.putIfAbsent(entry.getKey(), pernontsprop);
            }
        }
    }

    private void tryGetEmpentrel(Map<Long, DynamicObject> fileMap, Set<Long> employeeIds, Map<Long, DynamicObject> fileIdToEmpentrelMap) {
        if (fileIdToEmpentrelMap.isEmpty()) {
            DynamicObject[] empentrelObjArr = new SWCDataServiceHelper("hrpi_empentrel").query("id,laborreltype,laborrelstatus,employee", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("employee.id", "in", employeeIds)});
            Map empentrelMap = Arrays.stream(empentrelObjArr).collect(Collectors.toMap(object -> object.getLong("employee.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                long employeeId = entry.getValue().getLong("employee.id");
                DynamicObject empentrel = (DynamicObject)empentrelMap.get(employeeId);
                if (empentrel == null) continue;
                fileIdToEmpentrelMap.putIfAbsent(entry.getKey(), empentrel);
            }
        }
    }

    private void tryGetDepartment(Map<Long, DynamicObject> fileIdToDepempMap, Set<Long> departmentAdminOrgIds, Map<Long, DynamicObject> fileIdToDepartmentMap) {
        if (fileIdToDepartmentMap.isEmpty()) {
            DynamicObject[] departmentObjArr = new SWCDataServiceHelper("haos_adminorghr").query("id,name,number,city", new QFilter[]{new QFilter("id", "in", departmentAdminOrgIds)});
            Map departmentMap = Arrays.stream(departmentObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileIdToDepempMap.entrySet()) {
                DynamicObject dynamicObject;
                long adminorgId = entry.getValue().getLong("adminorg.id");
                if (adminorgId <= 0L || (dynamicObject = (DynamicObject)departmentMap.get(adminorgId)) == null) continue;
                fileIdToDepartmentMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetAdminOrgDepartment(Map<Long, DynamicObject> fileIdToDepempMap, Set<Long> departmentAdminOrgIds, Map<Long, DynamicObject> fileIdToAdminorgdepartmentMap) {
        DynamicObject[] adminorgdepartmentObjArr = new SWCDataServiceHelper("haos_adminorgdepartment").query("id,adminorg,departmenttype", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("adminorg.id", "in", departmentAdminOrgIds)});
        Map adminorgdepartmentMap = Arrays.stream(adminorgdepartmentObjArr).collect(Collectors.toMap(object -> object.getLong("adminorg.id"), Function.identity(), (o1, o2) -> o2));
        for (Map.Entry<Long, DynamicObject> entry : fileIdToDepempMap.entrySet()) {
            DynamicObject dynamicObject;
            long departmentAdminOrgId = entry.getValue().getLong("adminorg.id");
            if (departmentAdminOrgId <= 0L || (dynamicObject = (DynamicObject)adminorgdepartmentMap.get(departmentAdminOrgId)) == null) continue;
            fileIdToAdminorgdepartmentMap.put(entry.getKey(), dynamicObject);
        }
    }

    private void tryGetAdminOrgCompany(Map<Long, DynamicObject> fileIdToEmpposorgrelMap, Set<Long> adminOrgIds, Map<Long, DynamicObject> fileIdToAdminorgcompanyMap) {
        DynamicObject[] adminorgcompanyObjArr = new SWCDataServiceHelper("haos_adminorgcompany").query("id,industrytype,adminorg", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("adminorg.id", "in", adminOrgIds)});
        Map adminorgcompanyMap = Arrays.stream(adminorgcompanyObjArr).collect(Collectors.toMap(object -> object.getLong("adminorg.id"), Function.identity(), (o1, o2) -> o2));
        for (Map.Entry<Long, DynamicObject> entry : fileIdToEmpposorgrelMap.entrySet()) {
            DynamicObject dynamicObject;
            long companyAdminOrgId = entry.getValue().getLong("company.id");
            if (companyAdminOrgId <= 0L || (dynamicObject = (DynamicObject)adminorgcompanyMap.get(companyAdminOrgId)) == null) continue;
            fileIdToAdminorgcompanyMap.put(entry.getKey(), dynamicObject);
        }
    }

    private void tryLoadEmpjobrel(Map<Long, DynamicObject> fileMap, Set<Long> employeeIds, Map<Long, DynamicObject> fileIdToEmpjobrelMap) {
        if (fileIdToEmpjobrelMap.isEmpty()) {
            DynamicObject[] empjobrelObjArr = new SWCDataServiceHelper("hrpi_empjobrel").query("id,joblevel,jobgrade,employee", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("employee.id", "in", employeeIds), new QFilter("businessstatus", "=", (Object)"1")});
            Map empjobrelMap = Arrays.stream(empjobrelObjArr).collect(Collectors.toMap(object -> object.getLong("employee.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                DynamicObject dynamicObject;
                long employeeId = entry.getValue().getLong("employee.id");
                if (employeeId <= 0L || (dynamicObject = (DynamicObject)empjobrelMap.get(employeeId)) == null) continue;
                fileIdToEmpjobrelMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }
}

