/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.matchprop;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.IHcdmContrastPropExtPlugin;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.ContrastPropLoadEvent;
import kd.sdk.swc.hcdm.business.extpoint.salarystd.event.OnGetCustomerQFilterEvent;
import kd.sdk.swc.hcdm.common.adj.PersonQueryParam;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class HcdmContrastPropPluginByDepEmp
implements IHcdmContrastPropExtPlugin {
    public void loadContrastPropValue(ContrastPropLoadEvent event) {
        String personType;
        List personQueryParams = event.getPersonQueryParams();
        if (!CollectionUtils.isEmpty((Collection)personQueryParams) && StringUtils.equals((CharSequence)(personType = ((PersonQueryParam)personQueryParams.get(0)).getPersonType()), (CharSequence)"2")) {
            List<Long> depempIds = event.getPersonQueryParams().stream().map(PersonQueryParam::getDepEmpId).collect(Collectors.toList());
            Map<Long, Map<Long, Object>> result = this.getContrastPropValue(event.getPropCfgList(), depempIds, event.isVersion());
            event.setPropValues(result);
        }
    }

    public void onGetCustomerQFilter(OnGetCustomerQFilterEvent onGetCustomerQFilterEvent) {
    }

    private Map<Long, Map<Long, Object>> getContrastPropValue(List<ContrastPropConfigEntity> propCfg, List<Long> depEmpIdsParam, boolean isVersion) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        depEmpIdsParam.forEach(aLong -> resultMap.computeIfAbsent(aLong, v1 -> Maps.newHashMap()));
        HashSet depempIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet employeeIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet empposorgrelIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet jobIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet stdPositionIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet companyAdminOrgIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashSet departmentAdminOrgIds = Sets.newHashSetWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToJobMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPositionMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToStdPositionMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map<Long, DynamicObject> depempIdToEmpPosOrgRelMap = adjFileApplicationService.queryLatestEmpPosOrgRelByDepEmpId(Sets.newHashSet(depEmpIdsParam));
        for (Map.Entry<Long, DynamicObject> entry : depempIdToEmpPosOrgRelMap.entrySet()) {
            DynamicObject empPosOrgRelObj = entry.getValue();
            depempIds.add(entry.getKey());
            personIds.add(empPosOrgRelObj.getLong("person.id"));
            employeeIds.add(empPosOrgRelObj.getLong("employee.id"));
            empposorgrelIds.add(empPosOrgRelObj.getLong("id"));
        }
        Map<Long, DynamicObject> depEmpIdToAdjFileMap = adjFileApplicationService.queryLatestFileByDepempId("id,depemp,depcytype,country", depempIds);
        SWCDataServiceHelper depempService = new SWCDataServiceHelper("hrpi_depemp");
        DynamicObject[] depempObjArr = depempService.query("id,employee,otclassify,orgteam,adminorg,person", new QFilter[]{new QFilter("id", "in", (Object)depempIds)});
        Map<Long, DynamicObject> depempMap = Arrays.stream(depempObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        for (Long depEmpId : depempIds) {
            DynamicObject empPosOrgRelObj = depempIdToEmpPosOrgRelMap.get(depEmpId);
            if (empPosOrgRelObj == null) continue;
            jobIds.add(empPosOrgRelObj.getLong("job.id"));
            positionIds.add(empPosOrgRelObj.getLong("position.id"));
            stdPositionIds.add(empPosOrgRelObj.getLong("stdposition.id"));
        }
        SWCDataServiceHelper jobService = new SWCDataServiceHelper("hbjm_jobhr");
        DynamicObject[] jobObjArr = jobService.query("id,number,name,jobscm,jobseq,jobfamily,jobclass", new QFilter[]{new QFilter("id", "in", (Object)jobIds)});
        Map jobMap = Arrays.stream(jobObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        SWCDataServiceHelper positionService = new SWCDataServiceHelper("hbpm_positionhr");
        DynamicObject[] positionObjArr = positionService.query("id,number,name,jobscm", new QFilter[]{new QFilter("id", "in", (Object)positionIds)});
        Map positionMap = Arrays.stream(positionObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        SWCDataServiceHelper stpositionService = new SWCDataServiceHelper("hbpm_stposition");
        DynamicObject[] stpositionObjArr = stpositionService.query("id,number,name,jobscm", new QFilter[]{new QFilter("id", "in", (Object)stdPositionIds)});
        Map stpositionMap = Arrays.stream(stpositionObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        for (Long depEmpId : depEmpIdsParam) {
            DynamicObject dynamicObject;
            DynamicObject empPosOrgRelObj = depempIdToEmpPosOrgRelMap.get(depEmpId);
            DynamicObject depempObj = (DynamicObject)depempMap.get(depEmpId);
            if (depempObj != null) {
                departmentAdminOrgIds.add(depempObj.getLong("adminorg.id"));
            }
            if (empPosOrgRelObj == null) continue;
            companyAdminOrgIds.add(empPosOrgRelObj.getLong("company.id"));
            long jobId = empPosOrgRelObj.getLong("job.id");
            long positionId = empPosOrgRelObj.getLong("position.id");
            long stdpositionId = empPosOrgRelObj.getLong("stdposition.id");
            if (jobId > 0L && (dynamicObject = (DynamicObject)jobMap.get(jobId)) != null) {
                depempIdToJobMap.putIfAbsent(depEmpId, dynamicObject);
            }
            if (positionId > 0L && (dynamicObject = (DynamicObject)positionMap.get(positionId)) != null) {
                depempIdToPositionMap.putIfAbsent(depEmpId, dynamicObject);
            }
            if (stdpositionId <= 0L || (dynamicObject = (DynamicObject)stpositionMap.get(stdpositionId)) == null) continue;
            depempIdToStdPositionMap.putIfAbsent(depEmpId, dynamicObject);
        }
        HashMap depempIdToEmpjobrelMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToDepartmentMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToEmpentrelMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPernontspropMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPerregionMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPereduexpMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToCollegeMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPerocpqualMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPerpractqualMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToPerprotitleMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToProtitletypeMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        HashMap depempIdToWorkplaceMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
        block69: for (ContrastPropConfigEntity cfg : propCfg) {
            switch (cfg.getNumber()) {
                case "1000_S": {
                    DynamicObject job;
                    for (Long l : depEmpIdsParam) {
                        job = (DynamicObject)depempIdToJobMap.get(l);
                        if (job != null && job.getLong("jobscm.id") > 0L) {
                            ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobscm.id"));
                            continue;
                        }
                        DynamicObject positionObj = (DynamicObject)depempIdToPositionMap.get(l);
                        DynamicObject stdpositionObj = (DynamicObject)depempIdToStdPositionMap.get(l);
                        if (positionObj != null && positionObj.getLong("jobscm.id") > 0L) {
                            ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), positionObj.getLong("jobscm.id"));
                            continue;
                        }
                        if (stdpositionObj == null || stdpositionObj.getLong("jobscm.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), stdpositionObj.getLong("jobscm.id"));
                    }
                    continue block69;
                }
                case "1010_S": {
                    DynamicObject job;
                    for (Long l : depEmpIdsParam) {
                        job = (DynamicObject)depempIdToJobMap.get(l);
                        if (job == null || job.getLong("jobseq.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobseq.id"));
                    }
                    continue block69;
                }
                case "1020_S": {
                    DynamicObject job;
                    for (Long l : depEmpIdsParam) {
                        job = (DynamicObject)depempIdToJobMap.get(l);
                        if (job == null || job.getLong("jobfamily.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobfamily.id"));
                    }
                    continue block69;
                }
                case "1030_S": {
                    DynamicObject job;
                    for (Long l : depEmpIdsParam) {
                        job = (DynamicObject)depempIdToJobMap.get(l);
                        if (job == null || job.getLong("jobclass.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("jobclass.id"));
                    }
                    continue block69;
                }
                case "1040_S": {
                    DynamicObject job;
                    for (Long l : depEmpIdsParam) {
                        job = (DynamicObject)depempIdToJobMap.get(l);
                        if (job == null) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), job.getLong("id"));
                    }
                    continue block69;
                }
                case "1070_S": {
                    DynamicObject depemp;
                    for (Long l : depEmpIdsParam) {
                        depemp = depempMap.get(l);
                        if (depemp == null || depemp.getLong("adminorg.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), depemp.getLong("adminorg.id"));
                    }
                    continue block69;
                }
                case "1050_S": {
                    DynamicObject empjobrel;
                    this.tryLoadEmpjobrel(depempMap, employeeIds, depempIdToEmpjobrelMap);
                    for (Long l : depEmpIdsParam) {
                        empjobrel = (DynamicObject)depempIdToEmpjobrelMap.get(l);
                        if (empjobrel == null || empjobrel.getLong("joblevel.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empjobrel.getLong("joblevel.id"));
                    }
                    continue block69;
                }
                case "1060_S": {
                    DynamicObject empjobrel;
                    this.tryLoadEmpjobrel(depempMap, employeeIds, depempIdToEmpjobrelMap);
                    for (Long l : depEmpIdsParam) {
                        empjobrel = (DynamicObject)depempIdToEmpjobrelMap.get(l);
                        if (empjobrel == null || empjobrel.getLong("jobgrade.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), empjobrel.getLong("jobgrade.id"));
                    }
                    continue block69;
                }
                case "1080_S": {
                    DynamicObject depemp;
                    for (Long l : depEmpIdsParam) {
                        depemp = depempMap.get(l);
                        if (depemp == null || depemp.getLong("orgteam.id") <= 0L) continue;
                        ((Map)resultMap.get(l)).putIfAbsent(cfg.getId(), depemp.getLong("orgteam.id"));
                    }
                    continue block69;
                }
                case "1100_S": {
                    HashMap depempIdToAdminorgcompanyMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
                    this.tryGetAdminOrgCompany(depempIdToEmpPosOrgRelMap, companyAdminOrgIds, depempIdToAdminorgcompanyMap);
                    for (Long depempId2 : depEmpIdsParam) {
                        DynamicObject dynamicObject = (DynamicObject)depempIdToAdminorgcompanyMap.get(depempId2);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId2)).putIfAbsent(cfg.getId(), dynamicObject.getLong("industrytype.id"));
                    }
                    continue block69;
                }
                case "1110_S": {
                    DynamicObject dynamicObject;
                    HashMap hashMap = Maps.newHashMapWithExpectedSize((int)depEmpIdsParam.size());
                    this.tryGetAdminOrgDepartment(depempMap, departmentAdminOrgIds, hashMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)hashMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("departmenttype.id"));
                    }
                    continue block69;
                }
                case "1120_S": {
                    DynamicObject dynamicObject;
                    this.tryGetDepartment(depempMap, departmentAdminOrgIds, depempIdToDepartmentMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToDepartmentMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("city.id"));
                    }
                    continue block69;
                }
                case "1130_S": {
                    DynamicObject dynamicObject;
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = depempIdToEmpPosOrgRelMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("position.id"));
                    }
                    continue block69;
                }
                case "1135_S": {
                    DynamicObject dynamicObject;
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = depempIdToEmpPosOrgRelMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("stdposition.id"));
                    }
                    continue block69;
                }
                case "1140_S": {
                    DynamicObject dynamicObject;
                    this.tryGetEmpentrel(depempMap, employeeIds, depempIdToEmpentrelMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToEmpentrelMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("laborreltype.id"));
                    }
                    continue block69;
                }
                case "1150_S": {
                    DynamicObject dynamicObject;
                    this.tryGetEmpentrel(depempMap, employeeIds, depempIdToEmpentrelMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToEmpentrelMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("laborrelstatus.id"));
                    }
                    continue block69;
                }
                case "1160_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPernontsprop(depempMap, personIds, depempIdToPernontspropMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPernontspropMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("nationality.id"));
                    }
                    continue block69;
                }
                case "1170_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerregion(depempMap, personIds, depempIdToPerregionMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerregionMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("religion.id"));
                    }
                    continue block69;
                }
                case "1180_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPereduexp(depempMap, personIds, depempIdToPereduexpMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPereduexpMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("education.id"));
                    }
                    continue block69;
                }
                case "1190_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPereduexp(depempMap, personIds, depempIdToPereduexpMap);
                    this.tryGetCollege(depempIdToPereduexpMap, depempIdToCollegeMap);
                    for (Long depempId : depEmpIdsParam) {
                        DynamicObjectCollection collection;
                        dynamicObject = (DynamicObject)depempIdToCollegeMap.get(depempId);
                        if (dynamicObject == null || (collection = dynamicObject.getDynamicObjectCollection("collegecharact")) == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), collection.stream().map(object -> object.getLong("fbasedataid_id")).collect(Collectors.toList()));
                    }
                    continue block69;
                }
                case "1200_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerocpqual(depempMap, personIds, depempIdToPerocpqualMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerocpqualMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("qualification.id"));
                    }
                    continue block69;
                }
                case "1210_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerocpqual(depempMap, personIds, depempIdToPerocpqualMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerocpqualMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("qualevel.id"));
                    }
                    continue block69;
                }
                case "1220_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerpractqual(depempMap, personIds, depempIdToPerpractqualMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerpractqualMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("qualification.id"));
                    }
                    continue block69;
                }
                case "1230_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerpractqual(depempMap, personIds, depempIdToPerpractqualMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerpractqualMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("qualevel.id"));
                    }
                    continue block69;
                }
                case "1240_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerprotitle(depempMap, personIds, depempIdToPerprotitleMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerprotitleMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("professional.id"));
                    }
                    continue block69;
                }
                case "1250_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerprotitle(depempMap, personIds, depempIdToPerprotitleMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToPerprotitleMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("prolevel.id"));
                    }
                    continue block69;
                }
                case "1260_S": {
                    DynamicObject dynamicObject;
                    this.tryGetPerprotitle(depempMap, personIds, depempIdToPerprotitleMap);
                    this.tryGetProtitletype(depempIdToPerprotitleMap, depempIdToProtitletypeMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToProtitletypeMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("protitletype.id"));
                    }
                    continue block69;
                }
                case "1270_S": {
                    DynamicObject dynamicObject;
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = depempIdToEmpPosOrgRelMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("postype.id"));
                    }
                    continue block69;
                }
                case "1280_S": {
                    DynamicObject adjFileObj;
                    for (Long depempId : depEmpIdsParam) {
                        adjFileObj = depEmpIdToAdjFileMap.get(depempId);
                        if (adjFileObj == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), adjFileObj.getLong("depcytype.id"));
                    }
                    continue block69;
                }
                case "1290_S": {
                    DynamicObject adjFileObj;
                    for (Long depempId : depEmpIdsParam) {
                        adjFileObj = depEmpIdToAdjFileMap.get(depempId);
                        if (adjFileObj == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), adjFileObj.getLong("country.id"));
                    }
                    continue block69;
                }
                case "1300_S": {
                    DynamicObject dynamicObject;
                    this.tryGetWorkplace(depempIdToEmpPosOrgRelMap, depempIdToWorkplaceMap);
                    for (Long depempId : depEmpIdsParam) {
                        dynamicObject = (DynamicObject)depempIdToWorkplaceMap.get(depempId);
                        if (dynamicObject == null) continue;
                        ((Map)resultMap.get(depempId)).putIfAbsent(cfg.getId(), dynamicObject.getLong("city.id"));
                    }
                    continue block69;
                }
            }
        }
        if (isVersion) {
            return ContrastDataHelper.convertToVersion(propCfg, resultMap);
        }
        return resultMap;
    }

    private void tryGetWorkplace(Map<Long, DynamicObject> depempIdToEmpPosOrgRelMap, Map<Long, DynamicObject> depempIdToWorkplaceMap) {
        if (depempIdToWorkplaceMap.isEmpty()) {
            Set workplaceIds = depempIdToEmpPosOrgRelMap.values().stream().map(object -> object.getLong("workplace.id")).collect(Collectors.toSet());
            DynamicObject[] workplaceObjArr = new SWCDataServiceHelper("hbss_workplace").query("id,city", new QFilter[]{new QFilter("id", "in", workplaceIds)});
            Map workplaceMap = Arrays.stream(workplaceObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempIdToEmpPosOrgRelMap.entrySet()) {
                DynamicObject dynamicObject;
                long workplaceId = entry.getValue().getLong("workplace.id");
                if (workplaceId <= 0L || (dynamicObject = (DynamicObject)workplaceMap.get(workplaceId)) == null) continue;
                depempIdToWorkplaceMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetProtitletype(Map<Long, DynamicObject> fileIdToPerprotitleMap, Map<Long, DynamicObject> fileIdToProtitletypeMap) {
        if (fileIdToProtitletypeMap.isEmpty()) {
            Set protitleIds = fileIdToPerprotitleMap.values().stream().map(object -> object.getLong("professional.id")).collect(Collectors.toSet());
            DynamicObject[] protitleObjArr = new SWCDataServiceHelper("hbss_protitle").query("id,protitletype", new QFilter[]{new QFilter("id", "in", protitleIds)});
            Map protitleMap = Arrays.stream(protitleObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileIdToPerprotitleMap.entrySet()) {
                DynamicObject dynamicObject;
                long protitleId = entry.getValue().getLong("professional.id");
                if (protitleId <= 0L || (dynamicObject = (DynamicObject)protitleMap.get(protitleId)) == null) continue;
                fileIdToProtitletypeMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetPerprotitle(Map<Long, DynamicObject> depempMap, Set<Long> personIds, Map<Long, DynamicObject> depempIdToPerprotitleMap) {
        if (depempIdToPerprotitleMap.isEmpty()) {
            DynamicObject[] perprotitleObjArr = new SWCDataServiceHelper("hrpi_perprotitle").query("id,professional,prolevel,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds), new QFilter("ishigh", "=", (Object)Boolean.TRUE)});
            Map perprotitleMap = Arrays.stream(perprotitleObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long personId = entry.getValue().getLong("person.id");
                if (personId <= 0L || (dynamicObject = (DynamicObject)perprotitleMap.get(personId)) == null) continue;
                depempIdToPerprotitleMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetPerpractqual(Map<Long, DynamicObject> depempMap, Set<Long> personIds, Map<Long, DynamicObject> depempIdToPerpractqualMap) {
        if (depempIdToPerpractqualMap.isEmpty()) {
            DynamicObject[] PerpractqualObjArr = new SWCDataServiceHelper("hrpi_perpractqual").query("id,qualevel,qualification,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map perpractqualMap = Arrays.stream(PerpractqualObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long personId = entry.getValue().getLong("person.id");
                if (personId <= 0L || (dynamicObject = (DynamicObject)perpractqualMap.get(personId)) == null) continue;
                depempIdToPerpractqualMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetPerocpqual(Map<Long, DynamicObject> fileMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPerocpqualMap) {
        if (fileIdToPerocpqualMap.isEmpty()) {
            DynamicObject[] perocpqualObjArr = new SWCDataServiceHelper("hrpi_perocpqual").query("id,qualevel,qualification,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map perocpqualMap = Arrays.stream(perocpqualObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : fileMap.entrySet()) {
                DynamicObject dynamicObject;
                long personId = entry.getValue().getLong("person.id");
                if (personId <= 0L || (dynamicObject = (DynamicObject)perocpqualMap.get(personId)) == null) continue;
                fileIdToPerocpqualMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetCollege(Map<Long, DynamicObject> depempIdToPereduexpMap, Map<Long, DynamicObject> fileIdToCollegeMap) {
        if (fileIdToCollegeMap.isEmpty()) {
            Set collegeIds = depempIdToPereduexpMap.values().stream().map(object -> object.getLong("graduateschool.id")).collect(Collectors.toSet());
            DynamicObject[] collegeObjArr = new SWCDataServiceHelper("hbss_college").query("id,collegecharact", new QFilter[]{new QFilter("id", "in", collegeIds)});
            Map collegeMap = Arrays.stream(collegeObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempIdToPereduexpMap.entrySet()) {
                DynamicObject dynamicObject;
                long graduateschoolId = entry.getValue().getLong("graduateschool.id");
                if (graduateschoolId <= 0L || (dynamicObject = (DynamicObject)collegeMap.get(graduateschoolId)) == null) continue;
                fileIdToCollegeMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetPereduexp(Map<Long, DynamicObject> depempMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPereduexpMap) {
        if (fileIdToPereduexpMap.isEmpty()) {
            DynamicObject[] pereduexpObjArr = new SWCDataServiceHelper("hrpi_pereduexp").query("id,education,edunature,graduateschool,ishighestdegree,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds), new QFilter("ishighestdegree", "=", (Object)Character.valueOf('1'))});
            Map pereduexpMap = Arrays.stream(pereduexpObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long personId = entry.getValue().getLong("person.id");
                if (personId <= 0L || (dynamicObject = (DynamicObject)pereduexpMap.get(personId)) == null) continue;
                fileIdToPereduexpMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetPerregion(Map<Long, DynamicObject> depempMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPerregionMap) {
        if (fileIdToPerregionMap.isEmpty()) {
            DynamicObject[] perregionObjArr = new SWCDataServiceHelper("hrpi_perregion").query("id,religion,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map perregionMap = Arrays.stream(perregionObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long personId = entry.getValue().getLong("person.id");
                if (personId <= 0L || (dynamicObject = (DynamicObject)perregionMap.get(personId)) == null) continue;
                fileIdToPerregionMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetPernontsprop(Map<Long, DynamicObject> depempMap, Set<Long> personIds, Map<Long, DynamicObject> fileIdToPernontspropMap) {
        if (fileIdToPernontspropMap.isEmpty()) {
            DynamicObject[] pernontspropObjArr = new SWCDataServiceHelper("hrpi_pernontsprop").query("id,nationality,person", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("person.id", "in", personIds)});
            Map pernontspropMap = Arrays.stream(pernontspropObjArr).collect(Collectors.toMap(object -> object.getLong("person.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long personId = entry.getValue().getLong("person.id");
                if (personId <= 0L || (dynamicObject = (DynamicObject)pernontspropMap.get(personId)) == null) continue;
                fileIdToPernontspropMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetEmpentrel(Map<Long, DynamicObject> depempMap, Set<Long> employeeIds, Map<Long, DynamicObject> fileIdToEmpentrelMap) {
        if (fileIdToEmpentrelMap.isEmpty()) {
            DynamicObject[] empentrelObjArr = new SWCDataServiceHelper("hrpi_empentrel").query("id,laborreltype,laborrelstatus,employee", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("employee.id", "in", employeeIds)});
            Map empentrelMap = Arrays.stream(empentrelObjArr).collect(Collectors.toMap(object -> object.getLong("employee.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long employeeId = entry.getValue().getLong("employee.id");
                if (employeeId <= 0L || (dynamicObject = (DynamicObject)empentrelMap.get(employeeId)) == null) continue;
                fileIdToEmpentrelMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetDepartment(Map<Long, DynamicObject> depempMap, Set<Long> departmentAdminOrgIds, Map<Long, DynamicObject> fileIdToDepartmentMap) {
        if (fileIdToDepartmentMap.isEmpty()) {
            DynamicObject[] departmentObjArr = new SWCDataServiceHelper("haos_adminorghr").query("id,name,number,city", new QFilter[]{new QFilter("id", "in", departmentAdminOrgIds)});
            Map departmentMap = Arrays.stream(departmentObjArr).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long adminorgId = entry.getValue().getLong("adminorg.id");
                if (adminorgId <= 0L || (dynamicObject = (DynamicObject)departmentMap.get(adminorgId)) == null) continue;
                fileIdToDepartmentMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }

    private void tryGetAdminOrgDepartment(Map<Long, DynamicObject> depempMap, Set<Long> departmentAdminOrgIds, Map<Long, DynamicObject> fileIdToAdminorgdepartmentMap) {
        DynamicObject[] adminorgdepartmentObjArr = new SWCDataServiceHelper("haos_adminorgdepartment").query("id,adminorg,departmenttype", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("adminorg.id", "in", departmentAdminOrgIds)});
        Map adminorgdepartmentMap = Arrays.stream(adminorgdepartmentObjArr).collect(Collectors.toMap(object -> object.getLong("adminorg.id"), Function.identity(), (o1, o2) -> o2));
        for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
            DynamicObject dynamicObject;
            long departmentAdminOrgId = entry.getValue().getLong("adminorg.id");
            if (departmentAdminOrgId <= 0L || (dynamicObject = (DynamicObject)adminorgdepartmentMap.get(departmentAdminOrgId)) == null) continue;
            fileIdToAdminorgdepartmentMap.put(entry.getKey(), dynamicObject);
        }
    }

    private void tryGetAdminOrgCompany(Map<Long, DynamicObject> depempIdToEmpPosOrgRelMap, Set<Long> adminOrgIds, Map<Long, DynamicObject> fileIdToAdminorgcompanyMap) {
        DynamicObject[] adminorgcompanyObjArr = new SWCDataServiceHelper("haos_adminorgcompany").query("id,industrytype,adminorg", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("adminorg.id", "in", adminOrgIds)});
        Map adminorgcompanyMap = Arrays.stream(adminorgcompanyObjArr).collect(Collectors.toMap(object -> object.getLong("adminorg.id"), Function.identity(), (o1, o2) -> o2));
        for (Map.Entry<Long, DynamicObject> entry : depempIdToEmpPosOrgRelMap.entrySet()) {
            DynamicObject dynamicObject;
            long companyAdminOrgId = entry.getValue().getLong("company.id");
            if (companyAdminOrgId <= 0L || (dynamicObject = (DynamicObject)adminorgcompanyMap.get(companyAdminOrgId)) == null) continue;
            fileIdToAdminorgcompanyMap.put(entry.getKey(), dynamicObject);
        }
    }

    private void tryLoadEmpjobrel(Map<Long, DynamicObject> depempMap, Set<Long> employeeIds, Map<Long, DynamicObject> fileIdToEmpjobrelMap) {
        if (fileIdToEmpjobrelMap.isEmpty()) {
            DynamicObject[] empjobrelObjArr = new SWCDataServiceHelper("hrpi_empjobrel").query("id,joblevel,jobgrade,employee", new QFilter[]{BaseDataHisHelper.getHisCurrFilter(), new QFilter("employee.id", "in", employeeIds), new QFilter("businessstatus", "=", (Object)"1")});
            Map empjobrelMap = Arrays.stream(empjobrelObjArr).collect(Collectors.toMap(object -> object.getLong("employee.id"), Function.identity(), (o1, o2) -> o2));
            for (Map.Entry<Long, DynamicObject> entry : depempMap.entrySet()) {
                DynamicObject dynamicObject;
                long employeeId = entry.getValue().getLong("employee.id");
                if (employeeId <= 0L || (dynamicObject = (DynamicObject)empjobrelMap.get(employeeId)) == null) continue;
                fileIdToEmpjobrelMap.putIfAbsent(entry.getKey(), dynamicObject);
            }
        }
    }
}

