/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.matchprop;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.matchprop.SalaryStdMatchManager;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;

public class SalaryStdMatchContext {
    private SalaryStdMatchManager matchManager;
    private Map<Long, SalaryStandardEntryData> stdEntityMap = Maps.newHashMap();
    private Map<Long, List<ContrastPropConfigEntity>> propsGroup = Maps.newHashMap();
    private Map<Long, Map<Long, SalaryStdItemEntity>> stdItemMap = Maps.newHashMap();
    private String requestId = RequestContext.get().getRequestId();

    public SalaryStdMatchContext(SalaryStdMatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public Map<Long, SalaryStandardEntryData> getStdEntityMapFromThreadCache(Set<Long> stdTabId) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdTabId.size());
        Set<Object> notInCacheIdSet = Sets.newHashSetWithExpectedSize((int)stdTabId.size());
        if (!this.stdEntityMap.isEmpty()) {
            for (Long id : stdTabId) {
                SalaryStandardEntryData standardEntryData = this.stdEntityMap.get(id);
                if (standardEntryData != null) {
                    resultMap.put(id, standardEntryData);
                    continue;
                }
                notInCacheIdSet.add(id);
            }
        } else {
            notInCacheIdSet = stdTabId;
        }
        if (notInCacheIdSet.size() > 0) {
            Map<Long, DynamicObject> tabObjMap = this.matchManager.stdApplicationService.queryStdObj(notInCacheIdSet, "salarystddata_a");
            for (Map.Entry<Long, DynamicObject> entry : tabObjMap.entrySet()) {
                SalaryStandardEntryData tabEntity = EntityConverter.fetchEntityFromModelWithEntryName(entry.getValue(), "salarygrade", "salaryrank", "contrastps", "contrastsumdata");
                this.stdEntityMap.put(entry.getKey(), tabEntity);
                resultMap.put(entry.getKey(), tabEntity);
            }
        }
        return resultMap;
    }

    public Map<Long, List<ContrastPropConfigEntity>> getPropsGroupFromThreadCache(Set<Long> stdTabId) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdTabId.size());
        Set<Object> notInCacheIdSet = Sets.newHashSetWithExpectedSize((int)stdTabId.size());
        if (!this.propsGroup.isEmpty()) {
            for (Long id : stdTabId) {
                List<ContrastPropConfigEntity> props = this.propsGroup.get(id);
                if (!CollectionUtils.isEmpty(props)) {
                    resultMap.put(id, props);
                    continue;
                }
                notInCacheIdSet.add(id);
            }
        } else {
            notInCacheIdSet = stdTabId;
        }
        if (notInCacheIdSet.size() > 0) {
            Map<Long, List<ContrastPropConfigEntity>> props = ContrastDataHelper.queryContrastProps(notInCacheIdSet);
            this.propsGroup.putAll(props);
            resultMap.putAll(props);
        }
        return resultMap;
    }

    public Map<Long, Map<Long, SalaryStdItemEntity>> getStdItemMapFromThreadCache(Set<Long> stdTabId) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdTabId.size());
        Set<Object> notInCacheIdSet = Sets.newHashSetWithExpectedSize((int)stdTabId.size());
        if (!this.stdItemMap.isEmpty()) {
            for (Long id : stdTabId) {
                Map<Long, SalaryStdItemEntity> items = this.stdItemMap.get(id);
                if (!CollectionUtils.isEmpty(items)) {
                    resultMap.put(id, items);
                    continue;
                }
                notInCacheIdSet.add(id);
            }
        } else {
            notInCacheIdSet = stdTabId;
        }
        if (notInCacheIdSet.size() > 0) {
            Map<Long, List<SalaryStdItemEntity>> itemEntityMap = SalaryStdItemHelper.queryItemEntities(notInCacheIdSet);
            for (Map.Entry<Long, List<SalaryStdItemEntity>> entry : itemEntityMap.entrySet()) {
                Map<Long, SalaryStdItemEntity> stdItemEntityMap = SalaryStdItemHelper.groupBySalaryItemId(entry.getValue());
                this.stdItemMap.put(entry.getKey(), stdItemEntityMap);
                resultMap.put(entry.getKey(), stdItemEntityMap);
            }
        }
        return resultMap;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }
}

