/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.matchprop;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.SimpleMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SimpleStdRangeMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SimpleStdRangeMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.StdMatchParamWithDepEmp;
import kd.sdk.swc.hcdm.common.stdtab.StdSimpleMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.StdTabNotFoundType;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.matchprop.SalaryStdMatchContext;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableForCandidateParam;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.matchprop.entity.SalaryStdMatchResult;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.enums.DimensionEnum;
import kd.swc.hcdm.common.utils.GlobalParam;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryStdMatchManager {
    private final Log log = LogFactory.getLog(SalaryStdMatchManager.class);
    public SalaryStdApplicationService stdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);

    public Map<Long, Map<Long, SalaryStdMatchResultNew>> batchMatchStdTableWithAdjFile(List<MatchStdTableWithAdjFileParam> paramList) {
        long beginTime = TimeServiceHelper.now().getTime();
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyMap();
        }
        HashMap fileItemToBsedMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        HashMap fileToItemMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        Date defaultBsed = SWCDateTimeUtils.getDayDate((Date)TimeServiceHelper.now());
        HashMap fileToCustomPropMap = Maps.newHashMapWithExpectedSize((int)fileItemToBsedMap.size());
        for (MatchStdTableWithAdjFileParam param : paramList) {
            if (param.getAdjFileId() != null && param.getAdjFileId() > 0L && param.getStdItemId() != null && param.getStdItemId() > 0L) {
                Date bsed;
                Map valueParam = fileItemToBsedMap.computeIfAbsent(param.getAdjFileId(), val -> Maps.newHashMapWithExpectedSize((int)16));
                if (param.getBsed() == null) {
                    this.log.info("bsed is empty ,auto fill current system date ,param is {}", (Object)JSON.toJSONString((Object)param));
                }
                Date date = bsed = param.getBsed() == null ? defaultBsed : param.getBsed();
                if (valueParam.containsKey(param.getStdItemId())) {
                    throw new KDBizException("exist dulpicate adjFileId and stdItemId");
                }
                valueParam.put(param.getStdItemId(), bsed);
                List items = fileToItemMap.computeIfAbsent(param.getAdjFileId(), val -> Lists.newArrayListWithExpectedSize((int)10));
                items.add(param.getStdItemId());
                if (!MapUtils.isNotEmpty(param.getPersonPropValue())) continue;
                fileToCustomPropMap.put(param.getAdjFileId(), param.getPersonPropValue());
                continue;
            }
            throw new KDBizException("params has empty value,please check adjFileId or stdItemId");
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileItemToBsedMap.size());
        HashMap fileToScmMap = Maps.newHashMapWithExpectedSize((int)fileItemToBsedMap.size());
        HashMap fileToStructureMap = Maps.newHashMapWithExpectedSize((int)fileItemToBsedMap.size());
        DynamicObject[] adjfileObjArr = new SWCDataServiceHelper("hcdm_adjfileinfo").query("id,stdscm,salaystructure", new QFilter[]{new QFilter("id", "in", fileItemToBsedMap.keySet())});
        for (DynamicObject fileObj : adjfileObjArr) {
            fileToScmMap.putIfAbsent(fileObj.getLong("id"), fileObj.getLong("stdscm.id"));
            fileToStructureMap.putIfAbsent(fileObj.getLong("id"), fileObj.getLong("salaystructure.id"));
        }
        Map<Long, List<DynamicObject>> scmVersionMap = this.stdApplicationService.queryStdScmVersionObjWithBoId(fileToScmMap.values());
        Map<Long, Map<Long, DynamicObject>> fileItemToScmVersionMap = this.matchScmVersionWithBsed(fileItemToBsedMap, fileToScmMap, scmVersionMap);
        long beginTime2 = TimeServiceHelper.now().getTime();
        Map<Long, Map<Long, DynamicObject>> matchScmEntryMap = this.matchScmEntry(fileItemToScmVersionMap, fileToStructureMap);
        this.log.info("batchMatchStdTableWithAdjFile matchScmEntry cost {}", (Object)(TimeServiceHelper.now().getTime() - beginTime2));
        HashSet allUsedStdIds = Sets.newHashSet();
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : matchScmEntryMap.entrySet()) {
            for (Map.Entry<Long, DynamicObject> objectEntry : entry.getValue().entrySet()) {
                long tabId = objectEntry.getValue().getLong("salarystandard.id");
                if (tabId == 0L) continue;
                allUsedStdIds.add(tabId);
            }
        }
        Map<Long, List<DynamicObject>> stdBoIdToVersionObjMap = this.stdApplicationService.queryStdVersionObjWithBoId(allUsedStdIds);
        Map<Long, Map<Long, DynamicObject>> fileItemToStdVersion = this.matchStdVersionWithBsed(fileItemToBsedMap, matchScmEntryMap, stdBoIdToVersionObjMap);
        HashSet needMatchStdVersionIds = Sets.newHashSet();
        HashMap fileToStdTableVersionIdMap = Maps.newHashMapWithExpectedSize((int)fileItemToBsedMap.size());
        for (Map.Entry<Long, Map<Long, DynamicObject>> mapEntry : fileItemToStdVersion.entrySet()) {
            Long fileId = mapEntry.getKey();
            List stdTableIds = fileToStdTableVersionIdMap.computeIfAbsent(fileId, val -> Lists.newArrayListWithExpectedSize((int)10));
            for (DynamicObject stdVersionObj : mapEntry.getValue().values()) {
                long tabVersionId = stdVersionObj.getLong("id");
                if (tabVersionId <= 0L) continue;
                if (!stdTableIds.contains(tabVersionId)) {
                    stdTableIds.add(tabVersionId);
                }
                needMatchStdVersionIds.add(tabVersionId);
            }
        }
        long beginTime6 = TimeServiceHelper.now().getTime();
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map<Long, Long> workplaceMap = adjFileApplicationService.getWorkplaceByFile(fileToItemMap.keySet());
        Map<Long, Map<Long, Long>> matchCoefficientResult = this.matchCoefficientVersionId(matchScmEntryMap, workplaceMap, fileItemToBsedMap);
        this.log.info("batchMatchStdTableWithAdjFile matchCoefficient cost {}", (Object)(TimeServiceHelper.now().getTime() - beginTime6));
        SalaryStdMatchContext matchContext = this.getMatchContext();
        Map<Long, List<ContrastPropConfigEntity>> propsGroup = matchContext.getPropsGroupFromThreadCache(needMatchStdVersionIds);
        List<ContrastPropConfigEntity> distinctProp = this.mergeAndDistinct(propsGroup);
        Map<Long, Map<Long, SalaryStdItemEntity>> stdItemMap = matchContext.getStdItemMapFromThreadCache(needMatchStdVersionIds);
        long beginTime1 = TimeServiceHelper.now().getTime();
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, Object>> contrastPropValue = adjApprovalApplicationService.getContrastPropValue(distinctProp, new ArrayList<Long>(fileToItemMap.keySet()), false);
        Map<Long, Map<Long, List<Long>>> customPropBoValueMap = ContrastDataHelper.convertToBo(distinctProp, fileToCustomPropMap);
        this.coverPropWithCustomPropValue(contrastPropValue, customPropBoValueMap);
        this.log.info("batchMatchStdTableWithAdjFile afterGetContrastValue cost {}", (Object)(TimeServiceHelper.now().getTime() - beginTime1));
        long beginTime3 = TimeServiceHelper.now().getTime();
        Map<Long, List<SalaryStdMatchResult>> matchTableResult = this.doMatchTable(contrastPropValue, fileToStdTableVersionIdMap, propsGroup);
        this.log.info("batchMatchStdTableWithAdjFile afterDoMatchTable cost {}", (Object)(TimeServiceHelper.now().getTime() - beginTime3));
        long beginTime5 = TimeServiceHelper.now().getTime();
        Map<Long, Map<Long, Object>> contrastPropVersionValue = ContrastDataHelper.convertToVersion(distinctProp, contrastPropValue);
        this.coverPropValueWithVersion(matchTableResult, contrastPropVersionValue);
        this.log.info("batchMatchStdTableWithAdjFile coverPropValueWithVersion cost {}", (Object)(TimeServiceHelper.now().getTime() - beginTime5));
        for (Map.Entry entry : fileToItemMap.entrySet()) {
            Long fileId = (Long)entry.getKey();
            List itemIds = (List)entry.getValue();
            Map itemResultMap = resultMap.computeIfAbsent(fileId, o1 -> Maps.newHashMap());
            List<SalaryStdMatchResult> tableMatchResults = matchTableResult.get(fileId);
            Map<Long, DynamicObject> itemToScmEntryMap = matchScmEntryMap.get(fileId);
            Map<Long, Long> itemToCoefficientMap = matchCoefficientResult.get(fileId);
            Map<Long, DynamicObject> itemToStdVersionMap = fileItemToStdVersion.get(fileId);
            Map<Long, DynamicObject> itemToScmVersionMap = fileItemToScmVersionMap.get(fileId);
            for (Long itemId : itemIds) {
                long stdVersionId;
                DynamicObject scmEntryRow;
                DynamicObject scmVersionObj;
                SalaryStdMatchResultNew itemResult = new SalaryStdMatchResultNew();
                itemResultMap.put(itemId, itemResult);
                long stdScmId = 0L;
                if (!MapUtils.isEmpty(itemToScmVersionMap) && (scmVersionObj = itemToScmVersionMap.get(itemId)) != null) {
                    stdScmId = scmVersionObj.getLong("id");
                }
                Long coefficientId = itemToCoefficientMap == null ? Long.valueOf(0L) : itemToCoefficientMap.getOrDefault(itemId, 0L);
                itemResult.setStdScmVid(Long.valueOf(stdScmId));
                itemResult.setCoefficientVid(coefficientId);
                if (stdScmId == 0L) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.NOSTDSCM_INBSED);
                    continue;
                }
                DynamicObject dynamicObject = scmEntryRow = itemToScmEntryMap == null ? null : itemToScmEntryMap.get(itemId);
                if (scmEntryRow == null) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTEXIST_INSCM);
                    continue;
                }
                itemResult.setMatchStrategy(scmEntryRow.getString("matchStrategy"));
                itemResult.setIsMatchGradeRank(scmEntryRow.getString("isMatchGradeRank"));
                itemResult.setExcessControl(scmEntryRow.getString("excesscontrol"));
                if (scmEntryRow.getLong("salarystandard.id") == 0L) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTSETSTD_INSCM);
                    continue;
                }
                DynamicObject stdVersionObj = itemToStdVersionMap == null ? null : itemToStdVersionMap.get(itemId);
                long l = stdVersionId = stdVersionObj == null ? 0L : stdVersionObj.getLong("id");
                if (stdVersionId == 0L) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.STD_UNUSEABLE);
                    continue;
                }
                if (stdItemMap.get(stdVersionId) == null || stdItemMap.get(stdVersionId).get(itemId) == null) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTEXIST_INSTD);
                    continue;
                }
                SalaryStdMatchResult stdMatchResult = this.findSalaryStdMatchResult(tableMatchResults, stdVersionId);
                if (stdMatchResult == null) continue;
                itemResult.setStdTableVid(stdMatchResult.getStdTableVid());
                itemResult.setRangeData(GradeRankHelper.groupByRangeKeyToIdentityMap(stdMatchResult.getRangeData()));
                itemResult.setPersonPropValue(stdMatchResult.getPersonPropValue());
                itemResult.setNoMatchProp(stdMatchResult.getNoMatchProp());
                this.matchGradeRankId(stdMatchResult, scmEntryRow.getString("matchStrategy"), itemResult);
                Map<Long, SalaryStdItemEntity> stdItemEntityMap = stdItemMap.get(stdMatchResult.getStdTableVid());
                this.changeRangeDataByUseRankFlag(stdItemEntityMap.get(itemId), itemResult);
            }
        }
        HashSet resultList = Sets.newHashSetWithExpectedSize((int)16);
        for (Map value : resultMap.values()) {
            resultList.addAll(value.values());
        }
        this.batchReplaceGradeRankId(resultList);
        this.log.info("batchMatchStdTableWithAdjFile costtime {} , param size = {}", (Object)(TimeServiceHelper.now().getTime() - beginTime), (Object)fileToItemMap.size());
        return resultMap;
    }

    private void coverPropWithCustomPropValue(Map<Long, Map<Long, Object>> contrastPropValue, Map<Long, Map<Long, List<Long>>> fileToCustomPropMap) {
        if (MapUtils.isEmpty(fileToCustomPropMap)) {
            return;
        }
        for (Map.Entry<Long, Map<Long, List<Long>>> mapEntry : fileToCustomPropMap.entrySet()) {
            Map finalValue = contrastPropValue.computeIfAbsent(mapEntry.getKey(), val -> Maps.newHashMap());
            Map<Long, List<Long>> customValue = mapEntry.getValue();
            if (!MapUtils.isNotEmpty(customValue)) continue;
            for (Map.Entry<Long, List<Long>> propValues : customValue.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)propValues.getValue())) continue;
                finalValue.put(propValues.getKey(), propValues.getValue());
            }
        }
    }

    private Map<Long, Map<Long, DynamicObject>> matchStdVersionWithBsed(Map<Long, Map<Long, Date>> personkeyItemToBsedMap, Map<Long, Map<Long, DynamicObject>> matchScmEntryMap, Map<Long, List<DynamicObject>> stdBoIdToVersionObjMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personkeyItemToBsedMap.size());
        for (Map.Entry<Long, Map<Long, Date>> entry : personkeyItemToBsedMap.entrySet()) {
            Map<Long, DynamicObject> itemToScmEntryMap = matchScmEntryMap.get(entry.getKey());
            if (MapUtils.isEmpty(itemToScmEntryMap)) continue;
            HashMap subResultMap = Maps.newHashMapWithExpectedSize((int)entry.getValue().size());
            resultMap.put(entry.getKey(), subResultMap);
            for (Map.Entry<Long, Date> itemEntry : entry.getValue().entrySet()) {
                List<DynamicObject> stdVersionObjs;
                DynamicObject versionObj;
                long tabBoId;
                Long itemId = itemEntry.getKey();
                Date bsed = itemEntry.getValue();
                DynamicObject scmEntryRowObj = itemToScmEntryMap.get(itemId);
                if (scmEntryRowObj == null || (tabBoId = scmEntryRowObj.getLong("salarystandard.id")) == 0L || (versionObj = this.findVersionObjByBsed(bsed, stdVersionObjs = stdBoIdToVersionObjMap.get(tabBoId))) == null) continue;
                subResultMap.put(itemId, versionObj);
            }
        }
        return resultMap;
    }

    private Map<Long, Long> matchStdVersionWithBsedNoItem(Map<Long, Date> personkeyToBsedMap, Map<Long, Long> personKeyToStdIdOfParam, Map<Long, List<DynamicObject>> stdBoIdToVersionObjMap, Map<Long, DynamicObject> stdVidToVersionObj) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personkeyToBsedMap.size());
        for (Map.Entry<Long, Date> entry : personkeyToBsedMap.entrySet()) {
            Long tabId = personKeyToStdIdOfParam.get(entry.getKey());
            if (tabId == null) continue;
            List<DynamicObject> versionArrByBoId = stdBoIdToVersionObjMap.get(tabId);
            DynamicObject versionObjByVid = stdVidToVersionObj.get(tabId);
            DynamicObject finalVersionObj = stdVidToVersionObj.get(tabId);
            if (CollectionUtils.isEmpty(versionArrByBoId)) {
                if (versionObjByVid != null) {
                    finalVersionObj = versionObjByVid;
                }
            } else {
                finalVersionObj = this.findVersionObjByBsed(entry.getValue(), versionArrByBoId);
            }
            if (finalVersionObj == null) continue;
            resultMap.put(entry.getKey(), finalVersionObj.getLong("id"));
        }
        return resultMap;
    }

    private Map<Long, Map<Long, DynamicObject>> matchScmVersionWithBsed(Map<Long, Map<Long, Date>> personkeyItemToBsedMap, Map<Long, Long> personkeyToScmMap, Map<Long, List<DynamicObject>> scmVersionMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personkeyItemToBsedMap.size());
        for (Map.Entry<Long, Map<Long, Date>> entry : personkeyItemToBsedMap.entrySet()) {
            List<DynamicObject> scmVersionObjs;
            Long scmBoId = personkeyToScmMap.get(entry.getKey());
            if (scmBoId == null || scmBoId == 0L || CollectionUtils.isEmpty(scmVersionObjs = scmVersionMap.get(scmBoId))) continue;
            HashMap subResultMap = Maps.newHashMapWithExpectedSize((int)entry.getValue().size());
            resultMap.put(entry.getKey(), subResultMap);
            for (Map.Entry<Long, Date> itemEntry : entry.getValue().entrySet()) {
                Long itemId = itemEntry.getKey();
                Date bsed = itemEntry.getValue();
                DynamicObject versionObj = this.findVersionObjByBsed(bsed, scmVersionObjs);
                if (versionObj == null) continue;
                subResultMap.put(itemId, versionObj);
            }
        }
        return resultMap;
    }

    private DynamicObject findVersionObjByBsed(Date bsed, List<DynamicObject> hisVersionObjs) {
        if (CollectionUtils.isEmpty(hisVersionObjs)) {
            return null;
        }
        for (DynamicObject scmVersionObj : hisVersionObjs) {
            boolean dateIn = SWCDateTimeUtils.isCover((Date)bsed, (Date)scmVersionObj.getDate("bsed"), (Date)scmVersionObj.getDate("bsled"));
            if (!dateIn) continue;
            return scmVersionObj;
        }
        return null;
    }

    private SalaryStdMatchContext getMatchContext() {
        SalaryStdMatchContext matchContext = (SalaryStdMatchContext)GlobalParam.get((String)"batchMatchStdTableWithAdjFile");
        if (matchContext == null || !StringUtils.equals((CharSequence)matchContext.getRequestId(), (CharSequence)matchContext.getRequestId())) {
            GlobalParam.remove((String)"batchMatchStdTableWithAdjFile");
            matchContext = new SalaryStdMatchContext(this);
            GlobalParam.set((String)"batchMatchStdTableWithAdjFile", (Object)matchContext);
        }
        return matchContext;
    }

    private void matchGradeRankId(SalaryStdMatchResult tableMatchResult, String matchStrategy, SalaryStdMatchResultNew salaryStdMatchResultNew) {
        List<GradeRankKey> gradeRankKeys = tableMatchResult.getRangeData();
        Map RangeData = salaryStdMatchResultNew.getRangeData();
        if (CollectionUtils.isEmpty(gradeRankKeys)) {
            return;
        }
        List salaryGradeEntities = gradeRankKeys.stream().map(GradeRankKey::getGradeEntity).collect(Collectors.toList());
        List salaryRankEntities = gradeRankKeys.stream().map(GradeRankKey::getRankEntity).collect(Collectors.toList());
        switch (matchStrategy) {
            case "1": {
                SalaryGradeEntity maxGrade = salaryGradeEntities.stream().max(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).orElse(null);
                if (Objects.isNull(maxGrade)) break;
                List ranks = (List)RangeData.get(maxGrade.getGradeIdentity());
                if (!CollectionUtils.isEmpty((Collection)ranks)) {
                    HashSet rankSets = Sets.newHashSet((Iterable)ranks);
                    SalaryRankEntity maxRank = salaryRankEntities.stream().filter(salaryRankEntitie -> rankSets.contains(salaryRankEntitie.getRankIdentity())).max(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).orElse(null);
                    salaryStdMatchResultNew.setRankId(maxRank.getRankIdentity());
                }
                salaryStdMatchResultNew.setGradeId(maxGrade.getGradeIdentity());
                break;
            }
            case "2": {
                break;
            }
            case "3": {
                SalaryGradeEntity minGrade = salaryGradeEntities.stream().min(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).orElse(null);
                if (Objects.isNull(minGrade)) break;
                List ranks = (List)RangeData.get(minGrade.getGradeIdentity());
                if (!CollectionUtils.isEmpty((Collection)ranks)) {
                    HashSet rankSets = Sets.newHashSet((Iterable)ranks);
                    SalaryRankEntity minRank = salaryRankEntities.stream().filter(salaryRankEntitie -> rankSets.contains(salaryRankEntitie.getRankIdentity())).min(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).orElse(null);
                    salaryStdMatchResultNew.setRankId(minRank.getRankIdentity());
                }
                salaryStdMatchResultNew.setGradeId(minGrade.getGradeIdentity());
                break;
            }
        }
    }

    public Map<Long, Map<Long, SalaryStdMatchResultNew>> batchMatchStdTableForCandidate(List<MatchStdTableForCandidateParam> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyMap();
        }
        HashMap candIdItemToBsedMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        HashMap candIdToItemMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        HashMap candIdToScmMap = Maps.newHashMapWithExpectedSize((int)candIdItemToBsedMap.size());
        HashMap candIdToStructureMap = Maps.newHashMapWithExpectedSize((int)candIdItemToBsedMap.size());
        HashMap candIdToDysMap = Maps.newHashMapWithExpectedSize((int)candIdItemToBsedMap.size());
        Date defaultBsed = SWCDateTimeUtils.getDayDate((Date)TimeServiceHelper.now());
        for (MatchStdTableForCandidateParam param : paramList) {
            if (param.getCandidateId() != null && param.getCandidateId() > 0L && param.getStdItemId() != null && param.getStdItemId() > 0L && param.getStdScmId() != null && param.getStdScmId() > 0L && param.getSalaryStructureId() != null && param.getSalaryStructureId() > 0L && param.getCandidateBillObj() != null) {
                Map valueParam = candIdItemToBsedMap.computeIfAbsent(param.getCandidateId(), val -> Maps.newHashMapWithExpectedSize((int)16));
                if (param.getBsed() == null) {
                    this.log.info("bsed is empty ,auto fill current system date ");
                }
                Date bsed = param.getBsed() == null ? defaultBsed : param.getBsed();
                Date oldBsed = valueParam.put(param.getStdItemId(), bsed);
                if (oldBsed != null) {
                    throw new KDBizException("exist dulpicate candidateId and stdItemId");
                }
                List items = candIdToItemMap.computeIfAbsent(param.getCandidateId(), val -> Lists.newArrayListWithExpectedSize((int)10));
                items.add(param.getStdItemId());
                Long oldStdScmId = candIdToScmMap.put(param.getCandidateId(), param.getStdScmId());
                if (oldStdScmId != null && !oldStdScmId.equals(param.getStdScmId())) {
                    throw new KDBizException("one candidateId can not associated with one more stdScmId in two param");
                }
                Long oldStructureId = candIdToStructureMap.put(param.getCandidateId(), param.getSalaryStructureId());
                if (oldStructureId != null && !oldStructureId.equals(param.getSalaryStructureId())) {
                    throw new KDBizException("one candidateId can not associated with one more salaryStructureId in two param");
                }
                candIdToDysMap.put(param.getCandidateId(), param.getCandidateBillObj());
                continue;
            }
            throw new KDBizException("params has empty value,please check");
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)candIdItemToBsedMap.size());
        Map<Long, List<DynamicObject>> scmVersionMap = this.stdApplicationService.queryStdScmVersionObjWithBoId(candIdToScmMap.values());
        Map<Long, DynamicObject> scmVidToVersionObjMap = this.stdApplicationService.queryScmVersionObjWithVid(candIdToScmMap.values());
        Map<Long, Map<Long, DynamicObject>> candIdItemToScmVersionFinalMap = this.matchScmVersionWithBsed(candIdItemToBsedMap, candIdToScmMap, scmVersionMap);
        Map<Long, Map<Long, DynamicObject>> candIdItemToScmVersionMap = this.matchScmVersionByScmVId(candIdItemToBsedMap, candIdToScmMap, scmVidToVersionObjMap);
        this.mergeScmVersionMatchResult(candIdItemToScmVersionFinalMap, candIdItemToScmVersionMap);
        Map<Long, Map<Long, DynamicObject>> matchScmEntryMap = this.matchScmEntry(candIdItemToScmVersionFinalMap, candIdToStructureMap);
        HashSet allUsedStdIds = Sets.newHashSet();
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : matchScmEntryMap.entrySet()) {
            for (Map.Entry<Long, DynamicObject> objectEntry : entry.getValue().entrySet()) {
                long tabId = objectEntry.getValue().getLong("salarystandard.id");
                if (tabId == 0L) continue;
                allUsedStdIds.add(tabId);
            }
        }
        Map<Long, List<DynamicObject>> stdBoIdToVersionObjMap = this.stdApplicationService.queryStdVersionObjWithBoId(allUsedStdIds);
        Map<Long, Map<Long, DynamicObject>> candIdItemToStdVersion = this.matchStdVersionWithBsed(candIdItemToBsedMap, matchScmEntryMap, stdBoIdToVersionObjMap);
        HashSet needMatchStdVersionIds = Sets.newHashSet();
        HashMap candIdToStdTableVersionIdMap = Maps.newHashMapWithExpectedSize((int)candIdItemToBsedMap.size());
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : candIdItemToStdVersion.entrySet()) {
            Long l = entry.getKey();
            List stdTableIds = candIdToStdTableVersionIdMap.computeIfAbsent(l, val -> Lists.newArrayListWithExpectedSize((int)10));
            for (DynamicObject stdVersionObj : entry.getValue().values()) {
                long tabVersionId = stdVersionObj.getLong("id");
                if (tabVersionId <= 0L) continue;
                if (!stdTableIds.contains(tabVersionId)) {
                    stdTableIds.add(tabVersionId);
                }
                needMatchStdVersionIds.add(tabVersionId);
            }
        }
        HashMap workplaceMap = Maps.newHashMapWithExpectedSize((int)candIdToDysMap.size());
        for (Map.Entry entry : candIdToDysMap.entrySet()) {
            DynamicObject candSetSalaryApplDy = (DynamicObject)entry.getValue();
            DynamicObjectCollection personEntryDys = candSetSalaryApplDy.getDynamicObjectCollection("candsetsalperson");
            long baselocationId = ((DynamicObject)personEntryDys.get(0)).getLong("baselocation.id");
            workplaceMap.put(entry.getKey(), baselocationId);
        }
        Map<Long, Map<Long, Long>> map = this.matchCoefficientVersionId(matchScmEntryMap, workplaceMap, candIdItemToBsedMap);
        Map<Long, List<ContrastPropConfigEntity>> map2 = ContrastDataHelper.queryContrastProps(needMatchStdVersionIds);
        List<ContrastPropConfigEntity> distinctProp = this.mergeAndDistinct(map2);
        Map<Long, List<SalaryStdItemEntity>> itemEntityMap = SalaryStdItemHelper.queryItemEntities(needMatchStdVersionIds);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)needMatchStdVersionIds.size());
        for (Map.Entry<Long, List<SalaryStdItemEntity>> entry : itemEntityMap.entrySet()) {
            stdItemMap.computeIfAbsent(entry.getKey(), v1 -> SalaryStdItemHelper.groupBySalaryItemId((List)entry.getValue()));
        }
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, Object>> contrastPropValue = adjApprovalApplicationService.getContrastPropValueOfCandidate(distinctProp, candIdToDysMap, false);
        Map<Long, List<SalaryStdMatchResult>> matchTableResult = this.doMatchTable(contrastPropValue, candIdToStdTableVersionIdMap, map2);
        Map<Long, Map<Long, Object>> contrastPropVersionValue = ContrastDataHelper.convertToVersion(distinctProp, contrastPropValue);
        this.coverPropValueWithVersion(matchTableResult, contrastPropVersionValue);
        for (Map.Entry entry : candIdToItemMap.entrySet()) {
            Long candidateId = (Long)entry.getKey();
            List itemIds = (List)entry.getValue();
            Map itemResultMap = resultMap.computeIfAbsent(candidateId, o1 -> Maps.newHashMap());
            List<SalaryStdMatchResult> tableMatchResults = matchTableResult.get(candidateId);
            Map<Long, DynamicObject> itemToScmEntryMap = matchScmEntryMap.get(candidateId);
            Map<Long, Long> itemToCoefficientMap = map.get(candidateId);
            Map<Long, DynamicObject> itemToStdVersionMap = candIdItemToStdVersion.get(candidateId);
            Map<Long, DynamicObject> itemToScmVersionMap = candIdItemToScmVersionFinalMap.get(candidateId);
            for (Long itemId : itemIds) {
                long stdVersionId;
                DynamicObject scmEntryRow;
                DynamicObject scmVersionObj;
                SalaryStdMatchResultNew itemResult = new SalaryStdMatchResultNew();
                itemResultMap.put(itemId, itemResult);
                long stdScmId = 0L;
                if (!MapUtils.isEmpty(itemToScmVersionMap) && (scmVersionObj = itemToScmVersionMap.get(itemId)) != null) {
                    stdScmId = scmVersionObj.getLong("id");
                }
                Long coefficientId = itemToCoefficientMap == null ? Long.valueOf(0L) : itemToCoefficientMap.getOrDefault(itemId, 0L);
                itemResult.setCoefficientVid(coefficientId);
                itemResult.setStdScmVid(Long.valueOf(stdScmId));
                if (stdScmId == 0L) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.NOSTDSCM_INBSED);
                    continue;
                }
                DynamicObject dynamicObject = scmEntryRow = itemToScmEntryMap == null ? null : itemToScmEntryMap.get(itemId);
                if (scmEntryRow == null) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTEXIST_INSCM);
                    continue;
                }
                itemResult.setMatchStrategy(scmEntryRow.getString("matchStrategy"));
                itemResult.setIsMatchGradeRank(scmEntryRow.getString("isMatchGradeRank"));
                itemResult.setExcessControl(scmEntryRow.getString("excesscontrol"));
                if (scmEntryRow.getLong("salarystandard.id") == 0L) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTSETSTD_INSCM);
                    continue;
                }
                DynamicObject stdVersionObj = itemToStdVersionMap == null ? null : itemToStdVersionMap.get(itemId);
                long l = stdVersionId = stdVersionObj == null ? 0L : stdVersionObj.getLong("id");
                if (stdVersionId == 0L) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.STD_UNUSEABLE);
                    continue;
                }
                if (stdItemMap.get(stdVersionId) == null || ((Map)stdItemMap.get(stdVersionId)).get(itemId) == null) {
                    itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTEXIST_INSTD);
                    continue;
                }
                SalaryStdMatchResult stdMatchResult = this.findSalaryStdMatchResult(tableMatchResults, stdVersionId);
                if (stdMatchResult == null) continue;
                itemResult.setStdTableVid(stdMatchResult.getStdTableVid());
                itemResult.setRangeData(GradeRankHelper.groupByRangeKeyToIdentityMap(stdMatchResult.getRangeData()));
                itemResult.setPersonPropValue(stdMatchResult.getPersonPropValue());
                itemResult.setNoMatchProp(stdMatchResult.getNoMatchProp());
                this.matchGradeRankId(stdMatchResult, scmEntryRow.getString("matchStrategy"), itemResult);
                Map stdItemEntityMap = (Map)stdItemMap.get(stdMatchResult.getStdTableVid());
                this.changeRangeDataByUseRankFlag((SalaryStdItemEntity)stdItemEntityMap.get(itemId), itemResult);
            }
        }
        HashSet resultList = Sets.newHashSetWithExpectedSize((int)16);
        for (Map value : resultMap.values()) {
            resultList.addAll(value.values());
        }
        this.batchReplaceGradeRankId(resultList);
        return resultMap;
    }

    public List<SalaryStdMatchResultNew> batchMatchStdTableWithDepEmp(List<StdMatchParamWithDepEmp> params) {
        if (CollectionUtils.isEmpty(params)) {
            return Collections.emptyList();
        }
        this.log.info("batchMatchStdTableWithDepEmp param size  = {} ,param json  = {}", (Object)params.size(), (Object)JSON.toJSONString(params));
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)params.size());
        Set unionIds = params.stream().map(StdMatchParamWithDepEmp::getUnionId).collect(Collectors.toSet());
        if (unionIds.size() < params.size()) {
            throw new KDBizException("unionid is duplicated");
        }
        List noDepempParam = params.stream().filter(param -> param.getDepempId() == null || param.getDepempId() == 0L).collect(Collectors.toList());
        List<StdMatchParamWithDepEmp> hasDepempParam = params.stream().filter(param -> param.getDepempId() != null && param.getDepempId() > 0L).collect(Collectors.toList());
        hasDepempParam = this.filterParamAfterCheckIdExist(hasDepempParam, "hrpi_depemp", StdMatchParamWithDepEmp::getDepempId);
        CollectionUtils.addAll(hasDepempParam, noDepempParam.iterator());
        params = hasDepempParam;
        params = this.filterParamAfterCheckIdExist(params, "hcdm_stdscm", StdMatchParamWithDepEmp::getStdScmId);
        params = this.filterParamAfterCheckIdExist(params, "hcdm_salaystructure", StdMatchParamWithDepEmp::getSalayStructureId);
        params = this.filterParamAfterCheckIdExist(params, "hsbs_standarditem", StdMatchParamWithDepEmp::getStandardItemId);
        this.log.info("batchMatchStdTableWithDepEmp checkedparam size  = {} ,param json  = {}", (Object)params.size(), (Object)JSON.toJSONString(params));
        HashSet depEmpIds = Sets.newHashSet();
        HashSet stdScmIds = Sets.newHashSet();
        for (StdMatchParamWithDepEmp param2 : params) {
            boolean hasDepEmp;
            boolean bl = hasDepEmp = param2.getDepempId() != null && param2.getDepempId() > 0L;
            if (!hasDepEmp && MapUtils.isEmpty((Map)param2.getPersonPropValue())) {
                throw new KDBizException("PersonPropValue or depempId must input at least one");
            }
            if (hasDepEmp) {
                depEmpIds.add(param2.getDepempId());
            }
            stdScmIds.add(param2.getStdScmId());
        }
        HashMap personKeyToScmIdMap = Maps.newHashMapWithExpectedSize((int)depEmpIds.size());
        HashMap personKeyToStructureIdMap = Maps.newHashMapWithExpectedSize((int)depEmpIds.size());
        HashMap personKeyToItemIdMap = Maps.newHashMapWithExpectedSize((int)depEmpIds.size());
        HashMap personKeyToItemBsedMap = Maps.newHashMapWithExpectedSize((int)depEmpIds.size());
        HashMap unionIdToPersonKeyMap = Maps.newHashMapWithExpectedSize((int)depEmpIds.size());
        long personKey = 1000000L;
        Date defaultBsed = SWCDateTimeUtils.getDayDate((Date)TimeServiceHelper.now());
        for (StdMatchParamWithDepEmp param3 : params) {
            personKeyToScmIdMap.putIfAbsent(personKey, param3.getStdScmId());
            personKeyToStructureIdMap.putIfAbsent(personKey, param3.getSalayStructureId());
            List itemList = personKeyToItemIdMap.computeIfAbsent(personKey, o1 -> Lists.newArrayList());
            Map itemDateMap = personKeyToItemBsedMap.computeIfAbsent(personKey, o1 -> Maps.newHashMapWithExpectedSize((int)16));
            Date bsed = param3.getBsed() == null ? defaultBsed : param3.getBsed();
            itemDateMap.put(param3.getStandardItemId(), bsed);
            itemList.add(param3.getStandardItemId());
            unionIdToPersonKeyMap.put(param3.getUnionId(), personKey);
            ++personKey;
        }
        Map<Long, DynamicObject> scmVidToVersionObjMap = this.stdApplicationService.queryScmVersionObjWithVid(stdScmIds);
        Map<Long, List<DynamicObject>> scmVersionMap = this.stdApplicationService.queryStdScmVersionObjWithBoId(stdScmIds);
        Map<Long, Map<Long, DynamicObject>> personkeyItemToScmVersionFinalMap = this.matchScmVersionWithBsed(personKeyToItemBsedMap, personKeyToScmIdMap, scmVersionMap);
        Map<Long, Map<Long, DynamicObject>> personkeyItemToScmVersionMap = this.matchScmVersionByScmVId(personKeyToItemBsedMap, personKeyToScmIdMap, scmVidToVersionObjMap);
        this.mergeScmVersionMatchResult(personkeyItemToScmVersionFinalMap, personkeyItemToScmVersionMap);
        Map<Long, Map<Long, DynamicObject>> matchScmEntryMap = this.matchScmEntry(personkeyItemToScmVersionFinalMap, personKeyToStructureIdMap);
        HashSet allUsedStdIds = Sets.newHashSet();
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : matchScmEntryMap.entrySet()) {
            for (Map.Entry<Long, DynamicObject> objectEntry : entry.getValue().entrySet()) {
                long tabId = objectEntry.getValue().getLong("salarystandard.id");
                if (tabId == 0L) continue;
                allUsedStdIds.add(tabId);
            }
        }
        Map<Long, List<DynamicObject>> stdBoIdToVersionObjMap = this.stdApplicationService.queryStdVersionObjWithBoId(allUsedStdIds);
        Map<Long, Map<Long, DynamicObject>> personKeyItemToStdVersion = this.matchStdVersionWithBsed(personKeyToItemBsedMap, matchScmEntryMap, stdBoIdToVersionObjMap);
        HashSet needMatchStdVersionIds = Sets.newHashSet();
        HashMap personkeyToStdTableVersionIdMap = Maps.newHashMapWithExpectedSize((int)personKeyToItemBsedMap.size());
        for (Map.Entry<Long, Map<Long, DynamicObject>> mapEntry : personKeyItemToStdVersion.entrySet()) {
            Long fileId = mapEntry.getKey();
            List stdTableIds = personkeyToStdTableVersionIdMap.computeIfAbsent(fileId, val -> Lists.newArrayListWithExpectedSize((int)10));
            for (DynamicObject stdVersionObj : mapEntry.getValue().values()) {
                long tabVersionId = stdVersionObj.getLong("id");
                if (tabVersionId <= 0L) continue;
                if (!stdTableIds.contains(tabVersionId)) {
                    stdTableIds.add(tabVersionId);
                }
                needMatchStdVersionIds.add(tabVersionId);
            }
        }
        AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
        Map<Long, Long> workplaceMapOfQuery = adjFileApplicationService.getWorkplaceByDepEmp(depEmpIds);
        Map<Long, Long> personKeyToWorkplaceMap = this.getWorkplaceIdWithParam(workplaceMapOfQuery, params, unionIdToPersonKeyMap);
        Map<Long, Map<Long, Long>> matchCoefficientResult = this.matchCoefficientVersionId(matchScmEntryMap, personKeyToWorkplaceMap, personKeyToItemBsedMap);
        Map<Long, List<ContrastPropConfigEntity>> propsGroup = ContrastDataHelper.queryContrastProps(needMatchStdVersionIds);
        List<ContrastPropConfigEntity> distinctProp = this.mergeAndDistinct(propsGroup);
        Map<Long, List<SalaryStdItemEntity>> itemEntityMap = SalaryStdItemHelper.queryItemEntities(needMatchStdVersionIds);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)needMatchStdVersionIds.size());
        for (Map.Entry<Long, List<SalaryStdItemEntity>> entry : itemEntityMap.entrySet()) {
            stdItemMap.computeIfAbsent(entry.getKey(), v1 -> SalaryStdItemHelper.groupBySalaryItemId((List)entry.getValue()));
        }
        Map<Object, Object> contrastPropValue = Maps.newHashMapWithExpectedSize((int)params.size());
        if (!depEmpIds.isEmpty()) {
            AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
            contrastPropValue = adjApprovalApplicationService.getContrastPropValueByDepEmp(distinctProp, new ArrayList<Long>(depEmpIds), false);
        }
        contrastPropValue = this.mergeContrastPropValueWithParam(contrastPropValue, params, unionIdToPersonKeyMap);
        Map<Long, List<SalaryStdMatchResult>> matchTableResult = this.doMatchTable(contrastPropValue, personkeyToStdTableVersionIdMap, propsGroup);
        Map<Long, Map<Long, Object>> contrastPropVersionValue = ContrastDataHelper.convertToVersion(distinctProp, contrastPropValue);
        this.coverPropValueWithVersion(matchTableResult, contrastPropVersionValue);
        for (StdMatchParamWithDepEmp param4 : params) {
            long stdVersionId;
            DynamicObject scmEntryRow;
            DynamicObject scmVersionObj;
            Long personKeyTmp = (Long)unionIdToPersonKeyMap.get(param4.getUnionId());
            Long itemId = param4.getStandardItemId();
            SalaryStdMatchResultNew itemResult = new SalaryStdMatchResultNew();
            resultList.add(itemResult);
            itemResult.setUnionId(param4.getUnionId());
            List<SalaryStdMatchResult> tableMatchResults = matchTableResult.get(personKeyTmp);
            Map<Long, DynamicObject> itemToScmVersionMap = personkeyItemToScmVersionFinalMap.get(personKeyTmp);
            Map<Long, DynamicObject> itemToScmEntryMap = matchScmEntryMap.get(personKeyTmp);
            Map<Long, Long> itemToCoefficientMap = matchCoefficientResult.get(personKeyTmp);
            Map<Long, DynamicObject> itemToStdVersionMap = personKeyItemToStdVersion.get(personKeyTmp);
            long stdScmId = 0L;
            if (!MapUtils.isEmpty(itemToScmVersionMap) && (scmVersionObj = itemToScmVersionMap.get(itemId)) != null) {
                stdScmId = scmVersionObj.getLong("id");
            }
            Long coefficientId = itemToCoefficientMap == null ? Long.valueOf(0L) : itemToCoefficientMap.getOrDefault(itemId, 0L);
            itemResult.setStdScmVid(Long.valueOf(stdScmId));
            itemResult.setCoefficientVid(coefficientId);
            if (stdScmId == 0L) {
                itemResult.setStdTableNotFoundType(StdTabNotFoundType.NOSTDSCM_INBSED);
                continue;
            }
            DynamicObject dynamicObject = scmEntryRow = itemToScmEntryMap == null ? null : itemToScmEntryMap.get(itemId);
            if (scmEntryRow == null) {
                itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTEXIST_INSCM);
                continue;
            }
            itemResult.setMatchStrategy(scmEntryRow.getString("matchStrategy"));
            itemResult.setIsMatchGradeRank(scmEntryRow.getString("isMatchGradeRank"));
            itemResult.setExcessControl(scmEntryRow.getString("excesscontrol"));
            if (scmEntryRow.getLong("salarystandard.id") == 0L) {
                itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTSETSTD_INSCM);
                continue;
            }
            DynamicObject stdVersionObj = itemToStdVersionMap == null ? null : itemToStdVersionMap.get(itemId);
            long l = stdVersionId = stdVersionObj == null ? 0L : stdVersionObj.getLong("id");
            if (stdVersionId == 0L) {
                itemResult.setStdTableNotFoundType(StdTabNotFoundType.STD_UNUSEABLE);
                continue;
            }
            if (stdItemMap.get(stdVersionId) == null || ((Map)stdItemMap.get(stdVersionId)).get(itemId) == null) {
                itemResult.setStdTableNotFoundType(StdTabNotFoundType.ITEM_NOTEXIST_INSTD);
                continue;
            }
            SalaryStdMatchResult stdMatchResult = this.findSalaryStdMatchResult(tableMatchResults, stdVersionId);
            if (stdMatchResult == null) continue;
            itemResult.setStdTableVid(stdMatchResult.getStdTableVid());
            itemResult.setRangeData(GradeRankHelper.groupByRangeKeyToIdentityMap(stdMatchResult.getRangeData()));
            itemResult.setPersonPropValue(stdMatchResult.getPersonPropValue());
            itemResult.setNoMatchProp(stdMatchResult.getNoMatchProp());
            this.matchGradeRankId(stdMatchResult, scmEntryRow.getString("matchStrategy"), itemResult);
            Map stdItemEntityMap = (Map)stdItemMap.get(stdMatchResult.getStdTableVid());
            this.changeRangeDataByUseRankFlag((SalaryStdItemEntity)stdItemEntityMap.get(itemId), itemResult);
        }
        this.batchReplaceGradeRankId(resultList);
        this.log.info("batchMatchStdTableWithDepEmp result = {}", (Object)params.size(), (Object)JSON.toJSONString((Object)resultList));
        return resultList;
    }

    private Map<Long, Map<Long, DynamicObject>> matchScmVersionByScmVId(Map<Long, Map<Long, Date>> personKeyToItemBsedMap, Map<Long, Long> personKeyToScmIdMap, Map<Long, DynamicObject> scmVidToVersionObjMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personKeyToItemBsedMap.size());
        for (Map.Entry<Long, Map<Long, Date>> entry : personKeyToItemBsedMap.entrySet()) {
            DynamicObject scmVersionObj;
            Long scmBoId = personKeyToScmIdMap.get(entry.getKey());
            if (scmBoId == null || scmBoId == 0L || (scmVersionObj = scmVidToVersionObjMap.get(scmBoId)) == null) continue;
            Map itemResultMap = resultMap.computeIfAbsent(entry.getKey(), val -> Maps.newHashMapWithExpectedSize((int)((Map)entry.getValue()).size()));
            for (Map.Entry<Long, Date> itemEntry : entry.getValue().entrySet()) {
                itemResultMap.put(itemEntry.getKey(), scmVersionObj);
            }
        }
        return resultMap;
    }

    private void mergeScmVersionMatchResult(Map<Long, Map<Long, DynamicObject>> fileItemToScmVersionFinalMap, Map<Long, Map<Long, DynamicObject>> fileItemToScmVersion1Map) {
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : fileItemToScmVersion1Map.entrySet()) {
            Map itemEntryFinal = fileItemToScmVersionFinalMap.computeIfAbsent(entry.getKey(), val -> Maps.newHashMapWithExpectedSize((int)16));
            for (Map.Entry<Long, DynamicObject> subEntry : entry.getValue().entrySet()) {
                itemEntryFinal.computeIfAbsent(subEntry.getKey(), val -> (DynamicObject)subEntry.getValue());
            }
        }
    }

    private Map<Long, Long> getWorkplaceIdWithParam(Map<Long, Long> workplaceMapOfQuery, List<StdMatchParamWithDepEmp> params, Map<String, Long> unionIdToPersonKeyMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (StdMatchParamWithDepEmp param : params) {
            Long workplaceOfQuery;
            boolean needQueryValue;
            Long personKey = unionIdToPersonKeyMap.get(param.getUnionId());
            Long workplaceId = param.getAdminDivisionId();
            boolean bl = needQueryValue = (workplaceId == null || workplaceId == 0L) && param.getDepempId() != null && param.getDepempId() > 0L;
            if (needQueryValue && (workplaceOfQuery = workplaceMapOfQuery.get(param.getDepempId())) != null && workplaceOfQuery > 0L) {
                workplaceId = workplaceOfQuery;
            }
            if (workplaceId == null || workplaceId <= 0L) continue;
            resultMap.put(personKey, workplaceId);
        }
        return resultMap;
    }

    private Map<Long, Map<Long, Object>> mergeContrastPropValueWithParam(Map<Long, Map<Long, Object>> contrastPropValueAfterQuery, List<StdMatchParamWithDepEmp> params, Map<String, Long> unionIdToPersonKeyMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (StdMatchParamWithDepEmp param : params) {
            Map<Long, Object> personPropsAfterQuery;
            Long personKey = unionIdToPersonKeyMap.get(param.getUnionId());
            HashMap personPropsFinal = Maps.newHashMapWithExpectedSize((int)16);
            resultMap.put(personKey, personPropsFinal);
            if (MapUtils.isNotEmpty((Map)param.getPersonPropValue())) {
                for (Map.Entry paramEntry : param.getPersonPropValue().entrySet()) {
                    personPropsFinal.computeIfAbsent(paramEntry.getKey(), k1 -> (List)paramEntry.getValue());
                }
            }
            if (param.getDepempId() == null || param.getDepempId() <= 0L || !MapUtils.isNotEmpty(personPropsAfterQuery = contrastPropValueAfterQuery.get(param.getDepempId()))) continue;
            for (Map.Entry<Long, Object> paramEntry : personPropsAfterQuery.entrySet()) {
                boolean valueEmpty;
                Object queryValue = paramEntry.getValue();
                boolean bl = valueEmpty = queryValue == null;
                if (queryValue instanceof List) {
                    valueEmpty = CollectionUtils.isEmpty((Collection)((List)queryValue));
                }
                if (valueEmpty || !MapUtils.isEmpty((Map)param.getPersonPropValue()) && param.getPersonPropValue().containsKey(paramEntry.getKey())) continue;
                personPropsFinal.put(paramEntry.getKey(), queryValue);
            }
        }
        return resultMap;
    }

    private void changeRangeDataByUseRankFlag(SalaryStdItemEntity itemEntity, SalaryStdMatchResultNew itemResult) {
        boolean isUseRank;
        Map rangeData = itemResult.getRangeData();
        if (itemEntity == null) {
            return;
        }
        boolean bl = isUseRank = itemEntity.getItemIsUseSalaryRank() == 1;
        if (!isUseRank) {
            for (Map.Entry entry : rangeData.entrySet()) {
                ((List)entry.getValue()).clear();
                itemResult.setRankId(null);
            }
        }
    }

    private List<StdMatchParamWithDepEmp> filterParamAfterCheckIdExist(List<StdMatchParamWithDepEmp> params, String entityNumber, Function<StdMatchParamWithDepEmp, Long> func) {
        Set ids = params.stream().map(depEmp -> (Long)func.apply((StdMatchParamWithDepEmp)depEmp)).collect(Collectors.toSet());
        DynamicObject[] result = new SWCDataServiceHelper(entityNumber).query("id", new QFilter[]{new QFilter("id", "in", ids)});
        Set idSetOfDb = Arrays.stream(result).map(object -> object.getLong("id")).collect(Collectors.toSet());
        return params.stream().filter(depEmp -> idSetOfDb.contains(func.apply((StdMatchParamWithDepEmp)depEmp))).collect(Collectors.toList());
    }

    private void coverPropValueWithVersion(Map<Long, List<SalaryStdMatchResult>> matchTableResult, Map<Long, Map<Long, Object>> contrastPropValue) {
        if (MapUtils.isEmpty(matchTableResult)) {
            return;
        }
        for (Map.Entry<Long, List<SalaryStdMatchResult>> entry : matchTableResult.entrySet()) {
            Long personKey = entry.getKey();
            List<SalaryStdMatchResult> matchResult = entry.getValue();
            Map<Long, Object> propVersionValue = contrastPropValue.get(personKey);
            if (MapUtils.isEmpty(propVersionValue) || CollectionUtils.isEmpty(matchResult)) continue;
            for (SalaryStdMatchResult stdMatchResult : matchResult) {
                Map<Long, Object> personPropValue = stdMatchResult.getPersonPropValue();
                if (MapUtils.isEmpty(personPropValue)) continue;
                this.replaceWithVersionValue(propVersionValue, personPropValue);
            }
        }
    }

    private void replaceWithVersionValue(Map<Long, Object> propVersionValue, Map<Long, Object> personPropValue) {
        for (Long prop : personPropValue.keySet()) {
            Object versionValue = propVersionValue.get(prop);
            if (versionValue == null) continue;
            personPropValue.put(prop, versionValue);
        }
    }

    private Map<Long, Map<Long, Long>> matchCoefficientVersionId(Map<Long, Map<Long, DynamicObject>> matchScmEntryMap, Map<Long, Long> workplaceMap, Map<Long, Map<Long, Date>> personKeyItemToBsedMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)matchScmEntryMap.size());
        HashSet coefficientTabIds = Sets.newHashSet();
        for (Map<Long, DynamicObject> entry : matchScmEntryMap.values()) {
            for (DynamicObject object2 : entry.values()) {
                long coefficienttabId = object2.getLong("coefficienttabent.id");
                if (coefficienttabId <= 0L) continue;
                coefficientTabIds.add(coefficienttabId);
            }
        }
        Set coefficientTabIdsOfUsable = BaseDataHisHelper.getUsableId((String)"hcdm_coefficienttab", (Collection)coefficientTabIds);
        DynamicObject[] coefficientObjArr = new SWCDataServiceHelper("hcdm_coefficient").query("id,bsed,bsled,status,enable,admindivision,adminorg,coefficienttab", new QFilter[]{new QFilter("coefficienttab.id", "in", (Object)coefficientTabIdsOfUsable), BaseDataHisHelper.getHisVerFilter(), new QFilter("enable", "=", (Object)"1"), new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "1", "0"}))}, "bsed asc");
        Map<Long, List<DynamicObject>> coefficientMap = Arrays.stream(coefficientObjArr).collect(Collectors.groupingBy(object -> object.getLong("coefficienttab.id")));
        Date defaultBsed = SWCDateTimeUtils.getDayDate((Date)TimeServiceHelper.now());
        for (Map.Entry<Long, Map<Long, DynamicObject>> fileEntry : matchScmEntryMap.entrySet()) {
            Long personKey = fileEntry.getKey();
            Map itemResult = resultMap.computeIfAbsent(personKey, aLong -> Maps.newHashMapWithExpectedSize((int)((Map)fileEntry.getValue()).size()));
            Long admindivisionIdOfFile = workplaceMap.get(personKey);
            if (admindivisionIdOfFile == null) continue;
            Map itemToDateMap = personKeyItemToBsedMap.getOrDefault(personKey, Collections.emptyMap());
            for (Map.Entry<Long, DynamicObject> itemEntry : fileEntry.getValue().entrySet()) {
                Date itemBsed;
                Date paramDate;
                DynamicObject coefficientMatch;
                long coefficienttabId = itemEntry.getValue().getLong("coefficienttabent.id");
                List<DynamicObject> coefficientList = coefficientMap.get(coefficienttabId);
                if (CollectionUtils.isEmpty(coefficientList) || (coefficientMatch = this.findOneCoefficient(admindivisionIdOfFile, coefficientList, paramDate = (itemBsed = (Date)itemToDateMap.get(itemEntry.getKey())) == null ? defaultBsed : itemBsed)) == null) continue;
                itemResult.put(itemEntry.getKey(), coefficientMatch.getLong("id"));
            }
        }
        return resultMap;
    }

    private DynamicObject findOneCoefficient(Long admindivisionIdOfFile, List<DynamicObject> coefficientList, Date paramDate) {
        DynamicObject coefficientMatch = null;
        for (DynamicObject coefficient : coefficientList) {
            String dimensionValue = coefficient.getString("coefficienttab.dimension");
            Long admindivisionId = coefficient.getLong("admindivision.id");
            Date bsed = coefficient.getDate("bsed");
            Date bsled = coefficient.getDate("bsled");
            boolean belongAdmindivision = admindivisionIdOfFile != null && StringUtils.equals((CharSequence)String.valueOf(DimensionEnum.AdminDivision.getCode()), (CharSequence)dimensionValue) && admindivisionIdOfFile.equals(admindivisionId);
            boolean bsedIn = SWCDateTimeUtils.isCover((Date)paramDate, (Date)bsed, (Date)bsled);
            if (!belongAdmindivision || !bsedIn) continue;
            coefficientMatch = coefficient;
            break;
        }
        return coefficientMatch;
    }

    private Map<Long, Map<Long, DynamicObject>> matchScmEntry(Map<Long, Map<Long, DynamicObject>> personKeyItemToScmMap, Map<Long, Long> personKeyToStructureMap) {
        HashSet scmIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : personKeyItemToScmMap.entrySet()) {
            for (Map.Entry<Long, DynamicObject> subEntry : entry.getValue().entrySet()) {
                scmIds.add(subEntry.getValue().getLong("id"));
            }
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personKeyItemToScmMap.size());
        if (MapUtils.isEmpty(personKeyItemToScmMap)) {
            return resultMap;
        }
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : personKeyItemToScmMap.entrySet()) {
            Long personKey = entry.getKey();
            Map<Long, DynamicObject> itemToScmObjMap = entry.getValue();
            Map itemEntryMap = resultMap.computeIfAbsent(personKey, o1 -> Maps.newHashMap());
            Long structureId = personKeyToStructureMap.get(personKey);
            if (structureId == 0L || MapUtils.isEmpty(itemToScmObjMap)) continue;
            for (Map.Entry<Long, DynamicObject> itemEntry : itemToScmObjMap.entrySet()) {
                DynamicObject scmObj;
                DynamicObjectCollection entryRows;
                Long itemId = itemEntry.getKey();
                DynamicObject scmEntryRow = this.getScmEntryRow(structureId, itemId, entryRows = (scmObj = itemEntry.getValue()).getDynamicObjectCollection("entryentity"));
                if (scmEntryRow == null) continue;
                itemEntryMap.put(itemId, scmEntryRow);
            }
        }
        return resultMap;
    }

    private DynamicObject getScmEntryRow(Long structureId, Long itemId, DynamicObjectCollection entryRows) {
        for (DynamicObject entryRow : entryRows) {
            long salstructurentId = entryRow.getLong("salstructurent.id");
            long standarditemId = entryRow.getLong("standarditem.id");
            if (structureId != salstructurentId || itemId != standarditemId) continue;
            return entryRow;
        }
        return null;
    }

    private void batchReplaceGradeRankId(Collection<SalaryStdMatchResultNew> resultList) {
        HashSet stdIds = Sets.newHashSet();
        for (SalaryStdMatchResultNew stdMatchResult : resultList) {
            if (stdMatchResult == null || stdMatchResult.getStdTableVid() == null || stdMatchResult.getStdTableVid() <= 0L) continue;
            stdIds.add(stdMatchResult.getStdTableVid());
        }
        Map<Long, Map<Long, SalaryGradeEntity>> gradeMap = GradeRankHelper.queryGradeEntityMap(stdIds);
        Map<Long, Map<Long, SalaryRankEntity>> rankMap = GradeRankHelper.queryRankEntityMap(stdIds, false);
        for (SalaryStdMatchResultNew stdMatchResult : resultList) {
            if (stdMatchResult == null || stdMatchResult.getStdTableVid() == null || stdMatchResult.getStdTableVid() <= 0L) continue;
            this.replaceGradeRankEntityNew(stdMatchResult, gradeMap.get(stdMatchResult.getStdTableVid()), rankMap.get(stdMatchResult.getStdTableVid()));
        }
    }

    private void replaceGradeRankEntityNew(SalaryStdMatchResultNew stdMatchResult, Map<Long, SalaryGradeEntity> gradeEntityMapOfTabVid, Map<Long, SalaryRankEntity> rankEntityMapOfTabVid) {
        SalaryRankEntity salaryRankEntity;
        if (MapUtils.isEmpty((Map)stdMatchResult.getRangeData()) || MapUtils.isEmpty(gradeEntityMapOfTabVid)) {
            return;
        }
        LinkedHashMap replacedMap = Maps.newLinkedHashMapWithExpectedSize((int)stdMatchResult.getRangeData().size());
        for (Map.Entry entry : stdMatchResult.getRangeData().entrySet()) {
            Long gradeIdentity = (Long)entry.getKey();
            SalaryGradeEntity gradeEntity = gradeEntityMapOfTabVid.get(gradeIdentity);
            if (gradeEntity == null) continue;
            List rankIds = replacedMap.computeIfAbsent(gradeEntity.getId(), o1 -> Lists.newArrayList());
            if (((List)entry.getValue()).isEmpty() || MapUtils.isEmpty(rankEntityMapOfTabVid)) continue;
            for (Long rankIdentity : (List)entry.getValue()) {
                SalaryRankEntity rankEntity = rankEntityMapOfTabVid.get(rankIdentity);
                if (rankEntity == null) continue;
                rankIds.add(rankEntity.getId());
            }
        }
        stdMatchResult.setRangeData((Map)replacedMap);
        SalaryGradeEntity salaryGradeEntity = gradeEntityMapOfTabVid.get(stdMatchResult.getGradeId());
        if (!SWCObjectUtils.isEmpty((Object)salaryGradeEntity)) {
            stdMatchResult.setGradeId(salaryGradeEntity.getId());
        }
        if (!SWCObjectUtils.isEmpty((Object)(salaryRankEntity = rankEntityMapOfTabVid.get(stdMatchResult.getRankId())))) {
            stdMatchResult.setRankId(salaryRankEntity.getId());
        }
    }

    private SalaryStdMatchResult findSalaryStdMatchResult(List<SalaryStdMatchResult> tableMatchResults, long stdId) {
        if (CollectionUtils.isEmpty(tableMatchResults)) {
            return null;
        }
        for (SalaryStdMatchResult tableMatchResult : tableMatchResults) {
            if (null == tableMatchResult || null == tableMatchResult.getStdTableVid() || tableMatchResult.getStdTableVid() != stdId) continue;
            return tableMatchResult;
        }
        return null;
    }

    private Map<Long, List<SalaryStdMatchResult>> doMatchTable(Map<Long, Map<Long, Object>> contrastPropValue, Map<Long, List<Long>> personKeyToStdtableMap, Map<Long, List<ContrastPropConfigEntity>> stdPropCfg) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personKeyToStdtableMap.size());
        Set<Long> stdIds = stdPropCfg.keySet();
        long beginTime = TimeServiceHelper.now().getTime();
        SalaryStdMatchContext matchContext = this.getMatchContext();
        Map<Long, SalaryStandardEntryData> tabEntityMap = matchContext.getStdEntityMapFromThreadCache(stdIds);
        this.log.info("batchMatchStdTableWithAdjFile_cost doMatchTable_queryStdObj costtime {}", (Object)(TimeServiceHelper.now().getTime() - beginTime));
        HashMap rankMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap gradeIndexMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap rankIndexMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap gradeListMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        long beginTime1 = TimeServiceHelper.now().getTime();
        for (Map.Entry<Long, SalaryStandardEntryData> entry : tabEntityMap.entrySet()) {
            SalaryStandardEntryData tabEntity = entry.getValue();
            if (tabEntity.getContrastRowEntities().size() < 1000) {
                this.log.info("\u6807\u51c6\u8868{}\u5168\u91cf\u5bf9\u7167\u6570\u636e\uff08\u5305\u542b\u5e94\u7528\u8303\u56f4\uff09 : {}", (Object)entry.getKey(), (Object)JSON.toJSONString((Object)tabEntity.getContrastRowEntities()));
            }
            rankMap.put(entry.getKey(), GradeRankHelper.groupByRankIdentity(tabEntity.getRankEntities()));
            gradeIndexMap.put(entry.getKey(), GradeRankHelper.gradeMapByIndexAsc(tabEntity.getGradeEntities()));
            rankIndexMap.put(entry.getKey(), GradeRankHelper.rankMapByIndexAsc(GradeRankHelper.fetchStandardRank(tabEntity.getRankEntities())));
            gradeListMap.put(entry.getKey(), tabEntity.getGradeEntities());
        }
        this.log.info("\u591a\u4e2a\u4eba\u5458\u7684\u5168\u91cf\u5bf9\u7167\u5c5e\u6027\u503c: {}", (Object)JSON.toJSONString(contrastPropValue));
        this.log.info("batchMatchStdTableWithAdjFile_cost doMatchTable_prepareData costtime {}", (Object)(TimeServiceHelper.now().getTime() - beginTime1));
        for (Map.Entry<Long, Object> entry : personKeyToStdtableMap.entrySet()) {
            List matchResultsOfFile = resultMap.computeIfAbsent(entry.getKey(), o1 -> Lists.newArrayList());
            List curStdIds = (List)entry.getValue();
            Map<Long, Object> contrastPropValueOfFile = contrastPropValue.get(entry.getKey());
            for (Long stdId : curStdIds) {
                SalaryStandardEntryData standardEntryData = tabEntityMap.get(stdId);
                if (standardEntryData == null) continue;
                long onePersonBeginTime = TimeServiceHelper.now().getTime();
                List contrastRowEntities = standardEntryData.getContrastRowEntities();
                SalaryStdMatchResult salaryStdMatchResult = new SalaryStdMatchResult();
                salaryStdMatchResult.setNoMatchProp(Maps.newHashMap());
                salaryStdMatchResult.setTableUseRank(standardEntryData.getStdBaseEntity().isUseSalaryRank());
                salaryStdMatchResult.setStdTableVid(stdId);
                if (!MapUtils.isEmpty(contrastPropValueOfFile)) {
                    List<Integer> matchedRows = this.matchContrastRows(contrastPropValueOfFile, contrastRowEntities);
                    this.log.info("batchMatchStdTableWithAdjFile_cost doMatchTable_oneperson_checkContrastrow costtime {}", (Object)(TimeServiceHelper.now().getTime() - onePersonBeginTime));
                    List<GradeRankKey> gradeRankKeys = null;
                    Map<Long, Object> queryResult = this.getQueryResultByProps(contrastPropValueOfFile, stdPropCfg.get(stdId));
                    salaryStdMatchResult.setPersonPropValue(queryResult);
                    if (matchedRows.size() > 0) {
                        boolean isUseSalaryRank = standardEntryData.getStdBaseEntity().getIsUseSalaryRank() > 0;
                        gradeRankKeys = this.getGradeRankKey(contrastRowEntities, matchedRows, (Map)gradeIndexMap.get(stdId), (Map)rankIndexMap.get(stdId), (List)gradeListMap.get(stdId), (Map)rankMap.get(stdId), isUseSalaryRank);
                        if (CollectionUtils.isNotEmpty(gradeRankKeys)) {
                            salaryStdMatchResult.setRangeData(gradeRankKeys);
                        }
                    }
                }
                matchResultsOfFile.add(salaryStdMatchResult);
            }
        }
        return resultMap;
    }

    private List<Integer> matchContrastRows(Map<Long, Object> contrastPropValueOfFile, List<ContrastRowDataEntity> contrastRowEntities) {
        ArrayList matchedRows = Lists.newArrayListWithExpectedSize((int)contrastRowEntities.size());
        for (ContrastRowDataEntity rowDataEntity : contrastRowEntities) {
            Object queryResult;
            Map.Entry listEntry;
            List value;
            Integer row = rowDataEntity.getRowIndex();
            Map contrastDatas = rowDataEntity.getStdPropValueMap();
            int sum = 0;
            Iterator iterator = contrastDatas.entrySet().iterator();
            while (iterator.hasNext() && this.isMatch(value = (List)(listEntry = iterator.next()).getValue(), queryResult = contrastPropValueOfFile.get(listEntry.getKey()))) {
                ++sum;
            }
            if (sum < contrastDatas.size()) continue;
            matchedRows.add(row);
        }
        return matchedRows;
    }

    private Map<Long, Object> getQueryResultByProps(Map<Long, Object> queryResults, List<ContrastPropConfigEntity> configEntities) {
        if (CollectionUtils.isEmpty(configEntities)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)configEntities.size());
        for (ContrastPropConfigEntity entity : configEntities) {
            resultMap.put(entity.getId(), queryResults.get(entity.getId()));
        }
        return resultMap;
    }

    private List<GradeRankKey> getGradeRankKey(List<ContrastRowDataEntity> specialRowData, List<Integer> matchedRows, Map<Integer, SalaryGradeEntity> gradeMapByIndexAsc, Map<Integer, SalaryRankEntity> rankMapByIndexAsc, List<SalaryGradeEntity> gradeEntities, Map<Long, SalaryRankEntity> rankMap, boolean isUseSalaryRank) {
        List<Object> rangeData = Lists.newArrayListWithCapacity((int)10);
        Map map = specialRowData.stream().collect(Collectors.toMap(ContrastRowDataEntity::getRowIndex, Function.identity(), (o1, o2) -> o2));
        for (Integer matchedRow : matchedRows) {
            ContrastRowDataEntity rowDataEntity = (ContrastRowDataEntity)map.get(matchedRow);
            if (rowDataEntity == null || CollectionUtils.isEmpty((Collection)rowDataEntity.getRangeCode())) continue;
            this.log.info("\u83b7\u53d6\u5f53\u524d{}\u884c\u7684\u85aa\u7b49\u85aa\u6863\u539f\u59cb\u6570\u636e\u662f{}", (Object)JSON.toJSONString((Object)rowDataEntity.getRangeCode()));
            rangeData.addAll(rowDataEntity.getRangeCode());
        }
        rangeData = GradeRankHelper.unionRangeByCode((List<GradeRankValue>)rangeData);
        return GradeRankHelper.getGradeRankKeyFromRangeCode((List<GradeRankValue>)rangeData, rankMapByIndexAsc.size(), gradeMapByIndexAsc, rankMapByIndexAsc, rankMap, gradeEntities, isUseSalaryRank);
    }

    private boolean isMatch(List<Long> contrastValues, Object queryResult) {
        if (queryResult == null) {
            return false;
        }
        List pkIds = Collections.emptyList();
        if (queryResult instanceof Long) {
            pkIds = Collections.singletonList((Long)queryResult);
        }
        if (queryResult instanceof List) {
            pkIds = (List)queryResult;
        }
        for (Long val : contrastValues) {
            if (!pkIds.contains(val)) continue;
            return true;
        }
        return false;
    }

    public Map<Long, List<GradeRankKey>> assembleGradeAndRankByConfProp(List<SimpleMatchParam> params, Map<String, StdSimpleMatchResult> result, Set<Long> stdIds) {
        Map<Long, DynamicObject> tabObjMap = this.stdApplicationService.queryStdObj(stdIds, "salarystddata_a");
        HashMap tabEntityMap = Maps.newHashMapWithExpectedSize((int)tabObjMap.size());
        HashMap rankMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap gradeIndexMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap rankIndexMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap gradeListMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        HashMap rankListMap = Maps.newHashMapWithExpectedSize((int)tabEntityMap.size());
        for (Map.Entry<Long, DynamicObject> entry : tabObjMap.entrySet()) {
            SalaryStandardEntryData tabEntity = EntityConverter.fetchEntityFromModelWithEntryName(entry.getValue(), "salarystditem", "salarygrade", "salaryrank", "appliedrange", "contrastps", "contrastsumdata");
            tabEntityMap.put(entry.getKey(), tabEntity);
            List<SalaryRankEntity> salaryRankEntities = GradeRankHelper.fetchStandardRank(tabEntity.getRankEntities());
            this.log.info("\u6807\u51c6\u8868{}\u5168\u91cf\u5bf9\u7167\u6570\u636e\uff08\u5305\u542b\u5e94\u7528\u8303\u56f4\uff09 : {}", (Object)entry.getKey(), (Object)JSON.toJSONString((Object)tabEntity.getContrastRowEntities()));
            rankMap.put(entry.getKey(), GradeRankHelper.groupByRankIdentity(salaryRankEntities));
            gradeIndexMap.put(entry.getKey(), GradeRankHelper.gradeMapByIndexAsc(tabEntity.getGradeEntities()));
            rankIndexMap.put(entry.getKey(), GradeRankHelper.rankMapByIndexAsc(salaryRankEntities));
            gradeListMap.put(entry.getKey(), tabEntity.getGradeEntities());
            rankListMap.put(entry.getKey(), salaryRankEntities);
        }
        HashMap stdGradeRankLimitMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (SimpleMatchParam param : params) {
            SalaryStandardEntryData tabEntity;
            List rowDataEntitys;
            String uniqueCode = param.getUniqueCode();
            StdSimpleMatchResult stdSimpleMatchResult = result.get(uniqueCode);
            if (stdSimpleMatchResult != null) continue;
            stdSimpleMatchResult = new StdSimpleMatchResult();
            Long stdTableId = param.getStdTableId();
            Map propInfo = param.getPropInfo();
            if (propInfo == null || propInfo.size() == 0 || (rowDataEntitys = (tabEntity = (SalaryStandardEntryData)tabEntityMap.get(stdTableId)).getContrastRowEntities()) == null || rowDataEntitys.size() == 0) continue;
            stdSimpleMatchResult.setGradeList((List)gradeListMap.get(stdTableId));
            stdSimpleMatchResult.setRankList((List)rankListMap.get(stdTableId));
            ArrayList matchedRows = Lists.newArrayListWithExpectedSize((int)rowDataEntitys.size());
            HashMap noMatchProp = Maps.newHashMapWithExpectedSize((int)rowDataEntitys.size());
            this.singleMatch(stdTableId, propInfo, rowDataEntitys, matchedRows, noMatchProp);
            if (matchedRows.size() > 0) {
                boolean isUseSalaryRank = tabEntity.getStdBaseEntity().getIsUseSalaryRank() > 0;
                List<GradeRankKey> gradeRankKeys = this.getGradeRankKey(rowDataEntitys, matchedRows, (Map)gradeIndexMap.get(stdTableId), (Map)rankIndexMap.get(stdTableId), (List)gradeListMap.get(stdTableId), (Map)rankMap.get(stdTableId), isUseSalaryRank);
                List gradeRankMap = (List)stdGradeRankLimitMap.get(stdTableId);
                if (CollectionUtils.isNotEmpty(gradeRankKeys) && gradeRankMap == null) {
                    stdGradeRankLimitMap.put(stdTableId, gradeRankKeys);
                }
            }
            stdSimpleMatchResult.setStdTableId(stdTableId);
            stdSimpleMatchResult.setNoMatchProp((Map)noMatchProp);
            result.put(uniqueCode, stdSimpleMatchResult);
        }
        return stdGradeRankLimitMap;
    }

    private List<ContrastPropConfigEntity> mergeAndDistinct(Map<Long, List<ContrastPropConfigEntity>> propsGroup) {
        HashMap map = Maps.newHashMap();
        for (List<ContrastPropConfigEntity> subList : propsGroup.values()) {
            for (ContrastPropConfigEntity entity : subList) {
                map.putIfAbsent(entity.getId(), entity);
            }
        }
        return Lists.newArrayList(map.values());
    }

    private void singleMatch(Long stdTableId, Map<Long, List<Long>> propInfo, List<ContrastRowDataEntity> curStdContrastData, List<Integer> matchedRows, Map<Integer, List<Long>> noMatchProp) {
        for (ContrastRowDataEntity subEntry : curStdContrastData) {
            Integer row = subEntry.getRowIndex();
            Map contrastDatas = subEntry.getStdPropValueMap();
            int sum = 0;
            ArrayList notMatchPropOfCurrentRow = Lists.newArrayList();
            if (!propInfo.containsKey(1060L)) {
                contrastDatas.remove(1060L);
            }
            for (Map.Entry listEntry : contrastDatas.entrySet()) {
                List<Long> queryResult;
                List value = (List)listEntry.getValue();
                if (this.isMatch(value, queryResult = propInfo.get(listEntry.getKey()))) {
                    ++sum;
                    continue;
                }
                notMatchPropOfCurrentRow.add(listEntry.getKey());
            }
            if (sum >= contrastDatas.size()) {
                this.log.info("\u8bb0\u5f55\u5339\u914d\u7684\u5c5e\u6027\u4e2a\u6570:{}", (Object)sum);
                matchedRows.add(row);
                this.log.info("\u6807\u51c6\u8868{}\u5168\u90e8\u5339\u914d\u4e0a\u7684\u5f53\u524d\u884c\u662f\uff1a{}", (Object)stdTableId, (Object)row);
            } else {
                this.log.info("\u6807\u51c6\u8868{}\u5f53\u524d\u884c\u662f\uff1a{}\u6ca1\u6709\u5339\u914d\u4e0a,\u4e0d\u5339\u914d\u5c5e\u6027\u662f{}", new Object[]{stdTableId, row, JSON.toJSONString((Object)notMatchPropOfCurrentRow)});
            }
            if (notMatchPropOfCurrentRow.size() <= 0) continue;
            noMatchProp.put(row, notMatchPropOfCurrentRow);
        }
    }

    public Map<String, SimpleStdRangeMatchResult> matchRangeWithStdTableId(List<SimpleStdRangeMatchParam> params) {
        if (CollectionUtils.isEmpty(params = params.stream().filter(param -> StringUtils.isNotBlank((CharSequence)param.getUnionId()) && MapUtils.isNotEmpty((Map)param.getPropInfo()) && param.getStdTableId() != null && param.getStdTableId() > 0L).collect(Collectors.toList()))) {
            return Collections.emptyMap();
        }
        Set unionIds = params.stream().map(SimpleStdRangeMatchParam::getUnionId).collect(Collectors.toSet());
        if (unionIds.size() < params.size()) {
            throw new KDBizException("unionid is duplicated");
        }
        Set<Long> stdIds = params.stream().map(SimpleStdRangeMatchParam::getStdTableId).collect(Collectors.toSet());
        Long personKey = 0L;
        HashMap contrastPropValue = Maps.newHashMapWithExpectedSize((int)params.size());
        HashMap personKeyToStdTableMap = Maps.newHashMapWithExpectedSize((int)params.size());
        HashMap personKeyToBsedMap = Maps.newHashMapWithExpectedSize((int)params.size());
        Date defaultBsed = SWCDateTimeUtils.getDayDate((Date)TimeServiceHelper.now());
        for (SimpleStdRangeMatchParam simpleStdRangeMatchParam : params) {
            personKeyToStdTableMap.put(personKey, simpleStdRangeMatchParam.getStdTableId());
            HashMap propValueObjMap = Maps.newHashMapWithExpectedSize((int)simpleStdRangeMatchParam.getPropInfo().size());
            for (Map.Entry entry : simpleStdRangeMatchParam.getPropInfo().entrySet()) {
                propValueObjMap.put(entry.getKey(), entry.getValue());
            }
            Date bsed = simpleStdRangeMatchParam.getBsed() == null ? defaultBsed : simpleStdRangeMatchParam.getBsed();
            personKeyToBsedMap.put(personKey, bsed);
            contrastPropValue.put(personKey, propValueObjMap);
            Long l = personKey;
            personKey = personKey + 1L;
            Long l2 = personKey;
        }
        Map<Long, List<DynamicObject>> stdBoIdToVersionObjMap = this.stdApplicationService.queryStdVersionObjWithBoId(stdIds);
        Map<Long, DynamicObject> map = this.stdApplicationService.queryStdVersionObjWithVid(stdIds);
        Map<Long, Long> personKeyToStdVersion = this.matchStdVersionWithBsedNoItem(personKeyToBsedMap, personKeyToStdTableMap, stdBoIdToVersionObjMap, map);
        HashSet needMatchStdVersionIds = Sets.newHashSet(personKeyToStdVersion.values());
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (Map.Entry<Long, Long> entry : personKeyToStdVersion.entrySet()) {
            hashMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)params.size());
        Map<Long, List<ContrastPropConfigEntity>> propsGroup = ContrastDataHelper.queryContrastProps(needMatchStdVersionIds);
        Map<Long, List<SalaryStdMatchResult>> matchTableResult = this.doMatchTable(contrastPropValue, hashMap, propsGroup);
        personKey = 0L;
        for (SimpleStdRangeMatchParam simpleStdRangeMatchParam : params) {
            List<SalaryStdMatchResult> salaryStdMatchResults = matchTableResult.get(personKey);
            if (CollectionUtils.isNotEmpty(salaryStdMatchResults)) {
                SalaryStdMatchResult stdMatchResult = salaryStdMatchResults.get(0);
                SimpleStdRangeMatchResult simpleStdRangeMatchResult = new SimpleStdRangeMatchResult();
                simpleStdRangeMatchResult.setUnionId(simpleStdRangeMatchParam.getUnionId());
                simpleStdRangeMatchResult.setNoMatchProp(stdMatchResult.getNoMatchProp());
                simpleStdRangeMatchResult.setStdTableVid(stdMatchResult.getStdTableVid());
                Map<Long, List<Long>> rangeData = GradeRankHelper.groupByRangeKeyToIdMap(stdMatchResult.getRangeData());
                if (!stdMatchResult.isTableUseRank()) {
                    for (Map.Entry<Long, List<Long>> entry : rangeData.entrySet()) {
                        entry.setValue(Collections.emptyList());
                    }
                }
                simpleStdRangeMatchResult.setRangeData(rangeData);
                resultMap.put(simpleStdRangeMatchParam.getUnionId(), simpleStdRangeMatchResult);
            }
            Long l = personKey;
            Long l3 = personKey = Long.valueOf(personKey + 1L);
        }
        return resultMap;
    }
}

