/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.mq;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.swc.hcdm.business.activity.candsetsal.CandSetSalActDynHelper;
import kd.swc.hcdm.business.activity.dealer.ActivityDealer;
import kd.swc.hcdm.business.activity.msg.ActivityMsgHelper;
import kd.swc.hcdm.business.mq.HRMessagePublisher;
import kd.swc.hcdm.common.enums.ActivityMsgSceneEnum;
import org.apache.commons.lang3.StringUtils;

public class CandSetSalActConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(CandSetSalActConsumer.class);
    private static final String INSTANCE_ID = "instanceId";
    private static final String BIZ_BILL_ID = "bizBillId";
    private static final String BIND_BIZ_KEY = "bindBizKey";
    private static final String BIZ_BILL_KEY = "bizBillKey";
    private static final String MSGPUBNUM_CANDSETSAL = "MP20230720001094";
    private static final Long ACTION_ID_CANDSETSAL = 1733405590534784000L;

    public void onMessage(Object msg, String msgId, boolean resend, MessageAcker acker) {
        this.dealMessage(msg, msgId, resend, acker);
    }

    public void dealMessage(Object msg, String msgId, boolean resend, MessageAcker acker) {
        Long instanceId = 0L;
        try {
            logger.info("CandSetSalActConsumer onMessage start msg: {}", msg);
            Map messageObj = HRJSONUtils.convertJSONObjectToMap((Object)msg);
            Long bizBillId = HRJSONUtils.getLongValOfCustomParam(messageObj.get(BIZ_BILL_ID));
            String bizBillKey = String.valueOf(messageObj.get(BIZ_BILL_KEY));
            String bindBizKey = String.valueOf(messageObj.get(BIND_BIZ_KEY));
            instanceId = HRJSONUtils.getLongValOfCustomParam(messageObj.get(INSTANCE_ID));
            ActivityDealer activityDealer = ActivityDealer.getActivityDealer(bindBizKey);
            DynamicObject[] bizActDyns = CandSetSalActDynHelper.queryByOnbrdInfoIds(Lists.newArrayList((Object[])new Long[]{bizBillId}));
            if (bizActDyns != null && bizActDyns.length != 0) {
                ArrayList cancelActDyns = Lists.newArrayListWithCapacity((int)bizActDyns.length);
                for (DynamicObject bizActDyn : bizActDyns) {
                    String actStatus = bizActDyn.getString("activitybase.activitystatus");
                    if (!StringUtils.equals((CharSequence)actStatus, (CharSequence)"40") && instanceId.equals(bizActDyn.getLong("activitybase.activityins.id"))) {
                        logger.info("CandSetSalActConsumer onMessage repeat msg: {}", msg);
                        return;
                    }
                    cancelActDyns.add(bizActDyn);
                }
                if (!CollectionUtils.isEmpty((Collection)cancelActDyns)) {
                    activityDealer.batchCancelActivity(cancelActDyns.toArray(new DynamicObject[cancelActDyns.size()]), "1");
                }
            }
            activityDealer.generateActivity(bindBizKey, bizBillKey, bizBillId, instanceId);
            this.sendCandSetSalMsg(bizBillId, messageObj);
        }
        catch (Exception ext) {
            logger.info("CandSetSalActConsumer onMessage msg: {}; error: {}", msg, (Object)ext);
            if (!(ext instanceof KDBizException) && !ActivityMsgSceneEnum.GENERATE_NUMBER_ERROR.getSceneCode().equals(((KDBizException)((Object)ext)).getErrorCode().getCode())) {
                ActivityMsgHelper.sendMsgByInstanceId(instanceId, ActivityMsgSceneEnum.GENERATE_START_ERROR);
            }
            acker.deny(msgId);
        }
    }

    private void sendCandSetSalMsg(Long bizBillId, Map<String, Object> msg) {
        try {
            String msgNumber = String.format("%s_%s", bizBillId, System.currentTimeMillis());
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u5355%s\u5f00\u59cb\u5019\u9009\u4eba\u5b9a\u85aa", (String)"CandSetSalActConsumer_0", (String)"swc-hcdm-business", (Object[])new Object[0]), bizBillId);
            HRMessagePublisher.sendActionMessage(msgNumber, MSGPUBNUM_CANDSETSAL, title, ACTION_ID_CANDSETSAL, msg);
        }
        catch (Exception e) {
            logger.error("CandSetSalActConsumer sendCandSetSalMsg error:", (Throwable)e);
        }
    }
}

