/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.mq;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;

public class HRMessagePublisher {
    private static final Log LOGGER = LogFactory.getLog(HRMessagePublisher.class);
    static final String MSGNUMBER = "msgNumber";
    static final String MSGPUBNO = "msgPubNo";
    static final String MSGTITLE = "msgTitle";
    static final String MSGDESC = "msgDesc";
    static final String ACTIONID = "actionId";
    static final String MSGTAG = "msgTag";
    static final String SENDERID = "senderId";
    static final String SENDTIME = "sendTime";
    static final String PARAMS = "params";

    public static void sendActionMessage(String msgNumber, String msgPubNo, String msgTitle, Long actionId, Map<String, Object> content) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
        messageParams.put(MSGNUMBER, msgNumber);
        messageParams.put(MSGPUBNO, msgPubNo);
        messageParams.put(MSGTITLE, msgTitle);
        messageParams.put(ACTIONID, actionId);
        messageParams.put(SENDERID, RequestContext.get().getCurrUserId());
        messageParams.put(SENDTIME, new Date());
        messageParams.put(PARAMS, SerializationUtils.serializeToBase64(content));
        LOGGER.info(MessageFormat.format("sendActionMessage======params:{0}", JSONObject.toJSONString(messageParams)));
        try {
            HRProducerServiceHelper.publishAction(messageParams);
        }
        catch (Exception exception) {
            LOGGER.error("HRMessagePublisher sendActionMessage error:", (Throwable)exception);
        }
    }
}

