/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.person;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.person.IHCDMPersonExtService;
import kd.swc.hcdm.business.person.HCDMPersonExtService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class HCDMPersonServiceHelper {
    private static final Log LOG = LogFactory.getLog(HCDMPersonServiceHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";
    private static final String KEY_DATA = "data";
    private static final int BATCH_SIZE_MAX = 10000;
    private static final String KEY_DEALINFO = "dealInfo";
    private static final String ENTITY_DATAUPDATELOG = "hcdm_dataupdatelog";
    private static final String MAINOP = "modifyPersonNumber";
    private static final String CHILDOP = "hcdm";

    public Map<String, Object> modifyPersonNumber(Map<String, Object> param) {
        LOG.info("call...HCDMPersonServiceHelper.modifyPersonNumber...begin...{}", (Object)SerializationUtils.toJsonString(param));
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (!param.containsKey(KEY_DEALINFO)) {
            param.put(KEY_DEALINFO, new LinkedHashMap(16));
        }
        if (!param.containsKey("batchnum")) {
            param.put("batchnum", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSSS"));
        }
        try {
            if (!this.validateParam(param)) {
                throw new RuntimeException(String.valueOf(result.get(KEY_MSG)));
            }
            this.dealModifyPersonNumberExt(param);
            this.dealModifyPersonNumberHCDM(param);
            result.put(KEY_SUCCESS, Boolean.TRUE);
            result.put(KEY_DATA, param);
            this.generateSuccessLog(param);
        }
        catch (Exception ex) {
            LOG.error("call...HCDMPersonServiceHelper.modifyPersonNumber...runerror...", (Throwable)ex);
            result.put(KEY_SUCCESS, Boolean.FALSE);
            String msg = ex.getMessage();
            if (msg != null && msg.length() >= 497) {
                msg = msg.substring(0, 497) + "...";
            }
            result.put(KEY_MSG, msg);
            this.generateFailLog(param, msg);
        }
        LOG.info("call...HCDMPersonServiceHelper.modifyPersonNumber...end...{}", (Object)SerializationUtils.toJsonString(param));
        return result;
    }

    private void generateFailLog(Map<String, Object> param, String msg) {
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(ENTITY_DATAUPDATELOG);
        DynamicObject logDy = logHelper.generateEmptyDynamicObject();
        logDy.set("batchnum", param.get("batchnum"));
        logDy.set("mainop", (Object)MAINOP);
        logDy.set("childop", (Object)CHILDOP);
        logDy.set("updatestatus", (Object)"F");
        logDy.set("logdatatype", (Object)"T");
        logDy.set("errormsg", (Object)msg);
        logDy.set("remark", (Object)SerializationUtils.toJsonString(param));
        logHelper.saveOne(logDy);
    }

    private void generateSuccessLog(Map<String, Object> param) {
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(ENTITY_DATAUPDATELOG);
        DynamicObject logDy = logHelper.generateEmptyDynamicObject();
        logDy.set("batchnum", param.get("batchnum"));
        logDy.set("mainop", (Object)MAINOP);
        logDy.set("childop", (Object)CHILDOP);
        logDy.set("updatestatus", (Object)"S");
        logDy.set("logdatatype", (Object)"T");
        logDy.set("remark", (Object)SerializationUtils.toJsonString(param));
        logHelper.saveOne(logDy);
    }

    private void dealModifyPersonNumberHCDM(Map<String, Object> param) {
        try (TXHandle txHandle = TX.required();){
            List datas = (List)param.get(KEY_DATA);
            HashSet<String> oriNumbers = new HashSet<String>(16);
            HashMap<String, String> numberMap = new HashMap<String, String>(16);
            for (Map data : datas) {
                String oriNumber = String.valueOf(data.get("oriNumber"));
                String newNumber = String.valueOf(data.get("newNumber"));
                oriNumbers.add(oriNumber);
                numberMap.put(oriNumber, newNumber);
            }
            this.dealModifyPersonNumberForEntityEqual(param, oriNumbers, numberMap, "hcdm_adjapprperson", "number");
            this.dealModifyPersonNumberForEntityEqual(param, oriNumbers, numberMap, "hcdm_decadjrelperson", "empnumber");
            this.dealModifyPersonNumberForEntityRel(param, oriNumbers, numberMap, "hcdm_singlecandsetsalappl", "employeeno", "candsetsalperson");
            txHandle.commit();
        }
    }

    private boolean validateParam(Map<String, Object> param) {
        List datas = (List)param.get(KEY_DATA);
        if (datas == null) {
            LOG.info("call...dealModifyPersonNumber...end...datas is null");
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, "data is null");
            return false;
        }
        LOG.info("call...dealModifyPersonNumber...end...datas.size={}...", (Object)datas.size());
        if (datas.size() > 10000) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, "data size over 10000");
            return false;
        }
        if (datas.size() <= 30) {
            LOG.info("call...dealModifyPersonNumber...end...param={}...", (Object)SerializationUtils.toJsonString(param));
        }
        return true;
    }

    private DynamicObject[] dealModifyPersonNumberForEntityRel(Map<String, Object> param, Set<String> oriNumbers, Map<String, String> numberMap, String entityNumber, String propertyName, String entryName) {
        DynamicObject[] dataDys;
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(ENTITY_DATAUPDATELOG);
        ArrayList<DynamicObject> logDys = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter(entryName + "." + propertyName, "in", oriNumbers);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper(entityNumber);
        for (DynamicObject empDy : dataDys = empHelper.query(propertyName, new QFilter[]{qFilter})) {
            DynamicObjectCollection ents = empDy.getDynamicObjectCollection(entryName);
            for (DynamicObject ent : ents) {
                String oriVal = ent.getString(propertyName);
                String newVal = numberMap.get(oriVal);
                if (newVal == null) continue;
                ent.set(propertyName, (Object)newVal);
                DynamicObject logDy = logHelper.generateEmptyDynamicObject();
                logDy.set("batchnum", param.get("batchnum"));
                logDy.set("mainop", (Object)MAINOP);
                logDy.set("childop", (Object)CHILDOP);
                logDy.set("entityNumber", (Object)entityNumber);
                logDy.set("field", (Object)propertyName);
                logDy.set("updatestatus", (Object)"S");
                logDy.set("logdatatype", (Object)"D");
                logDy.set("dataid", ent.get("id"));
                logDy.set("orivalue", (Object)oriVal);
                logDy.set("newvalue", (Object)newVal);
                logDys.add(logDy);
            }
        }
        empHelper.update(dataDys);
        logHelper.save(logDys.toArray(new DynamicObject[0]));
        Map resultMap = (Map)param.get(KEY_DEALINFO);
        resultMap.put(entityNumber + "#" + propertyName, dataDys.length);
        return dataDys;
    }

    private DynamicObject[] dealModifyPersonNumberForEntityEqual(Map<String, Object> param, Set<String> oriNumbers, Map<String, String> numberMap, String entityNumber, String propertyName) {
        DynamicObject[] dataDys;
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(ENTITY_DATAUPDATELOG);
        ArrayList<DynamicObject> logDys = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter(propertyName, "in", oriNumbers);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper(entityNumber);
        for (DynamicObject empDy : dataDys = empHelper.query(propertyName, new QFilter[]{qFilter})) {
            String oriVal = empDy.getString(propertyName);
            String newVal = numberMap.get(empDy.get(propertyName));
            empDy.set(propertyName, (Object)newVal);
            DynamicObject logDy = logHelper.generateEmptyDynamicObject();
            logDy.set("batchnum", param.get("batchnum"));
            logDy.set("mainop", (Object)MAINOP);
            logDy.set("childop", (Object)CHILDOP);
            logDy.set("entityNumber", (Object)entityNumber);
            logDy.set("field", (Object)propertyName);
            logDy.set("updatestatus", (Object)"S");
            logDy.set("logdatatype", (Object)"D");
            logDy.set("dataid", empDy.get("id"));
            logDy.set("orivalue", (Object)oriVal);
            logDy.set("newvalue", (Object)newVal);
            logDys.add(logDy);
        }
        empHelper.update(dataDys);
        logHelper.save(logDys.toArray(new DynamicObject[0]));
        Map resultMap = (Map)param.get(KEY_DEALINFO);
        resultMap.put(entityNumber + "#" + propertyName, dataDys.length);
        return dataDys;
    }

    private void dealModifyPersonNumberExt(Map<String, Object> param) {
        HCDMPersonExtService IHCDMPersonExtService2 = new HCDMPersonExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)IHCDMPersonExtService2, IHCDMPersonExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.person.IPersonExtService#modifyPersonNumber", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.modifyPersonNumber(param);
            return null;
        });
    }
}

