/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.TimeReportColumn;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hcdm.business.report.validator.AdjFileRptQueryValidator;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.common.entity.report.AdjFileReportEntity;
import kd.swc.hcdm.common.entity.report.HCDMRptDisplayEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjDetailReportDisplayHelper {
    private static final DBRoute ROUETE_HCDM = new DBRoute("hcdm");
    private static final String ALGO_KEY = "QueryServiceHelper.";
    private static final Log logger = LogFactory.getLog(AdjDetailReportDisplayHelper.class);

    public static DynamicObject queryRptDisplaySchemeObj(Long pkId) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_detaildisplay");
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_detaildisplay");
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public static List<RptDisplayColumnEntity> buildConfigForQuery(DynamicObject displayScheme, List<String> groupColumns, List<String> sumColumns) {
        ArrayList<RptDisplayColumnEntity> columns = new ArrayList<RptDisplayColumnEntity>(10);
        if (SWCObjectUtils.isEmpty((Object)displayScheme)) {
            return columns;
        }
        DynamicObjectCollection colls = displayScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject coll : colls) {
            if (null != groupColumns && coll.getBoolean("isdimension")) {
                groupColumns.add(coll.getString("fieldvalue"));
            }
            if (null != sumColumns && !coll.getBoolean("isdimension")) {
                sumColumns.add(coll.getString("fieldvalue"));
            }
            columns.add((RptDisplayColumnEntity)AdjDetailReportDisplayHelper.getOneConfig(coll));
        }
        return columns;
    }

    private static HCDMRptDisplayEntity getOneConfig(DynamicObject coll) {
        String fieldName = coll.getString("fieldname");
        String displayName = coll.getString("displayname");
        HCDMRptDisplayEntity rptEntity = new HCDMRptDisplayEntity();
        rptEntity.setFieldAlias(coll.getString("fieldalias"));
        rptEntity.setFieldValue(coll.getString("fieldvalue"));
        rptEntity.setFieldName(fieldName);
        rptEntity.setDisplayName(SWCStringUtils.isEmpty((String)displayName) ? fieldName : displayName);
        rptEntity.setSecondaryHeader(coll.getString("secondaryheader"));
        rptEntity.setFieldType(coll.getString("fieldtype"));
        rptEntity.setIsDefault(coll.getBoolean("isdefault"));
        rptEntity.setColumnWidth(coll.getInt("columnwidth"));
        rptEntity.setAlignment(coll.getString("alignment"));
        rptEntity.setFreeze(coll.getBoolean("freeze"));
        rptEntity.setSortIndex(coll.getString("sort"));
        rptEntity.setSortType(coll.getString("sorttype"));
        return rptEntity;
    }

    public static List<AbstractReportColumn> getColumns(List<RptDisplayColumnEntity> entityList, List<AbstractReportColumn> columns) {
        HashMap<String, ReportColumnGroup> secondaryHeaderMap = new HashMap<String, ReportColumnGroup>(16);
        for (RptDisplayColumnEntity entity : entityList) {
            ReportColumn reportColumn = AdjDetailReportDisplayHelper.getReportColumnByDisplayEntity(entity);
            String secondaryHeader = entity.getSecondaryHeader();
            if (SWCStringUtils.isNotEmpty((String)secondaryHeader)) {
                ReportColumnGroup group = (ReportColumnGroup)secondaryHeaderMap.get(secondaryHeader);
                if (group == null) {
                    group = new ReportColumnGroup();
                    group.setFieldKey(secondaryHeader);
                    group.setCaption(new LocaleString(secondaryHeader));
                    secondaryHeaderMap.put(secondaryHeader, group);
                    columns.add((AbstractReportColumn)group);
                }
                entity.getFieldValue();
                reportColumn.setHideSingleColumnRow(false);
                group.getChildren().add(reportColumn);
                continue;
            }
            entity.getFieldValue();
            columns.add((AbstractReportColumn)reportColumn);
        }
        return columns;
    }

    public static ReportColumn getReportColumnByDisplayEntity(RptDisplayColumnEntity entity) {
        ColumnStyle style;
        Map<String, List<ValueMapItem>> comboMap = AdjDetailReportDisplayHelper.loadCombo();
        ReportColumn reportColumn = AdjDetailReportDisplayHelper.setFieldInfo(entity, comboMap);
        reportColumn.setCaption(new LocaleString(SWCStringUtils.isEmpty((String)entity.getDisplayName()) ? entity.getFieldName() : entity.getDisplayName()));
        reportColumn.setFieldKey(entity.getFieldAlias());
        int columnWidth = entity.getColumnWidth();
        if (columnWidth > 0) {
            reportColumn.setWidth(new LocaleString(columnWidth + "px"));
        }
        if ((style = reportColumn.getStyle()) == null) {
            style = new ColumnStyle();
        }
        style.setTextAlign(entity.getAlignment());
        reportColumn.setStyle(style);
        if (entity instanceof HCDMRptDisplayEntity) {
            reportColumn.setFreeze(((HCDMRptDisplayEntity)entity).isFreeze());
        }
        return reportColumn;
    }

    public static Map<String, List<ValueMapItem>> loadCombo() {
        HashMap<String, List<ValueMapItem>> map = new HashMap<String, List<ValueMapItem>>(16);
        MainEntityType salaryAdjRecord = EntityMetadataCache.getDataEntityType((String)"hcdm_salaryadjrecord");
        Map salaryAdjRecordFields = salaryAdjRecord.getAllFields();
        for (Map.Entry entry : salaryAdjRecordFields.entrySet()) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entry.getValue();
            if (!(iDataEntityProperty instanceof ComboProp)) continue;
            map.put((String)entry.getKey(), ((ComboProp)iDataEntityProperty).getComboItems());
        }
        MainEntityType salaryAdjRelPerson = EntityMetadataCache.getDataEntityType((String)"hcdm_decadjrelperson");
        Map salaryAdjRelPersonFields = salaryAdjRelPerson.getAllFields();
        for (Map.Entry entry : salaryAdjRelPersonFields.entrySet()) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entry.getValue();
            if (!(iDataEntityProperty instanceof ComboProp)) continue;
            map.put("hcdm_decadjrelperson." + (String)entry.getKey(), ((ComboProp)iDataEntityProperty).getComboItems());
        }
        MainEntityType adjFileInfo = EntityMetadataCache.getDataEntityType((String)"hcdm_adjfileinfo");
        Map map2 = adjFileInfo.getAllFields();
        for (Map.Entry entry : map2.entrySet()) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entry.getValue();
            if (!(iDataEntityProperty instanceof ComboProp)) continue;
            map.put("hcdm_adjfileinfo." + (String)entry.getKey(), ((ComboProp)iDataEntityProperty).getComboItems());
        }
        return map;
    }

    private static ReportColumn setFieldInfo(RptDisplayColumnEntity entity, Map<String, List<ValueMapItem>> comboMap) {
        ReportColumn reportColumn;
        String fieldType;
        switch (fieldType = entity.getFieldType()) {
            case "combofield": {
                List<ValueMapItem> items = comboMap.get(entity.getFieldAlias());
                if (items != null) {
                    reportColumn = new ComboReportColumn();
                    reportColumn.setFieldType("combofield");
                    ((ComboReportColumn)reportColumn).setComboItems(items);
                    break;
                }
                reportColumn = new ReportColumn();
                reportColumn.setFieldType("text");
                break;
            }
            case "amount": {
                reportColumn = new ReportColumn();
                reportColumn.setFieldType("amount");
                reportColumn.setNoDisplayScaleZero(false);
                reportColumn.setCurrencyField("currency.id");
                reportColumn.setZeroShow(true);
                break;
            }
            case "currency": {
                reportColumn = new ReportColumn();
                reportColumn.setFieldType("currency");
                reportColumn.setEntityId("bd_currency");
                reportColumn.setDisplayProp("name");
                reportColumn.setHide(false);
                break;
            }
            case "decimal": {
                reportColumn = new DecimalReportColumn();
                reportColumn.setFieldType("decimal");
                reportColumn.setNoDisplayScaleZero(true);
                reportColumn.setZeroShow(true);
                break;
            }
            case "date": {
                reportColumn = new TimeReportColumn();
                reportColumn.setFieldType("date");
                break;
            }
            case "integer": {
                reportColumn = new ReportColumn();
                reportColumn.setFieldType("integer");
                reportColumn.setZeroShow(true);
                break;
            }
            default: {
                reportColumn = new ReportColumn();
                reportColumn.setFieldType("text");
            }
        }
        return reportColumn;
    }

    public DataSet buildDetailDataSet(QueryEntityType queryEntityType, List<Long> pkList, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, String> dataTypeMap) {
        if (!new HashSet<String>(calPersonFields).contains("relpersonid")) {
            calPersonFields.add("relpersonid");
        }
        String selectProperties = String.join((CharSequence)",", calPersonFields);
        logger.info("CalPersonQueryHelper#buildDetailDataSet: {}", (Object)selectProperties);
        QFilter qFilter = new QFilter("id", "in", pkList);
        long startTime = System.currentTimeMillis();
        DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, selectProperties, new QFilter[]{qFilter}, "");
        long endTime = System.currentTimeMillis();
        logger.info("CalPersonQueryHelper buildDetailDataSet\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        if (dataSet == null) {
            return null;
        }
        return dataSet;
    }

    public static QFilter buildPersonFilter(String personFieldStr) {
        if (StringUtils.isEmpty((CharSequence)personFieldStr)) {
            return null;
        }
        String[] personFilters = personFieldStr.split(";");
        QFilter qFilter = null;
        for (int i = 0; i < personFilters.length; ++i) {
            String filterStr = '%' + personFilters[i] + '%';
            if (qFilter == null) {
                qFilter = new QFilter("hcdm_decadjrelperson.empnumber", "like", (Object)filterStr);
                qFilter.or("hcdm_decadjrelperson.personname", "like", (Object)filterStr);
                continue;
            }
            qFilter.or("hcdm_decadjrelperson.empnumber", "like", (Object)filterStr);
            qFilter.or("hcdm_decadjrelperson.personname", "like", (Object)filterStr);
        }
        return qFilter;
    }

    public static ValidatorTree getAdjFileRptQueryValidatorTree(ValidateContext<AdjFileReportEntity> validateContext) {
        ValidatorTree tree = new ValidatorTree();
        tree.addNode(tree.getRoot(), new ValidatorTree.ValidatorNode(new AdjFileRptQueryValidator(validateContext, ErrorLevel.FatalError)));
        return tree;
    }

    public static DataType getAlgoDataType(String fieldType) {
        BigDecimalType dataType;
        switch (fieldType) {
            case "decimal": 
            case "amount": {
                dataType = DataType.BigDecimalType;
                break;
            }
            case "date": {
                dataType = DataType.DateType;
                break;
            }
            case "integer": {
                dataType = DataType.IntegerType;
                break;
            }
            case "currency": {
                dataType = DataType.LongType;
                break;
            }
            default: {
                dataType = DataType.StringType;
            }
        }
        return dataType;
    }

    public static DataSet buildDataSet(RowMeta rowMeta, List<Map<String, Object>> dataList, String algoKey) {
        String[] fieldNames = rowMeta.getFieldNames();
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        if (!CollectionUtils.isEmpty(dataList)) {
            for (Map<String, Object> valueMap : dataList) {
                Object[] values = new Object[fieldNames.length];
                for (int i = 0; i < fieldNames.length; ++i) {
                    values[i] = valueMap.get(fieldNames[i]);
                }
                dataSetBuilder.append(values);
            }
        }
        return dataSetBuilder.build();
    }

    public static Map<String, QueryEntityTreeNode> buildQueryEntityTopTreeNode() {
        HashMap<String, QueryEntityTreeNode> topMap = new HashMap<String, QueryEntityTreeNode>(16);
        QueryEntityTreeNode queryEntityTreeNode = new QueryEntityTreeNode();
        queryEntityTreeNode.setEntityName(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848", (String)"AdjFileFormHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        queryEntityTreeNode.setEntityNumber("1");
        queryEntityTreeNode.setEntityAlias("salaryadjfile");
        topMap.put("salaryadjfile", queryEntityTreeNode);
        return topMap;
    }

    public static Map<String, QueryEntityTreeNode> buildQueryEntityChildTreeNode(List<QueryEntityTreeNode> childNode) {
        HashMap<String, QueryEntityTreeNode> childMap = new HashMap<String, QueryEntityTreeNode>(16);
        QueryEntityTreeNode salaryAdjBaseNode = new QueryEntityTreeNode();
        salaryAdjBaseNode.setEntityName(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AdjFileFormHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]));
        salaryAdjBaseNode.setEntityNumber("2");
        salaryAdjBaseNode.setEntityAlias("salaryadjbase");
        childNode.add(salaryAdjBaseNode);
        childMap.put("salaryadjbase", salaryAdjBaseNode);
        QueryEntityTreeNode salaryAdjTreeNode = new QueryEntityTreeNode();
        salaryAdjTreeNode.setEntityName(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u4fe1\u606f", (String)"AdjFileFormHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]));
        salaryAdjTreeNode.setEntityNumber("3");
        salaryAdjTreeNode.setEntityAlias("salaryadj");
        childNode.add(salaryAdjTreeNode);
        childMap.put("salaryadj", salaryAdjTreeNode);
        QueryEntityTreeNode salaryAdjRelTreeNode = new QueryEntityTreeNode();
        salaryAdjRelTreeNode.setEntityName(ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u4f9d\u636e\u4fe1\u606f", (String)"AdjFileFormHelper_3", (String)"swc-hcdm-business", (Object[])new Object[0]));
        salaryAdjRelTreeNode.setEntityNumber("4");
        salaryAdjRelTreeNode.setEntityAlias("salaryadjrel");
        childNode.add(salaryAdjRelTreeNode);
        childMap.put("salaryadjrel", salaryAdjRelTreeNode);
        return childMap;
    }
}

