/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hcdm.business.extpoint.report.IAdjDetailRptExtService;
import kd.sdk.swc.hcdm.business.extpoint.report.event.AdjDetailQueryParamEvent;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.report.AdjDetailReportDisplayHelper;
import kd.swc.hcdm.business.report.FieldMappingHelper;
import kd.swc.hcdm.business.report.entity.AdjDetailRptColumnInfo;
import kd.swc.hcdm.business.report.entity.AdjDetailRptQueryInfo;
import kd.swc.hcdm.business.report.service.AdjDetailRptQueryExtService;
import kd.swc.hcdm.common.enums.AdjFileStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjDetailRptHelper {
    private static final String HCDM_ADJDETAILREPORT = "hcdm_adjdetailreport";
    private static final String HCDM_ADJRECORDRPTQENTITY = "hcdm_adjrecordrptqentity";
    private static final Log logger = LogFactory.getLog(AdjDetailRptHelper.class);
    public static final int DECIMAL_PRECISION = 23;
    public static final int DECIMAL_SCALE = 4;
    public static final String KEY_ORG = "org";

    public AdjDetailRptQueryInfo handleRptQueryParam(ReportQueryParam queryParam) {
        AdjDetailRptQueryInfo salRptQueryInfo = new AdjDetailRptQueryInfo();
        salRptQueryInfo.setReportEntityCode(HCDM_ADJDETAILREPORT);
        salRptQueryInfo.setQueryEntityCode(HCDM_ADJRECORDRPTQENTITY);
        salRptQueryInfo.setPermEntityCode(HCDM_ADJRECORDRPTQENTITY);
        FilterInfo filterInfo = queryParam.getFilter();
        salRptQueryInfo.setPageId((String)queryParam.getCustomParam().get("pageid"));
        this.buildFilters(filterInfo, salRptQueryInfo);
        this.addExtFilter(queryParam, salRptQueryInfo.getFilters());
        this.setColumnInfoList(filterInfo, salRptQueryInfo);
        this.afterSetColumnInfoList(salRptQueryInfo);
        this.buildEmptyFilters(salRptQueryInfo);
        return salRptQueryInfo;
    }

    private void buildEmptyFilters(AdjDetailRptQueryInfo salRptQueryInfo) {
        Map<String, String> dataTypeMap = salRptQueryInfo.getDataTypeMap();
        List<QFilter> filters = salRptQueryInfo.getFilters();
        for (QFilter filter : filters) {
            if (SWCObjectUtils.isEmpty((Object)filter)) continue;
            this.emptyQuery(filter, dataTypeMap);
            List nests = filter.getNests(true);
            if (nests == null || nests.isEmpty()) continue;
            for (QFilter.QFilterNest nest : nests) {
                this.emptyQuery(nest.getFilter(), dataTypeMap);
            }
        }
    }

    private void emptyQuery(QFilter filter, Map<String, String> dataTypeMap) {
        String property = filter.getProperty();
        String cp = filter.getCP();
        Object value = filter.getValue();
        if (SWCStringUtils.equals((String)"EMPTY", (String)String.valueOf(value)) && SWCStringUtils.equals((String)"=", (String)cp) && StringUtils.endsWith((CharSequence)property, (CharSequence)".name") && SWCStringUtils.equals((String)"", (String)dataTypeMap.get(property))) {
            filter.__setProperty(property.replace(".name", ".id"));
            filter.__setValue((Object)0L);
        }
        if (SWCStringUtils.equals((String)"EMPTY", (String)String.valueOf(value)) && SWCStringUtils.equals((String)"=", (String)cp) && SWCStringUtils.equals((String)"combofield", (String)dataTypeMap.get(property))) {
            filter.or(property, "=", (Object)"");
            filter.or(property, "=", (Object)" ");
        }
    }

    private void addExtFilter(ReportQueryParam queryParam, List<QFilter> filters) {
        AdjDetailQueryParamEvent event = new AdjDetailQueryParamEvent(queryParam, filters);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new AdjDetailRptQueryExtService(), IAdjDetailRptExtService.class, (String)"kd.sdk.swc.hcdm.business.extpoint.report.IAdjDetailRptExtService#addExtFilter", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            plugin.addExtFilter(event);
            return null;
        });
    }

    private void buildFilters(FilterInfo filterInfo, AdjDetailRptQueryInfo salRptQueryInfo) {
        List<QFilter> filters;
        String openWay = filterInfo.getString("openway");
        if (openWay == null) {
            openWay = "1";
        }
        switch (openWay) {
            case "1": {
                filters = this.parseFilters(filterInfo, salRptQueryInfo);
                QFilter qFilter = this.parseMoreFilters(filterInfo, salRptQueryInfo);
                if (qFilter == null) break;
                filters.add(qFilter);
                break;
            }
            default: {
                filters = filterInfo.getQFilters();
            }
        }
        salRptQueryInfo.setOpenWay(openWay);
        salRptQueryInfo.setFilters(filters);
    }

    protected List<QFilter> parseFilters(FilterInfo filterInfo, AdjDetailRptQueryInfo adjDetailRptQueryInfo) {
        ArrayList filters = Lists.newArrayListWithCapacity((int)10);
        List filterItems = filterInfo.getFilterItems();
        filters.add(new QFilter("status", "not in", (Object)new String[]{"E", "F"}));
        filters.add(new QFilter("initstatus", "in", (Object)new String[]{" ", "2"}));
        filters.add(new QFilter("datastatus", "in", (Object)CommonHcdmBizHelper.VALIDATE_DATA_STATUS));
        filters.add(new QFilter("hisversion", "!=", (Object)" "));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("iscurrentversion", "=", (Object)"0"));
        boolean superUser = SWCPermissionServiceHelper.isSuperUser();
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        for (FilterItemInfo filterItem : filterItems) {
            this.dealDataPermQFilter(filterItem, filters, superUser, map);
        }
        this.dealObgToVersionFilter(filterItems, filters, map);
        List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hcdm"});
        QFilter qFilter = new QFilter(FieldMappingHelper.FILTER_ITEMS_MAP.get("empgroup"), "in", (Object)empgoupIds);
        filters.add(qFilter);
        filters.add(new QFilter("bsed", "<=", map.get("end")).and(new QFilter("bsled", ">=", map.get("start"))));
        this.dealDataPermQFilter(filterInfo, adjDetailRptQueryInfo, superUser, filters);
        return filters;
    }

    private void dealObgToVersionFilter(List<FilterItemInfo> filterItemInfos, List<QFilter> filters, Map<String, Date> map) {
        ArrayList addFilters = Lists.newArrayListWithCapacity((int)10);
        Iterator<FilterItemInfo> iterator = filterItemInfos.iterator();
        block13: while (iterator.hasNext()) {
            FilterItemInfo filterItemInfo = iterator.next();
            String propName = filterItemInfo.getPropName();
            Object value = filterItemInfo.getValue();
            String property = FieldMappingHelper.FILTER_ITEMS_MAP.get(propName);
            if (null == property) continue;
            switch (property) {
                case "hcdm_decadjrelperson.company": 
                case "hcdm_decadjrelperson.adminorg": {
                    if (null == value) break;
                    List<Long> adminOrgVIds = AdjDetailRptHelper.getVersionOfAll("haos_adminorghr", this.toCollection(value), map);
                    if (adminOrgVIds.isEmpty()) continue block13;
                    addFilters.add(new QFilter(property, "in", adminOrgVIds));
                    iterator.remove();
                    break;
                }
                case "hcdm_decadjrelperson.stdscm": {
                    if (null == value) break;
                    List<Long> stdsScmVIds = AdjDetailRptHelper.getVersionOfAll("hcdm_stdscm", this.toCollection(value), map);
                    if (stdsScmVIds.isEmpty()) continue block13;
                    addFilters.add(new QFilter(property, "in", stdsScmVIds));
                    iterator.remove();
                    break;
                }
                case "hcdm_decadjrelperson.job": {
                    if (null == value) break;
                    List<Long> jobVIds = AdjDetailRptHelper.getVersionOfAll("hbjm_jobhr", this.toCollection(value), map);
                    if (jobVIds.isEmpty()) continue block13;
                    addFilters.add(new QFilter(property, "in", jobVIds));
                    iterator.remove();
                    break;
                }
                case "hcdm_decadjrelperson.position": {
                    if (null == value) break;
                    List<Long> positionVIds = AdjDetailRptHelper.getVersionOfAll("hbpm_positionhr", this.toCollection(value), map);
                    if (positionVIds.isEmpty()) continue block13;
                    addFilters.add(new QFilter(property, "in", positionVIds));
                    iterator.remove();
                    break;
                }
            }
        }
        filters.addAll(addFilters);
    }

    private Collection toCollection(Object value) {
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection values = (DynamicObjectCollection)value;
            return values.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        if (value instanceof DynamicObject) {
            DynamicObject val = (DynamicObject)value;
            return Collections.singletonList(val.getLong("id"));
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Long> getVersionOfAll(String entityNumber, Collection pkIds, Map<String, Date> map) {
        QFilter qFilter = new QFilter("boid", "in", (Object)pkIds);
        qFilter.and(new QFilter("status", "=", (Object)AdjFileStatusEnum.AUDIT.getCode()));
        qFilter.and(new QFilter("enable", "=", (Object)YesOrNoEnum.YES.getCode()));
        qFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"}));
        qFilter.and(new QFilter("bsed", "<=", (Object)map.get("end")).and(new QFilter("bsled", ">=", (Object)map.get("start"))));
        DynamicObject[] objArr = new SWCDataServiceHelper(entityNumber).query("id", new QFilter[]{qFilter});
        return Arrays.stream(objArr).map(object -> object.getLong("id")).collect(Collectors.toList());
    }

    private void dealDataPermQFilter(FilterInfo filterInfo, AdjDetailRptQueryInfo adjDetailRptQueryInfo, boolean isSuperUser, List<QFilter> filters) {
        List authorizedDataRuleQFilter;
        QFilter orgFilter = AdjDetailRptHelper.buildOrgFilter(filterInfo, adjDetailRptQueryInfo, isSuperUser);
        if (orgFilter != null) {
            filters.add(orgFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)adjDetailRptQueryInfo.getPermEntityCode(), (String)"47150e89000000ac")))) {
            filters.addAll(authorizedDataRuleQFilter);
        }
        List filterItems = filterInfo.getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            Object value = filterItem.getValue();
            String propName = filterItem.getPropName();
            if (value == null || SWCObjectUtils.isEmpty((Object)FieldMappingHelper.FILTER_ITEMS_MAP.get(propName))) continue;
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                filters.add(new QFilter(FieldMappingHelper.FILTER_ITEMS_MAP.get(propName), "in", values.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList())));
                continue;
            }
            if (!(value instanceof DynamicObject)) continue;
            DynamicObject val = (DynamicObject)value;
            filters.add(new QFilter(FieldMappingHelper.FILTER_ITEMS_MAP.get(propName), "=", (Object)val.getLong("id")));
        }
    }

    public static QFilter buildOrgFilter(FilterInfo filterInfo, AdjDetailRptQueryInfo salaryQueryInfo, boolean isSuperUser) {
        Set<Long> orgList = AdjDetailRptHelper.getIdListFromFilterInfo(filterInfo, KEY_ORG);
        if (isSuperUser && CollectionUtils.isEmpty(orgList)) {
            return new QFilter("1", "!=", (Object)1);
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"0VO5EV13=I9W", (String)salaryQueryInfo.getPermEntityCode());
        if (!permOrgs.hasAllOrgPerm()) {
            List hasPermOrgList = permOrgs.getHasPermOrgs();
            if (hasPermOrgList != null) {
                HashSet<Long> hasPermOrgs = new HashSet<Long>(hasPermOrgList);
                orgList = CollectionUtils.isEmpty(orgList) ? hasPermOrgs : orgList.stream().filter(obj -> hasPermOrgs.contains(obj)).collect(Collectors.toSet());
            } else {
                orgList = new HashSet<Long>(0);
            }
        }
        return new QFilter(FieldMappingHelper.FILTER_ITEMS_MAP.get(KEY_ORG), "in", orgList);
    }

    public static QFilter buildBaseDataIdFilter(FilterInfo filterInfo, String formFieldCode, String filterFieldCode) {
        Set<Long> baseDataIds = AdjDetailRptHelper.getIdListFromFilterInfo(filterInfo, formFieldCode);
        if (CollectionUtils.isEmpty(baseDataIds)) {
            return null;
        }
        return new QFilter(filterFieldCode, "in", baseDataIds);
    }

    public static Set<Long> getIdListFromFilterInfo(FilterInfo filterInfo, String key) {
        Set<Object> idList = Sets.newHashSetWithExpectedSize((int)16);
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem(key);
        if (!Objects.isNull(filterItemInfo)) {
            DynamicObject value;
            if (filterItemInfo.getValue() instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)filterItemInfo.getValue();
                if (!Objects.isNull(values)) {
                    idList = values.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                }
            } else if (filterItemInfo.getValue() instanceof DynamicObject && !Objects.isNull(value = (DynamicObject)filterItemInfo.getValue())) {
                idList.add(value.getLong("id"));
            }
        }
        return idList;
    }

    private void dealDataPermQFilter(FilterItemInfo filterItem, List<QFilter> qFilterfilters, boolean superUser, Map<String, Date> map) {
        Object value = filterItem.getValue();
        String propName = filterItem.getPropName();
        if (SWCStringUtils.equals((String)"empgroup", (String)propName) || SWCStringUtils.equals((String)"department", (String)propName) || SWCStringUtils.equals((String)"stdscm", (String)propName)) {
            propName = FieldMappingHelper.FILTER_ITEMS_MAP.get(propName);
        }
        if (SWCStringUtils.equals((String)"displayscheme", (String)propName)) {
            return;
        }
        if (SWCStringUtils.equals((String)"date_startdate", (String)propName)) {
            map.put("start", (Date)value);
        }
        if (SWCStringUtils.equals((String)"date_enddate", (String)propName)) {
            map.put("end", (Date)value);
        }
        if (SWCObjectUtils.isEmpty((Object)propName) || null == value) {
            return;
        }
        if ("personfield".equals(propName)) {
            qFilterfilters.add(AdjDetailReportDisplayHelper.buildPersonFilter(value.toString()));
            return;
        }
    }

    protected QFilter parseMoreFilters(FilterInfo filterInfo, AdjDetailRptQueryInfo salRptQueryInfo) {
        QFilter qFilter = (QFilter)filterInfo.getCommFilter().get(salRptQueryInfo.getQueryEntityCode());
        if (SWCObjectUtils.isEmpty((Object)qFilter)) {
            return null;
        }
        return qFilter;
    }

    protected void setColumnInfoList(FilterInfo filterInfo, AdjDetailRptQueryInfo salRptQueryInfo) {
        List<AdjDetailRptColumnInfo> columnInfoList = this.parseReportScheme(filterInfo);
        salRptQueryInfo.setSalaryRptColumnInfoList(columnInfoList);
    }

    protected List<AdjDetailRptColumnInfo> parseReportScheme(FilterInfo filterInfo) {
        long reportSchemeId = filterInfo.getLong("displayscheme");
        DynamicObject reportScheme = AdjDetailReportDisplayHelper.queryRptDisplaySchemeObj(reportSchemeId);
        if (reportScheme == null) {
            throw new KDBizException("reportScheme(" + reportSchemeId + ") is not exist. ");
        }
        DynamicObjectCollection schemeEntries = reportScheme.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)schemeEntries)) {
            return null;
        }
        ArrayList columnInfos = Lists.newArrayListWithCapacity((int)schemeEntries.size());
        for (DynamicObject schemeEntry : schemeEntries) {
            AdjDetailRptColumnInfo columnInfo = this.createColumnInfo(schemeEntry);
            this.afterCreateColumnInfo(columnInfo, schemeEntry);
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    private AdjDetailRptColumnInfo createColumnInfo(DynamicObject schemeEntry) {
        AdjDetailRptColumnInfo columnInfo = new AdjDetailRptColumnInfo();
        String fieldCode = schemeEntry.getString("fieldalias");
        columnInfo.setFieldCode(fieldCode);
        columnInfo.setCaption(schemeEntry.getString("displayname"));
        columnInfo.setFreeze(schemeEntry.getBoolean("freeze"));
        columnInfo.setColumnWidth(schemeEntry.getInt("columnwidth"));
        columnInfo.setAlignment(schemeEntry.getString("alignment"));
        columnInfo.setSort(schemeEntry.getInt("sort"));
        columnInfo.setSortType(schemeEntry.getInt("sorttype") == 1 ? "ASC" : "DESC");
        String secondaryHeader = schemeEntry.getString("secondaryheader");
        if (!StringUtils.isEmpty((CharSequence)secondaryHeader)) {
            ArrayList parentHeaders = Lists.newArrayListWithCapacity((int)2);
            parentHeaders.add(secondaryHeader);
            columnInfo.setParentHeaders(parentHeaders);
        }
        String fieldType = schemeEntry.getString("fieldtype");
        columnInfo.setDataType(fieldType);
        if (fieldCode.startsWith("item")) {
            String[] splits = fieldCode.split("_");
            String itemType = splits[0];
            long itemId = Long.parseLong(splits[1]);
            columnInfo.setItem(true);
            columnInfo.setItemId(itemId);
            columnInfo.setItemType(itemType);
        }
        return columnInfo;
    }

    protected void afterCreateColumnInfo(AdjDetailRptColumnInfo columnInfo, DynamicObject schemeEntry) {
    }

    protected void afterSetColumnInfoList(AdjDetailRptQueryInfo salRptQueryInfo) {
        List<AdjDetailRptColumnInfo> columnInfoList = salRptQueryInfo.getSalaryRptColumnInfoList();
        if (CollectionUtils.isEmpty(columnInfoList)) {
            return;
        }
        ArrayList<String> fieldNameList = new ArrayList<String>(columnInfoList.size());
        ArrayList<DataType> algoDataTypeList = new ArrayList<DataType>(columnInfoList.size());
        HashMap dataTypeMap = Maps.newHashMapWithExpectedSize((int)columnInfoList.size());
        ArrayList mainSelectFields = Lists.newArrayListWithCapacity((int)10);
        String[] orderByFieldArry = new String[5];
        for (int i = 0; i < columnInfoList.size(); ++i) {
            String orderField;
            int sort;
            AdjDetailRptColumnInfo columnInfo = columnInfoList.get(i);
            String dataType = columnInfo.getDataType();
            String fieldCode = columnInfo.getFieldCode();
            String dbFieldCode = columnInfo.getDbFieldCode();
            if (columnInfo.isBuildColumn()) {
                fieldNameList.add(fieldCode);
                algoDataTypeList.add(AdjDetailReportDisplayHelper.getAlgoDataType(dataType));
                dataTypeMap.put(fieldCode, dataType);
            }
            if (columnInfo.isQuery()) {
                if (!StringUtils.isEmpty((CharSequence)dbFieldCode)) {
                    mainSelectFields.add(dbFieldCode);
                } else {
                    mainSelectFields.add(fieldCode);
                }
            }
            if ((sort = columnInfo.getSort()) <= 0) continue;
            orderByFieldArry[sort - 1] = orderField = fieldCode + "&" + columnInfo.getSortType();
        }
        LinkedHashMap orderByFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)orderByFieldArry.length);
        Arrays.stream(orderByFieldArry).filter(obj -> !StringUtils.isEmpty((CharSequence)obj)).forEach(obj -> orderByFieldMap.put(obj.substring(0, obj.indexOf(38)), obj.substring(obj.indexOf(38) + 1)));
        salRptQueryInfo.setOrderByFieldMap(orderByFieldMap);
        salRptQueryInfo.setRowMeta(new RowMeta(fieldNameList.toArray(new String[0]), algoDataTypeList.toArray(new DataType[0])));
        salRptQueryInfo.setDataTypeMap(dataTypeMap);
        salRptQueryInfo.setMainSelectFields(mainSelectFields);
    }

    public static void updateSalaryColumn(ReportColumn reportColumn) {
        String fieldKey = reportColumn.getFieldKey();
        if (Sets.newHashSet((Object[])new String[]{"salarypercent", "salaryseeprate", "suggestminrange", "suggestmaxrange", "actualrange"}).contains(fieldKey) && reportColumn.getFieldProperty() instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)reportColumn.getFieldProperty();
            AdjDetailRptHelper.updateDecimalProp(decimalProp);
            decimalProp.setScale(4);
            decimalProp.setPrecision(23);
        }
        if (Sets.newHashSet((Object[])new String[]{"amount", "suggestminamount", "suggestmaxamount", "actualamount"}).contains(fieldKey) && reportColumn.getFieldProperty() instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)reportColumn.getFieldProperty();
            amountProp.setDefaultValue(null);
            amountProp.setEnableNull(true);
            amountProp.setZeroShow(true);
        }
    }

    public static void updateDecimalProp(DecimalProp decimalProp) {
        decimalProp.setDefaultValue(null);
        decimalProp.setEnableNull(true);
        decimalProp.setZeroShow(true);
    }
}

