/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AbstractAdjfileServiceHelper {
    private static final Log logger = LogFactory.getLog(AbstractAdjfileServiceHelper.class);
    public static final String HRPI_PERSON = "hrpi_person";
    private static final String SWC_HCDM_BUSINESS = "swc-hcdm-business";
    public static final String HRPI_EMPPOSORGREL = "hrpi_empposorgrel";
    public AdjFileDomainService adjFileDomainService = (AdjFileDomainService)DomainFactory.getInstance(AdjFileDomainService.class);
    public static final long SUCCESS_STATUS_CODE = 200L;
    public static final String EMPTY_STR = "";

    public DynamicObject genDisableVersion(Date bsed, Date bsled, DynamicObject oldItemDyObj) {
        DynamicObject disableHisDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("id");
        ignoreField.add("iscurrentversion");
        SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)oldItemDyObj, (DynamicObject)disableHisDyn, ignoreField, null);
        disableHisDyn.set("bsed", (Object)bsed);
        disableHisDyn.set("bsled", (Object)bsled);
        disableHisDyn.set("enable", (Object)"0");
        disableHisDyn.set("boid", (Object)oldItemDyObj.getLong("boid"));
        return disableHisDyn;
    }

    public DynamicObject genEnableVersion(DynamicObject oldItemDyObj, DynamicObject curItemDyObj) {
        DynamicObject hisDyn = this.adjFileDomainService.generateEmptyDecideAdjSalary();
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("id");
        ignoreField.add("iscurrentversion");
        SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)curItemDyObj, (DynamicObject)hisDyn, ignoreField, null);
        hisDyn.set("status", (Object)"C");
        hisDyn.set("enable", (Object)"1");
        hisDyn.set("boid", (Object)oldItemDyObj.getLong("boid"));
        return hisDyn;
    }

    public Long genEventDyn(String event, List<DynamicObject> eventDynList, String eventType) {
        DynamicObject decideAdjEvent = this.adjFileDomainService.generateEmptyDecideAdjEvent();
        long[] eventPkIds = this.adjFileDomainService.genEventPkId(1);
        Long eventPkId = eventPkIds[0];
        decideAdjEvent.set("id", (Object)eventPkId);
        decideAdjEvent.set("event", (Object)event);
        decideAdjEvent.set("eventtype", (Object)eventType);
        decideAdjEvent.set("eventdate", (Object)new Date());
        decideAdjEvent.set("eventstatus", (Object)"0");
        eventDynList.add(decideAdjEvent);
        return eventPkId;
    }

    public Map<Long, Map<Long, DynamicObject>> getDecAdjRecordByAdjfile(Collection<Long> adjfileIdSets) {
        DynamicObject[] decideAdjSalaryObjs = this.adjFileDomainService.queryDecideAdjSalaryObj(adjfileIdSets, true);
        HashMap<Long, Map<Long, DynamicObject>> result = new HashMap<Long, Map<Long, DynamicObject>>(16);
        for (DynamicObject decAdjDy : decideAdjSalaryObjs) {
            Long salaryAdjFileId = decAdjDy.getLong("salaryadjfile.id");
            Long standarditemId = decAdjDy.getLong("standarditem.id");
            Map itemMap = result.computeIfAbsent(salaryAdjFileId, val -> new HashMap(16));
            itemMap.put(standarditemId, decAdjDy);
        }
        return result;
    }

    public String getBosEntityFlag(String field, String bosEntity) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bosEntity);
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)allFields.get(field);
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            return basedataProp.getBaseEntityId();
        }
        return null;
    }

    public Map<String, Map<String, Set<Long>>> getFieldEntityAndIds(String entityId, List<Map<String, Object>> validDataList) {
        HashMap<String, Map<String, Set<Long>>> fieldEntityIdMap = new HashMap<String, Map<String, Set<Long>>>(16);
        for (int i = 0; i < validDataList.size(); ++i) {
            Map<String, Object> validDataMap = validDataList.get(i);
            if (validDataMap == null) continue;
            for (Map.Entry<String, Object> next : validDataMap.entrySet()) {
                Set<Long> idSet;
                String bosEntityFlag;
                String key = next.getKey();
                Object value = next.getValue();
                if (!(value instanceof Long) && !(value instanceof Integer) || SWCStringUtils.isEmpty((String)(bosEntityFlag = this.getBosEntityFlag(key, entityId)))) continue;
                HashMap entityIdMap = (HashMap)fieldEntityIdMap.get(key);
                if (entityIdMap == null) {
                    entityIdMap = new HashMap(16);
                }
                Set set = idSet = entityIdMap.get(bosEntityFlag) == null ? new HashSet(16) : (Set)entityIdMap.get(bosEntityFlag);
                if (value instanceof Integer) {
                    Integer intVal = (Integer)value;
                    idSet.add(intVal.longValue());
                } else {
                    idSet.add((Long)value);
                }
                entityIdMap.put(bosEntityFlag, idSet);
                fieldEntityIdMap.put(key, entityIdMap);
            }
        }
        return fieldEntityIdMap;
    }

    public Map<Long, DynamicObject> getPersonEntryDate(Map<Long, DynamicObject> depEmpPosOrgRelMap) {
        Collection<DynamicObject> depEmpOrgPosVals = depEmpPosOrgRelMap.values();
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        for (DynamicObject empOrgPosVal : depEmpOrgPosVals) {
            Object personObj;
            Long personId;
            if (empOrgPosVal == null || (personId = this.getLongId(personObj = empOrgPosVal.get("person"))) == null) continue;
            personIdSet.add(personId);
        }
        Map<Long, DynamicObject> personEntryDateMap = DecAdjApprGridHelper.getEntryDate(personIdSet);
        return personEntryDateMap;
    }

    public Map<String, Object> getCheckParamIsEmptyResult(List<Map<String, Object>> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            HashMap<String, Object> methodReturnMap = new HashMap<String, Object>(16);
            methodReturnMap.put("success", Boolean.FALSE);
            String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjFileInfoServiceHelper_2", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            methodReturnMap.put("message", message);
            methodReturnMap.put("data", new ArrayList(10));
            return methodReturnMap;
        }
        return null;
    }

    public void covert2DynamicObject(DynamicObject entityObject, String entityId, Map<String, Object> dataMap, Map<String, Map<Long, DynamicObject>> fieldDataMap) throws ParseException {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Map allFields = dataEntityType.getAllFields();
        for (Map.Entry<String, Object> next : dataMap.entrySet()) {
            String key;
            IDataEntityProperty dataEntityProperty;
            if (next == null || (dataEntityProperty = (IDataEntityProperty)allFields.get(key = next.getKey())) == null) continue;
            Object value = next.getValue();
            if (dataEntityProperty instanceof BasedataProp) {
                Map<Long, DynamicObject> dynamicObjectMap = fieldDataMap.get(key);
                if (value instanceof Number && dynamicObjectMap != null && !dynamicObjectMap.isEmpty()) {
                    DynamicObject dynamicObject = null;
                    if (value instanceof Integer) {
                        Integer intVal = (Integer)value;
                        dynamicObject = dynamicObjectMap.get(intVal.longValue());
                    } else if (value instanceof Long) {
                        dynamicObject = dynamicObjectMap.get(value);
                    }
                    if (dynamicObject != null) {
                        entityObject.set(key, (Object)dynamicObject);
                        continue;
                    }
                    entityObject.set(key, value);
                    continue;
                }
                String baseEntityId = ((BasedataProp)dataEntityProperty).getBaseEntityId();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("id", value);
                entityObject.set(key, (Object)dynamicObject);
                continue;
            }
            if (dataEntityProperty instanceof MulBasedataProp) {
                List mulBaseBataIdList = (List)value;
                DynamicObjectCollection dynamicObjectCollection = entityObject.getDynamicObjectCollection(key);
                String baseEntityId = ((MulBasedataProp)dataEntityProperty).getBaseEntityId();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                if (mulBaseBataIdList == null || mulBaseBataIdList.isEmpty()) continue;
                for (int i = 0; i < mulBaseBataIdList.size(); ++i) {
                    Object id = mulBaseBataIdList.get(i);
                    Long longId = this.getLongId(id);
                    if (longId == null) continue;
                    DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                    dynamicObject.set("id", (Object)longId);
                    this.addMulObj(dynamicObjectCollection, dynamicObject);
                }
                entityObject.set(key, (Object)dynamicObjectCollection);
                continue;
            }
            if (dataEntityProperty instanceof DateProp) {
                entityObject.set(key, (Object)this.covert2DateOfNoTime(value));
                continue;
            }
            if (dataEntityProperty instanceof DateTimeProp) {
                entityObject.set(key, (Object)this.covert2Date(value));
                continue;
            }
            if (dataEntityProperty instanceof DecimalProp) {
                entityObject.set(key, (Object)this.covert2BigDecimal(value));
                continue;
            }
            entityObject.set(key, value);
        }
    }

    public BigDecimal covert2BigDecimal(Object data) {
        if (data instanceof BigDecimal) {
            return (BigDecimal)data;
        }
        if (data instanceof Number) {
            return new BigDecimal(data.toString());
        }
        if (data instanceof String) {
            return new BigDecimal((String)data);
        }
        return (BigDecimal)data;
    }

    public Date covert2Date(Object data) throws ParseException {
        if (data instanceof Date) {
            return (Date)data;
        }
        if (data instanceof String) {
            return SWCDateTimeUtils.parseDate((String)((String)data));
        }
        if (data instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)data);
            return calendar.getTime();
        }
        return (Date)data;
    }

    public Date covert2DateOfNoTime(Object data) throws ParseException {
        Date date = null;
        if (data instanceof Date) {
            date = (Date)data;
        } else if (data instanceof String) {
            date = SWCDateTimeUtils.parseDate((String)((String)data));
        } else if (data instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)data);
            date = calendar.getTime();
        }
        if (date != null) {
            return SWCDateTimeUtils.getDayDate((Date)date);
        }
        return (Date)data;
    }

    public Long getLongId(Object id) {
        Long longId = null;
        if (id instanceof Integer) {
            longId = ((Integer)id).longValue();
        } else if (id instanceof Long) {
            longId = (Long)id;
        } else if (id instanceof DynamicObject) {
            longId = ((DynamicObject)id).getLong("id");
        } else if (id instanceof String && SWCStringUtils.isNotEmpty((String)((String)id))) {
            longId = Long.parseLong((String)id);
        }
        return longId;
    }

    public void addMulObj(DynamicObjectCollection mulObj, DynamicObject objective) {
        DynamicObject obj = mulObj.addNew();
        obj.set("fbasedataid_id", objective.getPkValue());
        obj.set("fbasedataid", (Object)objective);
    }

    public Map<String, Map<Long, DynamicObject>> batchGetFieldDatas(Map<String, Map<String, Set<Long>>> fieldEntityIdMap) {
        HashMap<String, Map<Long, DynamicObject>> fieldDataMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        for (Map.Entry<String, Map<String, Set<Long>>> next : fieldEntityIdMap.entrySet()) {
            Map<String, Set<Long>> bosEntityAndIdMap;
            String field = next.getKey();
            if (field == null || (bosEntityAndIdMap = next.getValue()) == null) continue;
            for (Map.Entry<String, Set<Long>> entry : bosEntityAndIdMap.entrySet()) {
                String bosEntityFlag = entry.getKey();
                Set<Long> idSet = entry.getValue();
                if (SWCStringUtils.isEmpty((String)bosEntityFlag) || idSet == null) continue;
                String defaultSelectedProps = "id,number,name";
                if ("salaryadjrsn".equals(field)) {
                    defaultSelectedProps = "id,number,name,attributiontype";
                } else if ("stdscm".equals(field)) {
                    defaultSelectedProps = "id,number,name,sourcevid";
                }
                if (HRPI_PERSON.equals(bosEntityFlag)) {
                    defaultSelectedProps = "id,number,name,personindexid";
                }
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(bosEntityFlag);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)serviceHelper.getEntityName());
                Set fieldSet = mainEntityType.getFields().keySet();
                QFilter qFilter = new QFilter("id", "in", idSet);
                if (fieldSet.contains("enable")) {
                    qFilter.and("enable", "=", (Object)"1");
                }
                if (fieldSet.contains("status")) {
                    qFilter.and("status", "=", (Object)"C");
                }
                DynamicObject[] dynamicObjects = serviceHelper.query(defaultSelectedProps, new QFilter[]{qFilter});
                HashMap<Long, DynamicObject> idDynamicObj = new HashMap<Long, DynamicObject>(16);
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    DynamicObject dynamicObject = dynamicObjects[i];
                    if (dynamicObject == null) continue;
                    long id = dynamicObject.getLong("id");
                    idDynamicObj.put(id, dynamicObject);
                }
                fieldDataMap.put(field, idDynamicObj);
            }
        }
        return fieldDataMap;
    }

    public Date getDefaultMaxDate() {
        Date defaultMaxDate = null;
        try {
            defaultMaxDate = SWCDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException e) {
            logger.error("parse date error\uff1a{}", (Object)e.getMessage());
        }
        return defaultMaxDate;
    }

    public Map<String, String> getSalaryAdjEventStatus(Set<String> eventString) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salaryadjevent");
        QFilter filter = new QFilter("event", "in", eventString);
        DynamicObject[] eventDys = helper.query("event,eventstatus,eventtype,id", new QFilter[]{filter});
        return Arrays.stream(eventDys).collect(Collectors.toMap(dy -> dy.getString("event"), dy -> dy.getString("eventstatus"), (v1, v2) -> v1));
    }

    public boolean checkBussinessId(List<Map<String, Object>> sameUUIDParams) {
        HashSet<Long> bussinessIds = new HashSet<Long>(16);
        for (Map<String, Object> sameUUIDParam : sameUUIDParams) {
            Object bussinessIdObject = sameUUIDParam.get("bussinessid");
            if (bussinessIdObject == null) continue;
            Long bussinessId = this.getLongId(bussinessIdObject);
            bussinessIds.add(bussinessId);
            if (bussinessIds.size() <= 1) continue;
            return true;
        }
        return false;
    }
}

