/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.ListUtils;

public class AdjFileCertCommonHelper {
    private static final Log LOGGER = LogFactory.getLog(AdjFileCertCommonHelper.class);
    private static final String APP_ID = "0VO5EV13=I9W";
    private static final String FORM_ID = "hcdm_adjfileinfo";

    public static Map<String, Object> verifyCertForApply(List<Long> personIndexIds) {
        return SWCCertCommonHelper.verifyCertForApply((String)APP_ID, (String)FORM_ID, personIndexIds);
    }

    public static Map<String, Object> verifyCert(List<DynamicObject> persons) {
        HashSet successList = new HashSet(16);
        HashSet failList = new HashSet(16);
        HashSet<Long> requireList = new HashSet<Long>(16);
        for (DynamicObject person : persons) {
            requireList.add(person.getLong("personindexid"));
        }
        LOGGER.info("AdjFileCertCommonHelper requireList: {}", requireList);
        Map<String, Object> resultUsable = AdjFileCertCommonHelper.verifyCertForApply(new ArrayList<Long>(requireList));
        boolean result = (Boolean)resultUsable.get("result");
        if (result) {
            successList.addAll(requireList);
        } else {
            List noCerts = (List)resultUsable.get("datas");
            failList.addAll(noCerts);
            List hsaDetail = ListUtils.removeAll(requireList, (Collection)noCerts);
            successList.addAll(hsaDetail);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("successList", successList);
        resultMap.put("failList", failList);
        LOGGER.info("AdjFileCertCommonHelper resultUsable: {}", (Object)JSON.toJSONString(resultUsable));
        Map checkCountMap = (Map)resultUsable.get("msg");
        resultMap.put("message", checkCountMap.get("message"));
        resultMap.put("msg", resultUsable.get("msg"));
        return resultMap;
    }

    public static boolean isRequireCert(DynamicObject file) {
        return SWCStringUtils.equals((String)file.getString("status"), (String)"C");
    }

    public static void calPersonCertByPersonId(List<Long> personIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_person");
        QFilter idFilter = new QFilter("id", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)idFilter);
        DynamicObjectCollection persons = serviceHelper.queryOriginalCollection("personindexid", new QFilter[]{idFilter});
        List<Long> pIds = persons.stream().map(dy -> dy.getLong("personindexid")).collect(Collectors.toList());
        AdjFileCertCommonHelper.calPersonCertByIndexId(pIds);
    }

    public static void calPersonCertByFileId(List<Long> fileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(FORM_ID);
        QFilter filter = new QFilter("boid", "in", fileIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObject[] salaryFiles = helper.query("person.id", new QFilter[]{filter});
        List<Long> personIds = Arrays.stream(salaryFiles).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        AdjFileCertCommonHelper.calPersonCertByPersonId(personIds);
    }

    public static void calPersonCertByIndexId(List<Long> personIndexIds) {
        DynamicObjectCollection sinSurFileDys = AdjFileCertCommonHelper.getNeedCertByFileType(personIndexIds);
        Set requireCertSinSurIds = sinSurFileDys.stream().map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        SWCCertCommonHelper.updateCert((String)APP_ID, (String)FORM_ID, new ArrayList(requireCertSinSurIds));
        List releaseDelIds = ListUtils.removeAll(personIndexIds, requireCertSinSurIds);
        SWCCertCommonHelper.releaseCert((String)APP_ID, (String)FORM_ID, (List)releaseDelIds);
    }

    private static DynamicObjectCollection getNeedCertByFileType(List<Long> personindexids) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(FORM_ID);
        QFilter personFilter = new QFilter("person.personindexid", "in", personindexids);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter isVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter[] params = new QFilter[]{personFilter, statusFilter, isVersionFilter};
        return serviceHelper.queryOriginalCollection("person.personindexid", params);
    }

    public static boolean verifyCertCount(IFormView view) {
        Map resultMap = SWCCertCommonHelper.verifyCertCount((String)APP_ID, (String)FORM_ID);
        String infoType = (String)resultMap.get("infoType");
        String message = (String)resultMap.get("message");
        boolean showMessage = SWCStringUtils.equals((String)"true", (String)((String)resultMap.get("showMessage")));
        IFormView mainView = view.getMainView();
        if (SWCStringUtils.equals((String)infoType, (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            mainView.showErrorNotification(message);
            view.sendFormAction(mainView);
            return false;
        }
        if (SWCStringUtils.equals((String)infoType, (String)HRCertPromptInfoTypeEnum.EXCEED.getName()) || SWCStringUtils.equals((String)infoType, (String)HRCertPromptInfoTypeEnum.WARNING.getName())) {
            if (showMessage) {
                mainView.showTipNotification(message);
                view.sendFormAction(mainView);
            }
            return true;
        }
        return true;
    }

    public static String verifyExistFile(List<Long> fileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(FORM_ID);
        DynamicObjectCollection files = helper.queryOriginalCollection("person.personindexid", new QFilter[]{new QFilter("id", "in", fileIds)});
        List<Long> pids = files.stream().map(o1 -> o1.getLong("person.personindexid")).collect(Collectors.toList());
        return AdjFileCertCommonHelper.verifyExistPid(pids);
    }

    public static String verifyExistPerson(List<Long> personIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_person");
        DynamicObjectCollection persons = helper.queryOriginalCollection("personindexid", new QFilter[]{new QFilter("id", "in", personIds)});
        List<Long> pids = persons.stream().map(o1 -> o1.getLong("personindexid")).collect(Collectors.toList());
        return AdjFileCertCommonHelper.verifyExistPid(pids);
    }

    public static String verifyExistPid(List<Long> pids) {
        try {
            Map resultMap = SWCCertCommonHelper.verifyCert((String)APP_ID, (String)FORM_ID, pids);
            Boolean isforbidden = (Boolean)resultMap.get("isforbidden");
            if (isforbidden.booleanValue()) {
                Map msg = (Map)resultMap.get("msg");
                return (String)msg.get("message");
            }
        }
        catch (KDBizException e) {
            return e.getMessage();
        }
        return null;
    }

    public static void initCertData() {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(FORM_ID);
        QFilter isVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter[] params = new QFilter[]{isVersionFilter};
        DynamicObjectCollection sinSurFileDys = serviceHelper.queryOriginalCollection("person.id", params);
        List partition = Lists.partition((List)sinSurFileDys, (int)1000);
        for (List dynamicObjects : partition) {
            Set personIds = dynamicObjects.stream().map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
            AdjFileCertCommonHelper.calPersonCertByPersonId(new ArrayList<Long>(personIds));
        }
    }
}

