/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartViewEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AdjFileFormHelper {
    private static final Log logger = LogFactory.getLog(AdjFileFormHelper.class);

    public static FormShowParameter getSummaryFormShowParameter(FormShowParameter parentFormShowParameter, String targetKey) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId("hcdm_salaryadjfilepreview");
        OpenStyle openStyle = form.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(targetKey);
        form.setCustomParams(parentFormShowParameter.getCustomParams());
        return form;
    }

    public static FormShowParameter buildSalaryAdjFilePage(SalaryAdjFilePartViewEnum salaryAdjFilePartEnum, FormShowParameter parentFormShowParameter) {
        BaseShowParameter formShowParameter;
        String fileId = (String)parentFormShowParameter.getCustomParam("key_custom_param_fileid");
        if (salaryAdjFilePartEnum == null) {
            return null;
        }
        Object isHistoryPage = parentFormShowParameter.getCustomParams().get("isHistoryPage");
        if (salaryAdjFilePartEnum == SalaryAdjFilePartViewEnum.salaryadjrecord) {
            AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
            Map<Long, List<DynamicObject>> map = adjFileApplicationService.getCurDateItemVersion(Sets.newHashSet((Object[])new Long[]{Long.valueOf(fileId)}), isHistoryPage, null);
            return AdjFileFormHelper.setSalaryRecordShowParameter(salaryAdjFilePartEnum, fileId, isHistoryPage, map, Boolean.FALSE);
        }
        String pkId = AdjFileFormHelper.getIdByFileId(salaryAdjFilePartEnum, fileId, isHistoryPage);
        logger.info("show form name is {}, pkId is {}, fileId is {}", new Object[]{salaryAdjFilePartEnum.getNameParam().getDescription(), pkId, fileId});
        if (!AdjFileFormHelper.hasPerm(salaryAdjFilePartEnum.getEntityId(), fileId)) {
            logger.info("{} has no perm.", (Object)salaryAdjFilePartEnum.getEntityId());
            return null;
        }
        if (SWCStringUtils.isNotEmpty((String)pkId)) {
            formShowParameter = new BaseShowParameter();
            formShowParameter.setPkId((Object)pkId);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParams(parentFormShowParameter.getCustomParams());
            formShowParameter.setFormId(salaryAdjFilePartEnum.getEntityId());
        } else {
            formShowParameter = AdjFileFormHelper.getNullPage(salaryAdjFilePartEnum, fileId);
        }
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(salaryAdjFilePartEnum.getTargetKey());
        return formShowParameter;
    }

    public static boolean hasPerm(String entityNum, String fileId) {
        if (SWCStringUtils.equals((String)SalaryAdjFilePartViewEnum.baseInfo.getEntityId(), (String)entityNum)) {
            return true;
        }
        entityNum = "hcdm_salaryadjrecordview".equals(entityNum) ? "hcdm_salaryadjrecordquery" : entityNum;
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)entityNum, (String)"47150e89000000ac");
        logger.info("hcdm_salaryadjrecord query perm is: {}", (Object)hasPerm);
        return hasPerm;
    }

    public static String getIdByFileId(SalaryAdjFilePartViewEnum salaryAdjFilePartEnum, String fileId, Object isHistoryPage) {
        if (salaryAdjFilePartEnum == SalaryAdjFilePartViewEnum.baseInfo) {
            return fileId;
        }
        if (salaryAdjFilePartEnum == SalaryAdjFilePartViewEnum.salaryadjrecord) {
            return SalaryAdjFileServiceHelper.queryIdByFileId(SalaryAdjFilePartEnum.salaryadjrecord, fileId, isHistoryPage);
        }
        return null;
    }

    private static FormShowParameter getNullPage(SalaryAdjFilePartViewEnum salaryAdjFilePartEnum, String fileId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (salaryAdjFilePartEnum == null) {
            return formShowParameter;
        }
        String status = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId(fileId);
        String formId = SWCStringUtils.equals((String)status, (String)"E") || !AdjFileFormHelper.isAbleToAddNew(salaryAdjFilePartEnum) ? "hcdm_abandonednullpage" : "hcdm_nullpage";
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(salaryAdjFilePartEnum.getTargetKey());
        formShowParameter.setCustomParam("key_custom_param_entityid", (Object)salaryAdjFilePartEnum.getEntityId());
        formShowParameter.setCustomParam("key_custom_param_fileid", (Object)fileId);
        formShowParameter.setCustomParam("key_custom_param_filestatus", (Object)status);
        return formShowParameter;
    }

    private static boolean isAbleToAddNew(SalaryAdjFilePartViewEnum salaryAdjFilePartEnum) {
        return salaryAdjFilePartEnum != null;
    }

    public static FormShowParameter getFormShowParameterByEntityId(String entityId, FormShowParameter parentFormShowParameter) {
        SalaryAdjFilePartViewEnum salaryAdjFilePartEnum = SalaryAdjFilePartViewEnum.getEnumByEntityId((String)entityId);
        return AdjFileFormHelper.buildSalaryAdjFilePage(salaryAdjFilePartEnum, parentFormShowParameter);
    }

    public static FormShowParameter getAddNewFormShowParameterByEntityId(String entityId, FormShowParameter parentParameter) {
        SalaryAdjFilePartViewEnum salaryAdjFilePartEnum = SalaryAdjFilePartViewEnum.getEnumByEntityId((String)entityId);
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(salaryAdjFilePartEnum.getEntityId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(salaryAdjFilePartEnum.getTargetKey());
        formShowParameter.setCustomParam("key_custom_param_entityid", (Object)entityId);
        formShowParameter.setCustomParams(parentParameter.getCustomParams());
        return formShowParameter;
    }

    public static Boolean getEffectVisible(String fileId) {
        String fileStatus = SalaryAdjFileServiceHelper.getAdjFileStatuByFileId(fileId);
        return SWCStringUtils.equals((String)fileStatus, (String)"A");
    }

    public static String getAdjFileCaption(Long pkId) {
        if (pkId == null || pkId == 0L) {
            return null;
        }
        String captionTitle = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848", (String)"AdjFileFormHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String adjFilePersonName = SalaryAdjFileServiceHelper.getAdjFilePersonName(pkId);
        return SWCStringUtils.isEmpty((String)adjFilePersonName) ? captionTitle : captionTitle + "-" + adjFilePersonName;
    }

    public static FormShowParameter setSalaryRecordShowParameter(SalaryAdjFilePartViewEnum salaryAdjFilePartEnum, String fileId, Object isHistoryPage, Map<Long, List<DynamicObject>> map, Object isDelete) {
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((String)"0VO5EV13=I9W", (String)"hcdm_salaryadjrecordquery", (String)"47150e89000000ac");
        logger.info("hcdm_salaryadjrecord query perm is: {}", (Object)hasPerm);
        if (!hasPerm) {
            return null;
        }
        logger.info("setSalaryRecordShowParameter isHistoryPage={}", isHistoryPage);
        if (CollectionUtils.isEmpty(map)) {
            logger.info("setSalaryRecordShowParameter getCurDateItemVersion result is empty");
            return AdjFileFormHelper.getNullPageShowParam(salaryAdjFilePartEnum, fileId);
        }
        List<DynamicObject> list = map.get(Long.valueOf(fileId));
        if (CollectionUtils.isEmpty(list)) {
            logger.info("setSalaryRecordShowParameter getCurDateItemVersion fileId to record is empty");
            return AdjFileFormHelper.getNullPageShowParam(salaryAdjFilePartEnum, fileId);
        }
        logger.info("record size is={}", (Object)list.size());
        Map<Long, String> schoolTypeMap = AdjFileFormHelper.getSchoolType(list);
        Map<Long, Boolean> rankStatusMap = AdjFileFormHelper.itemUseRankFlag(list);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(salaryAdjFilePartEnum.getTargetKey());
        showParameter.setCustomParam("schoolTypeMap", schoolTypeMap);
        showParameter.setCustomParam("rankStatusMap", rankStatusMap);
        showParameter.setFormId("hsbp_nosearch_list_inh");
        showParameter.setBillFormId(salaryAdjFilePartEnum.getEntityId());
        showParameter.setSendToClient(true);
        showParameter.setMultiSelect(false);
        if (isDelete != null && ((Boolean)isDelete).booleanValue()) {
            showParameter.setMultiSelect(true);
            showParameter.setCustomParam("isDelete", (Object)Boolean.TRUE);
        }
        List sortedList = list.stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date o1Date = o1.getDate("bsed");
                Date o2Date = o2.getDate("bsed");
                return o1Date.compareTo(o2Date);
            }
        }.reversed()).collect(Collectors.toList());
        showParameter.setCustomParam("bsed", (Object)I18nServiceHelper.dateFormat((Date)((DynamicObject)sortedList.get(0)).getDate("bsed")));
        showParameter.setLookUp(false);
        Set ids = sortedList.stream().map(e1 -> e1.getLong("id")).collect(Collectors.toSet());
        Set relpersoIids = sortedList.stream().map(e1 -> e1.getLong("relpersonid")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("hcdm_decadjrelperson.id", "in", relpersoIids);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            filter.and("hcdm_decadjrelperson.org.id", "in", (Object)permOrgs.getHasPermOrgs());
        }
        logger.info("kd/swc/hcdm/business/salaryadjfile/AdjFileFormHelper.java:324--{}", (Object)filter.toString());
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        filterParams.setQFilters(Collections.singletonList(filter));
        return showParameter;
    }

    private static FormShowParameter getNullPageShowParam(SalaryAdjFilePartViewEnum salaryAdjFilePartEnum, String fileId) {
        FormShowParameter formShowParameter = AdjFileFormHelper.getNullPage(salaryAdjFilePartEnum, fileId);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(salaryAdjFilePartEnum.getTargetKey());
        return formShowParameter;
    }

    public static Map<Long, String> getSchoolType(List<DynamicObject> list) {
        Set relPersonIds = list.stream().map(e1 -> e1.getLong("relpersonid")).collect(Collectors.toSet());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_decadjrelperson");
        QFilter filter = new QFilter("id", "in", relPersonIds);
        DynamicObject[] relPersonDys = serviceHelper.query("schooltype", new QFilter[]{filter});
        logger.info("AdjFileFormHelper.getSchoolType {}", (Object)filter.toString());
        HashMap map = Maps.newHashMapWithExpectedSize((int)relPersonDys.length);
        for (DynamicObject relPersonDy : relPersonDys) {
            DynamicObjectCollection schoolTypes = relPersonDy.getDynamicObjectCollection("schooltype");
            if (CollectionUtils.isEmpty((Collection)schoolTypes)) {
                logger.info("AdjFileFormHelper.getSchoolType null----");
                continue;
            }
            HashSet names = Sets.newHashSetWithExpectedSize((int)schoolTypes.size());
            for (DynamicObject dynamicObject : schoolTypes) {
                names.add(dynamicObject.getString("fbasedataid.name"));
            }
            map.put(relPersonDy.getLong("id"), String.join((CharSequence)"\uff1b", names));
            logger.info("AdjFileFormHelper.getSchoolType{},{}", (Object)relPersonDy.getLong("id"), (Object)String.join((CharSequence)"\uff1b", names));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)list.size());
        for (DynamicObject dy : list) {
            result.put(dy.getLong("id"), map.get(dy.getLong("relpersonid")));
            logger.info("----AdjFileFormHelper.getSchoolType map {},{}", (Object)dy.getLong("id"), map.get(dy.getLong("relpersonid")));
        }
        return result;
    }

    public static Map<Long, Boolean> itemUseRankFlag(List<DynamicObject> list) {
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap recordAndStdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap recordAndStandardItemIdMap = Maps.newHashMapWithExpectedSize((int)16);
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        HashMap result = Maps.newHashMapWithExpectedSize((int)list.size());
        for (DynamicObject dy : list) {
            Long salaryStdId = dy.getLong("salarystd.id");
            Long standardItemId = dy.getLong("standarditem.id");
            recordAndStdMap.put(dy.getLong("id"), salaryStdId);
            recordAndStandardItemIdMap.put(dy.getLong("id"), standardItemId);
            List standarditemList = stdItemMap.computeIfAbsent(salaryStdId, k1 -> Lists.newArrayListWithExpectedSize((int)4));
            standarditemList.add(standardItemId);
        }
        Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag = service.getSalaryItemUseRankFlag(stdItemMap);
        if (CollectionUtils.isEmpty(salaryItemUseRankFlag)) {
            return result;
        }
        recordAndStdMap.forEach((key, vlaue) -> {
            Map map = (Map)salaryItemUseRankFlag.get(vlaue);
            Long standardItemId = (Long)recordAndStandardItemIdMap.get(key);
            if (!CollectionUtils.isEmpty((Map)map) && null != standardItemId) {
                Boolean flag = (Boolean)map.get(standardItemId);
                result.put(key, flag);
            }
        });
        return result;
    }
}

