/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.util.DomainFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.DecAdjSalaryEntity;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.SalaryAdjRecordRelPersonDynEntity;
import kd.swc.hcdm.business.adjapplication.domain.adjfile.service.AdjFileDomainService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.enums.AdjFileErrorMessageEnum;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hcdm.business.salaryadjfile.SalaryAdjFileHelper;
import kd.swc.hcdm.common.entity.adjfile.AdjFileMaxDateEntity;
import kd.swc.hcdm.common.entity.adjfile.DecAdjSalaryEvent;
import kd.swc.hcdm.common.enums.AdjFileStatusEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AdjFileInfoServiceHelper {
    public static final String BOS_ORG = "bos_org";
    private static final Log LOG = LogFactory.getLog(AdjFileInfoServiceHelper.class);
    private static final String SWC_HCDM_BUSINESS = "swc-hcdm-business";
    public static final String OLD_MAX_ENDDATE = "2199-12-31";
    private static final int BATCH_SIZE = 500;
    public static final String HRPI_EMPPOSORGREL = "hrpi_empposorgrel";
    public static final String ADJ_FILE_INFO = "adjfileinfo";
    public static final long SUCCESS_STATUS_CODE = 200L;
    public static final String STATUS = "status";
    public static final String AUDIT = "C";
    public static final String NEED_SAVE_NO_RECORD_LIST = "needSaveNoRecordList";
    public static final String NEED_SAVE_WITH_STATUS_NO_RECORD_LIST = "needSaveWithStatusNoRecordList";
    public static final String NEED_SAVE_WITH_STATUS_LIST = "needSaveWithStatusList";
    public static final String DEC_ADJ_SALARY_ENTITY_LIST = "decAdjSalaryEntityList";
    public static final String ID = "id";
    public static final String UPDATE_AUDIT_ADJ_INFO_LIST = "updateAuditAdjInfoList";
    public static final String UPDATE_AUDIT_DEC_ADJ_SAL_LIST = "updateAuditDecAdjSalList";
    public static final String NUMBER = "number";
    public static final String BSED = "bsed";
    public static final String BSLED = "bsled";
    public static final String EFFECT_ADJ_FILE_LIST = "effectAdjFileList";
    public static final String EFFECT_ADJ_SALARY_ENTITY_LIST = "effectAdjSalaryEntityList";
    public static final String BUSSINESSID = "bussinessid";
    public static final String DECADJ_DATA = "decadj_data";
    public static final String RELPERSON_DATA = "relperson_data";
    public static final String OPERATIONCODE = "operationcode";
    public static final String EMPTY_STR = "";
    public static final String SAVE = "save";
    public static final String SAVEAFTERAUDIT = "saveafteraudit";
    public static final String ADJ_FILE_TYPE_PART_TIME_JOB = "1";
    public static final String ADJ_FILE_TYPE_PRIMARY_JOB = "0";
    public static final String HCDM_SALAYSTRUCTURE = "hcdm_salaystructure";
    public static final String HCDM_STDSCM = "hcdm_stdscm";
    public static final String IS_FROM_API_SERVICE = "isFromApiService";
    public static final String PASS_DATA = "passData";
    public static final String FAIL_DATA = "failData";
    public static final String HRPI_PERSON = "hrpi_person";
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private AdjFileDomainService adjFileDomainService = (AdjFileDomainService)DomainFactory.getInstance(AdjFileDomainService.class);
    public static final String HRPI_DEPEMP = "hrpi_depemp";
    public static final String TRUE = "true";
    public static final String HCDM_SALARYADJRECORD = "hcdm_salaryadjrecord";
    public static final String HCDM_DECADJRELPERSON = "hcdm_decadjrelperson";
    private static final String NEEDREPUSH = "needrepush";
    String[] ADJFILE_MUST_FIELDS = new String[]{"uniquecode", "depemp", "org", "country", "depcytype", "stdscm", "salaystructure", "assoadminorg", "empgroup", "bsed", "datasource", "employee", "adminorg"};
    String[] ADJFILE_MUST_LONG_ID_FIELDS = new String[]{"depemp", "org", "country", "depcytype", "stdscm", "salaystructure", "assoadminorg", "empgroup", "employee", "adminorg"};
    String[] ADJRECORD_MUST_FIELDS = new String[]{"standarditem", "frequency", "currency", "amount", "salaryadjrsn", "bsed", "relperson_data"};
    String[] ADJRECORD_MUST_LONG_ID_FIELDS = new String[]{"standarditem", "frequency", "currency", "salaryadjrsn"};
    String[] ISCOVER_RELPERSONDATA_MUST_FIELDS = new String[]{"depemp", "org", "country", "personname", "empnumber"};
    String[] ISCOVER_RELPERSONDATA_MUST_LONG_ID_FIELDS = new String[]{"depemp", "org", "country"};
    String[] RELPERSONDATA_SAMEADJFILE_FIELDS = new String[]{"org", "country"};
    public static final String KEY_SPLIT_FALG = "###";
    private static final Set<String> NEEDREPUSH_VAL = Sets.newHashSet((Object[])new String[]{"0", "1"});

    private String checkMustField(Map<String, Object> dataMap, String[] mustCheckFields, String[] longIdMustFiles) {
        if (dataMap == null || dataMap.isEmpty()) {
            return null;
        }
        StringBuilder mustMessageBuild = new StringBuilder();
        for (int i = 0; i < mustCheckFields.length; ++i) {
            String fieldKey = mustCheckFields[i];
            Object value = dataMap.get(fieldKey);
            if (!dataMap.containsKey(fieldKey)) {
                if (!SWCStringUtils.isEmpty((String)mustMessageBuild.toString())) {
                    mustMessageBuild.append('\u3001');
                }
                mustMessageBuild.append(fieldKey);
                continue;
            }
            if (value != null && this.passLongValMustHasVal(dataMap, longIdMustFiles, fieldKey)) continue;
            if (!SWCStringUtils.isEmpty((String)mustMessageBuild.toString())) {
                mustMessageBuild.append('\u3001');
            }
            mustMessageBuild.append(fieldKey);
        }
        if (!SWCStringUtils.isEmpty((String)mustMessageBuild.toString())) {
            String message = ResManager.loadKDString((String)"\u5fc5\u586b\u9879{0}\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_0", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{mustMessageBuild.toString()});
            return message;
        }
        return null;
    }

    private boolean passLongValMustHasVal(Map<String, Object> dataMap, String[] longIdMustFiles, String fieldKey) {
        boolean idLongValPass = true;
        if (longIdMustFiles != null) {
            for (int j = 0; j < longIdMustFiles.length; ++j) {
                Long longVal;
                String longIdMustFile = longIdMustFiles[j];
                if (!fieldKey.equals(longIdMustFile) || (longVal = this.getLongTypeVal(dataMap, fieldKey)) != null && longVal != 0L) continue;
                idLongValPass = false;
            }
        }
        return idLongValPass;
    }

    private Map<String, Object> genErrorResultMap(AdjFileErrorMessageEnum errorMessageEnum, String errorMsg, Map<String, Object> dataMap, Object adjFileId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", Boolean.FALSE);
        resultMap.put("code", errorMessageEnum.getCode());
        resultMap.put("errormsg", errorMsg);
        resultMap.put("salaryfileid", adjFileId);
        resultMap.put("depemp", dataMap.get("depemp"));
        resultMap.put("org", dataMap.get("org"));
        resultMap.put("country", dataMap.get("country"));
        resultMap.put("stdscm", dataMap.get("stdscm"));
        if (null != dataMap.get("uuid")) {
            resultMap.put("uuid", dataMap.get("uuid"));
        }
        if (null != dataMap.get(NEEDREPUSH)) {
            resultMap.put(NEEDREPUSH, dataMap.get(NEEDREPUSH));
        }
        resultMap.put("uniquecode", dataMap.get("uniquecode"));
        return resultMap;
    }

    private Map<String, Object> genSuccessResultMap(Map<String, Object> dataMap, Object adjFileId, Object adjFileVId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("code", 200L);
        resultMap.put("errormsg", EMPTY_STR);
        resultMap.put("salaryfileid", adjFileId);
        resultMap.put("depemp", dataMap.get("depemp"));
        resultMap.put("org", dataMap.get("org"));
        resultMap.put("country", dataMap.get("country"));
        resultMap.put("stdscm", dataMap.get("stdscm"));
        resultMap.put("uniquecode", dataMap.get("uniquecode"));
        resultMap.put("salaryfilevid", adjFileVId == null ? Long.valueOf(0L) : adjFileVId);
        List decAdjParamData = (List)dataMap.get(DECADJ_DATA);
        ArrayList<Map<String, Object>> decAdjDataResList = new ArrayList<Map<String, Object>>(10);
        if (decAdjParamData != null) {
            for (int j = 0; j < decAdjParamData.size(); ++j) {
                Map decAdjMap = (Map)decAdjParamData.get(j);
                Map<String, Object> errorAdjRecResMap = this.genNomalAdjRecResMap(decAdjMap);
                decAdjDataResList.add(errorAdjRecResMap);
            }
        }
        if (decAdjDataResList.size() > 0) {
            resultMap.put(DECADJ_DATA, decAdjDataResList);
        }
        return resultMap;
    }

    private Map<String, Object> genErrorAdjRecResMap(AdjFileErrorMessageEnum errorMessageEnum, String errorMsg, Map<String, Object> decAdjMap) {
        HashMap<String, Object> decAdjDataResMap = new HashMap<String, Object>(16);
        if (decAdjMap != null) {
            decAdjDataResMap.put("standarditem", decAdjMap.get("standarditem"));
        }
        decAdjDataResMap.put("success", Boolean.FALSE);
        decAdjDataResMap.put("code", errorMessageEnum.getCode());
        decAdjDataResMap.put("message", errorMsg);
        return decAdjDataResMap;
    }

    private Map<String, Object> genNomalAdjRecResMap(Map<String, Object> decAdjMap) {
        HashMap<String, Object> decAdjDataResMap = new HashMap<String, Object>(16);
        if (decAdjMap != null) {
            decAdjDataResMap.put("standarditem", decAdjMap.get("standarditem"));
        }
        decAdjDataResMap.put("success", Boolean.TRUE);
        decAdjDataResMap.put("code", 200L);
        decAdjDataResMap.put("message", EMPTY_STR);
        return decAdjDataResMap;
    }

    private Date covert2Date(Object data) throws ParseException {
        if (data instanceof Date) {
            return (Date)data;
        }
        if (data instanceof String) {
            return SWCDateTimeUtils.parseDate((String)((String)data));
        }
        if (data instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)data);
            return calendar.getTime();
        }
        return (Date)data;
    }

    private Date covert2DateOfNoTime(Object data) throws ParseException {
        Date date = null;
        if (data instanceof Date) {
            date = (Date)data;
        } else if (data instanceof String) {
            date = SWCDateTimeUtils.parseDate((String)((String)data));
        } else if (data instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)data);
            date = calendar.getTime();
        }
        if (date != null) {
            return this.setDateTime2Zero(date);
        }
        return (Date)data;
    }

    Map<String, List<Map<String, Object>>> checkBsedAndBsledValue(List<Map<String, Object>> paramsList) throws ParseException {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> paramMap : paramsList) {
            Date bseDate = this.covert2DateOfNoTime(paramMap.get(BSED));
            Date bsleDate = this.covert2DateOfNoTime(paramMap.get(BSLED));
            if (bseDate != null && bsleDate != null && !SWCDateTimeUtils.dayBefore((Date)bseDate, (Date)bsleDate)) {
                String tips = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"AdjFileInfoServiceHelper_12", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                Map<String, Object> errorResMap = this.genErrorAdjAndAdjRecordMap(paramMap, tips, AdjFileErrorMessageEnum.DATA_WRONG, null);
                errorInfoList.add(errorResMap);
                continue;
            }
            passDataList.add(paramMap);
        }
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private boolean checkBussinessId(List<Map<String, Object>> sameUUIDParams) {
        HashSet<Long> bussinessIds = new HashSet<Long>(16);
        for (Map<String, Object> sameUUIDParam : sameUUIDParams) {
            Object bussinessIdObject = sameUUIDParam.get(BUSSINESSID);
            if (bussinessIdObject == null) continue;
            Long bussinessId = this.getLongId(bussinessIdObject);
            bussinessIds.add(bussinessId);
            if (bussinessIds.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> saveAdjFile(List<Map<String, Object>> paramsList) {
        Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
        if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
            return checkEmptyResult;
        }
        ArrayList<Map<String, Object>> noSalaryAdjRecords = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> haveSalaryAdjRecords = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> methodReturnMap = new HashMap<String, Object>(16);
        for (Map<String, Object> param : paramsList) {
            if (param == null || param.isEmpty()) continue;
            List decAdjParamData = (List)param.get(DECADJ_DATA);
            if (decAdjParamData != null && !decAdjParamData.isEmpty()) {
                haveSalaryAdjRecords.add(param);
                continue;
            }
            noSalaryAdjRecords.add(param);
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, List> groupByUUIDParams = new HashMap<String, List>(paramsList.size());
        for (Map map : haveSalaryAdjRecords) {
            Object v = map.get("uuid");
            if (ObjectUtils.isEmpty(v)) {
                Map<String, Object> checkResMap = this.genErrorAdjAndSpecAdjRecordMap(map, ResManager.loadKDString((String)"\u5982\u679c\u5165\u53c2\u4e2d\u5305\u542b\u5b9a\u8c03\u85aa\u6570\u636e\uff0c\u5219UUID\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_36", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.MUST_FIELD_ERROR, null, null);
                dataList.add(checkResMap);
            }
            List sameUUIDParams = groupByUUIDParams.computeIfAbsent((String)v, k1 -> new ArrayList());
            sameUUIDParams.add(map);
        }
        Iterator iterator = groupByUUIDParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List list = (List)entry.getValue();
            if (!this.checkBussinessId(list)) continue;
            iterator.remove();
            for (Map sameUUIDParam : list) {
                Map<String, Object> checkResMap = this.genErrorAdjAndSpecAdjRecordMap(sameUUIDParam, ResManager.loadKDString((String)"\u540c\u4e00UUID\u4e0b\u8bf7\u4fdd\u8bc1businessId\u76f8\u540c\u3002", (String)"AdjFileInfoServiceHelper_37", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.MUST_FIELD_ERROR, null, null);
                dataList.add(checkResMap);
            }
        }
        for (Map.Entry entry : groupByUUIDParams.entrySet()) {
            String uuid = (String)entry.getKey();
            Map<String, Object> haveSalaryAdjRecordsReturnMap = this.saveAdjFile(uuid, true, (List)entry.getValue());
            List methodReturnDataList = (List)haveSalaryAdjRecordsReturnMap.get("data");
            dataList.addAll(methodReturnDataList);
        }
        Map<String, Object> map = this.saveAdjFile("default", true, noSalaryAdjRecords);
        List list = (List)map.get("data");
        dataList.addAll(list);
        boolean success = true;
        for (int i = 0; i < dataList.size(); ++i) {
            Boolean successFlag;
            Map map2 = (Map)dataList.get(i);
            if (map2 == null || (successFlag = (Boolean)map2.get("success")) == null || successFlag.booleanValue()) continue;
            success = false;
        }
        methodReturnMap.put("success", success);
        methodReturnMap.put("message", EMPTY_STR);
        methodReturnMap.put("data", dataList);
        return methodReturnMap;
    }

    public Map<String, Object> saveAdjFile(String uuid, boolean endOperate, List<Map<String, Object>> paramsList) {
        HashMap<String, Object> methodReturnMap = new HashMap<String, Object>(16);
        try {
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
            if (!"default".equals(uuid) && this.checkUUID(uuid, methodReturnMap, dataList)) {
                for (Map<String, Object> paramMap : paramsList) {
                    paramMap.putAll(methodReturnMap);
                }
                methodReturnMap.put("data", paramsList);
                return methodReturnMap;
            }
            Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
            if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
                return checkEmptyResult;
            }
            List<Map<String, Object>> passCheckDataList = this.checkParamList(paramsList, uuid, endOperate, dataList);
            List tmpListSplit = Lists.partition(passCheckDataList, (int)500);
            for (List minList : tmpListSplit) {
                List<Map<String, Object>> saveResultList = this.batchSaveAdjFile(minList, uuid, endOperate);
                dataList.addAll(saveResultList);
            }
            methodReturnMap.put("message", EMPTY_STR);
            methodReturnMap.put("data", dataList);
            boolean success = true;
            for (int i = 0; i < dataList.size(); ++i) {
                Boolean successFlag;
                Map map = (Map)dataList.get(i);
                if (map == null || (successFlag = (Boolean)map.get("success")) == null || successFlag.booleanValue()) continue;
                success = false;
            }
            if (success && endOperate) {
                this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{uuid}));
            }
            methodReturnMap.put("success", success);
        }
        catch (Exception e) {
            LOG.error("AdjFileInfoServiceHelper executeOp error, msg: ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a{0}\u3002", (String)"AdjFileInfoServiceHelper_1", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{e.getMessage()});
            List dataList = (List)methodReturnMap.get("data");
            ArrayList<Map<String, Object>> newReturnDataList = new ArrayList<Map<String, Object>>(10);
            if (dataList == null && paramsList != null && !paramsList.isEmpty()) {
                for (int i = 0; i < paramsList.size(); ++i) {
                    Map<String, Object> paramMap = paramsList.get(i);
                    if (paramMap == null || paramMap.isEmpty()) continue;
                    Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.UNKNOW_ERROR, null);
                    newReturnDataList.add(map);
                }
                methodReturnMap.put("data", newReturnDataList);
            }
            methodReturnMap.put("message", msg);
            methodReturnMap.put("success", Boolean.FALSE);
        }
        return methodReturnMap;
    }

    private List<Map<String, Object>> checkParamList(List<Map<String, Object>> paramsList, String uuid, boolean endOperate, List<Map<String, Object>> allFailResultDataList) throws ParseException {
        Map<String, List<Map<String, Object>>> checkResultMap = this.checkMustField(paramsList, uuid, endOperate);
        List<Map<String, Object>> passCheckDataList = checkResultMap.get(PASS_DATA);
        List<Map<String, Object>> checkMustFaildAdjInfoList = checkResultMap.get(FAIL_DATA);
        allFailResultDataList.addAll(checkMustFaildAdjInfoList);
        Map<String, List<Map<String, Object>>> uniqueCodeResMap = this.checkUniqueCodeRepeat(passCheckDataList);
        passCheckDataList = uniqueCodeResMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)uniqueCodeResMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> needRepushSameResMap = this.checkNeedRepushSame(uuid, passCheckDataList);
        passCheckDataList = needRepushSameResMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)needRepushSameResMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> checkItemResMap = this.checkSalaryItemRepeat(passCheckDataList);
        passCheckDataList = checkItemResMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkItemResMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> checkAmountResultMap = this.checkAmount(passCheckDataList);
        passCheckDataList = checkAmountResultMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkAmountResultMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> checkStructResultMap = this.checkSalaryStructs(passCheckDataList);
        passCheckDataList = checkStructResultMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkStructResultMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> checkStdScmResultMap = this.checkStdScmBelongStructure(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkStdScmResultMap.get(FAIL_DATA));
        passCheckDataList = checkStdScmResultMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> bsedAndBsledResMap = this.checkBsedAndBsledValue(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)bsedAndBsledResMap.get(FAIL_DATA));
        passCheckDataList = bsedAndBsledResMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> permResMap = this.checkDataPermOfOrg(passCheckDataList, "salaystructure", HCDM_SALAYSTRUCTURE);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)permResMap.get(FAIL_DATA));
        passCheckDataList = permResMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> permResMapOfStdScm = this.checkDataPermOfOrg(passCheckDataList, "stdscm", HCDM_STDSCM);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)permResMapOfStdScm.get(FAIL_DATA));
        passCheckDataList = permResMapOfStdScm.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> checkStdScmItemsResMap = this.checkStdScmAndSalaryItem(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkStdScmItemsResMap.get(FAIL_DATA));
        passCheckDataList = checkStdScmItemsResMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> checkSalayStructureAndSalaryItemResMap = this.checkSalayStructureAndSalaryItem(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkSalayStructureAndSalaryItemResMap.get(FAIL_DATA));
        passCheckDataList = checkSalayStructureAndSalaryItemResMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> checkResMap = this.checkSalaryAdjRsn(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkResMap.get(FAIL_DATA));
        passCheckDataList = checkResMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> checkKeywordRepeatResMap = this.checkKeywordRepeat(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkKeywordRepeatResMap.get(FAIL_DATA));
        passCheckDataList = checkKeywordRepeatResMap.get(PASS_DATA);
        Map<String, List<Map<String, Object>>> checkEmpgroupResp = this.checkEmpgroup(passCheckDataList);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkEmpgroupResp.get(FAIL_DATA));
        passCheckDataList = checkEmpgroupResp.get(PASS_DATA);
        return passCheckDataList;
    }

    private Map<String, List<Map<String, Object>>> checkEmpgroup(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hcdm"});
        String errorMsg = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u586b\u5199\u201c\u85aa\u916c\u7ba1\u7406\u4eba\u5458\u7ec4\u201d\u7684\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b\uff0c\u8be5\u7ec4\u4e0d\u5c5e\u4e8e\u85aa\u916c\u7ba1\u7406\u3002", (String)"AdjFileInfoServiceHelper_44", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (Map<String, Object> paramMap : passCheckDataList) {
            if (paramMap == null) continue;
            Object depEmpParam = paramMap.get("empgroup");
            Long empgroupId = this.getLongId(depEmpParam);
            if (CollectionUtils.isEmpty((Collection)empgoupIds) || !empgoupIds.contains(empgroupId)) {
                Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(paramMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG, null);
                errorInfoList.add(map);
                continue;
            }
            passDataList.add(paramMap);
        }
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<String, List<Map<String, Object>>> checkKeywordRepeat(List<Map<String, Object>> passCheckDataList) throws ParseException {
        HashMap<Long, DynamicObject> depEmpPosOrgRelMap = new HashMap<Long, DynamicObject>(passCheckDataList.size());
        List partitions = Lists.partition(passCheckDataList, (int)500);
        for (List partition : partitions) {
            depEmpPosOrgRelMap.putAll(this.getDepEmpPosOrgRelMap(partition));
        }
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Integer> errorItemIndexSet = new HashSet<Integer>(16);
        HashSet<String> uniqueKeyword = new HashSet<String>(passCheckDataList.size());
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            String uniqueKey;
            Map<String, Object> errInfo;
            Map<String, Object> errInfo2;
            Map<String, Object> paramMap = passCheckDataList.get(i);
            if (paramMap == null) continue;
            Object depEmpParam = paramMap.get("depemp");
            Long depEmpId = this.getLongId(depEmpParam);
            DynamicObject empPosOrgRelDy = (DynamicObject)depEmpPosOrgRelMap.get(depEmpId);
            if (empPosOrgRelDy == null) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4ebaID\uff1a{0}\u6ca1\u6709\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_23", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                errInfo2 = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG, null, null);
                errorInfoList.add(errInfo2);
                errorItemIndexSet.add(i);
                continue;
            }
            String errorMsg1 = ResManager.loadKDString((String)"\u4eba\u5458\u4efb\u804c\u5df2\u5e9f\u5f03\u3002", (String)"DecAdjInfoServiceHelper_18", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            if (SWCStringUtils.equals((String)"-1", (String)empPosOrgRelDy.getString("datastatus"))) {
                errInfo2 = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg1, AdjFileErrorMessageEnum.DATA_WRONG, null, null);
                errorInfoList.add(errInfo2);
                errorItemIndexSet.add(i);
                continue;
            }
            List decAdjData = (List)paramMap.get(DECADJ_DATA);
            if (decAdjData != null && !decAdjData.isEmpty()) {
                boolean isAbandoned = false;
                for (Map decAdjMap : decAdjData) {
                    DynamicObject empPosOrgRelDy1;
                    Map relPersonData = (Map)decAdjMap.get(RELPERSON_DATA);
                    if (relPersonData.isEmpty() || !SWCStringUtils.equals((String)"-1", (String)(empPosOrgRelDy1 = (DynamicObject)depEmpPosOrgRelMap.get(this.getLongTypeVal(relPersonData, "depemp"))).getString("datastatus"))) continue;
                    isAbandoned = true;
                    break;
                }
                if (isAbandoned) {
                    errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg1, AdjFileErrorMessageEnum.DATA_WRONG, null, null);
                    errorInfoList.add(errInfo);
                    errorItemIndexSet.add(i);
                    continue;
                }
            }
            if (uniqueKeyword.add(uniqueKey = this.getUniqueKey(empPosOrgRelDy, paramMap))) continue;
            String errorMsg = ResManager.loadKDString((String)"\u5173\u952e\u5b57\u6bb5\u91cd\u590d", (String)"AdjFileInfoServiceHelper_38", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG, null, null);
            errorInfoList.add(errInfo);
            errorItemIndexSet.add(i);
        }
        AdjFileInfoServiceHelper.addPassData(passCheckDataList, passDataList, errorItemIndexSet);
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<String, List<Map<String, Object>>> checkSalaryAdjRsn(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        Set<Long> salaryAdjRsnIdSet = this.extractId(passCheckDataList, "salaryadjrsn");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_salaryadjustrsn");
        QFilter idFilter = new QFilter(ID, "in", salaryAdjRsnIdSet);
        DynamicObject[] salayStructureDys = serviceHelper.query("id,attributiontype", new QFilter[]{idFilter});
        Map<Long, DynamicObject> salayStructureDysGroupId = Arrays.stream(salayStructureDys).collect(Collectors.toMap(dy -> dy.getLong(ID), dy -> dy));
        HashSet<Integer> errorItemIndexSet = new HashSet<Integer>(16);
        String msg = ResManager.loadKDString((String)"\u540c\u4e00\u6279\u6b21\u4e2d\uff0c\u4e00\u4e2a\u5b9a\u8c03\u85aa\u6863\u6848\u4e0b\u4e0d\u5141\u8bb8\u540c\u65f6\u5199\u5165\u5b9a\u85aa\u548c\u8c03\u85aa\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_39", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        if (passCheckDataList != null) {
            block0: for (int i = 0; i < passCheckDataList.size(); ++i) {
                List decAdjDataList;
                Map<String, Object> paramMap = passCheckDataList.get(i);
                if (paramMap == null || (decAdjDataList = (List)paramMap.get(DECADJ_DATA)) == null) continue;
                HashSet<String> attributionTypeSet = new HashSet<String>(decAdjDataList.size());
                for (int j = 0; j < decAdjDataList.size(); ++j) {
                    Object salaryadjrsnObj;
                    Long salaryAdjRsnId;
                    DynamicObject salaryAdjRsnDynamicObject;
                    Map decAdjMap = (Map)decAdjDataList.get(j);
                    if (decAdjMap == null || (salaryAdjRsnDynamicObject = salayStructureDysGroupId.get(salaryAdjRsnId = this.getLongId(salaryadjrsnObj = decAdjMap.get("salaryadjrsn")))) == null) continue;
                    attributionTypeSet.add(salaryAdjRsnDynamicObject.getString("attributiontype"));
                    if (attributionTypeSet.size() <= 1) continue;
                    Map<String, Object> map = this.genErrorAdjAndSpecAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null, j);
                    errorInfoList.add(map);
                    errorItemIndexSet.add(i);
                    continue block0;
                }
            }
        }
        AdjFileInfoServiceHelper.addPassData(passCheckDataList, passDataList, errorItemIndexSet);
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<String, List<Map<String, Object>>> checkSalayStructureAndSalaryItem(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        Set<Long> salayStructureIdSet = this.extractId(passCheckDataList, "salaystructure");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(HCDM_SALAYSTRUCTURE);
        QFilter idFilter = new QFilter(ID, "in", salayStructureIdSet);
        DynamicObject[] salayStructureDys = serviceHelper.query("id,entryentity.standarditem", new QFilter[]{idFilter});
        Map<Long, Set<Long>> salayStructureIdMap = this.getsalayStructureItemMap(salayStructureDys);
        HashSet<Integer> errorItemIndexSet = new HashSet<Integer>(16);
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u916c\u7ed3\u6784\u4e0b\u4e0d\u5b58\u5728\u8be5\u5b9a\u8c03\u85aa\u9879\u76ee\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_21", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        if (passCheckDataList != null) {
            block0: for (int i = 0; i < passCheckDataList.size(); ++i) {
                Map<String, Object> paramMap = passCheckDataList.get(i);
                if (paramMap == null) continue;
                Object salayStructureParam = paramMap.get("salaystructure");
                Long salayStructureId = this.getLongId(salayStructureParam);
                Set<Long> salaryItemSet = salayStructureIdMap.get(salayStructureId);
                List decAdjDataList = (List)paramMap.get(DECADJ_DATA);
                if (decAdjDataList == null) continue;
                for (int j = 0; j < decAdjDataList.size(); ++j) {
                    Map decAdjMap = (Map)decAdjDataList.get(j);
                    if (decAdjMap == null) continue;
                    Object standardItemParam = decAdjMap.get("standarditem");
                    Long standarItemId = this.getLongId(standardItemParam);
                    if (salaryItemSet != null && salaryItemSet.contains(standarItemId)) continue;
                    Map<String, Object> map = this.genErrorAdjAndSpecAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null, j);
                    errorInfoList.add(map);
                    errorItemIndexSet.add(i);
                    continue block0;
                }
            }
        }
        AdjFileInfoServiceHelper.addPassData(passCheckDataList, passDataList, errorItemIndexSet);
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private BigDecimal covert2BigDecimal(Object data) {
        if (data instanceof BigDecimal) {
            return (BigDecimal)data;
        }
        if (data instanceof Number) {
            return new BigDecimal(data.toString());
        }
        if (data instanceof String) {
            return new BigDecimal((String)data);
        }
        return (BigDecimal)data;
    }

    private Map<String, List<Map<String, Object>>> checkAmount(List<Map<String, Object>> paramList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Integer> errorFileIndexSet = new HashSet<Integer>(16);
        if (paramList != null) {
            block0: for (int i = 0; i < paramList.size(); ++i) {
                List decAdjDataList;
                Map<String, Object> paramMap = paramList.get(i);
                if (paramMap == null || (decAdjDataList = (List)paramMap.get(DECADJ_DATA)) == null) continue;
                for (int j = 0; j < decAdjDataList.size(); ++j) {
                    Map decAdjMap = (Map)decAdjDataList.get(j);
                    if (decAdjMap == null) continue;
                    Object amountParam = decAdjMap.get("amount");
                    BigDecimal amount = this.covert2BigDecimal(amountParam);
                    if (amountParam == null || amount == null) continue;
                    BigDecimal checkAmount = new BigDecimal(amount.toString());
                    checkAmount = checkAmount.stripTrailingZeros();
                    int scale = checkAmount.scale();
                    int precision = checkAmount.precision();
                    if (precision - scale <= 13 && scale <= 10) continue;
                    String amountString = checkAmount.toPlainString();
                    String msg = ResManager.loadKDString((String)"\u91d1\u989d\uff1a{0}\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_22", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{amountString});
                    Map<String, Object> errMap = this.genErrorAdjAndSpecAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null, j);
                    errorInfoList.add(errMap);
                    errorFileIndexSet.add(i);
                    continue block0;
                }
            }
        }
        AdjFileInfoServiceHelper.addPassData(paramList, passDataList, errorFileIndexSet);
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private static void addPassData(List<Map<String, Object>> paramList, List<Map<String, Object>> passDataList, Set<Integer> errorFileIndexSet) {
        if (paramList != null) {
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> paramMap = paramList.get(i);
                if (paramMap == null || errorFileIndexSet.contains(i)) continue;
                passDataList.add(paramMap);
            }
        }
    }

    private Map<String, List<Map<String, Object>>> checkStdScmAndSalaryItem(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        Set<Long> stdScmIdSet = this.extractStdScmId(passCheckDataList);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(HCDM_STDSCM);
        QFilter idFilter = new QFilter(ID, "in", stdScmIdSet);
        DynamicObject[] stdScmDys = serviceHelper.query("id,entryentity.standarditem", new QFilter[]{idFilter});
        Map<Long, Set<Long>> scmItemIdMap = this.getStdScmItemIdMap(stdScmDys);
        HashSet<Integer> errorItemIndexSet = new HashSet<Integer>(16);
        if (passCheckDataList != null) {
            block0: for (int i = 0; i < passCheckDataList.size(); ++i) {
                Map<String, Object> paramMap = passCheckDataList.get(i);
                if (paramMap == null) continue;
                Object stdScmParam = paramMap.get("stdscm");
                Long stdScmId = this.getLongId(stdScmParam);
                Long stdScmVId = this.getLongTypeVal(paramMap, "stdscmvid");
                if (null != stdScmVId) {
                    stdScmId = stdScmVId;
                }
                Set<Long> salaryItemSet = scmItemIdMap.get(stdScmId);
                List decAdjDataList = (List)paramMap.get(DECADJ_DATA);
                if (decAdjDataList == null) continue;
                for (int j = 0; j < decAdjDataList.size(); ++j) {
                    Object standardItemParam;
                    Map decAdjMap = (Map)decAdjDataList.get(j);
                    if (decAdjMap == null || (standardItemParam = decAdjMap.get("standarditem")) == null) continue;
                    Long standarItemId = this.getLongId(standardItemParam);
                    if (salaryItemSet != null && salaryItemSet.contains(standarItemId)) continue;
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u916c\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u8be5\u5b9a\u8c03\u85aa\u9879\u76ee\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_43", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                    Map<String, Object> map = this.genErrorAdjAndSpecAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null, j);
                    errorInfoList.add(map);
                    errorItemIndexSet.add(i);
                    continue block0;
                }
            }
        }
        AdjFileInfoServiceHelper.addPassData(passCheckDataList, passDataList, errorItemIndexSet);
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Set<Long> extractId(List<Map<String, Object>> passCheckDataList, String filed) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        if (passCheckDataList != null) {
            for (Map<String, Object> paramMap : passCheckDataList) {
                Long id;
                Object obj = paramMap.get(filed);
                if (obj != null && (id = this.getLongId(obj)) != null) {
                    idSet.add(id);
                    continue;
                }
                List decAdjDataList = (List)paramMap.get(DECADJ_DATA);
                if (decAdjDataList == null || decAdjDataList.isEmpty()) continue;
                for (Map decAdjData : decAdjDataList) {
                    Object filedValue = decAdjData.get(filed);
                    Long id2 = this.getLongId(filedValue);
                    if (id2 == null) continue;
                    idSet.add(id2);
                }
            }
        }
        return idSet;
    }

    private Set<Long> extractStdScmId(List<Map<String, Object>> passCheckDataList) {
        HashSet<Long> stdScmIdSet = new HashSet<Long>(16);
        if (passCheckDataList != null) {
            for (Map<String, Object> paramMap : passCheckDataList) {
                Object stdScmObj = paramMap.get("stdscm");
                Long stdScmId = this.getLongId(stdScmObj);
                Long stdScmVId = this.getLongTypeVal(paramMap, "stdscmvid");
                if (null != stdScmVId) {
                    stdScmId = stdScmVId;
                }
                if (stdScmId == null) continue;
                stdScmIdSet.add(stdScmId);
            }
        }
        return stdScmIdSet;
    }

    private Map<Long, Set<Long>> getStdScmItemIdMap(DynamicObject[] stdScmDys) {
        HashMap<Long, Set<Long>> stdScmItemsMap = new HashMap<Long, Set<Long>>(16);
        if (stdScmDys != null) {
            for (int i = 0; i < stdScmDys.length; ++i) {
                DynamicObject stdScmDy = stdScmDys[i];
                if (stdScmDy == null) continue;
                long stdScmId = stdScmDy.getLong(ID);
                DynamicObjectCollection entryentityColl = stdScmDy.getDynamicObjectCollection("entryentity");
                if (entryentityColl == null) continue;
                for (int j = 0; j < entryentityColl.size(); ++j) {
                    DynamicObject standardItemDy;
                    DynamicObject entryEntity = (DynamicObject)entryentityColl.get(j);
                    if (entryEntity == null || (standardItemDy = entryEntity.getDynamicObject("standarditem")) == null) continue;
                    long standarItemId = standardItemDy.getLong(ID);
                    HashSet<Long> itemIdSet = (HashSet<Long>)stdScmItemsMap.get(stdScmId);
                    if (itemIdSet == null) {
                        itemIdSet = new HashSet<Long>(16);
                    }
                    itemIdSet.add(standarItemId);
                    stdScmItemsMap.put(stdScmId, itemIdSet);
                }
            }
        }
        return stdScmItemsMap;
    }

    private Map<Long, Set<Long>> getsalayStructureItemMap(DynamicObject[] stdScmDys) {
        HashMap<Long, Set<Long>> salayStructureItemsMap = new HashMap<Long, Set<Long>>(16);
        if (stdScmDys != null) {
            for (int i = 0; i < stdScmDys.length; ++i) {
                DynamicObject stdScmDy = stdScmDys[i];
                if (stdScmDy == null) continue;
                long stdScmId = stdScmDy.getLong(ID);
                DynamicObjectCollection entryentityColl = stdScmDy.getDynamicObjectCollection("entryentity");
                if (entryentityColl == null) continue;
                for (int j = 0; j < entryentityColl.size(); ++j) {
                    DynamicObject standardItemDy;
                    DynamicObject entryEntity = (DynamicObject)entryentityColl.get(j);
                    if (entryEntity == null || (standardItemDy = entryEntity.getDynamicObject("standarditem")) == null) continue;
                    long standarItemId = standardItemDy.getLong(ID);
                    HashSet<Long> itemIdSet = (HashSet<Long>)salayStructureItemsMap.get(stdScmId);
                    if (itemIdSet == null) {
                        itemIdSet = new HashSet<Long>(16);
                    }
                    itemIdSet.add(standarItemId);
                    salayStructureItemsMap.put(stdScmId, itemIdSet);
                }
            }
        }
        return salayStructureItemsMap;
    }

    private Map<String, List<Map<String, Object>>> checkDataPermOfOrg(List<Map<String, Object>> paramList, String fieldName, String entity) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, DynamicObject[]> orgDataCacheMap = new HashMap<String, DynamicObject[]>(16);
        if (paramList != null) {
            Map<Long, String> orgNameMap = this.getOrgNameMap(paramList);
            Map<Long, String> structOrStdScmNameMap = this.getStructOrStdScmNameData(paramList, entity);
            for (Map<String, Object> paramMap : paramList) {
                Set<Long> idSet;
                if (paramMap == null || paramMap.isEmpty()) continue;
                Object orgParam = paramMap.get("org");
                Object structParam = paramMap.get(fieldName);
                Long orgId = this.getLongId(orgParam);
                Long structId = this.getLongId(structParam);
                if (orgId == null || structId == null) {
                    passDataList.add(paramMap);
                    continue;
                }
                String cacheKey = entity + KEY_SPLIT_FALG + orgId;
                DynamicObject[] dynamicObjects = (DynamicObject[])orgDataCacheMap.get(cacheKey);
                if (dynamicObjects == null) {
                    SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
                    String selectProperties = "id,name";
                    QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)entity, (Long)orgId);
                    dynamicObjects = helper.query(selectProperties, new QFilter[]{baseDataFilter});
                    orgDataCacheMap.put(cacheKey, dynamicObjects);
                }
                if (!(idSet = this.getIdSetFormDynamicObjects(dynamicObjects)).contains(structId)) {
                    String orgName = orgNameMap.get(orgId);
                    String structName = structOrStdScmNameMap.get(structId);
                    String msg = this.getMessageOfDataPermOfOrg(entity, orgName, structName);
                    Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null);
                    errorInfoList.add(map);
                    continue;
                }
                passDataList.add(paramMap);
            }
        }
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<Long, String> getStructOrStdScmNameData(List<Map<String, Object>> paramList, String entity) {
        HashSet<Long> dataIdSet = new HashSet<Long>(16);
        for (int i = 0; i < paramList.size(); ++i) {
            Object paramObj;
            Map<String, Object> paramMap = paramList.get(i);
            if (paramMap == null || paramMap.isEmpty()) continue;
            Long dataId = null;
            if (HCDM_SALAYSTRUCTURE.equals(entity)) {
                paramObj = paramMap.get("salaystructure");
                dataId = this.getLongId(paramObj);
            } else if (HCDM_STDSCM.equals(entity)) {
                paramObj = paramMap.get("stdscm");
                dataId = this.getLongId(paramObj);
            }
            if (dataId == null) continue;
            dataIdSet.add(dataId);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        String selectProps = "id,name";
        DynamicObject[] dynamicObjects = helper.query(selectProps, new QFilter[]{new QFilter(ID, "in", dataIdSet)});
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject dynamicObject = dynamicObjects[i];
                if (dynamicObject == null) continue;
                dataMap.put(dynamicObject.getLong(ID), dynamicObject.getString("name"));
            }
        }
        return dataMap;
    }

    private String getMessageOfDataPermOfOrg(String entity, String orgName, String structName) {
        if (HCDM_SALAYSTRUCTURE.equals(entity)) {
            if (SWCStringUtils.isEmpty((String)structName)) {
                return ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201c{0}\u201d\u65e0\u85aa\u916c\u7ed3\u6784\u6743\u9650\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_24", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{orgName});
            }
            return ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201c{0}\u201d\u65e0\u85aa\u916c\u7ed3\u6784\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_19", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{orgName, structName});
        }
        if (HCDM_STDSCM.equals(entity)) {
            if (SWCStringUtils.isEmpty((String)structName)) {
                return ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201c{0}\u201d\u65e0\u85aa\u916c\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_25", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{orgName});
            }
            return ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201c{0}\u201d\u65e0\u85aa\u916c\u4f53\u7cfb\u6743\u9650\u201c{1}\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_20", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{orgName, structName});
        }
        return EMPTY_STR;
    }

    private Set<Long> getIdSetFormDynamicObjects(DynamicObject[] dynamicObjects) {
        HashSet<Long> structIdSet = new HashSet<Long>(16);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject == null) continue;
                long dbStructID = dynamicObject.getLong(ID);
                structIdSet.add(dbStructID);
            }
        }
        return structIdSet;
    }

    private Map<Long, String> getOrgNameMap(List<Map<String, Object>> paramList) {
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (Map<String, Object> paramMap : paramList) {
            Object orgParam;
            Long orgId;
            if (paramMap == null || paramMap.isEmpty() || (orgId = this.getLongId(orgParam = paramMap.get("org"))) == null) continue;
            orgIdSet.add(orgId);
        }
        SWCDataServiceHelper orgHelper = new SWCDataServiceHelper(BOS_ORG);
        String selectProp = "id,name";
        DynamicObject[] orgDynamics = orgHelper.query(selectProp, new QFilter[]{new QFilter(ID, "in", orgIdSet)});
        if (orgDynamics != null) {
            for (DynamicObject orgDynamic : orgDynamics) {
                orgNameMap.put(orgDynamic.getLong(ID), orgDynamic.getString("name"));
            }
        }
        return orgNameMap;
    }

    private Map<String, List<Map<String, Object>>> checkSalaryItemRepeat(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        if (passCheckDataList != null) {
            Map<String, Object> paramMap;
            int i;
            HashSet<Integer> errorIndexSet = new HashSet<Integer>(16);
            block0: for (i = 0; i < passCheckDataList.size(); ++i) {
                List decAdjParamData;
                paramMap = passCheckDataList.get(i);
                if (paramMap == null || paramMap.isEmpty() || (decAdjParamData = (List)paramMap.get(DECADJ_DATA)) == null || decAdjParamData.isEmpty()) continue;
                HashSet<Long> itemIdSet = new HashSet<Long>(16);
                for (int j = 0; j < decAdjParamData.size(); ++j) {
                    Object itemId;
                    Long itemLongId;
                    Map decAdjParam = (Map)decAdjParamData.get(j);
                    if (decAdjParam == null || decAdjParam.isEmpty() || (itemLongId = this.getLongId(itemId = decAdjParam.get("standarditem"))) == null) continue;
                    if (itemIdSet.contains(itemLongId)) {
                        String strLong = EMPTY_STR + itemLongId;
                        String message = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u9879\u76ee\u51fa\u73b0\u91cd\u590d\u6570\u636e\u4e3a\uff1a{0}\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_18", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{strLong});
                        Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(paramMap, message, AdjFileErrorMessageEnum.DATA_WRONG, null);
                        faildAdjInfoList.add(map);
                        errorIndexSet.add(i);
                        continue block0;
                    }
                    itemIdSet.add(itemLongId);
                }
            }
            for (i = 0; i < passCheckDataList.size(); ++i) {
                paramMap = passCheckDataList.get(i);
                if (paramMap == null || paramMap.isEmpty() || errorIndexSet.contains(i)) continue;
                passDataList.add(paramMap);
            }
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<Long, DynamicObject> getStructDataMap(Set<Long> structIdSet) {
        DynamicObject[] salaryStructs;
        HashMap<Long, DynamicObject> countrySalaryStructsMap = new HashMap<Long, DynamicObject>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(HCDM_SALAYSTRUCTURE);
        String selectedProps = "id,name,number";
        for (DynamicObject salaryStruct : salaryStructs = serviceHelper.query(selectedProps, new QFilter[]{new QFilter(ID, "in", structIdSet)})) {
            if (salaryStruct == null) continue;
            countrySalaryStructsMap.put(salaryStruct.getLong(ID), salaryStruct);
        }
        return countrySalaryStructsMap;
    }

    private Map<String, List<Map<String, Object>>> checkStdScmBelongStructure(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Long> structIdSet = new HashSet<Long>(16);
        for (Map<String, Object> paramMap : passCheckDataList) {
            Long salayStructureId = this.getLongTypeVal(paramMap, "salaystructure");
            if (salayStructureId == null) continue;
            structIdSet.add(salayStructureId);
        }
        Map<Long, Set<Long>> structureIdAndStdscmIdMap = SalaryAdjFileHelper.getStdscmAllIdsBySalaryStructureIdsNoPerm(structIdSet);
        if (structureIdAndStdscmIdMap == null) {
            structureIdAndStdscmIdMap = new HashMap<Long, Set<Long>>(16);
        }
        Map<Long, DynamicObject> structDataMap = this.getStructDataMap(structIdSet);
        for (Map<String, Object> paramMap : passCheckDataList) {
            Set<Long> stdScmIds;
            if (paramMap == null || paramMap.isEmpty()) continue;
            Long salaryStructID = this.getLongTypeVal(paramMap, "salaystructure");
            Long stdScmId = this.getLongTypeVal(paramMap, "stdscm");
            Long stdScmVId = this.getLongTypeVal(paramMap, "stdscmvid");
            if (null != stdScmVId) {
                stdScmId = stdScmVId;
            }
            if (CollectionUtils.isEmpty(stdScmIds = structureIdAndStdscmIdMap.get(salaryStructID)) || !stdScmIds.contains(stdScmId)) {
                Map<String, Object> errorResMap;
                String msg;
                DynamicObject structDynamicObj = structDataMap.get(salaryStructID);
                if (structDynamicObj == null) {
                    msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u916c\u7ed3\u6784\u4e0d\u5728\u85aa\u916c\u4f53\u7cfb\u4e2d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_14", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                    errorResMap = this.genErrorAdjAndAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null);
                    errorInfoList.add(errorResMap);
                    continue;
                }
                msg = ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u916c\u4f53\u7cfb\u4e0d\u5305\u542b\u201c{0}\u201d\u7684\u85aa\u916c\u7ed3\u6784\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_15", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{structDynamicObj.getString("name")});
                errorResMap = this.genErrorAdjAndAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, null);
                errorInfoList.add(errorResMap);
                continue;
            }
            passDataList.add(paramMap);
        }
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<String, List<Map<String, Object>>> checkSalaryStructs(List<Map<String, Object>> passCheckDataList) {
        Map<Long, Set<Long>> countrySalaryStructsMap = this.getCountrySalaryStructsMap(passCheckDataList);
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            Map<String, Object> paramMap = passCheckDataList.get(i);
            Long countryId = paramMap.get("country") == null ? Long.valueOf(0L) : this.getLongTypeVal(paramMap, "country");
            Long salaryStructureId = paramMap.get("salaystructure") == null ? Long.valueOf(0L) : this.getLongTypeVal(paramMap, "salaystructure");
            Set<Long> salaryStructureIds = countrySalaryStructsMap.get(countryId);
            if (salaryStructureIds != null && !salaryStructureIds.contains(salaryStructureId)) {
                String tips = ResManager.loadKDString((String)"\u85aa\u916c\u7ed3\u6784\u6240\u5c5e\u56fd\u5bb6/\u5730\u533a\u4e0e\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_13", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                Map<String, Object> errorResultMap = this.genErrorAdjAndAdjRecordMap(paramMap, tips, AdjFileErrorMessageEnum.DATA_WRONG, null);
                errorInfoList.add(errorResultMap);
                continue;
            }
            passDataList.add(paramMap);
        }
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<Long, Set<Long>> getCountrySalaryStructsMap(List<Map<String, Object>> passCheckDataList) {
        HashSet<Long> countryIdSet = new HashSet<Long>(16);
        for (Map<String, Object> paramDataMap : passCheckDataList) {
            Long countryId = paramDataMap.get("country") == null ? Long.valueOf(0L) : this.getLongTypeVal(paramDataMap, "country");
            countryIdSet.add(countryId);
        }
        HashMap<Long, Set<Long>> countrySalaryStructsMap = new HashMap<Long, Set<Long>>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(HCDM_SALAYSTRUCTURE);
        String selectedProps = "id,country.id";
        DynamicObject[] salaryStructs = serviceHelper.query(selectedProps, new QFilter[]{new QFilter("country", "in", countryIdSet)});
        for (int i = 0; i < salaryStructs.length; ++i) {
            DynamicObject salaryStruct = salaryStructs[i];
            if (salaryStruct == null) continue;
            long id = salaryStruct.getLong(ID);
            long countryId = salaryStruct.getLong("country.id");
            HashSet<Long> structsIds = (HashSet<Long>)countrySalaryStructsMap.get(countryId);
            if (structsIds == null) {
                structsIds = new HashSet<Long>(16);
            }
            structsIds.add(id);
            countrySalaryStructsMap.put(countryId, structsIds);
        }
        return countrySalaryStructsMap;
    }

    private Map<String, Object> getCheckParamIsEmptyResult(List<Map<String, Object>> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            HashMap<String, Object> methodReturnMap = new HashMap<String, Object>(16);
            methodReturnMap.put("success", Boolean.FALSE);
            String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjFileInfoServiceHelper_2", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            methodReturnMap.put("message", message);
            methodReturnMap.put("data", new ArrayList(10));
            return methodReturnMap;
        }
        return null;
    }

    private Map<String, List<Map<String, Object>>> checkUniqueCodeRepeat(List<Map<String, Object>> passCheckDataList) {
        String uniCode;
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Integer> unicodeCoutMap = new HashMap<String, Integer>(16);
        for (Map<String, Object> dataMap : passCheckDataList) {
            Integer count;
            uniCode = (String)dataMap.get("uniquecode");
            Integer n = count = unicodeCoutMap.get(uniCode) == null ? Integer.valueOf(0) : (Integer)unicodeCoutMap.get(uniCode);
            Integer n2 = count = Integer.valueOf(count + 1);
            unicodeCoutMap.put(uniCode, count);
        }
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            Map<String, Object> dataMap;
            dataMap = passCheckDataList.get(i);
            uniCode = (String)dataMap.get("uniquecode");
            Integer integer = (Integer)unicodeCoutMap.get(uniCode);
            if (integer != null && integer >= 2) {
                String message = ResManager.loadKDString((String)"uniquecode:{0}\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_3", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{uniCode});
                Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(dataMap, message, AdjFileErrorMessageEnum.DATA_WRONG, null);
                faildAdjInfoList.add(map);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, Object> genErrorAdjAndAdjRecordMap(Map<String, Object> paramMap, String msg, AdjFileErrorMessageEnum codeRepeatEnum, Object adjFileId) {
        if (paramMap == null || paramMap.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        Map<String, Object> adjResMap = this.genErrorResultMap(codeRepeatEnum, msg, paramMap, adjFileId);
        List decAdjParamData = (List)paramMap.get(DECADJ_DATA);
        ArrayList<Map<String, Object>> decAdjDataResList = new ArrayList<Map<String, Object>>(10);
        if (decAdjParamData != null) {
            for (int j = 0; j < decAdjParamData.size(); ++j) {
                Map decAdjMap = (Map)decAdjParamData.get(j);
                Map<String, Object> errorAdjRecResMap = this.genErrorAdjRecResMap(codeRepeatEnum, msg, decAdjMap);
                decAdjDataResList.add(errorAdjRecResMap);
            }
        }
        adjResMap.put(DECADJ_DATA, decAdjDataResList);
        return adjResMap;
    }

    private Map<String, Object> genErrorAdjAndSpecAdjRecordMap(Map<String, Object> paramMap, String msg, AdjFileErrorMessageEnum codeRepeatEnum, Object adjFileId, Integer errorAdjRecordIndex) {
        if (paramMap == null || paramMap.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        Map<String, Object> adjResMap = this.genErrorResultMap(codeRepeatEnum, msg, paramMap, adjFileId);
        List decAdjParamData = (List)paramMap.get(DECADJ_DATA);
        if (errorAdjRecordIndex == null) {
            ArrayList<Map<String, Object>> decAdjDataResList = new ArrayList<Map<String, Object>>(10);
            if (decAdjParamData != null) {
                for (int j = 0; j < decAdjParamData.size(); ++j) {
                    Map decAdjMap = (Map)decAdjParamData.get(j);
                    Map<String, Object> errorAdjRecResMap = this.genErrorAdjRecResMap(codeRepeatEnum, msg, decAdjMap);
                    decAdjDataResList.add(errorAdjRecResMap);
                }
            }
            adjResMap.put(DECADJ_DATA, decAdjDataResList);
        } else {
            ArrayList<Map<String, Object>> decAdjDataResList = new ArrayList<Map<String, Object>>(10);
            if (decAdjParamData != null) {
                for (int j = 0; j < decAdjParamData.size(); ++j) {
                    Map<String, Object> errorAdjRecResMap;
                    Map decAdjMap;
                    if (j == errorAdjRecordIndex) {
                        decAdjMap = (Map)decAdjParamData.get(j);
                        errorAdjRecResMap = this.genErrorAdjRecResMap(codeRepeatEnum, msg, decAdjMap);
                        decAdjDataResList.add(errorAdjRecResMap);
                        continue;
                    }
                    decAdjMap = (Map)decAdjParamData.get(j);
                    errorAdjRecResMap = this.genNomalAdjRecResMap(decAdjMap);
                    decAdjDataResList.add(errorAdjRecResMap);
                }
            }
            adjResMap.put(DECADJ_DATA, decAdjDataResList);
        }
        return adjResMap;
    }

    private Map<String, Object> dealNewOrTempSaveAdjFile(Map<String, Object> dataHelperMap, Map<String, Object> paramMap, DynamicObject adjFileInfo) throws ParseException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        ArrayList<DynamicObject> needSaveNoRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needSaveWithStatusNoRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needSaveWithStatusList = new ArrayList<DynamicObject>(10);
        ArrayList<DecAdjSalaryEntity> decAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
        List decAdjDataList = (List)paramMap.get(DECADJ_DATA);
        if (decAdjDataList == null || decAdjDataList.isEmpty()) {
            String statusParam = (String)paramMap.get(OPERATIONCODE);
            if (AUDIT.equalsIgnoreCase(statusParam)) {
                needSaveWithStatusNoRecordList.add(adjFileInfo);
            } else {
                needSaveNoRecordList.add(adjFileInfo);
            }
        } else {
            DecAdjSalaryEntity decAdjSalaryEntity = new DecAdjSalaryEntity();
            decAdjSalaryEntity.setSalaryadjfileId(Long.valueOf(adjFileInfo.getLong(ID)));
            decAdjSalaryEntity.setBussinessId(this.getLongTypeVal(paramMap, BUSSINESSID));
            this.setAdjRecordAndRelPerson(dataHelperMap, paramMap, adjFileInfo, decAdjSalaryEntity);
            decAdjSalaryEntityList.add(decAdjSalaryEntity);
            needSaveWithStatusList.add(adjFileInfo);
        }
        returnMap.put(NEED_SAVE_NO_RECORD_LIST, needSaveNoRecordList);
        returnMap.put(NEED_SAVE_WITH_STATUS_NO_RECORD_LIST, needSaveWithStatusNoRecordList);
        returnMap.put(NEED_SAVE_WITH_STATUS_LIST, needSaveWithStatusList);
        returnMap.put(DEC_ADJ_SALARY_ENTITY_LIST, decAdjSalaryEntityList);
        return returnMap;
    }

    private List<Map<String, Object>> batchSaveAdjFile(List<Map<String, Object>> paramList, String uuid, boolean endOperate) throws ParseException {
        LOG.info("batchSaveAdjFile begin time {}", (Object)TimeServiceHelper.getTimeStamp());
        ArrayList<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> errorDataList = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> dataHelperMap = this.getDataHelperMap(paramList);
        HashMap<String, DynamicObject> adjFileInfoMap = new HashMap<String, DynamicObject>(16);
        paramList = this.getAdjFileInfoMapFromDb(paramList, adjFileInfoMap, dataHelperMap, errorDataList);
        Map<String, Long> keyIdMappingMap = this.generateAdjFileId(paramList, adjFileInfoMap, dataHelperMap);
        ArrayList<DynamicObject> needSaveNoRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needSaveWithStatusNoRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needSaveWithStatusList = new ArrayList<DynamicObject>(10);
        ArrayList<DecAdjSalaryEntity> decAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
        ArrayList<DynamicObject> updateAuditAdjInfoList = new ArrayList<DynamicObject>(10);
        ArrayList<DecAdjSalaryEntity> updateAuditDecAdjSalList = new ArrayList<DecAdjSalaryEntity>(10);
        ArrayList<DynamicObject> effectAdjFileList = new ArrayList<DynamicObject>(10);
        ArrayList<DecAdjSalaryEntity> effectAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
        HashMap<Long, Map<String, Object>> idDataMap = new HashMap<Long, Map<String, Object>>(16);
        String needRepush = ADJ_FILE_TYPE_PRIMARY_JOB;
        for (Map<String, Object> paramMap : paramList) {
            Map<String, Object> returnMap;
            DynamicObject adjFileDyInfo;
            String key;
            Object depEmpParam;
            Long depEmpId;
            if (null != paramMap.get(NEEDREPUSH)) {
                needRepush = ObjectUtils.getDisplayString((Object)paramMap.get(NEEDREPUSH));
            }
            if (this.checkDepempEmployee(errorDataList, dataHelperMap, paramMap, depEmpId = this.getLongId(depEmpParam = paramMap.get("depemp")))) continue;
            Map depEmpPosOrgRelMap = (Map)dataHelperMap.get("EMP_POS_ORG_MAP");
            DynamicObject empPosOrgRelDy = (DynamicObject)depEmpPosOrgRelMap.get(depEmpId);
            Object adjFileInfoObject = paramMap.get(ADJ_FILE_INFO);
            if (adjFileInfoObject != null && this.getLongId(adjFileInfoObject) != 0L) {
                key = String.valueOf(this.getLongId(adjFileInfoObject));
                adjFileDyInfo = (DynamicObject)adjFileInfoMap.get(key);
                if (adjFileDyInfo == null) {
                    Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"AdjFileInfoServiceHelper_28", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.DATA_WRONG, this.getLongId(adjFileInfoObject), null);
                    errorDataList.add(errInfo);
                    continue;
                }
                if (!this.checkParamKeyword(adjFileDyInfo, paramMap, dataHelperMap, errorDataList)) {
                    continue;
                }
            } else {
                key = this.getUniqueKey(empPosOrgRelDy, paramMap);
                adjFileDyInfo = (DynamicObject)adjFileInfoMap.get(key);
            }
            if (this.checkEscrowStaff(errorDataList, paramMap, adjFileInfoObject)) continue;
            if (adjFileDyInfo == null || adjFileDyInfo.getPkValue() == null) {
                DynamicObject adjFileInfo = this.covert2AdjFileInfo(paramMap, dataHelperMap);
                Long fieldId = keyIdMappingMap.get(key);
                adjFileInfo.set(ID, (Object)fieldId);
                idDataMap.put(fieldId, paramMap);
                returnMap = this.dealNewOrTempSaveAdjFile(dataHelperMap, paramMap, adjFileInfo);
                needSaveNoRecordList.addAll((List)returnMap.get(NEED_SAVE_NO_RECORD_LIST));
                needSaveWithStatusNoRecordList.addAll((List)returnMap.get(NEED_SAVE_WITH_STATUS_NO_RECORD_LIST));
                needSaveWithStatusList.addAll((List)returnMap.get(NEED_SAVE_WITH_STATUS_LIST));
                decAdjSalaryEntityList.addAll((List)returnMap.get(DEC_ADJ_SALARY_ENTITY_LIST));
                continue;
            }
            String status = adjFileDyInfo.getString(STATUS);
            idDataMap.put(adjFileDyInfo.getLong("boid"), paramMap);
            idDataMap.putIfAbsent(adjFileDyInfo.getLong(ID), paramMap);
            Map adjInfoFieldDataMap = (Map)dataHelperMap.get("ADJ_FILE_INFO_MAP");
            if (AdjFileStatusEnum.AUDIT.getCode().equals(status)) {
                this.updateAdjFileObjInfo(dataHelperMap, paramMap, adjInfoFieldDataMap, adjFileDyInfo);
                returnMap = this.dealAudit(dataHelperMap, paramMap, adjFileDyInfo);
                updateAuditAdjInfoList.addAll((List)returnMap.get(UPDATE_AUDIT_ADJ_INFO_LIST));
                updateAuditDecAdjSalList.addAll((List)returnMap.get(UPDATE_AUDIT_DEC_ADJ_SAL_LIST));
                continue;
            }
            if (AdjFileStatusEnum.SUBMIT.getCode().equals(status)) {
                String number = adjFileDyInfo.getString(NUMBER);
                String msg = ResManager.loadKDString((String)"\u5458\u5de5\u5b9a\u8c03\u85aa\u6863\u6848\uff1a{0}\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5199\u5165\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjFileInfoServiceHelper_4", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{number});
                Map<String, Object> errorResMap = this.genErrorAdjAndAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.STATUS_WRONG, adjFileDyInfo.getLong(ID));
                errorDataList.add(errorResMap);
                continue;
            }
            if (AdjFileStatusEnum.STORAGE.getCode().equals(status)) {
                this.updateAdjFileObjInfo(dataHelperMap, paramMap, adjInfoFieldDataMap, adjFileDyInfo);
                returnMap = this.dealNewOrTempSaveAdjFile(dataHelperMap, paramMap, adjFileDyInfo);
                needSaveNoRecordList.addAll((List)returnMap.get(NEED_SAVE_NO_RECORD_LIST));
                needSaveWithStatusNoRecordList.addAll((List)returnMap.get(NEED_SAVE_WITH_STATUS_NO_RECORD_LIST));
                needSaveWithStatusList.addAll((List)returnMap.get(NEED_SAVE_WITH_STATUS_LIST));
                decAdjSalaryEntityList.addAll((List)returnMap.get(DEC_ADJ_SALARY_ENTITY_LIST));
                continue;
            }
            if (!AdjFileStatusEnum.EXPIRED.getCode().equals(status)) continue;
            Date bSedDate = this.covert2DateOfNoTime(paramMap.get(BSED));
            Date bSledDate = adjFileDyInfo.getDate(BSED);
            bSledDate = this.setDateTime2Zero(bSledDate);
            if (bSedDate != null && bSledDate != null && bSedDate.compareTo(bSledDate) < 0) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u8c03\u6574\u65e5\u671f\uff0c\u4f7f\u6570\u636e\u751f\u6548\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u6863\u6848\u5931\u6548\u65e5\u671f\u3002", (String)"AdjFileInfoServiceHelper_6", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                Map<String, Object> errorResMap = this.genErrorAdjAndAdjRecordMap(paramMap, msg, AdjFileErrorMessageEnum.DATA_WRONG, adjFileDyInfo.getLong(ID));
                errorDataList.add(errorResMap);
                continue;
            }
            this.updateAdjFileObjInfo(dataHelperMap, paramMap, adjInfoFieldDataMap, adjFileDyInfo);
            Map<String, Object> returnMap2 = this.dealDiscardAdjFile(dataHelperMap, paramMap, adjFileDyInfo);
            effectAdjFileList.addAll((List)returnMap2.get(EFFECT_ADJ_FILE_LIST));
            effectAdjSalaryEntityList.addAll((List)returnMap2.get(EFFECT_ADJ_SALARY_ENTITY_LIST));
        }
        returnDataList.addAll(errorDataList);
        ArrayList<DecAdjSalaryEntity> allDecAdjSalarys = new ArrayList<DecAdjSalaryEntity>(10);
        allDecAdjSalarys.addAll(decAdjSalaryEntityList);
        allDecAdjSalarys.addAll(updateAuditDecAdjSalList);
        allDecAdjSalarys.addAll(effectAdjSalaryEntityList);
        HashMap<Long, Set<Long>> fileItemIdMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> adjFieldSetOfDecat = new HashSet<Long>(16);
        this.getParamsForJudge(allDecAdjSalarys, fileItemIdMap, adjFieldSetOfDecat);
        Map<Long, Map<Long, Date>> forAdjBillMap = this.adjFileApplicationService.getMaxBsedOfRecordForAdjType(fileItemIdMap);
        Map<Long, Date> maxBsedOfFileForDecMap = this.adjFileApplicationService.getMaxBsedOfRecordForDecType(adjFieldSetOfDecat);
        this.saveAdjFileNoRecord(returnDataList, needSaveNoRecordList, idDataMap);
        this.saveAdjFileNoRecordAudit(returnDataList, needSaveWithStatusNoRecordList, idDataMap);
        this.checkAdjRecordEffectDate(returnDataList, needSaveWithStatusList, decAdjSalaryEntityList, idDataMap, forAdjBillMap, maxBsedOfFileForDecMap);
        this.saveAdjFileHasRecord2Audit(returnDataList, needSaveWithStatusList, decAdjSalaryEntityList, idDataMap, uuid, needRepush);
        this.checkAdjRecordEffectDate(returnDataList, updateAuditAdjInfoList, updateAuditDecAdjSalList, idDataMap, forAdjBillMap, maxBsedOfFileForDecMap);
        this.saveAuditedAdjFile(returnDataList, updateAuditAdjInfoList, updateAuditDecAdjSalList, idDataMap, uuid, needRepush);
        this.checkAdjRecordEffectDate(returnDataList, effectAdjFileList, effectAdjSalaryEntityList, idDataMap, forAdjBillMap, maxBsedOfFileForDecMap);
        this.effectAndSaveAdjFile(returnDataList, effectAdjFileList, effectAdjSalaryEntityList, idDataMap, uuid);
        LOG.info("batchSaveAdjFile end time {}", (Object)TimeServiceHelper.getTimeStamp());
        return returnDataList;
    }

    private void setAdjFileEscrowStaff(Map<String, Object> paramMap, DynamicObject adjFileDyInfo) {
        Long assoAdminOrgId = this.getLongTypeVal(paramMap, "assoadminorg");
        Long adminOrgId = this.getLongTypeVal(paramMap, "adminorg");
        if (adminOrgId != null && assoAdminOrgId != null) {
            adjFileDyInfo.set("escrowstaff", (Object)(!adminOrgId.equals(assoAdminOrgId) ? 1 : 0));
        }
    }

    private boolean checkEscrowStaff(List<Map<String, Object>> errorDataList, Map<String, Object> paramMap, Object adjFileInfoObject) {
        if (paramMap.containsKey("escrowstaff")) {
            Long assoAdminOrgId = this.getLongTypeVal(paramMap, "assoadminorg");
            Long adminOrgId = this.getLongTypeVal(paramMap, "adminorg");
            boolean escrowstaff = this.getBooleanTypeVal(paramMap, "escrowstaff");
            if (adminOrgId != null && assoAdminOrgId != null && (adminOrgId.equals(assoAdminOrgId) && escrowstaff || !adminOrgId.equals(assoAdminOrgId) && !escrowstaff)) {
                Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u4e0e\u884c\u653f\u7ec4\u7ec7\u76f8\u540c\u65f6\uff0c\u4e3a\u975e\u4ee3\u7ba1\u5458\u5de5\uff1b\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u4e0e\u884c\u653f\u7ec4\u7ec7\u4e0d\u540c\u65f6\uff0c\u4e3a\u4ee3\u7ba1\u5458\u5de5\uff1b\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_40", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.DATA_WRONG, this.getLongId(adjFileInfoObject), null);
                errorDataList.add(errInfo);
                return true;
            }
        }
        return false;
    }

    private boolean checkDepempEmployee(List<Map<String, Object>> errorDataList, Map<String, Object> dataHelperMap, Map<String, Object> paramMap, Long depEmpId) {
        Long employeeId;
        Map employeeDepempMap = (Map)dataHelperMap.get("EMPLOYEE_DEPEMP_MAP");
        List depemps = (List)employeeDepempMap.get(employeeId = (Long)paramMap.get("employee"));
        if (depemps == null || depemps.size() == 0) {
            Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4eba\u4e0d\u5c5e\u4e8e\u8be5\u4f01\u4e1a\u4eba\u3002", (String)"AdjFileInfoServiceHelper_27", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.DATA_WRONG, null, null);
            errorDataList.add(errInfo);
            return true;
        }
        if (!depemps.contains(depEmpId)) {
            Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4eba\u4e0d\u5c5e\u4e8e\u8be5\u4f01\u4e1a\u4eba\u3002", (String)"AdjFileInfoServiceHelper_27", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.DATA_WRONG, null, null);
            errorDataList.add(errInfo);
            return true;
        }
        List decAdjDataList = (List)paramMap.get(DECADJ_DATA);
        if (decAdjDataList != null && !decAdjDataList.isEmpty()) {
            for (Map decAdjData : decAdjDataList) {
                Object depemp;
                Long depempId;
                Map relPersonDataMap;
                if (decAdjData == null || (relPersonDataMap = (Map)decAdjData.get(RELPERSON_DATA)) == null || depemps.contains(depempId = this.getLongId(depemp = relPersonDataMap.get("depemp")))) continue;
                Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4eba\u4e0d\u5c5e\u4e8e\u8be5\u4f01\u4e1a\u4eba\u3002", (String)"AdjFileInfoServiceHelper_27", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.DATA_WRONG, null, null);
                errorDataList.add(errInfo);
                return true;
            }
        }
        return false;
    }

    private boolean checkParamKeyword(DynamicObject adjFileDyInfo, Map<String, Object> paramMap, Map<String, Object> dataHelperMap, List<Map<String, Object>> errorDataList) {
        Object depEmpParam;
        Long depEmpId;
        Map depEmpPosOrgRelMap = (Map)dataHelperMap.get("EMP_POS_ORG_MAP");
        DynamicObject empPosOrgRelDy = (DynamicObject)depEmpPosOrgRelMap.get(depEmpId = this.getLongId(depEmpParam = paramMap.get("depemp")));
        if (empPosOrgRelDy == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4ebaID\uff1a{0}\u6ca1\u6709\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_23", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            Long adjFileId = null;
            if (adjFileDyInfo != null) {
                adjFileId = adjFileDyInfo.getLong(ID);
            }
            Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG, adjFileId, null);
            errorDataList.add(errInfo);
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object employee = paramMap.get("employee");
        Long employeeID = this.getLongId(employee);
        if (adjFileDyInfo.getLong("employee.id") != employeeID.longValue()) {
            stringBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba:{0}", (String)"AdjFileInfoServiceHelper_33", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), employee));
        }
        Object org = paramMap.get("org");
        Long orgID = this.getLongId(org);
        if (adjFileDyInfo.getLong("org.id") != orgID.longValue()) {
            stringBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7:{0}", (String)"AdjFileInfoServiceHelper_30", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), org));
        }
        Object country = paramMap.get("country");
        Long countryId = this.getLongId(country);
        if (adjFileDyInfo.getLong("country.id") != countryId.longValue()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\u3001');
            }
            stringBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u916c\u7ba1\u7406\u5c5e\u5730:{0}", (String)"AdjFileInfoServiceHelper_31", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), country));
        }
        Object stdscm = paramMap.get("stdscm");
        Long stdScmId = this.getLongId(stdscm);
        if (adjFileDyInfo.getLong("stdscm.id") != stdScmId.longValue()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\u3001');
            }
            stringBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u916c\u4f53\u7cfb:{0}", (String)"AdjFileInfoServiceHelper_32", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), stdscm));
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(ResManager.loadKDString((String)"\u4e0e\u5b9a\u8c03\u85aa\u6863\u6848\u57fa\u672c\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_34", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]));
            Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(paramMap, stringBuilder.toString(), AdjFileErrorMessageEnum.DATA_WRONG, adjFileDyInfo.getLong(ID), null);
            errorDataList.add(errInfo);
            return false;
        }
        return true;
    }

    private void checkAdjRecordEffectDate(List<Map<String, Object>> returnDataList, List<DynamicObject> needSaveWithStatusList, List<DecAdjSalaryEntity> decAdjSalaryEntityList, Map<Long, Map<String, Object>> idDataMap, Map<Long, Map<Long, Date>> forAdjBillMap, Map<Long, Date> maxBsedOfFileForDecMap) {
        for (int i = 0; i < decAdjSalaryEntityList.size(); ++i) {
            AdjAttributionType billType;
            DecAdjSalaryEntity decAdjSalary = decAdjSalaryEntityList.get(i);
            if (decAdjSalary == null || (billType = decAdjSalary.getBillType()) == null) continue;
            Long adjFileId = decAdjSalary.getSalaryadjfileId();
            Map<Long, Date> maxDateEntityMap = forAdjBillMap.get(adjFileId);
            if (AdjAttributionType.ADJATTRTYPE.getCode().equals(billType.getCode())) {
                this.doCheckAdjTypeData(returnDataList, needSaveWithStatusList, decAdjSalaryEntityList, idDataMap, decAdjSalary, adjFileId, maxDateEntityMap);
                continue;
            }
            if (!AdjAttributionType.DECATTRTYPE.getCode().equals(billType.getCode())) continue;
            this.doCheckDecATTR(returnDataList, needSaveWithStatusList, decAdjSalaryEntityList, idDataMap, maxBsedOfFileForDecMap, decAdjSalary, adjFileId);
        }
    }

    private void doCheckDecATTR(List<Map<String, Object>> returnDataList, List<DynamicObject> needSaveWithStatusList, List<DecAdjSalaryEntity> decAdjSalaryEntityList, Map<Long, Map<String, Object>> idDataMap, Map<Long, Date> maxBsedOfFileForDecMap, DecAdjSalaryEntity decAdjSalary, Long adjFileId) {
        List salaryAdjRecordRelPersonDynEntities = decAdjSalary.getSalaryAdjRecordRelPersonDynEntities();
        if (salaryAdjRecordRelPersonDynEntities != null) {
            for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                Date dbDate;
                DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                Date bsedDate = (Date)salaryAdjRecord.get(BSED);
                if (bsedDate == null || adjFileId == null) continue;
                Date dateCompare = this.setDateTime2Zero(bsedDate);
                salaryAdjRecord.set(BSED, (Object)dateCompare);
                if (maxBsedOfFileForDecMap == null || (dbDate = maxBsedOfFileForDecMap.get(adjFileId)) == null || dateCompare.compareTo(dbDate) > 0) continue;
                String formatEntBsed = SWCDateTimeUtils.format((Date)bsedDate, (String)"yyyy-MM-dd");
                String formatMaxBsed = SWCDateTimeUtils.format((Date)dbDate, (String)"yyyy-MM-dd");
                String message = ResManager.loadKDString((String)"\u5165\u53c2\u751f\u6548\u65e5\u671f{0}\u9700\u5927\u4e8e\u5f53\u524d\u6863\u6848\u4e0b\u9879\u76ee\u6700\u5927\u53ef\u7528\u7248\u672c\u7684\u751f\u6548\u65e5\u671f{1}\u3002", (String)"AdjFileInfoServiceHelper_17", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{formatEntBsed, formatMaxBsed});
                Map<String, Object> map = idDataMap.get(adjFileId);
                Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(map, message, AdjFileErrorMessageEnum.DATA_WRONG, adjFileId);
                returnDataList.add(errorMap);
                this.removeErrorData(needSaveWithStatusList, decAdjSalaryEntityList, idDataMap, adjFileId);
            }
        }
    }

    private void doCheckAdjTypeData(List<Map<String, Object>> returnDataList, List<DynamicObject> needSaveWithStatusList, List<DecAdjSalaryEntity> decAdjSalaryEntityList, Map<Long, Map<String, Object>> idDataMap, DecAdjSalaryEntity decAdjSalary, Long adjFileId, Map<Long, Date> maxDateEntityMap) {
        List salaryAdjRecordRelPersonDynEntities = decAdjSalary.getSalaryAdjRecordRelPersonDynEntities();
        if (salaryAdjRecordRelPersonDynEntities != null) {
            for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                Date bsedDate;
                Long longId;
                DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                Object standarditem = salaryAdjRecord.get("standarditem");
                if (standarditem == null || (longId = this.getLongId(standarditem)) == null || (bsedDate = (Date)salaryAdjRecord.get(BSED)) == null || adjFileId == null) continue;
                Date dateCompare = this.setDateTime2Zero(bsedDate);
                salaryAdjRecord.set(BSED, (Object)dateCompare);
                Date dbDate = maxDateEntityMap.get(longId);
                if (null == dbDate || dateCompare.compareTo(dbDate) > 0) continue;
                String formatEntBsed = SWCDateTimeUtils.format((Date)bsedDate, (String)"yyyy-MM-dd");
                String formatMaxBsed = SWCDateTimeUtils.format((Date)dbDate, (String)"yyyy-MM-dd");
                Map<String, Object> map = idDataMap.get(adjFileId);
                String message = ResManager.loadKDString((String)"\u5165\u53c2\u751f\u6548\u65e5\u671f{0}\u9700\u5927\u4e8e\u7cfb\u7edf\u5185\u73b0\u6709\u5b9a\u8c03\u85aa\u6570\u636e\u751f\u6548\u65e5\u671f{1}\u3002", (String)"AdjFileInfoServiceHelper_16", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{formatEntBsed, formatMaxBsed});
                Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(map, message, AdjFileErrorMessageEnum.DATA_WRONG, adjFileId);
                returnDataList.add(errorMap);
                this.removeErrorData(needSaveWithStatusList, decAdjSalaryEntityList, idDataMap, adjFileId);
            }
        }
    }

    private void removeErrorData(List<DynamicObject> needSaveWithStatusList, List<DecAdjSalaryEntity> decAdjSalaryEntityList, Map<Long, Map<String, Object>> idDataMap, Long adjFileId) {
        Iterator<DynamicObject> iterator = needSaveWithStatusList.iterator();
        while (iterator.hasNext()) {
            Long longID;
            Object id;
            DynamicObject next = iterator.next();
            if (next == null || (id = next.get("boid")) == null || (longID = this.getLongId(id)) == null || longID.longValue() != adjFileId.longValue()) continue;
            iterator.remove();
        }
        Iterator<DecAdjSalaryEntity> iterator1 = decAdjSalaryEntityList.iterator();
        while (iterator1.hasNext()) {
            Long id;
            DecAdjSalaryEntity next = iterator1.next();
            if (next == null || (id = next.getSalaryadjfileId()) == null || id.longValue() != adjFileId.longValue()) continue;
            iterator1.remove();
        }
        idDataMap.remove(adjFileId);
    }

    private void getParamsForJudge(List<DecAdjSalaryEntity> allDecAdjSalarys, Map<Long, Set<Long>> fileItemIdMap, Set<Long> adjFieldSetOfDecat) {
        for (DecAdjSalaryEntity decAdjSalary : allDecAdjSalarys) {
            Long adjFileId;
            AdjAttributionType billType;
            if (decAdjSalary == null || (billType = decAdjSalary.getBillType()) == null || (adjFileId = decAdjSalary.getSalaryadjfileId()) == null) continue;
            if (AdjAttributionType.ADJATTRTYPE.getCode().equals(billType.getCode())) {
                List salaryAdjRecordRelPersonDynEntities;
                Set<Long> itemIdSet = fileItemIdMap.get(adjFileId);
                if (itemIdSet == null) {
                    itemIdSet = new HashSet<Long>(16);
                }
                if ((salaryAdjRecordRelPersonDynEntities = decAdjSalary.getSalaryAdjRecordRelPersonDynEntities()) != null) {
                    for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                        Object standarditemIdObj;
                        Long standarItemID;
                        DynamicObject adjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
                        if (adjRecord == null || (standarItemID = this.getLongId(standarditemIdObj = adjRecord.get("standarditem"))) == null) continue;
                        itemIdSet.add(standarItemID);
                    }
                }
                fileItemIdMap.put(adjFileId, itemIdSet);
            }
            adjFieldSetOfDecat.add(adjFileId);
        }
    }

    private void effectAndSaveAdjFile(List<Map<String, Object>> returnDataList, List<DynamicObject> effectAdjFileList, List<DecAdjSalaryEntity> effectAdjSalaryEntityList, Map<Long, Map<String, Object>> idDataMap, String uuid) {
        if (CollectionUtils.isNotEmpty(effectAdjFileList)) {
            for (int i = 0; i < effectAdjFileList.size(); ++i) {
                DynamicObject adjFileInfo = effectAdjFileList.get(i);
                long boid = adjFileInfo.getLong("boid");
                Map<String, Object> paramMap = idDataMap.get(boid);
                ArrayList<DecAdjSalaryEntity> currentAdjFileDecs = new ArrayList<DecAdjSalaryEntity>(10);
                for (int j = 0; j < effectAdjSalaryEntityList.size(); ++j) {
                    Long salaryAdjFileId;
                    DecAdjSalaryEntity decAdjSalaryEntity = effectAdjSalaryEntityList.get(j);
                    long boId = adjFileInfo.getLong("boid");
                    if (decAdjSalaryEntity == null || boId != (salaryAdjFileId = decAdjSalaryEntity.getSalaryadjfileId())) continue;
                    currentAdjFileDecs.add(decAdjSalaryEntity);
                }
                List<Map<String, Object>> lists = this.effectAndSaveAdjFileSingle(adjFileInfo, paramMap, currentAdjFileDecs, uuid);
                returnDataList.addAll(lists);
            }
        }
    }

    private List<Map<String, Object>> effectAndSaveAdjFileSingle(DynamicObject adjFileDy, Map<String, Object> paramMap, List<DecAdjSalaryEntity> decAdjSalaryEntityList, String uuid) {
        ArrayList<Map<String, Object>> resultList;
        block23: {
            resultList = new ArrayList<Map<String, Object>>(10);
            if (adjFileDy == null) {
                return resultList;
            }
            try (TXHandle txHandle = TX.required();){
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    OperationServiceImpl opImpl = new OperationServiceImpl();
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ishasright", TRUE);
                    operateOption.setVariableValue("skipCheckDataPermission", TRUE);
                    operateOption.setVariableValue("skipCheckSpecialDataPermission", TRUE);
                    Date bsedDate = adjFileDy.getDate(BSED);
                    long boid = adjFileDy.getLong("boid");
                    String dateStr = format.format(bsedDate);
                    operateOption.setVariableValue("var_bsed", dateStr);
                    DynamicObject[] adjFileArr = new DynamicObject[]{adjFileDy};
                    adjFileDy.set(STATUS, (Object)AdjFileStatusEnum.EXPIRED.getCode());
                    OperationResult operationResult = opImpl.localInvokeOperation("donothing_effect", adjFileArr, operateOption);
                    if (operationResult == null) break block23;
                    List successPkIds = operationResult.getSuccessPkIds();
                    if (operationResult.isSuccess()) {
                        HashSet<String> ignoreSet = new HashSet<String>(16);
                        ignoreSet.add(ID);
                        ignoreSet.add("masterid");
                        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
                        adjFileDy.set(STATUS, (Object)AdjFileStatusEnum.AUDIT.getCode());
                        adjFileDy.set("enable", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
                        DynamicObject emptyAdjFile = helper.generateEmptyDynamicObject();
                        HRDynamicObjectUtils.copy((DynamicObject)adjFileDy, (DynamicObject)emptyAdjFile, ignoreSet, (boolean)true);
                        DynamicObject[] adjFileArr2 = new DynamicObject[]{emptyAdjFile};
                        HisResponse response = BaseDataHisHelper.saveTimeVersion((DynamicObject[])adjFileArr2, (boolean)true);
                        String errorMessage = response.getErrorMessage();
                        if (SWCStringUtils.isNotEmpty((String)errorMessage)) {
                            Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(paramMap, errorMessage, AdjFileErrorMessageEnum.EFFECT_FAIL, boid);
                            resultList.add(map);
                        } else if (successPkIds != null && !successPkIds.isEmpty()) {
                            if (decAdjSalaryEntityList != null && !decAdjSalaryEntityList.isEmpty()) {
                                this.adjFileApplicationService.saveTimeVersionForBill(decAdjSalaryEntityList, new DecAdjSalaryEvent(uuid));
                            }
                            String newPkId = ((VersionChangeRespData)response.getData()).getNewDynamicObjects()[0].getString(ID);
                            Map<String, Object> map = this.genSuccessResultMap(paramMap, boid, Long.valueOf(newPkId));
                            resultList.add(map);
                        }
                        break block23;
                    }
                    ArrayList<String> errorList = new ArrayList<String>(10);
                    String msgString = operationResult.getMessage();
                    if (SWCStringUtils.isNotEmpty((String)msgString)) {
                        errorList.add(msgString);
                    }
                    List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                    for (int i = 0; i < allErrorOrValidateInfo.size(); ++i) {
                        IOperateInfo operateInfo = (IOperateInfo)allErrorOrValidateInfo.get(i);
                        String message = operateInfo.getMessage();
                        if (!SWCStringUtils.isNotEmpty((String)message)) continue;
                        errorList.add(message);
                    }
                    Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(paramMap, this.assembleErrorMsg(errorList), AdjFileErrorMessageEnum.SAVE_FAIL, boid);
                    resultList.add(errorMap);
                }
                catch (KDBizException e) {
                    txHandle.markRollback();
                    LOG.error("AdjFileInfoServiceHelper executeOp error, msg: ", (Throwable)e);
                    long boid = adjFileDy.getLong("boid");
                    Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(paramMap, e.getMessage(), AdjFileErrorMessageEnum.SAVE_FAIL, boid);
                    resultList.add(errorMap);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    LOG.error("AdjFileInfoServiceHelper executeOp error, msg: ", (Throwable)e);
                    long boid = adjFileDy.getLong("boid");
                    Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(paramMap, e.getMessage(), AdjFileErrorMessageEnum.UNKNOW_ERROR, boid);
                    resultList.add(errorMap);
                }
            }
        }
        return resultList;
    }

    private void saveAuditedAdjFile(List<Map<String, Object>> returnDataList, List<DynamicObject> updateAuditAdjInfoList, List<DecAdjSalaryEntity> updateAuditDecAdjSalList, Map<Long, Map<String, Object>> idDataMap, String uuid, String needRepush) {
        if (CollectionUtils.isNotEmpty(updateAuditAdjInfoList)) {
            Map<Long, Map<String, Object>> needSaveMap = AdjFileInfoServiceHelper.getMappingSaveMap(updateAuditAdjInfoList, idDataMap);
            List<Map<String, Object>> opResults = this.batchExecuteOpHasAdjRecord(SAVEAFTERAUDIT, updateAuditAdjInfoList, needSaveMap, null, updateAuditDecAdjSalList, uuid, needRepush);
            returnDataList.addAll(opResults);
        }
    }

    private void saveAdjFileHasRecord2Audit(List<Map<String, Object>> returnDataList, List<DynamicObject> needSaveWithStatusList, List<DecAdjSalaryEntity> decAdjSalaryEntityList, Map<Long, Map<String, Object>> idDataMap, String uuid, String needRepush) {
        if (CollectionUtils.isNotEmpty(needSaveWithStatusList)) {
            Map<Long, Map<String, Object>> needSaveMap = AdjFileInfoServiceHelper.getMappingSaveMap(needSaveWithStatusList, idDataMap);
            List<Map<String, Object>> opResults = this.batchExecuteOpHasAdjRecord(SAVE, needSaveWithStatusList, needSaveMap, AUDIT, decAdjSalaryEntityList, uuid, needRepush);
            returnDataList.addAll(opResults);
        }
    }

    private void saveAdjFileNoRecordAudit(List<Map<String, Object>> returnDataList, List<DynamicObject> needSaveWithStatusNoRecordList, Map<Long, Map<String, Object>> idDataMap) {
        if (CollectionUtils.isNotEmpty(needSaveWithStatusNoRecordList)) {
            Map<Long, Map<String, Object>> needSaveMap = AdjFileInfoServiceHelper.getMappingSaveMap(needSaveWithStatusNoRecordList, idDataMap);
            List<Map<String, Object>> opResults = this.batchExecuteOp(SAVE, needSaveWithStatusNoRecordList, needSaveMap, AUDIT);
            returnDataList.addAll(opResults);
        }
    }

    private void saveAdjFileNoRecord(List<Map<String, Object>> returnDataList, List<DynamicObject> needSaveNoRecordList, Map<Long, Map<String, Object>> idDataMap) {
        if (CollectionUtils.isNotEmpty(needSaveNoRecordList)) {
            Map<Long, Map<String, Object>> needSaveMap = AdjFileInfoServiceHelper.getMappingSaveMap(needSaveNoRecordList, idDataMap);
            List<Map<String, Object>> opResults = this.batchExecuteOp(SAVE, needSaveNoRecordList, needSaveMap, null);
            returnDataList.addAll(opResults);
        }
    }

    private static Map<Long, Map<String, Object>> getMappingSaveMap(List<DynamicObject> needSaveNoRecordList, Map<Long, Map<String, Object>> idDataMap) {
        HashMap<Long, Map<String, Object>> needSaveMap = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject dynamicObject : needSaveNoRecordList) {
            long id = dynamicObject.getLong(ID);
            needSaveMap.put(id, idDataMap.get(id));
        }
        return needSaveMap;
    }

    private Map<String, Object> dealDiscardAdjFile(Map<String, Object> dataHelperMap, Map<String, Object> paramMap, DynamicObject adjFileInfo) throws ParseException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        List decAdjDatas = (List)paramMap.get(DECADJ_DATA);
        ArrayList<DynamicObject> effectAdjFileList = new ArrayList<DynamicObject>(10);
        ArrayList<DecAdjSalaryEntity> effectAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
        if (decAdjDatas != null && !decAdjDatas.isEmpty()) {
            DecAdjSalaryEntity decAdjSalaryEntity = new DecAdjSalaryEntity();
            decAdjSalaryEntity.setSalaryadjfileId(Long.valueOf(adjFileInfo.getLong("boid")));
            decAdjSalaryEntity.setBussinessId(this.getLongTypeVal(paramMap, BUSSINESSID));
            this.setAdjRecordAndRelPerson(dataHelperMap, paramMap, adjFileInfo, decAdjSalaryEntity);
            effectAdjSalaryEntityList.add(decAdjSalaryEntity);
        }
        effectAdjFileList.add(adjFileInfo);
        returnMap.put(EFFECT_ADJ_FILE_LIST, effectAdjFileList);
        returnMap.put(EFFECT_ADJ_SALARY_ENTITY_LIST, effectAdjSalaryEntityList);
        return returnMap;
    }

    private Map<String, Object> dealAudit(Map<String, Object> dataHelperMap, Map<String, Object> paramMap, DynamicObject adjFileDyInfo) throws ParseException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        ArrayList<DynamicObject> updateAuditAdjInfoList = new ArrayList<DynamicObject>(10);
        ArrayList<DecAdjSalaryEntity> updateAuditDecAdjSalList = new ArrayList<DecAdjSalaryEntity>(10);
        List decAdjDatas = (List)paramMap.get(DECADJ_DATA);
        if (decAdjDatas != null && !decAdjDatas.isEmpty()) {
            DecAdjSalaryEntity decAdjSalaryEntity = new DecAdjSalaryEntity();
            decAdjSalaryEntity.setSalaryadjfileId(Long.valueOf(adjFileDyInfo.getLong("boid")));
            decAdjSalaryEntity.setBussinessId(this.getLongTypeVal(paramMap, BUSSINESSID));
            this.setAdjRecordAndRelPerson(dataHelperMap, paramMap, adjFileDyInfo, decAdjSalaryEntity);
            updateAuditDecAdjSalList.add(decAdjSalaryEntity);
        }
        updateAuditAdjInfoList.add(adjFileDyInfo);
        returnMap.put(UPDATE_AUDIT_ADJ_INFO_LIST, updateAuditAdjInfoList);
        returnMap.put(UPDATE_AUDIT_DEC_ADJ_SAL_LIST, updateAuditDecAdjSalList);
        return returnMap;
    }

    private void setAdjRecordAndRelPerson(Map<String, Object> dataHelperMap, Map<String, Object> paramMap, DynamicObject fileDy, DecAdjSalaryEntity decAdjSalaryEntity) throws ParseException {
        ArrayList<SalaryAdjRecordRelPersonDynEntity> salaryAdjRecordRelPersonDynEntities = new ArrayList<SalaryAdjRecordRelPersonDynEntity>(10);
        List decAdjDatas = (List)paramMap.get(DECADJ_DATA);
        if (decAdjDatas != null) {
            long currUserId = RequestContext.get().getCurrUserId();
            for (Map decAdjDataMap : decAdjDatas) {
                if (decAdjDataMap == null) continue;
                SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity = new SalaryAdjRecordRelPersonDynEntity();
                Map adjRecordFieldDataMap = (Map)dataHelperMap.get("ADJ_RECORD_INFO_MAP");
                SWCDataServiceHelper helper = new SWCDataServiceHelper(HCDM_SALARYADJRECORD);
                DynamicObject adjRecordDy = helper.generateEmptyDynamicObject();
                adjRecordDy.set("needpush", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
                adjRecordDy.set("salaryadjfile", (Object)AdjFileInfoServiceHelper.genFileDynamicObject(fileDy.getLong("boid") == 0L ? fileDy.getLong(ID) : fileDy.getLong("boid")));
                adjRecordDy.set("creator", (Object)currUserId);
                this.covert2DynamicObject(adjRecordDy, HCDM_SALARYADJRECORD, decAdjDataMap, adjRecordFieldDataMap);
                Map relPersonDataMap = (Map)decAdjDataMap.get(RELPERSON_DATA);
                Map relPersonFieldDataMap = (Map)dataHelperMap.get("REL_PERSON_INFO_MAP");
                helper = new SWCDataServiceHelper(HCDM_DECADJRELPERSON);
                DynamicObject relPersonDy = helper.generateEmptyDynamicObject();
                this.covert2DynamicObject(relPersonDy, HCDM_DECADJRELPERSON, relPersonDataMap, relPersonFieldDataMap);
                adjRecordDy.set("relpersonid", (Object)relPersonDy);
                salaryAdjRecordRelPersonDynEntity.setSalaryAdjRecord(adjRecordDy);
                salaryAdjRecordRelPersonDynEntity.setRelpersonDyn(relPersonDy);
                salaryAdjRecordRelPersonDynEntities.add(salaryAdjRecordRelPersonDynEntity);
            }
        }
        for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
            String code;
            DynamicObject salaryAdjRecord = salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord();
            if (salaryAdjRecord == null || !SWCStringUtils.isNotEmpty((String)(code = salaryAdjRecord.getString("salaryadjrsn.attributiontype")))) continue;
            decAdjSalaryEntity.setBillType(AdjAttributionType.getByCode((String)code));
            break;
        }
        decAdjSalaryEntity.setSalaryAdjFileVId(Long.valueOf(fileDy.getLong(ID)));
        decAdjSalaryEntity.setSalaryAdjRecordRelPersonDynEntities(salaryAdjRecordRelPersonDynEntities);
    }

    public static DynamicObject genFileDynamicObject(Long salaryFileVid) {
        if (salaryFileVid == null) {
            return null;
        }
        DynamicObject fileObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hcdm_adjfileinfo"));
        fileObj.set(ID, (Object)salaryFileVid);
        return fileObj;
    }

    private Map<String, Object> getDataHelperMap(List<Map<String, Object>> paramList) {
        Map<String, Map<Long, DynamicObject>> adjInfoFieldDataMap = this.getAdjInfoFieldDataMap(paramList);
        Map<Long, DynamicObject> depEmpPosOrgRelMap = this.getDepEmpPosOrgRelMap(paramList);
        Map<Long, DynamicObject> depEmpInfoMap = this.getDepEmpInfoMap(paramList);
        Map<Long, DynamicObject> personEntryDateMap = this.getPersonEntryDate(depEmpPosOrgRelMap);
        Map<Long, DynamicObject> personInfoMap = this.getPersonInfo(paramList, depEmpPosOrgRelMap);
        Map<String, Map<Long, DynamicObject>> adjRecordFieldDataMap = this.getAdjRecordFileDataMap(paramList);
        Map<String, Map<Long, DynamicObject>> relPersonFieldDataMap = this.getRelPersonFieldDataMap(paramList);
        Map<Long, List<Long>> employeeDepempMap = this.getEmployeeDepempMap(paramList);
        HashMap<String, Object> dataHelperMap = new HashMap<String, Object>(16);
        dataHelperMap.put("ADJ_FILE_INFO_MAP", adjInfoFieldDataMap);
        dataHelperMap.put("ADJ_RECORD_INFO_MAP", adjRecordFieldDataMap);
        dataHelperMap.put("REL_PERSON_INFO_MAP", relPersonFieldDataMap);
        dataHelperMap.put("EMP_POS_ORG_MAP", depEmpPosOrgRelMap);
        dataHelperMap.put("DEP_EMP_MAP", depEmpInfoMap);
        dataHelperMap.put("PERSON_ENTRY_DATE", personEntryDateMap);
        dataHelperMap.put("PERSON_INFO_MAP", personInfoMap);
        dataHelperMap.put("EMPLOYEE_DEPEMP_MAP", employeeDepempMap);
        return dataHelperMap;
    }

    private Map<Long, List<Long>> getEmployeeDepempMap(List<Map<String, Object>> paramList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(HRPI_DEPEMP);
        ArrayList<Long> allEmployeeIds = new ArrayList<Long>(10);
        for (int i = 0; i < paramList.size(); ++i) {
            Map<String, Object> objectMap = paramList.get(i);
            if (objectMap == null) continue;
            Long employeeId = (Long)objectMap.get("employee");
            allEmployeeIds.add(employeeId);
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)serviceHelper.getEntityName());
        Set fieldSet = mainEntityType.getFields().keySet();
        QFilter qFilter = new QFilter("employee", "in", allEmployeeIds);
        if (fieldSet.contains("enable")) {
            qFilter.and("enable", "=", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
        }
        if (fieldSet.contains(STATUS)) {
            qFilter.and(STATUS, "=", (Object)AUDIT);
        }
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,employee.id", new QFilter[]{qFilter});
        HashMap<Long, List<Long>> employeeDepempMap = new HashMap<Long, List<Long>>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            List depemps = employeeDepempMap.computeIfAbsent(dynamicObject.getLong("employee.id"), k1 -> new ArrayList());
            depemps.add(dynamicObject.getLong(ID));
        }
        return employeeDepempMap;
    }

    private Map<Long, DynamicObject> getPersonInfo(List<Map<String, Object>> paramList, Map<Long, DynamicObject> depEmpPosOrgRelMap) {
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        if (paramList != null) {
            for (Map<String, Object> paramMap : paramList) {
                Object person = paramMap.get("person");
                Long personID = this.getLongId(person);
                if (personID == null) continue;
                personIdSet.add(personID);
            }
        }
        if (depEmpPosOrgRelMap != null) {
            for (Map.Entry<Long, DynamicObject> next : depEmpPosOrgRelMap.entrySet()) {
                Long key = next.getKey();
                DynamicObject empPosOrgRel = next.getValue();
                if (empPosOrgRel == null) continue;
                long personId = empPosOrgRel.getLong("person.id");
                personIdSet.add(personId);
            }
        }
        HashMap<Long, DynamicObject> personMap = new HashMap<Long, DynamicObject>(16);
        if (!personIdSet.isEmpty()) {
            DynamicObject[] personObjs;
            SWCDataServiceHelper service = new SWCDataServiceHelper(HRPI_PERSON);
            QFilter filter = new QFilter(ID, "in", personIdSet);
            String selectProps = "id,number,name,personindexid";
            for (DynamicObject personObj : personObjs = service.query(selectProps, new QFilter[]{filter})) {
                if (personObj == null) continue;
                personMap.put(personObj.getLong(ID), personObj);
            }
            return personMap;
        }
        return personMap;
    }

    private Map<Long, DynamicObject> getPersonEntryDate(Map<Long, DynamicObject> depEmpPosOrgRelMap) {
        Collection<DynamicObject> depEmpOrgPosVals = depEmpPosOrgRelMap.values();
        HashSet<Long> personIdSet = new HashSet<Long>(16);
        for (DynamicObject empOrgPosVal : depEmpOrgPosVals) {
            Object personObj;
            Long personId;
            if (empOrgPosVal == null || (personId = this.getLongId(personObj = empOrgPosVal.get("person"))) == null) continue;
            personIdSet.add(personId);
        }
        Map<Long, DynamicObject> personEntryDateMap = DecAdjApprGridHelper.getEntryDate(personIdSet);
        return personEntryDateMap;
    }

    private Map<String, Map<Long, DynamicObject>> getAdjInfoFieldDataMap(List<Map<String, Object>> paramList) {
        Map<String, Map<String, Set<Long>>> fieldEntityIdMap = this.getFieldEntityAndIds("hcdm_adjfileinfo", paramList);
        Map<String, Map<Long, DynamicObject>> adjInfoFieldDataMap = AdjFileInfoServiceHelper.batchGetFieldDatas(fieldEntityIdMap);
        return adjInfoFieldDataMap;
    }

    private Long getLongTypeVal(Map<String, Object> dataMap, String key) {
        Long returnVal = null;
        if (dataMap != null) {
            Object keyVal = dataMap.get(key);
            if (keyVal instanceof Integer) {
                returnVal = ((Integer)keyVal).longValue();
            } else if (keyVal instanceof Long) {
                returnVal = (Long)keyVal;
            } else if (keyVal instanceof String) {
                returnVal = Long.parseLong((String)keyVal);
            }
        }
        return returnVal;
    }

    private boolean getBooleanTypeVal(Map<String, Object> dataMap, String key) {
        boolean returnVal = true;
        if (dataMap != null) {
            Object keyVal = dataMap.get(key);
            if (keyVal instanceof Boolean) {
                returnVal = (Boolean)keyVal;
            } else if (keyVal instanceof String) {
                returnVal = SWCStringUtils.equals((String)ADJ_FILE_TYPE_PART_TIME_JOB, (String)((String)keyVal));
            }
        }
        return returnVal;
    }

    private String getUniqueKey(DynamicObject empPosOrgRelDy, Map<String, Object> validDataMap) throws ParseException {
        Long depempId = this.getLongTypeVal(validDataMap, "depemp");
        Long orgId = this.getLongTypeVal(validDataMap, "org");
        Long countryId = this.getLongTypeVal(validDataMap, "country");
        Long stdScmId = this.getLongTypeVal(validDataMap, "stdscm");
        Date bsed = this.covert2DateOfNoTime(validDataMap.get(BSED));
        return depempId + KEY_SPLIT_FALG + orgId + KEY_SPLIT_FALG + countryId + KEY_SPLIT_FALG + stdScmId + KEY_SPLIT_FALG + SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd");
    }

    private Map<String, Map<Long, DynamicObject>> getAdjRecordFileDataMap(List<Map<String, Object>> successAdjInfoList) {
        ArrayList<Map<String, Object>> allDecAdjDatas = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < successAdjInfoList.size(); ++i) {
            Map<String, Object> objectMap = successAdjInfoList.get(i);
            if (objectMap == null || objectMap.get(DECADJ_DATA) == null) continue;
            List dataList = (List)objectMap.get(DECADJ_DATA);
            allDecAdjDatas.addAll(dataList);
        }
        Map<String, Map<Long, DynamicObject>> adjRecordFieldDataMap = AdjFileInfoServiceHelper.batchGetFieldDatas(this.getFieldEntityAndIds(HCDM_SALARYADJRECORD, allDecAdjDatas));
        return adjRecordFieldDataMap;
    }

    private Map<String, Map<Long, DynamicObject>> getRelPersonFieldDataMap(List<Map<String, Object>> successAdjInfoList) {
        ArrayList<Map<String, Object>> allRelPersonDatas = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < successAdjInfoList.size(); ++i) {
            List decadjData;
            Map<String, Object> objectMap = successAdjInfoList.get(i);
            if (objectMap == null || (decadjData = (List)objectMap.get(DECADJ_DATA)) == null) continue;
            for (Map decadjDatum : decadjData) {
                Map relPersonData;
                if (decadjDatum.get(RELPERSON_DATA) == null || (relPersonData = (Map)decadjDatum.get(RELPERSON_DATA)) == null || relPersonData.isEmpty()) continue;
                allRelPersonDatas.add(relPersonData);
            }
        }
        Map<String, Map<Long, DynamicObject>> relPersonFieldDataMap = AdjFileInfoServiceHelper.batchGetFieldDatas(this.getFieldEntityAndIds(HCDM_DECADJRELPERSON, allRelPersonDatas));
        return relPersonFieldDataMap;
    }

    private List<Map<String, Object>> getAdjFileInfoMapFromDb(List<Map<String, Object>> paramsList, Map<String, DynamicObject> adjFileInfoMap, Map<String, Object> dataHelperMap, List<Map<String, Object>> errorDataList) throws ParseException {
        HashSet<Long> depempIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashSet<Long> countryIdSet = new HashSet<Long>(16);
        HashSet<Long> stdScmIdSet = new HashSet<Long>(16);
        HashSet<Long> adjFileInfoIds = new HashSet<Long>(16);
        Map depEmpPosOrgRelMap = (Map)dataHelperMap.get("EMP_POS_ORG_MAP");
        ArrayList<Map<String, Object>> successParamsList = new ArrayList<Map<String, Object>>(paramsList.size());
        for (int i = 0; i < paramsList.size(); ++i) {
            Long stdscm;
            Long country;
            DynamicObject[] org;
            Long adjFileInfoId;
            Map<String, Object> dataMap = paramsList.get(i);
            if (dataMap == null || dataMap.isEmpty()) continue;
            Object adjFileInfoObject = dataMap.get(ADJ_FILE_INFO);
            if (adjFileInfoObject != null && (adjFileInfoId = this.getLongId(adjFileInfoObject)) != 0L) {
                adjFileInfoIds.add(adjFileInfoId);
                continue;
            }
            Long depemp = this.getLongTypeVal(dataMap, "depemp");
            if (depemp != null) {
                depempIdSet.add(depemp);
            }
            if ((org = this.getLongTypeVal(dataMap, "org")) != null) {
                orgIdSet.add((Long)org);
            }
            if ((country = this.getLongTypeVal(dataMap, "country")) != null) {
                countryIdSet.add(country);
            }
            if ((stdscm = this.getLongTypeVal(dataMap, "stdscm")) == null) continue;
            stdScmIdSet.add(stdscm);
        }
        if (adjFileInfoIds.size() > 0) {
            DynamicObject[] adjFileInfos;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
            QFilter notDiscard = new QFilter(STATUS, "in", (Object)CommonHcdmBizHelper.VALIDATE_STATUS);
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
            for (DynamicObject adjFileInfo : adjFileInfos = helper.loadDynamicObjectArray(new QFilter[]{new QFilter(ID, "in", adjFileInfoIds), notDiscard, currentVersionFilter})) {
                adjFileInfoMap.put(String.valueOf(adjFileInfo.getLong(ID)), adjFileInfo);
            }
        }
        Map<String, List<DynamicObject>> adjFileInfoGroupByKeyword = AdjFileInfoServiceHelper.getAdjFileInfoGroupByKeyword(depempIdSet, orgIdSet, countryIdSet, stdScmIdSet);
        for (Map<String, Object> dataMap : paramsList) {
            Long org = this.getLongTypeVal(dataMap, "org");
            Long country = this.getLongTypeVal(dataMap, "country");
            Long stdscm = this.getLongTypeVal(dataMap, "stdscm");
            Date bsed = this.covert2DateOfNoTime(dataMap.get(BSED));
            Object depEmpParam = dataMap.get("depemp");
            Long depEmpId = this.getLongId(depEmpParam);
            DynamicObject empPosOrgRelDy = (DynamicObject)depEmpPosOrgRelMap.get(depEmpId);
            String key = depEmpId + KEY_SPLIT_FALG + org + KEY_SPLIT_FALG + country + KEY_SPLIT_FALG + stdscm;
            List<DynamicObject> dynamicObjects = adjFileInfoGroupByKeyword.get(key);
            if (dynamicObjects != null) {
                if (!this.getAdjFileInfo(errorDataList, adjFileInfoMap, dataMap, bsed, key, dynamicObjects)) continue;
                successParamsList.add(dataMap);
                continue;
            }
            successParamsList.add(dataMap);
        }
        return successParamsList;
    }

    public static Map<String, List<DynamicObject>> getAdjFileInfoGroupByKeyword(Set<Long> depempIdSet, Set<Long> orgIdSet, Set<Long> countryIdSet, Set<Long> stdScmIdSet) {
        DynamicObject[] adjFileInfos;
        HashMap<String, List<DynamicObject>> adjFileInfoGroupByKeyword = new HashMap<String, List<DynamicObject>>(16);
        if (CollectionUtils.isEmpty(depempIdSet)) {
            return Collections.emptyMap();
        }
        for (DynamicObject adjFileInfo : adjFileInfos = AdjFileInfoServiceHelper.getAdjFileInfos(depempIdSet, orgIdSet, countryIdSet, stdScmIdSet)) {
            if (SWCStringUtils.equals((String)adjFileInfo.getString(STATUS), (String)AUDIT) && adjFileInfo.getBoolean("iscurrentversion")) continue;
            DynamicObject depemp = adjFileInfo.getDynamicObject("depemp");
            DynamicObject org = adjFileInfo.getDynamicObject("org");
            DynamicObject country = adjFileInfo.getDynamicObject("country");
            DynamicObject stdScm = adjFileInfo.getDynamicObject("stdscm");
            Long depempId = null;
            if (depemp != null) {
                depempId = (Long)depemp.getPkValue();
            }
            Long orgId = null;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            Long countryId = null;
            if (country != null) {
                countryId = (Long)country.getPkValue();
            }
            Long stdScmId = null;
            if (stdScm != null) {
                stdScmId = (Long)stdScm.getPkValue();
            }
            String key = AdjFileInfoServiceHelper.buildKey(depempId, orgId, countryId, stdScmId);
            List adjFileInfoLists = adjFileInfoGroupByKeyword.computeIfAbsent(key, k1 -> new ArrayList());
            adjFileInfoLists.add(adjFileInfo);
        }
        return adjFileInfoGroupByKeyword;
    }

    public static String buildKey(Long depempId, Long orgId, Long countryId, Long stdScmId) {
        return depempId + KEY_SPLIT_FALG + orgId + KEY_SPLIT_FALG + countryId + KEY_SPLIT_FALG + stdScmId;
    }

    private boolean getAdjFileInfo(List<Map<String, Object>> errorDataList, Map<String, DynamicObject> adjFileInfoMap, Map<String, Object> dataMap, Date bsed, String key, List<DynamicObject> dynamicObjects) {
        if (bsed == null) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date adjFileBsed = dynamicObject.getDate(BSED);
            Date adjFileBsled = dynamicObject.getDate(BSLED);
            if (bsed.compareTo(adjFileBsed) < 0 || bsed.compareTo(adjFileBsled) > 0) continue;
            if (adjFileInfoMap.containsKey(key + KEY_SPLIT_FALG + SWCInteDateTimeUtil.formateDate((Date)bsed))) {
                LOG.info("\u5173\u952e\u5b57\u6bb5{0}\u5728\u751f\u6548\u65e5\u671f{1}\u5b58\u5728\u76f8\u540c\u7684\u6863\u6848\uff1a{2}", new Object[]{key, SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), dynamicObject.getString(NUMBER)});
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5458\u5de5\u5728\u201c{0}\u201d\u662f\u5426\u5b58\u5728\u591a\u4efd\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u5e76\u63d0\u4f9b\u53c2\u6863\u6848ID\u3002", (String)"AdjFileInfoServiceHelper_41", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), SWCInteDateTimeUtil.formateDate((Date)bsed));
                Map<String, Object> errInfo = this.genErrorAdjAndSpecAdjRecordMap(dataMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG, null, null);
                errorDataList.add(errInfo);
                return false;
            }
            adjFileInfoMap.put(key + KEY_SPLIT_FALG + SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), dynamicObject);
        }
        return true;
    }

    private Map<String, List<Map<String, Object>>> checkMustField(List<Map<String, Object>> paramsList, String uuid, boolean endOperate) {
        Map<String, Object> paramMap;
        int i;
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Integer> errorFileIndexSet = new HashSet<Integer>(16);
        if (paramsList != null) {
            block0: for (i = 0; i < paramsList.size(); ++i) {
                Map<String, Object> checkResMap;
                paramMap = paramsList.get(i);
                if (paramMap == null || paramMap.isEmpty()) continue;
                String errorMsg = this.checkMustField(paramMap, this.ADJFILE_MUST_FIELDS, this.ADJFILE_MUST_LONG_ID_FIELDS);
                if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                    checkResMap = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg, AdjFileErrorMessageEnum.MUST_FIELD_ERROR, null, null);
                    faildAdjInfoList.add(checkResMap);
                    errorFileIndexSet.add(i);
                    continue;
                }
                errorMsg = this.checkDataLegal(paramMap);
                if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                    checkResMap = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG, null, null);
                    faildAdjInfoList.add(checkResMap);
                    errorFileIndexSet.add(i);
                    continue;
                }
                List decAdjData = (List)paramMap.get(DECADJ_DATA);
                if (decAdjData == null || decAdjData.isEmpty()) continue;
                for (int j = 0; j < decAdjData.size(); ++j) {
                    Map decAdjMap = (Map)decAdjData.get(j);
                    String errorMessage = this.checkMustField(decAdjMap, this.ADJRECORD_MUST_FIELDS, this.ADJRECORD_MUST_LONG_ID_FIELDS);
                    if (SWCStringUtils.isNotEmpty((String)errorMessage)) {
                        Map<String, Object> resMap = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMessage, AdjFileErrorMessageEnum.MUST_FIELD_ERROR, null, j);
                        faildAdjInfoList.add(resMap);
                        errorFileIndexSet.add(i);
                        continue block0;
                    }
                    Map relPersonData = (Map)decAdjMap.get(RELPERSON_DATA);
                    if (relPersonData == null || relPersonData.isEmpty()) {
                        String message = ResManager.loadKDString((String)"\u5fc5\u586b\u9879{0}\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_0", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{RELPERSON_DATA});
                        Map<String, Object> resMap = this.genErrorAdjAndSpecAdjRecordMap(paramMap, message, AdjFileErrorMessageEnum.MUST_FIELD_ERROR, null, j);
                        faildAdjInfoList.add(resMap);
                        errorFileIndexSet.add(i);
                        continue block0;
                    }
                    errorMessage = this.checkMustField(relPersonData, this.ISCOVER_RELPERSONDATA_MUST_FIELDS, this.ISCOVER_RELPERSONDATA_MUST_LONG_ID_FIELDS);
                    if (!SWCStringUtils.isNotEmpty((String)errorMessage)) continue;
                    Map<String, Object> resMap = this.genErrorAdjAndSpecAdjRecordMap(paramMap, errorMessage, AdjFileErrorMessageEnum.MUST_FIELD_ERROR, null, j);
                    faildAdjInfoList.add(resMap);
                    errorFileIndexSet.add(i);
                    continue block0;
                }
            }
        }
        if (paramsList != null) {
            for (i = 0; i < paramsList.size(); ++i) {
                paramMap = paramsList.get(i);
                if (paramMap == null || paramMap.isEmpty() || errorFileIndexSet.contains(i)) continue;
                passDataList.add(paramMap);
            }
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<Long, DynamicObject> getDepEmpPosOrgRelMap(List<Map<String, Object>> successAdjInfoList) {
        HashSet<Long> depEmpIdSet = new HashSet<Long>(16);
        for (int i = 0; i < successAdjInfoList.size(); ++i) {
            Map<String, Object> paramMap = successAdjInfoList.get(i);
            if (paramMap == null) continue;
            depEmpIdSet.add(this.getLongTypeVal(paramMap, "depemp"));
            List decAdjData = (List)paramMap.get(DECADJ_DATA);
            if (decAdjData == null || decAdjData.isEmpty()) continue;
            for (Map decAdjMap : decAdjData) {
                Map relPersonData = (Map)decAdjMap.get(RELPERSON_DATA);
                if (relPersonData.isEmpty()) continue;
                depEmpIdSet.add(this.getLongTypeVal(relPersonData, "depemp"));
            }
        }
        HashMap<Long, DynamicObject> depEmpPosOrgRelMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] empPosOrgRelInfos = this.getEmpPosOrgRelInfos(depEmpIdSet);
        for (int i = 0; i < empPosOrgRelInfos.length; ++i) {
            DynamicObject depEmp;
            DynamicObject empPosOrgRelInfo = empPosOrgRelInfos[i];
            if (empPosOrgRelInfo == null || (depEmp = empPosOrgRelInfo.getDynamicObject("depemp")) == null) continue;
            long depEmpId = depEmp.getLong(ID);
            depEmpPosOrgRelMap.put(depEmpId, empPosOrgRelInfo);
        }
        return depEmpPosOrgRelMap;
    }

    private Map<Long, DynamicObject> getDepEmpInfoMap(List<Map<String, Object>> successAdjInfoList) {
        HashSet<Long> depEmpIdSet = new HashSet<Long>(16);
        for (int i = 0; i < successAdjInfoList.size(); ++i) {
            Map<String, Object> paramMap = successAdjInfoList.get(i);
            if (paramMap == null) continue;
            depEmpIdSet.add(this.getLongTypeVal(paramMap, "depemp"));
        }
        HashMap<Long, DynamicObject> depEmpInfoMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] depEmps = this.getDepEmpAdminOrgNum(depEmpIdSet);
        for (int i = 0; i < depEmps.length; ++i) {
            DynamicObject depEmp = depEmps[i];
            if (depEmp == null) continue;
            depEmpInfoMap.put(depEmp.getLong(ID), depEmp);
        }
        return depEmpInfoMap;
    }

    private DynamicObject[] getEmpPosOrgRelInfos(Set<Long> depEmpIdSet) {
        SWCDataServiceHelper service = new SWCDataServiceHelper(HRPI_EMPPOSORGREL);
        QFilter filter = new QFilter("depemp", "in", depEmpIdSet);
        QFilter currentVersion = new QFilter("iscurrentversion", "=", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
        String queryPropties = "id,number,depemp,person,person.name,person.number,person.id,isprimary,employee,employee.empnumber,job,position,postype,company,adminorg,startdate,enddate,datastatus";
        return service.query(queryPropties, new QFilter[]{filter, currentVersion});
    }

    private DynamicObject[] getDepEmpAdminOrgNum(Set<Long> depEmpIdSet) {
        SWCDataServiceHelper service = new SWCDataServiceHelper(HRPI_DEPEMP);
        QFilter filter = new QFilter(ID, "in", depEmpIdSet);
        String queryPropties = "id,adminorg.number";
        return service.query(queryPropties, new QFilter[]{filter});
    }

    private Map<String, Long> generateAdjFileId(List<Map<String, Object>> validDataList, Map<String, DynamicObject> adjFileInfoMap, Map<String, Object> dataHelperMap) throws ParseException {
        HashMap<String, Long> keyIdMappingMap = new HashMap<String, Long>(16);
        ArrayList<String> uniqeKeyList = new ArrayList<String>(10);
        Map depEmpPosOrgRelMap = (Map)dataHelperMap.get("EMP_POS_ORG_MAP");
        for (int i = 0; i < validDataList.size(); ++i) {
            Object depEmpParam;
            Long depEmpId;
            DynamicObject empPosOrgRelDy;
            String key;
            DynamicObject dynamicObject;
            Long adjFileInfoId;
            Map<String, Object> validDataMap = validDataList.get(i);
            Object adjFileInfoObject = validDataMap.get(ADJ_FILE_INFO);
            if (adjFileInfoObject != null && (adjFileInfoId = this.getLongId(adjFileInfoObject)) != 0L || (dynamicObject = adjFileInfoMap.get(key = this.getUniqueKey(empPosOrgRelDy = (DynamicObject)depEmpPosOrgRelMap.get(depEmpId = this.getLongId(depEmpParam = validDataMap.get("depemp"))), validDataMap))) != null || uniqeKeyList.contains(key)) continue;
            uniqeKeyList.add(key);
        }
        long[] adjFileIds = null;
        if (!uniqeKeyList.isEmpty()) {
            adjFileIds = DB.genLongIds((String)"hcdm_adjfileinfo", (int)uniqeKeyList.size());
        }
        if (adjFileIds != null) {
            for (int i = 0; i < adjFileIds.length; ++i) {
                long adjFileId = adjFileIds[i];
                keyIdMappingMap.put((String)uniqeKeyList.get(i), adjFileId);
            }
        }
        return keyIdMappingMap;
    }

    private static DynamicObject[] getAdjFileInfos(Set<Long> depempIdSet, Set<Long> orgIdSet, Set<Long> countryIdSet, Set<Long> stdScmIdSet) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
        QFilter dataStatusFilter = new QFilter("datastatus", "not in", (Object)new String[]{"-2", "-1"});
        if (depempIdSet != null && depempIdSet.size() > 0) {
            QFilter depempFilter = new QFilter("depemp", "in", depempIdSet);
            dataStatusFilter.and(depempFilter);
        }
        if (orgIdSet != null && orgIdSet.size() > 0) {
            QFilter orgFilter = new QFilter("org", "in", orgIdSet);
            dataStatusFilter.and(orgFilter);
        }
        if (countryIdSet != null && countryIdSet.size() > 0) {
            QFilter countryFilter = new QFilter("country", "in", countryIdSet);
            dataStatusFilter.and(countryFilter);
        }
        if (stdScmIdSet != null && stdScmIdSet.size() > 0) {
            QFilter stdScmFilter = new QFilter("stdscm", "in", stdScmIdSet);
            dataStatusFilter.and(stdScmFilter);
        }
        QFilter notDiscard = new QFilter(STATUS, "!=", (Object)AdjFileStatusEnum.DISCARD.getCode());
        dataStatusFilter.and(notDiscard);
        dataStatusFilter.and(enableFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        return helper.loadDynamicObjectArray(new QFilter[]{dataStatusFilter});
    }

    private static Map<String, Map<Long, DynamicObject>> batchGetFieldDatas(Map<String, Map<String, Set<Long>>> fieldEntityIdMap) {
        HashMap<String, Map<Long, DynamicObject>> fieldDataMap = new HashMap<String, Map<Long, DynamicObject>>(16);
        for (Map.Entry<String, Map<String, Set<Long>>> next : fieldEntityIdMap.entrySet()) {
            Map<String, Set<Long>> bosEntityAndIdMap;
            String field = next.getKey();
            if (field == null || (bosEntityAndIdMap = next.getValue()) == null) continue;
            for (Map.Entry<String, Set<Long>> entry : bosEntityAndIdMap.entrySet()) {
                String bosEntityFlag = entry.getKey();
                Set<Long> idSet = entry.getValue();
                if (SWCStringUtils.isEmpty((String)bosEntityFlag) || idSet == null) continue;
                String defaultSelectedProps = "id,number,name";
                if ("salaryadjrsn".equals(field)) {
                    defaultSelectedProps = "id,number,name,attributiontype";
                } else if ("stdscm".equals(field)) {
                    defaultSelectedProps = "id,number,name,sourcevid,firstbsed";
                }
                if (HRPI_PERSON.equals(bosEntityFlag)) {
                    defaultSelectedProps = "id,number,name,personindexid";
                }
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(bosEntityFlag);
                QFilter qFilter = new QFilter(ID, "in", idSet);
                DynamicObject[] dynamicObjects = serviceHelper.query(defaultSelectedProps, new QFilter[]{qFilter});
                HashMap<Long, DynamicObject> idDynamicObj = new HashMap<Long, DynamicObject>(16);
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    DynamicObject dynamicObject = dynamicObjects[i];
                    if (dynamicObject == null) continue;
                    long id = dynamicObject.getLong(ID);
                    idDynamicObj.put(id, dynamicObject);
                }
                fieldDataMap.put(field, idDynamicObj);
            }
        }
        return fieldDataMap;
    }

    private Map<String, Map<String, Set<Long>>> getFieldEntityAndIds(String entityId, List<Map<String, Object>> validDataList) {
        HashMap<String, Map<String, Set<Long>>> fieldEntityIdMap = new HashMap<String, Map<String, Set<Long>>>(16);
        for (int i = 0; i < validDataList.size(); ++i) {
            Map<String, Object> validDataMap = validDataList.get(i);
            if (validDataMap == null) continue;
            for (Map.Entry<String, Object> next : validDataMap.entrySet()) {
                Set<Long> idSet;
                String bosEntityFlag;
                String key = next.getKey();
                Object value = next.getValue();
                if (value == null || !(value instanceof Long) && !(value instanceof Integer) || SWCStringUtils.isEmpty((String)(bosEntityFlag = this.getBosEntityFlag(key, entityId)))) continue;
                HashMap entityIdMap = (HashMap)fieldEntityIdMap.get(key);
                if (entityIdMap == null) {
                    entityIdMap = new HashMap(16);
                }
                Set set = idSet = entityIdMap.get(bosEntityFlag) == null ? new HashSet(16) : (Set)entityIdMap.get(bosEntityFlag);
                if (value instanceof Integer) {
                    Integer intVal = (Integer)value;
                    idSet.add(intVal.longValue());
                } else {
                    idSet.add((Long)value);
                }
                entityIdMap.put(bosEntityFlag, idSet);
                fieldEntityIdMap.put(key, entityIdMap);
            }
        }
        return fieldEntityIdMap;
    }

    private String getBosEntityFlag(String field, String bosEntity) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bosEntity);
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)allFields.get(field);
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            return basedataProp.getBaseEntityId();
        }
        return null;
    }

    private void covert2DynamicObject(DynamicObject entityObject, String entityId, Map<String, Object> dataMap, Map<String, Map<Long, DynamicObject>> fieldDataMap) throws ParseException {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Map allFields = dataEntityType.getAllFields();
        for (Map.Entry<String, Object> next : dataMap.entrySet()) {
            String key;
            IDataEntityProperty dataEntityProperty;
            if (next == null || (dataEntityProperty = (IDataEntityProperty)allFields.get(key = next.getKey())) == null) continue;
            Object value = next.getValue();
            if (dataEntityProperty instanceof BasedataProp) {
                Map<Long, DynamicObject> dynamicObjectMap = fieldDataMap.get(key);
                if (value instanceof Number && dynamicObjectMap != null && !dynamicObjectMap.isEmpty()) {
                    DynamicObject dynamicObject = null;
                    if (value instanceof Integer) {
                        Integer intVal = (Integer)value;
                        dynamicObject = dynamicObjectMap.get(intVal.longValue());
                    } else if (value instanceof Long) {
                        dynamicObject = dynamicObjectMap.get(value);
                    }
                    if (dynamicObject != null) {
                        entityObject.set(key, (Object)dynamicObject);
                        continue;
                    }
                    entityObject.set(key, value);
                    continue;
                }
                String baseEntityId = ((BasedataProp)dataEntityProperty).getBaseEntityId();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set(ID, value);
                entityObject.set(key, (Object)dynamicObject);
                continue;
            }
            if (dataEntityProperty instanceof MulBasedataProp) {
                List mulBaseBataIdList = (List)value;
                DynamicObjectCollection dynamicObjectCollection = entityObject.getDynamicObjectCollection(key);
                String baseEntityId = ((MulBasedataProp)dataEntityProperty).getBaseEntityId();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                if (mulBaseBataIdList == null || mulBaseBataIdList.isEmpty()) continue;
                for (int i = 0; i < mulBaseBataIdList.size(); ++i) {
                    Object id = mulBaseBataIdList.get(i);
                    Long longId = this.getLongId(id);
                    if (longId == null) continue;
                    DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                    dynamicObject.set(ID, (Object)longId);
                    this.addMulObj(dynamicObjectCollection, dynamicObject);
                }
                entityObject.set(key, (Object)dynamicObjectCollection);
                continue;
            }
            if (dataEntityProperty instanceof DateProp) {
                entityObject.set(key, (Object)this.covert2DateOfNoTime(value));
                continue;
            }
            if (dataEntityProperty instanceof DateTimeProp) {
                entityObject.set(key, (Object)this.covert2Date(value));
                continue;
            }
            if (dataEntityProperty instanceof DecimalProp) {
                entityObject.set(key, (Object)this.covert2BigDecimal(value));
                continue;
            }
            entityObject.set(key, value);
        }
    }

    private void addMulObj(DynamicObjectCollection mulObj, DynamicObject objective) {
        DynamicObject obj = mulObj.addNew();
        obj.set("fbasedataid_id", objective.getPkValue());
        obj.set("fbasedataid", (Object)objective);
    }

    private Long getLongId(Object id) {
        Long longId = null;
        if (id instanceof Integer) {
            longId = ((Integer)id).longValue();
        } else if (id instanceof Long) {
            longId = (Long)id;
        } else if (id instanceof DynamicObject) {
            longId = ((DynamicObject)id).getLong(ID);
        } else if (id instanceof String && SWCStringUtils.isNotEmpty((String)((String)id))) {
            longId = Long.parseLong((String)id);
        }
        return longId;
    }

    private void updateAdjFileObjInfo(Map<String, Object> dataHelperMap, Map<String, Object> validDataMap, Map<String, Map<Long, DynamicObject>> fieldDataMap, DynamicObject dy) throws ParseException {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hcdm_adjfileinfo");
        Map allFields = dataEntityType.getAllFields();
        this.setAdjFileInfoByEmpPosOrg(validDataMap, dataHelperMap, dy);
        this.setParamDataInEntity(validDataMap, fieldDataMap, dy, allFields);
    }

    private Date setDateTime2Zero(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private DynamicObject covert2AdjFileInfo(Map<String, Object> validDataMap, Map<String, Object> dataHelperMap) throws ParseException {
        Map fieldDataMap = (Map)dataHelperMap.get("ADJ_FILE_INFO_MAP");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject emptyAdjFile = helper.generateEmptyDynamicObject();
        emptyAdjFile.set(STATUS, (Object)"A");
        emptyAdjFile.set("enable", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
        emptyAdjFile.set("createtime", (Object)new Date());
        emptyAdjFile.set(BSLED, (Object)SWCDateTimeUtils.getMaxBsled());
        this.setAdjFileInfoByEmpPosOrg(validDataMap, dataHelperMap, emptyAdjFile);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hcdm_adjfileinfo");
        Map allFields = dataEntityType.getAllFields();
        this.setParamDataInEntity(validDataMap, fieldDataMap, emptyAdjFile, allFields);
        return emptyAdjFile;
    }

    private void setParamDataInEntity(Map<String, Object> validDataMap, Map<String, Map<Long, DynamicObject>> fieldDataMap, DynamicObject emptyAdjFile, Map<String, IDataEntityProperty> allFields) throws ParseException {
        for (Map.Entry<String, Object> dataMap : validDataMap.entrySet()) {
            Object value;
            String key;
            IDataEntityProperty dataEntityProperty;
            if (dataMap == null || (dataEntityProperty = allFields.get(key = dataMap.getKey())) == null || (value = dataMap.getValue()) == null) continue;
            if (dataEntityProperty instanceof BasedataProp) {
                Map<Long, DynamicObject> dynamicObjectMap = fieldDataMap.get(key);
                if (value instanceof Number && dynamicObjectMap != null && !dynamicObjectMap.isEmpty()) {
                    DynamicObject dynamicObject = null;
                    if (value instanceof Integer) {
                        Integer intVal = (Integer)value;
                        dynamicObject = dynamicObjectMap.get(intVal.longValue());
                    } else if (value instanceof Long) {
                        dynamicObject = dynamicObjectMap.get(value);
                    }
                    if (dynamicObject != null) {
                        emptyAdjFile.set(key, (Object)dynamicObject);
                        continue;
                    }
                    emptyAdjFile.set(key, value);
                    continue;
                }
                String baseEntityId = ((BasedataProp)dataEntityProperty).getBaseEntityId();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set(ID, value);
                emptyAdjFile.set(key, (Object)dynamicObject);
                continue;
            }
            if (dataEntityProperty instanceof MulBasedataProp) {
                List mulBaseBataIdList = (List)value;
                DynamicObjectCollection dynamicObjectCollection = emptyAdjFile.getDynamicObjectCollection(key);
                String baseEntityId = ((MulBasedataProp)dataEntityProperty).getBaseEntityId();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(baseEntityId);
                if (mulBaseBataIdList == null || mulBaseBataIdList.isEmpty()) continue;
                for (int i = 0; i < mulBaseBataIdList.size(); ++i) {
                    Object id = mulBaseBataIdList.get(i);
                    Long longId = this.getLongId(id);
                    if (longId == null) continue;
                    DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                    dynamicObject.set(ID, (Object)longId);
                    this.addMulObj(dynamicObjectCollection, dynamicObject);
                }
                emptyAdjFile.set(key, (Object)dynamicObjectCollection);
                continue;
            }
            if (dataEntityProperty instanceof DateProp) {
                emptyAdjFile.set(key, (Object)this.covert2DateOfNoTime(value));
                continue;
            }
            if (dataEntityProperty instanceof DateTimeProp) {
                emptyAdjFile.set(key, (Object)this.covert2Date(value));
                continue;
            }
            if (dataEntityProperty instanceof DecimalProp) {
                emptyAdjFile.set(key, (Object)this.covert2BigDecimal(value));
                continue;
            }
            emptyAdjFile.set(key, value);
        }
    }

    private void setAdjFileInfoByEmpPosOrg(Map<String, Object> validDataMap, Map<String, Object> dataHelperMap, DynamicObject emptyAdjFile) {
        emptyAdjFile.set(BSLED, (Object)SWCDateTimeUtils.getMaxBsled());
        Long assoAdminOrgId = this.getLongTypeVal(validDataMap, "assoadminorg");
        Long adminOrgId = this.getLongTypeVal(validDataMap, "adminorg");
        Map depEmpPosOrgRelMap = (Map)dataHelperMap.get("EMP_POS_ORG_MAP");
        Long depEmpId = this.getLongTypeVal(validDataMap, "depemp");
        DynamicObject empPosOrgRelDy = (DynamicObject)depEmpPosOrgRelMap.get(depEmpId);
        if (empPosOrgRelDy != null) {
            emptyAdjFile.set("employee", (Object)empPosOrgRelDy.getDynamicObject("employee"));
            emptyAdjFile.set("empposorgrel", (Object)empPosOrgRelDy);
            emptyAdjFile.set("depemp", (Object)empPosOrgRelDy.getDynamicObject("depemp"));
            String isPrimary = empPosOrgRelDy.getString("isprimary");
            emptyAdjFile.set("isprimary", (Object)isPrimary);
            emptyAdjFile.set("type", (Object)ADJ_FILE_TYPE_PART_TIME_JOB);
            if (SWCStringUtils.isNotEmpty((String)isPrimary) && isPrimary.equals(ADJ_FILE_TYPE_PART_TIME_JOB)) {
                emptyAdjFile.set("type", (Object)ADJ_FILE_TYPE_PRIMARY_JOB);
            }
            emptyAdjFile.set("biznumber", (Object)empPosOrgRelDy.getString(NUMBER));
            long personID = empPosOrgRelDy.getLong("person.id");
            Map personInfoMap = (Map)dataHelperMap.get("PERSON_INFO_MAP");
            emptyAdjFile.set("person", personInfoMap.get(personID));
            emptyAdjFile.set("job", (Object)empPosOrgRelDy.getDynamicObject("job"));
            Long positionId = this.getLongTypeVal(validDataMap, "position");
            if (positionId == null || positionId == 0L) {
                emptyAdjFile.set("position", (Object)empPosOrgRelDy.getDynamicObject("position"));
            }
            if (null != adminOrgId && null != assoAdminOrgId) {
                emptyAdjFile.set("escrowstaff", (Object)(!adminOrgId.equals(assoAdminOrgId) ? 1 : 0));
            }
        }
    }

    public List<Map<String, Object>> batchExecuteOp(String opName, List<DynamicObject> importDyList, Map<Long, Map<String, Object>> dataMaps, String status) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        try (TXHandle txHandle = TX.required();){
            try {
                OperationServiceImpl opImpl = new OperationServiceImpl();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(IS_FROM_API_SERVICE, TRUE);
                operateOption.setVariableValue(STATUS, status);
                operateOption.setVariableValue("ishasright", TRUE);
                operateOption.setVariableValue("skipCheckDataPermission", TRUE);
                operateOption.setVariableValue("skipCheckSpecialDataPermission", TRUE);
                OperationResult operationResult = opImpl.localInvokeOperation(opName, importDyList.toArray(new DynamicObject[importDyList.size()]), operateOption);
                resultList.addAll(this.dealOpResult(dataMaps, operationResult, importDyList, status));
            }
            catch (Exception e) {
                txHandle.markRollback();
                LOG.error("AdjFileInfoServiceHelper executeOp error, msg: ", (Throwable)e);
                for (Map.Entry<Long, Map<String, Object>> map : dataMaps.entrySet()) {
                    if (map == null) continue;
                    Long id = map.getKey();
                    Map<String, Object> dataMap = map.getValue();
                    Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(dataMap, e.getMessage(), AdjFileErrorMessageEnum.UNKNOW_ERROR, id);
                    resultList.add(errorMap);
                }
            }
        }
        return resultList;
    }

    private List<Map<String, Object>> dealOpResult(Map<Long, Map<String, Object>> dataMaps, OperationResult operationResult, List<DynamicObject> importDyList, String status) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        if (operationResult != null) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null) {
                HashMap<Long, Long> adjfileVidMap = new HashMap<Long, Long>();
                if (SWCStringUtils.equals((String)AUDIT, (String)status)) {
                    for (DynamicObject dynamicObject : importDyList) {
                        adjfileVidMap.put(dynamicObject.getLong("boid"), dynamicObject.getLong("sourcevid"));
                    }
                }
                for (Object successPkId : successPkIds) {
                    Map<String, Object> dataMap = dataMaps.get(successPkId);
                    Map<String, Object> resultMap = this.genSuccessResultMap(dataMap, successPkId, adjfileVidMap.get(successPkId));
                    resultList.add(resultMap);
                }
            }
            this.handleErrorMessageResult(dataMaps, operationResult, resultList);
        }
        return resultList;
    }

    private void handleErrorMessageResult(Map<Long, Map<String, Object>> dataMaps, OperationResult operationResult, List<Map<String, Object>> resultList) {
        Map<Long, List<String>> errorMsgMap = this.getErrorMsgMap(operationResult, dataMaps);
        for (Map.Entry<Long, List<String>> errorEntry : errorMsgMap.entrySet()) {
            Long pkId = errorEntry.getKey();
            List<String> errorList = errorEntry.getValue();
            Map<String, Object> dataMap = dataMaps.get(pkId);
            if (dataMap == null) continue;
            Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(dataMap, this.assembleErrorMsg(errorList), AdjFileErrorMessageEnum.SAVE_FAIL, pkId);
            resultList.add(errorMap);
        }
    }

    private Map<Long, List<String>> getErrorMsgMap(OperationResult operationResult, Map<Long, Map<String, Object>> dataMaps) {
        List successPkIds = operationResult.getSuccessPkIds();
        HashMap<Long, List<String>> errorMsgMap = new HashMap<Long, List<String>>(16);
        if (successPkIds == null || successPkIds.isEmpty()) {
            String message = operationResult.getMessage();
            for (Map.Entry<Long, Map<String, Object>> map : dataMaps.entrySet()) {
                if (map == null) continue;
                Long id = map.getKey();
                ArrayList<String> errorMsgList = (ArrayList<String>)errorMsgMap.get(id);
                if (errorMsgList == null) {
                    errorMsgList = new ArrayList<String>(10);
                }
                errorMsgList.add(message);
                errorMsgMap.put(id, errorMsgList);
            }
        }
        List allErrorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        for (int i = 0; i < allErrorOrValidateInfos.size(); ++i) {
            IOperateInfo operateInfo = (IOperateInfo)allErrorOrValidateInfos.get(i);
            String message = operateInfo.getMessage();
            Object pkValue = operateInfo.getPkValue();
            Long adjFilePk = this.getLongId(pkValue);
            ArrayList<String> errorMsgList = (ArrayList<String>)errorMsgMap.get(pkValue);
            if (errorMsgList == null) {
                errorMsgList = new ArrayList<String>(10);
            }
            errorMsgList.add(message);
            errorMsgMap.put(adjFilePk, errorMsgList);
        }
        return errorMsgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> batchExecuteOpHasAdjRecord(String opName, List<DynamicObject> importDyList, Map<Long, Map<String, Object>> dataMaps, String status, List<DecAdjSalaryEntity> decAdjSalaryEntityList, String uuid, String needRepush) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        Map<Long, DecAdjSalaryEntity> decAdjSalaryEntityMap = AdjFileInfoServiceHelper.covert2MapOfDecAdjSalary(decAdjSalaryEntityList);
        boolean isSuccess = true;
        try (TXHandle txHandle = TX.required();){
            try {
                OperationServiceImpl opImpl = new OperationServiceImpl();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(IS_FROM_API_SERVICE, TRUE);
                operateOption.setVariableValue(STATUS, status);
                operateOption.setVariableValue("ishasright", TRUE);
                operateOption.setVariableValue("skipCheckDataPermission", TRUE);
                operateOption.setVariableValue("skipCheckSpecialDataPermission", TRUE);
                OperationResult operationResult = opImpl.localInvokeOperation(opName, importDyList.toArray(new DynamicObject[importDyList.size()]), operateOption);
                List<Map<String, Object>> dealOpResult = this.dealOpResultHasDecAdjSalEntity(dataMaps, decAdjSalaryEntityMap, operationResult, uuid, opName, operateOption, importDyList, needRepush);
                resultList.addAll(dealOpResult);
                List errorList = dealOpResult.stream().filter(map -> (Boolean)map.get("success") == false).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(errorList)) {
                    isSuccess = false;
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                LOG.error("AdjFileInfoServiceHelper executeOp error, msg: ", (Throwable)e);
                for (Map.Entry<Long, Map<String, Object>> map2 : dataMaps.entrySet()) {
                    if (map2 == null) continue;
                    Long id = map2.getKey();
                    Map<String, Object> dataMap = map2.getValue();
                    Map<String, Object> errorMap = this.genErrorAdjAndAdjRecordMap(dataMap, e.getMessage(), AdjFileErrorMessageEnum.UNKNOW_ERROR, id);
                    resultList.add(errorMap);
                }
            }
            finally {
                if (!isSuccess) {
                    txHandle.markRollback();
                }
            }
        }
        return resultList;
    }

    private List<Map<String, Object>> dealOpResultHasDecAdjSalEntity(Map<Long, Map<String, Object>> dataMaps, Map<Long, DecAdjSalaryEntity> decAdjSalaryEntityMap, OperationResult operationResult, String uuid, String opName, OperateOption operateOption, List<DynamicObject> importDyList, String needRepush) throws ParseException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        if (operationResult != null) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null && successPkIds.size() > 0) {
                List<DecAdjSalaryEntity> decAdjSalaryEntityList = AdjFileInfoServiceHelper.handleAdjSalaryEntityGroupByUUID(decAdjSalaryEntityMap, successPkIds, opName, operateOption, importDyList);
                Map<String, String> matchResultMap = this.adjFileApplicationService.saveTimeVersionForBill(decAdjSalaryEntityList, new DecAdjSalaryEvent(uuid, needRepush));
                HashMap<Long, Long> adjfileVidMap = new HashMap<Long, Long>();
                if (SWCStringUtils.equals((String)SAVE, (String)opName)) {
                    for (DynamicObject dynamicObject : importDyList) {
                        adjfileVidMap.put(dynamicObject.getLong("boid"), dynamicObject.getLong("sourcevid"));
                    }
                } else if (SWCStringUtils.equals((String)SAVEAFTERAUDIT, (String)opName)) {
                    for (Object successPkId : successPkIds) {
                        String changeRespDataJson = operateOption.getVariableValue("changeRespData");
                        Map changeRespData = (Map)SerializationUtils.fromJsonString((String)changeRespDataJson, Map.class);
                        Long adjfileVid = (Long)changeRespData.get(String.valueOf(successPkId));
                        adjfileVidMap.put((Long)successPkId, adjfileVid);
                    }
                }
                Map<String, Long> boidMap = importDyList.stream().collect(Collectors.toMap(o1 -> o1.getString(ID), o1 -> o1.getLong("boid")));
                if (!matchResultMap.isEmpty()) {
                    for (Object successPkId : successPkIds) {
                        Map<String, Object> paramMap = dataMaps.get(successPkId);
                        List decAdjDataList = (List)paramMap.get(DECADJ_DATA);
                        for (Map dataMap : decAdjDataList) {
                            Long itemLongId = this.getLongId(dataMap.get("standarditem"));
                            Date bseDate = this.covert2DateOfNoTime(dataMap.get(BSED));
                            Date bsleDate = this.covert2DateOfNoTime(dataMap.get(BSLED));
                            Date bsled = bsleDate == null ? SWCDateTimeUtils.getMaxBsled() : bsleDate;
                            String unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(successPkId), String.valueOf(itemLongId), SWCDateTimeUtils.format((Date)bseDate, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
                            String errorMsg = matchResultMap.get(unionId);
                            if (null != errorMsg) {
                                paramMap.put("success", Boolean.FALSE);
                                paramMap.put("code", AdjFileErrorMessageEnum.DECADJ_SAVEAFTERAUDIT_ERROR.getCode());
                                paramMap.put("errormsg", errorMsg);
                                dataMap.put("success", Boolean.FALSE);
                                dataMap.put("code", AdjFileErrorMessageEnum.DECADJ_SAVEAFTERAUDIT_ERROR.getCode());
                                dataMap.put("errormsg", errorMsg);
                                continue;
                            }
                            dataMap.put("success", Boolean.TRUE);
                            dataMap.put("code", 200L);
                            dataMap.put("errormsg", EMPTY_STR);
                        }
                        paramMap.put("salaryfileid", boidMap.get(String.valueOf(successPkId)));
                        resultList.add(paramMap);
                    }
                } else {
                    for (Object successPkId : successPkIds) {
                        Map<String, Object> dataMap = dataMaps.get(successPkId);
                        Map<String, Object> resultMap = this.genSuccessResultMap(dataMap, boidMap.get(String.valueOf(successPkId)), adjfileVidMap.get(successPkId));
                        resultList.add(resultMap);
                    }
                }
                return resultList;
            }
            this.handleErrorMessageResult(dataMaps, operationResult, resultList);
        }
        return resultList;
    }

    private static List<DecAdjSalaryEntity> handleAdjSalaryEntityGroupByUUID(Map<Long, DecAdjSalaryEntity> decAdjSalaryEntityMap, List<Object> successPkIds, String opName, OperateOption operateOption, List<DynamicObject> importDyList) {
        ArrayList<DecAdjSalaryEntity> decAdjSalaryEntityList = new ArrayList<DecAdjSalaryEntity>(10);
        if (decAdjSalaryEntityMap != null && !decAdjSalaryEntityMap.isEmpty()) {
            AdjFileInfoServiceHelper.setAdjFileSourceVid2DecAdjSalary(successPkIds, opName, decAdjSalaryEntityMap, operateOption, importDyList);
            for (Object successPkId : successPkIds) {
                decAdjSalaryEntityList.add(decAdjSalaryEntityMap.get(successPkId));
            }
        }
        return decAdjSalaryEntityList;
    }

    private static void setAdjFileSourceVid2DecAdjSalary(List<Object> successPkIds, String opName, Map<Long, DecAdjSalaryEntity> decAdjSalaryEntityMap, OperateOption operateOption, List<DynamicObject> importDyList) {
        block6: {
            block5: {
                if (!SWCStringUtils.equals((String)SAVE, (String)opName)) break block5;
                HashMap<Long, DynamicObject> adjFileInfoVersions = new HashMap<Long, DynamicObject>(successPkIds.size());
                for (DynamicObject dynamicObject : importDyList) {
                    adjFileInfoVersions.put(dynamicObject.getLong("boid"), AdjFileInfoServiceHelper.genFileDynamicObject(dynamicObject.getLong("sourcevid")));
                }
                for (Object successPkId : successPkIds) {
                    DecAdjSalaryEntity decAdjSalaryEntity = decAdjSalaryEntityMap.get(successPkId);
                    if (decAdjSalaryEntity == null) continue;
                    List salaryAdjRecordRelPersonDynEntities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
                    for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                        salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord().set("salaryadjfilevid", adjFileInfoVersions.get(successPkId));
                    }
                }
                break block6;
            }
            if (!SWCStringUtils.equals((String)SAVEAFTERAUDIT, (String)opName)) break block6;
            String changeRespDataJson = operateOption.getVariableValue("changeRespData");
            Map changeRespData = (Map)SerializationUtils.fromJsonString((String)changeRespDataJson, Map.class);
            for (Object successPkId : successPkIds) {
                DecAdjSalaryEntity decAdjSalaryEntity = decAdjSalaryEntityMap.get(successPkId);
                if (decAdjSalaryEntity == null) continue;
                List salaryAdjRecordRelPersonDynEntities = decAdjSalaryEntity.getSalaryAdjRecordRelPersonDynEntities();
                for (SalaryAdjRecordRelPersonDynEntity salaryAdjRecordRelPersonDynEntity : salaryAdjRecordRelPersonDynEntities) {
                    salaryAdjRecordRelPersonDynEntity.getSalaryAdjRecord().set("salaryadjfilevid", (Object)AdjFileInfoServiceHelper.genFileDynamicObject((Long)changeRespData.get(String.valueOf(successPkId))));
                }
            }
        }
    }

    private static Map<Long, DecAdjSalaryEntity> covert2MapOfDecAdjSalary(List<DecAdjSalaryEntity> decAdjSalaryEntityList) {
        HashMap<Long, DecAdjSalaryEntity> decAdjSalaryEntityMap = new HashMap<Long, DecAdjSalaryEntity>(16);
        for (int i = 0; i < decAdjSalaryEntityList.size(); ++i) {
            DecAdjSalaryEntity decAdjSalaryEntity = decAdjSalaryEntityList.get(i);
            if (decAdjSalaryEntity == null) continue;
            decAdjSalaryEntityMap.put(decAdjSalaryEntity.getSalaryAdjFileVId(), decAdjSalaryEntity);
        }
        return decAdjSalaryEntityMap;
    }

    private String assembleErrorMsg(List<String> errors) {
        return StringUtils.join((Object[])errors.toArray(), (String)";");
    }

    public Map<Long, List<Object>> getMaxDateByFileBOId(Collection<Long> fileBOIds) {
        Map<Long, AdjFileMaxDateEntity> maxBsedForDecMap = this.adjFileApplicationService.getMaxBsedOfFileForDecBill(fileBOIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)maxBsedForDecMap.size());
        for (Map.Entry<Long, AdjFileMaxDateEntity> entry : maxBsedForDecMap.entrySet()) {
            Long fielBOId = entry.getKey();
            AdjFileMaxDateEntity adjFileMaxDateEntity = entry.getValue();
            List objects = resultMap.computeIfAbsent(fielBOId, v1 -> new ArrayList());
            objects.add(adjFileMaxDateEntity.getDate());
            objects.add(adjFileMaxDateEntity.getAdjFilePart().getEntityId());
        }
        return resultMap;
    }

    public Map<Long, Map<Long, List<Object>>> getMaxDateByFileAndItemId(Map<Long, Set<Long>> fileItemIdMap) {
        Map<Long, Map<Long, AdjFileMaxDateEntity>> maxBsedOfFileMap = this.adjFileApplicationService.getMaxBsedOfFileForAdjBill(fileItemIdMap);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)maxBsedOfFileMap.size());
        for (Map.Entry<Long, Map<Long, AdjFileMaxDateEntity>> entry : maxBsedOfFileMap.entrySet()) {
            Long fileId = entry.getKey();
            Map map = resultMap.computeIfAbsent(fileId, v1 -> new HashMap());
            Map<Long, AdjFileMaxDateEntity> itemMap = entry.getValue();
            for (Map.Entry<Long, AdjFileMaxDateEntity> subEntry : itemMap.entrySet()) {
                Long itemId = subEntry.getKey();
                AdjFileMaxDateEntity entity = subEntry.getValue();
                List objectList = map.computeIfAbsent(itemId, v1 -> new ArrayList());
                objectList.add(entity.getDate());
                objectList.add(entity.getAdjFilePart().getEntityId());
            }
        }
        return resultMap;
    }

    public Map<String, Object> unableAdjFile(String uuid, boolean endOperate, List<Map<String, Object>> paramsList) {
        HashMap<String, Object> methodReturnMap = new HashMap<String, Object>(16);
        ArrayList<Map<String, Object>> allFailResultDataList = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> checkEmptyResult = this.checkParam(uuid, paramsList, methodReturnMap, allFailResultDataList);
        if (checkEmptyResult != null) {
            return checkEmptyResult;
        }
        List<Map<String, Object>> passCheckDataList = this.checkMustField(paramsList, allFailResultDataList);
        Map<String, List<Map<String, Object>>> batchDataMap = this.splitParamsByBsledKey(passCheckDataList);
        for (Map.Entry<String, List<Map<String, Object>>> entry : batchDataMap.entrySet()) {
            ArrayList tmpList = new ArrayList(entry.getValue().size());
            tmpList.addAll(entry.getValue());
            String bsled = entry.getKey();
            List tmpListSplit = Lists.partition(tmpList, (int)500);
            for (List minList : tmpListSplit) {
                List<Map<String, Object>> errorMessageList = this.unableAdjFile(bsled, uuid, (List<Map<String, Object>>)minList);
                allFailResultDataList.addAll(errorMessageList);
            }
        }
        if (allFailResultDataList.size() == 0 && endOperate) {
            this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{uuid}));
        }
        methodReturnMap.put("data", allFailResultDataList);
        methodReturnMap.put("message", EMPTY_STR);
        methodReturnMap.put("success", allFailResultDataList.size() == 0);
        return methodReturnMap;
    }

    public Map<String, Object> abandonAdjFile(String uuid, boolean endOperate, List<Map<String, Object>> paramsList) {
        HashMap<String, Object> methodReturnMap = new HashMap<String, Object>(16);
        ArrayList<Map<String, Object>> allFailResultDataList = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> checkEmptyResult = this.checkParam(uuid, paramsList, methodReturnMap, allFailResultDataList);
        if (checkEmptyResult != null) {
            return checkEmptyResult;
        }
        ArrayList<Map<String, Object>> passCheckDataList = new ArrayList<Map<String, Object>>(10);
        String[] unableAdjFileMustFields = new String[]{ADJ_FILE_INFO};
        String[] longIdMustFiles = new String[]{ADJ_FILE_INFO};
        for (Map<String, Object> param : paramsList) {
            String errorMsg = this.checkMustField(param, unableAdjFileMustFields, longIdMustFiles);
            if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                Map<String, Object> checkResMap = this.genErrorMessage(errorMsg, AdjFileErrorMessageEnum.MUST_FIELD_ERROR, param.get(ADJ_FILE_INFO));
                allFailResultDataList.add(checkResMap);
                continue;
            }
            passCheckDataList.add(param);
        }
        List tmpListSplit = Lists.partition(passCheckDataList, (int)500);
        for (List minList : tmpListSplit) {
            List<Map<String, Object>> errorMessageList = this.abandonAdjFile(uuid, minList);
            allFailResultDataList.addAll(errorMessageList);
        }
        if (allFailResultDataList.size() == 0 && endOperate) {
            this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{uuid}));
        }
        methodReturnMap.put("data", allFailResultDataList);
        methodReturnMap.put("message", EMPTY_STR);
        methodReturnMap.put("success", allFailResultDataList.size() == 0);
        return methodReturnMap;
    }

    private List<Map<String, Object>> abandonAdjFile(String uuid, List<Map<String, Object>> passCheckDataList) {
        DynamicObject[] dynamicObjects = this.getAdjFileDynamicObject(passCheckDataList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("abandonEventId", uuid);
        return this.batchExecuteOp("abandon", dynamicObjects, operateOption);
    }

    private List<Map<String, Object>> unableAdjFile(String bsled, String uuid, List<Map<String, Object>> passCheckDataList) {
        DynamicObject[] dynamicObjects = this.getAdjFileDynamicObject(passCheckDataList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("unableEventId", uuid);
        operateOption.setVariableValue("var_bsled", bsled);
        return this.batchExecuteOp("unable", dynamicObjects, operateOption);
    }

    public List<Map<String, Object>> batchExecuteOp(String opName, DynamicObject[] dynamicObjects, OperateOption operateOption) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        if (dynamicObjects.length == 0) {
            return resultList;
        }
        try (TXHandle txHandle = TX.required();){
            try {
                OperationServiceImpl opImpl = new OperationServiceImpl();
                operateOption.setVariableValue("ishasright", TRUE);
                operateOption.setVariableValue("skipCheckDataPermission", TRUE);
                operateOption.setVariableValue("skipCheckSpecialDataPermission", TRUE);
                OperationResult operationResult = opImpl.localInvokeOperation(opName, dynamicObjects, operateOption);
                resultList.addAll(this.dealOpResult(operationResult));
            }
            catch (Exception e) {
                txHandle.markRollback();
                LOG.error("AdjFileInfoServiceHelper.{0}AdjFile executeOp error, msg: ", (Object)opName, (Object)e);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Map<String, Object> result = this.genErrorMessage(e.getMessage(), AdjFileErrorMessageEnum.UNKNOW_ERROR, dynamicObject.getPkValue());
                    resultList.add(result);
                }
            }
        }
        return resultList;
    }

    private List<Map<String, Object>> dealOpResult(OperationResult operationResult) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        List allErrorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo operateInfo : allErrorOrValidateInfos) {
            String message = operateInfo.getMessage();
            Object pkValue = operateInfo.getPkValue();
            Long adjFilePk = this.getLongId(pkValue);
            Map<String, Object> checkResMap = this.genErrorMessage(message, AdjFileErrorMessageEnum.ADJFILE_INFO_CHECK_ERROR, adjFilePk);
            resultList.add(checkResMap);
        }
        return resultList;
    }

    private DynamicObject[] getAdjFileDynamicObject(List<Map<String, Object>> passCheckDataList) {
        ArrayList<Long> adjFileIds = new ArrayList<Long>(passCheckDataList.size());
        for (Map<String, Object> param : passCheckDataList) {
            adjFileIds.add((Long)param.get(ADJ_FILE_INFO));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        return helper.loadDynamicObjectArray(new QFilter[]{new QFilter(ID, "in", adjFileIds)});
    }

    private Map<String, List<Map<String, Object>>> splitParamsByBsledKey(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> batchDyMaps = new HashMap<String, List<Map<String, Object>>>(16);
        for (Map<String, Object> param : passCheckDataList) {
            Date bsled = (Date)param.get(BSLED);
            List batchDyMap = batchDyMaps.computeIfAbsent(SWCDateTimeUtils.formatDate((Date)this.setDateTime2Zero(bsled)), k1 -> new ArrayList());
            batchDyMap.add(param);
        }
        return batchDyMaps;
    }

    private boolean checkUUID(String uuid, Map<String, Object> methodReturnMap, List<Map<String, Object>> dataList) {
        if (SWCStringUtils.isEmpty((String)uuid)) {
            methodReturnMap.put("data", dataList);
            String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjFileInfoServiceHelper_2", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            methodReturnMap.put("message", message);
            methodReturnMap.put("success", Boolean.FALSE);
            return true;
        }
        if (this.getSalaryAdjEventStatus(uuid)) {
            methodReturnMap.put("data", dataList);
            methodReturnMap.put("message", MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524duuid\uff1a{0}\u4e8b\u4ef6\u5df2\u88ab\u63a8\u9001\u3002", (String)"AdjFileInfoServiceHelper_26", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), uuid));
            methodReturnMap.put("success", Boolean.FALSE);
            return true;
        }
        return false;
    }

    private Map<String, Object> checkParam(String uuid, List<Map<String, Object>> paramsList, Map<String, Object> methodReturnMap, List<Map<String, Object>> allFailResultDataList) {
        if (this.checkUUID(uuid, methodReturnMap, allFailResultDataList)) {
            return methodReturnMap;
        }
        Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
        if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
            return checkEmptyResult;
        }
        return null;
    }

    private List<Map<String, Object>> checkMustField(List<Map<String, Object>> paramsList, List<Map<String, Object>> allFailResultDataList) {
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        String[] unableAdjFileMustFields = new String[]{ADJ_FILE_INFO, BSLED};
        String[] longIdMustFiles = new String[]{ADJ_FILE_INFO};
        for (Map<String, Object> param : paramsList) {
            String errorMsg = this.checkMustField(param, unableAdjFileMustFields, longIdMustFiles);
            if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                Map<String, Object> checkResMap = this.genErrorMessage(errorMsg, AdjFileErrorMessageEnum.MUST_FIELD_ERROR, param.get(ADJ_FILE_INFO));
                allFailResultDataList.add(checkResMap);
                continue;
            }
            Object bsled = param.get(BSLED);
            if (!(bsled instanceof Date)) {
                Map<String, Object> checkResMap = this.genErrorMessage(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AdjFileInfoServiceHelper_35", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), AdjFileErrorMessageEnum.DATA_WRONG, param.get(ADJ_FILE_INFO));
                allFailResultDataList.add(checkResMap);
                continue;
            }
            passDataList.add(param);
        }
        return passDataList;
    }

    private Map<String, Object> genErrorMessage(String errorMsg, AdjFileErrorMessageEnum mustFieldError, Object obj) {
        HashMap<String, Object> checkResMap = new HashMap<String, Object>(16);
        checkResMap.put("code", mustFieldError.getCode());
        checkResMap.put("errormsg", errorMsg);
        checkResMap.put("salaryfileid", obj);
        return checkResMap;
    }

    public boolean getSalaryAdjEventStatus(String event) {
        DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(event);
        if (eventDyn == null) {
            return false;
        }
        return SWCStringUtils.equals((String)ADJ_FILE_TYPE_PART_TIME_JOB, (String)eventDyn.getString("eventstatus"));
    }

    private Map<String, List<Map<String, Object>>> checkAdjFileInfoRepeat(String uuid, List<Map<String, Object>> passCheckDataList) {
        String uniCode;
        Long stdScmId;
        Long countryId;
        Long orgId;
        Long depempId;
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Integer> keyCoutMap = new HashMap<String, Integer>(16);
        for (Map<String, Object> dataMap : passCheckDataList) {
            Integer count;
            depempId = this.getLongTypeVal(dataMap, "depemp");
            orgId = this.getLongTypeVal(dataMap, "org");
            countryId = this.getLongTypeVal(dataMap, "country");
            stdScmId = this.getLongTypeVal(dataMap, "stdscm");
            uniCode = uuid + KEY_SPLIT_FALG + depempId + KEY_SPLIT_FALG + orgId + KEY_SPLIT_FALG + countryId + KEY_SPLIT_FALG + stdScmId;
            Integer n = count = keyCoutMap.get(uniCode) == null ? Integer.valueOf(0) : (Integer)keyCoutMap.get(uniCode);
            Integer n2 = count = Integer.valueOf(count + 1);
            keyCoutMap.put(uniCode, count);
        }
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            Map<String, Object> dataMap;
            dataMap = passCheckDataList.get(i);
            depempId = this.getLongTypeVal(dataMap, "depemp");
            orgId = this.getLongTypeVal(dataMap, "org");
            countryId = this.getLongTypeVal(dataMap, "country");
            stdScmId = this.getLongTypeVal(dataMap, "stdscm");
            uniCode = uuid + KEY_SPLIT_FALG + depempId + KEY_SPLIT_FALG + orgId + KEY_SPLIT_FALG + countryId + KEY_SPLIT_FALG + stdScmId;
            Integer integer = (Integer)keyCoutMap.get(uniCode);
            if (integer != null && integer >= 2) {
                String message = ResManager.loadKDString((String)"\u76f8\u540cuuid\u4e2d\uff0c\u5b58\u5728\u91cd\u590d\u7684\u201c\u7ec4\u7ec7\u4eba\u3001\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u3001\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u3001\u85aa\u916c\u4f53\u7cfb\u201d\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjFileInfoServiceHelper_45", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{uniCode});
                Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(dataMap, message, AdjFileErrorMessageEnum.DATA_WRONG, null);
                faildAdjInfoList.add(map);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private String checkDataLegal(Map<String, Object> dataMap) {
        if (dataMap == null || dataMap.isEmpty() || null == dataMap.get(NEEDREPUSH)) {
            return null;
        }
        String needRepush = (String)dataMap.get(NEEDREPUSH);
        if (!NEEDREPUSH_VAL.contains(needRepush)) {
            String dataModeErrorMsg = ResManager.loadKDString((String)"\u662f\u5426\u81ea\u52a8\u91cd\u63a8needrepush\uff1a{0}\u4e0d\u5728[0,1]\u53ef\u9009\u8303\u56f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_46", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            return MessageFormat.format(dataModeErrorMsg, needRepush);
        }
        return null;
    }

    private Map<String, List<Map<String, Object>>> checkNeedRepushSame(String uuid, List<Map<String, Object>> passCheckDataList) {
        String needRepush;
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<String> needRepushSet = new HashSet<String>(16);
        for (Map<String, Object> dataMap : passCheckDataList) {
            needRepush = (String)dataMap.get(NEEDREPUSH);
            if (null == needRepush) continue;
            needRepushSet.add(needRepush);
        }
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            Map<String, Object> dataMap;
            dataMap = passCheckDataList.get(i);
            needRepush = (String)dataMap.get(NEEDREPUSH);
            if (needRepush != null && needRepushSet.size() > 1) {
                String message = ResManager.loadKDString((String)"\u975e\u6cd5\u5165\u53c2\uff0c\u76f8\u540cUUID\u7684\u3010\u662f\u5426\u81ea\u52a8\u91cd\u63a8\u3011\u5b57\u6bb5\u9700\u8981\u4fdd\u6301\u4e00\u81f4\u3002UUID\uff1a{0}", (String)"AdjFileInfoServiceHelper_47", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{uuid});
                Map<String, Object> map = this.genErrorAdjAndAdjRecordMap(dataMap, message, AdjFileErrorMessageEnum.DATA_WRONG, null);
                faildAdjInfoList.add(map);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }
}

