/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class AdjFilePersonHelper {
    private static final Log logger = LogFactory.getLog(AdjFilePersonHelper.class);

    public static void addAdjFilePerson(List<DynamicObject> adjFileDyObjList, SWCDataServiceHelper serviceHelper) {
        Set personIdSet = adjFileDyObjList.stream().map(o1 -> o1.getLong("person.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("person", "in", personIdSet);
        DynamicObject[] adjFilePersons = serviceHelper.query("person.id", new QFilter[]{qFilter});
        Set personIdSetDb = Arrays.stream(adjFilePersons).map(o1 -> o1.getLong("person.id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(adjFileDyObjList = adjFileDyObjList.stream().filter(o1 -> !personIdSetDb.contains(o1.getLong("person.id"))).collect(Collectors.toList()))) {
            DynamicObjectCollection adjFileDyObjToDb = new DynamicObjectCollection();
            ArrayList personIds = Lists.newArrayListWithExpectedSize((int)adjFileDyObjList.size());
            for (DynamicObject dynamicObject : adjFileDyObjList) {
                long personId = dynamicObject.getLong("person.id");
                if (personIds.contains(personId)) continue;
                personIds.add(personId);
                DynamicObject adjFilePersonDyObj = serviceHelper.generateEmptyDynamicObject();
                adjFilePersonDyObj.set("person", (Object)dynamicObject.getLong("person.id"));
                adjFilePersonDyObj.set("depemp", (Object)dynamicObject.getLong("depemp.id"));
                adjFileDyObjToDb.add((Object)adjFilePersonDyObj);
            }
            serviceHelper.save(adjFileDyObjToDb);
        }
    }

    public static void syncAdjFilePerson(Set<Long> adjFileIdSet) {
        Set delPersonIdSet;
        Object[] delAdjFilePersonDys;
        logger.info("AdjFilePersonHelper#syncAdjFilePerson \u4f20\u5165\u7684\u53c2\u6570 adjFileIdSet = {}", (Object)JSON.toJSONString(adjFileIdSet));
        logger.info("\u540c\u6b65\u5b9a\u8c03\u85aa\u6863\u6848\u4eba\u5458...");
        long startTime = System.currentTimeMillis();
        DynamicObject[] adjFileDyObjs = SalaryAdjFileServiceHelper.queryAdjFileInfoByFileId(adjFileIdSet);
        if (adjFileDyObjs == null) {
            return;
        }
        Set<Long> personIdSet = Arrays.stream(adjFileDyObjs).map(o1 -> o1.getLong("person.id")).collect(Collectors.toSet());
        DynamicObjectCollection adjFileInfoDyObjColl = AdjFilePersonHelper.queryAdjFileInfoByPersonIds(personIdSet);
        Map<Long, List<DynamicObject>> adjFileByPersonIdMap = adjFileInfoDyObjColl.stream().collect(Collectors.groupingBy(o1 -> o1.getLong("person.id")));
        ArrayList auditAdjFilePersonDyList = Lists.newArrayListWithExpectedSize((int)adjFileByPersonIdMap.size());
        ArrayList noAuditAdjFilePersonDyList = Lists.newArrayListWithExpectedSize((int)adjFileByPersonIdMap.size());
        for (Map.Entry<Long, List<DynamicObject>> adjFileByPersonId : adjFileByPersonIdMap.entrySet()) {
            List<DynamicObject> adjFileList = adjFileByPersonId.getValue();
            List statusList = adjFileList.stream().map(o1 -> o1.getString("status")).collect(Collectors.toList());
            if (statusList.contains("C")) {
                auditAdjFilePersonDyList.add(adjFileList.get(0));
                continue;
            }
            noAuditAdjFilePersonDyList.add(adjFileList.get(0));
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileperson");
        if (CollectionUtils.isNotEmpty((Collection)auditAdjFilePersonDyList)) {
            AdjFilePersonHelper.addAdjFilePerson(auditAdjFilePersonDyList, serviceHelper);
        }
        if (CollectionUtils.isNotEmpty((Collection)noAuditAdjFilePersonDyList) && (delAdjFilePersonDys = serviceHelper.query(new QFilter[]{new QFilter("person.id", "in", delPersonIdSet = noAuditAdjFilePersonDyList.stream().map(o1 -> o1.getLong("person.id")).collect(Collectors.toSet()))})) != null && delAdjFilePersonDys.length > 0) {
            serviceHelper.delete(delAdjFilePersonDys);
        }
        long endTime = System.currentTimeMillis();
        logger.info("AdjFilePersonHelper#syncAdjFilePerson \u540c\u6b65\u5b9a\u8c03\u85aa\u6863\u6848\u4eba\u5458\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a{}\uff08ms\uff09", (Object)(endTime - startTime));
    }

    public static void allSyncAdjFilePerson() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u540c\u6b65\u5347\u7ea7...");
        long startTime = System.currentTimeMillis();
        List<AdjFilePerson> differencePersonList = AdjFilePersonHelper.queryDifferencePersonDate();
        TXHandle txHandle = TX.required();
        try {
            if (CollectionUtils.isNotEmpty(differencePersonList)) {
                Set<Long> personIdSet = differencePersonList.stream().map(AdjFilePerson::getPersonId).collect(Collectors.toSet());
                DynamicObjectCollection adjFileInfoDyObjColl = AdjFilePersonHelper.queryAdjFileInfoByPersonIds(personIdSet);
                ArrayList adjFilePersonDyList = Lists.newArrayList((Iterable)adjFileInfoDyObjColl);
                AdjFilePersonHelper.addAdjFilePerson(adjFilePersonDyList, new SWCDataServiceHelper("hcdm_adjfileperson"));
            }
        }
        catch (Exception e) {
            txHandle.markRollback();
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
        }
        finally {
            txHandle.close();
            long endTime = System.currentTimeMillis();
            logger.info("\u5347\u7ea7\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a{}\uff08ms\uff09", (Object)(endTime - startTime));
        }
    }

    private static List<AdjFilePerson> queryDifferencePersonDate() {
        String querySql = "SELECT t1.fpersonid FROM t_hcdm_adjfileinfo t1  LEFT JOIN t_hcdm_adjfileperson t2 ON t1.fpersonid = t2.fpersonid WHERE t2.fpersonid is NULL AND t1.fstatus = ? and t1.fiscurrentversion='1' group by t1.fpersonid; ";
        DataSet dataSet = HCDMDbHelper.queryDataSet(querySql, new Object[]{"C"});
        ArrayList<AdjFilePerson> result = new ArrayList<AdjFilePerson>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            AdjFilePerson adjFilePerson = new AdjFilePerson();
            adjFilePerson.setPersonId(row.getLong(0));
            result.add(adjFilePerson);
        }
        return result;
    }

    private static DynamicObjectCollection queryAdjFileInfoByPersonIds(Set<Long> personIdSet) {
        QFilter filter = new QFilter("person", "in", personIdSet);
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        SWCDataServiceHelper adjFileInfoServiceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        return adjFileInfoServiceHelper.queryOriginalCollection("person.id, depemp.id, status", new QFilter[]{filter, hisCurrFilter});
    }

    static class AdjFilePerson {
        private Long personId;
        private Long depempId;

        AdjFilePerson() {
        }

        public Long getPersonId() {
            return this.personId;
        }

        public void setPersonId(Long personId) {
            this.personId = personId;
        }

        public Long getDepempId() {
            return this.depempId;
        }

        public void setDepempId(Long depempId) {
            this.depempId = depempId;
        }
    }
}

