/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFilePersonHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.task.AdjFileStatusUpdateTask;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AdjFileStatusUpdateHelper {
    private static Log logger = LogFactory.getLog(AdjFileStatusUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private static final String QUERY_LOSE_EFFEC_SQL = "A.fid, A.fsourcevid\nFROM _&table_name A  \nINNER JOIN _&table_name B ON A.fsourcevid = B.fid AND A.fiscurrentversion = ?\nWHERE  A.fstatus = ?  AND B.fenable = ? AND B.fdatastatus= ?";
    private static final String QUERY_AUDIT_SQL = " A.fid, A.fsourcevid\nFROM _&table_name A \nWHERE A.fdatastatus= ? AND A.fenable = ? AND A.fiscurrentversion = ? AND A.fstatus = ? ";
    private static final List<Object> QUERY_LOSE_EFFECT_DATA_PARAM = Lists.newArrayList((Object[])new Object[]{Boolean.TRUE, "D", "1", "1"});
    private static final List<Object> QUERY_AUDIT_DATA_PARAM = Lists.newArrayList((Object[])new Object[]{"1", "0", Boolean.TRUE, "C"});

    public static void updateAdjfileStatus() {
        String entityId = SalaryAdjFilePartEnum.baseInfo.getEntityId();
        AdjFileStatusUpdateHelper.executeSynDataStatus(entityId, QUERY_AUDIT_SQL, QUERY_AUDIT_DATA_PARAM);
        AdjFileStatusUpdateHelper.executeSynDataStatus(entityId, QUERY_LOSE_EFFEC_SQL, QUERY_LOSE_EFFECT_DATA_PARAM);
    }

    private static void executeSynDataStatus(String entityName, String tplSql, List<Object> params) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String tableName = mainEntityType.getAlias();
        String qp = "select " + tplSql.replace("_&table_name", tableName);
        String countSql = "select count(1) c from(" + qp + ") C";
        DataSet countDataSet = HCDMDbHelper.queryDataSet(countSql, params.toArray());
        int total = ((Row)countDataSet.iterator().next()).getInteger(0);
        countDataSet.close();
        if (total > 0) {
            String sql;
            DataSet dataSet;
            boolean empty;
            for (int index = 0; !(empty = (dataSet = HCDMDbHelper.queryDataSet(sql = " SELECT top " + BATCH_SIZE + tplSql.replace("_&table_name", tableName), params.toArray())).isEmpty()) && index <= total; ++index) {
                HashMap sourceVIdMap = Maps.newHashMapWithExpectedSize((int)BATCH_SIZE);
                HashSet adjFileIdSet = Sets.newHashSetWithExpectedSize((int)BATCH_SIZE);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong(0);
                    Long sourcevid = row.getLong(1);
                    sourceVIdMap.put(id, sourcevid);
                    if (!SalaryAdjFilePartEnum.baseInfo.getEntityId().equals(entityName)) continue;
                    adjFileIdSet.add(id);
                }
                dataSet.close();
                if (!MapUtils.isNotEmpty((Map)sourceVIdMap)) continue;
                try (TXHandle tx = TX.requiresNew();){
                    SalaryAdjFileServiceHelper.updateCurrentDataStatus(entityName, sourceVIdMap);
                    if (!SalaryAdjFilePartEnum.baseInfo.getEntityId().equals(entityName) || !CollectionUtils.isNotEmpty((Collection)adjFileIdSet)) continue;
                    AdjFilePersonHelper.syncAdjFilePerson(adjFileIdSet);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u66f4\u65b0\u5b9a\u8c03\u85aa\u6863\u6848\u72b6\u6001\u4efb\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }
}

