/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.adjfile.AdjFileMatchParam;
import kd.sdk.swc.hcdm.common.adjfile.AdjfileMatchResult;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprCreateGridHelper;
import kd.swc.hcdm.business.enums.AdjFileErrorMessageEnum;
import kd.swc.hcdm.business.salaryadjfile.AbstractAdjfileServiceHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class DecAdjInfoServiceHelper
extends AbstractAdjfileServiceHelper {
    private static final Log logger = LogFactory.getLog(DecAdjInfoServiceHelper.class);
    private static final String SWC_HCDM_BUSINESS = "swc-hcdm-business";
    public static final String RELPERSON_DATA = "relperson_data";
    private static final String RULE_DATA = "rule_data";
    private static final String PASS_DATA = "passData";
    private static final String FAIL_DATA = "failData";
    private static final String RULE_SALARYADJFILE = "rule_salaryadjfile";
    private static final String RULE_STANDARDITEM = "rule_standarditem";
    public static final String RULETYPE = "ruletype";
    public static final String RULETYPE_DEC = "1";
    public static final String RULETYPE_ADJ = "2";
    private static final String KEY_SPLIT_FALG = "###";
    private static final String SALARYADJFILE = "salaryadjfile";
    private static final String STANDARDITEM = "standarditem";
    private DynamicObjectType adjFileInfoType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjfileinfo");
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final String METHOD_ATOMIC = "1";
    private static final String METHOD_RULE = "2";
    private static final String DATAMODE = "datamode";
    private static final String DATAMODE_CUT = "2";
    private static final String DATAMODE_UPDATE = "1";
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";
    private static final int BATCH_SIZE_MAX = 500;
    String[] MUST_FIELDS_MODE_CUT = new String[]{"uuid", "uniquecode", "standarditem", "bsed", "datamode", "salaryadjfile"};
    String[] MUST_FIELDS_MODE_UPDATE = new String[]{"uuid", "uniquecode", "standarditem", "frequency", "currency", "amount", "salaryadjrsn", "bsed", "datasource", "datamode", "salaryadjfile", "relperson_data"};
    String[] BATCH_MUST_FIELDS_MODE_CUT = new String[]{"uniquecode", "standarditem", "bsed", "datamode", "salaryadjfile"};
    String[] BATCH_MUST_FIELDS_MODE_UPDATE = new String[]{"uniquecode", "standarditem", "frequency", "currency", "amount", "salaryadjrsn", "bsed", "datasource", "datamode", "salaryadjfile", "relperson_data"};
    String[] BATCH_DECADJ_MUST_FIELDS = new String[]{"uniquecode", "standarditem", "frequency", "currency", "amount", "salaryadjrsn", "bsed", "datasource", "rule_data", "salaryadjfile", "relperson_data"};
    String[] DECADJ_MUST_FIELDS = new String[]{"uuid", "uniquecode", "standarditem", "frequency", "currency", "amount", "salaryadjrsn", "bsed", "datasource", "rule_data", "salaryadjfile", "relperson_data"};
    String[] DECADJ_MUST_LONG_ID_FIELDS = new String[]{"standarditem", "frequency", "currency", "salaryadjrsn", "salaryadjfile"};
    String[] RULE_MUST_FIELDS = new String[]{"ruletype", "rule_standarditem", "rule_salaryadjfile"};
    String[] RULE_MUST_LONG_ID_FIELDS = new String[]{"rule_standarditem", "rule_salaryadjfile"};
    String[] RELPERSONDATA_MUST_FIELDS = new String[]{"depemp", "org", "country", "personname", "empnumber"};
    String[] RELPERSONDATA_MUST_LONG_ID_FIELDS = new String[]{"depemp", "org", "country"};
    private static final Set<String> RULETYPESET = Sets.newHashSet((Object[])new String[]{"1", "2"});
    private static final String HCDM_SALARYADJRECORDQUERY = "hcdm_salaryadjrecordquery";
    private static final CloneUtils cloneUtils = new CloneUtils(false, true);

    public Map<String, Object> saveDecAdjRecord(List<Map<String, Object>> paramsList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
            if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
                return checkEmptyResult;
            }
            ArrayList<Map<String, Object>> allFailResultDataList = new ArrayList<Map<String, Object>>(10);
            List<Map<String, Object>> passCheckDataList = this.checkParamList(paramsList, allFailResultDataList, false, "1");
            Map<String, List<Map>> uuidMap = passCheckDataList.stream().collect(Collectors.groupingBy(map -> (String)map.get("uuid")));
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
            dataList.addAll(allFailResultDataList);
            for (Map.Entry<String, List<Map>> entry : uuidMap.entrySet()) {
                ArrayList tmpList = new ArrayList(entry.getValue().size());
                tmpList.addAll(entry.getValue());
                List tmpListSplit = Lists.partition(tmpList, (int)500);
                String eventUUID = entry.getKey();
                for (List minList : tmpListSplit) {
                    List<Map<String, Object>> saveResultList = this.batchSaveDecAdjRecord(minList, eventUUID);
                    dataList.addAll(saveResultList);
                }
                this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{eventUUID}));
            }
            result.put("data", dataList);
            boolean success = this.isSuccess(dataList);
            result.put(KEY_SUCCESS, success);
            result.put(KEY_MSG, "");
        }
        catch (Exception e) {
            logger.error("executeOp error, msg: ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a{0}\u3002", (String)"AdjFileInfoServiceHelper_1", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{e.getMessage()});
            result.put(KEY_MSG, msg);
            result.put(KEY_SUCCESS, Boolean.FALSE);
        }
        return result;
    }

    public Map<String, Object> saveBatchDecAdjRecord(String uuid, boolean endOperate, List<Map<String, Object>> paramsList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
            if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
                return checkEmptyResult;
            }
            Map<String, String> uuidEventDyMap = this.getSalaryAdjEventStatus(Sets.newHashSet((Object[])new String[]{uuid}));
            if ("1".equals(uuidEventDyMap.get(uuid))) {
                result.put(KEY_SUCCESS, Boolean.FALSE);
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524duuid\uff1a{0}\u4e8b\u4ef6\u5df2\u88ab\u63a8\u9001\u3002", (String)"AdjFileInfoServiceHelper_26", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                result.put(KEY_MSG, MessageFormat.format(errorMsg, uuid));
                return result;
            }
            ArrayList<Map<String, Object>> allFailResultDataList = new ArrayList<Map<String, Object>>(10);
            List<Map<String, Object>> passCheckDataList = this.checkParamList(paramsList, allFailResultDataList, true, "1");
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
            dataList.addAll(allFailResultDataList);
            List<Map<String, Object>> saveResultList = this.batchSaveDecAdjRecord(passCheckDataList, uuid);
            dataList.addAll(saveResultList);
            result.put("data", dataList);
            boolean success = this.isSuccess(dataList);
            if (endOperate && success) {
                this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{uuid}));
            }
            result.put(KEY_SUCCESS, success);
            result.put(KEY_MSG, "");
        }
        catch (Exception e) {
            logger.error("executeOp error, msg: ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a{0}\u3002", (String)"AdjFileInfoServiceHelper_1", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{e.getMessage()});
            result.put(KEY_MSG, msg);
            result.put(KEY_SUCCESS, Boolean.FALSE);
        }
        return result;
    }

    public Map<String, Object> saveBatchDecAdjData(String uuid, boolean endOperate, List<Map<String, Object>> paramsList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
            if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
                return checkEmptyResult;
            }
            Map<String, String> uuidEventDyMap = this.getSalaryAdjEventStatus(Sets.newHashSet((Object[])new String[]{uuid}));
            if ("1".equals(uuidEventDyMap.get(uuid))) {
                result.put(KEY_SUCCESS, Boolean.FALSE);
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524duuid\uff1a{0}\u4e8b\u4ef6\u5df2\u88ab\u63a8\u9001\u3002", (String)"AdjFileInfoServiceHelper_26", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                result.put(KEY_MSG, MessageFormat.format(errorMsg, uuid));
                return result;
            }
            ArrayList<Map<String, Object>> allFailResultDataList = new ArrayList<Map<String, Object>>(10);
            List<Map<String, Object>> passCheckDataList = this.checkParamList(paramsList, allFailResultDataList, true, "2");
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
            dataList.addAll(allFailResultDataList);
            List<Map<String, Object>> saveResultList = this.batchSaveDecAdj(passCheckDataList, uuid);
            dataList.addAll(saveResultList);
            result.put("data", dataList);
            boolean success = this.isSuccess(dataList);
            if (endOperate && success) {
                this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{uuid}));
            }
            result.put(KEY_SUCCESS, success);
            result.put(KEY_MSG, "");
        }
        catch (Exception e) {
            logger.error("executeOp error, msg: ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a{0}\u3002", (String)"AdjFileInfoServiceHelper_1", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{e.getMessage()});
            result.put(KEY_MSG, msg);
            result.put(KEY_SUCCESS, Boolean.FALSE);
        }
        return result;
    }

    private boolean isSuccess(List<Map<String, Object>> dataList) {
        boolean success = true;
        for (int i = 0; i < dataList.size(); ++i) {
            Boolean successFlag;
            Map<String, Object> map = dataList.get(i);
            if (map == null || (successFlag = (Boolean)map.get(KEY_SUCCESS)) == null || successFlag.booleanValue()) continue;
            success = false;
        }
        return success;
    }

    public Map<String, Object> saveDecAdjData(List<Map<String, Object>> paramsList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            Map<String, Object> checkEmptyResult = this.getCheckParamIsEmptyResult(paramsList);
            if (checkEmptyResult != null && !checkEmptyResult.isEmpty()) {
                return checkEmptyResult;
            }
            ArrayList<Map<String, Object>> allFailResultDataList = new ArrayList<Map<String, Object>>(10);
            List<Map<String, Object>> passCheckDataList = this.checkParamList(paramsList, allFailResultDataList, false, "2");
            Map<String, List<Map>> uuidMap = passCheckDataList.stream().collect(Collectors.groupingBy(map -> (String)map.get("uuid")));
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
            dataList.addAll(allFailResultDataList);
            for (Map.Entry<String, List<Map>> entry : uuidMap.entrySet()) {
                ArrayList tmpList = new ArrayList(entry.getValue().size());
                tmpList.addAll(entry.getValue());
                List tmpListSplit = Lists.partition(tmpList, (int)500);
                String eventUUID = entry.getKey();
                for (List minList : tmpListSplit) {
                    List<Map<String, Object>> saveResultList = this.batchSaveDecAdj(minList, eventUUID);
                    dataList.addAll(saveResultList);
                }
                this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{eventUUID}));
            }
            result.put("data", dataList);
            boolean success = this.isSuccess(dataList);
            result.put(KEY_SUCCESS, success);
            result.put(KEY_MSG, "");
        }
        catch (Exception e) {
            logger.error("executeOp error, msg: ", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a{0}\u3002", (String)"AdjFileInfoServiceHelper_1", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{e.getMessage()});
            result.put(KEY_MSG, msg);
            result.put(KEY_SUCCESS, Boolean.FALSE);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> batchSaveDecAdj(List<Map<String, Object>> paramList, String uuidEvent) throws ParseException {
        Map<String, Object> paramMap;
        ArrayList<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> dataHelperMap = this.getDataHelperMap(paramList, "2");
        ArrayList<Map<String, Object>> errorDataList = new ArrayList<Map<String, Object>>(10);
        List<Map<String, Object>> rightParamsList = this.validateParamFromDB(paramList, dataHelperMap, errorDataList, "2");
        returnDataList.addAll(errorDataList);
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> relPersonDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
        DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(uuidEvent);
        Long eventPkId = 0L;
        eventPkId = null == eventDyn ? this.genEventDyn(uuidEvent, eventDynList, null) : Long.valueOf(eventDyn.getLong("id"));
        String dataSource = null;
        long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(rightParamsList.size());
        HashMap<Long, Set> pkIdRulePkIdMap = new HashMap<Long, Set>(16);
        Map adjFileDyMap = (Map)dataHelperMap.get("ADJFILE_INFO_MAP");
        Map adjfileRecordMap = (Map)dataHelperMap.get("ADJFILE_ITEM_MAP");
        for (int i = 0; i < rightParamsList.size(); ++i) {
            Map<String, Object> paramMap2 = rightParamsList.get(i);
            if (null == dataSource) {
                dataSource = (String)paramMap2.get("datasource");
            }
            Long salaryadjfileId = this.getLongId(paramMap2.get(SALARYADJFILE));
            DynamicObject fileDyObj = (DynamicObject)adjFileDyMap.get(salaryadjfileId);
            Map adjRecordFieldDataMap = (Map)dataHelperMap.get("ADJ_RECORD_INFO_MAP");
            DynamicObject adjRecordDy = new SWCDataServiceHelper("hcdm_salaryadjrecord").generateEmptyDynamicObject();
            adjRecordDy.set("needpush", (Object)"1");
            adjRecordDy.set(SALARYADJFILE, (Object)fileDyObj);
            adjRecordDy.set("salaryadjfilevid", (Object)this.genFileDynamicObject(fileDyObj.getLong("sourcevid")));
            long pkId = this.genDecAdjOnePkId();
            adjRecordDy.set("id", (Object)pkId);
            adjRecordDy.set("boid", (Object)pkId);
            long currUserId = RequestContext.get().getCurrUserId();
            adjRecordDy.set("creator", (Object)currUserId);
            this.covert2DynamicObject(adjRecordDy, "hcdm_salaryadjrecord", paramMap2, adjRecordFieldDataMap);
            Map relPersonDataMap = (Map)paramMap2.get(RELPERSON_DATA);
            DynamicObject relPersonDy = new SWCDataServiceHelper("hcdm_decadjrelperson").generateEmptyDynamicObject();
            long relPersonId = relPersonIds[i];
            relPersonDy.set("id", (Object)relPersonId);
            adjRecordDy.set("relpersonid", (Object)relPersonId);
            relPersonDys.add(relPersonDy);
            if (relPersonDataMap != null && !relPersonDataMap.isEmpty()) {
                Map relPersonFieldDataMap = (Map)dataHelperMap.get("REL_PERSON_INFO_MAP");
                this.covert2DynamicObject(relPersonDy, "hcdm_decadjrelperson", relPersonDataMap, relPersonFieldDataMap);
            }
            List ruleMapList = (List)paramMap2.get(RULE_DATA);
            Set rulePkIds = pkIdRulePkIdMap.computeIfAbsent(pkId, v1 -> Sets.newHashSet());
            Long standardItemId = this.getLongId(paramMap2.get(STANDARDITEM));
            Date bsed = this.covert2DateOfNoTime(paramMap2.get("bsed"));
            for (Map ruleMap : ruleMapList) {
                String ruleType = (String)ruleMap.get(RULETYPE);
                Long ruleFileId = this.getLongId(ruleMap.get(RULE_SALARYADJFILE));
                Long ruleItemId = this.getLongId(ruleMap.get(RULE_STANDARDITEM));
                if (SWCStringUtils.equals((String)ruleType, (String)"1")) {
                    DynamicObject dbItemDy;
                    Map itemDBMap = (Map)adjfileRecordMap.get(ruleFileId);
                    if (salaryadjfileId.equals(ruleFileId) && standardItemId.equals(ruleItemId)) {
                        if (null == itemDBMap || !itemDBMap.containsKey(ruleItemId)) {
                            needSaveList.add(adjRecordDy);
                            rulePkIds.add(adjRecordDy.getLong("id"));
                        } else {
                            dbItemDy = (DynamicObject)itemDBMap.get(ruleItemId);
                            DynamicObject versionDy = this.genEnableVersion(dbItemDy, adjRecordDy);
                            versionDy.set("id", (Object)pkId);
                            needNewHisList.add(versionDy);
                            rulePkIds.add(pkId);
                        }
                    } else {
                        dbItemDy = (DynamicObject)itemDBMap.get(ruleItemId);
                        DynamicObject disableVersion = this.genDisableVersion(bsed, this.getDefaultMaxDate(), dbItemDy);
                        long decAdjOnePkId = this.genDecAdjOnePkId();
                        disableVersion.set("id", (Object)decAdjOnePkId);
                        needNewHisList.add(disableVersion);
                        rulePkIds.add(decAdjOnePkId);
                    }
                }
                if (!SWCStringUtils.equals((String)ruleType, (String)"2")) continue;
                DynamicObject ruleFileDy = (DynamicObject)adjFileDyMap.get(ruleFileId);
                adjRecordDy.set(SALARYADJFILE, (Object)ruleFileDy);
                adjRecordDy.set("salaryadjfilevid", (Object)this.genFileDynamicObject(ruleFileDy.getLong("sourcevid")));
                Map dbItemDyMap = (Map)adjfileRecordMap.get(ruleFileId);
                if (dbItemDyMap == null || !dbItemDyMap.containsKey(ruleItemId)) {
                    if (salaryadjfileId.equals(ruleFileId) && standardItemId.equals(ruleItemId)) {
                        rulePkIds.add(pkId);
                    } else {
                        long decAdjOnePkId = this.genDecAdjOnePkId();
                        adjRecordDy.set("id", (Object)decAdjOnePkId);
                        adjRecordDy.set("boid", (Object)decAdjOnePkId);
                        rulePkIds.add(pkId);
                    }
                    needSaveList.add(adjRecordDy);
                    continue;
                }
                DynamicObject dbItemDyObj = (DynamicObject)dbItemDyMap.get(ruleItemId);
                DynamicObject versionDy = this.genEnableVersion(dbItemDyObj, adjRecordDy);
                if (salaryadjfileId.equals(ruleFileId) && standardItemId.equals(ruleItemId)) {
                    versionDy.set("id", (Object)pkId);
                    rulePkIds.add(pkId);
                } else {
                    long decAdjOnePkId = this.genDecAdjOnePkId();
                    versionDy.set("id", (Object)decAdjOnePkId);
                    rulePkIds.add(decAdjOnePkId);
                }
                needNewHisList.add(versionDy);
            }
        }
        try (TXHandle txHandle = TX.required();){
            OperationResult operationResult;
            if (CollectionUtils.isNotEmpty(eventDynList)) {
                ((DynamicObject)eventDynList.get(0)).set("eventtype", (Object)dataSource);
                logger.info("DecAdjInfoServiceHelper datasource is:{}", (Object)dataSource);
                this.adjFileDomainService.saveDecAdjEvent(eventDynList);
            }
            this.adjFileDomainService.saveRelPerson(relPersonDys);
            boolean isBatchSuccess = true;
            if (CollectionUtils.isNotEmpty(needSaveList) && !(operationResult = this.adjFileDomainService.saveItemDataByOperate(needSaveList, eventPkId)).isSuccess()) {
                isBatchSuccess = false;
            }
            if (!needNewHisList.isEmpty()) {
                for (int i = 0; i < needNewHisList.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)needNewHisList.get(i);
                    logger.info("needNewHisList param: size is {}, needNewHisList{}: bsed is{}, bsled is {}, enable is {},fileid is {}", new Object[]{needNewHisList.size(), i, dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled"), dynamicObject.get("enable"), dynamicObject.get("salaryadjfile.id")});
                }
                HisResponse response = BaseDataHisHelper.saveTimeVersion((DynamicObject[])needNewHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
                String errorMessage = response.getErrorMessage();
                if (SWCStringUtils.isNotEmpty((String)errorMessage)) {
                    isBatchSuccess = false;
                }
            }
            if (isBatchSuccess) {
                for (int i = 0; i < rightParamsList.size(); ++i) {
                    paramMap = rightParamsList.get(i);
                    Map<String, Object> successResultMap = this.genSuccessResultMap(paramMap);
                    returnDataList.add(successResultMap);
                }
            }
            logger.info("begain generateSyncDataFromRec");
            ArrayList record = Lists.newArrayListWithExpectedSize((int)(needSaveList.size() + needNewHisList.size()));
            record.addAll(needSaveList);
            record.addAll(needNewHisList);
            SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, relPersonDys);
            txHandle.commit();
        }
        return returnDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> batchSaveDecAdjRecord(List<Map<String, Object>> paramList, String uuidEvent) throws ParseException {
        ArrayList<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>(10);
        Map<String, Object> dataHelperMap = this.getDataHelperMap(paramList, "1");
        ArrayList<Map<String, Object>> errorDataList = new ArrayList<Map<String, Object>>(10);
        List<Map<String, Object>> rightParamsList = this.validateParamFromDB(paramList, dataHelperMap, errorDataList, "1");
        this.filterSameFileAndItem(rightParamsList, errorDataList);
        returnDataList.addAll(errorDataList);
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needNewHisUnableList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> relPersonDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
        DynamicObject eventDyn = this.adjFileDomainService.queryByEvent(uuidEvent);
        Long eventPkId = 0L;
        eventPkId = null == eventDyn ? this.genEventDyn(uuidEvent, eventDynList, null) : Long.valueOf(eventDyn.getLong("id"));
        String dataSource = null;
        long[] relPersonIds = this.adjFileDomainService.genRelPersonPkId(rightParamsList.size());
        Map adjfileRecordMap = (Map)dataHelperMap.get("ADJFILE_ITEM_MAP");
        for (int i = 0; i < rightParamsList.size(); ++i) {
            String datamode;
            Map<String, Object> paramMap = rightParamsList.get(i);
            if (null == dataSource) {
                dataSource = (String)paramMap.get("datasource");
            }
            if (SWCStringUtils.equals((String)"2", (String)(datamode = (String)paramMap.get(DATAMODE)))) {
                this.dealDataModeCutData(needNewHisUnableList, adjfileRecordMap, paramMap);
            }
            if (!SWCStringUtils.equals((String)"1", (String)datamode)) continue;
            this.dealDataModeUpdateData(dataHelperMap, needSaveList, needNewHisList, relPersonDys, relPersonIds[i], paramMap);
        }
        try (TXHandle txHandle = TX.required();){
            OperationResult operationResult;
            if (CollectionUtils.isNotEmpty(eventDynList)) {
                ((DynamicObject)eventDynList.get(0)).set("eventtype", (Object)dataSource);
                logger.info("DecAdjInfoServiceHelper#batchSaveData datasource is:{}", (Object)dataSource);
                this.adjFileDomainService.saveDecAdjEvent(eventDynList);
            }
            this.adjFileDomainService.saveRelPerson(relPersonDys);
            boolean isBatchSuccess = true;
            isBatchSuccess = this.saveTimeVersion(needNewHisUnableList, eventPkId, isBatchSuccess);
            if (CollectionUtils.isNotEmpty(needSaveList) && !(operationResult = this.adjFileDomainService.saveItemDataByOperate(needSaveList, eventPkId)).isSuccess()) {
                isBatchSuccess = false;
            }
            if (isBatchSuccess = this.saveTimeVersion(needNewHisList, eventPkId, isBatchSuccess)) {
                for (int i = 0; i < rightParamsList.size(); ++i) {
                    Map<String, Object> paramMap = rightParamsList.get(i);
                    Map<String, Object> successResultMap = this.genSuccessResultMap(paramMap);
                    returnDataList.add(successResultMap);
                }
            }
            logger.info("DecAdjInfoServiceHelper#batchSaveData begain generateSyncDataFromRec");
            ArrayList record = Lists.newArrayListWithExpectedSize((int)(needSaveList.size() + needNewHisList.size()));
            record.addAll(needSaveList);
            record.addAll(needNewHisList);
            SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, record, relPersonDys);
            txHandle.commit();
        }
        return returnDataList;
    }

    private boolean saveTimeVersion(List<DynamicObject> needNewHisList, Long eventPkId, boolean isBatchSuccess) {
        if (!needNewHisList.isEmpty()) {
            for (int i = 0; i < needNewHisList.size(); ++i) {
                DynamicObject dynamicObject = needNewHisList.get(i);
                logger.info("DecAdjInfoServiceHelper#batchSaveData needNewHisList param: size is {}, needNewHisList{}: bsed is{}, bsled is {}, enable is {},fileid is {}", new Object[]{needNewHisList.size(), i, dynamicObject.getDate("bsed"), dynamicObject.getDate("bsled"), dynamicObject.get("enable"), dynamicObject.get("salaryadjfile.id")});
            }
            HisResponse response = BaseDataHisHelper.saveTimeVersion((DynamicObject[])needNewHisList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
            String errorMessage = response.getErrorMessage();
            if (SWCStringUtils.isNotEmpty((String)errorMessage)) {
                isBatchSuccess = false;
            }
        }
        return isBatchSuccess;
    }

    private void dealDataModeCutData(List<DynamicObject> needNewHisUnableList, Map<Long, Map<Long, DynamicObject>> adjfileRecordMap, Map<String, Object> paramMap) throws ParseException {
        Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
        Long standardItemId = this.getLongId(paramMap.get(STANDARDITEM));
        Date bsed = this.covert2DateOfNoTime(paramMap.get("bsed"));
        Map<Long, DynamicObject> recordDBMap = adjfileRecordMap.get(salaryadjfileId);
        DynamicObject dbRecordDy = recordDBMap.get(standardItemId);
        DynamicObject disableVersion = this.genDisableVersion(bsed, this.getDefaultMaxDate(), dbRecordDy);
        long decAdjOnePkId = this.genDecAdjOnePkId();
        disableVersion.set("id", (Object)decAdjOnePkId);
        needNewHisUnableList.add(disableVersion);
    }

    private void dealDataModeUpdateData(Map<String, Object> dataHelperMap, List<DynamicObject> needSaveList, List<DynamicObject> needNewHisList, List<DynamicObject> relPersonDys, long relPersonId, Map<String, Object> paramMap) throws ParseException {
        Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
        Long standardItemId = this.getLongId(paramMap.get(STANDARDITEM));
        Map adjFileDyMap = (Map)dataHelperMap.get("ADJFILE_INFO_MAP");
        Map adjfileRecordMap = (Map)dataHelperMap.get("ADJFILE_ITEM_MAP");
        Map recordDBMap = (Map)adjfileRecordMap.get(salaryadjfileId);
        DynamicObject fileDyObj = (DynamicObject)adjFileDyMap.get(salaryadjfileId);
        Map adjRecordFieldDataMap = (Map)dataHelperMap.get("ADJ_RECORD_INFO_MAP");
        DynamicObject adjRecordDy = new SWCDataServiceHelper("hcdm_salaryadjrecord").generateEmptyDynamicObject();
        adjRecordDy.set("needpush", (Object)"1");
        adjRecordDy.set(SALARYADJFILE, (Object)fileDyObj);
        adjRecordDy.set("salaryadjfilevid", (Object)this.genFileDynamicObject(fileDyObj.getLong("sourcevid")));
        long pkId = this.genDecAdjOnePkId();
        adjRecordDy.set("id", (Object)pkId);
        adjRecordDy.set("boid", (Object)pkId);
        long currUserId = RequestContext.get().getCurrUserId();
        adjRecordDy.set("creator", (Object)currUserId);
        this.covert2DynamicObject(adjRecordDy, "hcdm_salaryadjrecord", paramMap, adjRecordFieldDataMap);
        Map relPersonDataMap = (Map)paramMap.get(RELPERSON_DATA);
        DynamicObject relPersonDy = new SWCDataServiceHelper("hcdm_decadjrelperson").generateEmptyDynamicObject();
        relPersonDy.set("id", (Object)relPersonId);
        adjRecordDy.set("relpersonid", (Object)relPersonId);
        relPersonDys.add(relPersonDy);
        if (relPersonDataMap != null && !relPersonDataMap.isEmpty()) {
            Map relPersonFieldDataMap = (Map)dataHelperMap.get("REL_PERSON_INFO_MAP");
            this.covert2DynamicObject(relPersonDy, "hcdm_decadjrelperson", relPersonDataMap, relPersonFieldDataMap);
        }
        if (null == recordDBMap || !recordDBMap.containsKey(standardItemId)) {
            this.completeHisVersion(needSaveList, needNewHisList, adjRecordDy);
        } else {
            DynamicObject dbItemDy = (DynamicObject)recordDBMap.get(standardItemId);
            DynamicObject versionDy = this.genEnableVersion(dbItemDy, adjRecordDy);
            versionDy.set("id", (Object)pkId);
            needNewHisList.add(versionDy);
        }
    }

    private void completeHisVersion(List<DynamicObject> needSaveList, List<DynamicObject> needNewHisList, DynamicObject decAdjSalDyn) {
        Date bsled = decAdjSalDyn.getDate("bsled");
        if (bsled != null && bsled.compareTo(SWCDateTimeUtils.getMaxBsled()) < 0) {
            long newBoid = DB.genLongId((String)"T_HCDM_SALARYADJRECORD");
            DynamicObject addNewRecordData = (DynamicObject)cloneUtils.clone((IDataEntityBase)decAdjSalDyn);
            addNewRecordData.set("bsled", (Object)SWCDateTimeUtils.getMaxBsled());
            addNewRecordData.set("boid", (Object)newBoid);
            addNewRecordData.set("id", (Object)newBoid);
            needSaveList.add(addNewRecordData);
            decAdjSalDyn.set("bsed", (Object)SWCDateTimeUtils.addDay((Date)bsled, (long)1L));
            decAdjSalDyn.set("bsled", (Object)SWCDateTimeUtils.getMaxBsled());
            decAdjSalDyn.set("enable", (Object)"0");
            decAdjSalDyn.set("boid", (Object)newBoid);
            needNewHisList.add(decAdjSalDyn);
        } else if (bsled == null || bsled.compareTo(SWCDateTimeUtils.getMaxBsled()) == 0) {
            needSaveList.add(decAdjSalDyn);
        }
    }

    private List<Map<String, Object>> validateParamFromDB(List<Map<String, Object>> paramList, Map<String, Object> dataHelperMap, List<Map<String, Object>> errorDataList, String methodType) {
        ArrayList rightParamsList = Lists.newArrayListWithExpectedSize((int)paramList.size());
        HashSet<Integer> errorFileIndexSet = new HashSet<Integer>(16);
        for (int i = 0; i < paramList.size(); ++i) {
            Map<String, Object> errMap;
            Map<String, Object> ruleAdjfileAndItemResultMap;
            Map<String, Object> paramMap = paramList.get(i);
            Map<String, Object> notExistResultMap = this.checkValueExistDB(paramMap, dataHelperMap, methodType);
            if (!notExistResultMap.isEmpty()) {
                errorDataList.add(notExistResultMap);
                errorFileIndexSet.add(i);
                continue;
            }
            Map<String, Object> notBOIDErrMap = this.checkAdjfileBOID(paramMap, dataHelperMap);
            if (!notBOIDErrMap.isEmpty()) {
                errorDataList.add(notBOIDErrMap);
                errorFileIndexSet.add(i);
                continue;
            }
            Map<String, Object> checkEmpposErrMap = this.checkEmpposAvailable(paramMap, dataHelperMap);
            if (!checkEmpposErrMap.isEmpty()) {
                errorDataList.add(checkEmpposErrMap);
                errorFileIndexSet.add(i);
                continue;
            }
            Map adjfileRecordMap = (Map)dataHelperMap.get("ADJFILE_ITEM_MAP");
            if ("2".equals(methodType) && !(ruleAdjfileAndItemResultMap = this.checkRuleAdjfileAndItem(adjfileRecordMap, paramMap)).isEmpty()) {
                errorDataList.add(ruleAdjfileAndItemResultMap);
                errorFileIndexSet.add(i);
                continue;
            }
            if (!"1".equals(methodType) || !SWCStringUtils.equals((String)"2", (String)((String)paramMap.get(DATAMODE))) || (errMap = this.checkFileAndItemExist(adjfileRecordMap, paramMap)).isEmpty()) continue;
            errorDataList.add(errMap);
            errorFileIndexSet.add(i);
        }
        DecAdjInfoServiceHelper.addPassData(paramList, rightParamsList, errorFileIndexSet);
        return rightParamsList;
    }

    private Map<String, Object> checkEmpposAvailable(Map<String, Object> paramMap, Map<String, Object> dataHelperMap) {
        Map dempEmpposgrelMap = (Map)dataHelperMap.get("EMP_POS_ORG_MAP");
        if (dempEmpposgrelMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map relPersonDataMap = (Map)paramMap.get(RELPERSON_DATA);
        Long depempId = this.getLongTypeVal(relPersonDataMap, "depemp");
        DynamicObject empposDyn = (DynamicObject)dempEmpposgrelMap.get(depempId);
        if (null == empposDyn) {
            return Collections.emptyMap();
        }
        String errorMsg = ResManager.loadKDString((String)"\u4eba\u5458\u4efb\u804c\u5df2\u5e9f\u5f03\u3002", (String)"DecAdjInfoServiceHelper_18", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        Map<Object, Object> errorResultMap = Maps.newHashMapWithExpectedSize((int)1);
        if (SWCStringUtils.equals((String)"-1", (String)empposDyn.getString("datastatus"))) {
            errorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, errorMsg, paramMap);
        }
        return errorResultMap;
    }

    private Map<String, Object> checkFileAndItemExist(Map<Long, Map<Long, DynamicObject>> adjfileRecordMap, Map<String, Object> paramMap) {
        HashMap errorResultMap = Maps.newHashMapWithExpectedSize((int)1);
        Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
        Long standarditemId = this.getLongId(paramMap.get(STANDARDITEM));
        Map<Long, DynamicObject> recordMap = adjfileRecordMap.get(salaryadjfileId);
        if (null == recordMap || !recordMap.containsKey(standarditemId)) {
            String errorMsg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848\uff08{0}\uff09\u4e0b\u4e0d\u5b58\u5728\u5b9a\u8c03\u85aa\u9879\u76ee\uff08{1}\uff09\uff0c\u65e0\u6cd5\u8fdb\u884c\u7248\u672c\u5207\u65ad\u64cd\u4f5c\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjInfoServiceHelper_15", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            Map<String, Object> genErrorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(errorMsg, String.valueOf(salaryadjfileId), String.valueOf(standarditemId)), paramMap);
            errorResultMap.putAll(genErrorResultMap);
        }
        return errorResultMap;
    }

    private Map<String, Object> checkAdjfileBOID(Map<String, Object> paramMap, Map<String, Object> dataHelperMap) {
        Map<Object, Object> errorResultMap = Maps.newHashMapWithExpectedSize((int)1);
        Map adjFileDyMap = (Map)dataHelperMap.get("ADJFILE_INFO_MAP");
        Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
        DynamicObject fileDbDy = (DynamicObject)adjFileDyMap.get(salaryadjfileId);
        String errorMsg = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848ID\uff1a{0}\u4e0d\u662fBOID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DecAdjInfoServiceHelper_10", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        List ruleParamsList = (List)paramMap.get(RULE_DATA);
        ArrayList<Map<String, Object>> ruleErrList = new ArrayList<Map<String, Object>>(10);
        if (null != ruleParamsList && ruleParamsList.size() > 0) {
            for (Map ruleMap : ruleParamsList) {
                Long ruleFileId = this.getLongId(ruleMap.get(RULE_SALARYADJFILE));
                if (((DynamicObject)adjFileDyMap.get(ruleFileId)).getBoolean("iscurrentversion")) continue;
                Map<String, Object> errorRuleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(errorMsg, String.valueOf(ruleFileId)), ruleMap);
                ruleErrList.add(errorRuleResultMap);
            }
        }
        if (!fileDbDy.getBoolean("iscurrentversion")) {
            errorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(errorMsg, String.valueOf(salaryadjfileId)), paramMap);
            if (null != ruleParamsList) {
                errorResultMap.put(RULE_DATA, ruleParamsList);
            }
        } else if (!ruleErrList.isEmpty()) {
            errorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, "", paramMap);
            errorResultMap.put(RULE_DATA, ruleErrList);
        }
        return errorResultMap;
    }

    private Map<String, Object> checkValueExistDB(Map<String, Object> validDataMap, Map<String, Object> dataHelperMap, String methodType) {
        Map<String, Object> genErrorResultMap;
        HashMap errorResultMap = Maps.newHashMapWithExpectedSize((int)1);
        Map adjFileDyMap = (Map)dataHelperMap.get("ADJFILE_INFO_MAP");
        Map itemDyMap = (Map)dataHelperMap.get("STANDARDITEM_INFO_MAP");
        Map adjRecordFieldDataMap = (Map)dataHelperMap.get("ADJ_RECORD_INFO_MAP");
        Map relPersonFieldDataMap = (Map)dataHelperMap.get("REL_PERSON_INFO_MAP");
        String bdNotFindMsg = ResManager.loadKDString((String)"\u201c{0}\u201d\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"DecAdjInfoServiceHelper_2", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        String recordFieldErr = this.checkParamExist("hcdm_salaryadjrecord", validDataMap, adjRecordFieldDataMap);
        Map relPersonDataMap = (Map)validDataMap.get(RELPERSON_DATA);
        String relPersonFieldErr = null;
        if (relPersonDataMap != null && !relPersonDataMap.isEmpty() && !"2".equals(validDataMap.get(DATAMODE))) {
            relPersonFieldErr = this.checkParamExist("hcdm_decadjrelperson", relPersonDataMap, relPersonFieldDataMap);
        }
        if ("2".equals(methodType)) {
            List ruleParamsList = (List)validDataMap.get(RULE_DATA);
            List<Map<String, Object>> ruleErrResultList = this.checkRuleExist(ruleParamsList, adjFileDyMap, itemDyMap, bdNotFindMsg);
            if (recordFieldErr.length() > 0 || relPersonFieldErr != null && relPersonFieldErr.length() > 0 || !ruleErrResultList.isEmpty()) {
                genErrorResultMap = this.copyRecordParamMap(validDataMap);
                if (recordFieldErr.length() > 0) {
                    genErrorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(bdNotFindMsg, recordFieldErr), validDataMap);
                }
                if (relPersonFieldErr != null && relPersonFieldErr.length() > 0) {
                    Map<String, Object> relPersonErrMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(bdNotFindMsg, relPersonFieldErr), relPersonDataMap);
                    genErrorResultMap.put(RELPERSON_DATA, relPersonErrMap);
                } else {
                    genErrorResultMap.put(RELPERSON_DATA, relPersonDataMap);
                }
                if (!ruleErrResultList.isEmpty()) {
                    genErrorResultMap.put(RULE_DATA, ruleErrResultList);
                } else {
                    genErrorResultMap.put(RULE_DATA, ruleParamsList);
                }
                errorResultMap.putAll(genErrorResultMap);
            }
        }
        if ("1".equals(methodType)) {
            String errString;
            StringJoiner stringJoiner = new StringJoiner(",");
            if (recordFieldErr.length() > 0) {
                stringJoiner.add(recordFieldErr);
            }
            if (relPersonFieldErr != null && relPersonFieldErr.length() > 0) {
                stringJoiner.add(relPersonFieldErr);
            }
            if ((errString = stringJoiner.toString()).length() > 0) {
                genErrorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(bdNotFindMsg, errString), validDataMap);
                errorResultMap.putAll(genErrorResultMap);
            }
        }
        return errorResultMap;
    }

    private List<Map<String, Object>> checkRuleExist(List<Map<String, Object>> ruleParamsList, Map<Long, DynamicObject> adjFileDyMap, Map<Long, DynamicObject> itemDyMap, String bdNotFindMsg) {
        ArrayList ruleErrResultList = Lists.newArrayListWithExpectedSize((int)ruleParamsList.size());
        for (Map<String, Object> ruleMap : ruleParamsList) {
            Long ruleFileId = this.getLongId(ruleMap.get(RULE_SALARYADJFILE));
            Long ruleItemId = this.getLongId(ruleMap.get(RULE_STANDARDITEM));
            StringJoiner stringJoiner = new StringJoiner(",");
            if (!adjFileDyMap.containsKey(ruleFileId)) {
                stringJoiner.add(SalaryStandardConstants.SALARY_ADJ_FILE() + ":" + String.valueOf(ruleFileId));
            }
            if (!itemDyMap.containsKey(ruleItemId)) {
                stringJoiner.add(SalaryStandardConstants.SALARY_STD_ITEM() + ":" + String.valueOf(ruleItemId));
            }
            if (stringJoiner.length() <= 0) continue;
            Map<String, Object> errorRuleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(bdNotFindMsg, stringJoiner.toString()), ruleMap);
            ruleErrResultList.add(errorRuleResultMap);
        }
        return ruleErrResultList;
    }

    private String checkParamExist(String baseEntity, Map<String, Object> paramMap, Map<String, Map<Long, DynamicObject>> fieldDyMap) {
        StringJoiner stringJoiner = new StringJoiner(",");
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)baseEntity).getFields();
        for (Map.Entry prop : fieldProps.entrySet()) {
            Map<Long, DynamicObject> dynamicObjectMap;
            Object pValue;
            Long longId;
            String pkey = (String)prop.getKey();
            IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
            if (!(propval instanceof BasedataProp) || null == (longId = this.getLongId(pValue = paramMap.get(pkey))) || null != (dynamicObjectMap = fieldDyMap.get(pkey)) && dynamicObjectMap.containsKey(longId)) continue;
            stringJoiner.add(propval.getDisplayName().getLocaleValue());
        }
        return stringJoiner.toString();
    }

    private Map<String, Object> checkRuleAdjfileAndItem(Map<Long, Map<Long, DynamicObject>> adjfileRecordMap, Map<String, Object> paramMap) {
        List ruleMapList = (List)paramMap.get(RULE_DATA);
        Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
        Long standarditemId = this.getLongId(paramMap.get(STANDARDITEM));
        for (Map ruleMap : ruleMapList) {
            Long ruleFileId = this.getLongId(ruleMap.get(RULE_SALARYADJFILE));
            Long ruleItemId = this.getLongId(ruleMap.get(RULE_STANDARDITEM));
            String ruleType = (String)ruleMap.get(RULETYPE);
            if (SWCStringUtils.equals((String)ruleType, (String)"2") || SWCStringUtils.equals((String)ruleType, (String)"1") && salaryadjfileId.equals(ruleFileId) && standarditemId.equals(ruleItemId)) continue;
            Map<Long, DynamicObject> recordMap = adjfileRecordMap.get(ruleFileId);
            String errorMsg = null;
            if (null == recordMap) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u7684\u6863\u6848\uff1a{0}\u4e0b\u4e0d\u5b58\u5728\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DecAdjInfoServiceHelper_3", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), String.valueOf(ruleFileId));
            } else if (!recordMap.containsKey(ruleItemId)) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u7684\u6863\u6848\uff1a{0}\u4e0b\u4e0d\u5b58\u5728\u9879\u76ee\uff1a{1}\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DecAdjInfoServiceHelper_4", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), String.valueOf(ruleFileId), String.valueOf(ruleItemId));
            }
            if (null == errorMsg) continue;
            Map<String, Object> errorDecAdjMap = this.genErrorDecAdjMap(paramMap, errorMsg, AdjFileErrorMessageEnum.DATA_WRONG);
            Map<String, Object> errorRuleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, errorMsg, ruleMap);
            errorDecAdjMap.put(RULE_DATA, errorRuleResultMap);
            return errorDecAdjMap;
        }
        return new HashMap<String, Object>();
    }

    private Map<Long, DynamicObject> getAdjFileInfoMapFromDb(List<Map<String, Object>> paramsList, String methodType) {
        HashSet fileIdSet = Sets.newHashSetWithExpectedSize((int)paramsList.size());
        for (int i = 0; i < paramsList.size(); ++i) {
            Map<String, Object> paramMap = paramsList.get(i);
            if (paramMap == null) continue;
            Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
            fileIdSet.add(salaryadjfileId);
            if (!"2".equals(methodType)) continue;
            List ruleMapList = (List)paramMap.get(RULE_DATA);
            for (Map ruleMap : ruleMapList) {
                fileIdSet.add(this.getLongId(ruleMap.get(RULE_SALARYADJFILE)));
            }
        }
        QFilter fileIdFilter = new QFilter("id", "in", (Object)fileIdSet);
        fileIdFilter.and("enable", "=", (Object)"1");
        fileIdFilter.and("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{fileIdFilter};
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(qFilters);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj, (k1, k2) -> k1));
    }

    private Map<String, Object> getDataHelperMap(List<Map<String, Object>> paramList, String methodType) {
        Map<Long, DynamicObject> depEmpPosOrgRelMap = this.getDepEmpPosOrgRelMap(paramList);
        Map<String, Map<Long, DynamicObject>> adjRecordFieldDataMap = this.getAdjRecordFileDataMap(paramList);
        Map<String, Map<Long, DynamicObject>> relPersonFieldDataMap = this.getRelPersonFieldDataMap(paramList);
        Map<Long, DynamicObject> itemInfoMap = this.getItemInfoMapFromDb(paramList, methodType);
        Map<Long, DynamicObject> adjFileInfoMap = this.getAdjFileInfoMapFromDb(paramList, methodType);
        Set<Long> adjfileIds = adjFileInfoMap.keySet();
        Map<Long, Map<Long, DynamicObject>> adjfileRecordMap = this.getDecAdjRecordByAdjfile(adjfileIds);
        HashMap<String, Object> dataHelperMap = new HashMap<String, Object>(16);
        dataHelperMap.put("ADJFILE_INFO_MAP", adjFileInfoMap);
        dataHelperMap.put("STANDARDITEM_INFO_MAP", itemInfoMap);
        dataHelperMap.put("ADJ_RECORD_INFO_MAP", adjRecordFieldDataMap);
        dataHelperMap.put("REL_PERSON_INFO_MAP", relPersonFieldDataMap);
        dataHelperMap.put("EMP_POS_ORG_MAP", depEmpPosOrgRelMap);
        dataHelperMap.put("ADJFILE_ITEM_MAP", adjfileRecordMap);
        return dataHelperMap;
    }

    private Map<Long, DynamicObject> getItemInfoMapFromDb(List<Map<String, Object>> paramsList, String methodType) {
        HashSet itemIdSet = Sets.newHashSetWithExpectedSize((int)paramsList.size());
        for (int i = 0; i < paramsList.size(); ++i) {
            Map<String, Object> paramMap = paramsList.get(i);
            if (paramMap == null) continue;
            Long standarditemId = this.getLongId(paramMap.get(STANDARDITEM));
            itemIdSet.add(standarditemId);
            if (!"2".equals(methodType)) continue;
            List ruleMapList = (List)paramMap.get(RULE_DATA);
            for (Map ruleMap : ruleMapList) {
                itemIdSet.add(this.getLongId(ruleMap.get(RULE_STANDARDITEM)));
            }
        }
        QFilter filter = new QFilter("id", "in", (Object)itemIdSet);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{filter};
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_standarditem");
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(qFilters);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj, (k1, k2) -> k1));
    }

    private Map<String, Map<Long, DynamicObject>> getRelPersonFieldDataMap(List<Map<String, Object>> successAdjInfoList) {
        ArrayList<Map<String, Object>> allRelPersonDatas = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < successAdjInfoList.size(); ++i) {
            Map relPersonData;
            Map<String, Object> objectMap = successAdjInfoList.get(i);
            if (objectMap == null || objectMap.get(RELPERSON_DATA) == null || (relPersonData = (Map)objectMap.get(RELPERSON_DATA)) == null || relPersonData.isEmpty()) continue;
            allRelPersonDatas.add(relPersonData);
        }
        Map<String, Map<Long, DynamicObject>> relPersonFieldDataMap = this.batchGetFieldDatas(this.getFieldEntityAndIds("hcdm_decadjrelperson", allRelPersonDatas));
        return relPersonFieldDataMap;
    }

    private Map<String, Map<Long, DynamicObject>> getAdjRecordFileDataMap(List<Map<String, Object>> successAdjInfoList) {
        return this.batchGetFieldDatas(this.getFieldEntityAndIds("hcdm_salaryadjrecord", successAdjInfoList));
    }

    private Map<Long, DynamicObject> getDepEmpPosOrgRelMap(List<Map<String, Object>> successAdjInfoList) {
        HashSet<Long> depEmpIdSet = new HashSet<Long>(16);
        for (int i = 0; i < successAdjInfoList.size(); ++i) {
            Map<String, Object> paramMap = successAdjInfoList.get(i);
            if (paramMap == null) continue;
            Map relPersonDataMap = (Map)paramMap.get(RELPERSON_DATA);
            depEmpIdSet.add(this.getLongTypeVal(relPersonDataMap, "depemp"));
        }
        HashMap<Long, DynamicObject> depEmpPosOrgRelMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] empPosOrgRelInfos = SalaryAdjFileServiceHelper.queryJobByPersonalEmpposorgrel(depEmpIdSet, true);
        for (int i = 0; i < empPosOrgRelInfos.length; ++i) {
            DynamicObject depEmp;
            DynamicObject empPosOrgRelInfo = empPosOrgRelInfos[i];
            if (empPosOrgRelInfo == null || (depEmp = empPosOrgRelInfo.getDynamicObject("depemp")) == null) continue;
            long depEmpId = depEmp.getLong("id");
            depEmpPosOrgRelMap.put(depEmpId, empPosOrgRelInfo);
        }
        return depEmpPosOrgRelMap;
    }

    private List<Map<String, Object>> checkParamList(List<Map<String, Object>> paramsList, List<Map<String, Object>> allFailResultDataList, boolean isBatchApi, String methodType) throws ParseException {
        Map<String, List<Map<String, Object>>> checkResultMap = this.checkMustField(paramsList, isBatchApi, methodType);
        List<Map<String, Object>> passCheckDataList = checkResultMap.get(PASS_DATA);
        List<Map<String, Object>> checkMustFaildAdjInfoList = checkResultMap.get(FAIL_DATA);
        allFailResultDataList.addAll(checkMustFaildAdjInfoList);
        Map<String, List<Map<String, Object>>> UUIDResMap = this.checkUUIDStatus(passCheckDataList);
        passCheckDataList = UUIDResMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)UUIDResMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> bussinessIDResMap = this.checkUUIDAndBussinessID(passCheckDataList, isBatchApi);
        passCheckDataList = bussinessIDResMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)bussinessIDResMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> uniqueCodeResMap = this.checkUniqueCodeRepeat(passCheckDataList);
        passCheckDataList = uniqueCodeResMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)uniqueCodeResMap.get(FAIL_DATA));
        Map<String, List<Map<String, Object>>> checkAmountResultMap = this.checkAmount(passCheckDataList);
        passCheckDataList = checkAmountResultMap.get(PASS_DATA);
        allFailResultDataList.addAll((Collection<Map<String, Object>>)checkAmountResultMap.get(FAIL_DATA));
        if ("2".equals(methodType)) {
            Map<String, List<Map<String, Object>>> ruleItemResMap = this.checkFileAndItemRuleRepeat(passCheckDataList);
            passCheckDataList = ruleItemResMap.get(PASS_DATA);
            allFailResultDataList.addAll((Collection<Map<String, Object>>)ruleItemResMap.get(FAIL_DATA));
            Map<String, List<Map<String, Object>>> checkRuleResultMap = this.checkRuleData(passCheckDataList);
            passCheckDataList = checkRuleResultMap.get(PASS_DATA);
            allFailResultDataList.addAll((Collection<Map<String, Object>>)checkRuleResultMap.get(FAIL_DATA));
        }
        if ("1".equals(methodType)) {
            Map<String, List<Map<String, Object>>> dataModeReptResMap = this.checkFileAndItemDataModeRepeat(passCheckDataList);
            passCheckDataList = dataModeReptResMap.get(PASS_DATA);
            allFailResultDataList.addAll((Collection<Map<String, Object>>)dataModeReptResMap.get(FAIL_DATA));
            Map<String, List<Map<String, Object>>> fileVersionResMap = this.checkMatchAdjFileVersion(passCheckDataList);
            passCheckDataList = fileVersionResMap.get(PASS_DATA);
            allFailResultDataList.addAll((Collection<Map<String, Object>>)fileVersionResMap.get(FAIL_DATA));
        }
        this.filterSameFileAndItem(passCheckDataList, allFailResultDataList);
        return passCheckDataList;
    }

    private void filterSameFileAndItem(List<Map<String, Object>> passCheckDataList, List<Map<String, Object>> failedList) {
        if (failedList.isEmpty()) {
            return;
        }
        HashMap fileItemFailedMap = Maps.newHashMapWithExpectedSize((int)failedList.size());
        for (Map<String, Object> failedMap : failedList) {
            Long salaryadjfileId = this.getLongTypeVal(failedMap, SALARYADJFILE);
            Long standarditemId = this.getLongTypeVal(failedMap, STANDARDITEM);
            if (null == salaryadjfileId || null == standarditemId) continue;
            String uniqueString = salaryadjfileId + KEY_SPLIT_FALG + standarditemId;
            Map fileItemMap = fileItemFailedMap.computeIfAbsent(uniqueString, k1 -> new HashMap());
            fileItemMap.putAll(failedMap);
        }
        String errorMsg = ResManager.loadKDString((String)"\u540c\u4e00\u5b9a\u8c03\u85aa\u6863\u6848\u4e2d\u76f8\u540c\u7684\u5b9a\u8c03\u85aa\u9879\u76ee\u6821\u9a8c\u5931\u8d25\uff0c\u9700\u786e\u4fdd\u76f8\u540c\u5b9a\u8c03\u85aa\u9879\u76ee\u540c\u65f6\u6821\u9a8c\u6210\u529f\u624d\u80fd\u843d\u5b58\u6570\u636e\u3002", (String)"DecAdjInfoServiceHelper_17", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        Iterator<Map<String, Object>> iterator = passCheckDataList.iterator();
        while (iterator.hasNext()) {
            String uniqueString;
            Map<String, Object> passMap = iterator.next();
            Long salaryadjfileId = this.getLongTypeVal(passMap, SALARYADJFILE);
            Long standarditemId = this.getLongTypeVal(passMap, STANDARDITEM);
            if (null == salaryadjfileId || null == standarditemId || !fileItemFailedMap.containsKey(uniqueString = salaryadjfileId + KEY_SPLIT_FALG + standarditemId)) continue;
            Map<String, Object> checkResMap = this.genErrorDecAdjMap(passMap, errorMsg, AdjFileErrorMessageEnum.MUST_FIELD_ERROR);
            failedList.add(checkResMap);
            iterator.remove();
        }
    }

    private Map<String, List<Map<String, Object>>> checkMatchAdjFileVersion(List<Map<String, Object>> passCheckDataList) throws ParseException {
        String unionId;
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<AdjFileMatchParam> fileMatchParams = new ArrayList<AdjFileMatchParam>(10);
        for (Map<String, Object> dataMap : passCheckDataList) {
            String dataMode = (String)dataMap.get(DATAMODE);
            if (SWCStringUtils.equals((String)"2", (String)dataMode)) continue;
            Long salaryadjfileId = this.getLongTypeVal(dataMap, SALARYADJFILE);
            Long standarditemId = this.getLongTypeVal(dataMap, STANDARDITEM);
            Date bsed = this.covert2DateOfNoTime(dataMap.get("bsed"));
            Date bsled = this.covert2DateOfNoTime(dataMap.get("bsled")) == null ? SWCDateTimeUtils.getMaxBsled() : this.covert2DateOfNoTime(dataMap.get("bsled"));
            AdjFileMatchParam fileMatchParam = new AdjFileMatchParam();
            fileMatchParam.setAdjFileBoId(salaryadjfileId);
            fileMatchParam.setBsed(bsed);
            fileMatchParam.setBsled(bsled);
            unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(salaryadjfileId), String.valueOf(standarditemId), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
            fileMatchParam.setUnionId(unionId);
            fileMatchParams.add(fileMatchParam);
        }
        Map<String, AdjfileMatchResult> matchResultMap = this.adjFileApplicationService.batchMatchEffectiveAdjfileVersion(fileMatchParams);
        for (Map<String, Object> dataMap : passCheckDataList) {
            Date bsled;
            String dataMode = (String)dataMap.get(DATAMODE);
            if (SWCStringUtils.equals((String)"2", (String)dataMode)) {
                passDataList.add(dataMap);
                continue;
            }
            Long salaryadjfileId = this.getLongTypeVal(dataMap, SALARYADJFILE);
            Long standarditemId = this.getLongTypeVal(dataMap, STANDARDITEM);
            Date bsed = this.covert2DateOfNoTime(dataMap.get("bsed"));
            Date date = bsled = this.covert2DateOfNoTime(dataMap.get("bsled")) == null ? SWCDateTimeUtils.getMaxBsled() : this.covert2DateOfNoTime(dataMap.get("bsled"));
            unionId = DecAdjApprCreateGridHelper.combineStrings(String.valueOf(salaryadjfileId), String.valueOf(standarditemId), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd"));
            AdjfileMatchResult adjfileMatchResult = matchResultMap.get(unionId);
            if (null == adjfileMatchResult) continue;
            DynamicObject adjfileVersion = adjfileMatchResult.getAdjfileVersion();
            if (null == adjfileVersion) {
                Map<String, Object> errorRuleResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, adjfileMatchResult.getAdjfileNotFoundErrorEnum().getLocaleName().loadKDString(), dataMap);
                faildAdjInfoList.add(errorRuleResultMap);
                continue;
            }
            dataMap.put("salaryadjfilevid", adjfileVersion.getLong("id"));
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, List<Map<String, Object>>> checkFileAndItemDataModeRepeat(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Integer> fileItemDataModeCountMap = new HashMap<String, Integer>(16);
        for (Map<String, Object> dataMap : passCheckDataList) {
            Integer count;
            String dataMode = (String)dataMap.get(DATAMODE);
            Long salaryadjfileId = this.getLongTypeVal(dataMap, SALARYADJFILE);
            Long standarditemId = this.getLongTypeVal(dataMap, STANDARDITEM);
            String uniqueString = dataMode + KEY_SPLIT_FALG + salaryadjfileId + KEY_SPLIT_FALG + standarditemId;
            Integer n = count = fileItemDataModeCountMap.get(uniqueString) == null ? Integer.valueOf(0) : (Integer)fileItemDataModeCountMap.get(uniqueString);
            Integer n2 = count = Integer.valueOf(count + 1);
            fileItemDataModeCountMap.put(uniqueString, count);
        }
        String formatStr = ResManager.loadKDString((String)"\u5b9a\u8c03\u85aa\u6863\u6848\uff08%1$s\uff09\u3001\u5b9a\u8c03\u85aa\u9879\u76ee\uff08%2$s\uff09\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u6a21\u5f0f\uff08%3$s\uff09\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DecAdjInfoServiceHelper_16", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (Map<String, Object> dataMap : passCheckDataList) {
            String dataMode = (String)dataMap.get(DATAMODE);
            Long salaryadjfileId = this.getLongTypeVal(dataMap, SALARYADJFILE);
            Long standarditemId = this.getLongTypeVal(dataMap, STANDARDITEM);
            String uniqueString = dataMode + KEY_SPLIT_FALG + salaryadjfileId + KEY_SPLIT_FALG + standarditemId;
            Integer count = (Integer)fileItemDataModeCountMap.get(uniqueString);
            if (count != null && count >= 2) {
                Map<String, Object> errorRuleResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, String.format(formatStr, String.valueOf(salaryadjfileId), String.valueOf(standarditemId), dataMode), dataMap);
                faildAdjInfoList.add(errorRuleResultMap);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, List<Map<String, Object>>> checkUUIDAndBussinessID(List<Map<String, Object>> paramsList, boolean isBatchApi) {
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        if (!isBatchApi) {
            Map<String, List<Map>> groupByUUIDMap = paramsList.stream().collect(Collectors.groupingBy(map -> (String)map.get("uuid")));
            for (Map.Entry<String, List<Map>> entry : groupByUUIDMap.entrySet()) {
                List<Map<String, Object>> uuidSameList = entry.getValue();
                if (this.checkBussinessId(uuidSameList)) {
                    faildAdjInfoList.addAll(uuidSameList);
                    continue;
                }
                passDataList.addAll(uuidSameList);
            }
        } else if (this.checkBussinessId(paramsList)) {
            faildAdjInfoList.addAll(paramsList);
        } else {
            passDataList.addAll(paramsList);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, List<Map<String, Object>>> checkUUIDStatus(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet uuidSet = Sets.newHashSetWithExpectedSize((int)passCheckDataList.size());
        for (Map<String, Object> dataMap : passCheckDataList) {
            String uuid = (String)dataMap.get("uuid");
            uuidSet.add(uuid);
        }
        Map<String, String> uuidEventDyMap = this.getSalaryAdjEventStatus(uuidSet);
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524duuid\uff1a{0}\u4e8b\u4ef6\u5df2\u88ab\u63a8\u9001\u3002", (String)"AdjFileInfoServiceHelper_26", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (Map<String, Object> dataMap : passCheckDataList) {
            String uuid = (String)dataMap.get("uuid");
            String eventStatus = uuidEventDyMap.get(uuid);
            if ("1".equals(eventStatus)) {
                Map<String, Object> map = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(errorMsg, uuid), dataMap);
                faildAdjInfoList.add(map);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, List<Map<String, Object>>> checkRuleData(List<Map<String, Object>> paramList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        String itemDifferentMsg = ResManager.loadKDString((String)"\u5207\u5272\u89c4\u5219\u4e3a\u8c03\u85aa\uff0c\u5165\u53c2\u9879\u76ee\u4e0e\u8c03\u85aa\u9879\u76ee\u9700\u8981\u4fdd\u8bc1\u4e00\u81f4\u3002", (String)"DecAdjInfoServiceHelper_5", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (int i = 0; i < paramList.size(); ++i) {
            Map<String, Object> paramMap = paramList.get(i);
            Long standarditemId = this.getLongTypeVal(paramMap, STANDARDITEM);
            List ruleData = (List)paramMap.get(RULE_DATA);
            ArrayList ruleErrorList = Lists.newArrayListWithExpectedSize((int)ruleData.size());
            for (Map ruleMap : ruleData) {
                Long ruleStandarditemId = this.getLongTypeVal(ruleMap, RULE_STANDARDITEM);
                String ruletype = (String)ruleMap.get(RULETYPE);
                if (null == standarditemId || null == ruleStandarditemId || !SWCStringUtils.equals((String)ruletype, (String)"2") || standarditemId.equals(ruleStandarditemId)) continue;
                String formatMsg = ResManager.loadKDString((String)"\u5207\u5272\u89c4\u5219\u4e3a\u8c03\u85aa\uff0c\u5165\u53c2\u9879\u76eeID:{0}\u4e0e\u89c4\u5219\u4e2d\u7684\u9879\u76eeID\uff1a{1}\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DecAdjInfoServiceHelper_6", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                Map<String, Object> errorRuleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(formatMsg, String.valueOf(standarditemId), String.valueOf(ruleStandarditemId)), ruleMap);
                ruleErrorList.add(errorRuleResultMap);
            }
            if (!ruleErrorList.isEmpty()) {
                Map<String, Object> errorRuleResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, itemDifferentMsg, paramMap);
                errorRuleResultMap.put(RULE_DATA, ruleErrorList);
                errorInfoList.add(errorRuleResultMap);
                continue;
            }
            passDataList.add(paramMap);
        }
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private Map<String, List<Map<String, Object>>> checkAmount(List<Map<String, Object>> paramList) {
        HashMap<String, List<Map<String, Object>>> returnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Integer> errorFileIndexSet = new HashSet<Integer>(16);
        if (paramList != null) {
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> paramMap = paramList.get(i);
                if (paramMap == null) continue;
                Object amountParam = paramMap.get("amount");
                BigDecimal amount = this.covert2BigDecimal(amountParam);
                if (amountParam == null || amount == null) continue;
                BigDecimal checkAmount = new BigDecimal(amount.toString());
                checkAmount = checkAmount.stripTrailingZeros();
                int scale = checkAmount.scale();
                int precision = checkAmount.precision();
                if (precision - scale <= 13 && scale <= 10) continue;
                String amountString = checkAmount.toPlainString();
                String msg = ResManager.loadKDString((String)"\u91d1\u989d\uff1a{0}\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_22", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{amountString});
                Map<String, Object> errMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, msg, paramMap);
                errorInfoList.add(errMap);
                errorFileIndexSet.add(i);
                break;
            }
        }
        DecAdjInfoServiceHelper.addPassData(paramList, passDataList, errorFileIndexSet);
        returnMap.put(PASS_DATA, passDataList);
        returnMap.put(FAIL_DATA, errorInfoList);
        return returnMap;
    }

    private static void addPassData(List<Map<String, Object>> paramList, List<Map<String, Object>> passDataList, Set<Integer> errorFileIndexSet) {
        if (paramList != null) {
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> paramMap = paramList.get(i);
                if (paramMap == null || errorFileIndexSet.contains(i)) continue;
                passDataList.add(paramMap);
            }
        }
    }

    private Map<String, List<Map<String, Object>>> checkFileAndItemRuleRepeat(List<Map<String, Object>> passCheckDataList) {
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Integer> fileAndItemCoutMap = new HashMap<String, Integer>(16);
        for (Map<String, Object> dataMap : passCheckDataList) {
            List ruleData = (List)dataMap.get(RULE_DATA);
            for (Map ruleMap : ruleData) {
                Integer count;
                Long cutSalaryadjfileId = this.getLongTypeVal(ruleMap, RULE_SALARYADJFILE);
                Long cutStandarditemId = this.getLongTypeVal(ruleMap, RULE_STANDARDITEM);
                String fileAndItemKey = cutSalaryadjfileId + KEY_SPLIT_FALG + cutStandarditemId;
                Integer n = count = fileAndItemCoutMap.get(fileAndItemKey) == null ? Integer.valueOf(0) : (Integer)fileAndItemCoutMap.get(fileAndItemKey);
                Integer n2 = count = Integer.valueOf(count + 1);
                fileAndItemCoutMap.put(fileAndItemKey, count);
            }
        }
        String formatStr = ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u7684\u5b9a\u8c03\u85aa\u6863\u6848:{0}\u548c\u89c4\u5219\u4e2d\u7684\u5b9a\u8c03\u85aa\u9879\u76ee{1}\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DecAdjInfoServiceHelper_7", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            Map<String, Object> dataMap = passCheckDataList.get(i);
            List ruleData = (List)dataMap.get(RULE_DATA);
            ArrayList ruleErrorList = Lists.newArrayListWithCapacity((int)ruleData.size());
            for (Map ruleMap : ruleData) {
                Long cutSalaryadjfileId = this.getLongTypeVal(ruleMap, RULE_SALARYADJFILE);
                Long cutStandarditemId = this.getLongTypeVal(ruleMap, RULE_STANDARDITEM);
                String fileAndItemKey = cutSalaryadjfileId + KEY_SPLIT_FALG + cutStandarditemId;
                Integer integer = (Integer)fileAndItemCoutMap.get(fileAndItemKey);
                if (integer == null || integer < 2) continue;
                Map<String, Object> map = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, MessageFormat.format(formatStr, String.valueOf(cutSalaryadjfileId), String.valueOf(cutStandarditemId)), ruleMap);
                ruleErrorList.add(map);
            }
            if (!ruleErrorList.isEmpty()) {
                Map<String, Object> errorResultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u7684\u6863\u6848\u548c\u9879\u76ee\u53ea\u5141\u8bb8\u88ab\u6307\u5b9a\u4e00\u6b21\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DecAdjInfoServiceHelper_8", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]), dataMap);
                errorResultMap.put(RULE_DATA, ruleErrorList);
                faildAdjInfoList.add(errorResultMap);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, List<Map<String, Object>>> checkMustField(List<Map<String, Object>> paramsList, boolean isBatchApi, String methodType) {
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashSet<Integer> errorFileIndexSet = new HashSet<Integer>(16);
        for (int i = 0; i < paramsList.size(); ++i) {
            Map<String, Object> dataModeLegalErrorMap;
            Map relPersonParamMap;
            String relPersonMustError;
            Map<String, Object> paramMap = paramsList.get(i);
            if (paramMap == null || paramMap.isEmpty()) continue;
            String errorMsg = null;
            if ("2".equals(methodType)) {
                errorMsg = isBatchApi ? this.checkMustField(paramMap, this.BATCH_DECADJ_MUST_FIELDS, this.DECADJ_MUST_LONG_ID_FIELDS) : this.checkMustField(paramMap, this.DECADJ_MUST_FIELDS, this.DECADJ_MUST_LONG_ID_FIELDS);
            } else if (isBatchApi) {
                errorMsg = this.checkMustField(paramMap, this.BATCH_MUST_FIELDS_MODE_CUT, new String[]{STANDARDITEM, SALARYADJFILE});
                if (errorMsg == null && SWCStringUtils.equals((String)"1", (String)((String)paramMap.get(DATAMODE)))) {
                    errorMsg = this.checkMustField(paramMap, this.BATCH_MUST_FIELDS_MODE_UPDATE, this.DECADJ_MUST_LONG_ID_FIELDS);
                }
            } else {
                errorMsg = this.checkMustField(paramMap, this.MUST_FIELDS_MODE_CUT, new String[]{STANDARDITEM, SALARYADJFILE});
                if (errorMsg == null && SWCStringUtils.equals((String)"1", (String)((String)paramMap.get(DATAMODE)))) {
                    errorMsg = this.checkMustField(paramMap, this.MUST_FIELDS_MODE_UPDATE, this.DECADJ_MUST_LONG_ID_FIELDS);
                }
            }
            if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                Map<String, Object> checkResMap = this.genErrorDecAdjMap(paramMap, errorMsg, AdjFileErrorMessageEnum.MUST_FIELD_ERROR);
                faildAdjInfoList.add(checkResMap);
                errorFileIndexSet.add(i);
                continue;
            }
            if (("2".equals(methodType) || SWCStringUtils.equals((String)"1", (String)((String)paramMap.get(DATAMODE)))) && SWCStringUtils.isNotEmpty((String)(relPersonMustError = this.checkMustField(relPersonParamMap = (Map)paramMap.get(RELPERSON_DATA), this.RELPERSONDATA_MUST_FIELDS, this.RELPERSONDATA_MUST_LONG_ID_FIELDS)))) {
                Map<String, Object> checkResMap = this.genErrorDecAdjMap(paramMap, relPersonMustError, AdjFileErrorMessageEnum.MUST_FIELD_ERROR);
                faildAdjInfoList.add(checkResMap);
                errorFileIndexSet.add(i);
                continue;
            }
            if ("2".equals(methodType)) {
                Long standardItemId;
                List ruleDataList = (List)paramMap.get(RULE_DATA);
                Long salaryadjfileId = this.getLongId(paramMap.get(SALARYADJFILE));
                boolean isContains = this.isRuleListContainsParamFileAndItem(salaryadjfileId, standardItemId = this.getLongId(paramMap.get(STANDARDITEM)), ruleDataList);
                if (!isContains) {
                    String formatStr = ResManager.loadKDString((String)"\u5165\u53c2\u5b9a\u8c03\u85aa\u6863\u6848\uff1a{0}\u548c\u5165\u53c2\u5b9a\u8c03\u85aa\u9879\u76ee\uff1a{1}\u5fc5\u987b\u6307\u5b9a\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjInfoServiceHelper_9", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
                    String errorMessage = MessageFormat.format(formatStr, String.valueOf(salaryadjfileId), String.valueOf(standardItemId));
                    Map<String, Object> resMap = this.genErrorDecAdjMap(paramMap, errorMessage, AdjFileErrorMessageEnum.MUST_FIELD_ERROR);
                    resMap.put(RULE_DATA, ruleDataList);
                    faildAdjInfoList.add(resMap);
                    errorFileIndexSet.add(i);
                    continue;
                }
                Map<String, Object> ruleMustInuptErrorMap = this.checkRuleDataMustInput(paramMap);
                if (!ruleMustInuptErrorMap.isEmpty()) {
                    faildAdjInfoList.add(ruleMustInuptErrorMap);
                    errorFileIndexSet.add(i);
                    continue;
                }
                Map<String, Object> ruleTypeLegalErrorMap = this.checRuleTypeLegal(paramMap);
                if (!ruleTypeLegalErrorMap.isEmpty()) {
                    faildAdjInfoList.add(ruleTypeLegalErrorMap);
                    errorFileIndexSet.add(i);
                    continue;
                }
            }
            if (!"1".equals(methodType) || (dataModeLegalErrorMap = this.checkDataModeLegal(paramMap)).isEmpty()) continue;
            faildAdjInfoList.add(dataModeLegalErrorMap);
            errorFileIndexSet.add(i);
        }
        DecAdjInfoServiceHelper.addPassData(paramsList, passDataList, errorFileIndexSet);
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    private Map<String, Object> checkDataModeLegal(Map<String, Object> paramMap) {
        String dataMode = (String)paramMap.get(DATAMODE);
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)paramMap.size());
        String dataModeErrorMsg = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u5f0fdatamode\uff1a{0}\u4e0d\u5728[1,2]\u53ef\u9009\u8303\u56f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjInfoServiceHelper_14", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        if (!RULETYPESET.contains(dataMode)) {
            String errorMessage = MessageFormat.format(dataModeErrorMsg, dataMode);
            resultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, errorMessage, paramMap);
        }
        return resultMap;
    }

    private Map<String, Object> checRuleTypeLegal(Map<String, Object> paramMap) {
        List ruleDataList = (List)paramMap.get(RULE_DATA);
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)ruleDataList.size());
        ArrayList errorRuleList = Lists.newArrayListWithExpectedSize((int)ruleDataList.size());
        String ruleTypeErrorMsg = ResManager.loadKDString((String)"\u7248\u672c\u5207\u5272\u89c4\u5219\u7c7b\u578bruletype\uff1a{0}\u4e0d\u5728[1,2]\u53ef\u9009\u8303\u56f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjInfoServiceHelper_11", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (int j = 0; j < ruleDataList.size(); ++j) {
            Map ruleMap = (Map)ruleDataList.get(j);
            String ruleType = (String)ruleMap.get(RULETYPE);
            if (RULETYPESET.contains(ruleType)) continue;
            String errorMessage = MessageFormat.format(ruleTypeErrorMsg, ruleType);
            Map<String, Object> ruleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DATA_WRONG, errorMessage, ruleMap);
            errorRuleList.add(ruleResultMap);
        }
        if (!errorRuleList.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u7248\u672c\u5207\u5272\u89c4\u5219\u7c7b\u578bruletype\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjInfoServiceHelper_12", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            resultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, errorMsg, paramMap);
            resultMap.put(RULE_DATA, errorRuleList);
        }
        return resultMap;
    }

    private Map<String, Object> checkRuleDataMustInput(Map<String, Object> paramMap) {
        List ruleDataList = (List)paramMap.get(RULE_DATA);
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)ruleDataList.size());
        ArrayList errorRuleList = Lists.newArrayListWithExpectedSize((int)ruleDataList.size());
        for (int j = 0; j < ruleDataList.size(); ++j) {
            Map ruleMap = (Map)ruleDataList.get(j);
            String errorMessage = this.checkMustField(ruleMap, this.RULE_MUST_FIELDS, this.RULE_MUST_LONG_ID_FIELDS);
            if (!SWCStringUtils.isNotEmpty((String)errorMessage)) continue;
            Map<String, Object> ruleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.MUST_FIELD_ERROR, errorMessage, ruleMap);
            errorRuleList.add(ruleResultMap);
        }
        if (!errorRuleList.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u5165\u53c2\u89c4\u5219\u5236\u5b9a\u96c6\u5408\u4e2d\u5b58\u5728\u5fc5\u586b\u9879\u5b57\u6bb5\u672a\u586b\u5199\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DecAdjInfoServiceHelper_13", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
            resultMap = this.genErrorResultMap(AdjFileErrorMessageEnum.MUST_FIELD_ERROR, errorMsg, paramMap);
            resultMap.put(RULE_DATA, errorRuleList);
        }
        return resultMap;
    }

    private boolean isRuleListContainsParamFileAndItem(Long salaryadjfileId, Long standardItemId, List<Map<String, Object>> ruleDataList) {
        if (null != ruleDataList && !ruleDataList.isEmpty()) {
            for (int j = 0; j < ruleDataList.size(); ++j) {
                Map<String, Object> ruleMap = ruleDataList.get(j);
                Long ruleFileId = this.getLongId(ruleMap.get(RULE_SALARYADJFILE));
                Long ruleItemId = this.getLongId(ruleMap.get(RULE_STANDARDITEM));
                if (!salaryadjfileId.equals(ruleFileId) || !standardItemId.equals(ruleItemId)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Object> genErrorDecAdjMap(Map<String, Object> paramMap, String errorMsg, AdjFileErrorMessageEnum errorMessageEnum) {
        if (paramMap == null || paramMap.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        Map<String, Object> adjResMap = this.genErrorResultMap(errorMessageEnum, errorMsg, paramMap);
        return adjResMap;
    }

    private Map<String, Object> copyRecordParamMap(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(SALARYADJFILE, paramMap.get(SALARYADJFILE));
        resultMap.put(STANDARDITEM, paramMap.get(STANDARDITEM));
        resultMap.put("bsed", paramMap.get("bsed"));
        if (null != paramMap.get("uuid")) {
            resultMap.put("uuid", paramMap.get("uuid"));
        }
        resultMap.put("uniquecode", paramMap.get("uniquecode"));
        resultMap.put(RELPERSON_DATA, paramMap.get(RELPERSON_DATA));
        if (null != paramMap.get(RULE_DATA)) {
            resultMap.put(RULE_DATA, paramMap.get(RULE_DATA));
        }
        if (null != paramMap.get(DATAMODE)) {
            resultMap.put(DATAMODE, paramMap.get(DATAMODE));
        }
        return resultMap;
    }

    private Map<String, Object> genErrorResultMap(AdjFileErrorMessageEnum errorMessageEnum, String errorMsg, Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(KEY_SUCCESS, Boolean.FALSE);
        resultMap.put("code", errorMessageEnum.getCode());
        resultMap.put("errormsg", errorMsg);
        Map<String, Object> copyParamMap = this.copyRecordParamMap(paramMap);
        resultMap.putAll(copyParamMap);
        return resultMap;
    }

    private Map<String, Object> genErrorRuleResultMap(AdjFileErrorMessageEnum errorMessageEnum, String errorMsg, Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(KEY_SUCCESS, Boolean.FALSE);
        resultMap.put("code", errorMessageEnum.getCode());
        resultMap.put("errormsg", errorMsg);
        resultMap.putAll(paramMap);
        return resultMap;
    }

    private String checkMustField(Map<String, Object> dataMap, String[] mustCheckFields, String[] longIdMustFiles) {
        StringBuilder mustMessageBuild = new StringBuilder();
        for (int i = 0; i < mustCheckFields.length; ++i) {
            String fieldKey = mustCheckFields[i];
            Object value = dataMap.get(fieldKey);
            if (!dataMap.containsKey(fieldKey)) {
                if (!SWCStringUtils.isEmpty((String)mustMessageBuild.toString())) {
                    mustMessageBuild.append('\u3001');
                }
                mustMessageBuild.append(fieldKey);
                continue;
            }
            if (value != null && this.passLongValMustHasVal(dataMap, longIdMustFiles, fieldKey)) continue;
            if (!SWCStringUtils.isEmpty((String)mustMessageBuild.toString())) {
                mustMessageBuild.append('\u3001');
            }
            mustMessageBuild.append(fieldKey);
        }
        if (!SWCStringUtils.isEmpty((String)mustMessageBuild.toString())) {
            return ResManager.loadKDString((String)"\u5fc5\u586b\u9879{0}\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AdjFileInfoServiceHelper_0", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{mustMessageBuild.toString()});
        }
        return null;
    }

    private boolean passLongValMustHasVal(Map<String, Object> dataMap, String[] longIdMustFiles, String fieldKey) {
        boolean idLongValPass = true;
        if (longIdMustFiles != null) {
            for (int j = 0; j < longIdMustFiles.length; ++j) {
                Long longVal;
                String longIdMustFile = longIdMustFiles[j];
                if (!fieldKey.equals(longIdMustFile) || (longVal = this.getLongTypeVal(dataMap, fieldKey)) != null && longVal != 0L) continue;
                idLongValPass = false;
            }
        }
        return idLongValPass;
    }

    private Long getLongTypeVal(Map<String, Object> dataMap, String key) {
        Long returnVal = null;
        if (dataMap != null) {
            Object keyVal = dataMap.get(key);
            if (keyVal instanceof Integer) {
                returnVal = ((Integer)keyVal).longValue();
            } else if (keyVal instanceof Long) {
                returnVal = (Long)keyVal;
            } else if (keyVal instanceof String) {
                returnVal = Long.parseLong((String)keyVal);
            }
        }
        return returnVal;
    }

    private Map<String, List<Map<String, Object>>> checkUniqueCodeRepeat(List<Map<String, Object>> passCheckDataList) {
        String uniCode;
        HashMap<String, List<Map<String, Object>>> methodReturnMap = new HashMap<String, List<Map<String, Object>>>(16);
        ArrayList<Map<String, Object>> faildAdjInfoList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> passDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Integer> unicodeCoutMap = new HashMap<String, Integer>(16);
        for (Map<String, Object> dataMap : passCheckDataList) {
            Integer count;
            uniCode = (String)dataMap.get("uniquecode");
            Integer n = count = unicodeCoutMap.get(uniCode) == null ? Integer.valueOf(0) : (Integer)unicodeCoutMap.get(uniCode);
            Integer n2 = count = Integer.valueOf(count + 1);
            unicodeCoutMap.put(uniCode, count);
        }
        for (int i = 0; i < passCheckDataList.size(); ++i) {
            Map<String, Object> dataMap;
            dataMap = passCheckDataList.get(i);
            uniCode = (String)dataMap.get("uniquecode");
            Integer integer = (Integer)unicodeCoutMap.get(uniCode);
            if (integer != null && integer >= 2) {
                String message = ResManager.loadKDString((String)"uniquecode:{0}\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjFileInfoServiceHelper_3", (String)SWC_HCDM_BUSINESS, (Object[])new Object[]{uniCode});
                Map<String, Object> map = this.genErrorResultMap(AdjFileErrorMessageEnum.DATA_WRONG, message, dataMap);
                faildAdjInfoList.add(map);
                continue;
            }
            passDataList.add(dataMap);
        }
        methodReturnMap.put(FAIL_DATA, faildAdjInfoList);
        methodReturnMap.put(PASS_DATA, passDataList);
        return methodReturnMap;
    }

    protected Map<String, Object> genSuccessResultMap(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(KEY_SUCCESS, Boolean.TRUE);
        resultMap.put("code", 200L);
        resultMap.put("errormsg", "");
        resultMap.put(SALARYADJFILE, paramMap.get(SALARYADJFILE));
        resultMap.put(STANDARDITEM, paramMap.get(STANDARDITEM));
        resultMap.put("bsed", paramMap.get("bsed"));
        if (null != paramMap.get("uuid")) {
            resultMap.put("uuid", paramMap.get("uuid"));
        }
        resultMap.put("uniquecode", paramMap.get("uniquecode"));
        if (null != paramMap.get(RELPERSON_DATA)) {
            resultMap.put(RELPERSON_DATA, paramMap.get(RELPERSON_DATA));
        }
        if (null != paramMap.get(RULE_DATA)) {
            resultMap.put(RULE_DATA, paramMap.get(RULE_DATA));
        }
        if (null != paramMap.get(DATAMODE)) {
            resultMap.put(DATAMODE, paramMap.get(DATAMODE));
        }
        return resultMap;
    }

    protected void handleErrorMessageResult(Map<Long, Map<String, Object>> dataMaps, OperationResult operationResult, List<Map<String, Object>> resultList) {
        List successPkIds = operationResult.getSuccessPkIds();
        if (successPkIds == null || successPkIds.isEmpty()) {
            String errorMessage = operationResult.getMessage();
            for (Map.Entry<Long, Map<String, Object>> map : dataMaps.entrySet()) {
                if (map == null) continue;
                Map<String, Object> dataMap = map.getValue();
                Map<String, Object> errorMap = this.genErrorResultMap(AdjFileErrorMessageEnum.DECADJ_SAVE_ERROR, errorMessage, dataMap);
                List ruleDataList = (List)dataMap.get(RULE_DATA);
                ArrayList<Map<String, Object>> errorRuleList = new ArrayList<Map<String, Object>>(10);
                if (null != ruleDataList && !ruleDataList.isEmpty()) {
                    for (Map ruleMap : ruleDataList) {
                        Map<String, Object> errorRuleResultMap = this.genErrorRuleResultMap(AdjFileErrorMessageEnum.DECADJ_SAVE_ERROR, errorMessage, ruleMap);
                        errorRuleList.add(errorRuleResultMap);
                    }
                    errorMap.put(RULE_DATA, errorRuleList);
                }
                resultList.add(errorMap);
            }
        }
    }

    private long genDecAdjOnePkId() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hcdm_salaryadjrecord");
        return ORM.create().genLongId((IDataEntityType)mainEntityType);
    }

    private List<Map<String, Object>> dealOpResult(Map<Long, Map<String, Object>> dataMaps, Map<Long, Set<Long>> pkIdRulePkIdMap, OperationResult operationResult) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        if (operationResult != null) {
            this.handleErrorMessageResult(dataMaps, operationResult, resultList);
        }
        return resultList;
    }

    private DynamicObject genFileDynamicObject(Long salaryFileVid) {
        DynamicObject fileObj = new DynamicObject(this.adjFileInfoType);
        fileObj.set("id", (Object)salaryFileVid);
        return fileObj;
    }

    public DynamicObjectCollection getDecAdjInfos(List<String> selectFields, QFilter[] qFilters, String orderBys, int start, int limit) {
        List<Long> pkList = this.getDecAdjIds(qFilters, orderBys, start, limit);
        return this.getDecAdjInfos(selectFields, pkList, orderBys, 0, -1);
    }

    public List<Long> getDecAdjIds(QFilter[] qFilters, String orderBys, int start, int limit) {
        List pkObjList = HRQueryEntityHelper.getInstance().queryAllPkByKSql(this.getQueryEntityType(), qFilters, orderBys, start, limit);
        List<Object> pkList = Lists.newArrayListWithExpectedSize((int)16);
        if (pkObjList != null) {
            pkList = pkObjList.stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
        }
        return pkList;
    }

    public DynamicObjectCollection getDecAdjInfos(List<String> selectFields, List<Long> pkList, String orderBys, int start, int limit) {
        String selectProperties = String.join((CharSequence)",", selectFields);
        QFilter qFilter = new QFilter("id", "in", pkList);
        DynamicObjectCollection coll = null;
        boolean isLimitCount = true;
        if (limit <= 0) {
            isLimitCount = false;
        }
        try (DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(this.getQueryEntityType(), selectProperties, new QFilter[]{qFilter}, orderBys, isLimitCount, start, limit);){
            coll = ORM.create().toPlainDynamicObjectCollection(dataSet);
        }
        return coll;
    }

    private QueryEntityType getQueryEntityType() {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)HCDM_SALARYADJRECORDQUERY);
        return queryEntityType;
    }

    public Map<String, Object> syncAdjFileInfoExtField(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        DecAdjInfoServiceHelper.dealCollaExtField(params, data);
        result.put(KEY_SUCCESS, Boolean.TRUE);
        result.put("data", data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealCollaExtField(Map<String, Object> param, Map<String, Object> result) {
        String bizEntityNumber = String.valueOf(param.get("bizEntityNumber"));
        ArrayList<Long> setIds = new ArrayList<Long>(10);
        SWCDataServiceHelper collaSerHelper = new SWCDataServiceHelper("hsbs_triggercolla");
        QFilter filter = new QFilter("entityobject.number", "=", (Object)bizEntityNumber);
        filter.and("issyspreset", "=", (Object)Boolean.TRUE);
        DynamicObject collaDy = collaSerHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)collaSerHelper.getEntityName()), filter.toArray());
        if (collaDy == null) {
            return;
        }
        DynamicObjectCollection params = collaDy.getDynamicObjectCollection("paramentryentity");
        Map<String, DynamicObject> paramMap = params.stream().collect(Collectors.toMap(dy -> dy.getString("fieldkey"), dy -> dy, (v1, v2) -> v1));
        List fields = (List)param.get("data");
        for (Map field : fields) {
            String fieldkey = String.valueOf(field.get("number"));
            String type = String.valueOf(field.get("type"));
            Boolean isDelete = (Boolean)field.get("delete");
            if ("BasedataPropField".equals(type) || "MulBasedataField".equals(type) || "AttachmentPanelAp".equals(type) || "DateTimeField".equals(type)) continue;
            DynamicObject paramDB = paramMap.get(fieldkey);
            if (paramDB == null && !isDelete.booleanValue()) {
                DynamicObject newEntry = params.addNew();
                newEntry.set("fieldkey", (Object)fieldkey);
                newEntry.set("seq", (Object)params.size());
                newEntry.set("isentrysyspreset", (Object)"0");
            }
            if (paramDB == null || !isDelete.booleanValue()) continue;
            params.remove((Object)paramDB);
        }
        try (TXHandle handle = TX.requiresNew();){
            collaSerHelper.saveOne(collaDy);
            setIds.add(collaDy.getLong("id"));
            result.put(collaSerHelper.getEntityName(), setIds);
        }
    }

    public Map<String, Object> syncAdjSalaryExtField(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        this.dealAdjSalSynField(params, data);
        result.put(KEY_SUCCESS, Boolean.TRUE);
        result.put("data", data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealAdjSalSynField(Map<String, Object> params, Map<String, Object> result) {
        String bizEntityNumber = String.valueOf(params.get("bizEntityNumber"));
        List fields = (List)params.get("data");
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return;
        }
        SWCDataServiceHelper fieldGroupHelper = new SWCDataServiceHelper("hcdm_salaryadjfieldgrp");
        QFilter filter = new QFilter("number", "=", (Object)bizEntityNumber);
        DynamicObject fieldGroup = fieldGroupHelper.queryOne("id", filter.toArray());
        if (fieldGroup == null) {
            return;
        }
        ArrayList<String> deleteField = new ArrayList<String>(fields.size());
        HashMap<String, String> nameOfFieldKey = new HashMap<String, String>(fields.size());
        String nameOfNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"DecAdjInfoServiceHelper_0", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        String nameOfName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"DecAdjInfoServiceHelper_1", (String)SWC_HCDM_BUSINESS, (Object[])new Object[0]);
        for (Map field : fields) {
            String fieldKey = MapUtils.getString((Map)field, (Object)"number");
            DynamicObject[] type = MapUtils.getString((Map)field, (Object)"type");
            boolean isDelete = MapUtils.getBooleanValue((Map)field, (Object)"delete", (boolean)false);
            if (isDelete) {
                if ("BasedataPropField".equals(type)) {
                    deleteField.add(fieldKey + ".number");
                    deleteField.add(fieldKey + ".name");
                    continue;
                }
                deleteField.add(fieldKey);
                continue;
            }
            String name = MapUtils.getString((Map)field, (Object)"name");
            if ("BasedataPropField".equals(type)) {
                nameOfFieldKey.put(fieldKey + ".number", name + "." + nameOfNumber);
                nameOfFieldKey.put(fieldKey + ".name", name + "." + nameOfName);
                continue;
            }
            nameOfFieldKey.put(fieldKey, name);
        }
        SWCDataServiceHelper fieldHelper = new SWCDataServiceHelper("hcdm_salaryadjfield");
        filter = new QFilter("group", "=", (Object)fieldGroup.getLong("id"));
        filter = filter.and("number", "in", nameOfFieldKey.keySet());
        DynamicObject[] existFields = fieldHelper.query("id,number,name", filter.toArray());
        ArrayList<DynamicObject> updateFields = new ArrayList<DynamicObject>(existFields.length);
        for (DynamicObject existField : existFields) {
            String number = existField.getString("number");
            String string = (String)nameOfFieldKey.remove(number);
            if (string == null) continue;
            existField.set("name", (Object)string);
            updateFields.add(existField);
        }
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        ArrayList<DynamicObject> insertFields = new ArrayList<DynamicObject>(nameOfFieldKey.size());
        for (Map.Entry entry : nameOfFieldKey.entrySet()) {
            DynamicObject insertField = fieldHelper.generateEmptyDynamicObject();
            insertFields.add(insertField);
            insertField.set("group", (Object)fieldGroup);
            insertField.set("number", entry.getKey());
            insertField.set("name", entry.getValue());
            insertField.set("status", (Object)"C");
            insertField.set("enable", (Object)"1");
            insertField.set("creator", (Object)userId);
            insertField.set("modifier", (Object)userId);
            insertField.set("createtime", (Object)now);
            insertField.set("modifytime", (Object)now);
        }
        try (TXHandle handle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty(deleteField)) {
                filter = new QFilter("group", "=", (Object)fieldGroup.getLong("id"));
                Object[] objectArray = fieldHelper.query("id", (filter = filter.and("number", "in", deleteField)).toArray());
                if (ArrayUtils.isEmpty((Object[])objectArray)) {
                    fieldHelper.deleteByFilter(filter.toArray());
                }
            }
            if (!CollectionUtils.isEmpty(updateFields)) {
                fieldHelper.save(updateFields.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(insertFields)) {
                fieldHelper.save(insertFields.toArray(new DynamicObject[0]));
            }
        }
    }
}

