/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncFacade;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class SalaryAdjFileDelHelper {
    private static final Log logger = LogFactory.getLog(SalaryAdjFileDelHelper.class);
    private static final AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);

    public static boolean delSalaryAdjInfo(List<Object> idList) {
        boolean flag = true;
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
        String event = adjFileApplicationService.beginEvent(SalaryAdjFileDelHelper.getEventTypeCode());
        Long eventPkId = adjFileApplicationService.genEventDyn(event, eventDynList, SalaryAdjFileDelHelper.getEventTypeCode(), "0");
        DynamicObject[] revisionData = SalaryAdjFileDelHelper.getRevisionData(idList);
        if (SWCObjectUtils.isEmpty((Object)revisionData)) {
            return false;
        }
        ArrayList updateRecordDataList = Lists.newArrayListWithExpectedSize((int)10);
        CloneUtils cloneUtils = new CloneUtils(false, true);
        for (DynamicObject dynamicObject : revisionData) {
            DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)dynamicObject);
            clone.set("enable", (Object)"0");
            updateRecordDataList.add(clone);
        }
        try (TXHandle required = TX.requiresNew();){
            if (!CollectionUtils.isEmpty(eventDynList)) {
                adjFileApplicationService.getAdjFileDomainService().saveDecAdjEvent(eventDynList);
            }
            BaseDataHisHelper.saveTimeVersion((DynamicObject[])updateRecordDataList.toArray(new DynamicObject[0]), (boolean)true, (Long)eventPkId);
            logger.info("begain generateSyncDataFromRec");
            SalaryAdjSyncFacade.generateSyncDataFromRec(eventPkId, updateRecordDataList, null);
        }
        adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
        try {
            if (flag) {
                for (DynamicObject revisionDataObj : revisionData) {
                    revisionDataObj.set("datastatus", (Object)"-4");
                }
                recordHelper.save(revisionData);
                logger.error("SalaryAdjFileDelHelper update datastatus success!");
            }
        }
        catch (Exception exception) {
            logger.error("SalaryAdjFileDelHelper update datastatus fail, exception is :", (Throwable)exception);
            throw exception;
        }
        return flag;
    }

    public static DynamicObject[] getRevisionData(List<Object> idList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hcdm_salaryadjrecord");
        return helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", idList)});
    }

    public static String getEventTypeCode() {
        return EventTypeEnum.SALARYADJRECORD_REVISION_DEL.getCode();
    }

    public static DynamicObject[] getSalaryAdjRecord(List<Object> idList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        return helper.query("id, datastatus, standarditem.id , boid, enable", new QFilter[]{new QFilter("id", "in", idList)});
    }
}

