/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.salarystandardscm.SalaryStandardScmHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SalaryAdjFileHelper {
    public static Map<Long, Set<Long>> getStdscmAllIdsBySalaryStructureIdsNoPerm(Set<Long> salaryStructureIds) {
        Map<Long, List<DynamicObject>> stdScmtMap = SalaryStandardScmHelper.queryAllStdScmByStructureIds(salaryStructureIds);
        if (CollectionUtils.isEmpty(stdScmtMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)stdScmtMap.size());
        stdScmtMap.forEach((key, value) -> {
            for (DynamicObject dy : value) {
                ids.add(dy.getLong("id"));
            }
        });
        return SalaryAdjFileHelper.getResult(ids, stdScmtMap);
    }

    public static Map<Long, Set<Long>> getStdscmIdsBySalaryStructureIdsNoPerm(Set<Long> salaryStructureIds) {
        Map<Long, List<DynamicObject>> stdScmtMap = SalaryStandardScmHelper.queryStdScmMapWithNoStatusByStructureIds(salaryStructureIds);
        if (CollectionUtils.isEmpty(stdScmtMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)stdScmtMap.size());
        stdScmtMap.forEach((key, value) -> {
            for (DynamicObject dy : value) {
                ids.add(dy.getLong("id"));
            }
        });
        return SalaryAdjFileHelper.getResult(ids, stdScmtMap);
    }

    public static Map<Long, Set<Long>> getStdscmIdsBySalaryStructureIds(Set<Long> salaryStructureIds) {
        Set stdScmSetByPermItem = SWCPermissionServiceHelper.getStdScmSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac");
        return SalaryAdjFileHelper.matchStdscmIdsByStructureId(stdScmSetByPermItem, salaryStructureIds);
    }

    public static Map<Long, Set<Long>> getStdscmIdsBySalaryStructureIdsOfCand(Set<Long> salaryStructureIds) {
        Set stdScmSetByPermItem = SWCPermissionServiceHelper.getStdScmSetByPermItem((String)"0VO5EV13=I9W", (String)"hcdm_singlecandsetsalappl", (String)"47150e89000000ac");
        return SalaryAdjFileHelper.matchStdscmIdsByStructureId(stdScmSetByPermItem, salaryStructureIds);
    }

    private static Map<Long, Set<Long>> matchStdscmIdsByStructureId(Set<Long> stdScmSetByPermItem, Set<Long> salaryStructureIds) {
        Map<Long, List<DynamicObject>> stdScmtMap = SalaryStandardScmHelper.queryStdScmMapByStructureIds(salaryStructureIds);
        if (CollectionUtils.isEmpty(stdScmtMap)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashSet ids = Sets.newHashSetWithExpectedSize((int)stdScmtMap.size());
        stdScmtMap.forEach((key, value) -> {
            for (DynamicObject dy : value) {
                ids.add(dy.getLong("id"));
            }
        });
        if (null == stdScmSetByPermItem) {
            return SalaryAdjFileHelper.getResult(ids, stdScmtMap);
        }
        Sets.SetView intersectionIds = Sets.intersection(stdScmSetByPermItem, (Set)ids);
        return SalaryAdjFileHelper.getResult((Set<Long>)intersectionIds, stdScmtMap);
    }

    private static Map<Long, Set<Long>> getResult(Set<Long> intersectionIds, Map<Long, List<DynamicObject>> stdScmtMap) {
        if (CollectionUtils.isEmpty(intersectionIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)intersectionIds.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : stdScmtMap.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            for (DynamicObject dynamicObject : value) {
                if (!intersectionIds.contains(dynamicObject.getLong("id"))) continue;
                Set ids = result.computeIfAbsent(entry.getKey(), key -> new HashSet(16));
                ids.add(dynamicObject.getLong("id"));
            }
        }
        return result;
    }

    public static Long changeSalaryStructure(long salaryStructureId) {
        if (0L != salaryStructureId) {
            Map<Long, Set<Long>> map = SalaryAdjFileHelper.getStdscmIdsBySalaryStructureIds(Sets.newHashSet((Object[])new Long[]{salaryStructureId}));
            return map == null || map.get(salaryStructureId) == null || map.get(salaryStructureId).size() != 1 ? null : map.get(salaryStructureId).iterator().next();
        }
        return null;
    }

    public static boolean isCover(DynamicObject dy, DynamicObject dynamicObject) {
        Date oldBsed = dynamicObject.getDate("bsed");
        Date maxLoseEffectDate = SWCBaseUtils.getMaxLoseEffectDate();
        Date oldBsled = dynamicObject.getDate("bsled") == null ? maxLoseEffectDate : dynamicObject.getDate("bsled");
        Date newBsed = dy.getDate("bsed");
        Date newBsled = dy.getDate("bsled");
        return SWCDateTimeUtils.isDateRangeOverlap((Date)newBsed, (Date)newBsled, (Date)oldBsed, (Date)oldBsled);
    }
}

