/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile.dao;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class DecideAdjSalaryServiceHelper {
    public static DynamicObject[] queryInitInfoBySalaryAdjFile(Set<Long> salaryFileIds) {
        SWCDataServiceHelper salHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        QFilter fileFilter = new QFilter("salaryadjfile.id", "in", salaryFileIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)CommonHcdmBizHelper.VALIDATE_DATA_STATUS);
        QFilter enableFilter = new QFilter("enable", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter voFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return salHelper.query("id,salaryadjfile.number,datasource,salaryadjfile.id,standarditem,standarditem.id,standarditem.name,bsed,bsled", new QFilter[]{fileFilter, dataStatusFilter, enableFilter, voFilter});
    }

    public static Map<String, List<DynamicObject>> queryInitInfoByDimensionNumber(Set<String> empnumbers, Set<Long> orgIds, Set<Long> countryIds, Set<String> stdscmIds) {
        SWCDataServiceHelper salHelper1 = new SWCDataServiceHelper("hcdm_decadjrelperson");
        QFilter empnumberFilter = new QFilter("empnumber", "in", empnumbers);
        QFilter orgFilter = new QFilter("org.id", "in", orgIds);
        QFilter countryFilter = new QFilter("country.id", "in", countryIds);
        QFilter stdscmFilter = new QFilter("stdscm.number", "in", stdscmIds);
        Object[] relPersons = salHelper1.query("stdscm.number,country.id,org.id,empnumber,id", new QFilter[]{empnumberFilter, orgFilter, countryFilter, stdscmFilter});
        if (ArrayUtils.isEmpty((Object[])relPersons)) {
            return null;
        }
        Map<Long, DynamicObject> relPersonMap = Arrays.stream(relPersons).collect(Collectors.toMap(object -> object.getLong("id"), e1 -> e1));
        HashMap result = Maps.newHashMapWithExpectedSize((int)relPersonMap.size());
        SWCDataServiceHelper salHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        QFilter relpersonidFilter = new QFilter("relpersonid", "in", relPersonMap.keySet());
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)CommonHcdmBizHelper.VALIDATE_DATA_STATUS);
        QFilter enableFilter = new QFilter("enable", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter voFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObject[] dys = salHelper.query("id,datasource,relpersonid,standarditem,standarditem.id,standarditem.name,bsed,bsled", new QFilter[]{relpersonidFilter, dataStatusFilter, enableFilter, voFilter});
        Map<Long, List<DynamicObject>> listMap = Arrays.stream(dys).collect(Collectors.groupingBy(e1 -> e1.getLong("relpersonid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : listMap.entrySet()) {
            Long key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            DynamicObject relPerson = relPersonMap.get(key);
            StringBuilder bu = new StringBuilder();
            String empnumber = relPerson.getString("empnumber");
            bu.append(empnumber);
            long orgId = relPerson.getLong("org.id");
            bu.append(orgId);
            long countryId = relPerson.getLong("country.id");
            bu.append(countryId);
            String stdscmNumber = relPerson.getString("stdscm.number");
            bu.append(stdscmNumber);
            List list = result.computeIfAbsent(bu.toString(), k1 -> Lists.newArrayListWithExpectedSize((int)16));
            list.addAll(value);
        }
        return result;
    }
}

