/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile.dao;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapprbill.enums.YesOrNoEnum;
import kd.swc.hcdm.common.entity.adjapprbill.AdjFileApprBillMapping;
import kd.swc.hcdm.common.entity.adjfile.AdjFileInfo;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SalaryAdjFileServiceHelper {
    private static Log logger = LogFactory.getLog(SalaryAdjFileServiceHelper.class);

    private SalaryAdjFileServiceHelper() {
    }

    public static String getAdjFileStatuByFileId(String fileId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject file = helper.queryOriginalOne("status", (Object)SalaryAdjFileServiceHelper.idStringToLong(fileId));
        if (file == null) {
            return "";
        }
        return file.getString("status");
    }

    public static DynamicObject queryAdjFileInfoByFileId(Long fileId) {
        HashSet adjFileIdSet = Sets.newHashSet((Object[])new Long[]{fileId});
        DynamicObject[] fileInfos = SalaryAdjFileServiceHelper.queryAdjFileInfoByFileId(adjFileIdSet);
        return fileInfos != null && fileInfos.length > 0 ? fileInfos[0] : null;
    }

    public static DynamicObject[] queryAdjFileInfoByFileId(Set<Long> adjFileIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", adjFileIdSet)};
        String selectProperties = "id, boid,number, datastatus, stdscm.id, stdscm.sourcevid, person, employee, isprimary, status, type, empposorgrel, depemp, job, biznumber,org,country,empgroup,joblevel,jobgrade,position, salaystructure.id, depcytype.id, adminorg.id, assoadminorg.id, empposorgrel.company";
        return helper.query(selectProperties, qFilters);
    }

    public static String queryIdByFileId(SalaryAdjFilePartEnum salaryAdjFilePartEnum, String fileId, Object isHistoryPage) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(salaryAdjFilePartEnum.getEntityId());
        QFilter[] filters = null;
        if (ObjectUtils.isEmpty((Object)isHistoryPage)) {
            QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
            filters = new QFilter[]{new QFilter("salaryadjfile", "=", (Object)SalaryAdjFileServiceHelper.idStringToLong(fileId)), currFilter};
        } else {
            filters = new QFilter[]{new QFilter("salaryadjfilevid", "=", (Object)SalaryAdjFileServiceHelper.idStringToLong(fileId))};
        }
        DynamicObject queryOriginalOne = helper.queryOriginalOne("id", filters);
        if (queryOriginalOne == null) {
            return null;
        }
        return queryOriginalOne.getString("id");
    }

    public static DynamicObject[] queryJobByPersonalEmpposorgrel(Collection<Long> depempIds, boolean isCurrentVersion) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter personFilter = new QFilter("depemp.id", "in", depempIds);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)isCurrentVersion);
        QFilter[] filters = new QFilter[]{personFilter, isCurrentVersionFilter};
        String selectString = "id,number,depemp,workplace,person,person.name,person.number,person.id,isprimary,employee,employee.empnumber,job,position,postype,company,adminorg,startdate,enddate,datastatus";
        return helper.query(selectString, filters, "startdate desc");
    }

    public static DynamicObject[] queryJobByPersonalEmpposorgrel(Set<Long> depempIdSet, Set<String> numberSet, boolean isCurrentVersion) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter personFilter = new QFilter("employee.id", "in", depempIdSet);
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)isCurrentVersion);
        QFilter[] filters = new QFilter[]{personFilter, numberFilter, isCurrentVersionFilter};
        return helper.query("id,job,depemp,employee,number,person,isprimary,adminorg,workplace,startdate,enddate,position,datastatus", filters, "startdate asc");
    }

    public static DynamicObject[] queryJobByPersonalEmpposorgrel(long depempId, String number, boolean isCurrentVersion) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter personFilter = new QFilter("depemp.id", "=", (Object)depempId);
        QFilter numberFilter = new QFilter("depemp.number", "=", (Object)number);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)isCurrentVersion);
        QFilter[] filters = new QFilter[]{personFilter, numberFilter, isCurrentVersionFilter};
        return helper.query("id,job,depemp,workplace,adminorg,employee,number,person,isprimary,position,startdate,datastatus", filters, "startdate desc");
    }

    public static DynamicObject[] queryPartDataByFileIds(String entityId, Set<Long> fileIdSet) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
        QFilter[] filters = new QFilter[]{new QFilter("salaryadjfile", "in", fileIdSet), currFilter};
        return serviceHelper.loadDynamicObjectArray(filters);
    }

    public static DynamicObject queryFileDataByFileId(String selectFields, long fileId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(SalaryAdjFilePartEnum.baseInfo.getEntityId());
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)fileId)};
        return serviceHelper.queryOne(selectFields, filters);
    }

    public static Map<String, Object> getPernontsprop(Long personId, String[] NATIONALITY_FIELDS) {
        SWCDataServiceHelper pernontspropHelper = new SWCDataServiceHelper("hrpi_pernontsprop");
        DynamicObject prop = pernontspropHelper.queryOne("nationality.id,gender.name", new QFilter[]{new QFilter("person", "=", (Object)personId)});
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (prop != null) {
            objectMap.put("GENDER", prop.getString("gender.name"));
            long nationalityId = prop.getLong("nationality.id");
            if (nationalityId != 0L) {
                SWCDataServiceHelper nationalityHelper = new SWCDataServiceHelper("hbss_nationality");
                DynamicObject nationality = nationalityHelper.queryOne("name,logo", new QFilter[]{new QFilter("id", "=", (Object)nationalityId)});
                if (nationality != null) {
                    objectMap.put("COUNTRYNAME", nationality.getString("name"));
                    objectMap.put("COUNTRYLOGO", nationality.getString("logo"));
                }
            }
        }
        return objectMap;
    }

    public static DynamicObject getPercontactDyobj(Long personId) {
        if (personId == null) {
            return null;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_percontact");
        String selectProperties = "phone, peremail";
        QFilter filter = new QFilter("person.id", "=", (Object)SalaryAdjFileServiceHelper.idStringToLong(personId.toString()));
        return serviceHelper.queryOne(selectProperties, new QFilter[]{filter});
    }

    public static boolean isExistAdjFile(AdjFileInfo data) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter personFilter = new QFilter("depemp.id", "=", (Object)data.getPersonId());
        QFilter countryFilter = new QFilter("country.id", "=", (Object)data.getCountryId());
        QFilter orgFilter = new QFilter("org.id", "=", (Object)data.getOrgId());
        QFilter scmFilter = new QFilter("stdscm.id", "=", (Object)data.getStdscmId());
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter bsledFilter = new QFilter("bsled", "=", (Object)SWCDateTimeUtils.getMaxBsled());
        BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
        QFilter[] qFilters = new QFilter[]{statusFilter, orgFilter, countryFilter, personFilter, scmFilter, enableFilter, bsledFilter};
        return helper.isExists(qFilters);
    }

    public static String getAdjFilePersonName(Long pkId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        DynamicObject queryOne = helper.queryOne("person.name", (Object)pkId);
        return queryOne.getString("person.name");
    }

    public static QFilter getEmpGroupFilter(String selectFields) {
        List empgoupIds = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcdm");
        if (CollectionUtils.isNotEmpty((Collection)empgoupIds)) {
            return new QFilter(selectFields, "in", (Object)empgoupIds);
        }
        return null;
    }

    public static List<Long> queryEmpGroup() {
        return SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hcdm");
    }

    public static Long idStringToLong(String stringId) {
        Long id = 0L;
        if (SWCStringUtils.isNotEmpty((String)stringId)) {
            id = Long.valueOf(stringId);
        }
        return id;
    }

    public static Map<String, Map<Long, String>> buildAdjFileRelateLog(Set<Long> fileIds, String opName) {
        if (CollectionUtils.isEmpty(fileIds)) {
            return Collections.emptyMap();
        }
        Map<Long, List<AdjFileApprBillMapping>> apprBillRelateMap = SalaryAdjFileServiceHelper.queryApprBillRelate(fileIds);
        Map<Long, List<DynamicObject>> adjSalSynRelateMap = SalaryAdjFileServiceHelper.queryAdjSalSynRelate(fileIds);
        String adjFileApprBillRelate = ResManager.loadKDString((String)"\u5df2\u88ab\u5458\u5de5\u5b9a\u8c03\u85aa\u7533\u8bf7\u5355%1$s\u5f15\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c%2$s\u3002", (String)"SalaryAdjFileServiceHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String adjSalSynRelate = ResManager.loadKDString((String)"\u5df2\u88ab\u5b9a\u8c03\u85aa\u6570\u636e\u540c\u6b65%1$s\u5f15\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c%2$s\u3002", (String)"SalaryAdjFileServiceHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        HashMap relateLogMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap apprBillRelateLogMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        HashMap adjSalSynRelateLogMap = Maps.newHashMapWithExpectedSize((int)fileIds.size());
        for (Long fileId : fileIds) {
            List<DynamicObject> adjSalSynRelateList;
            List<AdjFileApprBillMapping> adjFileApprBillMappings = apprBillRelateMap.get(fileId);
            if (CollectionUtils.isNotEmpty(adjFileApprBillMappings)) {
                Set billNoSet = adjFileApprBillMappings.stream().map(AdjFileApprBillMapping::getBillNo).collect(Collectors.toSet());
                apprBillRelateLogMap.put(fileId, String.format(adjFileApprBillRelate, String.join((CharSequence)"\u3001", billNoSet), opName));
            }
            if (!CollectionUtils.isNotEmpty(adjSalSynRelateList = adjSalSynRelateMap.get(fileId))) continue;
            Set batchNumberSet = adjSalSynRelateList.stream().map(object -> object.getString("batchnumber")).collect(Collectors.toSet());
            adjSalSynRelateLogMap.put(fileId, String.format(adjSalSynRelate, String.join((CharSequence)"\u3001", batchNumberSet), opName));
        }
        relateLogMap.put("apprBillRelateLog", apprBillRelateLogMap);
        relateLogMap.put("adjSalSynRelateLog", adjSalSynRelateLogMap);
        return relateLogMap;
    }

    private static Map<Long, List<AdjFileApprBillMapping>> queryApprBillRelate(Set<Long> fileIds) {
        ArrayList billStatusList = Lists.newArrayList((Object[])new String[]{"A", "B", "D", "G"});
        String sql = "SELECT T1.fadjfileid, T2.fbillno FROM t_hcdm_adjapprper T1\nLEFT JOIN t_hcdm_adjapprbill T2 ON T1.fadjapprbillid = T2.fid\n WHERE T2.fbillstatus IN " + HCDMDbHelper.getFidHolder(billStatusList.size()) + " AND T1.fadjfileid IN " + HCDMDbHelper.getFidHolder(fileIds.size());
        Object[] params = ArrayUtils.addAll((Object[])billStatusList.toArray(), (Object[])fileIds.toArray());
        DataSet dataSet = HCDMDbHelper.queryDataSet(sql, params);
        String sql1 = "SELECT T1.fadjfileid, T2.fbillno FROM t_hcdm_adjapprper T1\nLEFT JOIN t_hcdm_adjconfirmperson T3 ON T3.fadjfileid = T1.fadjfileid\nLEFT JOIN t_hcdm_adjapprbill T2 ON T3.fadjapprovalbillid = T2.fid\nWHERE T2.fbillstatus = 'C' AND T3.fconfirmstatus = '0' AND T1.fadjfileid IN " + HCDMDbHelper.getFidHolder(fileIds.size());
        DataSet dataSet1 = HCDMDbHelper.queryDataSet(sql1, fileIds.toArray());
        DataSet resultDataSet = dataSet.union(dataSet1);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            AdjFileApprBillMapping mapping = new AdjFileApprBillMapping();
            Long adjFileId = row.getLong(0);
            String billNo = row.getString(1);
            mapping.setAdjFileId(adjFileId);
            mapping.setBillNo(billNo);
            resultList.add(mapping);
        }
        dataSet.close();
        return resultList.stream().collect(Collectors.groupingBy(AdjFileApprBillMapping::getAdjFileId));
    }

    private static Map<Long, List<DynamicObject>> queryAdjSalSynRelate(Set<Long> fileIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
        QFilter filter = new QFilter("adjfile", "in", fileIds);
        filter.and(new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "1"})));
        DynamicObject[] dataEntities = serviceHelper.query("id, adjfile.id, batchnumber", new QFilter[]{filter});
        return Arrays.stream(dataEntities).collect(Collectors.groupingBy(o1 -> o1.getLong("adjfile.id")));
    }

    public static void allSyncUpdateAdjFileStatus() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5168\u91cf\u540c\u6b65\u66f4\u65b0\u6863\u6848\u5386\u53f2\u72b6\u6001\u5347\u7ea7...");
        long startTime = System.currentTimeMillis();
        DynamicObject[] dataEntities = SalaryAdjFileServiceHelper.queryUpdateAdjFileStatusData();
        TXHandle txHandle = TX.required();
        try {
            if (dataEntities.length != 0) {
                SalaryAdjFileServiceHelper.syncUpdateAdjFileStatus(dataEntities);
            }
        }
        catch (Exception e) {
            txHandle.markRollback();
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
        }
        finally {
            txHandle.close();
            long endTime = System.currentTimeMillis();
            logger.info("\u5168\u91cf\u540c\u6b65\u66f4\u65b0\u6863\u6848\u5386\u53f2\u72b6\u6001\u5347\u7ea7\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a{}\uff08ms\uff09", (Object)(endTime - startTime));
        }
    }

    public static void syncUpdateAdjFileStatus(DynamicObject[] dataEntities) {
        SalaryAdjFilePartEnum[] values;
        Set<Long> fileIds = Arrays.stream(dataEntities).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
        for (SalaryAdjFilePartEnum salaryAdjFilePartEnum : values = SalaryAdjFilePartEnum.values()) {
            Set<Long> partIds;
            if (salaryAdjFilePartEnum == SalaryAdjFilePartEnum.baseInfo) {
                SalaryAdjFileServiceHelper.syncUpdateAdjFileStatus("hcdm_adjfileinfo", fileIds);
                continue;
            }
            String entityId = salaryAdjFilePartEnum.getEntityId();
            DynamicObject[] partDatas = SalaryAdjFileServiceHelper.queryPartDataByFileIds(entityId, fileIds);
            if (partDatas == null || partDatas.length == 0 || !CollectionUtils.isNotEmpty(partIds = Arrays.stream(partDatas).map(o1 -> o1.getLong("id")).collect(Collectors.toSet()))) continue;
            SalaryAdjFileServiceHelper.syncUpdateAdjFileStatus(entityId, partIds);
        }
    }

    public static void syncUpdateAdjFileStatus(String entityName, Set<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "in", ids);
        String selectProperties = "id, datastatus, status, enable, sourcevid, iscurrentversion ";
        DynamicObject[] dyobjs = helper.query(selectProperties, new QFilter[]{qFilter});
        Map<Long, Long> sourcevidMap = Arrays.stream(dyobjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1.getLong("sourcevid")));
        SalaryAdjFileServiceHelper.updateCurrentDataStatus(entityName, sourcevidMap);
    }

    public static void updateCurrentDataStatus(String entityName, Map<Long, Long> datas) {
        if (MapUtils.isEmpty(datas)) {
            return;
        }
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        Collection<Long> sourcevids = datas.values();
        Set<Long> ids = datas.keySet();
        idSet.addAll(sourcevids);
        idSet.addAll(ids);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter qFilter = new QFilter("id", "in", (Object)idSet);
        String selectProperties = "id, status, datastatus, enable, masterid, fnumber";
        DynamicObject[] dyobjs = helper.query(selectProperties, new QFilter[]{qFilter});
        Map<Long, DynamicObject> dyobjMap = Arrays.stream(dyobjs).collect(Collectors.toMap(o1 -> o1.getLong("id"), o1 -> o1));
        DynamicObjectCollection coll = new DynamicObjectCollection();
        for (Map.Entry<Long, Long> data : datas.entrySet()) {
            Long id = data.getKey();
            Long sourcevid = data.getValue();
            DynamicObject versiondyobj = dyobjMap.get(sourcevid);
            if (versiondyobj == null) continue;
            DynamicObject dyn = dyobjMap.get(id);
            String dataStatus = versiondyobj.getString("datastatus");
            String enable = versiondyobj.getString("enable");
            String status = versiondyobj.getString("status");
            if (dataStatus.equals("-1")) {
                dyn.set("status", (Object)"E");
            } else if (enable.equals("0") && dataStatus.equals("1")) {
                dyn.set("status", (Object)"D");
            } else if (dyn.getString("status").equals("D") && dataStatus.equals("1") && enable.equals("1")) {
                dyn.set("status", (Object)"C");
            }
            coll.add((Object)dyn);
        }
        helper.save(coll);
    }

    public static Set<Long> queryEntityBOID(String entityNumber, Set<Long> fileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        QFilter qFilter = new QFilter("salaryadjfile", "in", fileIds);
        DynamicObject[] decideSalaryDyObjs = helper.query("boid", new QFilter[]{qFilter});
        return Arrays.stream(decideSalaryDyObjs).map(o1 -> o1.getLong("boid")).collect(Collectors.toSet());
    }

    public static DynamicObject[] queryUpdateAdjFileStatusData() {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        String selectProperties = "id,datastatus,enable,boid";
        QFilter filter = new QFilter("datastatus", "in", (Object)"1");
        QFilter f0 = new QFilter("enable", "=", (Object)"0");
        QFilter f1 = new QFilter("status", "=", (Object)"D");
        filter.and(f0.or(f1));
        filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter};
        return serviceHelper.query(selectProperties, filters);
    }

    public static void enableToHis(String entityNumber, Set<Long> boIds, Date newDate, boolean disabled) {
        logger.info("\u8c03\u7528\u4e2d\u53f0\u7981\u7528\u63a5\u53e3 entityNumber = {}, boIds = {} , newDate ={} , disabled = {}", new Object[]{entityNumber, JSON.toJSONString(boIds), SWCDateTimeUtils.format((Date)newDate), disabled});
        long startTime = System.currentTimeMillis();
        HisModelController hisModelController = new HisModelController();
        HisEnableParamBo hisEnableParamBo = SalaryAdjFileServiceHelper.getHisEnableParamBo(entityNumber, boIds, newDate, disabled);
        hisModelController.disableOrEnableBo(hisEnableParamBo);
        long endTime = System.currentTimeMillis();
        logger.info("\u8c03\u7528\u4e2d\u53f0\u7981\u7528\u63a5\u53e3 entityNumber = {} \u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a {} ms", (Object)entityNumber, (Object)(endTime - startTime));
    }

    private static HisEnableParamBo getHisEnableParamBo(String entityNumber, Set<Long> boIds, Date newDate, boolean disabled) {
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        ArrayList boIdList = Lists.newArrayList(boIds);
        hisBaseBo.setBoIdList((List)boIdList);
        hisEnableParamBo.setHisBaseBo(hisBaseBo);
        hisEnableParamBo.setDisabled(disabled);
        hisEnableParamBo.setEffectDate(newDate);
        return hisEnableParamBo;
    }

    public static void enableToHis(String entityNumber, Set<Long> boIds, Date newDate, boolean disabled, Long eventPkId) {
        HisModelController hisModelController = new HisModelController();
        HisEnableParamBo hisEnableParamBo = SalaryAdjFileServiceHelper.getHisEnableParamBo(entityNumber, boIds, newDate, disabled);
        hisEnableParamBo.setEventId(eventPkId);
        hisModelController.disableOrEnableBo(hisEnableParamBo);
    }

    public static DynamicObject[] queryFileDataByDepempId(String selectFields, Set<Long> depempId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter personFilter = new QFilter("depemp.id", "in", depempId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{personFilter, enableFilter};
        DynamicObject[] dys = helper.query(selectFields, qFilters);
        if (null == dys || dys.length == 0) {
            return new DynamicObject[0];
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(dys).collect(Collectors.groupingBy(e1 -> e1.getLong("boid")));
        Set boidSet = Arrays.stream(dys).filter(object -> object.getBoolean("iscurrentversion") && object.getString("status").equals("E")).map(object -> object.getLong("boid")).collect(Collectors.toSet());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dys.length);
        map.forEach((key, list) -> {
            if (!boidSet.contains(key)) {
                for (DynamicObject dynamicObject : list) {
                    if (dynamicObject.getString("datastatus").equals("-2") || dynamicObject.getString("datastatus").equals("-1")) continue;
                    result.add(dynamicObject);
                }
            }
        });
        return result.toArray(new DynamicObject[result.size()]);
    }

    public static DynamicObject[] queryDepempInfoByEmpInfo(Set<Object> empnumberSet, Set<Object> adminorgSet, Set<Object> positionSet, Set<Object> stdpositionSet, Set<Object> jobSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter empnumberFilter = new QFilter("employee.empnumber", "in", empnumberSet);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1"});
        if (!CollectionUtils.isEmpty(adminorgSet)) {
            isCurrentVersionFilter.and("adminorg.id", "in", adminorgSet);
        }
        QFilter positionFilter = SalaryAdjFileServiceHelper.getPositionFilter(jobSet, positionSet, stdpositionSet);
        return helper.query("id,job,depemp,position,stdposition,employee.empnumber,adminorg,startdate,enddate", new QFilter[]{dataStatusFilter, isCurrentVersionFilter, empnumberFilter, positionFilter}, "startdate desc");
    }

    private static QFilter getPositionFilter(Set<Object> jobSet, Set<Object> positionSet, Set<Object> stdpositionSet) {
        if (!CollectionUtils.isEmpty(jobSet)) {
            return new QFilter("job.id", "in", jobSet);
        }
        if (!CollectionUtils.isEmpty(positionSet)) {
            return new QFilter("position.id", "in", positionSet);
        }
        if (!CollectionUtils.isEmpty(stdpositionSet)) {
            return new QFilter("stdposition.id", "in", stdpositionSet);
        }
        return new QFilter("1", "=", (Object)1);
    }

    public static DynamicObject[] queryDepempInfoByEmpNumber(Set<Object> empnumberSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter empnumberFilter = new QFilter("employee.empnumber", "in", empnumberSet);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1"});
        return helper.query("boid,id,job,depemp,startdate,enddate,isprimary,employee.empnumber", new QFilter[]{empnumberFilter, dataStatusFilter, isCurrentVersionFilter}, "startdate desc");
    }

    public static DynamicObject[] queryAdjFileByNumber(Set<Object> numberSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        numberFilter.and("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode());
        return helper.query("country,org,stdscm,salaystructure,adminorg,empgroup,status,number,employee.empnumber,assoadminorg", new QFilter[]{numberFilter});
    }

    public static DynamicObject[] getAdjFileByDataRule(HasPermOrgResult permOrgResult) {
        List dataRuleQFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!permOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            qFilters.add(new QFilter("org", "in", (Object)hasPermOrgs));
        }
        if (CollectionUtils.isEmpty((Collection)(dataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hcdm_adjfileinfo", (String)"47150e89000000ac")))) {
            return null;
        }
        qFilters.addAll(dataRuleQFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjfileinfo");
        return helper.query("id,number", qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] getSalaryItemByOrg(HasPermOrgResult permOrgResult) {
        List<QFilter> qFilters = SalaryAdjFileServiceHelper.getBaseOrgFilters(permOrgResult, "hsbs_standarditem");
        List dataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hsbs_standarditem", (String)"47150e89000000ac");
        if (CollectionUtils.isEmpty((Collection)dataRuleQFilter)) {
            return null;
        }
        qFilters.addAll(dataRuleQFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_standarditem");
        return helper.query("id", qFilters.toArray(new QFilter[0]));
    }

    public static List<QFilter> getBaseOrgFilters(HasPermOrgResult permOrgResult, String entityName) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!permOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)entityName, (List)hasPermOrgs, (boolean)true);
            qFilters.add(baseDataFilter);
        }
        return qFilters;
    }

    public static DynamicObject[] getSalaryAdjustrsnByOrg(HasPermOrgResult permOrgResult) {
        List<QFilter> qFilters = SalaryAdjFileServiceHelper.getBaseOrgFilters(permOrgResult, "hsbs_salaryadjustrsn");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryadjustrsn");
        return helper.query("id", qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] getSalayStructureByPermItem(HasPermOrgResult permOrgResult) {
        List<QFilter> qFilters = SalaryAdjFileServiceHelper.getBaseOrgFilters(permOrgResult, "hcdm_salaystructure");
        List dataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)"hcdm_salaystructure", (String)"47150e89000000ac");
        if (CollectionUtils.isEmpty((Collection)dataRuleQFilter)) {
            return null;
        }
        qFilters.addAll(dataRuleQFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salaystructure");
        return helper.query("id", qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] queryEmployeeByempNum(Set<String> empNumberSet) {
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hrpi_employee");
        QFilter numberFilter = new QFilter("empnumber", "in", empNumberSet);
        return empHelper.query("id,empnumber,person", new QFilter[]{numberFilter});
    }

    public static Map<Long, Long> getLastAdjFileVersionByBoId(String entityNumber, Collection<Long> pkIds) {
        DynamicObject[] objArr = new SWCDataServiceHelper(entityNumber).query("id,boid,enable,status,bsed", new QFilter[]{new QFilter("boid", "in", pkIds), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("datastatus", "in", (Object)new String[]{"0", "2", "1"}), new QFilter("iscurrentversion", "=", (Object)"0")}, "boid asc,bsed desc");
        HashMap map = Maps.newHashMapWithExpectedSize((int)pkIds.size());
        for (DynamicObject dy : objArr) {
            if (map.containsKey(dy.getLong("boid"))) continue;
            map.put(dy.getLong("boid"), dy.getLong("id"));
        }
        return map;
    }

    public static Map<Long, DynamicObject> getStandardItemMap(String selectFields, Collection<Long> ids) {
        SWCDataServiceHelper itemServiceHelper = new SWCDataServiceHelper("hsbs_standarditem");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] itemDyObjs = itemServiceHelper.query(selectFields, new QFilter[]{filter});
        return Arrays.stream(itemDyObjs).collect(Collectors.toMap(obj -> obj.getLong("id"), val -> val, (k1, k2) -> k1));
    }

    public static Set<Long> getAbandonIds(String entityNumber, Collection<Long> ids) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("id", "in", ids);
        idFilter.and("datastatus", "=", (Object)"-1");
        DynamicObject[] datas = serviceHelper.query(new QFilter[]{idFilter});
        return Arrays.stream(datas).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }
}

