/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile.sidebar;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;

public class FileSidebarService {
    private FileSidebarService() {
    }

    public static FlexPanelAp createFlexpanelAp(QFilter[] qFilters, ISWCAppCache appCache, String cacheKey, String pageKey, String panelKey) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(panelKey);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(pageKey);
        DynamicObjectCollection objects = helper.queryColl("id,datastatus,bsed,createtime,modifytime", qFilters, "bsed desc,modifytime desc");
        if (objects.size() > 0) {
            ArrayList<Long> pkList = new ArrayList<Long>(10);
            int index = -1;
            for (DynamicObject dynamicObject : objects) {
                FlexPanelAp flexPanel = new FlexPanelAp();
                flexPanel.setWidth(new LocaleString("100%"));
                flexPanel.setKey(panelKey + ++index);
                flexPanelAp.getItems().add(flexPanel);
                pkList.add(dynamicObject.getLong("id"));
            }
            appCache.put(cacheKey, pkList);
        } else {
            FileSidebarService.clearCacheByClosePage(appCache, cacheKey);
        }
        return flexPanelAp;
    }

    public static FlexPanelAp createFlexpanelApNoHis(List<Map<Date, List<DynamicObject>>> allDateVersion, ISWCAppCache appCache, String cacheKey, String pageKey, String panelKey) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(panelKey);
        if (!CollectionUtils.isEmpty(allDateVersion)) {
            ArrayList pkList = new ArrayList(10);
            for (int i = 0; i < allDateVersion.size(); ++i) {
                FlexPanelAp flexPanel = new FlexPanelAp();
                flexPanel.setWidth(new LocaleString("100%"));
                flexPanel.setKey(panelKey + i);
                Style style = new Style();
                Margin margin = new Margin();
                style.setMargin(margin);
                flexPanel.setStyle(style);
                flexPanelAp.getItems().add(flexPanel);
            }
            appCache.put(cacheKey, pkList);
        } else {
            FileSidebarService.clearCacheByClosePage(appCache, cacheKey);
        }
        return flexPanelAp;
    }

    public static void showEntryHisPage(IFormView formView, ISWCAppCache appCache, String cacheKey, String fileId, String panelKey) {
        List cachePkList = (List)appCache.get(cacheKey, List.class);
        if (null != cachePkList && cachePkList.size() > 0) {
            int size = cachePkList.size();
            for (int i = 0; i < size; ++i) {
                BaseShowParameter formShowParameter = new BaseShowParameter();
                formShowParameter.setFormId(cacheKey);
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey + i);
                formShowParameter.setPkId(cachePkList.get(i));
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.setCustomParam("fromPage", (Object)"fromHisAction");
                formShowParameter.setCustomParam("isOnlyView", (Object)"true");
                formShowParameter.setCustomParam("key_custom_param_fileid", (Object)fileId);
                formView.showForm((FormShowParameter)formShowParameter);
            }
            formView.setVisible(Boolean.FALSE, new String[]{panelKey + "empty"});
            formView.setVisible(Boolean.TRUE, new String[]{panelKey});
        } else {
            FileSidebarService.showEmptyPage(panelKey + "empty", formView);
            formView.setVisible(Boolean.FALSE, new String[]{panelKey});
            formView.setVisible(Boolean.TRUE, new String[]{panelKey + "empty"});
        }
    }

    public static void clearCacheByClosePage(ISWCAppCache appCache, String cacheKey) {
        appCache.remove(cacheKey);
    }

    public static void showEmptyPage(String panelKey, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hcdm_emptypage");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(panelKey);
        view.showForm(formShowParameter);
    }
}

