/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile.validator;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.LegalValidator;
import kd.swc.hcdm.common.entity.adjfile.AdjFileInfo;
import kd.swc.hcdm.common.enums.SalaryAdjFilePartEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class AdjFileDateValidator
extends LegalValidator<AdjFileInfo> {
    private static Log logger = LogFactory.getLog(AdjFileDateValidator.class);

    public AdjFileDateValidator(ValidateContext<AdjFileInfo> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateResult result = new ValidateResult(this.getLevel());
        ValidateContext context = this.getContext();
        AdjFileInfo data = (AdjFileInfo)context.getData();
        this.setDateIfNull(data);
        long fileId = data.getId();
        SalaryAdjFilePartEnum[] allFileParts = SalaryAdjFilePartEnum.values();
        ArrayList<AdjFileInfo> allInfos = new ArrayList<AdjFileInfo>(allFileParts.length);
        String selectFields = "bsed,bsled";
        for (SalaryAdjFilePartEnum filePart : allFileParts) {
            DynamicObject fileInfo = null;
            if (data.getAdjFilePart() == filePart) continue;
            if (filePart == SalaryAdjFilePartEnum.baseInfo) {
                fileInfo = SalaryAdjFileServiceHelper.queryFileDataByFileId(selectFields, fileId);
            }
            if (fileInfo == null) continue;
            AdjFileInfo partInfo = new AdjFileInfo();
            partInfo.setBsed(fileInfo.getDate("bsed"));
            partInfo.setBsled(fileInfo.getDate("bsled"));
            partInfo.setAdjFilePart(filePart);
            this.setDateIfNull(partInfo);
            allInfos.add(partInfo);
        }
        for (AdjFileInfo adjFileInfo : allInfos) {
            if (this.isOverlapping(data, adjFileInfo)) continue;
            result.addErrorMsg(this.getErrorMsg(adjFileInfo));
            return result;
        }
        return result;
    }

    private String getErrorMsg(AdjFileInfo adjFileInfo) {
        EnumMap<SalaryAdjFilePartEnum, String> msgMap = new EnumMap<SalaryAdjFilePartEnum, String>(SalaryAdjFilePartEnum.class);
        msgMap.put(SalaryAdjFilePartEnum.baseInfo, ResManager.loadKDString((String)"\u4e0d\u505a\u4fee\u6539", (String)"AdjFileDateValidator_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        msgMap.put(SalaryAdjFilePartEnum.decideSalaryInfo, ResManager.loadKDString((String)"\u4e0d\u505a\u4fee\u6539", (String)"AdjFileDateValidator_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        return (String)msgMap.get(adjFileInfo.getAdjFilePart());
    }

    private boolean isOverlapping(AdjFileInfo data, AdjFileInfo adjFileInfo) {
        Date bsed = data.getBsed();
        Date bsled = data.getBsled();
        Date bsed2 = adjFileInfo.getBsed();
        Date bsled2 = adjFileInfo.getBsled();
        return !bsed.after(bsled2) && !bsled.before(bsed2);
    }

    private void setDateIfNull(AdjFileInfo data) {
        Date bsed = data.getBsed();
        Date bsled = data.getBsled();
        if (bsed == null) {
            try {
                bsed = SWCDateTimeUtils.parseDate((String)"1900-01-01");
                data.setBsed(bsed);
            }
            catch (ParseException e) {
                logger.error("setBsedError: {}", (Object)e.getMessage());
            }
        }
        if (bsled == null) {
            try {
                bsled = SWCDateTimeUtils.parseDate((String)"2999-12-31");
                data.setBsled(bsled);
            }
            catch (ParseException e) {
                logger.error("setBsledError: {}", (Object)e.getMessage());
            }
        }
    }
}

