/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile.validator;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.LegalValidator;
import kd.swc.hcdm.common.entity.adjfile.AdjFileInfo;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class AdjFileRepeatValidator
extends LegalValidator<AdjFileInfo> {
    private static Log logger = LogFactory.getLog(AdjFileRepeatValidator.class);

    public AdjFileRepeatValidator(ValidateContext<AdjFileInfo> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateResult result = new ValidateResult(this.getLevel());
        ValidateContext context = this.getContext();
        AdjFileInfo data = (AdjFileInfo)context.getData();
        if (0L == data.getDepempId()) {
            return result;
        }
        Object[] dys = SalaryAdjFileServiceHelper.queryFileDataByDepempId("boid,person.name,employee.empnumber,number,bsed,bsled,status,iscurrentversion,datastatus", Sets.newHashSet((Object[])new Long[]{data.getDepempId()}));
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return result;
        }
        for (Object dy : dys) {
            Date newBsled;
            if (dy.getLong("boid") == data.getBoId()) continue;
            Date maxLoseEffectDate = SWCBaseUtils.getMaxLoseEffectDate();
            Date oldBsled = dy.getDate("bsled") == null ? maxLoseEffectDate : dy.getDate("bsled");
            Date oldBsed = dy.getDate("bsed");
            Date newBsed = data.getBsed();
            if (!SWCDateTimeUtils.isDateRangeOverlap((Date)newBsed, (Date)(newBsled = data.getBsled()), (Date)oldBsed, (Date)oldBsled)) continue;
            String bsedStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsed", (Date)dy.getDate("bsed"));
            String bsledStr = HRInteDateTimeUtil.formatDate((String)"hcdm_adjfileinfo", (String)"bsled", (Date)dy.getDate("bsled"));
            result.addErrorMsg(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5df2\u88ab\u5173\u8054\u5230\u5b9a\u8c03\u85aa\u6863\u6848{2}\u4e14\u751f\u5931\u6548\u65e5\u671f\u4e3a{3}\u81f3{4}\uff0c\u4e0d\u5141\u8bb8\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"AdjFileRepeatValidator_0", (String)"swc-hcdm-business", (Object[])new Object[0]), dy.getString("person.name"), dy.getString("employee.empnumber"), dy.getString("number"), bsedStr, bsledStr));
            return result;
        }
        return result;
    }
}

