/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjfile.validator;

import java.text.ParseException;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.LegalValidator;
import kd.swc.hcdm.common.entity.adjfile.AdjFileInfo;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class AdjFileSaveValidator
extends LegalValidator<AdjFileInfo> {
    private static Log logger = LogFactory.getLog(AdjFileSaveValidator.class);

    public AdjFileSaveValidator(ValidateContext<AdjFileInfo> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        boolean isExist;
        ValidateResult result = new ValidateResult(this.getLevel());
        ValidateContext context = this.getContext();
        AdjFileInfo data = (AdjFileInfo)context.getData();
        this.setIfNull(data);
        Date bsed = data.getBsed();
        Date bsled = data.getBsled();
        if (0L == data.getDepempId()) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u201c\u4eba\u5458\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjFileSaveValidator_2", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        if (!SWCDateTimeUtils.dayBefore((Date)bsed, (Date)bsled)) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"AdjFileSaveValidator_1", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        if (isExist = SalaryAdjFileServiceHelper.isExistAdjFile(data)) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u201c\u5b9a\u8c03\u85aa\u4eba\u5458\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u85aa\u916c\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u916c\u4f53\u7cfb\u201d\u7684\u5b9a\u8c03\u85aa\u6863\u6848\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"AdjFileSaveValidator_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
        return result;
    }

    private void setIfNull(AdjFileInfo data) {
        Date bsed = data.getBsed();
        Date bsled = data.getBsled();
        if (bsed == null) {
            try {
                bsed = SWCDateTimeUtils.parseDate((String)"1900-01-01");
                data.setBsed(bsed);
            }
            catch (ParseException e) {
                logger.error("setBsedError: {}", (Object)e.getMessage());
            }
        }
        if (bsled == null) {
            try {
                bsled = SWCDateTimeUtils.parseDate((String)"2999-12-31");
                data.setBsled(bsled);
            }
            catch (ParseException e) {
                logger.error("setBsledError:{}", (Object)e.getMessage());
            }
        }
    }
}

