/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hcdm.business.adjapprbill.enums.SynStatusEnum;
import kd.swc.hcdm.common.enums.AdjSalSynStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataSrcSystemEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.model.BaseResult;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class AdjSalarySynHelper {
    private static final Log LOGGER = LogFactory.getLog(AdjSalarySynHelper.class);
    public static final String OPSYSTEM = "hcdm";
    public static final String DATASOURCE = "2";
    private static Date defaultMaxDate;

    public static Map<String, Object> assembleAdjSalaryForAdd(DynamicObject syncRecord, DynamicObject[] synDetails) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)3);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(synDetails.length);
        paramMap.put("operate", "1");
        paramMap.put("opsystem", OPSYSTEM);
        paramMap.put("data", data);
        for (DynamicObject entity : synDetails) {
            data.add(AdjSalarySynHelper.convertAdjDynamicObjToMapForAdd(syncRecord, entity));
        }
        return paramMap;
    }

    public static Map<String, Object> assembleAdjSalaryForDel(DynamicObject syncRecord, DynamicObject[] synDetails) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)3);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(synDetails.length);
        paramMap.put("operate", "LDE");
        paramMap.put("opsystem", OPSYSTEM);
        paramMap.put("data", data);
        for (DynamicObject entity : synDetails) {
            data.add(AdjSalarySynHelper.convertAdjDynamicObjToMapForDel(syncRecord, entity));
        }
        return paramMap;
    }

    public static Map<String, Object> assembleAdjSalaryForExp(DynamicObject syncRecord, DynamicObject[] synDetails) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)3);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(synDetails.length);
        paramMap.put("opsystem", OPSYSTEM);
        paramMap.put("data", data);
        for (DynamicObject entity : synDetails) {
            data.add(AdjSalarySynHelper.convertAdjDynamicObjToMapForExp(syncRecord, entity));
        }
        return paramMap;
    }

    private static Map<String, Object> convertAdjDynamicObjToMapForAdd(DynamicObject syncRecord, DynamicObject syncDetail) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("bizdatacode", syncDetail.getString("bizdatacode"));
        map.put("bizitemid", syncDetail.getLong("bizitem.id"));
        if (syncDetail.getLong("bizitem.datatype.id") == DataTypeEnum.AMOUNT.getDbId()) {
            map.put("currencyid", syncDetail.getLong("currency.id"));
        }
        map.put("batchcode", syncDetail.getString("batchnumber"));
        map.put("datasources", DATASOURCE);
        map.put("srcsystem", BizDataSrcSystemEnum.HCDM.getCode());
        map.put("bsed", syncDetail.getDate("bsed"));
        Date bsled = syncDetail.getDate("bsled");
        if (SWCDateTimeUtils.dayEquals((Date)defaultMaxDate, (Date)bsled)) {
            bsled = null;
        }
        map.put("bsled", bsled);
        BigDecimal amount = syncDetail.getBigDecimal("amount");
        int amtPrecision = syncDetail.getInt("currency.amtprecision");
        amount = AdjSalarySynHelper.formatByCurrency(amtPrecision, amount);
        String encodeAmount = null == amount ? null : Encrypters.encode((String)amount.toPlainString());
        map.put("value", encodeAmount);
        map.put("depempid", syncDetail.getLong("depemp.id"));
        map.put("employeeid", syncDetail.getLong("depemp.employee.id"));
        map.put("calfrequencyid", syncDetail.getLong("frequency.id"));
        map.put("isencrypted", Boolean.TRUE);
        String fieldMappingValue = syncDetail.getString("fieldmappingvalue");
        if (!StringUtils.isEmpty((Object)fieldMappingValue)) {
            HashMap extraValue = (HashMap)SerializationUtils.fromJsonString((String)fieldMappingValue, HashMap.class);
            map.putAll(extraValue);
        }
        return map;
    }

    private static Map<String, Object> convertAdjDynamicObjToMapForDel(DynamicObject syncRecord, DynamicObject syncDetail) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("bizdatacode", syncDetail.getString("bizdatacode"));
        result.put("bizitemid", syncDetail.getLong("bizitem.id"));
        return result;
    }

    private static Map<String, Object> convertAdjDynamicObjToMapForExp(DynamicObject syncRecord, DynamicObject syncDetail) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("bizdatacode", syncDetail.getString("bizdatacode"));
        result.put("bizitemid", syncDetail.getLong("bizitem.id"));
        Date bsled = syncDetail.getDate("bsled");
        result.put("bsled", bsled);
        return result;
    }

    public static BigDecimal formatByCurrency(int amtprecision, BigDecimal amount) {
        if (null == amount) {
            return null;
        }
        return amount.setScale(amtprecision, 5);
    }

    public static DynamicObject[] querySynDetailByDetailIds(Set<Long> detailIds, QFilter qFilter) {
        QFilter synIdFilter = new QFilter("id", "in", detailIds);
        if (null != qFilter) {
            synIdFilter.and(qFilter);
        }
        QFilter[] qFilters = new QFilter[]{synIdFilter};
        String synDetailSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjsalsyndetail");
        return new SWCDataServiceHelper("hcdm_adjsalsyndetail").query(synDetailSelectProperties, qFilters);
    }

    public static boolean checkIsSynFailedData(Set<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter statusFilter = new QFilter("status", "=", (Object)SynStatusEnum.FAILED.getCode());
        SWCDataServiceHelper adjSalSynService = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
        QFilter[] filters = new QFilter[]{idFilter, statusFilter};
        int count = adjSalSynService.count(filters);
        return count > 0;
    }

    public static DynamicObject[] queryHrpiDepEmp(List<Long> depEmpIds) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hrpi_depemp");
        return service.query("id, person", new QFilter[]{new QFilter("id", "in", depEmpIds)});
    }

    public static DynamicObject[] queryWorkRoles(List<Long> roleIds) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hbpm_workroleshrallright");
        return service.query("id, name", new QFilter[]{new QFilter("id", "in", roleIds)});
    }

    public static DynamicObject queryAdjSalSynSet(Long pkValue) {
        SWCDataServiceHelper service = new SWCDataServiceHelper("hcdm_adjsalarysynset");
        QFilter adjSalSynSetFilter = new QFilter("id", "=", (Object)pkValue);
        return service.queryOne("id, entryentity, adjsalsynsetperson.personid, adjsalsynsetrole.roleid", new QFilter[]{adjSalSynSetFilter});
    }

    public static BaseResult<DynamicObject> hasBillPerm(Long pkId) {
        SWCDataServiceHelper serviceHelper;
        DynamicObject srcBill;
        String entityName;
        DynamicObject adjSalSyn = new SWCDataServiceHelper("hcdm_adjsalsyn").queryOriginalOne("datasource,srcbillid", (Object)pkId);
        if (adjSalSyn == null || adjSalSyn.getLong("srcbillid") == 0L) {
            return BaseResult.message((String)ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e0d\u53ef\u8bbf\u95ee", (String)"AdjSalSynListPlugin_1", (String)"swc-hcdm-formplugin", (Object[])new Object[0]), (int)400);
        }
        QFilter filter = new QFilter("id", "=", (Object)adjSalSyn.getLong("srcbillid"));
        String string = entityName = DATASOURCE.equals(adjSalSyn.getString("datasource")) ? "hcdm_singlecandsetsalappl" : "hcdm_adjapprbill";
        if (!SWCPermissionServiceHelper.isSuperUser()) {
            List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0VO5EV13=I9W", (String)entityName, (String)"47150e89000000ac");
            if (permissionFilter != null) {
                for (QFilter authFilter : permissionFilter) {
                    filter.and(authFilter);
                }
            } else {
                filter.and(new QFilter("1", "!=", (Object)1));
            }
            HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"28", (String)"0VO5EV13=I9W", (String)entityName, (String)"47150e89000000ac");
            if (!permOrgs.hasAllOrgPerm()) {
                List hasPermOrgs = permOrgs.getHasPermOrgs();
                QFilter qFilter = new QFilter("org", "in", (Object)hasPermOrgs);
                filter.and(qFilter);
            }
        }
        if ((srcBill = (serviceHelper = new SWCDataServiceHelper(entityName)).queryOne("id", new QFilter[]{filter})) == null) {
            return BaseResult.message((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6765\u6e90\u5355\u636e\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"AdjSalarySynHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]), (int)400);
        }
        return BaseResult.success((Object)serviceHelper.loadSingle((Object)srcBill.getLong("id")));
    }

    public static String getErrorDescByCode(String errCode) {
        String desc = BizDataFailStatusEnum.getDesc((String)errCode);
        if (null != desc) {
            return desc;
        }
        return AdjSalSynStatusEnum.getDesc((String)errCode);
    }

    static {
        try {
            defaultMaxDate = SWCDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException e) {
            LOGGER.error("error occurs when parse date", (Throwable)e);
        }
    }
}

