/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SalaryAdjFieldFactory {
    private static final Log LOGGER = LogFactory.getLog(SalaryAdjFieldFactory.class);

    public static DataTypeEnum dataTypeOf(String fieldGroup, String fieldNumber) {
        PropResult property = SalaryAdjFieldFactory.propertyOf(fieldGroup, fieldNumber, null);
        return property == null ? DataTypeEnum.NULL : DataTypeEnum.getDataType((IDataEntityProperty)property.getProperty());
    }

    public static List<Long> dataTypesOf(String fieldGroup, String fieldNumber) {
        PropResult property = SalaryAdjFieldFactory.propertyOf(fieldGroup, fieldNumber, null);
        if (property == null) {
            return Collections.singletonList(DataTypeEnum.NULL.getDbId());
        }
        DataTypeEnum dataType = DataTypeEnum.getDataType((IDataEntityProperty)property.getProperty());
        return dataType == DataTypeEnum.AMOUNT ? Arrays.asList(DataTypeEnum.AMOUNT.getDbId(), DataTypeEnum.NUMBERIC.getDbId()) : Collections.singletonList(dataType.getDbId());
    }

    public static Object valueOf(String fieldGroup, String fieldNumber, DynamicObject ... srcObjs) {
        Object value;
        if (ArrayUtils.isEmpty((Object[])srcObjs)) {
            return null;
        }
        DynamicObject src = null;
        for (DynamicObject srcObj : srcObjs) {
            if (srcObj == null || !SWCStringUtils.equals((String)srcObj.getDataEntityType().getName(), (String)fieldGroup)) continue;
            src = srcObj;
            break;
        }
        if (src == null) {
            return null;
        }
        PropResult propResult = SalaryAdjFieldFactory.propertyOf(fieldGroup, fieldNumber, src);
        if (propResult == null || (value = propResult.value()) == null) {
            return null;
        }
        IDataEntityProperty property = propResult.getProperty();
        if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!value.equals(comboItem.getValue())) continue;
                return comboItem.getName().toString();
            }
        }
        return value;
    }

    public static Long getIdOfBaseProp(DynamicObject object, String baseProp) {
        if (object == null || StringUtils.isBlank((CharSequence)baseProp)) {
            return 0L;
        }
        Object value = object.get(baseProp);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value == null) {
            return 0L;
        }
        throw new KDBizException("");
    }

    private static PropResult propertyOf(String fieldGroup, String fieldNumber, DynamicObject srcObj) {
        return SalaryAdjFieldFactory.propertyOf((IDataEntityType)EntityMetadataCache.getDataEntityType((String)fieldGroup), fieldNumber, srcObj);
    }

    private static PropResult propertyOf(IDataEntityType entityType, String fieldNumber, DynamicObject srcObj) {
        IDataEntityProperty property;
        String[] split = fieldNumber.split("\\.");
        if (split.length == 1) {
            property = (IDataEntityProperty)entityType.getProperties().get((Object)fieldNumber);
        } else {
            for (int i = 0; i < split.length - 1; ++i) {
                property = (IDataEntityProperty)entityType.getProperties().get((Object)split[i]);
                if (!(property instanceof BasedataProp)) {
                    return null;
                }
                if (srcObj != null) {
                    Object value = property.getValue((Object)srcObj);
                    if (value instanceof DynamicObject) {
                        srcObj = (DynamicObject)value;
                    } else {
                        srcObj = null;
                        LOGGER.info("Trace By Quinn: need DynamicObject, actual {}", value);
                    }
                }
                entityType = ((BasedataProp)property).getComplexType();
            }
            property = (IDataEntityProperty)entityType.getProperties().get((Object)split[split.length - 1]);
        }
        return new PropResult(property, entityType, srcObj);
    }

    public static class PropResult {
        private final IDataEntityProperty property;
        private final IDataEntityType entityType;
        private final Object srcObj;

        private PropResult(IDataEntityProperty property, IDataEntityType entityType, DynamicObject srcObj) {
            this.property = property;
            this.entityType = entityType;
            this.srcObj = srcObj;
        }

        public Object value() {
            return this.property == null || this.srcObj == null ? null : this.formatValue(this.property.getValue(this.srcObj), this.property);
        }

        public Object value(String propName) {
            if (this.entityType == null || this.srcObj == null) {
                return null;
            }
            if (this.srcObj instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)this.srcObj;
                return this.formatValue(obj.get(propName), (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)propName));
            }
            StringBuilder result = new StringBuilder();
            if (this.srcObj instanceof DynamicObjectCollection) {
                DynamicObjectCollection collection = (DynamicObjectCollection)this.srcObj;
                IDataEntityProperty prop = (IDataEntityProperty)collection.getDynamicObjectType().getProperties().get((Object)propName);
                for (DynamicObject object : collection) {
                    result.append(this.formatValue(object.get(propName), prop));
                }
            }
            return result.toString();
        }

        public Object formatValue(Object value, IDataEntityProperty property) {
            if (ObjectUtils.isEmpty((Object)value)) {
                return null;
            }
            if (property instanceof AmountProp) {
                AmountProp amountProp = (AmountProp)property;
                String controlPropName = amountProp.getControlPropName();
                DynamicObject currency = (DynamicObject)this.value(controlPropName);
                if (currency != null) {
                    value = ((BigDecimal)value).setScale(currency.getInt("amtprecision"), amountProp.getRoundingMode());
                }
            } else if (property instanceof DecimalProp) {
                DecimalProp decimalProp = (DecimalProp)property;
                LOGGER.info(" value is:{},decimalProp is:{}", value, (Object)decimalProp);
                value = ((BigDecimal)value).setScale(decimalProp.getScale(), decimalProp.getRoundingMode());
            } else if (property instanceof DateTimeProp) {
                Date date = (Date)value;
                String format = ((DateTimeProp)property).getDisplayFormatString();
                value = !StringUtils.isEmpty((CharSequence)format) ? SWCDateTimeUtils.format((Date)date, (String)format) : (property instanceof DateProp ? SWCDateTimeUtils.formatDate((Date)date) : SWCDateTimeUtils.format((Date)date));
            }
            return value;
        }

        public IDataEntityProperty getProperty() {
            return this.property;
        }

        public IDataEntityType getEntityType() {
            return this.entityType;
        }

        public Object getSrcObj() {
            return this.srcObj;
        }
    }
}

