/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncConstants;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncGenResult;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPushResult;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncPushService;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncGenEventAndBoIdServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncPushBatchNumberServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncPushBuAndCountryServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncPushEventServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncPushSyncDetailServiceImpl;
import kd.swc.hcdm.business.salaryadjsync.impl.SalaryAdjSyncPushSyncRecordServiceImpl;
import kd.swc.hcdm.common.constants.AdjSalSynConstants;
import kd.swc.hcdm.common.enums.AdjSalSynStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.model.BaseResult;
import kd.swc.hsbp.common.model.Message;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryAdjSyncFacade {
    private static final Log LOGGER = LogFactory.getLog(SalaryAdjSyncFacade.class);

    public static SalaryAdjSyncGenResult generateSyncData(Object event) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.generateSyncData start");
        return new SalaryAdjSyncGenEventAndBoIdServiceImpl(event, null).generateSyncData();
    }

    public static SalaryAdjSyncGenResult generateSyncDataFromBoId(Object event, List<Long> adjSalaryRecBoIds) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.generateSyncDataFromBoId start");
        return new SalaryAdjSyncGenEventAndBoIdServiceImpl(event, adjSalaryRecBoIds).generateSyncData();
    }

    public static SalaryAdjSyncGenResult generateSyncDataFromRec(Object event, List<DynamicObject> adjSalaryRecs, List<DynamicObject> relPersonDys) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.generateSyncDataFromBoId start");
        return SalaryAdjSyncGenEventAndBoIdServiceImpl.newInstance(event, adjSalaryRecs, relPersonDys).generateSyncData();
    }

    public static SalaryAdjSyncGenResult generateSyncDataFromAbandonBoId(Object event, Collection<Long> adjSalaryRecBoIds) {
        if (event != null && !"".equals(event) && !Long.valueOf(0L).equals(event)) {
            return SalaryAdjSyncFacade.generateSyncDataFromBoId(event, Lists.newArrayList(adjSalaryRecBoIds));
        }
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.generateSyncDataFromAbandonBoId start");
        String message = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5b9a\u8c03\u85aa\u4e8b\u4ef6\u3002", (String)"BaseSalaryAdjSyncGenServiceImpl_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        throw new KDBizException(message);
    }

    public static SalaryAdjSyncGenResult generateSyncDataFromExpireBoId(Object event, Collection<Long> adjSalaryRecBoIds, Date expireDate) {
        if (event != null && !"".equals(event) && !Long.valueOf(0L).equals(event)) {
            return SalaryAdjSyncFacade.generateSyncDataFromBoId(event, Lists.newArrayList(adjSalaryRecBoIds));
        }
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.generateSyncDataFromExpireBoId start");
        String message = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5b9a\u8c03\u85aa\u4e8b\u4ef6\u3002", (String)"BaseSalaryAdjSyncGenServiceImpl_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        throw new KDBizException(message);
    }

    public static SalaryAdjSyncPushResult triggerPushSyncData(Collection<?> events) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.triggerPushSyncData start");
        SalaryAdjSyncPushService service = SalaryAdjSyncPushEventServiceImpl.newInstance(events);
        if (service == null) {
            return new SalaryAdjSyncPushResult(Lists.newArrayList(), null);
        }
        return service.pushSyncData();
    }

    public static SalaryAdjSyncPushResult pushSyncData(Collection<?> events) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.pushSyncData start");
        SalaryAdjSyncPushService service = SalaryAdjSyncPushEventServiceImpl.newInstance(events, false);
        if (service == null) {
            return new SalaryAdjSyncPushResult(Lists.newArrayList(), null);
        }
        return service.pushSyncData();
    }

    public static SalaryAdjSyncPushResult pushSyncData(Object event) {
        return SalaryAdjSyncFacade.pushSyncData(Collections.singleton(event));
    }

    public static SalaryAdjSyncPushResult pushSyncData(List<Long> syncRecordIds) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.pushSyncData start");
        SalaryAdjSyncPushService service = SalaryAdjSyncPushBatchNumberServiceImpl.newInstance(syncRecordIds);
        if (service == null) {
            return new SalaryAdjSyncPushResult(Lists.newArrayList(), new Message("Parameter not correct", 400));
        }
        return service.pushSyncData();
    }

    public static SalaryAdjSyncPushResult pushSyncDataBySyncs(DynamicObject[] salaryAdjSyncs) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.pushSyncDataBySyncs start");
        Set synRecIds = Arrays.stream(salaryAdjSyncs).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] salarySyncs = new SWCDataServiceHelper("hcdm_adjsalsyn").query("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", new QFilter[]{new QFilter("id", "in", synRecIds)});
        DynamicObject[] syncDetails = new SWCDataServiceHelper("hcdm_adjsalsyndetail").query(SalaryAdjSyncConstants.SYNC_DETAIL_QUERY_PROPS, new QFilter[]{new QFilter("adjsalsyn", "in", synRecIds)});
        Map<Long, List<DynamicObject>> detailsOfSyn = Arrays.stream(syncDetails).collect(Collectors.groupingBy(ele -> ele.getLong("adjsalsyn")));
        List<DynamicObject> synRecList = SalaryAdjSyncFacade.dealBatchnumber(salarySyncs, detailsOfSyn);
        return new SalaryAdjSyncPushSyncRecordServiceImpl(synRecList.toArray(new DynamicObject[0])).pushSyncData();
    }

    public static SalaryAdjSyncPushResult pushSyncData(Long syncRecordId, List<Long> syncDetailIds) {
        HashMap syncDetailToBoIds;
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.pushSyncData start");
        if (syncDetailIds != null) {
            syncDetailToBoIds = Maps.newHashMapWithExpectedSize((int)syncDetailIds.size());
            for (Long syncDetailId : syncDetailIds) {
                syncDetailToBoIds.put(syncDetailId, 0L);
            }
        } else {
            syncDetailToBoIds = null;
        }
        return new SalaryAdjSyncPushSyncDetailServiceImpl(syncRecordId, (Map<Long, Long>)syncDetailToBoIds, null).pushSyncData();
    }

    public static SalaryAdjSyncPushResult pushSyncData(DynamicObject syncRecord, Collection<DynamicObject> syncDetails) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.pushSyncData start");
        Map<String, List<DynamicObject>> syncDetailToBoIdsOfTypes = syncDetails.stream().collect(Collectors.groupingBy(detail -> detail.getString("syntype")));
        SalaryAdjSyncPushResult result = new SalaryAdjSyncPushResult(Lists.newArrayListWithCapacity((int)syncDetails.size()), null);
        for (Map.Entry<String, List<DynamicObject>> entry : syncDetailToBoIdsOfTypes.entrySet()) {
            SalaryAdjSyncPushSyncDetailServiceImpl.subGroupPush(result, entry.getKey(), syncRecord, entry.getValue());
        }
        return result;
    }

    public static SalaryAdjSyncPushResult pushSyncDataByDetails(DynamicObject[] syncDetails) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.pushSyncDataByDetails start");
        Map<Long, List<DynamicObject>> detailsOfSyn = Arrays.stream(syncDetails).collect(Collectors.groupingBy(ele -> ele.getLong("adjsalsyn")));
        DynamicObject[] query = new SWCDataServiceHelper("hcdm_adjsalsyn").query("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", new QFilter[]{new QFilter("id", "in", detailsOfSyn.keySet())});
        DynamicObject[] allSyncDetails = new SWCDataServiceHelper("hcdm_adjsalsyndetail").query(SalaryAdjSyncConstants.SYNC_DETAIL_QUERY_PROPS, new QFilter[]{new QFilter("adjsalsyn", "in", detailsOfSyn.keySet())});
        Map<Long, List<DynamicObject>> allDetailsOfSyn = Arrays.stream(allSyncDetails).collect(Collectors.groupingBy(ele -> ele.getLong("adjsalsyn")));
        SalaryAdjSyncPushResult result = new SalaryAdjSyncPushResult(Lists.newArrayListWithCapacity((int)syncDetails.length), null);
        List<DynamicObject> synRecList = SalaryAdjSyncFacade.dealBatchnumber(query, allDetailsOfSyn);
        for (DynamicObject syncRecord : synRecList) {
            List<DynamicObject> details = detailsOfSyn.get(syncRecord.getLong("id"));
            result.merge(SalaryAdjSyncFacade.pushSyncData(syncRecord, details));
        }
        return result;
    }

    public static Map<String, Object> pushAdjSalSynRecord(Map<String, Object> params) {
        SalaryAdjSyncPushService pushService;
        HashMap result = Maps.newHashMap();
        result.put("success", false);
        result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u53c2\u7167\u63a5\u53e3\u6587\u6863\u8fdb\u884c\u8c03\u6574\u3002", (String)"SalaryAdjSyncFacade_0", (String)"swc-hcdm-business", (Object[])new Object[0]));
        if (params == null || params.isEmpty()) {
            return result;
        }
        String pushWay = MapUtils.getString(params, (Object)"pushWay");
        if ("BT".equals(pushWay)) {
            Object batchNumbers = params.get("batchNumbers");
            if (batchNumbers == null) {
                return result;
            }
            pushService = SalaryAdjSyncPushBatchNumberServiceImpl.newInstance(batchNumbers);
        } else if ("BU".equals(pushWay)) {
            Object orgs = params.get("orgs");
            if (orgs == null) {
                return result;
            }
            Object countries = params.get("countries");
            pushService = SalaryAdjSyncPushBuAndCountryServiceImpl.newInstance(orgs, countries);
        } else {
            Object events = params.get("events");
            if (events == null) {
                return result;
            }
            pushService = SalaryAdjSyncPushEventServiceImpl.newInstance(events, MapUtils.getBooleanValue(params, (Object)"isTrigger", (boolean)false));
        }
        if (pushService != null) {
            BaseResult<List<String>> baseResult = pushService.validateBefore();
            SWCThreadPoolFactory.getAsyncPushThreadpool().execute(pushService::pushSyncData);
            result.put("success", true);
            result.put("data", baseResult.getData());
            String message = baseResult.getMsg();
            if (CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                if (StringUtils.isEmpty((Object)message)) {
                    message = ResManager.loadKDString((String)"\u6839\u636e\u63a5\u53e3\u53c2\u6570\u6ca1\u6709\u627e\u5230\u5b9a\u8c03\u85aa\u540c\u6b65\u8bb0\u5f55\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"SalaryAdjSyncFacade_3", (String)"swc-hcdm-business", (Object[])new Object[0]);
                }
            } else {
                message = StringUtils.isEmpty((Object)message) ? ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u7cfb\u7edf\u5c06\u5bf9\u547d\u4e2d\u7684\u5b9a\u8c03\u85aa\u540c\u6b65\u8bb0\u5f55\u8fdb\u884c\u5f02\u6b65\u63a8\u9001\u3002", (String)"SalaryAdjSyncFacade_1", (String)"swc-hcdm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u7cfb\u7edf\u5c06\u5bf9\u547d\u4e2d\u7684\u5b9a\u8c03\u85aa\u540c\u6b65\u8bb0\u5f55\u8fdb\u884c\u5f02\u6b65\u63a8\u9001\uff0c\u4f46\u53c2\u6570\u5b58\u5728\u95ee\u9898\u5982\u4e0b\uff1a{0}", (String)"SalaryAdjSyncFacade_2", (String)"swc-hcdm-business", (Object[])new Object[]{message});
            }
            result.put("message", message);
        }
        return result;
    }

    public static void updateSyncRecStatus(long syncRecordId) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.updateSyncRecStatus start");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
        DynamicObject syncRecord = serviceHelper.queryOne("id,synstatus,modifier,syntime,successnum,failnum", (Object)syncRecordId);
        if (syncRecord == null) {
            return;
        }
        SalaryAdjSyncFacade.updateSyncRecStatus(serviceHelper, syncRecord);
    }

    public static void updateSyncRecStatus(SWCDataServiceHelper serviceHelper, DynamicObject syncRecord) {
        LOGGER.info("Trace By Quinn: SalaryAdjSyncFacade.updateSyncRecStatus start");
        try (DataSet countSet = new SWCDataServiceHelper("hcdm_adjsalsyndetail").queryDataSet("SalaryAdjSyncFacade.updateSyncRecStatus", "status", new QFilter[]{new QFilter("adjsalsyn", "=", (Object)syncRecord.getLong("id"))});
             DataSet taskCount = countSet.groupBy(new String[]{"status"}).count("num").finish();){
            int successNum = 0;
            int failNum = 0;
            int ingNum = 0;
            for (Row row : taskCount) {
                String status = row.getString("status");
                Integer num = row.getInteger("num");
                if (status == null || num == null) continue;
                switch (status) {
                    case "0": 
                    case "9": {
                        ingNum += num.intValue();
                        break;
                    }
                    case "1": {
                        failNum += num.intValue();
                        break;
                    }
                    case "3": {
                        successNum += num.intValue();
                        break;
                    }
                }
            }
            if (ingNum == 0) {
                syncRecord.set("synstatus", (Object)"1");
            } else if (successNum > 0 || failNum > 0) {
                syncRecord.set("synstatus", (Object)"0");
            }
            syncRecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
            syncRecord.set("syntime", (Object)new Date());
            syncRecord.set("successnum", (Object)successNum);
            syncRecord.set("failnum", (Object)failNum);
            serviceHelper.saveOne(syncRecord);
        }
    }

    private static List<DynamicObject> dealBatchnumber(DynamicObject[] salaryAdjSyncs, Map<Long, List<DynamicObject>> detailsOfSyn) {
        ArrayList hasNumberSynRecList = Lists.newArrayListWithExpectedSize((int)salaryAdjSyncs.length);
        ArrayList noBatchNumbersDys = Lists.newArrayListWithExpectedSize((int)salaryAdjSyncs.length);
        for (DynamicObject synRecDys : salaryAdjSyncs) {
            String errormsg = synRecDys.getString("errormsg");
            if (AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode().equals(errormsg) || AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode().equals(errormsg)) {
                noBatchNumbersDys.add(synRecDys);
                continue;
            }
            hasNumberSynRecList.add(synRecDys);
        }
        ArrayList updateSynDteailList = Lists.newArrayListWithExpectedSize((int)10);
        if (!CollectionUtils.isEmpty((Collection)noBatchNumbersDys)) {
            int i;
            try {
                List numbers = CodeRuleServiceHelper.getNumbers((String)"hcdm_adjsalsyn", (List)noBatchNumbersDys);
                for (i = 0; i < noBatchNumbersDys.size(); ++i) {
                    String number = (String)numbers.get(i);
                    DynamicObject syncRec = (DynamicObject)noBatchNumbersDys.get(i);
                    String batchNumber = SWCStringUtils.isEmpty((String)number) ? AdjSalSynConstants.BATCHNUMBER_FAILED() : (String)numbers.get(i);
                    syncRec.set("batchnumber", (Object)batchNumber);
                    syncRec.set("errormsg", null);
                    List<DynamicObject> synDetails = detailsOfSyn.get(syncRec.getLong("id"));
                    if (null == synDetails) continue;
                    for (DynamicObject syncDetail : synDetails) {
                        syncDetail.set("batchnumber", (Object)batchNumber);
                        if (SWCStringUtils.isEmpty((String)number)) {
                            syncRec.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode());
                            syncDetail.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4206.getCode());
                            continue;
                        }
                        updateSynDteailList.add(syncDetail);
                    }
                }
            }
            catch (KDException ex) {
                for (i = 0; i < noBatchNumbersDys.size(); ++i) {
                    DynamicObject syncRec = (DynamicObject)noBatchNumbersDys.get(i);
                    String batchNumber = AdjSalSynConstants.BATCHNUMBER_FAILED();
                    syncRec.set("batchnumber", (Object)batchNumber);
                    syncRec.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode());
                    List<DynamicObject> synDetails = detailsOfSyn.get(syncRec.getLong("id"));
                    for (DynamicObject syncDetail : synDetails) {
                        syncDetail.set("errormsg", (Object)AdjSalSynStatusEnum.HCDM_FAIL_STATUS_4207.getCode());
                    }
                }
            }
        }
        hasNumberSynRecList.addAll(noBatchNumbersDys);
        if (!CollectionUtils.isEmpty((Collection)updateSynDteailList)) {
            SWCDataServiceHelper detailServiceHelper = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
            detailServiceHelper.update(updateSynDteailList.toArray(new DynamicObject[0]));
        }
        return hasNumberSynRecList;
    }
}

