/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjEvent;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjFieldFactory;
import kd.swc.hsbp.common.model.BatchResult;
import kd.swc.hsbp.common.model.Message;

public class SalaryAdjSyncGenResult
extends BatchResult<DynamicObject> {
    private SalaryAdjEvent event;
    private final HashBasedTable<Long, Long, DynamicObject> adjSalarySynMap = HashBasedTable.create((int)32, (int)4);
    private final HashBasedTable<Long, Long, Message> messageOfOrgAndCountry = HashBasedTable.create((int)32, (int)4);
    private final Map<DynamicObject, List<DynamicObject>> adjSalarySynDetailsOfRec = Maps.newHashMapWithExpectedSize((int)64);

    public void merge(BatchResult<DynamicObject> result) {
        super.merge(result);
        if (!(result instanceof SalaryAdjSyncGenResult)) {
            return;
        }
        SalaryAdjSyncGenResult res = (SalaryAdjSyncGenResult)result;
        this.adjSalarySynMap.putAll(res.adjSalarySynMap);
        this.messageOfOrgAndCountry.putAll(res.messageOfOrgAndCountry);
        this.adjSalarySynDetailsOfRec.putAll(res.adjSalarySynDetailsOfRec);
    }

    public SalaryAdjSyncGenResult(List<DynamicObject> data, Message message) {
        super(data, message);
    }

    public DynamicObject getAdjSalarySyn(long orgId, long countryId) {
        return (DynamicObject)this.adjSalarySynMap.get((Object)orgId, (Object)countryId);
    }

    public void putAdjSalarySyn(long orgId, long countryId, DynamicObject adjSalarySyn) {
        this.adjSalarySynMap.put((Object)orgId, (Object)countryId, (Object)adjSalarySyn);
    }

    public Message getAdjSalarySynMessage(long orgId, long countryId) {
        return (Message)this.messageOfOrgAndCountry.get((Object)orgId, (Object)countryId);
    }

    public void putAdjSalarySynMessage(long orgId, long countryId, Message message) {
        this.messageOfOrgAndCountry.put((Object)orgId, (Object)countryId, (Object)message);
    }

    public void addAdjSalarySynDetail(DynamicObject adjSalarySyn, DynamicObject adjSalarySynDetail) {
        List adjSalarySynDetails = this.adjSalarySynDetailsOfRec.computeIfAbsent(adjSalarySyn, key -> Lists.newArrayListWithExpectedSize((int)this.adjSalarySynDetailsOfRec.size()));
        adjSalarySynDetails.add(adjSalarySynDetail);
    }

    public List<DynamicObject> allAdjSalarySyn() {
        return Lists.newArrayList((Iterable)this.adjSalarySynMap.values());
    }

    public List<DynamicObject> adjSalarySynDetailsOf(DynamicObject adjSalarySyn) {
        return this.adjSalarySynDetailsOfRec.get(adjSalarySyn);
    }

    public void replaceSync(DynamicObject newSyncRec, DynamicObject oldSyncRec) {
        this.adjSalarySynMap.put((Object)SalaryAdjFieldFactory.getIdOfBaseProp(newSyncRec, "org"), (Object)SalaryAdjFieldFactory.getIdOfBaseProp(newSyncRec, "country"), (Object)oldSyncRec);
        this.adjSalarySynDetailsOfRec.put(oldSyncRec, this.adjSalarySynDetailsOfRec.remove(newSyncRec));
    }

    public SalaryAdjEvent getEvent() {
        return this.event;
    }

    public void setEvent(SalaryAdjEvent event) {
        this.event = event;
    }
}

