/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hcdm.common.enums.AdjSalSynStatusEnum;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.model.BatchResult;
import kd.swc.hsbp.common.model.Message;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryAdjSyncPushResult
extends BatchResult<Long> {
    private List<DynamicObject> syncDetails;
    private Map<String, DynamicObject> detailsOfBizCode;

    public SalaryAdjSyncPushResult(List<Long> data, Message message) {
        super(data, message);
    }

    public boolean hasFailMsg() {
        return this.detailsOfBizCode != null && !this.detailsOfBizCode.isEmpty();
    }

    public void merge(BatchResult<Long> result) {
        super.merge(result);
        if (!(result instanceof SalaryAdjSyncPushResult)) {
            return;
        }
        SalaryAdjSyncPushResult pushRes = (SalaryAdjSyncPushResult)result;
        if (pushRes.syncDetails == null) {
            return;
        }
        if (this.syncDetails == null) {
            this.syncDetails = Lists.newArrayList(pushRes.syncDetails);
            this.detailsOfBizCode = Maps.newHashMap(pushRes.detailsOfBizCode);
        } else {
            this.syncDetails.addAll(pushRes.syncDetails);
            this.detailsOfBizCode.putAll(pushRes.detailsOfBizCode);
        }
    }

    public void setMessage(Message message) {
        super.setMessage(message);
        if (message != null && !CollectionUtils.isEmpty(this.syncDetails)) {
            for (DynamicObject detail : this.syncDetails) {
                long detailId = detail.getLong("id");
                Message msg = this.bizMsg(detailId);
                if (msg != null && message.getStatus() <= msg.getStatus()) continue;
                this.bizMsg(detailId, message);
            }
        }
    }

    public void mergeRpcRes(Map<String, Object> rpcRes) {
        if (this.syncDetails == null) {
            return;
        }
        boolean success = MapUtils.getBooleanValue(rpcRes, (Object)"success", (boolean)false);
        if (!success) {
            String message = MapUtils.getString(rpcRes, (Object)"message", (String)BizDataFailStatusEnum.FAILSTATUS_0.getCode());
            Message messageObj = new Message(message, 400);
            for (DynamicObject syncDetail : this.syncDetails) {
                long detailId = syncDetail.getLong("id");
                Message msg = this.bizMsg(detailId);
                if (msg != null) continue;
                this.bizMsg(detailId, messageObj);
            }
            return;
        }
        List result = (List)rpcRes.get("result");
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        for (Map map : result) {
            DynamicObject detail = this.detailsOfBizCode.get(MapUtils.getString((Map)map, (Object)"bizdatacode"));
            if (detail == null) continue;
            long id = detail.getLong("id");
            if ("1".equals(MapUtils.getString((Map)map, (Object)"status"))) {
                this.bizMsg(id, null);
                continue;
            }
            this.bizMsg(id, new Message(MapUtils.getString((Map)map, (Object)"errorcode"), 400));
        }
    }

    public List<DynamicObject> detailsWithStatus() {
        if (CollectionUtils.isEmpty(this.syncDetails)) {
            return this.syncDetails;
        }
        for (DynamicObject detail : this.syncDetails) {
            if ("3".equals(detail.get("status"))) continue;
            long id = detail.getLong("id");
            Message message = this.bizMsg(id);
            if (message != null) {
                if (message.isSuccess()) {
                    detail.set("status", (Object)"3");
                } else {
                    detail.set("status", (Object)"1");
                }
                detail.set("errormsg", (Object)message.getMsg());
                if (AdjSalSynStatusEnum.HCDM_FAIL_STATUS_1002.getCode().equals(message.getMsg())) continue;
                String errorDesc = AdjSalarySynHelper.getErrorDescByCode(message.getMsg());
                detail.set("errormessage", (Object)errorDesc);
                continue;
            }
            detail.set("status", (Object)"3");
            detail.set("errormsg", (Object)"");
            detail.set("errormessage", (Object)"");
        }
        return this.syncDetails;
    }

    public void addSyncDetails(DynamicObject[] syncDetails) {
        this.addSyncDetails(syncDetails, null);
    }

    public void addSyncDetails(DynamicObject[] syncDetails, Message message) {
        block6: {
            if (syncDetails == null) break block6;
            if (this.syncDetails == null) {
                this.syncDetails = Lists.newArrayList((Object[])syncDetails);
                this.detailsOfBizCode = Maps.newHashMapWithExpectedSize((int)syncDetails.length);
            } else {
                this.syncDetails.addAll(Lists.newArrayList((Object[])syncDetails));
            }
            if (message != null) {
                for (DynamicObject detail : syncDetails) {
                    this.detailsOfBizCode.put(detail.getString("bizdatacode"), detail);
                    this.bizMsg(detail.getLong("id"), message);
                }
            } else {
                for (DynamicObject detail : syncDetails) {
                    this.detailsOfBizCode.put(detail.getString("bizdatacode"), detail);
                }
            }
        }
    }

    public void addSyncDetailsWith(DynamicObject[] syncDetails, Message message, Map<Long, String> employeErrMap) {
        block6: {
            if (syncDetails == null) break block6;
            if (this.syncDetails == null) {
                this.syncDetails = Lists.newArrayList((Object[])syncDetails);
                this.detailsOfBizCode = Maps.newHashMapWithExpectedSize((int)syncDetails.length);
            } else {
                this.syncDetails.addAll(Lists.newArrayList((Object[])syncDetails));
            }
            if (message != null) {
                for (DynamicObject detail : syncDetails) {
                    this.detailsOfBizCode.put(detail.getString("bizdatacode"), detail);
                    long employeeId = detail.getLong("employee.id");
                    detail.set("errormessage", (Object)employeErrMap.get(employeeId));
                    this.bizMsg(detail.getLong("id"), message);
                }
            } else {
                for (DynamicObject detail : syncDetails) {
                    this.detailsOfBizCode.put(detail.getString("bizdatacode"), detail);
                }
            }
        }
    }
}

