/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salaryadjsync;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.xdb.util.Pair;

public class SalaryAdjSyncSet {
    private final DynamicObject srcEntity;
    private final Map<Long, Long> bizOfSalaryStdItem;
    private final Map<Long, List<Long>> propIdsOfBizItem;
    private final Map<Long, Pair<String, String>> valueFetchOfProp;

    public SalaryAdjSyncSet(DynamicObject srcEntity) {
        this.srcEntity = srcEntity;
        DynamicObjectCollection itemEntity = srcEntity.getDynamicObjectCollection("entryentity");
        this.bizOfSalaryStdItem = Maps.newHashMapWithExpectedSize((int)itemEntity.size());
        this.propIdsOfBizItem = Maps.newHashMapWithExpectedSize((int)itemEntity.size());
        for (DynamicObject item : itemEntity) {
            DynamicObjectCollection collection;
            long bizItemId = item.getLong("bizitem.id");
            this.bizOfSalaryStdItem.put(item.getLong("salarystditem.id"), bizItemId);
            DynamicObject bizItem = item.getDynamicObject("bizitem");
            if (bizItem == null || CollectionUtils.isEmpty((Collection)(collection = bizItem.getDynamicObjectCollection("bizitempropentry")))) continue;
            List props = collection.stream().map(ele -> ele.getLong("bizitemprop.id")).collect(Collectors.toList());
            this.propIdsOfBizItem.put(bizItemId, props);
        }
        DynamicObjectCollection fieldEntry = srcEntity.getDynamicObjectCollection("fieldentry");
        this.valueFetchOfProp = Maps.newHashMapWithExpectedSize((int)fieldEntry.size());
        for (DynamicObject field : fieldEntry) {
            this.valueFetchOfProp.put(field.getLong("bizitemprop.id"), (Pair<String, String>)new Pair((Object)field.getString("salaryadjfield.number"), (Object)field.getString("salaryadjfield.group.number")));
        }
    }

    public Long getLong(String propName) {
        return this.srcEntity.getLong(propName);
    }

    public String getString(String propName) {
        return this.srcEntity.getString(propName);
    }

    public Object get(String propName) {
        return this.srcEntity.get(propName);
    }

    public Long bizItemIdOfStdId(Long salaryStdItemId) {
        return this.bizOfSalaryStdItem.get(salaryStdItemId);
    }

    public List<Long> propsOfBizItem(Long bizItemId) {
        return this.propIdsOfBizItem.get(bizItemId);
    }

    public Pair<String, String> valueFetchOfProp(Long propId) {
        return this.valueFetchOfProp.get(propId);
    }

    public Map<Long, Pair<String, String>> getValueFetchOfProp() {
        return this.valueFetchOfProp;
    }

    public DynamicObject getSrcEntity() {
        return this.srcEntity;
    }
}

